/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.InvalidUtfException;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteBuffer {
    public byte[] elems;
    public int length;

    public ByteBuffer() {
        this(64);
    }

    public ByteBuffer(int initialSize) {
        this(new byte[initialSize]);
    }

    public ByteBuffer(byte[] elems) {
        this.elems = elems;
    }

    public void appendByte(int b) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length);
        this.elems[this.length++] = (byte)b;
    }

    public void appendBytes(byte[] bs, int start, int len) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + len);
        System.arraycopy(bs, start, this.elems, this.length, len);
        this.length += len;
    }

    public void appendBytes(byte[] bs) {
        this.appendBytes(bs, 0, bs.length);
    }

    public void appendChar(int x) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + 1);
        this.elems[this.length] = (byte)(x >> 8 & 0xFF);
        this.elems[this.length + 1] = (byte)(x & 0xFF);
        this.length += 2;
    }

    public void appendInt(int x) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + 3);
        this.elems[this.length] = (byte)(x >> 24 & 0xFF);
        this.elems[this.length + 1] = (byte)(x >> 16 & 0xFF);
        this.elems[this.length + 2] = (byte)(x >> 8 & 0xFF);
        this.elems[this.length + 3] = (byte)(x & 0xFF);
        this.length += 4;
    }

    public void appendLong(long x) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(8);
        DataOutputStream bufout = new DataOutputStream(buffer);
        try {
            bufout.writeLong(x);
            this.appendBytes(buffer.toByteArray(), 0, 8);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendFloat(float x) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(4);
        DataOutputStream bufout = new DataOutputStream(buffer);
        try {
            bufout.writeFloat(x);
            this.appendBytes(buffer.toByteArray(), 0, 4);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendDouble(double x) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(8);
        DataOutputStream bufout = new DataOutputStream(buffer);
        try {
            bufout.writeDouble(x);
            this.appendBytes(buffer.toByteArray(), 0, 8);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendName(Name name) {
        int utf8len = name.getUtf8Length();
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + utf8len);
        name.getUtf8Bytes(this.elems, this.length);
        this.length += utf8len;
    }

    public void appendStream(InputStream input) throws IOException {
        while (true) {
            int amountToRead = Math.max(input.available(), 64);
            this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + amountToRead);
            int amountRead = input.read(this.elems, this.length, amountToRead);
            if (amountRead == -1) break;
            this.length += amountRead;
            if (amountRead != amountToRead) continue;
            int byt = input.read();
            if (byt == -1) break;
            this.elems[this.length++] = (byte)byt;
        }
    }

    public int getInt(int bp) throws UnderflowException {
        this.verifyRange(bp, 4);
        return ((this.elems[bp] & 0xFF) << 24) + ((this.elems[bp + 1] & 0xFF) << 16) + ((this.elems[bp + 2] & 0xFF) << 8) + (this.elems[bp + 3] & 0xFF);
    }

    public long getLong(int bp) throws UnderflowException {
        this.verifyRange(bp, 8);
        DataInputStream elemsin = new DataInputStream(new ByteArrayInputStream(this.elems, bp, 8));
        try {
            return elemsin.readLong();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public float getFloat(int bp) throws UnderflowException {
        this.verifyRange(bp, 4);
        DataInputStream elemsin = new DataInputStream(new ByteArrayInputStream(this.elems, bp, 4));
        try {
            return elemsin.readFloat();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public double getDouble(int bp) throws UnderflowException {
        this.verifyRange(bp, 8);
        DataInputStream elemsin = new DataInputStream(new ByteArrayInputStream(this.elems, bp, 8));
        try {
            return elemsin.readDouble();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public char getChar(int bp) throws UnderflowException {
        this.verifyRange(bp, 2);
        return (char)(((this.elems[bp] & 0xFF) << 8) + (this.elems[bp + 1] & 0xFF));
    }

    public byte getByte(int bp) throws UnderflowException {
        this.verifyRange(bp, 1);
        return this.elems[bp];
    }

    public void reset() {
        this.length = 0;
    }

    public Name toName(Names names) throws InvalidUtfException {
        return names.fromUtf(this.elems, 0, this.length, Convert.Validation.STRICT);
    }

    public void verifyRange(int off, int len) throws UnderflowException {
        if (off < 0 || len < 0) {
            throw new IllegalArgumentException("off=" + off + ", len=" + len);
        }
        if (off + len < 0 || off + len > this.length) {
            throw new UnderflowException(this.length);
        }
    }

    public java.nio.ByteBuffer asByteBuffer() {
        return java.nio.ByteBuffer.wrap(this.elems, 0, this.length);
    }

    public static class UnderflowException
    extends Exception {
        private static final long serialVersionUID = 0L;
        private final int length;

        public UnderflowException(int length) {
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }
    }
}

