/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.formatter;

import aQute.lib.date.Dates;
import java.time.ZonedDateTime;
import java.util.Formatter;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Formatters {
    private static final Pattern PRINTF_P = Pattern.compile("%((?<index>\\d+)\\$|(?<previous><))?(-|\\+|0|\\(|,|\\^|#| )*(\\d*)?(\\.(\\d+))?(?<conversion>a|A|b|B|c|C|d|e|E|f|g|G|h|H|n|o|s|S|x|X|(?:[tT][HIklMSLNpzZsQBbhAaCYyjmdeRTrDFc])|%)");

    public static String format(String format, Function<String, Boolean> isTruthy, int offset, String ... args) {
        Object[] formatArgs = new Object[args.length - offset + 10];
        Matcher m = PRINTF_P.matcher(format);
        int automatic = offset;
        while (m.find()) {
            int index;
            char conversion = m.group("conversion").charAt(0);
            if (conversion == 'n' || conversion == '%') continue;
            String indexString = m.group("index");
            if (indexString != null) {
                index = Integer.parseInt(indexString) + offset - 1;
            } else {
                String previousString = m.group("previous");
                if (previousString != null) continue;
                index = automatic++;
            }
            switch (conversion) {
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    formatArgs[index - offset] = Long.parseLong(args[index]);
                    break;
                }
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    formatArgs[index - offset] = Double.parseDouble(args[index]);
                    break;
                }
                case 'C': 
                case 'c': {
                    if (args[index].length() == 1) {
                        formatArgs[index - offset] = Character.valueOf(args[index].charAt(0));
                        break;
                    }
                    try {
                        int parseInt = Integer.parseInt(args[index]);
                        formatArgs[index - offset] = parseInt;
                        break;
                    }
                    catch (NumberFormatException ne) {
                        throw new IllegalArgumentException("Character expected but found '" + args[index] + "'");
                    }
                }
                case 'B': 
                case 'b': {
                    String v = args[index].toLowerCase();
                    formatArgs[index - offset] = isTruthy.apply(v);
                    break;
                }
                case 'H': 
                case 'S': 
                case 'h': 
                case 's': {
                    formatArgs[index - offset] = args[index];
                    break;
                }
                case 'T': 
                case 't': {
                    String inputDate = args[index];
                    ZonedDateTime date = Dates.parse(inputDate);
                    if (date == null) {
                        throw new IllegalArgumentException("Illegal Date Format " + inputDate);
                    }
                    formatArgs[index - offset] = date;
                }
            }
        }
        try (Formatter f = new Formatter(Locale.ROOT);){
            f.format(format, formatArgs);
            String string = f.toString();
            return string;
        }
    }

    public static String format(String format, String ... args) {
        return Formatters.format(format, Formatters::isTruthy, 0, args);
    }

    private static boolean isTruthy(String arg) {
        if (arg == null) {
            return false;
        }
        if (arg.isEmpty()) {
            return false;
        }
        if ("false".equalsIgnoreCase(arg)) {
            return false;
        }
        if ("0".equals(arg)) {
            return false;
        }
        return !"(+|-)?0.0[DFdf]?".matches(arg);
    }
}

