/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.security.SecureRandom;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.KeyToken;
import org.eclipse.californium.core.network.TokenGenerator;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomTokenGenerator
implements TokenGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomTokenGenerator.class);
    private final int tokenSize;
    private final SecureRandom rng;

    public RandomTokenGenerator(Configuration config) {
        if (config == null) {
            throw new NullPointerException("NetworkConfig must not be null");
        }
        this.rng = new SecureRandom();
        this.rng.nextInt(10);
        this.tokenSize = (Integer)config.get((BasicDefinition)CoapConfig.TOKEN_SIZE_LIMIT);
        LOGGER.info("using tokens of {} bytes in length", (Object)this.tokenSize);
    }

    @Override
    public Token createToken(TokenGenerator.Scope scope) {
        byte[] token = new byte[this.tokenSize];
        this.rng.nextBytes(token);
        switch (scope) {
            case LONG_TERM: {
                token[0] = (byte)(token[0] | 1);
                break;
            }
            case SHORT_TERM: {
                token[0] = (byte)(token[0] & 0xFC);
                token[0] = (byte)(token[0] | 2);
                break;
            }
            case SHORT_TERM_CLIENT_LOCAL: {
                token[0] = (byte)(token[0] & 0xFC);
            }
        }
        return Token.fromProvider(token);
    }

    @Override
    public TokenGenerator.Scope getScope(Token token) {
        if (token.length() != this.tokenSize) {
            return TokenGenerator.Scope.SHORT_TERM_CLIENT_LOCAL;
        }
        int scope = token.getBytes()[0] & 3;
        switch (scope) {
            case 0: {
                return TokenGenerator.Scope.SHORT_TERM_CLIENT_LOCAL;
            }
            case 2: {
                return TokenGenerator.Scope.SHORT_TERM;
            }
        }
        return TokenGenerator.Scope.LONG_TERM;
    }

    @Override
    public KeyToken getKeyToken(Token token, Object peer) {
        if (this.getScope(token) == TokenGenerator.Scope.SHORT_TERM_CLIENT_LOCAL) {
            if (peer == null) {
                throw new IllegalArgumentException("client-local token requires peer!");
            }
            return new KeyToken(token, peer);
        }
        return new KeyToken(token, null);
    }
}

