/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UIComponent {
    String component;
    Map<String, Object> config;
    Map<String, List<UIComponent>> slots = null;

    public UIComponent() {
    }

    public UIComponent(String componentType) {
        this.component = componentType;
        this.config = new HashMap<String, Object>();
    }

    public String getType() {
        return this.component;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public void addConfig(String key, Object value) {
        this.config.put(key, value);
    }

    public Map<String, List<UIComponent>> getSlots() {
        return this.slots;
    }

    public void setSlots(Map<String, List<UIComponent>> slots) {
        this.slots = slots;
    }

    public List<UIComponent> addSlot(String slotName) {
        if (this.slots == null) {
            this.slots = new HashMap<String, List<UIComponent>>();
        }
        ArrayList<UIComponent> newSlot = new ArrayList<UIComponent>();
        this.slots.put(slotName, newSlot);
        return newSlot;
    }

    public List<UIComponent> getSlot(String slotName) {
        return this.slots.get(slotName);
    }

    public void addComponent(String slotName, UIComponent subComponent) {
        List<UIComponent> slot = this.slots == null || !this.slots.containsKey(slotName) ? this.addSlot(slotName) : this.getSlot(slotName);
        slot.add(subComponent);
    }
}

