/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.dependency;

import com.projectlibre1.association.AssociationList;
import com.projectlibre1.functor.CollectionVisitor;
import com.projectlibre1.pm.calendar.HasCalendar;
import com.projectlibre1.pm.dependency.HasDependencies;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.collections.Closure;

public class HasDependenciesImpl
implements HasDependencies,
Serializable {
    private HasCalendar hasCalendar;
    private transient AssociationList predecessors = new AssociationList();
    private transient AssociationList successors = new AssociationList();

    public HasDependenciesImpl(HasCalendar hasCalendar) {
        this.hasCalendar = hasCalendar;
    }

    @Override
    public AssociationList getPredecessorList() {
        return this.predecessors;
    }

    @Override
    public AssociationList getSuccessorList() {
        return this.successors;
    }

    public Closure forAllPredecessors(Closure closure) {
        return new CollectionVisitor(this, closure){

            @Override
            protected final Collection getCollection(Object object) {
                return ((HasDependencies)object).getPredecessorList().getList();
            }
        };
    }

    public Closure forAllSuccesssors(Closure closure) {
        return new CollectionVisitor(this, closure){

            @Override
            protected final Collection getCollection(Object object) {
                return ((HasDependencies)object).getSuccessorList().getList();
            }
        };
    }

    @Override
    public HasCalendar getHasCalendar() {
        return this.hasCalendar;
    }

    @Override
    public boolean dependsOn(HasDependencies hasDependencies) {
        System.out.println("error dependsOn should not be called on ScheduleWindowImpl");
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.predecessors = new AssociationList();
        this.successors = new AssociationList();
    }

    @Override
    public AssociationList getDependencyList(boolean bl) {
        return bl ? this.predecessors : this.successors;
    }
}

