/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.key.uniqueid;

import com.projectlibre1.pm.key.uniqueid.UniqueIdException;
import com.projectlibre1.pm.time.MutableInterval;
import com.projectlibre1.session.Session;
import com.projectlibre1.session.SessionFactory;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class UniqueIdPool {
    protected static int MIN_SIZE = 10;
    protected static int DEFAULT_SIZE = 500;
    protected static UniqueIdPool instance;
    protected List serverIntervals = new LinkedList();
    protected int reservationSem;
    protected long lastIdReservation = -1L;

    public static UniqueIdPool getInstance() {
        if (instance == null) {
            instance = new UniqueIdPool();
        }
        return instance;
    }

    protected UniqueIdPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getId(Session session) throws UniqueIdException {
        int n = this.getIdCount();
        if (this.serverIntervals.size() == 0) {
            try {
                this.makeServerReservationSync(n, session);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new UniqueIdException("Server exception");
            }
        }
        long l = -1L;
        int n2 = 0;
        List list = this.serverIntervals;
        synchronized (list) {
            Iterator iterator = this.serverIntervals.iterator();
            while (iterator.hasNext()) {
                MutableInterval mutableInterval = (MutableInterval)iterator.next();
                if (l == -1L) {
                    l = mutableInterval.getStart();
                    mutableInterval.setStart(l + 1L);
                    if (mutableInterval.getStart() > mutableInterval.getEnd()) {
                        iterator.remove();
                        continue;
                    }
                }
                n2 = (int)((long)n2 + (mutableInterval.getEnd() - mutableInterval.getStart() + 1L));
            }
        }
        if (n2 < this.getMinIdCount()) {
            this.makeServerReservationAsync(n - n2, session);
        }
        return l;
    }

    protected int getIdCount() {
        long l = System.currentTimeMillis();
        if (this.lastIdReservation != -1L && l - this.lastIdReservation < 10000L) {
            return DEFAULT_SIZE * 10;
        }
        return DEFAULT_SIZE;
    }

    protected int getMinIdCount() {
        return MIN_SIZE;
    }

    protected void makeServerReservationAsync(final int n, final Session session) {
        Thread thread = new Thread(this){
            final /* synthetic */ UniqueIdPool this$0;
            {
                this.this$0 = uniqueIdPool;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.this$0.reservationSem > 0) {
                        return;
                    }
                    ++this.this$0.reservationSem;
                }
                try {
                    this.this$0.makeServerReservation(n, session);
                }
                catch (Exception exception) {
                    System.out.println("Id cannot be retrieved: " + String.valueOf(exception));
                }
                finally {
                    1 var1_3 = this;
                    synchronized (var1_3) {
                        --this.this$0.reservationSem;
                    }
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeServerReservationSync(int n, Session session) throws Exception {
        UniqueIdPool uniqueIdPool = this;
        synchronized (uniqueIdPool) {
            ++this.reservationSem;
        }
        try {
            this.makeServerReservation(n, session);
        }
        finally {
            uniqueIdPool = this;
            synchronized (uniqueIdPool) {
                --this.reservationSem;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeServerReservation(int n, Session session) throws Exception {
        System.out.println("ID reservation...");
        this.lastIdReservation = System.currentTimeMillis();
        MutableInterval mutableInterval = (MutableInterval)SessionFactory.call(session, "bookUIDInterval", new Class[]{Integer.TYPE}, new Object[]{n});
        List list = this.serverIntervals;
        synchronized (list) {
            this.serverIntervals.add(mutableInterval);
        }
        System.out.println("ID reservation, new pool: " + this.dump());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        List list = this.serverIntervals;
        synchronized (list) {
            Iterator iterator = this.serverIntervals.iterator();
            while (iterator.hasNext()) {
                MutableInterval mutableInterval = (MutableInterval)iterator.next();
                stringBuffer.append('[').append(mutableInterval.getStart()).append(',').append(mutableInterval.getEnd()).append(']');
                if (!iterator.hasNext()) continue;
                stringBuffer.append(',');
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

