/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization;

import com.intellij.notebooks.ui.visualization.NotebookEditorAppearanceUtils;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.ui.cellsDnD.DropHighlightable;
import com.intellij.notebooks.visualization.ui.jupyterToolbars.JupyterAddNewCellToolbar;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u000eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/notebooks/visualization/NotebookBelowLastCellPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/notebooks/visualization/ui/cellsDnD/DropHighlightable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "isHighlighted", "", "addDropHighlight", "", "removeDropHighlight", "HighlightableTopBorder", "intellij.notebooks.visualization"})
public final class NotebookBelowLastCellPanel
extends JPanel
implements DropHighlightable {
    @NotNull
    private final EditorImpl editor;
    private boolean isHighlighted;

    public NotebookBelowLastCellPanel(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(new FlowLayout(1));
        this.editor = editor;
        if (NotebookEditorAppearanceUtils.INSTANCE.isOrdinaryNotebookEditor((Editor)this.editor)) {
            this.setOpaque(false);
            this.setBorder((Border)((Object)new HighlightableTopBorder(NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellBorderHeight())));
            AnAction anAction = ActionManager.getInstance().getAction("Jupyter.CreateNewCellsPanel");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            ActionGroup actionGroup = (ActionGroup)anAction;
            this.add((Component)((Object)new JupyterAddNewCellToolbar(actionGroup, this, null, null, 12, null)));
        }
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @Override
    public void addDropHighlight() {
        this.isHighlighted = true;
        this.repaint();
    }

    @Override
    public void removeDropHighlight() {
        this.isHighlighted = false;
        this.repaint();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/notebooks/visualization/NotebookBelowLastCellPanel$HighlightableTopBorder;", "Lcom/intellij/util/ui/JBEmptyBorder;", "borderHeight", "", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookBelowLastCellPanel;I)V", "paintBorder", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "width", "height", "intellij.notebooks.visualization"})
    private final class HighlightableTopBorder
    extends JBEmptyBorder {
        private final int borderHeight;

        public HighlightableTopBorder(int borderHeight) {
            super(borderHeight, 0, 0, 0);
            this.borderHeight = borderHeight;
        }

        public void paintBorder(@Nullable Component c, @NotNull Graphics g, int x, int y, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintBorder(c, g, x, y, width, height);
            if (NotebookBelowLastCellPanel.this.isHighlighted) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor((Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)NotebookBelowLastCellPanel.this.getEditor()).getCellStripeSelectedColor().get());
                int lineY = y + this.borderHeight / 2;
                g2d.fillRect(x, lineY - 1, width, 2);
            }
        }
    }
}

