/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.editor.settings.JupyterStructureShowPythonCellsMode;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterDisplayDataOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutput;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.jupyter.core.jupyter.structure.JupyterCellTitleInfo;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureItemPresentation;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewCellElement;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewModel;
import com.intellij.navigation.ItemPresentation;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 :2\u00020\u0001:\u0001:B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J(\u0010 \u001a\u001a\u0012\u0004\u0012\u00020\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020$0#0!2\u0006\u0010%\u001a\u00020$H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010%\u001a\u00020$H\u0002J&\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001a2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010+\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020$H\u0002J\u0010\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020\u0013H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020.0\u00192\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00105\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.H\u0002J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000209H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewRoot;", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "psiFile", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;", "model", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel;", "<init>", "(Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel;)V", "mdParser", "Lorg/intellij/markdown/parser/MarkdownParser;", "rootPresentation", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureItemPresentation;", "parentStack", "", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewCellElement;", "settings", "Lcom/intellij/jupyter/core/editor/settings/JupyterSettings;", "headingNumbers", "", "", "getChildren", "", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "()[Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "extractCellTitles", "", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterCellTitleInfo;", "cell", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "extractCodeCellTitles", "extractMarkdownCellTitles", "extractMarkdownOutputTitles", "findHtmlHeaders", "", "Lkotlin/ranges/IntRange;", "Lkotlin/Pair;", "", "text", "extractMarkdownTitlesFromMarkdownText", "addToStructure", "", "titleInfo", "rootChildren", "handleCodeCellStatus", "extractNodeText", "node", "Lorg/intellij/markdown/ast/ASTNode;", "contentText", "getHeadingNumber", "level", "collectTextNodes", "isMarkdownHeading", "", "getMarkdownTitleLevel", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getValue", "", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterStructureViewRoot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterStructureViewRoot.kt\ncom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewRoot\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1869#2,2:232\n1617#2,9:240\n1869#2:249\n1870#2:251\n1626#2:252\n1374#2:253\n1460#2,5:254\n1869#2,2:262\n774#2:264\n865#2,2:265\n1374#2:267\n1460#2,5:268\n774#2:273\n865#2,2:274\n1869#2,2:276\n1374#2:278\n1460#2,5:279\n774#2:284\n865#2:285\n2746#2,3:286\n866#2:289\n1869#2,2:290\n1869#2,2:292\n37#3:234\n36#3,3:235\n183#4,2:238\n1321#4:259\n1322#4:261\n1#5:250\n1#5:260\n*S KotlinDebug\n*F\n+ 1 JupyterStructureViewRoot.kt\ncom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewRoot\n*L\n43#1:232,2\n87#1:240,9\n87#1:249\n87#1:251\n87#1:252\n93#1:253\n93#1:254,5\n135#1:262,2\n180#1:264\n180#1:265,2\n181#1:267\n181#1:268,5\n191#1:273\n191#1:274,2\n191#1:276,2\n204#1:278\n204#1:279,5\n114#1:284\n114#1:285\n117#1:286,3\n114#1:289\n119#1:290,2\n131#1:292,2\n47#1:234\n47#1:235,3\n61#1:238,2\n99#1:259\n99#1:261\n87#1:250\n*E\n"})
public final class JupyterStructureViewRoot
implements StructureViewTreeElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JupyterFile psiFile;
    @NotNull
    private final JupyterStructureViewModel model;
    @NotNull
    private final MarkdownParser mdParser;
    @NotNull
    private final JupyterStructureItemPresentation rootPresentation;
    @NotNull
    private final List<JupyterStructureViewCellElement> parentStack;
    @NotNull
    private final JupyterSettings settings;
    @NotNull
    private final Map<Integer, Integer> headingNumbers;
    private static final int CODE_CELL_HEADING_LEVEL = 7;
    @NotNull
    private static final String CODE_CELL_HEADING_PREFIX = "# ";
    private static final int MAX_LABEL_LENGTH = 50;
    @NotNull
    private static final String TRUNCATION_SUFFIX = "...";
    @NotNull
    private static final Regex HTML_TAG_REGEX = new Regex("<[^>]*>");
    @NotNull
    private static final Regex MULTI_SPACE_REGEX = new Regex("\\s+");
    @NotNull
    private static final Map<IElementType, Integer> headingTypes;

    public JupyterStructureViewRoot(@NotNull JupyterFile psiFile, @NotNull JupyterStructureViewModel model) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.psiFile = psiFile;
        this.model = model;
        this.mdParser = new MarkdownParser((MarkdownFlavourDescriptor)new GFMFlavourDescriptor(false, false, false, 7, null));
        this.rootPresentation = new JupyterStructureItemPresentation(this.psiFile.getName(), null, null, 0);
        this.parentStack = new ArrayList();
        this.settings = JupyterSettings.Companion.getInstance();
        this.headingNumbers = new LinkedHashMap();
    }

    @NotNull
    public TreeElement[] getChildren() {
        Document document = this.psiFile.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        if (!NotebookCellLines.Companion.hasSupport(document)) {
            return new TreeElement[0];
        }
        Document document2 = this.psiFile.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getFileDocument(...)");
        List intervals = NotebookCellLines.Companion.get(document2).getIntervals();
        List rootChildren = new ArrayList();
        this.parentStack.clear();
        this.headingNumbers.clear();
        for (NotebookCellLines.Interval interval : intervals) {
            List<JupyterCellTitleInfo> titles = this.extractCellTitles(interval);
            Iterable $this$forEach$iv = titles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JupyterCellTitleInfo it = (JupyterCellTitleInfo)element$iv;
                boolean bl = false;
                this.addToStructure(interval, it, rootChildren);
            }
            if (JupyterCellLinesExtensionsKt.toJupyterCellType(interval.getType()) != JupyterCellType.CODE) continue;
            this.handleCodeCellStatus(interval);
        }
        Collection $this$toTypedArray$iv = rootChildren;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new TreeElement[0]);
    }

    private final List<JupyterCellTitleInfo> extractCellTitles(NotebookCellLines.Interval cell) {
        return switch (WhenMappings.$EnumSwitchMapping$0[JupyterCellLinesExtensionsKt.toJupyterCellType(cell.getType()).ordinal()]) {
            case 1 -> CollectionsKt.plus((Collection)this.extractCodeCellTitles(cell), (Iterable)this.extractMarkdownOutputTitles(cell));
            case 2 -> this.extractMarkdownCellTitles(cell);
            default -> CollectionsKt.emptyList();
        };
    }

    private final List<JupyterCellTitleInfo> extractCodeCellTitles(NotebookCellLines.Interval cell) {
        Object title;
        boolean includeCell;
        Object v2;
        block5: {
            if (!this.settings.getShowPythonCellsInStructure()) {
                return CollectionsKt.emptyList();
            }
            Document document = this.psiFile.getFileDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
            CharSequence source = cell.getContentText(document);
            Sequence $this$firstOrNull$iv = StringsKt.lineSequence((CharSequence)source);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        String string = v2;
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String firstNonEmptyLine = string;
        boolean hasCodeHeading = StringsKt.startsWith$default((String)firstNonEmptyLine, (String)CODE_CELL_HEADING_PREFIX, (boolean)false, (int)2, null);
        boolean bl = includeCell = this.settings.getShowPythonCellsInStructureMode() == JupyterStructureShowPythonCellsMode.ALL || this.settings.getShowPythonCellsInStructureMode() == JupyterStructureShowPythonCellsMode.STARTS_WITH_COMMENT && hasCodeHeading;
        if (!includeCell) {
            return CollectionsKt.emptyList();
        }
        Object object = title = hasCodeHeading ? ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)firstNonEmptyLine, (CharSequence)CODE_CELL_HEADING_PREFIX))).toString() : firstNonEmptyLine;
        if (((String)title).length() > 50) {
            title = StringsKt.take((String)title, (int)50) + TRUNCATION_SUFFIX;
        }
        String label = cell.getOrdinal() + 1 + ". " + (String)title;
        return CollectionsKt.listOf((Object)new JupyterCellTitleInfo(7, label, JupyterCellType.CODE, hasCodeHeading));
    }

    private final List<JupyterCellTitleInfo> extractMarkdownCellTitles(NotebookCellLines.Interval cell) {
        Document document = this.psiFile.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        String text = ((Object)cell.getContentText(document)).toString();
        return this.extractMarkdownTitlesFromMarkdownText(text);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JupyterCellTitleInfo> extractMarkdownOutputTitles(NotebookCellLines.Interval cell) {
        void $this$flatMapTo$iv$iv;
        Collection destination$iv$iv;
        JupyterCell jupyterCell = JupyterCellLinesExtensionsKt.toJupyterCell(cell, this.psiFile);
        if (jupyterCell == null) {
            return CollectionsKt.emptyList();
        }
        JupyterCell jupyterCell2 = jupyterCell;
        Object object = jupyterCell2.getOutputs();
        if (object != null && (object = object.getOutputs()) != null && (object = CollectionsKt.withIndex((Iterable)((Iterable)object))) != null) {
            void $this$mapNotNullTo$iv$iv;
            Object $this$mapNotNull$iv = object;
            boolean $i$f$mapNotNull = false;
            Object object2 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                IndexedValue indexedValue;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                IndexedValue indexedValue2 = (IndexedValue)element$iv$iv;
                boolean bl2 = false;
                int index = indexedValue2.component1();
                JupyterOutput value = (JupyterOutput)indexedValue2.component2();
                Object object3 = value instanceof JupyterDisplayDataOutput ? (JupyterDisplayDataOutput)value : null;
                if (object3 == null || (object3 = ((JupyterDisplayDataOutput)object3).getData()) == null || (object3 = object3.getAsString(MimeType.TEXT_MARKDOWN.getMimeType())) == null) {
                    indexedValue = null;
                } else {
                    Object markdownOutput = object3;
                    indexedValue = new IndexedValue(index, markdownOutput);
                }
                if (indexedValue == null) continue;
                IndexedValue it$iv$iv = indexedValue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
        } else {
            return CollectionsKt.emptyList();
        }
        List markdownOutputs = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = markdownOutputs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            destination$iv$iv = (IndexedValue)element$iv$iv;
            boolean bl = false;
            String markdownOutput = (String)destination$iv$iv.component2();
            Iterable list$iv$iv = this.extractMarkdownTitlesFromMarkdownText(markdownOutput);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private final Map<IntRange, Pair<Integer, String>> findHtmlHeaders(String text) {
        Map htmlHeaders = new LinkedHashMap();
        Regex htmlHeaderRegex = new Regex("<h([1-6])\\s*[^>]*>(.*?)</h\\1>", RegexOption.DOT_MATCHES_ALL);
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)htmlHeaderRegex, (CharSequence)text, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult matchResult = (MatchResult)element$iv;
            boolean bl = false;
            Integer n = StringsKt.toIntOrNull((String)((String)matchResult.getGroupValues().get(1)));
            if (n == null) continue;
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            boolean bl2 = false;
            n = (1 <= it ? it < 7 : false) ? n2 : null;
            if (n == null) {
                continue;
            }
            int level = n;
            CharSequence charSequence = (CharSequence)matchResult.getGroupValues().get(2);
            n2 = HTML_TAG_REGEX;
            String string = "";
            String titleText = ((Object)StringsKt.trim((CharSequence)n2.replace(charSequence, string))).toString();
            htmlHeaders.put(matchResult.getRange(), TuplesKt.to((Object)level, (Object)titleText));
        }
        return htmlHeaders;
    }

    private final List<JupyterCellTitleInfo> extractMarkdownTitlesFromMarkdownText(String text) {
        ASTNode parsedTree = MarkdownParser.parse$default((MarkdownParser)this.mdParser, (IElementType)new IElementType("ROOT"), (String)text, (boolean)false, (int)4, null);
        List titles = new ArrayList();
        Map htmlHeaders = MapsKt.toMutableMap(this.findHtmlHeaders(text));
        JupyterStructureViewRoot.extractMarkdownTitlesFromMarkdownText$walk(htmlHeaders, this, text, titles, parsedTree);
        Iterable $this$forEach$iv = htmlHeaders.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int level = ((Number)pair.component1()).intValue();
            String titleText = (String)pair.component2();
            titles.add(new JupyterCellTitleInfo(level, this.getHeadingNumber(level) + titleText, JupyterCellType.MARKDOWN, false, 8, null));
        }
        return titles;
    }

    private final void addToStructure(NotebookCellLines.Interval cell, JupyterCellTitleInfo titleInfo, List<JupyterStructureViewCellElement> rootChildren) {
        JupyterStructureViewCellElement structureViewElement = new JupyterStructureViewCellElement(cell, titleInfo.getTitle(), titleInfo.getLevel(), null, this.model, titleInfo.getCellType(), titleInfo.isCodeCellHeading());
        while (!((Collection)this.parentStack).isEmpty() && ((JupyterStructureViewCellElement)CollectionsKt.last(this.parentStack)).getLevel() >= titleInfo.getLevel()) {
            this.parentStack.remove(this.parentStack.size() - 1);
        }
        boolean bl = !((Collection)this.parentStack).isEmpty() ? ((JupyterStructureViewCellElement)CollectionsKt.last(this.parentStack)).addChild((TreeElement)structureViewElement) : rootChildren.add(structureViewElement);
        this.model.setIntervalToComponent(cell, structureViewElement);
        this.parentStack.add(structureViewElement);
    }

    private final void handleCodeCellStatus(NotebookCellLines.Interval cell) {
        JupyterStructureViewCellElement jupyterStructureViewCellElement = (JupyterStructureViewCellElement)CollectionsKt.lastOrNull(this.parentStack);
        if (jupyterStructureViewCellElement == null) {
            return;
        }
        JupyterStructureViewCellElement parentElement = jupyterStructureViewCellElement;
        parentElement.associateInterval(cell);
        this.model.setIntervalToComponent(cell, parentElement);
        parentElement.updateStatus(this.model.getCellStatus(cell.getOrdinal()));
    }

    /*
     * WARNING - void declaration
     */
    private final String extractNodeText(ASTNode node, String contentText) {
        void $this$flatMapTo$iv$iv;
        ASTNode it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = node.getChildren();
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getType().getName(), (Object)"ATX_HEADER"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.collectTextNodes(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        CharSequence charSequence = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, arg_0 -> JupyterStructureViewRoot.extractNodeText$lambda$13(contentText, arg_0), (int)30, null);
        Regex regex = HTML_TAG_REGEX;
        object = "";
        charSequence = regex.replace(charSequence, (String)object);
        regex = MULTI_SPACE_REGEX;
        object = " ";
        return ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, (String)object))).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String getHeadingNumber(int level) {
        void $this$filterTo$iv$iv;
        if (!this.settings.getShowHeadingNumbersInStructure()) {
            return "";
        }
        Iterable $this$filter$iv = this.headingNumbers.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(it > level)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.headingNumbers.remove(it);
        }
        this.headingNumbers.put(level, ((Number)this.headingNumbers.getOrDefault(level, 0)).intValue() + 1);
        for (int i = 1; i < level; ++i) {
            if (this.headingNumbers.containsKey(i)) continue;
            this.headingNumbers.put(i, 1);
        }
        return CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, level)), (CharSequence)".", null, null, (int)0, null, arg_0 -> JupyterStructureViewRoot.getHeadingNumber$lambda$16(this, arg_0), (int)30, null) + ". ";
    }

    /*
     * WARNING - void declaration
     */
    private final List<ASTNode> collectTextNodes(ASTNode node) {
        List list;
        if (node.getChildren().isEmpty()) {
            list = CollectionsKt.listOf((Object)node);
        } else {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = node.getChildren();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ASTNode it = (ASTNode)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.collectTextNodes(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private final boolean isMarkdownHeading(ASTNode node) {
        return headingTypes.containsKey(node.getType());
    }

    private final int getMarkdownTitleLevel(ASTNode node) {
        Integer n = headingTypes.get(node.getType());
        if (n == null) {
            throw new IllegalStateException("Node is not a heading".toString());
        }
        return n;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return (ItemPresentation)this.rootPresentation;
    }

    @NotNull
    public Object getValue() {
        String string = this.psiFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private static final void extractMarkdownTitlesFromMarkdownText$walk(Map<IntRange, Pair<Integer, String>> htmlHeaders, JupyterStructureViewRoot this$0, String $text, List<JupyterCellTitleInfo> titles, ASTNode node) {
        var5_5 = htmlHeaders.entrySet();
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var10_12 = $this$filterTo$iv$iv.iterator();
        while (var10_12.hasNext()) {
            block9: {
                element$iv$iv = var10_12.next();
                var12_16 = (Map.Entry)element$iv$iv;
                $i$a$-filter-JupyterStructureViewRoot$extractMarkdownTitlesFromMarkdownText$walk$1 = false;
                range = (IntRange)var12_16.getKey();
                if (range.getFirst() < node.getStartOffset() || range.getLast() > node.getEndOffset()) ** GOTO lbl-1000
                $this$none$iv = node.getChildren();
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    v0 = true;
                } else {
                    for (T element$iv : $this$none$iv) {
                        child = (ASTNode)element$iv;
                        $i$a$-none-JupyterStructureViewRoot$extractMarkdownTitlesFromMarkdownText$walk$1$1 = false;
                        if (!(range.getFirst() >= child.getStartOffset() && range.getLast() <= child.getEndOffset())) continue;
                        v0 = false;
                        break block9;
                    }
                    v0 = true;
                }
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            $i$f$filterTo = (Map.Entry)element$iv;
            $i$a$-forEach-JupyterStructureViewRoot$extractMarkdownTitlesFromMarkdownText$walk$2 = false;
            range = (IntRange)$i$f$filterTo.getKey();
            headerInfo = (Pair)$i$f$filterTo.getValue();
            level = ((Number)headerInfo.component1()).intValue();
            titleText = (String)headerInfo.component2();
            titles.add(new JupyterCellTitleInfo(level, this$0.getHeadingNumber(level) + titleText, JupyterCellType.MARKDOWN, false, 8, null));
            htmlHeaders.remove(range);
        }
        if (this$0.isMarkdownHeading(node)) {
            titleText = this$0.extractNodeText(node, $text);
            level = this$0.getMarkdownTitleLevel(node);
            headingNumber = this$0.getHeadingNumber(level);
            numberedTitle = headingNumber + titleText;
            titles.add(new JupyterCellTitleInfo(level, numberedTitle, JupyterCellType.MARKDOWN, false, 8, null));
        }
        $this$forEach$iv = node.getChildren();
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (ASTNode)element$iv;
            $i$a$-forEach-JupyterStructureViewRoot$extractMarkdownTitlesFromMarkdownText$walk$3 = false;
            JupyterStructureViewRoot.extractMarkdownTitlesFromMarkdownText$walk(htmlHeaders, this$0, $text, titles, it);
        }
    }

    private static final CharSequence extractNodeText$lambda$13(String $contentText, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ASTUtilKt.getTextInNode((ASTNode)it, (CharSequence)$contentText);
    }

    private static final CharSequence getHeadingNumber$lambda$16(JupyterStructureViewRoot this$0, int it) {
        Object object = this$0.headingNumbers.get(it);
        return object != null && (object = ((Integer)object).toString()) != null ? (CharSequence)object : (CharSequence)"0";
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MarkdownElementTypes.ATX_1, (Object)1), TuplesKt.to((Object)MarkdownElementTypes.ATX_2, (Object)2), TuplesKt.to((Object)MarkdownElementTypes.ATX_3, (Object)3), TuplesKt.to((Object)MarkdownElementTypes.ATX_4, (Object)4), TuplesKt.to((Object)MarkdownElementTypes.ATX_5, (Object)5), TuplesKt.to((Object)MarkdownElementTypes.ATX_6, (Object)6), TuplesKt.to((Object)MarkdownElementTypes.SETEXT_1, (Object)1), TuplesKt.to((Object)MarkdownElementTypes.SETEXT_2, (Object)2)};
        headingTypes = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewRoot$Companion;", "", "<init>", "()V", "CODE_CELL_HEADING_LEVEL", "", "CODE_CELL_HEADING_PREFIX", "", "MAX_LABEL_LENGTH", "TRUNCATION_SUFFIX", "HTML_TAG_REGEX", "Lkotlin/text/Regex;", "MULTI_SPACE_REGEX", "headingTypes", "", "Lorg/intellij/markdown/IElementType;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterCellType.values().length];
            try {
                nArray[JupyterCellType.CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterCellType.MARKDOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

