/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.SimpleTerminalController;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.ui.TerminalUi;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001&B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010 \u001a\u00020\rH\u0002J\u0006\u0010!\u001a\u00020\tJ\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/terminal/block/SimpleTerminalView;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "withVerticalScroll", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Z)V", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "controller", "Lorg/jetbrains/plugins/terminal/block/SimpleTerminalController;", "getController", "()Lorg/jetbrains/plugins/terminal/block/SimpleTerminalController;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "preferredFocusableComponent", "getPreferredFocusableComponent", "terminalWidth", "", "getTerminalWidth", "()I", "charSize", "Ljava/awt/geom/Dimension2D;", "getCharSize", "()Ljava/awt/geom/Dimension2D;", "createEditor", "isFocused", "getText", "", "dispose", "", "SimpleTerminalPanel", "intellij.terminal"})
public final class SimpleTerminalView
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    private final boolean withVerticalScroll;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final SimpleTerminalController controller;
    @NotNull
    private final JComponent component;

    public SimpleTerminalView(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull BlockTerminalSession session2, boolean withVerticalScroll) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.project = project;
        this.settings = settings;
        this.withVerticalScroll = withVerticalScroll;
        this.editor = this.createEditor();
        this.controller = new SimpleTerminalController(this.settings, session2, (EditorEx)this.editor);
        this.component = new SimpleTerminalPanel((Editor)this.editor);
        this.editor.addFocusListener(new FocusChangeListener(){

            public void focusGained(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.getController().setFocused(true);
            }

            public void focusLost(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.getController().setFocused(false);
            }
        });
    }

    public /* synthetic */ SimpleTerminalView(Project project, JBTerminalSystemSettingsProviderBase jBTerminalSystemSettingsProviderBase, BlockTerminalSession blockTerminalSession, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(project, jBTerminalSystemSettingsProviderBase, blockTerminalSession, bl);
    }

    @NotNull
    public final SimpleTerminalController getController() {
        return this.controller;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"getContentComponent(...)");
        return (JComponent)editorComponentImpl;
    }

    public final int getTerminalWidth() {
        Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        int scrollBarWidth = this.editor.getScrollPane().getVerticalScrollBar().getWidth();
        return visibleArea.width - scrollBarWidth;
    }

    @NotNull
    public final Dimension2D getCharSize() {
        return TerminalUiUtilsKt.getCharSize((Editor)this.editor);
    }

    private final EditorImpl createEditor() {
        DocumentImpl document = new DocumentImpl((CharSequence)"", true);
        EditorImpl editor = TerminalUiUtils.INSTANCE.createOutputEditor((Document)document, this.project, this.settings, true);
        TerminalUi.INSTANCE.useTerminalDefaultBackground((EditorEx)editor, this);
        editor.getSettings().setLineMarkerAreaShown(false);
        editor.getScrollPane().setVerticalScrollBarPolicy(this.withVerticalScroll ? 20 : 21);
        return editor;
    }

    public final boolean isFocused() {
        return this.editor.getContentComponent().hasFocus();
    }

    @NotNull
    public final CharSequence getText() {
        CharSequence charSequence = this.editor.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        return charSequence;
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor((Editor)this.editor);
        Disposer.dispose((Disposable)this.controller);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/terminal/block/SimpleTerminalView$SimpleTerminalPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/SimpleTerminalView;Lcom/intellij/openapi/editor/Editor;)V", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.terminal"})
    private final class SimpleTerminalPanel
    extends JPanel
    implements UiDataProvider {
        public SimpleTerminalPanel(Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.setBackground((Color)TerminalUi.INSTANCE.defaultBackground(editor));
            this.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
            this.setLayout(new BorderLayout());
            this.add((Component)editor.getComponent(), "Center");
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            DataKey dataKey = CommonDataKeys.EDITOR;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR");
            sink.set(dataKey, (Object)SimpleTerminalView.this.editor);
        }
    }
}

