/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt.error;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.ListLayout;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.prompt.error.TerminalPromptErrorDescription;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/error/TerminalPromptErrorUtil;", "", "<init>", "()V", "createErrorComponent", "Ljavax/swing/JComponent;", "description", "Lorg/jetbrains/plugins/terminal/block/prompt/error/TerminalPromptErrorDescription;", "colorScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "intellij.terminal"})
public final class TerminalPromptErrorUtil {
    @NotNull
    public static final TerminalPromptErrorUtil INSTANCE = new TerminalPromptErrorUtil();

    private TerminalPromptErrorUtil() {
    }

    @NotNull
    public final JComponent createErrorComponent(@NotNull TerminalPromptErrorDescription description, @NotNull EditorColorsScheme colorScheme) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        JPanel panel = new JPanel((LayoutManager)ListLayout.Companion.horizontal$default((ListLayout.Companion)ListLayout.Companion, (int)0, null, null, (int)7, null));
        panel.setBorder((Border)JBUI.Borders.emptyTop((int)4));
        panel.setOpaque(false);
        JBLabel errorLabel = new JBLabel(description.getErrorText());
        errorLabel.setCopyable(true);
        errorLabel.setIcon(description.getIcon());
        errorLabel.setIconTextGap(JBUI.scale((int)6));
        TextAttributes textAttributes = colorScheme.getAttributes(ConsoleViewContentType.ERROR_OUTPUT_KEY);
        errorLabel.setForeground(textAttributes != null ? textAttributes.getForegroundColor() : null);
        panel.add((Component)errorLabel);
        String linkText = description.getLinkText();
        if (linkText != null) {
            ActionLink linkLabel = new ActionLink(linkText, arg_0 -> TerminalPromptErrorUtil.createErrorComponent$lambda$0(description, arg_0));
            TextAttributes textAttributes2 = colorScheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR);
            linkLabel.setForeground(textAttributes2 != null ? textAttributes2.getForegroundColor() : null);
            linkLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
            panel.add((Component)linkLabel);
        }
        return panel;
    }

    private static final Unit createErrorComponent$lambda$0(TerminalPromptErrorDescription $description, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $description.onLinkClick();
        return Unit.INSTANCE;
    }
}

