/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryPaths;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.history.VcsLogFileRevision;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class FileHistoryModel {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogDiffHandler myDiffHandler;
    @NotNull
    private final VirtualFile myRoot;

    public FileHistoryModel(@NotNull VcsLogData data, @NotNull VcsLogDiffHandler handler, @NotNull VirtualFile root) {
        if (data == null) {
            FileHistoryModel.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            FileHistoryModel.$$$reportNull$$$0(1);
        }
        if (root == null) {
            FileHistoryModel.$$$reportNull$$$0(2);
        }
        this.myLogData = data;
        this.myDiffHandler = handler;
        this.myRoot = root;
    }

    @NotNull
    protected abstract VisiblePack getVisiblePack();

    @NotNull
    VcsLogDiffHandler getDiffHandler() {
        VcsLogDiffHandler vcsLogDiffHandler = this.myDiffHandler;
        if (vcsLogDiffHandler == null) {
            FileHistoryModel.$$$reportNull$$$0(3);
        }
        return vcsLogDiffHandler;
    }

    @Nullable
    public VcsFileRevision createRevision(@Nullable VcsCommitMetadata commit) {
        if (commit == null) {
            return null;
        }
        if (this.isFileDeletedInCommit((Hash)commit.getId())) {
            return VcsFileRevision.NULL;
        }
        FilePath path = this.getPathInCommit((Hash)commit.getId());
        if (path == null) {
            return null;
        }
        return new VcsLogFileRevision(commit, this.myDiffHandler.createContentRevision(path, (Hash)commit.getId()), path, false);
    }

    @Nullable
    public FilePath getPathInCommit(@NotNull Hash hash) {
        if (hash == null) {
            FileHistoryModel.$$$reportNull$$$0(4);
        }
        int commitIndex = this.myLogData.getStorage().getCommitIndex(hash, this.myRoot);
        return FileHistoryPaths.filePath(this.getVisiblePack(), commitIndex);
    }

    private boolean isFileDeletedInCommit(@NotNull Hash hash) {
        if (hash == null) {
            FileHistoryModel.$$$reportNull$$$0(5);
        }
        int commitIndex = this.myLogData.getStorage().getCommitIndex(hash, this.myRoot);
        return FileHistoryPaths.isDeletedInCommit(this.getVisiblePack(), commitIndex);
    }

    @Nullable
    public Change getSelectedChange(int @NotNull [] rows) {
        if (rows == null) {
            FileHistoryModel.$$$reportNull$$$0(6);
        }
        if (rows.length == 0) {
            return null;
        }
        int row = rows[0];
        VisiblePack visiblePack = this.getVisiblePack();
        List<Integer> parentRows = rows.length == 1 ? (((Boolean)VisiblePack.NO_GRAPH_INFORMATION.get((UserDataHolder)visiblePack, (Object)false)).booleanValue() && row + 1 < visiblePack.getVisibleGraph().getVisibleCommitCount() ? Collections.singletonList(row + 1) : visiblePack.getVisibleGraph().getRowInfo(row).getAdjacentRows(true)) : Collections.singletonList(rows[rows.length - 1]);
        return FileHistoryUtil.createChangeToParents(row, parentRows, visiblePack, this.myDiffHandler, this.myLogData);
    }

    @NotNull
    public FileHistoryModel createSnapshot() {
        return new Snapshot(this.myLogData, this.myDiffHandler, this.myRoot, this.getVisiblePack());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPathInCommit";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFileDeletedInCommit";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class Snapshot
    extends FileHistoryModel {
        @NotNull
        private final VisiblePack myVisiblePack;

        private Snapshot(@NotNull VcsLogData data, @NotNull VcsLogDiffHandler handler, @NotNull VirtualFile root, @NotNull VisiblePack visiblePack) {
            if (data == null) {
                Snapshot.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                Snapshot.$$$reportNull$$$0(1);
            }
            if (root == null) {
                Snapshot.$$$reportNull$$$0(2);
            }
            if (visiblePack == null) {
                Snapshot.$$$reportNull$$$0(3);
            }
            super(data, handler, root);
            this.myVisiblePack = visiblePack;
        }

        @Override
        @NotNull
        protected VisiblePack getVisiblePack() {
            VisiblePack visiblePack = this.myVisiblePack;
            if (visiblePack == null) {
                Snapshot.$$$reportNull$$$0(4);
            }
            return visiblePack;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visiblePack";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryModel$Snapshot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryModel$Snapshot";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVisiblePack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

