/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.scientific.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GroupHeaderSeparator;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.scientific.action.ImageOperationMode;
import org.intellij.images.scientific.action.ImageOperationsActionGroup;
import org.intellij.images.scientific.utils.ScientificUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000M\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\t\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/intellij/images/scientific/action/ImageOperationsActionGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "selectedMode", "Lorg/intellij/images/scientific/action/ImageOperationMode;", "customRenderer", "org/intellij/images/scientific/action/ImageOperationsActionGroup$customRenderer$1", "Lorg/intellij/images/scientific/action/ImageOperationsActionGroup$customRenderer$1;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "handleComboBoxSelection", "comboBox", "Lcom/intellij/openapi/ui/ComboBox;", "intellij.platform.images"})
public final class ImageOperationsActionGroup
extends DefaultActionGroup
implements CustomComponentAction,
DumbAware {
    @NotNull
    private ImageOperationMode selectedMode = ImageOperationMode.ORIGINAL_IMAGE;
    @NotNull
    private final customRenderer.1 customRenderer = new ListCellRenderer<Object>(){
        private final GroupHeaderSeparator separator;
        private final JLabel itemComponent;
        private final JPanel panel;
        {
            this.separator = new GroupHeaderSeparator(JBUI.CurrentTheme.Popup.separatorLabelInsets());
            this.itemComponent = new JLabel();
            this.panel = new JPanel(new BorderLayout());
            this.panel.setOpaque(false);
            this.panel.setBorder(null);
            this.itemComponent.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ImageOperationMode mode;
            ImageOperationMode imageOperationMode = mode = value instanceof ImageOperationMode ? (ImageOperationMode)((Object)value) : null;
            this.itemComponent.setText(imageOperationMode != null ? imageOperationMode.getDisplayName() : null);
            ImageOperationMode imageOperationMode2 = mode;
            this.itemComponent.setIcon(imageOperationMode2 != null ? imageOperationMode2.getIcon() : null);
            this.itemComponent.setBorder(null);
            if (isSelected) {
                JList<? extends Object> jList = list;
                this.itemComponent.setForeground(jList != null ? jList.getSelectionForeground() : null);
                JList<? extends Object> jList2 = list;
                this.itemComponent.setBackground(jList2 != null ? jList2.getSelectionBackground() : null);
                this.itemComponent.setOpaque(true);
            } else {
                JList<? extends Object> jList = list;
                this.itemComponent.setForeground(jList != null ? jList.getForeground() : null);
                JList<? extends Object> jList3 = list;
                this.itemComponent.setBackground(jList3 != null ? jList3.getBackground() : null);
                this.itemComponent.setOpaque(false);
            }
            this.panel.removeAll();
            if (index > 0 && this.shouldShowSeparator(list, index)) {
                this.panel.add((Component)this.separator, "North");
            }
            this.panel.add((Component)this.itemComponent, "Center");
            return this.panel;
        }

        private final boolean shouldShowSeparator(JList<? extends Object> list, int index) {
            JList<? extends Object> jList = list;
            Object var4_3 = jList != null && (jList = jList.getModel()) != null ? jList.getElementAt(index - 1) : null;
            ImageOperationMode prevItem = var4_3 instanceof ImageOperationMode ? (ImageOperationMode)var4_3 : null;
            return prevItem == ImageOperationMode.ORIGINAL_IMAGE || prevItem == ImageOperationMode.BINARIZE_IMAGE || prevItem == ImageOperationMode.CHANNEL_3;
        }
    };

    public ImageOperationsActionGroup() {
        Presentation presentation;
        Presentation $this$_init__u24lambda_u240 = presentation = this.getTemplatePresentation();
        boolean bl = false;
        $this$_init__u24lambda_u240.setPerformGroup(true);
        this.setPopup(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean shouldShowTheGroup = Registry.Companion.is("ide.images.sci.mode.channels.operations");
        if (!shouldShowTheGroup) {
            e.getPresentation().setVisible(false);
            return;
        }
        VirtualFile imageFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile virtualFile = imageFile;
        e.getPresentation().setEnabledAndVisible((virtualFile != null ? (Unit)virtualFile.getUserData(ScientificUtils.SCIENTIFIC_MODE_KEY) : null) != null);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        this.selectedMode = ImageOperationMode.ORIGINAL_IMAGE;
        DefaultComboBoxModel<ImageOperationMode> comboBoxModel = new DefaultComboBoxModel<ImageOperationMode>(ImageOperationMode.values());
        Object object = new ComboBox((ComboBoxModel)comboBoxModel);
        ComboBox $this$createCustomComponent_u24lambda_u242 = object;
        boolean bl = false;
        $this$createCustomComponent_u24lambda_u242.setSelectedItem((Object)this.selectedMode);
        $this$createCustomComponent_u24lambda_u242.setOpaque(false);
        $this$createCustomComponent_u24lambda_u242.setMaximumRowCount(comboBoxModel.getSize());
        $this$createCustomComponent_u24lambda_u242.setRenderer((ListCellRenderer)this.customRenderer);
        $this$createCustomComponent_u24lambda_u242.addActionListener(arg_0 -> ImageOperationsActionGroup.createCustomComponent$lambda$2$lambda$1(this, $this$createCustomComponent_u24lambda_u242, arg_0));
        ComboBox comboBox = object;
        Object $this$createCustomComponent_u24lambda_u243 = object = new JPanel(new FlowLayout(1, 0, 0));
        boolean bl2 = false;
        ((JComponent)$this$createCustomComponent_u24lambda_u243).setOpaque(false);
        ((JComponent)$this$createCustomComponent_u24lambda_u243).setBorder(null);
        ((Container)$this$createCustomComponent_u24lambda_u243).add((Component)comboBox);
        return (JComponent)object;
    }

    private final void handleComboBoxSelection(ComboBox<ImageOperationMode> comboBox) {
        Object object = comboBox.getSelectedItem();
        ImageOperationMode imageOperationMode = object instanceof ImageOperationMode ? (ImageOperationMode)((Object)object) : null;
        if (imageOperationMode == null) {
            return;
        }
        ImageOperationMode selectedItem = imageOperationMode;
        if (selectedItem == ImageOperationMode.CONFIGURE_ACTIONS) {
            comboBox.setSelectedItem((Object)this.selectedMode);
            selectedItem.runAction();
        } else {
            this.selectedMode = selectedItem;
            this.selectedMode.runAction();
        }
    }

    private static final void createCustomComponent$lambda$2$lambda$1(ImageOperationsActionGroup this$0, ComboBox $this_apply, ActionEvent it) {
        this$0.handleComboBoxSelection((ComboBox<ImageOperationMode>)$this_apply);
    }
}

