/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.impl.ngram.model;

import com.intellij.platform.ml.impl.ngram.model.NGramModel;
import com.intellij.platform.ml.impl.ngram.model.NGramModelKt;
import com.intellij.platform.ml.impl.ngram.model.NGramToken;
import com.intellij.platform.ml.impl.ngram.model.counter.NGramCounter;
import com.intellij.platform.ml.impl.ngram.model.counter.NGramHashMapCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u0011*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0011B\u001f\b\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J2\u0010\u000e\u001a\u00020\n2 \u0010\u000b\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000f0\fj\n\u0012\u0006\b\u0001\u0012\u00028\u0000`\u00102\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/ml/impl/ngram/model/SimpleNGramModel;", "T", "Lcom/intellij/platform/ml/impl/ngram/model/NGramModel;", "ngramCounter", "Lcom/intellij/platform/ml/impl/ngram/model/counter/NGramCounter;", "ngramSize", "", "<init>", "(Lcom/intellij/platform/ml/impl/ngram/model/counter/NGramCounter;I)V", "scoreToken", "", "input", "", "tokenIndex", "scoreNGram", "Lcom/intellij/platform/ml/impl/ngram/model/NGramToken;", "Lcom/intellij/platform/ml/impl/ngram/model/NGram;", "Companion", "intellij.platform.ml.impl"})
@ApiStatus.Internal
public final class SimpleNGramModel<T>
extends NGramModel<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private SimpleNGramModel(NGramCounter<T> ngramCounter, int ngramSize) {
        super(ngramCounter, ngramSize);
    }

    @Override
    public double scoreToken(@NotNull List<? extends T> input, int tokenIndex) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        List ngram = NGramModelKt.toNGram((Collection)input, false);
        int tokenInNGramIndex = tokenIndex + 1;
        return this.scoreNGram(ngram, tokenInNGramIndex);
    }

    private final double scoreNGram(List<? extends NGramToken<? extends T>> input, int tokenIndex) {
        int minIndex = RangesKt.coerceAtLeast((int)(tokenIndex - this.getNgramSize() + 1), (int)0);
        List<? extends NGramToken<? extends T>> inputWithToken = input.subList(minIndex, tokenIndex + 1);
        List<? extends NGramToken<? extends T>> prefix = input.subList(minIndex, tokenIndex);
        int inputFrequency = this.getNGramCounter().getFrequencyOf(inputWithToken);
        int prefixFrequency = this.getNGramCounter().getFrequencyOf(prefix);
        return (double)inputFrequency / (double)prefixFrequency;
    }

    public /* synthetic */ SimpleNGramModel(NGramCounter ngramCounter, int ngramSize, DefaultConstructorMarker $constructor_marker) {
        this(ngramCounter, ngramSize);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ0\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\t0\f2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/ml/impl/ngram/model/SimpleNGramModel$Companion;", "", "<init>", "()V", "train", "Lcom/intellij/platform/ml/impl/ngram/model/SimpleNGramModel;", "T", "tokens", "", "", "ngramSize", "", "Lkotlin/sequences/Sequence;", "intellij.platform.ml.impl"})
    @SourceDebugExtension(value={"SMAP\nSimpleNGramModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleNGramModel.kt\ncom/intellij/platform/ml/impl/ngram/model/SimpleNGramModel$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1063#2:69\n1#3:70\n827#4:71\n855#4,2:72\n*S KotlinDebug\n*F\n+ 1 SimpleNGramModel.kt\ncom/intellij/platform/ml/impl/ngram/model/SimpleNGramModel$Companion\n*L\n61#1:69\n52#1:71\n52#1:72,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> SimpleNGramModel<T> train(@NotNull Collection<? extends List<? extends T>> tokens, int ngramSize) {
            Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
            return this.train(CollectionsKt.asSequence((Iterable)tokens), ngramSize);
        }

        /*
         * WARNING - void declaration
         */
        private final <T> SimpleNGramModel<T> train(Sequence<? extends List<? extends T>> tokens, int ngramSize) {
            void $this$groupingBy$iv;
            Sequence sequence = SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.mapNotNull(tokens, arg_0 -> Companion.train$lambda$2(ngramSize, arg_0)));
            boolean $i$f$groupingBy = false;
            Map it = GroupingKt.eachCount((Grouping)new Grouping<List<? extends NGramToken<? extends T>>, List<? extends NGramToken<? extends T>>>((Sequence)$this$groupingBy$iv){
                final /* synthetic */ Sequence $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                public Iterator<List<? extends NGramToken<? extends T>>> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public Object keyOf(Object element) {
                    void var2_2;
                    List it = (List)element;
                    boolean bl = false;
                    return var2_2;
                }
            });
            boolean bl = false;
            NGramHashMapCounter ngramCounter = new NGramHashMapCounter(it, ngramSize);
            return new SimpleNGramModel(ngramCounter, ngramSize, null);
        }

        /*
         * WARNING - void declaration
         */
        private static final List train$lambda$2(int $ngramSize, List token) {
            List list;
            List list2;
            List list3;
            List list4;
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            List it = list4 = token;
            boolean bl2 = false;
            List<NGramToken<Object>> list5 = list3 = !((Collection)it).isEmpty() ? list4 : null;
            if (list3 != null && (list4 = NGramModelKt.toNGram(list3, true)) != null && (list2 = CollectionsKt.windowed$default((Iterable)list4, (int)$ngramSize, (int)0, (boolean)true, (int)2, null)) != null) {
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                Iterable bl2 = list2;
                boolean $i$f$filterNot = false;
                void var7_8 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    List it2 = (List)element$iv$iv;
                    boolean bl3 = false;
                    if (it2.size() < $ngramSize && !(CollectionsKt.first((List)it2) instanceof NGramToken.StartOfSentence)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

