/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.request.json;

import com.google.gson.annotations.SerializedName;
import dev.langchain4j.Experimental;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Experimental
public class JsonObjectSchema
implements JsonSchemaElement {
    private final String description;
    private final Map<String, JsonSchemaElement> properties;
    private final List<String> required;
    @SerializedName(value="additionalProperties")
    private final Boolean additionalProperties;

    public JsonObjectSchema(Builder builder) {
        this.description = builder.description;
        this.properties = new LinkedHashMap<String, JsonSchemaElement>(ValidationUtils.ensureNotEmpty(builder.properties, "properties"));
        this.required = Utils.copyIfNotNull(builder.required);
        this.additionalProperties = builder.additionalProperties;
    }

    public String description() {
        return this.description;
    }

    public Map<String, JsonSchemaElement> properties() {
        return this.properties;
    }

    public List<String> required() {
        return this.required;
    }

    public Boolean additionalProperties() {
        return this.additionalProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonObjectSchema that = (JsonObjectSchema)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.properties, that.properties) && Objects.equals(this.required, that.required) && Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.properties, this.required, this.additionalProperties);
    }

    public String toString() {
        return "JsonObjectSchema {description = " + Utils.quoted(this.description) + ", properties = " + this.properties + ", required = " + this.required + ", additionalProperties = " + this.additionalProperties + " }";
    }

    public static class Builder {
        private String description;
        private Map<String, JsonSchemaElement> properties = new LinkedHashMap<String, JsonSchemaElement>();
        private List<String> required = new ArrayList<String>();
        private Boolean additionalProperties;

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder properties(Map<String, JsonSchemaElement> properties) {
            this.properties = properties;
            return this;
        }

        public Builder required(List<String> required) {
            this.required = required;
            return this;
        }

        public Builder required(String ... required) {
            return this.required(Arrays.asList(required));
        }

        public Builder additionalProperties(Boolean additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }

        public JsonObjectSchema build() {
            return new JsonObjectSchema(this);
        }
    }
}

