/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameCmd
implements CollApiCmds.CollectionApiCommand {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionCommandContext ccc;

    public RenameCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
        String extCollectionName = message.getStr("name");
        String target = message.getStr("target");
        if (this.ccc.getZkStateReader().aliasesManager != null) {
            this.ccc.getZkStateReader().aliasesManager.update();
        }
        if (extCollectionName == null || target == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "both collection 'name' and 'target' name must be specified");
        }
        Aliases aliases = this.ccc.getZkStateReader().getAliases();
        boolean followAliases = message.getBool("followAliases", false);
        String collectionName = followAliases ? aliases.resolveSimpleAlias(extCollectionName) : extCollectionName;
        if (!state.hasCollection(collectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "source collection '" + collectionName + "' not found.");
        }
        if (this.ccc.getZkStateReader().getAliases().hasAlias(target)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "target alias '" + target + "' exists: " + this.ccc.getZkStateReader().getAliases().getCollectionAliasListMap().get(target));
        }
        this.ccc.getZkStateReader().aliasesManager.applyModificationAndExportToZk(a -> a.cloneWithRename(extCollectionName, target));
    }
}

