/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.filestore;

import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.endpoint.NodeFileStoreApis;
import org.apache.solr.client.api.model.FileStoreDirectoryListingResponse;
import org.apache.solr.client.api.model.FileStoreEntryMetadata;
import org.apache.solr.client.api.model.FileStoreJsonFileResponse;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.filestore.DistribFileStore;
import org.apache.solr.filestore.FileStore;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeFileStore
extends JerseyResource
implements NodeFileStoreApis {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CoreContainer coreContainer;
    private final SolrQueryRequest req;
    private final SolrQueryResponse rsp;
    private final FileStore fileStore;

    @Inject
    public NodeFileStore(CoreContainer coreContainer, DistribFileStore fileStore, SolrQueryRequest req, SolrQueryResponse rsp) {
        this.coreContainer = coreContainer;
        this.req = req;
        this.rsp = rsp;
        this.fileStore = fileStore;
    }

    @PermissionName(value=PermissionNameProvider.Name.FILESTORE_READ_PERM)
    public SolrJerseyResponse getFile(String path, Boolean sync, String getFrom, Boolean meta) {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        if (Boolean.TRUE.equals(sync)) {
            try {
                this.fileStore.syncToAllNodes(path);
                return response;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error getting file ", (Throwable)e);
            }
        }
        if (path == null) {
            path = "";
        }
        String pathCopy = path;
        if (getFrom != null) {
            this.coreContainer.getUpdateShardHandler().getUpdateExecutor().submit(() -> {
                log.debug("Downloading file {}", (Object)pathCopy);
                try {
                    this.fileStore.fetch(pathCopy, getFrom);
                }
                catch (Exception e) {
                    log.error("Failed to download file: {}", (Object)pathCopy, (Object)e);
                }
                log.info("downloaded file: {}", (Object)pathCopy);
            });
            return response;
        }
        FileStore.FileType type = this.fileStore.getType(path, false);
        if (type == FileStore.FileType.NOFILE) {
            FileStoreDirectoryListingResponse fileMissingResponse = this.instantiateJerseyResponse(FileStoreDirectoryListingResponse.class);
            fileMissingResponse.files = Collections.singletonMap(path, null);
            return fileMissingResponse;
        }
        if (type == FileStore.FileType.DIRECTORY) {
            FileStoreDirectoryListingResponse directoryListingResponse = this.instantiateJerseyResponse(FileStoreDirectoryListingResponse.class);
            List directoryContents = this.fileStore.list(path, null).stream().map(details -> this.convertToResponse((FileStore.FileDetails)details)).collect(Collectors.toList());
            directoryListingResponse.files = Collections.singletonMap(path, directoryContents);
            return directoryListingResponse;
        }
        if (Boolean.TRUE.equals(meta)) {
            if (type == FileStore.FileType.FILE) {
                int idx = path.lastIndexOf(47);
                String fileName = path.substring(idx + 1);
                String parentPath = path.substring(0, path.lastIndexOf(47));
                List<FileStore.FileDetails> l = this.fileStore.list(parentPath, s -> s.equals(fileName));
                FileStoreDirectoryListingResponse fileMetaResponse = this.instantiateJerseyResponse(FileStoreDirectoryListingResponse.class);
                fileMetaResponse.files = Collections.singletonMap(path, l.isEmpty() ? null : this.convertToResponse(l.get(0)));
                return fileMetaResponse;
            }
        } else {
            if ("json".equals(this.req.getParams().get("wt"))) {
                FileStoreJsonFileResponse jsonResponse = this.instantiateJerseyResponse(FileStoreJsonFileResponse.class);
                try {
                    this.fileStore.get(pathCopy, it -> {
                        try {
                            InputStream inputStream = it.getInputStream();
                            if (inputStream != null) {
                                jsonResponse.response = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                            }
                        }
                        catch (IOException e) {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading file " + pathCopy);
                        }
                    }, false);
                    return jsonResponse;
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error getting file from path " + path);
                }
            }
            ModifiableSolrParams solrParams = new ModifiableSolrParams();
            solrParams.add("wt", new String[]{"filestream"});
            this.req.setParams(SolrParams.wrapDefaults((SolrParams)solrParams, (SolrParams)this.req.getParams()));
            this.rsp.add("content", os -> this.fileStore.get(pathCopy, it -> {
                try {
                    InputStream inputStream = it.getInputStream();
                    if (inputStream != null) {
                        inputStream.transferTo(os);
                    }
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading file " + pathCopy);
                }
            }, false));
        }
        return response;
    }

    private FileStoreEntryMetadata convertToResponse(FileStore.FileDetails details) {
        FileStoreEntryMetadata entryMetadata = new FileStoreEntryMetadata();
        entryMetadata.name = details.getSimpleName();
        if (details.isDir()) {
            entryMetadata.dir = true;
            return entryMetadata;
        }
        entryMetadata.size = details.size();
        entryMetadata.timestamp = details.getTimeStamp();
        if (details.getMetaData() != null) {
            details.getMetaData().toMap(entryMetadata.unknownProperties());
        }
        return entryMetadata;
    }
}

