/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.HashMap;
import org.apache.solr.client.api.endpoint.CollectionSnapshotApis;
import org.apache.solr.client.api.model.CreateCollectionSnapshotRequestBody;
import org.apache.solr.client.api.model.CreateCollectionSnapshotResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class CreateCollectionSnapshot
extends AdminAPIBase
implements CollectionSnapshotApis.Create {
    @Inject
    public CreateCollectionSnapshot(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public CreateCollectionSnapshotResponse createCollectionSnapshot(String collName, String snapshotName, CreateCollectionSnapshotRequestBody requestBody) throws Exception {
        CreateCollectionSnapshotResponse response = this.instantiateJerseyResponse(CreateCollectionSnapshotResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        CreateCollectionSnapshot.recordCollectionForLogAndTracing(collName, this.solrQueryRequest);
        String collectionName = this.resolveCollectionName(collName, requestBody.followAliases);
        SolrZkClient client = coreContainer.getZkController().getZkClient();
        if (SolrSnapshotManager.snapshotExists(client, collectionName, snapshotName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot with name '" + snapshotName + "' already exists for collection '" + collectionName + "', no action taken.");
        }
        ZkNodeProps remoteMessage = CreateCollectionSnapshot.createRemoteMessage(collName, requestBody.followAliases, snapshotName, requestBody.async);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.CREATESNAPSHOT, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        response.collection = collName;
        response.followAliases = requestBody.followAliases;
        response.snapshotName = snapshotName;
        response.requestId = requestBody.async;
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, boolean followAliases, String snapshotName, String asyncId) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.CREATESNAPSHOT.toLower());
        remoteMessage.put("collection", collectionName);
        remoteMessage.put("commitName", snapshotName);
        remoteMessage.put("followAliases", followAliases);
        if (asyncId != null) {
            remoteMessage.put("async", asyncId);
        }
        return new ZkNodeProps(remoteMessage);
    }
}

