/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.lucene.util.ResourceLoader;
import org.apache.solr.api.AnnotatedApi;
import org.apache.solr.api.Api;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SpecProvider;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.ModifyMultiPluginAuthConfigAPI;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.BasicAuthPlugin;
import org.apache.solr.security.ConfigEditablePlugin;
import org.eclipse.jetty.client.api.Request;

public class MultiAuthPlugin
extends AuthenticationPlugin
implements ConfigEditablePlugin,
SpecProvider {
    public static final String PROPERTY_SCHEMES = "schemes";
    public static final String PROPERTY_SCHEME = "scheme";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static final ThreadLocal<AuthenticationPlugin> pluginInRequest = new ThreadLocal();
    private static final String UNKNOWN_SCHEME = "";
    private final Map<String, AuthenticationPlugin> pluginMap = new LinkedHashMap<String, AuthenticationPlugin>();
    private final Map<String, String> realms = new LinkedHashMap<String, String>();
    private final List<String> WWWAuthenticateHeaders = new ArrayList<String>();
    private final ResourceLoader loader;
    private AuthenticationPlugin allowsUnknown = null;

    public MultiAuthPlugin(CoreContainer cc) {
        this.loader = cc.getResourceLoader();
    }

    static boolean applyEditCommandToSchemePlugin(String scheme, ConfigEditablePlugin plugin, CommandOperation c, Map<String, Object> latestConf) {
        boolean madeChanges = false;
        Map<String, Object> latestPluginConf = null;
        int updateAt = -1;
        List schemes = (List)latestConf.get(PROPERTY_SCHEMES);
        for (int i = 0; i < schemes.size(); ++i) {
            Map schemeConfig = (Map)schemes.get(i);
            if (!scheme.equals(schemeConfig.get(PROPERTY_SCHEME))) continue;
            latestPluginConf = MultiAuthPlugin.withoutScheme(schemeConfig);
            updateAt = i;
            break;
        }
        if (latestPluginConf == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Config for scheme '" + scheme + "' not found!");
        }
        Map<String, Object> updated = plugin.edit(latestPluginConf, Collections.singletonList(c));
        if (updated != null) {
            madeChanges = true;
            schemes.set(updateAt, MultiAuthPlugin.withScheme(scheme, updated));
        }
        return madeChanges;
    }

    private static Map<String, Object> withoutScheme(Map<String, Object> data) {
        HashMap<String, Object> updatedData = new HashMap<String, Object>(data);
        updatedData.remove(PROPERTY_SCHEME);
        return updatedData;
    }

    private static Map<String, Object> withScheme(String scheme, Map<String, Object> data) {
        HashMap<String, Object> updatedData = new HashMap<String, Object>(data);
        updatedData.put(PROPERTY_SCHEME, scheme);
        return updatedData;
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
        Object o = pluginConfig.get(PROPERTY_SCHEMES);
        if (!(o instanceof List)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid config: MultiAuthPlugin requires a list of schemes!");
        }
        List schemeList = (List)o;
        if (schemeList.size() < 2) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid config: MultiAuthPlugin requires at least two schemes!");
        }
        for (Object s : schemeList) {
            if (!(s instanceof Map)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid scheme config, expected JSON object but found: " + s);
            }
            this.initPluginForScheme((Map)s);
        }
        this.initWWWAuthenticateHeaders();
    }

    protected void initPluginForScheme(Map<String, Object> schemeMap) {
        HashMap<String, Object> schemeConfig = new HashMap<String, Object>(schemeMap);
        String scheme = (String)schemeConfig.remove(PROPERTY_SCHEME);
        if (StrUtils.isNullOrEmpty((String)scheme)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'scheme' is a required attribute: " + schemeMap);
        }
        String clazz = (String)schemeConfig.remove("class");
        if (StrUtils.isNullOrEmpty((String)clazz)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'class' is a required attribute: " + schemeMap);
        }
        String realm = (String)schemeConfig.remove("realm");
        if (!StrUtils.isNullOrEmpty((String)realm)) {
            this.realms.put(scheme, realm);
        }
        AuthenticationPlugin pluginForScheme = (AuthenticationPlugin)this.loader.newInstance(clazz, AuthenticationPlugin.class);
        pluginForScheme.init(schemeConfig);
        this.pluginMap.put(scheme.toLowerCase(Locale.ROOT), pluginForScheme);
        if (this.allowsUnknown == null && !Boolean.parseBoolean(String.valueOf(schemeConfig.getOrDefault("blockUnknown", true)))) {
            this.allowsUnknown = pluginForScheme;
        }
    }

    private void initWWWAuthenticateHeaders() {
        for (String scheme : this.pluginMap.keySet()) {
            String realm = this.realms.get(scheme);
            Object realmStr = realm == null ? UNKNOWN_SCHEME : " realm=\"" + realm + "\"";
            this.WWWAuthenticateHeaders.add(scheme + (String)realmStr);
        }
    }

    private void addWWWAuthenticateHeaders(HttpServletResponse response) {
        for (String wwwAuthHeader : this.WWWAuthenticateHeaders) {
            response.addHeader("WWW-Authenticate", wwwAuthHeader);
        }
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        for (AuthenticationPlugin plugin : this.pluginMap.values()) {
            plugin.initializeMetrics(parentContext, scope);
        }
    }

    private String getSchemeFromAuthHeader(String authHeader) {
        int firstSpace = authHeader.indexOf(32);
        return firstSpace != -1 ? authHeader.substring(0, firstSpace).toLowerCase(Locale.ROOT) : UNKNOWN_SCHEME;
    }

    @Override
    public boolean doAuthenticate(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String authHeader = request.getHeader(AUTHORIZATION_HEADER);
        if (authHeader == null) {
            AuthenticationPlugin plugin = BasicAuthPlugin.isAjaxRequest(request) ? this.pluginMap.values().iterator().next() : this.allowsUnknown;
            boolean result = false;
            if (plugin != null) {
                pluginInRequest.set(plugin);
                result = plugin.doAuthenticate(request, response, filterChain);
            } else {
                this.addWWWAuthenticateHeaders(response);
                response.sendError(SolrException.ErrorCode.UNAUTHORIZED.code, "No Authorization header");
            }
            return result;
        }
        String scheme = this.getSchemeFromAuthHeader(authHeader);
        AuthenticationPlugin plugin = this.pluginMap.get(scheme);
        if (plugin == null) {
            this.addWWWAuthenticateHeaders(response);
            response.sendError(SolrException.ErrorCode.UNAUTHORIZED.code, "Authorization scheme '" + scheme + "' not supported!");
            return false;
        }
        pluginInRequest.set(plugin);
        return plugin.doAuthenticate(request, response, filterChain);
    }

    @Override
    public void close() throws IOException {
        IOException exc = null;
        for (AuthenticationPlugin plugin : this.pluginMap.values()) {
            try {
                plugin.close();
            }
            catch (IOException ioExc) {
                if (exc != null) continue;
                exc = ioExc;
            }
        }
        if (exc != null) {
            throw exc;
        }
    }

    @Override
    public void closeRequest() {
        AuthenticationPlugin plugin = pluginInRequest.get();
        if (plugin != null) {
            plugin.closeRequest();
            pluginInRequest.remove();
        }
    }

    @Override
    protected boolean interceptInternodeRequest(HttpRequest httpRequest, HttpContext httpContext) {
        for (AuthenticationPlugin plugin : this.pluginMap.values()) {
            if (!plugin.interceptInternodeRequest(httpRequest, httpContext)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean interceptInternodeRequest(Request request) {
        for (AuthenticationPlugin plugin : this.pluginMap.values()) {
            if (!plugin.interceptInternodeRequest(request)) continue;
            return true;
        }
        return false;
    }

    public ValidatingJsonMap getSpec() {
        List<Api> apis = AnnotatedApi.getApis(new ModifyMultiPluginAuthConfigAPI());
        return apis.get(0).getSpec();
    }

    @Override
    public Map<String, Object> edit(Map<String, Object> latestConf, List<CommandOperation> commands) {
        boolean madeChanges = false;
        for (CommandOperation c : commands) {
            Map dataMap = c.getDataMap();
            if (dataMap == null || dataMap.size() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "All edit commands must include a 'scheme' wrapper object!");
            }
            String scheme = ((String)dataMap.keySet().iterator().next()).toLowerCase(Locale.ROOT);
            AuthenticationPlugin plugin = this.pluginMap.get(scheme);
            if (plugin == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No authentication plugin configured for the '" + scheme + "' scheme!");
            }
            if (!(plugin instanceof ConfigEditablePlugin)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Plugin for scheme '" + scheme + "' is not editable!");
            }
            CommandOperation cmdForPlugin = new CommandOperation(c.name, dataMap.get(scheme));
            if (MultiAuthPlugin.applyEditCommandToSchemePlugin(scheme, (ConfigEditablePlugin)((Object)plugin), cmdForPlugin, latestConf)) {
                madeChanges = true;
            }
            for (String err : cmdForPlugin.getErrors()) {
                c.addError(err);
            }
        }
        return madeChanges ? latestConf : null;
    }
}

