/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class GenericSolrRequest
extends SolrRequest<SimpleSolrResponse> {
    public SolrParams params;
    public SimpleSolrResponse response = new SimpleSolrResponse();
    public RequestWriter.ContentWriter contentWriter;
    public boolean requiresCollection;

    public GenericSolrRequest(SolrRequest.METHOD m, String path) {
        this(m, path, new ModifiableSolrParams());
    }

    public GenericSolrRequest(SolrRequest.METHOD m, String path, SolrParams params) {
        super(m, path);
        this.params = params;
    }

    public GenericSolrRequest setRequiresCollection(boolean requiresCollection) {
        this.requiresCollection = requiresCollection;
        return this;
    }

    @Override
    public boolean requiresCollection() {
        return this.requiresCollection;
    }

    public GenericSolrRequest setContentWriter(RequestWriter.ContentWriter contentWriter) {
        this.contentWriter = contentWriter;
        return this;
    }

    public GenericSolrRequest withContent(final byte[] buf, final String type) {
        this.contentWriter = new RequestWriter.ContentWriter(){

            @Override
            public void write(OutputStream os) throws IOException {
                os.write(buf);
            }

            @Override
            public String getContentType() {
                return type;
            }
        };
        return this;
    }

    @Override
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
        return this.contentWriter;
    }

    @Override
    public SolrParams getParams() {
        return this.params;
    }

    @Override
    protected SimpleSolrResponse createResponse(SolrClient client) {
        return this.response;
    }

    @Override
    public String getRequestType() {
        return SolrRequest.SolrRequestType.UNSPECIFIED.toString();
    }
}

