/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.cohere;

import dev.langchain4j.model.cohere.RequestLoggingInterceptor;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResponseLoggingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ResponseLoggingInterceptor.class);

    ResponseLoggingInterceptor() {
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        this.log(response);
        return response;
    }

    void log(Response response) {
        log.debug("Response:\n- status code: {}\n- headers: {}\n- body: {}", new Object[]{response.code(), RequestLoggingInterceptor.inOneLine(response.headers()), this.getBody(response)});
    }

    private String getBody(Response response) {
        try {
            return response.peekBody(Long.MAX_VALUE).string();
        }
        catch (IOException e) {
            log.warn("Failed to log response", (Throwable)e);
            return "[failed to log response]";
        }
    }
}

