Luanti Texture Pack Reference
===============================

Texture packs allow you to replace textures provided by a mod with your own
textures.

Texture pack directory structure
--------------------------------

    textures
    |-- Texture Pack
    |   |-- texture_pack.conf
    |   |-- screenshot.png
    |   |-- description.txt
    |   |-- override.txt
    |   |-- your_texture_1.png
    |   |-- your_texture_2.png
    `-- Another Texture Pack

### Texture Pack
This is a directory containing the entire contents of a single texture pack.
It can be chosen more or less freely and will also become the name of the
texture pack. The name must not be “base”.

### The "server" texture pack
If a texture pack named `server` exists, the textures in it will replace textures
sent to clients.
It's independent of the client's texture pack, which will take precedence as usual.

### `texture_pack.conf`
A key-value config file with the following keys:

* `name`: The texture pack name. Allows Luanti to determine the texture pack name even if
  the folder is wrongly named.
* `title` - human-readable title
* `description` - short description, shown in the content tab
* `author`: The author's ContentDB username.
* `textdomain`: Textdomain used to translate title and description.
  Defaults to the texture pack name.
  See [Translating content meta](lua_api.md#translating-content-meta).

### `description.txt`
**Deprecated**, you should use texture_pack.conf instead.

A file containing a short description of the texture pack to be shown in the
content tab.

### `screenshot.png`
A preview image showing an in-game screenshot of this texture pack; it will be
shown in the texture packs tab. It should have an aspect ratio of 3:2 and a
minimum size of 300×200 pixels.

### `your_texture_1.png`, `your_texture_2.png`, etc.
Any other PNG files will be interpreted as textures. They must have the same
names as the textures they are supposed to override. For example, to override
the apple texture of Minetest Game, add a PNG file named `default_apple.png`.

The custom textures do not necessarily require the same size as their
originals, but this might be required for a few particular textures. When
unsure, just test your texture pack in-game.

Texture modifiers
-----------------

See lua_api.md for texture modifiers

Special textures
----------------

These texture names are hardcoded into the engine but can also be overwritten
by texture packs. All existing fallback textures can be found in the directory
`textures/base/pack`.

### Gameplay textures

* `bubble.png`: the bubble texture when the player is drowning
                (default size: 12×12)
* `bubble_gone.png`: like `bubble.png`, but denotes lack of breath
                     (transparent by default, same size as bubble.png)

* `crack_anylength.png`: node overlay texture when digging

* `crosshair.png`
    * the crosshair texture in the center of the screen. The settings
      `crosshair_color` and `crosshair_alpha` are used to create a cross
      when no texture is found.

* `object_crosshair.png`
    * the crosshair seen when pointing at an object. The settings
    `crosshair_color` and `crosshair_alpha` are used to create a cross
    when no texture is found.

* `halo.png`: used for the node highlighting mesh

* `heart.png`: used to display the health points of the player
               (default size: 12×12)
* `heart_gone.png`: like `heart.png`, but denotes lack of health points
                    (transparent by default, same size as heart.png)

* `minimap_mask_round.png`: round minimap mask, white gets replaced by the map
* `minimap_mask_square.png`: mask used for the square minimap
* `minimap_overlay_round.png`: overlay texture for the round minimap
* `minimap_overlay_square.png`: overlay texture for the square minimap
* `object_marker_red.png`: texture for players on the minimap
* `player_marker.png`: texture for the own player on the square minimap
* `no_texture_airlike.png`: fallback inventory image for airlike nodes
* `no_texture.png`: fallback image for unspecified textures

* `player.png`: front texture of the 2D upright sprite player
* `player_back.png`: back texture of the 2D upright sprite player

* `progress_bar.png`: foreground texture of the loading screen's progress bar
* `progress_bar_bg.png`: background texture of the loading screen's progress bar

* `moon.png`: texture of the moon. Default texture is generated by Luanti
* `moon_tonemap.png`: tonemap to be used when `moon.png` was found
* `sun.png`: texture of the sun. Default texture is generated by Luanti
* `sun_tonemap.png`: tonemap to be used when `sun.png` was found
* `sunrisebg.png`: shown sky texture when the sun rises

* `smoke_puff.png`: texture used when an object died by punching

* `unknown_item.png`: shown texture when an item definition was not found
* `unknown_node.png`: shown texture when a node definition was not found
* `unknown_object.png`: shown texture when an entity definition was not found

* `wieldhand.png`: texture of the wieldhand

Note: The default textures of `player.png`, `player_back.png` and `wieldhand.png`
are placeholders intended to be overwritten by the game.

### Mainmenu textures

* `menu_bg.png`: used as mainmenu background when the clouds are disabled
* `menu_header.png`: header texture when no texture pack is selected

* `no_screenshot.png`
    * texture when no screenshot was found for a texture pack or mod

* `server_flags_creative.png`: icon for creative servers
* `server_flags_damage.png`: icon for enabled damage on servers
* `server_flags_favorite.png`: icon for your favorite servers
* `server_flags_pvp.png`: icon for enabled PvP on servers

### Android textures

* `dig_btn.png`
* `place_btn.png`

* `jump_btn.png`
* `down.png`
* `zoom.png`
* `aux1_btn.png`
* `overflow_btn.png`

* `chat_btn.png`
* `inventory_btn.png`
* `drop_btn.png`
* `exit_btn.png`

* `fly_btn.png`
* `fast_btn.png`
* `noclip_btn.png`
* `debug_btn.png`
* `camera_btn.png`
* `rangeview_btn.png`
* `minimap_btn.png`
* `chat_hide_btn.png`
* `chat_show_btn.png`

* `joystick_off.png`
* `joystick_bg.png`
* `joystick_center.png`

Texture Overrides
-----------------

You can override the textures of nodes and items from a
texture pack using texture overrides. To do this, create one or
more files in a texture pack called override.txt

Each line in an override.txt file is a rule. It consists of

	itemname target texture

For example,

	default:dirt_with_grass sides default_stone.png

or

	default:sword_steel inventory my_steel_sword.png

You can list multiple targets on one line as a comma-separated list:

	default:tree top,bottom my_special_tree.png

You can use texture modifiers, as usual:

	default:dirt_with_grass sides default_stone.png^[brighten

Finally, if a line is empty or starts with '#' it will be considered
a comment and not read as a rule. You can use this to better organize
your override.txt files.

Here are targets you can choose from:

| target        | behavior                                          |
|---------------|---------------------------------------------------|
| left          | x- face                                           |
| right         | x+ face                                           |
| front         | z- face                                           |
| back          | z+ face                                           |
| top           | y+ face                                           |
| bottom        | y- face                                           |
| sides         | x-, x+, z-, z+ faces                              |
| all           | All faces. You can also use '*' instead of 'all'. |
| special1      | The first entry in the special_tiles list         |
| special2      | The second entry in the special_tiles list        |
| special3      | The third entry in the special_tiles list         |
| special4      | The fourth entry in the special_tiles list        |
| special5      | The fifth entry in the special_tiles list         |
| special6      | The sixth entry in the special_tiles list         |
| inventory     | The inventory texture                             |
| wield         | The texture used when held by the player          |
| align_world=N | Overrides the "world align" behavior of tiles ¹   |

Nodes support all targets, but other items only support 'inventory'
and 'wield'.

¹ : `N` is an integer [0,255]. Sets align_style = "world" and scale = N on the tile,
     refer to lua_api.md for details.

### Using the special targets

The special* targets only apply to specific drawtypes:

* `flowingliquid`: special1 sets the top texture, special2 sets the side texture
* `allfaces_optional`: special1 is used by simple mode, see below
* `glasslike_framed`: When containing a liquid, special1 sets the liquid texture
* `glasslike_framed_optional`: Same as `glasslike_framed`
* `plantlike_rooted`: special1 sets the plant's texture

Designing leaves textures for the leaves rendering options
----------------------------------------------------------

Luanti has three modes for rendering leaves nodes if the node has the
`allfaces_optional` drawtype.

### Fancy

Uses the texture specified in the `tiles` nodedef field.
The texture should have some transparent pixels and be in the RGBA format so
that the transparent pixels can have color information.
Faces of every leaves node are rendered even if they are inside a solid volume
of leaves; this gives a dense appearance.

### Opaque

Uses the texture specified in `tiles` but makes it opaque by converting each
transparent pixel into an opaque pixel that uses the color information of that
transparent pixel.
Due to this the `tiles` texture format must be RGBA not 'indexed alpha' to allow
each transparent pixel to have color information.

The colors of the transparent pixels should be set for a good appearance in
`opaque` mode. This can be done by painting the pixels the desired colors then
erasing them. Then when saving the texture, use the 'save color information from
transparent pixels' option (or equivalent).

### Simple

Uses the texture specified in the `special_tiles` nodedef field if it exists, if
not, the `tiles` texture.
The `special_tiles` texture should have fewer transparent pixels than the
`tiles` texture and be in the 'indexed alpha' format.

This mode is between the other two in terms of appearance and rendering load.
The nodes are rendered using the `glasslike` drawtype, only showing the surface
faces for any solid volume of leaves, not the internal faces.
Due to this the `tiles` texture might appear lacking in density, so optionally a
`special_tiles` texture can be used to provide a texture with fewer transparent
pixels for a denser appearance.
