function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0) { ; } } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * NOTE: We can't test this component because Enzyme doesn't support rendering
 * into portals.
 */

import React, { useEffect, useRef, useState } from 'react';
import PropTypes from "prop-types";
import { createPortal } from 'react-dom';
import classNames from 'classnames';
import { keysOf } from '../common';
export var OuiOverlayMask = function OuiOverlayMask(_ref) {
  var className = _ref.className,
    children = _ref.children,
    onClick = _ref.onClick,
    _ref$headerZindexLoca = _ref.headerZindexLocation,
    headerZindexLocation = _ref$headerZindexLoca === void 0 ? 'above' : _ref$headerZindexLoca,
    rest = _objectWithoutProperties(_ref, ["className", "children", "onClick", "headerZindexLocation"]);
  var overlayMaskNode = useRef(document.createElement('div'));
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPortalTargetReady = _useState2[0],
    setIsPortalTargetReady = _useState2[1];
  useEffect(function () {
    document.body.classList.add('ouiBody-hasOverlayMask');
    return function () {
      document.body.classList.remove('ouiBody-hasOverlayMask');
    };
  }, []);
  useEffect(function () {
    var portalTarget = overlayMaskNode.current;
    document.body.appendChild(overlayMaskNode.current);
    setIsPortalTargetReady(true);
    return function () {
      if (portalTarget) {
        document.body.removeChild(portalTarget);
      }
    };
  }, []);
  useEffect(function () {
    if (!overlayMaskNode.current) return;
    keysOf(rest).forEach(function (key) {
      if (typeof rest[key] !== 'string') {
        throw new Error("Unhandled property type. OuiOverlayMask property ".concat(key, " is not a string."));
      }
      overlayMaskNode.current.setAttribute(key, rest[key]);
    });
  }, []); // eslint-disable-line react-hooks/exhaustive-deps

  useEffect(function () {
    if (!overlayMaskNode.current) return;
    overlayMaskNode.current.className = classNames('ouiOverlayMask', "ouiOverlayMask--".concat(headerZindexLocation, "Header"), className);
  }, [className, headerZindexLocation]);
  useEffect(function () {
    if (!overlayMaskNode.current || !onClick) return;
    var portalTarget = overlayMaskNode.current;
    var handleClick = function handleClick(e) {
      if (e.target === overlayMaskNode.current) {
        onClick();
      }
    };
    portalTarget.addEventListener('click', handleClick);
    return function () {
      if (portalTarget) {
        portalTarget.removeEventListener('click', handleClick);
      }
    };
  }, [onClick]);
  return isPortalTargetReady ? /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/createPortal(children, overlayMaskNode.current)) : null;
};

/* OUI -> EUI Aliases: Build-Time */
OuiOverlayMask.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  /**
     * Function that applies to clicking the mask itself and not the children
     */
  onClick: PropTypes.func,
  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.node,
  /**
     * Should the mask visually sit above or below the OuiHeader (controlled by z-index)
     */
  headerZindexLocation: PropTypes.oneOf(["above", "below"])
};
/* OUI -> EUI Aliases: Build-Time */export { EuiOverlayMask } from '../../eui_components/overlay_mask/overlay_mask';