"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.customStringify = customStringify;
exports.customStringifySingleLine = customStringifySingleLine;
exports.getCharacterLimitedString = getCharacterLimitedString;
exports.isRAGUseCase = isRAGUseCase;
exports.isVectorSearchUseCase = isVectorSearchUseCase;
exports.prettifyErrorMessage = void 0;
exports.toFormattedDate = toFormattedDate;
var _moment = _interopRequireDefault(require("moment"));
var _ = require("./");
var _lodash = require("lodash");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function toFormattedDate(timestampMillis) {
  return (0, _moment.default)(new Date(timestampMillis)).format(_.DATE_FORMAT_PATTERN);
}
const PERMISSIONS_ERROR_PATTERN = /no permissions for \[(.+)\] and User \[name=(.+), backend_roles/;
const prettifyErrorMessage = rawErrorMessage => {
  if ((0, _lodash.isEmpty)(rawErrorMessage) || rawErrorMessage === 'undefined') {
    return 'Unknown error is returned.';
  }
  const match = rawErrorMessage.match(PERMISSIONS_ERROR_PATTERN);
  if ((0, _lodash.isEmpty)(match)) {
    return rawErrorMessage;
  } else {
    return `User ${match[2]} has no permissions to [${match[1]}].`;
  }
};
exports.prettifyErrorMessage = prettifyErrorMessage;
function getCharacterLimitedString(input, limit) {
  return input !== undefined ? input.length > limit ? input.substring(0, limit - 3) + '...' : input : '';
}
function customStringify(jsonObj) {
  return JSON.stringify(jsonObj, undefined, 2);
}
function customStringifySingleLine(jsonObj) {
  return JSON.stringify(jsonObj, undefined, 0);
}
function isVectorSearchUseCase(workflowType) {
  return workflowType !== undefined && [_.WORKFLOW_TYPE.SEMANTIC_SEARCH, _.WORKFLOW_TYPE.MULTIMODAL_SEARCH, _.WORKFLOW_TYPE.HYBRID_SEARCH, _.WORKFLOW_TYPE.VECTOR_SEARCH_WITH_RAG, _.WORKFLOW_TYPE.HYBRID_SEARCH_WITH_RAG, _.WORKFLOW_TYPE.SEMANTIC_SEARCH_USING_SPARSE_ENCODERS].includes(workflowType);
}
function isRAGUseCase(workflowType) {
  return workflowType !== undefined && [_.WORKFLOW_TYPE.VECTOR_SEARCH_WITH_RAG, _.WORKFLOW_TYPE.HYBRID_SEARCH_WITH_RAG].includes(workflowType);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfbW9tZW50IiwiX2ludGVyb3BSZXF1aXJlRGVmYXVsdCIsInJlcXVpcmUiLCJfIiwiX2xvZGFzaCIsImUiLCJfX2VzTW9kdWxlIiwiZGVmYXVsdCIsInRvRm9ybWF0dGVkRGF0ZSIsInRpbWVzdGFtcE1pbGxpcyIsIm1vbWVudCIsIkRhdGUiLCJmb3JtYXQiLCJEQVRFX0ZPUk1BVF9QQVRURVJOIiwiUEVSTUlTU0lPTlNfRVJST1JfUEFUVEVSTiIsInByZXR0aWZ5RXJyb3JNZXNzYWdlIiwicmF3RXJyb3JNZXNzYWdlIiwiaXNFbXB0eSIsIm1hdGNoIiwiZXhwb3J0cyIsImdldENoYXJhY3RlckxpbWl0ZWRTdHJpbmciLCJpbnB1dCIsImxpbWl0IiwidW5kZWZpbmVkIiwibGVuZ3RoIiwic3Vic3RyaW5nIiwiY3VzdG9tU3RyaW5naWZ5IiwianNvbk9iaiIsIkpTT04iLCJzdHJpbmdpZnkiLCJjdXN0b21TdHJpbmdpZnlTaW5nbGVMaW5lIiwiaXNWZWN0b3JTZWFyY2hVc2VDYXNlIiwid29ya2Zsb3dUeXBlIiwiV09SS0ZMT1dfVFlQRSIsIlNFTUFOVElDX1NFQVJDSCIsIk1VTFRJTU9EQUxfU0VBUkNIIiwiSFlCUklEX1NFQVJDSCIsIlZFQ1RPUl9TRUFSQ0hfV0lUSF9SQUciLCJIWUJSSURfU0VBUkNIX1dJVEhfUkFHIiwiU0VNQU5USUNfU0VBUkNIX1VTSU5HX1NQQVJTRV9FTkNPREVSUyIsImluY2x1ZGVzIiwiaXNSQUdVc2VDYXNlIl0sInNvdXJjZXMiOlsidXRpbHMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgbW9tZW50IGZyb20gJ21vbWVudCc7XG5pbXBvcnQgeyBEQVRFX0ZPUk1BVF9QQVRURVJOLCBXT1JLRkxPV19UWVBFIH0gZnJvbSAnLi8nO1xuaW1wb3J0IHsgaXNFbXB0eSB9IGZyb20gJ2xvZGFzaCc7XG5cbmV4cG9ydCBmdW5jdGlvbiB0b0Zvcm1hdHRlZERhdGUodGltZXN0YW1wTWlsbGlzOiBudW1iZXIpOiBTdHJpbmcge1xuICByZXR1cm4gbW9tZW50KG5ldyBEYXRlKHRpbWVzdGFtcE1pbGxpcykpLmZvcm1hdChEQVRFX0ZPUk1BVF9QQVRURVJOKTtcbn1cblxuY29uc3QgUEVSTUlTU0lPTlNfRVJST1JfUEFUVEVSTiA9IC9ubyBwZXJtaXNzaW9ucyBmb3IgXFxbKC4rKVxcXSBhbmQgVXNlciBcXFtuYW1lPSguKyksIGJhY2tlbmRfcm9sZXMvO1xuXG5leHBvcnQgY29uc3QgcHJldHRpZnlFcnJvck1lc3NhZ2UgPSAocmF3RXJyb3JNZXNzYWdlOiBzdHJpbmcpID0+IHtcbiAgaWYgKGlzRW1wdHkocmF3RXJyb3JNZXNzYWdlKSB8fCByYXdFcnJvck1lc3NhZ2UgPT09ICd1bmRlZmluZWQnKSB7XG4gICAgcmV0dXJuICdVbmtub3duIGVycm9yIGlzIHJldHVybmVkLic7XG4gIH1cbiAgY29uc3QgbWF0Y2ggPSByYXdFcnJvck1lc3NhZ2UubWF0Y2goUEVSTUlTU0lPTlNfRVJST1JfUEFUVEVSTik7XG4gIGlmIChpc0VtcHR5KG1hdGNoKSkge1xuICAgIHJldHVybiByYXdFcnJvck1lc3NhZ2U7XG4gIH0gZWxzZSB7XG4gICAgcmV0dXJuIGBVc2VyICR7bWF0Y2hbMl19IGhhcyBubyBwZXJtaXNzaW9ucyB0byBbJHttYXRjaFsxXX1dLmA7XG4gIH1cbn07XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRDaGFyYWN0ZXJMaW1pdGVkU3RyaW5nKFxuICBpbnB1dDogc3RyaW5nIHwgdW5kZWZpbmVkLFxuICBsaW1pdDogbnVtYmVyXG4pOiBzdHJpbmcge1xuICByZXR1cm4gaW5wdXQgIT09IHVuZGVmaW5lZFxuICAgID8gaW5wdXQubGVuZ3RoID4gbGltaXRcbiAgICAgID8gaW5wdXQuc3Vic3RyaW5nKDAsIGxpbWl0IC0gMykgKyAnLi4uJ1xuICAgICAgOiBpbnB1dFxuICAgIDogJyc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBjdXN0b21TdHJpbmdpZnkoanNvbk9iajoge30gfCBbXSk6IHN0cmluZyB7XG4gIHJldHVybiBKU09OLnN0cmluZ2lmeShqc29uT2JqLCB1bmRlZmluZWQsIDIpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gY3VzdG9tU3RyaW5naWZ5U2luZ2xlTGluZShqc29uT2JqOiB7fSk6IHN0cmluZyB7XG4gIHJldHVybiBKU09OLnN0cmluZ2lmeShqc29uT2JqLCB1bmRlZmluZWQsIDApO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaXNWZWN0b3JTZWFyY2hVc2VDYXNlKHdvcmtmbG93VHlwZT86IFdPUktGTE9XX1RZUEUpOiBib29sZWFuIHtcbiAgcmV0dXJuIChcbiAgICB3b3JrZmxvd1R5cGUgIT09IHVuZGVmaW5lZCAmJlxuICAgIFtcbiAgICAgIFdPUktGTE9XX1RZUEUuU0VNQU5USUNfU0VBUkNILFxuICAgICAgV09SS0ZMT1dfVFlQRS5NVUxUSU1PREFMX1NFQVJDSCxcbiAgICAgIFdPUktGTE9XX1RZUEUuSFlCUklEX1NFQVJDSCxcbiAgICAgIFdPUktGTE9XX1RZUEUuVkVDVE9SX1NFQVJDSF9XSVRIX1JBRyxcbiAgICAgIFdPUktGTE9XX1RZUEUuSFlCUklEX1NFQVJDSF9XSVRIX1JBRyxcbiAgICAgIFdPUktGTE9XX1RZUEUuU0VNQU5USUNfU0VBUkNIX1VTSU5HX1NQQVJTRV9FTkNPREVSUyxcbiAgICBdLmluY2x1ZGVzKHdvcmtmbG93VHlwZSlcbiAgKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlzUkFHVXNlQ2FzZSh3b3JrZmxvd1R5cGU/OiBXT1JLRkxPV19UWVBFKTogYm9vbGVhbiB7XG4gIHJldHVybiAoXG4gICAgd29ya2Zsb3dUeXBlICE9PSB1bmRlZmluZWQgJiZcbiAgICBbXG4gICAgICBXT1JLRkxPV19UWVBFLlZFQ1RPUl9TRUFSQ0hfV0lUSF9SQUcsXG4gICAgICBXT1JLRkxPV19UWVBFLkhZQlJJRF9TRUFSQ0hfV0lUSF9SQUcsXG4gICAgXS5pbmNsdWRlcyh3b3JrZmxvd1R5cGUpXG4gICk7XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7OztBQUtBLElBQUFBLE9BQUEsR0FBQUMsc0JBQUEsQ0FBQUMsT0FBQTtBQUNBLElBQUFDLENBQUEsR0FBQUQsT0FBQTtBQUNBLElBQUFFLE9BQUEsR0FBQUYsT0FBQTtBQUFpQyxTQUFBRCx1QkFBQUksQ0FBQSxXQUFBQSxDQUFBLElBQUFBLENBQUEsQ0FBQUMsVUFBQSxHQUFBRCxDQUFBLEtBQUFFLE9BQUEsRUFBQUYsQ0FBQTtBQVBqQztBQUNBO0FBQ0E7QUFDQTs7QUFNTyxTQUFTRyxlQUFlQSxDQUFDQyxlQUF1QixFQUFVO0VBQy9ELE9BQU8sSUFBQUMsZUFBTSxFQUFDLElBQUlDLElBQUksQ0FBQ0YsZUFBZSxDQUFDLENBQUMsQ0FBQ0csTUFBTSxDQUFDQyxxQkFBbUIsQ0FBQztBQUN0RTtBQUVBLE1BQU1DLHlCQUF5QixHQUFHLGlFQUFpRTtBQUU1RixNQUFNQyxvQkFBb0IsR0FBSUMsZUFBdUIsSUFBSztFQUMvRCxJQUFJLElBQUFDLGVBQU8sRUFBQ0QsZUFBZSxDQUFDLElBQUlBLGVBQWUsS0FBSyxXQUFXLEVBQUU7SUFDL0QsT0FBTyw0QkFBNEI7RUFDckM7RUFDQSxNQUFNRSxLQUFLLEdBQUdGLGVBQWUsQ0FBQ0UsS0FBSyxDQUFDSix5QkFBeUIsQ0FBQztFQUM5RCxJQUFJLElBQUFHLGVBQU8sRUFBQ0MsS0FBSyxDQUFDLEVBQUU7SUFDbEIsT0FBT0YsZUFBZTtFQUN4QixDQUFDLE1BQU07SUFDTCxPQUFRLFFBQU9FLEtBQUssQ0FBQyxDQUFDLENBQUUsMkJBQTBCQSxLQUFLLENBQUMsQ0FBQyxDQUFFLElBQUc7RUFDaEU7QUFDRixDQUFDO0FBQUNDLE9BQUEsQ0FBQUosb0JBQUEsR0FBQUEsb0JBQUE7QUFFSyxTQUFTSyx5QkFBeUJBLENBQ3ZDQyxLQUF5QixFQUN6QkMsS0FBYSxFQUNMO0VBQ1IsT0FBT0QsS0FBSyxLQUFLRSxTQUFTLEdBQ3RCRixLQUFLLENBQUNHLE1BQU0sR0FBR0YsS0FBSyxHQUNsQkQsS0FBSyxDQUFDSSxTQUFTLENBQUMsQ0FBQyxFQUFFSCxLQUFLLEdBQUcsQ0FBQyxDQUFDLEdBQUcsS0FBSyxHQUNyQ0QsS0FBSyxHQUNQLEVBQUU7QUFDUjtBQUVPLFNBQVNLLGVBQWVBLENBQUNDLE9BQWdCLEVBQVU7RUFDeEQsT0FBT0MsSUFBSSxDQUFDQyxTQUFTLENBQUNGLE9BQU8sRUFBRUosU0FBUyxFQUFFLENBQUMsQ0FBQztBQUM5QztBQUVPLFNBQVNPLHlCQUF5QkEsQ0FBQ0gsT0FBVyxFQUFVO0VBQzdELE9BQU9DLElBQUksQ0FBQ0MsU0FBUyxDQUFDRixPQUFPLEVBQUVKLFNBQVMsRUFBRSxDQUFDLENBQUM7QUFDOUM7QUFFTyxTQUFTUSxxQkFBcUJBLENBQUNDLFlBQTRCLEVBQVc7RUFDM0UsT0FDRUEsWUFBWSxLQUFLVCxTQUFTLElBQzFCLENBQ0VVLGVBQWEsQ0FBQ0MsZUFBZSxFQUM3QkQsZUFBYSxDQUFDRSxpQkFBaUIsRUFDL0JGLGVBQWEsQ0FBQ0csYUFBYSxFQUMzQkgsZUFBYSxDQUFDSSxzQkFBc0IsRUFDcENKLGVBQWEsQ0FBQ0ssc0JBQXNCLEVBQ3BDTCxlQUFhLENBQUNNLHFDQUFxQyxDQUNwRCxDQUFDQyxRQUFRLENBQUNSLFlBQVksQ0FBQztBQUU1QjtBQUVPLFNBQVNTLFlBQVlBLENBQUNULFlBQTRCLEVBQVc7RUFDbEUsT0FDRUEsWUFBWSxLQUFLVCxTQUFTLElBQzFCLENBQ0VVLGVBQWEsQ0FBQ0ksc0JBQXNCLEVBQ3BDSixlQUFhLENBQUNLLHNCQUFzQixDQUNyQyxDQUFDRSxRQUFRLENBQUNSLFlBQVksQ0FBQztBQUU1QiJ9