"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securityAnalyticsPlugin = securityAnalyticsPlugin;
var _constants = require("../utils/constants");
var _addAlertsMethods = require("./addAlertsMethods");
var _addDetectorMethods = require("./addDetectorMethods");
var _addFieldMappingMethods = require("./addFieldMappingMethods");
var _addFindingsMethods = require("./addFindingsMethods");
var _addRuleMethods = require("./addRuleMethods");
var _addNotificationsMethods = require("./addNotificationsMethods");
var _addCorrelationMethods = require("./addCorrelationMethods");
var _addLogTypeMethods = require("./addLogTypeMethods");
var _addThreatIntelMethods = require("./addThreatIntelMethods");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function securityAnalyticsPlugin(Client, config, components) {
  const createAction = components.clientAction.factory;
  Client.prototype[_constants.PLUGIN_PROPERTY_NAME] = components.clientAction.namespaceFactory();
  const securityAnalytics = Client.prototype[_constants.PLUGIN_PROPERTY_NAME].prototype;
  (0, _addDetectorMethods.addDetectorMethods)(securityAnalytics, createAction);
  (0, _addCorrelationMethods.addCorrelationMethods)(securityAnalytics, createAction);
  (0, _addFieldMappingMethods.addFieldMappingMethods)(securityAnalytics, createAction);
  (0, _addFindingsMethods.addFindingsMethods)(securityAnalytics, createAction);
  (0, _addAlertsMethods.addAlertsMethods)(securityAnalytics, createAction);
  (0, _addRuleMethods.addRulesMethods)(securityAnalytics, createAction);
  (0, _addNotificationsMethods.addNotificationsMethods)(securityAnalytics, createAction);
  (0, _addLogTypeMethods.addLogTypeMethods)(securityAnalytics, createAction);
  (0, _addThreatIntelMethods.addThreatIntelMethods)(securityAnalytics, createAction);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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