--------------------------------------------------------------------------------
# `__BuiltinArithmeticType.init`

## Signature 

```
__BuiltinArithmeticType.init(int value);
```

## Parameters

* `value`

--------------------------------------------------------------------------------
# `__BuiltinFloatingPointType.init`

## Signature 

```
__BuiltinFloatingPointType.init(float value);
```

## Parameters

* `value`

--------------------------------------------------------------------------------
# `__BuiltinFloatingPointType.getPi`

## Description

Get the value of the mathematical constant pi in this type.

## Signature 

```
__BuiltinFloatingPointType.This __BuiltinFloatingPointType.getPi();
```

--------------------------------------------------------------------------------
# `struct ConstantBuffer<T>`

## Generic Parameters

* `T`

--------------------------------------------------------------------------------
# `struct TextureBuffer<T>`

## Generic Parameters

* `T`

--------------------------------------------------------------------------------
# `struct ParameterBlock<T>`

## Generic Parameters

* `T`

--------------------------------------------------------------------------------
# `struct SamplerState`

## Description

Sampling state for filtered texture fetches.

--------------------------------------------------------------------------------
# `struct SamplerComparisonState`

## Description

Sampling state for filtered texture fetches that include a comparison operation before filtering.

--------------------------------------------------------------------------------
# `struct Texture1D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `Texture1D<T>.CalculateLevelOfDetail`

## Signature 

```
float Texture1D<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,1>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `Texture1D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float Texture1D<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,1>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `Texture1D<T>.GetDimensions`

## Signature 

```
void Texture1D<T>.GetDimensions(out uint width);
void Texture1D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             numberOfLevels);
void Texture1D<T>.GetDimensions(out float width);
void Texture1D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Texture1D<T>.Load`

## Signature 

```
/// See Availability 1
T Texture1D<T>.Load(vector<int,2> location);
/// See Availability 2
T Texture1D<T>.Load(
    vector<int,2>        location,
    vector<int,1>        offset);
/// See Availability 3
T Texture1D<T>.Load(
    vector<int,2>        location,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** **CUDA** 
2. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Texture1D<T>.subscript`

## Signature 

```
T Texture1D<T>.subscript(uint location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `Texture1D<T>.Sample`

## Signature 

```
/// See Availability 1
T Texture1D<T>.Sample(
    SamplerState         s,
    vector<float,1>      location);
/// See Availability 2
T Texture1D<T>.Sample(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 3
T Texture1D<T>.Sample(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    float                clamp);
T Texture1D<T>.Sample(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `Texture1D<T>.SampleBias`

## Signature 

```
T Texture1D<T>.SampleBias(
    SamplerState         s,
    vector<float,1>      location,
    float                bias);
T Texture1D<T>.SampleBias(
    SamplerState         s,
    vector<float,1>      location,
    float                bias,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `Texture1D<T>.SampleCmp`

## Signature 

```
float Texture1D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue);
float Texture1D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Texture1D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float Texture1D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue);
/// See Availability 2
float Texture1D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Texture1D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T Texture1D<T>.SampleGrad(
    SamplerState         s,
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY);
T Texture1D<T>.SampleGrad(
    SamplerState         s,
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset);
/// See Availability 2
T Texture1D<T>.SampleGrad(
    SamplerState         s,
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `Texture1D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T Texture1D<T>.SampleLevel(
    SamplerState         s,
    vector<float,1>      location,
    float                level);
/// See Availability 2
T Texture1D<T>.SampleLevel(
    SamplerState         s,
    vector<float,1>      location,
    float                level,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension Texture1D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture1D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture1D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture1D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture1D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Texture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Texture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Texture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Texture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Texture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RWTexture1D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RWTexture1D<T>.CalculateLevelOfDetail`

## Signature 

```
float RWTexture1D<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,1>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RWTexture1D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RWTexture1D<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,1>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RWTexture1D<T>.GetDimensions`

## Signature 

```
void RWTexture1D<T>.GetDimensions(out uint width);
void RWTexture1D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             numberOfLevels);
void RWTexture1D<T>.GetDimensions(out float width);
void RWTexture1D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWTexture1D<T>.Load`

## Signature 

```
/// See Availability 1
T RWTexture1D<T>.Load(vector<int,1> location);
/// See Availability 2
T RWTexture1D<T>.Load(
    vector<int,1>        location,
    vector<int,1>        offset);
/// See Availability 3
T RWTexture1D<T>.Load(
    vector<int,1>        location,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** **CUDA** 
2. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWTexture1D<T>.subscript`

## Signature 

```
T RWTexture1D<T>.subscript(uint location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RWTexture1D<T>.Sample`

## Signature 

```
/// See Availability 1
T RWTexture1D<T>.Sample(
    SamplerState         s,
    vector<float,1>      location);
/// See Availability 2
T RWTexture1D<T>.Sample(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 3
T RWTexture1D<T>.Sample(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    float                clamp);
T RWTexture1D<T>.Sample(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RWTexture1D<T>.SampleBias`

## Signature 

```
T RWTexture1D<T>.SampleBias(
    SamplerState         s,
    vector<float,1>      location,
    float                bias);
T RWTexture1D<T>.SampleBias(
    SamplerState         s,
    vector<float,1>      location,
    float                bias,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture1D<T>.SampleCmp`

## Signature 

```
float RWTexture1D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue);
float RWTexture1D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture1D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RWTexture1D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue);
/// See Availability 2
float RWTexture1D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture1D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RWTexture1D<T>.SampleGrad(
    SamplerState         s,
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY);
T RWTexture1D<T>.SampleGrad(
    SamplerState         s,
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset);
/// See Availability 2
T RWTexture1D<T>.SampleGrad(
    SamplerState         s,
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RWTexture1D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RWTexture1D<T>.SampleLevel(
    SamplerState         s,
    vector<float,1>      location,
    float                level);
/// See Availability 2
T RWTexture1D<T>.SampleLevel(
    SamplerState         s,
    vector<float,1>      location,
    float                level,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RWTexture1D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture1D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture1D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture1D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture1D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedTexture1D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D<T>.CalculateLevelOfDetail`

## Signature 

```
float RasterizerOrderedTexture1D<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,1>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RasterizerOrderedTexture1D<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,1>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedTexture1D<T>.GetDimensions(out uint width);
void RasterizerOrderedTexture1D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             numberOfLevels);
void RasterizerOrderedTexture1D<T>.GetDimensions(out float width);
void RasterizerOrderedTexture1D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture1D<T>.Load(vector<int,1> location);
T RasterizerOrderedTexture1D<T>.Load(
    vector<int,1>        location,
    vector<int,1>        offset);
/// See Availability 2
T RasterizerOrderedTexture1D<T>.Load(
    vector<int,1>        location,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D<T>.subscript`

## Signature 

```
T RasterizerOrderedTexture1D<T>.subscript(uint location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D<T>.Sample`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture1D<T>.Sample(
    SamplerState         s,
    vector<float,1>      location);
/// See Availability 2
T RasterizerOrderedTexture1D<T>.Sample(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 3
T RasterizerOrderedTexture1D<T>.Sample(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    float                clamp);
T RasterizerOrderedTexture1D<T>.Sample(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D<T>.SampleBias`

## Signature 

```
T RasterizerOrderedTexture1D<T>.SampleBias(
    SamplerState         s,
    vector<float,1>      location,
    float                bias);
T RasterizerOrderedTexture1D<T>.SampleBias(
    SamplerState         s,
    vector<float,1>      location,
    float                bias,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D<T>.SampleCmp`

## Signature 

```
float RasterizerOrderedTexture1D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue);
float RasterizerOrderedTexture1D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RasterizerOrderedTexture1D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue);
/// See Availability 2
float RasterizerOrderedTexture1D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture1D<T>.SampleGrad(
    SamplerState         s,
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY);
T RasterizerOrderedTexture1D<T>.SampleGrad(
    SamplerState         s,
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset);
/// See Availability 2
T RasterizerOrderedTexture1D<T>.SampleGrad(
    SamplerState         s,
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture1D<T>.SampleLevel(
    SamplerState         s,
    vector<float,1>      location,
    float                level);
/// See Availability 2
T RasterizerOrderedTexture1D<T>.SampleLevel(
    SamplerState         s,
    vector<float,1>      location,
    float                level,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture1D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location);
vector<T,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location);
vector<float,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location);
vector<int,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1D.Gather(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1D.GatherRed(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1D.GatherGreen(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1D.GatherBlue(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location);
vector<uint,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1D.GatherAlpha(
    SamplerState         s,
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct Texture1DMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `Texture1DMS<T>.GetDimensions`

## Signature 

```
void Texture1DMS<T>.GetDimensions(
    out uint             width,
    out uint             sampleCount);
void Texture1DMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             sampleCount,
    out uint             numberOfLevels);
void Texture1DMS<T>.GetDimensions(
    out float            width,
    out float            sampleCount);
void Texture1DMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Texture1DMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> Texture1DMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `Texture1DMS<T>.Load`

## Signature 

```
/// See Availability 1
T Texture1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex);
T Texture1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex,
    vector<int,1>        offset);
/// See Availability 2
T Texture1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Texture1DMS<T>.subscript`

## Signature 

```
T Texture1DMS<T>.subscript(uint location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RWTexture1DMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RWTexture1DMS<T>.GetDimensions`

## Signature 

```
void RWTexture1DMS<T>.GetDimensions(
    out uint             width,
    out uint             sampleCount);
void RWTexture1DMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RWTexture1DMS<T>.GetDimensions(
    out float            width,
    out float            sampleCount);
void RWTexture1DMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWTexture1DMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RWTexture1DMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RWTexture1DMS<T>.Load`

## Signature 

```
/// See Availability 1
T RWTexture1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex);
T RWTexture1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex,
    vector<int,1>        offset);
/// See Availability 2
T RWTexture1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWTexture1DMS<T>.subscript`

## Signature 

```
T RWTexture1DMS<T>.subscript(uint location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedTexture1DMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DMS<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedTexture1DMS<T>.GetDimensions(
    out uint             width,
    out uint             sampleCount);
void RasterizerOrderedTexture1DMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RasterizerOrderedTexture1DMS<T>.GetDimensions(
    out float            width,
    out float            sampleCount);
void RasterizerOrderedTexture1DMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RasterizerOrderedTexture1DMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DMS<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex);
T RasterizerOrderedTexture1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex,
    vector<int,1>        offset);
/// See Availability 2
T RasterizerOrderedTexture1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DMS<T>.subscript`

## Signature 

```
T RasterizerOrderedTexture1DMS<T>.subscript(uint location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct Texture1DArray<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `Texture1DArray<T>.CalculateLevelOfDetail`

## Signature 

```
float Texture1DArray<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,1>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `Texture1DArray<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float Texture1DArray<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,1>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `Texture1DArray<T>.GetDimensions`

## Signature 

```
void Texture1DArray<T>.GetDimensions(
    out uint             width,
    out uint             elements);
void Texture1DArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             elements,
    out uint             numberOfLevels);
void Texture1DArray<T>.GetDimensions(
    out float            width,
    out float            elements);
void Texture1DArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            elements,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `elements`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Texture1DArray<T>.Load`

## Signature 

```
/// See Availability 1
T Texture1DArray<T>.Load(vector<int,3> location);
T Texture1DArray<T>.Load(
    vector<int,3>        location,
    vector<int,1>        offset);
/// See Availability 2
T Texture1DArray<T>.Load(
    vector<int,3>        location,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Texture1DArray<T>.subscript`

## Signature 

```
T Texture1DArray<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `Texture1DArray<T>.Sample`

## Signature 

```
/// See Availability 1
T Texture1DArray<T>.Sample(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
T Texture1DArray<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 3
T Texture1DArray<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    float                clamp);
T Texture1DArray<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `Texture1DArray<T>.SampleBias`

## Signature 

```
T Texture1DArray<T>.SampleBias(
    SamplerState         s,
    vector<float,2>      location,
    float                bias);
T Texture1DArray<T>.SampleBias(
    SamplerState         s,
    vector<float,2>      location,
    float                bias,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `Texture1DArray<T>.SampleCmp`

## Signature 

```
float Texture1DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
float Texture1DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Texture1DArray<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float Texture1DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
/// See Availability 2
float Texture1DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Texture1DArray<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T Texture1DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY);
T Texture1DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset);
/// See Availability 2
T Texture1DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `Texture1DArray<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T Texture1DArray<T>.SampleLevel(
    SamplerState         s,
    vector<float,2>      location,
    float                level);
/// See Availability 2
T Texture1DArray<T>.SampleLevel(
    SamplerState         s,
    vector<float,2>      location,
    float                level,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension Texture1DArray`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Texture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Texture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Texture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Texture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Texture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RWTexture1DArray<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RWTexture1DArray<T>.CalculateLevelOfDetail`

## Signature 

```
float RWTexture1DArray<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,1>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RWTexture1DArray<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RWTexture1DArray<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,1>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RWTexture1DArray<T>.GetDimensions`

## Signature 

```
void RWTexture1DArray<T>.GetDimensions(
    out uint             width,
    out uint             elements);
void RWTexture1DArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             elements,
    out uint             numberOfLevels);
void RWTexture1DArray<T>.GetDimensions(
    out float            width,
    out float            elements);
void RWTexture1DArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            elements,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `elements`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWTexture1DArray<T>.Load`

## Signature 

```
/// See Availability 1
T RWTexture1DArray<T>.Load(vector<int,2> location);
/// See Availability 2
T RWTexture1DArray<T>.Load(
    vector<int,2>        location,
    vector<int,1>        offset);
/// See Availability 3
T RWTexture1DArray<T>.Load(
    vector<int,2>        location,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** **CUDA** 
2. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWTexture1DArray<T>.subscript`

## Signature 

```
T RWTexture1DArray<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RWTexture1DArray<T>.Sample`

## Signature 

```
/// See Availability 1
T RWTexture1DArray<T>.Sample(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
T RWTexture1DArray<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 3
T RWTexture1DArray<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    float                clamp);
T RWTexture1DArray<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RWTexture1DArray<T>.SampleBias`

## Signature 

```
T RWTexture1DArray<T>.SampleBias(
    SamplerState         s,
    vector<float,2>      location,
    float                bias);
T RWTexture1DArray<T>.SampleBias(
    SamplerState         s,
    vector<float,2>      location,
    float                bias,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture1DArray<T>.SampleCmp`

## Signature 

```
float RWTexture1DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
float RWTexture1DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture1DArray<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RWTexture1DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
/// See Availability 2
float RWTexture1DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture1DArray<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RWTexture1DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY);
T RWTexture1DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset);
/// See Availability 2
T RWTexture1DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RWTexture1DArray<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RWTexture1DArray<T>.SampleLevel(
    SamplerState         s,
    vector<float,2>      location,
    float                level);
/// See Availability 2
T RWTexture1DArray<T>.SampleLevel(
    SamplerState         s,
    vector<float,2>      location,
    float                level,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RWTexture1DArray`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedTexture1DArray<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray<T>.CalculateLevelOfDetail`

## Signature 

```
float RasterizerOrderedTexture1DArray<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,1>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RasterizerOrderedTexture1DArray<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,1>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedTexture1DArray<T>.GetDimensions(
    out uint             width,
    out uint             elements);
void RasterizerOrderedTexture1DArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             elements,
    out uint             numberOfLevels);
void RasterizerOrderedTexture1DArray<T>.GetDimensions(
    out float            width,
    out float            elements);
void RasterizerOrderedTexture1DArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            elements,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `elements`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture1DArray<T>.Load(vector<int,2> location);
T RasterizerOrderedTexture1DArray<T>.Load(
    vector<int,2>        location,
    vector<int,1>        offset);
/// See Availability 2
T RasterizerOrderedTexture1DArray<T>.Load(
    vector<int,2>        location,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray<T>.subscript`

## Signature 

```
T RasterizerOrderedTexture1DArray<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray<T>.Sample`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture1DArray<T>.Sample(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
T RasterizerOrderedTexture1DArray<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 3
T RasterizerOrderedTexture1DArray<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    float                clamp);
T RasterizerOrderedTexture1DArray<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray<T>.SampleBias`

## Signature 

```
T RasterizerOrderedTexture1DArray<T>.SampleBias(
    SamplerState         s,
    vector<float,2>      location,
    float                bias);
T RasterizerOrderedTexture1DArray<T>.SampleBias(
    SamplerState         s,
    vector<float,2>      location,
    float                bias,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray<T>.SampleCmp`

## Signature 

```
float RasterizerOrderedTexture1DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
float RasterizerOrderedTexture1DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RasterizerOrderedTexture1DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
/// See Availability 2
float RasterizerOrderedTexture1DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture1DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY);
T RasterizerOrderedTexture1DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset);
/// See Availability 2
T RasterizerOrderedTexture1DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture1DArray<T>.SampleLevel(
    SamplerState         s,
    vector<float,2>      location,
    float                level);
/// See Availability 2
T RasterizerOrderedTexture1DArray<T>.SampleLevel(
    SamplerState         s,
    vector<float,2>      location,
    float                level,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture1DArray`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
vector<T,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
vector<float,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
vector<int,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1DArray.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1DArray.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1DArray.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1DArray.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
vector<uint,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture1DArray.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct Texture1DMSArray<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `Texture1DMSArray<T>.GetDimensions`

## Signature 

```
void Texture1DMSArray<T>.GetDimensions(
    out uint             width,
    out uint             elements,
    out uint             sampleCount);
void Texture1DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             elements,
    out uint             sampleCount,
    out uint             numberOfLevels);
void Texture1DMSArray<T>.GetDimensions(
    out float            width,
    out float            elements,
    out float            sampleCount);
void Texture1DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            elements,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `elements`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Texture1DMSArray<T>.GetSamplePosition`

## Signature 

```
vector<float,2> Texture1DMSArray<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `Texture1DMSArray<T>.Load`

## Signature 

```
/// See Availability 1
T Texture1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex);
T Texture1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,1>        offset);
/// See Availability 2
T Texture1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Texture1DMSArray<T>.subscript`

## Signature 

```
T Texture1DMSArray<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RWTexture1DMSArray<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RWTexture1DMSArray<T>.GetDimensions`

## Signature 

```
void RWTexture1DMSArray<T>.GetDimensions(
    out uint             width,
    out uint             elements,
    out uint             sampleCount);
void RWTexture1DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             elements,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RWTexture1DMSArray<T>.GetDimensions(
    out float            width,
    out float            elements,
    out float            sampleCount);
void RWTexture1DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            elements,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `elements`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWTexture1DMSArray<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RWTexture1DMSArray<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RWTexture1DMSArray<T>.Load`

## Signature 

```
/// See Availability 1
T RWTexture1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex);
T RWTexture1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,1>        offset);
/// See Availability 2
T RWTexture1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWTexture1DMSArray<T>.subscript`

## Signature 

```
T RWTexture1DMSArray<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedTexture1DMSArray<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DMSArray<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedTexture1DMSArray<T>.GetDimensions(
    out uint             width,
    out uint             elements,
    out uint             sampleCount);
void RasterizerOrderedTexture1DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             elements,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RasterizerOrderedTexture1DMSArray<T>.GetDimensions(
    out float            width,
    out float            elements,
    out float            sampleCount);
void RasterizerOrderedTexture1DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            elements,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `elements`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DMSArray<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RasterizerOrderedTexture1DMSArray<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DMSArray<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex);
T RasterizerOrderedTexture1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,1>        offset);
/// See Availability 2
T RasterizerOrderedTexture1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture1DMSArray<T>.subscript`

## Signature 

```
T RasterizerOrderedTexture1DMSArray<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct Texture2D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `Texture2D<T>.CalculateLevelOfDetail`

## Signature 

```
float Texture2D<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,2>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `Texture2D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float Texture2D<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,2>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `Texture2D<T>.GetDimensions`

## Signature 

```
void Texture2D<T>.GetDimensions(
    out uint             width,
    out uint             height);
void Texture2D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             numberOfLevels);
void Texture2D<T>.GetDimensions(
    out float            width,
    out float            height);
void Texture2D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Texture2D<T>.Load`

## Signature 

```
/// See Availability 1
T Texture2D<T>.Load(vector<int,3> location);
T Texture2D<T>.Load(
    vector<int,3>        location,
    vector<int,2>        offset);
/// See Availability 2
T Texture2D<T>.Load(
    vector<int,3>        location,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Texture2D<T>.subscript`

## Signature 

```
T Texture2D<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `Texture2D<T>.Sample`

## Signature 

```
/// See Availability 1
T Texture2D<T>.Sample(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
T Texture2D<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
T Texture2D<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    float                clamp);
T Texture2D<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `Texture2D<T>.SampleBias`

## Signature 

```
T Texture2D<T>.SampleBias(
    SamplerState         s,
    vector<float,2>      location,
    float                bias);
T Texture2D<T>.SampleBias(
    SamplerState         s,
    vector<float,2>      location,
    float                bias,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `Texture2D<T>.SampleCmp`

## Signature 

```
float Texture2D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
float Texture2D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Texture2D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float Texture2D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
/// See Availability 2
float Texture2D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Texture2D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T Texture2D<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY);
T Texture2D<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset);
/// See Availability 2
T Texture2D<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `Texture2D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T Texture2D<T>.SampleLevel(
    SamplerState         s,
    vector<float,2>      location,
    float                level);
/// See Availability 2
T Texture2D<T>.SampleLevel(
    SamplerState         s,
    vector<float,2>      location,
    float                level,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension Texture2D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture2D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture2D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture2D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture2D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Texture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Texture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Texture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Texture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Texture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RWTexture2D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RWTexture2D<T>.CalculateLevelOfDetail`

## Signature 

```
float RWTexture2D<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,2>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RWTexture2D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RWTexture2D<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,2>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RWTexture2D<T>.GetDimensions`

## Signature 

```
void RWTexture2D<T>.GetDimensions(
    out uint             width,
    out uint             height);
void RWTexture2D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             numberOfLevels);
void RWTexture2D<T>.GetDimensions(
    out float            width,
    out float            height);
void RWTexture2D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWTexture2D<T>.Load`

## Signature 

```
/// See Availability 1
T RWTexture2D<T>.Load(vector<int,2> location);
/// See Availability 2
T RWTexture2D<T>.Load(
    vector<int,2>        location,
    vector<int,2>        offset);
/// See Availability 3
T RWTexture2D<T>.Load(
    vector<int,2>        location,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** **CUDA** 
2. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWTexture2D<T>.subscript`

## Signature 

```
T RWTexture2D<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RWTexture2D<T>.Sample`

## Signature 

```
/// See Availability 1
T RWTexture2D<T>.Sample(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
T RWTexture2D<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
T RWTexture2D<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    float                clamp);
T RWTexture2D<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RWTexture2D<T>.SampleBias`

## Signature 

```
T RWTexture2D<T>.SampleBias(
    SamplerState         s,
    vector<float,2>      location,
    float                bias);
T RWTexture2D<T>.SampleBias(
    SamplerState         s,
    vector<float,2>      location,
    float                bias,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture2D<T>.SampleCmp`

## Signature 

```
float RWTexture2D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
float RWTexture2D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture2D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RWTexture2D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
/// See Availability 2
float RWTexture2D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture2D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RWTexture2D<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY);
T RWTexture2D<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset);
/// See Availability 2
T RWTexture2D<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RWTexture2D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RWTexture2D<T>.SampleLevel(
    SamplerState         s,
    vector<float,2>      location,
    float                level);
/// See Availability 2
T RWTexture2D<T>.SampleLevel(
    SamplerState         s,
    vector<float,2>      location,
    float                level,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RWTexture2D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture2D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture2D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture2D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture2D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedTexture2D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D<T>.CalculateLevelOfDetail`

## Signature 

```
float RasterizerOrderedTexture2D<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,2>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RasterizerOrderedTexture2D<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,2>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedTexture2D<T>.GetDimensions(
    out uint             width,
    out uint             height);
void RasterizerOrderedTexture2D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             numberOfLevels);
void RasterizerOrderedTexture2D<T>.GetDimensions(
    out float            width,
    out float            height);
void RasterizerOrderedTexture2D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture2D<T>.Load(vector<int,2> location);
T RasterizerOrderedTexture2D<T>.Load(
    vector<int,2>        location,
    vector<int,2>        offset);
/// See Availability 2
T RasterizerOrderedTexture2D<T>.Load(
    vector<int,2>        location,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D<T>.subscript`

## Signature 

```
T RasterizerOrderedTexture2D<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D<T>.Sample`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture2D<T>.Sample(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
T RasterizerOrderedTexture2D<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
T RasterizerOrderedTexture2D<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    float                clamp);
T RasterizerOrderedTexture2D<T>.Sample(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D<T>.SampleBias`

## Signature 

```
T RasterizerOrderedTexture2D<T>.SampleBias(
    SamplerState         s,
    vector<float,2>      location,
    float                bias);
T RasterizerOrderedTexture2D<T>.SampleBias(
    SamplerState         s,
    vector<float,2>      location,
    float                bias,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D<T>.SampleCmp`

## Signature 

```
float RasterizerOrderedTexture2D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
float RasterizerOrderedTexture2D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RasterizerOrderedTexture2D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
/// See Availability 2
float RasterizerOrderedTexture2D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture2D<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY);
T RasterizerOrderedTexture2D<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset);
/// See Availability 2
T RasterizerOrderedTexture2D<T>.SampleGrad(
    SamplerState         s,
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture2D<T>.SampleLevel(
    SamplerState         s,
    vector<float,2>      location,
    float                level);
/// See Availability 2
T RasterizerOrderedTexture2D<T>.SampleLevel(
    SamplerState         s,
    vector<float,2>      location,
    float                level,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture2D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2D.Gather(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2D.GatherRed(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2D.GatherGreen(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2D.GatherBlue(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2D.GatherAlpha(
    SamplerState         s,
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct Texture2DMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `Texture2DMS<T>.GetDimensions`

## Signature 

```
void Texture2DMS<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             sampleCount);
void Texture2DMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             sampleCount,
    out uint             numberOfLevels);
void Texture2DMS<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            sampleCount);
void Texture2DMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Texture2DMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> Texture2DMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `Texture2DMS<T>.Load`

## Signature 

```
/// See Availability 1
T Texture2DMS<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex);
T Texture2DMS<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,2>        offset);
/// See Availability 2
T Texture2DMS<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Texture2DMS<T>.subscript`

## Signature 

```
T Texture2DMS<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RWTexture2DMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RWTexture2DMS<T>.GetDimensions`

## Signature 

```
void RWTexture2DMS<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             sampleCount);
void RWTexture2DMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RWTexture2DMS<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            sampleCount);
void RWTexture2DMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWTexture2DMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RWTexture2DMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RWTexture2DMS<T>.Load`

## Signature 

```
/// See Availability 1
T RWTexture2DMS<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex);
T RWTexture2DMS<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,2>        offset);
/// See Availability 2
T RWTexture2DMS<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWTexture2DMS<T>.subscript`

## Signature 

```
T RWTexture2DMS<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedTexture2DMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DMS<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedTexture2DMS<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             sampleCount);
void RasterizerOrderedTexture2DMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RasterizerOrderedTexture2DMS<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            sampleCount);
void RasterizerOrderedTexture2DMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RasterizerOrderedTexture2DMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DMS<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture2DMS<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex);
T RasterizerOrderedTexture2DMS<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,2>        offset);
/// See Availability 2
T RasterizerOrderedTexture2DMS<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DMS<T>.subscript`

## Signature 

```
T RasterizerOrderedTexture2DMS<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct Texture2DArray<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `Texture2DArray<T>.CalculateLevelOfDetail`

## Signature 

```
float Texture2DArray<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,2>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `Texture2DArray<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float Texture2DArray<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,2>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `Texture2DArray<T>.GetDimensions`

## Signature 

```
void Texture2DArray<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             elements);
void Texture2DArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             numberOfLevels);
void Texture2DArray<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            elements);
void Texture2DArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            elements,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `elements`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Texture2DArray<T>.Load`

## Signature 

```
/// See Availability 1
T Texture2DArray<T>.Load(vector<int,4> location);
T Texture2DArray<T>.Load(
    vector<int,4>        location,
    vector<int,2>        offset);
/// See Availability 2
T Texture2DArray<T>.Load(
    vector<int,4>        location,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Texture2DArray<T>.subscript`

## Signature 

```
T Texture2DArray<T>.subscript(vector<uint,3> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `Texture2DArray<T>.Sample`

## Signature 

```
/// See Availability 1
T Texture2DArray<T>.Sample(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
T Texture2DArray<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
T Texture2DArray<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    float                clamp);
T Texture2DArray<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `Texture2DArray<T>.SampleBias`

## Signature 

```
T Texture2DArray<T>.SampleBias(
    SamplerState         s,
    vector<float,3>      location,
    float                bias);
T Texture2DArray<T>.SampleBias(
    SamplerState         s,
    vector<float,3>      location,
    float                bias,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `Texture2DArray<T>.SampleCmp`

## Signature 

```
float Texture2DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
float Texture2DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Texture2DArray<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float Texture2DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
/// See Availability 2
float Texture2DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Texture2DArray<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T Texture2DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY);
T Texture2DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset);
/// See Availability 2
T Texture2DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `Texture2DArray<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T Texture2DArray<T>.SampleLevel(
    SamplerState         s,
    vector<float,3>      location,
    float                level);
/// See Availability 2
T Texture2DArray<T>.SampleLevel(
    SamplerState         s,
    vector<float,3>      location,
    float                level,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension Texture2DArray`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture2DArray.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture2DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture2DArray.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture2DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture2DArray.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture2DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture2DArray.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Texture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Texture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Texture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Texture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture2DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Texture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RWTexture2DArray<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RWTexture2DArray<T>.CalculateLevelOfDetail`

## Signature 

```
float RWTexture2DArray<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,2>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RWTexture2DArray<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RWTexture2DArray<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,2>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RWTexture2DArray<T>.GetDimensions`

## Signature 

```
void RWTexture2DArray<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             elements);
void RWTexture2DArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             numberOfLevels);
void RWTexture2DArray<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            elements);
void RWTexture2DArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            elements,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `elements`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWTexture2DArray<T>.Load`

## Signature 

```
/// See Availability 1
T RWTexture2DArray<T>.Load(vector<int,3> location);
/// See Availability 2
T RWTexture2DArray<T>.Load(
    vector<int,3>        location,
    vector<int,2>        offset);
/// See Availability 3
T RWTexture2DArray<T>.Load(
    vector<int,3>        location,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** **CUDA** 
2. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWTexture2DArray<T>.subscript`

## Signature 

```
T RWTexture2DArray<T>.subscript(vector<uint,3> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RWTexture2DArray<T>.Sample`

## Signature 

```
/// See Availability 1
T RWTexture2DArray<T>.Sample(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
T RWTexture2DArray<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
T RWTexture2DArray<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    float                clamp);
T RWTexture2DArray<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RWTexture2DArray<T>.SampleBias`

## Signature 

```
T RWTexture2DArray<T>.SampleBias(
    SamplerState         s,
    vector<float,3>      location,
    float                bias);
T RWTexture2DArray<T>.SampleBias(
    SamplerState         s,
    vector<float,3>      location,
    float                bias,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture2DArray<T>.SampleCmp`

## Signature 

```
float RWTexture2DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
float RWTexture2DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture2DArray<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RWTexture2DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
/// See Availability 2
float RWTexture2DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture2DArray<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RWTexture2DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY);
T RWTexture2DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset);
/// See Availability 2
T RWTexture2DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RWTexture2DArray<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RWTexture2DArray<T>.SampleLevel(
    SamplerState         s,
    vector<float,3>      location,
    float                level);
/// See Availability 2
T RWTexture2DArray<T>.SampleLevel(
    SamplerState         s,
    vector<float,3>      location,
    float                level,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RWTexture2DArray`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture2DArray.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture2DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture2DArray.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture2DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture2DArray.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture2DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture2DArray.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture2DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedTexture2DArray<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray<T>.CalculateLevelOfDetail`

## Signature 

```
float RasterizerOrderedTexture2DArray<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,2>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RasterizerOrderedTexture2DArray<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,2>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedTexture2DArray<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             elements);
void RasterizerOrderedTexture2DArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             numberOfLevels);
void RasterizerOrderedTexture2DArray<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            elements);
void RasterizerOrderedTexture2DArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            elements,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `elements`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture2DArray<T>.Load(vector<int,3> location);
T RasterizerOrderedTexture2DArray<T>.Load(
    vector<int,3>        location,
    vector<int,2>        offset);
/// See Availability 2
T RasterizerOrderedTexture2DArray<T>.Load(
    vector<int,3>        location,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray<T>.subscript`

## Signature 

```
T RasterizerOrderedTexture2DArray<T>.subscript(vector<uint,3> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray<T>.Sample`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture2DArray<T>.Sample(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
T RasterizerOrderedTexture2DArray<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
T RasterizerOrderedTexture2DArray<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    float                clamp);
T RasterizerOrderedTexture2DArray<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray<T>.SampleBias`

## Signature 

```
T RasterizerOrderedTexture2DArray<T>.SampleBias(
    SamplerState         s,
    vector<float,3>      location,
    float                bias);
T RasterizerOrderedTexture2DArray<T>.SampleBias(
    SamplerState         s,
    vector<float,3>      location,
    float                bias,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray<T>.SampleCmp`

## Signature 

```
float RasterizerOrderedTexture2DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
float RasterizerOrderedTexture2DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RasterizerOrderedTexture2DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
/// See Availability 2
float RasterizerOrderedTexture2DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture2DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY);
T RasterizerOrderedTexture2DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset);
/// See Availability 2
T RasterizerOrderedTexture2DArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture2DArray<T>.SampleLevel(
    SamplerState         s,
    vector<float,3>      location,
    float                level);
/// See Availability 2
T RasterizerOrderedTexture2DArray<T>.SampleLevel(
    SamplerState         s,
    vector<float,3>      location,
    float                level,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture2DArray`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture2DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture2DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture2DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2DArray.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2DArray.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2DArray.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2DArray.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedTexture2DArray.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct Texture2DMSArray<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `Texture2DMSArray<T>.GetDimensions`

## Signature 

```
void Texture2DMSArray<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             sampleCount);
void Texture2DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             sampleCount,
    out uint             numberOfLevels);
void Texture2DMSArray<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            elements,
    out float            sampleCount);
void Texture2DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            elements,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `elements`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Texture2DMSArray<T>.GetSamplePosition`

## Signature 

```
vector<float,2> Texture2DMSArray<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `Texture2DMSArray<T>.Load`

## Signature 

```
/// See Availability 1
T Texture2DMSArray<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex);
T Texture2DMSArray<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,2>        offset);
/// See Availability 2
T Texture2DMSArray<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Texture2DMSArray<T>.subscript`

## Signature 

```
T Texture2DMSArray<T>.subscript(vector<uint,3> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RWTexture2DMSArray<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RWTexture2DMSArray<T>.GetDimensions`

## Signature 

```
void RWTexture2DMSArray<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             sampleCount);
void RWTexture2DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RWTexture2DMSArray<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            elements,
    out float            sampleCount);
void RWTexture2DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            elements,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `elements`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWTexture2DMSArray<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RWTexture2DMSArray<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RWTexture2DMSArray<T>.Load`

## Signature 

```
/// See Availability 1
T RWTexture2DMSArray<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex);
T RWTexture2DMSArray<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,2>        offset);
/// See Availability 2
T RWTexture2DMSArray<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWTexture2DMSArray<T>.subscript`

## Signature 

```
T RWTexture2DMSArray<T>.subscript(vector<uint,3> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedTexture2DMSArray<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DMSArray<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedTexture2DMSArray<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             sampleCount);
void RasterizerOrderedTexture2DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RasterizerOrderedTexture2DMSArray<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            elements,
    out float            sampleCount);
void RasterizerOrderedTexture2DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            elements,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `elements`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DMSArray<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RasterizerOrderedTexture2DMSArray<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DMSArray<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture2DMSArray<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex);
T RasterizerOrderedTexture2DMSArray<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,2>        offset);
/// See Availability 2
T RasterizerOrderedTexture2DMSArray<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture2DMSArray<T>.subscript`

## Signature 

```
T RasterizerOrderedTexture2DMSArray<T>.subscript(vector<uint,3> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct Texture3D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `Texture3D<T>.CalculateLevelOfDetail`

## Signature 

```
float Texture3D<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,3>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `Texture3D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float Texture3D<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,3>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `Texture3D<T>.GetDimensions`

## Signature 

```
void Texture3D<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             depth);
void Texture3D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             depth,
    out uint             numberOfLevels);
void Texture3D<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            depth);
void Texture3D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            depth,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `depth`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Texture3D<T>.Load`

## Signature 

```
/// See Availability 1
T Texture3D<T>.Load(vector<int,4> location);
T Texture3D<T>.Load(
    vector<int,4>        location,
    vector<int,3>        offset);
/// See Availability 2
T Texture3D<T>.Load(
    vector<int,4>        location,
    vector<int,3>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Texture3D<T>.subscript`

## Signature 

```
T Texture3D<T>.subscript(vector<uint,3> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `Texture3D<T>.Sample`

## Signature 

```
/// See Availability 1
T Texture3D<T>.Sample(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
T Texture3D<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 3
T Texture3D<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    float                clamp);
T Texture3D<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `Texture3D<T>.SampleBias`

## Signature 

```
T Texture3D<T>.SampleBias(
    SamplerState         s,
    vector<float,3>      location,
    float                bias);
T Texture3D<T>.SampleBias(
    SamplerState         s,
    vector<float,3>      location,
    float                bias,
    vector<int,3>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `Texture3D<T>.SampleCmp`

## Signature 

```
float Texture3D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
float Texture3D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue,
    vector<int,3>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Texture3D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float Texture3D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
/// See Availability 2
float Texture3D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue,
    vector<int,3>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Texture3D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T Texture3D<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,3>      gradX,
    vector<float,3>      gradY);
T Texture3D<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,3>      gradX,
    vector<float,3>      gradY,
    vector<int,3>        offset);
/// See Availability 2
T Texture3D<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,3>      gradX,
    vector<float,3>      gradY,
    vector<int,3>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `Texture3D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T Texture3D<T>.SampleLevel(
    SamplerState         s,
    vector<float,3>      location,
    float                level);
/// See Availability 2
T Texture3D<T>.SampleLevel(
    SamplerState         s,
    vector<float,3>      location,
    float                level,
    vector<int,3>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension Texture3D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture3D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture3D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture3D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture3D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture3D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Texture3D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Texture3D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> Texture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> Texture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> Texture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> Texture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Texture3D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> Texture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RWTexture3D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RWTexture3D<T>.CalculateLevelOfDetail`

## Signature 

```
float RWTexture3D<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,3>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RWTexture3D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RWTexture3D<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,3>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RWTexture3D<T>.GetDimensions`

## Signature 

```
void RWTexture3D<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             depth);
void RWTexture3D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             depth,
    out uint             numberOfLevels);
void RWTexture3D<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            depth);
void RWTexture3D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            depth,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `depth`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWTexture3D<T>.Load`

## Signature 

```
/// See Availability 1
T RWTexture3D<T>.Load(vector<int,3> location);
/// See Availability 2
T RWTexture3D<T>.Load(
    vector<int,3>        location,
    vector<int,3>        offset);
/// See Availability 3
T RWTexture3D<T>.Load(
    vector<int,3>        location,
    vector<int,3>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** **CUDA** 
2. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWTexture3D<T>.subscript`

## Signature 

```
T RWTexture3D<T>.subscript(vector<uint,3> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RWTexture3D<T>.Sample`

## Signature 

```
/// See Availability 1
T RWTexture3D<T>.Sample(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
T RWTexture3D<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 3
T RWTexture3D<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    float                clamp);
T RWTexture3D<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RWTexture3D<T>.SampleBias`

## Signature 

```
T RWTexture3D<T>.SampleBias(
    SamplerState         s,
    vector<float,3>      location,
    float                bias);
T RWTexture3D<T>.SampleBias(
    SamplerState         s,
    vector<float,3>      location,
    float                bias,
    vector<int,3>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture3D<T>.SampleCmp`

## Signature 

```
float RWTexture3D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
float RWTexture3D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue,
    vector<int,3>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture3D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RWTexture3D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
/// See Availability 2
float RWTexture3D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue,
    vector<int,3>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWTexture3D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RWTexture3D<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,3>      gradX,
    vector<float,3>      gradY);
T RWTexture3D<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,3>      gradX,
    vector<float,3>      gradY,
    vector<int,3>        offset);
/// See Availability 2
T RWTexture3D<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,3>      gradX,
    vector<float,3>      gradY,
    vector<int,3>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RWTexture3D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RWTexture3D<T>.SampleLevel(
    SamplerState         s,
    vector<float,3>      location,
    float                level);
/// See Availability 2
T RWTexture3D<T>.SampleLevel(
    SamplerState         s,
    vector<float,3>      location,
    float                level,
    vector<int,3>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RWTexture3D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture3D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture3D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture3D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture3D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture3D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWTexture3D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWTexture3D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RWTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RWTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RWTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RWTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWTexture3D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RWTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedTexture3D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D<T>.CalculateLevelOfDetail`

## Signature 

```
float RasterizerOrderedTexture3D<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,3>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RasterizerOrderedTexture3D<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,3>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedTexture3D<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             depth);
void RasterizerOrderedTexture3D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             depth,
    out uint             numberOfLevels);
void RasterizerOrderedTexture3D<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            depth);
void RasterizerOrderedTexture3D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            depth,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `depth`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture3D<T>.Load(vector<int,3> location);
T RasterizerOrderedTexture3D<T>.Load(
    vector<int,3>        location,
    vector<int,3>        offset);
/// See Availability 2
T RasterizerOrderedTexture3D<T>.Load(
    vector<int,3>        location,
    vector<int,3>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D<T>.subscript`

## Signature 

```
T RasterizerOrderedTexture3D<T>.subscript(vector<uint,3> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D<T>.Sample`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture3D<T>.Sample(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
T RasterizerOrderedTexture3D<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 3
T RasterizerOrderedTexture3D<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    float                clamp);
T RasterizerOrderedTexture3D<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D<T>.SampleBias`

## Signature 

```
T RasterizerOrderedTexture3D<T>.SampleBias(
    SamplerState         s,
    vector<float,3>      location,
    float                bias);
T RasterizerOrderedTexture3D<T>.SampleBias(
    SamplerState         s,
    vector<float,3>      location,
    float                bias,
    vector<int,3>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D<T>.SampleCmp`

## Signature 

```
float RasterizerOrderedTexture3D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
float RasterizerOrderedTexture3D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue,
    vector<int,3>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RasterizerOrderedTexture3D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
/// See Availability 2
float RasterizerOrderedTexture3D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue,
    vector<int,3>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture3D<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,3>      gradX,
    vector<float,3>      gradY);
T RasterizerOrderedTexture3D<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,3>      gradX,
    vector<float,3>      gradY,
    vector<int,3>        offset);
/// See Availability 2
T RasterizerOrderedTexture3D<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,3>      gradX,
    vector<float,3>      gradY,
    vector<int,3>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture3D<T>.SampleLevel(
    SamplerState         s,
    vector<float,3>      location,
    float                level);
/// See Availability 2
T RasterizerOrderedTexture3D<T>.SampleLevel(
    SamplerState         s,
    vector<float,3>      location,
    float                level,
    vector<int,3>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture3D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture3D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture3D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTexture3D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture3D.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture3D.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture3D.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture3D.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTexture3D.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct Texture3DMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `Texture3DMS<T>.GetDimensions`

## Signature 

```
void Texture3DMS<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             depth,
    out uint             sampleCount);
void Texture3DMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             depth,
    out uint             sampleCount,
    out uint             numberOfLevels);
void Texture3DMS<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            depth,
    out float            sampleCount);
void Texture3DMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            depth,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `depth`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Texture3DMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> Texture3DMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `Texture3DMS<T>.Load`

## Signature 

```
/// See Availability 1
T Texture3DMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex);
T Texture3DMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,3>        offset);
/// See Availability 2
T Texture3DMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,3>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Texture3DMS<T>.subscript`

## Signature 

```
T Texture3DMS<T>.subscript(vector<uint,3> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RWTexture3DMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RWTexture3DMS<T>.GetDimensions`

## Signature 

```
void RWTexture3DMS<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             depth,
    out uint             sampleCount);
void RWTexture3DMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             depth,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RWTexture3DMS<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            depth,
    out float            sampleCount);
void RWTexture3DMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            depth,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `depth`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWTexture3DMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RWTexture3DMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RWTexture3DMS<T>.Load`

## Signature 

```
/// See Availability 1
T RWTexture3DMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex);
T RWTexture3DMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,3>        offset);
/// See Availability 2
T RWTexture3DMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,3>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWTexture3DMS<T>.subscript`

## Signature 

```
T RWTexture3DMS<T>.subscript(vector<uint,3> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedTexture3DMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3DMS<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedTexture3DMS<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             depth,
    out uint             sampleCount);
void RasterizerOrderedTexture3DMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             depth,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RasterizerOrderedTexture3DMS<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            depth,
    out float            sampleCount);
void RasterizerOrderedTexture3DMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            depth,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `depth`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3DMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RasterizerOrderedTexture3DMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3DMS<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTexture3DMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex);
T RasterizerOrderedTexture3DMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,3>        offset);
/// See Availability 2
T RasterizerOrderedTexture3DMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,3>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTexture3DMS<T>.subscript`

## Signature 

```
T RasterizerOrderedTexture3DMS<T>.subscript(vector<uint,3> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct TextureCube<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `TextureCube<T>.CalculateLevelOfDetail`

## Signature 

```
float TextureCube<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,3>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `TextureCube<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float TextureCube<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,3>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `TextureCube<T>.GetDimensions`

## Signature 

```
void TextureCube<T>.GetDimensions(
    out uint             width,
    out uint             height);
void TextureCube<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             numberOfLevels);
void TextureCube<T>.GetDimensions(
    out float            width,
    out float            height);
void TextureCube<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `TextureCube<T>.Load`

## Signature 

```
/// See Availability 1
T TextureCube<T>.Load(vector<int,4> location);
T TextureCube<T>.Load(
    vector<int,4>        location,
    vector<int,3>        offset);
/// See Availability 2
T TextureCube<T>.Load(
    vector<int,4>        location,
    vector<int,3>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `TextureCube<T>.Sample`

## Signature 

```
/// See Availability 1
T TextureCube<T>.Sample(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
T TextureCube<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    float                clamp);
T TextureCube<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `TextureCube<T>.SampleBias`

## Signature 

```
T TextureCube<T>.SampleBias(
    SamplerState         s,
    vector<float,3>      location,
    float                bias);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`

--------------------------------------------------------------------------------
# `TextureCube<T>.SampleCmp`

## Signature 

```
float TextureCube<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`

--------------------------------------------------------------------------------
# `TextureCube<T>.SampleCmpLevelZero`

## Signature 

```
float TextureCube<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`

--------------------------------------------------------------------------------
# `TextureCube<T>.SampleGrad`

## Signature 

```
T TextureCube<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,3>      gradX,
    vector<float,3>      gradY);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`

--------------------------------------------------------------------------------
# `TextureCube<T>.SampleLevel`

## Signature 

```
T TextureCube<T>.SampleLevel(
    SamplerState         s,
    vector<float,3>      location,
    float                level);
```

## Availability

**GLSL** **HLSL** **CUDA** 

## Parameters

* `s`
* `location`
* `level`

--------------------------------------------------------------------------------
# `extension TextureCube`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `TextureCube.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension TextureCube`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `TextureCube.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension TextureCube`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `TextureCube.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension TextureCube`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `TextureCube.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> TextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> TextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> TextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> TextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCube.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> TextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedTextureCube<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube<T>.CalculateLevelOfDetail`

## Signature 

```
float RasterizerOrderedTextureCube<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,3>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RasterizerOrderedTextureCube<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,3>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedTextureCube<T>.GetDimensions(
    out uint             width,
    out uint             height);
void RasterizerOrderedTextureCube<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             numberOfLevels);
void RasterizerOrderedTextureCube<T>.GetDimensions(
    out float            width,
    out float            height);
void RasterizerOrderedTextureCube<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTextureCube<T>.Load(vector<int,3> location);
T RasterizerOrderedTextureCube<T>.Load(
    vector<int,3>        location,
    vector<int,3>        offset);
/// See Availability 2
T RasterizerOrderedTextureCube<T>.Load(
    vector<int,3>        location,
    vector<int,3>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube<T>.Sample`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTextureCube<T>.Sample(
    SamplerState         s,
    vector<float,3>      location);
/// See Availability 2
T RasterizerOrderedTextureCube<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    float                clamp);
T RasterizerOrderedTextureCube<T>.Sample(
    SamplerState         s,
    vector<float,3>      location,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube<T>.SampleBias`

## Signature 

```
T RasterizerOrderedTextureCube<T>.SampleBias(
    SamplerState         s,
    vector<float,3>      location,
    float                bias);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube<T>.SampleCmp`

## Signature 

```
float RasterizerOrderedTextureCube<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube<T>.SampleCmpLevelZero`

## Signature 

```
float RasterizerOrderedTextureCube<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,3>      location,
    float                compareValue);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube<T>.SampleGrad`

## Signature 

```
T RasterizerOrderedTextureCube<T>.SampleGrad(
    SamplerState         s,
    vector<float,3>      location,
    vector<float,3>      gradX,
    vector<float,3>      gradY);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube<T>.SampleLevel`

## Signature 

```
T RasterizerOrderedTextureCube<T>.SampleLevel(
    SamplerState         s,
    vector<float,3>      location,
    float                level);
```

## Availability

**GLSL** **HLSL** **CUDA** 

## Parameters

* `s`
* `location`
* `level`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTextureCube`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<T,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTextureCube`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<float,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTextureCube`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<int,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTextureCube`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCube.Gather(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCube.GatherRed(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCube.GatherGreen(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCube.GatherBlue(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCube.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location);
vector<uint,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCube.GatherAlpha(
    SamplerState         s,
    vector<float,3>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct TextureCubeMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`

--------------------------------------------------------------------------------
# `TextureCubeMS<T>.GetDimensions`

## Signature 

```
void TextureCubeMS<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             sampleCount);
void TextureCubeMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             sampleCount,
    out uint             numberOfLevels);
void TextureCubeMS<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            sampleCount);
void TextureCubeMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `TextureCubeMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> TextureCubeMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `TextureCubeMS<T>.Load`

## Signature 

```
/// See Availability 1
T TextureCubeMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex);
T TextureCubeMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,3>        offset);
/// See Availability 2
T TextureCubeMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,3>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedTextureCubeMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeMS<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedTextureCubeMS<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             sampleCount);
void RasterizerOrderedTextureCubeMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RasterizerOrderedTextureCubeMS<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            sampleCount);
void RasterizerOrderedTextureCubeMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RasterizerOrderedTextureCubeMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeMS<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTextureCubeMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex);
T RasterizerOrderedTextureCubeMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,3>        offset);
/// See Availability 2
T RasterizerOrderedTextureCubeMS<T>.Load(
    vector<int,3>        location,
    int                  sampleIndex,
    vector<int,3>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `struct TextureCubeArray<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Sample`
* `SampleBias`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `TextureCubeArray<T>.CalculateLevelOfDetail`

## Signature 

```
float TextureCubeArray<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,3>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `TextureCubeArray<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float TextureCubeArray<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,3>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `TextureCubeArray<T>.GetDimensions`

## Signature 

```
void TextureCubeArray<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             elements);
void TextureCubeArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             numberOfLevels);
void TextureCubeArray<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            elements);
void TextureCubeArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            elements,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `elements`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `TextureCubeArray<T>.Sample`

## Signature 

```
/// See Availability 1
T TextureCubeArray<T>.Sample(
    SamplerState         s,
    vector<float,4>      location);
/// See Availability 2
T TextureCubeArray<T>.Sample(
    SamplerState         s,
    vector<float,4>      location,
    float                clamp);
T TextureCubeArray<T>.Sample(
    SamplerState         s,
    vector<float,4>      location,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `TextureCubeArray<T>.SampleBias`

## Signature 

```
T TextureCubeArray<T>.SampleBias(
    SamplerState         s,
    vector<float,4>      location,
    float                bias);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`

--------------------------------------------------------------------------------
# `TextureCubeArray<T>.SampleGrad`

## Signature 

```
T TextureCubeArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,4>      location,
    vector<float,3>      gradX,
    vector<float,3>      gradY);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`

--------------------------------------------------------------------------------
# `TextureCubeArray<T>.SampleLevel`

## Signature 

```
T TextureCubeArray<T>.SampleLevel(
    SamplerState         s,
    vector<float,4>      location,
    float                level);
```

## Availability

**GLSL** **HLSL** **CUDA** 

## Parameters

* `s`
* `location`
* `level`

--------------------------------------------------------------------------------
# `extension TextureCubeArray`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `TextureCubeArray.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location);
vector<T,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location);
vector<T,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location);
vector<T,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location);
vector<T,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location);
vector<T,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension TextureCubeArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `TextureCubeArray.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location);
vector<float,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location);
vector<float,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location);
vector<float,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location);
vector<float,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location);
vector<float,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension TextureCubeArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `TextureCubeArray.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location);
vector<int,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location);
vector<int,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location);
vector<int,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location);
vector<int,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location);
vector<int,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension TextureCubeArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `TextureCubeArray.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location);
vector<uint,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> TextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location);
vector<uint,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> TextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location);
vector<uint,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> TextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location);
vector<uint,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> TextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `TextureCubeArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location);
vector<uint,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> TextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedTextureCubeArray<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Sample`
* `SampleBias`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray<T>.CalculateLevelOfDetail`

## Signature 

```
float RasterizerOrderedTextureCubeArray<T>.CalculateLevelOfDetail(
    SamplerState         s,
    vector<float,3>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RasterizerOrderedTextureCubeArray<T>.CalculateLevelOfDetailUnclamped(
    SamplerState         s,
    vector<float,3>      location);
```

## Parameters

* `s`
* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedTextureCubeArray<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             elements);
void RasterizerOrderedTextureCubeArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             numberOfLevels);
void RasterizerOrderedTextureCubeArray<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            elements);
void RasterizerOrderedTextureCubeArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            elements,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `elements`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray<T>.Sample`

## Signature 

```
/// See Availability 1
T RasterizerOrderedTextureCubeArray<T>.Sample(
    SamplerState         s,
    vector<float,4>      location);
/// See Availability 2
T RasterizerOrderedTextureCubeArray<T>.Sample(
    SamplerState         s,
    vector<float,4>      location,
    float                clamp);
T RasterizerOrderedTextureCubeArray<T>.Sample(
    SamplerState         s,
    vector<float,4>      location,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray<T>.SampleBias`

## Signature 

```
T RasterizerOrderedTextureCubeArray<T>.SampleBias(
    SamplerState         s,
    vector<float,4>      location,
    float                bias);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `bias`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray<T>.SampleGrad`

## Signature 

```
T RasterizerOrderedTextureCubeArray<T>.SampleGrad(
    SamplerState         s,
    vector<float,4>      location,
    vector<float,3>      gradX,
    vector<float,3>      gradY);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `gradX`
* `gradY`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray<T>.SampleLevel`

## Signature 

```
T RasterizerOrderedTextureCubeArray<T>.SampleLevel(
    SamplerState         s,
    vector<float,4>      location,
    float                level);
```

## Availability

**GLSL** **HLSL** **CUDA** 

## Parameters

* `s`
* `location`
* `level`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTextureCubeArray`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location);
vector<T,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location);
vector<T,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location);
vector<T,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location);
vector<T,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location);
vector<T,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTextureCubeArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location);
vector<float,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location);
vector<float,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location);
vector<float,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location);
vector<float,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location);
vector<float,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTextureCubeArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location);
vector<int,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location);
vector<int,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location);
vector<int,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location);
vector<int,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location);
vector<int,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedTextureCubeArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location);
vector<uint,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCubeArray.Gather(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location);
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherRed(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location);
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherGreen(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location);
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherBlue(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location);
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedTextureCubeArray.GatherAlpha(
    SamplerState         s,
    vector<float,4>      location,
    vector<int,3>        offset1,
    vector<int,3>        offset2,
    vector<int,3>        offset3,
    vector<int,3>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct TextureCubeMSArray<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`

--------------------------------------------------------------------------------
# `TextureCubeMSArray<T>.GetDimensions`

## Signature 

```
void TextureCubeMSArray<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             sampleCount);
void TextureCubeMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             sampleCount,
    out uint             numberOfLevels);
void TextureCubeMSArray<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            elements,
    out float            sampleCount);
void TextureCubeMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            elements,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `elements`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `TextureCubeMSArray<T>.GetSamplePosition`

## Signature 

```
vector<float,2> TextureCubeMSArray<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedTextureCubeMSArray<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeMSArray<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedTextureCubeMSArray<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             sampleCount);
void RasterizerOrderedTextureCubeMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             elements,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RasterizerOrderedTextureCubeMSArray<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            elements,
    out float            sampleCount);
void RasterizerOrderedTextureCubeMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            elements,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `elements`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedTextureCubeMSArray<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RasterizerOrderedTextureCubeMSArray<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `struct Sampler1D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `Sampler1D<T>.CalculateLevelOfDetail`

## Signature 

```
float Sampler1D<T>.CalculateLevelOfDetail(vector<float,1> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `Sampler1D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float Sampler1D<T>.CalculateLevelOfDetailUnclamped(vector<float,1> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `Sampler1D<T>.GetDimensions`

## Signature 

```
void Sampler1D<T>.GetDimensions(out uint width);
void Sampler1D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             numberOfLevels);
void Sampler1D<T>.GetDimensions(out float width);
void Sampler1D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Sampler1D<T>.Load`

## Signature 

```
/// See Availability 1
T Sampler1D<T>.Load(vector<int,2> location);
/// See Availability 2
T Sampler1D<T>.Load(
    vector<int,2>        location,
    vector<int,1>        offset);
/// See Availability 3
T Sampler1D<T>.Load(
    vector<int,2>        location,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** **CUDA** 
2. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Sampler1D<T>.subscript`

## Signature 

```
T Sampler1D<T>.subscript(uint location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `Sampler1D<T>.Sample`

## Signature 

```
/// See Availability 1
T Sampler1D<T>.Sample(vector<float,1> location);
/// See Availability 2
T Sampler1D<T>.Sample(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 3
T Sampler1D<T>.Sample(
    vector<float,1>      location,
    vector<int,1>        offset,
    float                clamp);
T Sampler1D<T>.Sample(
    vector<float,1>      location,
    vector<int,1>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `Sampler1D<T>.SampleBias`

## Signature 

```
T Sampler1D<T>.SampleBias(
    vector<float,1>      location,
    float                bias);
T Sampler1D<T>.SampleBias(
    vector<float,1>      location,
    float                bias,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `Sampler1D<T>.SampleCmp`

## Signature 

```
float Sampler1D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue);
float Sampler1D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Sampler1D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float Sampler1D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue);
/// See Availability 2
float Sampler1D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Sampler1D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T Sampler1D<T>.SampleGrad(
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY);
T Sampler1D<T>.SampleGrad(
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset);
/// See Availability 2
T Sampler1D<T>.SampleGrad(
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `Sampler1D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T Sampler1D<T>.SampleLevel(
    vector<float,1>      location,
    float                level);
/// See Availability 2
T Sampler1D<T>.SampleLevel(
    vector<float,1>      location,
    float                level,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension Sampler1D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Sampler1D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler1D.Gather(vector<float,1> location);
vector<T,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler1D.GatherRed(vector<float,1> location);
vector<T,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler1D.GatherGreen(vector<float,1> location);
vector<T,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler1D.GatherBlue(vector<float,1> location);
vector<T,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler1D.GatherAlpha(vector<float,1> location);
vector<T,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Sampler1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Sampler1D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler1D.Gather(vector<float,1> location);
vector<float,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler1D.GatherRed(vector<float,1> location);
vector<float,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler1D.GatherGreen(vector<float,1> location);
vector<float,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler1D.GatherBlue(vector<float,1> location);
vector<float,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler1D.GatherAlpha(vector<float,1> location);
vector<float,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Sampler1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Sampler1D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler1D.Gather(vector<float,1> location);
vector<int,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler1D.GatherRed(vector<float,1> location);
vector<int,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler1D.GatherGreen(vector<float,1> location);
vector<int,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler1D.GatherBlue(vector<float,1> location);
vector<int,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler1D.GatherAlpha(vector<float,1> location);
vector<int,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Sampler1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Sampler1D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler1D.Gather(vector<float,1> location);
vector<uint,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Sampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler1D.GatherRed(vector<float,1> location);
vector<uint,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Sampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler1D.GatherGreen(vector<float,1> location);
vector<uint,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Sampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler1D.GatherBlue(vector<float,1> location);
vector<uint,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Sampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler1D.GatherAlpha(vector<float,1> location);
vector<uint,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Sampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RWSampler1D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RWSampler1D<T>.CalculateLevelOfDetail`

## Signature 

```
float RWSampler1D<T>.CalculateLevelOfDetail(vector<float,1> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RWSampler1D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RWSampler1D<T>.CalculateLevelOfDetailUnclamped(vector<float,1> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RWSampler1D<T>.GetDimensions`

## Signature 

```
void RWSampler1D<T>.GetDimensions(out uint width);
void RWSampler1D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             numberOfLevels);
void RWSampler1D<T>.GetDimensions(out float width);
void RWSampler1D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWSampler1D<T>.Load`

## Signature 

```
/// See Availability 1
T RWSampler1D<T>.Load(vector<int,1> location);
/// See Availability 2
T RWSampler1D<T>.Load(
    vector<int,1>        location,
    vector<int,1>        offset);
/// See Availability 3
T RWSampler1D<T>.Load(
    vector<int,1>        location,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** **CUDA** 
2. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWSampler1D<T>.subscript`

## Signature 

```
T RWSampler1D<T>.subscript(uint location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RWSampler1D<T>.Sample`

## Signature 

```
/// See Availability 1
T RWSampler1D<T>.Sample(vector<float,1> location);
/// See Availability 2
T RWSampler1D<T>.Sample(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 3
T RWSampler1D<T>.Sample(
    vector<float,1>      location,
    vector<int,1>        offset,
    float                clamp);
T RWSampler1D<T>.Sample(
    vector<float,1>      location,
    vector<int,1>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RWSampler1D<T>.SampleBias`

## Signature 

```
T RWSampler1D<T>.SampleBias(
    vector<float,1>      location,
    float                bias);
T RWSampler1D<T>.SampleBias(
    vector<float,1>      location,
    float                bias,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RWSampler1D<T>.SampleCmp`

## Signature 

```
float RWSampler1D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue);
float RWSampler1D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWSampler1D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RWSampler1D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue);
/// See Availability 2
float RWSampler1D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWSampler1D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RWSampler1D<T>.SampleGrad(
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY);
T RWSampler1D<T>.SampleGrad(
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset);
/// See Availability 2
T RWSampler1D<T>.SampleGrad(
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RWSampler1D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RWSampler1D<T>.SampleLevel(
    vector<float,1>      location,
    float                level);
/// See Availability 2
T RWSampler1D<T>.SampleLevel(
    vector<float,1>      location,
    float                level,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RWSampler1D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWSampler1D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler1D.Gather(vector<float,1> location);
vector<T,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler1D.GatherRed(vector<float,1> location);
vector<T,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler1D.GatherGreen(vector<float,1> location);
vector<T,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler1D.GatherBlue(vector<float,1> location);
vector<T,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler1D.GatherAlpha(vector<float,1> location);
vector<T,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWSampler1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWSampler1D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler1D.Gather(vector<float,1> location);
vector<float,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler1D.GatherRed(vector<float,1> location);
vector<float,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler1D.GatherGreen(vector<float,1> location);
vector<float,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler1D.GatherBlue(vector<float,1> location);
vector<float,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler1D.GatherAlpha(vector<float,1> location);
vector<float,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWSampler1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWSampler1D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler1D.Gather(vector<float,1> location);
vector<int,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler1D.GatherRed(vector<float,1> location);
vector<int,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler1D.GatherGreen(vector<float,1> location);
vector<int,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler1D.GatherBlue(vector<float,1> location);
vector<int,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler1D.GatherAlpha(vector<float,1> location);
vector<int,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWSampler1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWSampler1D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler1D.Gather(vector<float,1> location);
vector<uint,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler1D.GatherRed(vector<float,1> location);
vector<uint,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler1D.GatherGreen(vector<float,1> location);
vector<uint,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler1D.GatherBlue(vector<float,1> location);
vector<uint,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler1D.GatherAlpha(vector<float,1> location);
vector<uint,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedSampler1D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D<T>.CalculateLevelOfDetail`

## Signature 

```
float RasterizerOrderedSampler1D<T>.CalculateLevelOfDetail(vector<float,1> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RasterizerOrderedSampler1D<T>.CalculateLevelOfDetailUnclamped(vector<float,1> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedSampler1D<T>.GetDimensions(out uint width);
void RasterizerOrderedSampler1D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             numberOfLevels);
void RasterizerOrderedSampler1D<T>.GetDimensions(out float width);
void RasterizerOrderedSampler1D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedSampler1D<T>.Load(vector<int,1> location);
T RasterizerOrderedSampler1D<T>.Load(
    vector<int,1>        location,
    vector<int,1>        offset);
/// See Availability 2
T RasterizerOrderedSampler1D<T>.Load(
    vector<int,1>        location,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D<T>.subscript`

## Signature 

```
T RasterizerOrderedSampler1D<T>.subscript(uint location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D<T>.Sample`

## Signature 

```
/// See Availability 1
T RasterizerOrderedSampler1D<T>.Sample(vector<float,1> location);
/// See Availability 2
T RasterizerOrderedSampler1D<T>.Sample(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 3
T RasterizerOrderedSampler1D<T>.Sample(
    vector<float,1>      location,
    vector<int,1>        offset,
    float                clamp);
T RasterizerOrderedSampler1D<T>.Sample(
    vector<float,1>      location,
    vector<int,1>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D<T>.SampleBias`

## Signature 

```
T RasterizerOrderedSampler1D<T>.SampleBias(
    vector<float,1>      location,
    float                bias);
T RasterizerOrderedSampler1D<T>.SampleBias(
    vector<float,1>      location,
    float                bias,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D<T>.SampleCmp`

## Signature 

```
float RasterizerOrderedSampler1D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue);
float RasterizerOrderedSampler1D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RasterizerOrderedSampler1D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue);
/// See Availability 2
float RasterizerOrderedSampler1D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,1>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RasterizerOrderedSampler1D<T>.SampleGrad(
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY);
T RasterizerOrderedSampler1D<T>.SampleGrad(
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset);
/// See Availability 2
T RasterizerOrderedSampler1D<T>.SampleGrad(
    vector<float,1>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RasterizerOrderedSampler1D<T>.SampleLevel(
    vector<float,1>      location,
    float                level);
/// See Availability 2
T RasterizerOrderedSampler1D<T>.SampleLevel(
    vector<float,1>      location,
    float                level,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedSampler1D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1D.Gather(vector<float,1> location);
vector<T,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1D.GatherRed(vector<float,1> location);
vector<T,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1D.GatherGreen(vector<float,1> location);
vector<T,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1D.GatherBlue(vector<float,1> location);
vector<T,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1D.GatherAlpha(vector<float,1> location);
vector<T,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedSampler1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1D.Gather(vector<float,1> location);
vector<float,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1D.GatherRed(vector<float,1> location);
vector<float,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1D.GatherGreen(vector<float,1> location);
vector<float,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1D.GatherBlue(vector<float,1> location);
vector<float,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1D.GatherAlpha(vector<float,1> location);
vector<float,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedSampler1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1D.Gather(vector<float,1> location);
vector<int,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1D.GatherRed(vector<float,1> location);
vector<int,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1D.GatherGreen(vector<float,1> location);
vector<int,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1D.GatherBlue(vector<float,1> location);
vector<int,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1D.GatherAlpha(vector<float,1> location);
vector<int,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedSampler1D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1D.Gather(vector<float,1> location);
vector<uint,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1D.Gather(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1D.GatherRed(vector<float,1> location);
vector<uint,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1D.GatherRed(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1D.GatherGreen(vector<float,1> location);
vector<uint,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1D.GatherGreen(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1D.GatherBlue(vector<float,1> location);
vector<uint,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1D.GatherBlue(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1D.GatherAlpha(vector<float,1> location);
vector<uint,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1D.GatherAlpha(
    vector<float,1>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct Sampler1DMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `Sampler1DMS<T>.GetDimensions`

## Signature 

```
void Sampler1DMS<T>.GetDimensions(
    out uint             width,
    out uint             sampleCount);
void Sampler1DMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             sampleCount,
    out uint             numberOfLevels);
void Sampler1DMS<T>.GetDimensions(
    out float            width,
    out float            sampleCount);
void Sampler1DMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Sampler1DMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> Sampler1DMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `Sampler1DMS<T>.Load`

## Signature 

```
/// See Availability 1
T Sampler1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex);
T Sampler1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex,
    vector<int,1>        offset);
/// See Availability 2
T Sampler1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Sampler1DMS<T>.subscript`

## Signature 

```
T Sampler1DMS<T>.subscript(uint location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RWSampler1DMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RWSampler1DMS<T>.GetDimensions`

## Signature 

```
void RWSampler1DMS<T>.GetDimensions(
    out uint             width,
    out uint             sampleCount);
void RWSampler1DMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RWSampler1DMS<T>.GetDimensions(
    out float            width,
    out float            sampleCount);
void RWSampler1DMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWSampler1DMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RWSampler1DMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RWSampler1DMS<T>.Load`

## Signature 

```
/// See Availability 1
T RWSampler1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex);
T RWSampler1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex,
    vector<int,1>        offset);
/// See Availability 2
T RWSampler1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWSampler1DMS<T>.subscript`

## Signature 

```
T RWSampler1DMS<T>.subscript(uint location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedSampler1DMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DMS<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedSampler1DMS<T>.GetDimensions(
    out uint             width,
    out uint             sampleCount);
void RasterizerOrderedSampler1DMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RasterizerOrderedSampler1DMS<T>.GetDimensions(
    out float            width,
    out float            sampleCount);
void RasterizerOrderedSampler1DMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RasterizerOrderedSampler1DMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DMS<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedSampler1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex);
T RasterizerOrderedSampler1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex,
    vector<int,1>        offset);
/// See Availability 2
T RasterizerOrderedSampler1DMS<T>.Load(
    vector<int,1>        location,
    int                  sampleIndex,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DMS<T>.subscript`

## Signature 

```
T RasterizerOrderedSampler1DMS<T>.subscript(uint location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct Sampler1DArray<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `Sampler1DArray<T>.CalculateLevelOfDetail`

## Signature 

```
float Sampler1DArray<T>.CalculateLevelOfDetail(vector<float,1> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `Sampler1DArray<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float Sampler1DArray<T>.CalculateLevelOfDetailUnclamped(vector<float,1> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `Sampler1DArray<T>.GetDimensions`

## Signature 

```
void Sampler1DArray<T>.GetDimensions(
    out uint             width,
    out uint             elements);
void Sampler1DArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             elements,
    out uint             numberOfLevels);
void Sampler1DArray<T>.GetDimensions(
    out float            width,
    out float            elements);
void Sampler1DArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            elements,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `elements`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Sampler1DArray<T>.Load`

## Signature 

```
/// See Availability 1
T Sampler1DArray<T>.Load(vector<int,3> location);
T Sampler1DArray<T>.Load(
    vector<int,3>        location,
    vector<int,1>        offset);
/// See Availability 2
T Sampler1DArray<T>.Load(
    vector<int,3>        location,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Sampler1DArray<T>.subscript`

## Signature 

```
T Sampler1DArray<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `Sampler1DArray<T>.Sample`

## Signature 

```
/// See Availability 1
T Sampler1DArray<T>.Sample(vector<float,2> location);
/// See Availability 2
T Sampler1DArray<T>.Sample(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 3
T Sampler1DArray<T>.Sample(
    vector<float,2>      location,
    vector<int,1>        offset,
    float                clamp);
T Sampler1DArray<T>.Sample(
    vector<float,2>      location,
    vector<int,1>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `Sampler1DArray<T>.SampleBias`

## Signature 

```
T Sampler1DArray<T>.SampleBias(
    vector<float,2>      location,
    float                bias);
T Sampler1DArray<T>.SampleBias(
    vector<float,2>      location,
    float                bias,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `Sampler1DArray<T>.SampleCmp`

## Signature 

```
float Sampler1DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
float Sampler1DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Sampler1DArray<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float Sampler1DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
/// See Availability 2
float Sampler1DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Sampler1DArray<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T Sampler1DArray<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY);
T Sampler1DArray<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset);
/// See Availability 2
T Sampler1DArray<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `Sampler1DArray<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T Sampler1DArray<T>.SampleLevel(
    vector<float,2>      location,
    float                level);
/// See Availability 2
T Sampler1DArray<T>.SampleLevel(
    vector<float,2>      location,
    float                level,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension Sampler1DArray`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Sampler1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler1DArray.Gather(vector<float,2> location);
vector<T,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler1DArray.GatherRed(vector<float,2> location);
vector<T,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler1DArray.GatherGreen(vector<float,2> location);
vector<T,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler1DArray.GatherBlue(vector<float,2> location);
vector<T,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler1DArray.GatherAlpha(vector<float,2> location);
vector<T,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Sampler1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Sampler1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler1DArray.Gather(vector<float,2> location);
vector<float,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler1DArray.GatherRed(vector<float,2> location);
vector<float,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler1DArray.GatherGreen(vector<float,2> location);
vector<float,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler1DArray.GatherBlue(vector<float,2> location);
vector<float,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler1DArray.GatherAlpha(vector<float,2> location);
vector<float,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Sampler1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Sampler1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler1DArray.Gather(vector<float,2> location);
vector<int,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler1DArray.GatherRed(vector<float,2> location);
vector<int,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler1DArray.GatherGreen(vector<float,2> location);
vector<int,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler1DArray.GatherBlue(vector<float,2> location);
vector<int,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler1DArray.GatherAlpha(vector<float,2> location);
vector<int,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Sampler1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Sampler1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler1DArray.Gather(vector<float,2> location);
vector<uint,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Sampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler1DArray.GatherRed(vector<float,2> location);
vector<uint,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Sampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler1DArray.GatherGreen(vector<float,2> location);
vector<uint,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Sampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler1DArray.GatherBlue(vector<float,2> location);
vector<uint,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Sampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler1DArray.GatherAlpha(vector<float,2> location);
vector<uint,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> Sampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RWSampler1DArray<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RWSampler1DArray<T>.CalculateLevelOfDetail`

## Signature 

```
float RWSampler1DArray<T>.CalculateLevelOfDetail(vector<float,1> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RWSampler1DArray<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RWSampler1DArray<T>.CalculateLevelOfDetailUnclamped(vector<float,1> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RWSampler1DArray<T>.GetDimensions`

## Signature 

```
void RWSampler1DArray<T>.GetDimensions(
    out uint             width,
    out uint             elements);
void RWSampler1DArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             elements,
    out uint             numberOfLevels);
void RWSampler1DArray<T>.GetDimensions(
    out float            width,
    out float            elements);
void RWSampler1DArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            elements,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `elements`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWSampler1DArray<T>.Load`

## Signature 

```
/// See Availability 1
T RWSampler1DArray<T>.Load(vector<int,2> location);
/// See Availability 2
T RWSampler1DArray<T>.Load(
    vector<int,2>        location,
    vector<int,1>        offset);
/// See Availability 3
T RWSampler1DArray<T>.Load(
    vector<int,2>        location,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** **CUDA** 
2. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWSampler1DArray<T>.subscript`

## Signature 

```
T RWSampler1DArray<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RWSampler1DArray<T>.Sample`

## Signature 

```
/// See Availability 1
T RWSampler1DArray<T>.Sample(vector<float,2> location);
/// See Availability 2
T RWSampler1DArray<T>.Sample(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 3
T RWSampler1DArray<T>.Sample(
    vector<float,2>      location,
    vector<int,1>        offset,
    float                clamp);
T RWSampler1DArray<T>.Sample(
    vector<float,2>      location,
    vector<int,1>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RWSampler1DArray<T>.SampleBias`

## Signature 

```
T RWSampler1DArray<T>.SampleBias(
    vector<float,2>      location,
    float                bias);
T RWSampler1DArray<T>.SampleBias(
    vector<float,2>      location,
    float                bias,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RWSampler1DArray<T>.SampleCmp`

## Signature 

```
float RWSampler1DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
float RWSampler1DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWSampler1DArray<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RWSampler1DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
/// See Availability 2
float RWSampler1DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWSampler1DArray<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RWSampler1DArray<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY);
T RWSampler1DArray<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset);
/// See Availability 2
T RWSampler1DArray<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RWSampler1DArray<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RWSampler1DArray<T>.SampleLevel(
    vector<float,2>      location,
    float                level);
/// See Availability 2
T RWSampler1DArray<T>.SampleLevel(
    vector<float,2>      location,
    float                level,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RWSampler1DArray`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWSampler1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler1DArray.Gather(vector<float,2> location);
vector<T,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler1DArray.GatherRed(vector<float,2> location);
vector<T,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler1DArray.GatherGreen(vector<float,2> location);
vector<T,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler1DArray.GatherBlue(vector<float,2> location);
vector<T,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler1DArray.GatherAlpha(vector<float,2> location);
vector<T,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWSampler1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWSampler1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler1DArray.Gather(vector<float,2> location);
vector<float,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler1DArray.GatherRed(vector<float,2> location);
vector<float,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler1DArray.GatherGreen(vector<float,2> location);
vector<float,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler1DArray.GatherBlue(vector<float,2> location);
vector<float,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler1DArray.GatherAlpha(vector<float,2> location);
vector<float,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWSampler1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWSampler1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler1DArray.Gather(vector<float,2> location);
vector<int,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler1DArray.GatherRed(vector<float,2> location);
vector<int,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler1DArray.GatherGreen(vector<float,2> location);
vector<int,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler1DArray.GatherBlue(vector<float,2> location);
vector<int,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler1DArray.GatherAlpha(vector<float,2> location);
vector<int,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWSampler1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWSampler1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler1DArray.Gather(vector<float,2> location);
vector<uint,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler1DArray.GatherRed(vector<float,2> location);
vector<uint,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler1DArray.GatherGreen(vector<float,2> location);
vector<uint,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler1DArray.GatherBlue(vector<float,2> location);
vector<uint,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler1DArray.GatherAlpha(vector<float,2> location);
vector<uint,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RWSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedSampler1DArray<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray<T>.CalculateLevelOfDetail`

## Signature 

```
float RasterizerOrderedSampler1DArray<T>.CalculateLevelOfDetail(vector<float,1> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RasterizerOrderedSampler1DArray<T>.CalculateLevelOfDetailUnclamped(vector<float,1> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedSampler1DArray<T>.GetDimensions(
    out uint             width,
    out uint             elements);
void RasterizerOrderedSampler1DArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             elements,
    out uint             numberOfLevels);
void RasterizerOrderedSampler1DArray<T>.GetDimensions(
    out float            width,
    out float            elements);
void RasterizerOrderedSampler1DArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            elements,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `elements`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedSampler1DArray<T>.Load(vector<int,2> location);
T RasterizerOrderedSampler1DArray<T>.Load(
    vector<int,2>        location,
    vector<int,1>        offset);
/// See Availability 2
T RasterizerOrderedSampler1DArray<T>.Load(
    vector<int,2>        location,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray<T>.subscript`

## Signature 

```
T RasterizerOrderedSampler1DArray<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray<T>.Sample`

## Signature 

```
/// See Availability 1
T RasterizerOrderedSampler1DArray<T>.Sample(vector<float,2> location);
/// See Availability 2
T RasterizerOrderedSampler1DArray<T>.Sample(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 3
T RasterizerOrderedSampler1DArray<T>.Sample(
    vector<float,2>      location,
    vector<int,1>        offset,
    float                clamp);
T RasterizerOrderedSampler1DArray<T>.Sample(
    vector<float,2>      location,
    vector<int,1>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray<T>.SampleBias`

## Signature 

```
T RasterizerOrderedSampler1DArray<T>.SampleBias(
    vector<float,2>      location,
    float                bias);
T RasterizerOrderedSampler1DArray<T>.SampleBias(
    vector<float,2>      location,
    float                bias,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray<T>.SampleCmp`

## Signature 

```
float RasterizerOrderedSampler1DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
float RasterizerOrderedSampler1DArray<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RasterizerOrderedSampler1DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
/// See Availability 2
float RasterizerOrderedSampler1DArray<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RasterizerOrderedSampler1DArray<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY);
T RasterizerOrderedSampler1DArray<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset);
/// See Availability 2
T RasterizerOrderedSampler1DArray<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,1>      gradX,
    vector<float,1>      gradY,
    vector<int,1>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RasterizerOrderedSampler1DArray<T>.SampleLevel(
    vector<float,2>      location,
    float                level);
/// See Availability 2
T RasterizerOrderedSampler1DArray<T>.SampleLevel(
    vector<float,2>      location,
    float                level,
    vector<int,1>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedSampler1DArray`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1DArray.Gather(vector<float,2> location);
vector<T,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1DArray.GatherRed(vector<float,2> location);
vector<T,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1DArray.GatherGreen(vector<float,2> location);
vector<T,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1DArray.GatherBlue(vector<float,2> location);
vector<T,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1DArray.GatherAlpha(vector<float,2> location);
vector<T,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<T,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedSampler1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1DArray.Gather(vector<float,2> location);
vector<float,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1DArray.GatherRed(vector<float,2> location);
vector<float,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1DArray.GatherGreen(vector<float,2> location);
vector<float,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1DArray.GatherBlue(vector<float,2> location);
vector<float,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1DArray.GatherAlpha(vector<float,2> location);
vector<float,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<float,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedSampler1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1DArray.Gather(vector<float,2> location);
vector<int,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1DArray.GatherRed(vector<float,2> location);
vector<int,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1DArray.GatherGreen(vector<float,2> location);
vector<int,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1DArray.GatherBlue(vector<float,2> location);
vector<int,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1DArray.GatherAlpha(vector<float,2> location);
vector<int,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<int,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedSampler1DArray`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1DArray.Gather(vector<float,2> location);
vector<uint,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1DArray.Gather(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1DArray.GatherRed(vector<float,2> location);
vector<uint,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1DArray.GatherRed(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1DArray.GatherGreen(vector<float,2> location);
vector<uint,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1DArray.GatherGreen(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1DArray.GatherBlue(vector<float,2> location);
vector<uint,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1DArray.GatherBlue(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DArray.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1DArray.GatherAlpha(vector<float,2> location);
vector<uint,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset,
    out uint             status);
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler1DArray.GatherAlpha(
    vector<float,2>      location,
    vector<int,1>        offset1,
    vector<int,1>        offset2,
    vector<int,1>        offset3,
    vector<int,1>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct Sampler1DMSArray<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `Sampler1DMSArray<T>.GetDimensions`

## Signature 

```
void Sampler1DMSArray<T>.GetDimensions(
    out uint             width,
    out uint             elements,
    out uint             sampleCount);
void Sampler1DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             elements,
    out uint             sampleCount,
    out uint             numberOfLevels);
void Sampler1DMSArray<T>.GetDimensions(
    out float            width,
    out float            elements,
    out float            sampleCount);
void Sampler1DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            elements,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `elements`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Sampler1DMSArray<T>.GetSamplePosition`

## Signature 

```
vector<float,2> Sampler1DMSArray<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `Sampler1DMSArray<T>.Load`

## Signature 

```
/// See Availability 1
T Sampler1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex);
T Sampler1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,1>        offset);
/// See Availability 2
T Sampler1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Sampler1DMSArray<T>.subscript`

## Signature 

```
T Sampler1DMSArray<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RWSampler1DMSArray<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RWSampler1DMSArray<T>.GetDimensions`

## Signature 

```
void RWSampler1DMSArray<T>.GetDimensions(
    out uint             width,
    out uint             elements,
    out uint             sampleCount);
void RWSampler1DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             elements,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RWSampler1DMSArray<T>.GetDimensions(
    out float            width,
    out float            elements,
    out float            sampleCount);
void RWSampler1DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            elements,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `elements`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWSampler1DMSArray<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RWSampler1DMSArray<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RWSampler1DMSArray<T>.Load`

## Signature 

```
/// See Availability 1
T RWSampler1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex);
T RWSampler1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,1>        offset);
/// See Availability 2
T RWSampler1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWSampler1DMSArray<T>.subscript`

## Signature 

```
T RWSampler1DMSArray<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedSampler1DMSArray<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DMSArray<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedSampler1DMSArray<T>.GetDimensions(
    out uint             width,
    out uint             elements,
    out uint             sampleCount);
void RasterizerOrderedSampler1DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             elements,
    out uint             sampleCount,
    out uint             numberOfLevels);
void RasterizerOrderedSampler1DMSArray<T>.GetDimensions(
    out float            width,
    out float            elements,
    out float            sampleCount);
void RasterizerOrderedSampler1DMSArray<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            elements,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `elements`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DMSArray<T>.GetSamplePosition`

## Signature 

```
vector<float,2> RasterizerOrderedSampler1DMSArray<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DMSArray<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedSampler1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex);
T RasterizerOrderedSampler1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,1>        offset);
/// See Availability 2
T RasterizerOrderedSampler1DMSArray<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,1>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler1DMSArray<T>.subscript`

## Signature 

```
T RasterizerOrderedSampler1DMSArray<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct Sampler2D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `Sampler2D<T>.CalculateLevelOfDetail`

## Signature 

```
float Sampler2D<T>.CalculateLevelOfDetail(vector<float,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `Sampler2D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float Sampler2D<T>.CalculateLevelOfDetailUnclamped(vector<float,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `Sampler2D<T>.GetDimensions`

## Signature 

```
void Sampler2D<T>.GetDimensions(
    out uint             width,
    out uint             height);
void Sampler2D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             numberOfLevels);
void Sampler2D<T>.GetDimensions(
    out float            width,
    out float            height);
void Sampler2D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Sampler2D<T>.Load`

## Signature 

```
/// See Availability 1
T Sampler2D<T>.Load(vector<int,3> location);
T Sampler2D<T>.Load(
    vector<int,3>        location,
    vector<int,2>        offset);
/// See Availability 2
T Sampler2D<T>.Load(
    vector<int,3>        location,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Sampler2D<T>.subscript`

## Signature 

```
T Sampler2D<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `Sampler2D<T>.Sample`

## Signature 

```
/// See Availability 1
T Sampler2D<T>.Sample(vector<float,2> location);
/// See Availability 2
T Sampler2D<T>.Sample(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
T Sampler2D<T>.Sample(
    vector<float,2>      location,
    vector<int,2>        offset,
    float                clamp);
T Sampler2D<T>.Sample(
    vector<float,2>      location,
    vector<int,2>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `Sampler2D<T>.SampleBias`

## Signature 

```
T Sampler2D<T>.SampleBias(
    vector<float,2>      location,
    float                bias);
T Sampler2D<T>.SampleBias(
    vector<float,2>      location,
    float                bias,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `Sampler2D<T>.SampleCmp`

## Signature 

```
float Sampler2D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
float Sampler2D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Sampler2D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float Sampler2D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
/// See Availability 2
float Sampler2D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `Sampler2D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T Sampler2D<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY);
T Sampler2D<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset);
/// See Availability 2
T Sampler2D<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `Sampler2D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T Sampler2D<T>.SampleLevel(
    vector<float,2>      location,
    float                level);
/// See Availability 2
T Sampler2D<T>.SampleLevel(
    vector<float,2>      location,
    float                level,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension Sampler2D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Sampler2D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler2D.Gather(vector<float,2> location);
/// See Availability 2
vector<T,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler2D.GatherRed(vector<float,2> location);
/// See Availability 2
vector<T,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler2D.GatherGreen(vector<float,2> location);
/// See Availability 2
vector<T,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler2D.GatherBlue(vector<float,2> location);
/// See Availability 2
vector<T,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> Sampler2D.GatherAlpha(vector<float,2> location);
/// See Availability 2
vector<T,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Sampler2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Sampler2D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler2D.Gather(vector<float,2> location);
/// See Availability 2
vector<float,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler2D.GatherRed(vector<float,2> location);
/// See Availability 2
vector<float,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler2D.GatherGreen(vector<float,2> location);
/// See Availability 2
vector<float,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler2D.GatherBlue(vector<float,2> location);
/// See Availability 2
vector<float,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> Sampler2D.GatherAlpha(vector<float,2> location);
/// See Availability 2
vector<float,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Sampler2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Sampler2D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler2D.Gather(vector<float,2> location);
/// See Availability 2
vector<int,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler2D.GatherRed(vector<float,2> location);
/// See Availability 2
vector<int,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler2D.GatherGreen(vector<float,2> location);
/// See Availability 2
vector<int,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler2D.GatherBlue(vector<float,2> location);
/// See Availability 2
vector<int,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> Sampler2D.GatherAlpha(vector<float,2> location);
/// See Availability 2
vector<int,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension Sampler2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `Sampler2D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler2D.Gather(vector<float,2> location);
/// See Availability 2
vector<uint,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Sampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler2D.GatherRed(vector<float,2> location);
/// See Availability 2
vector<uint,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Sampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler2D.GatherGreen(vector<float,2> location);
/// See Availability 2
vector<uint,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Sampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler2D.GatherBlue(vector<float,2> location);
/// See Availability 2
vector<uint,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Sampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `Sampler2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> Sampler2D.GatherAlpha(vector<float,2> location);
/// See Availability 2
vector<uint,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> Sampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RWSampler2D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RWSampler2D<T>.CalculateLevelOfDetail`

## Signature 

```
float RWSampler2D<T>.CalculateLevelOfDetail(vector<float,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RWSampler2D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RWSampler2D<T>.CalculateLevelOfDetailUnclamped(vector<float,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RWSampler2D<T>.GetDimensions`

## Signature 

```
void RWSampler2D<T>.GetDimensions(
    out uint             width,
    out uint             height);
void RWSampler2D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             numberOfLevels);
void RWSampler2D<T>.GetDimensions(
    out float            width,
    out float            height);
void RWSampler2D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RWSampler2D<T>.Load`

## Signature 

```
/// See Availability 1
T RWSampler2D<T>.Load(vector<int,2> location);
/// See Availability 2
T RWSampler2D<T>.Load(
    vector<int,2>        location,
    vector<int,2>        offset);
/// See Availability 3
T RWSampler2D<T>.Load(
    vector<int,2>        location,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** **CUDA** 
2. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RWSampler2D<T>.subscript`

## Signature 

```
T RWSampler2D<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RWSampler2D<T>.Sample`

## Signature 

```
/// See Availability 1
T RWSampler2D<T>.Sample(vector<float,2> location);
/// See Availability 2
T RWSampler2D<T>.Sample(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
T RWSampler2D<T>.Sample(
    vector<float,2>      location,
    vector<int,2>        offset,
    float                clamp);
T RWSampler2D<T>.Sample(
    vector<float,2>      location,
    vector<int,2>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RWSampler2D<T>.SampleBias`

## Signature 

```
T RWSampler2D<T>.SampleBias(
    vector<float,2>      location,
    float                bias);
T RWSampler2D<T>.SampleBias(
    vector<float,2>      location,
    float                bias,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RWSampler2D<T>.SampleCmp`

## Signature 

```
float RWSampler2D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
float RWSampler2D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWSampler2D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RWSampler2D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
/// See Availability 2
float RWSampler2D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RWSampler2D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RWSampler2D<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY);
T RWSampler2D<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset);
/// See Availability 2
T RWSampler2D<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RWSampler2D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RWSampler2D<T>.SampleLevel(
    vector<float,2>      location,
    float                level);
/// See Availability 2
T RWSampler2D<T>.SampleLevel(
    vector<float,2>      location,
    float                level,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RWSampler2D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWSampler2D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler2D.Gather(vector<float,2> location);
/// See Availability 2
vector<T,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler2D.GatherRed(vector<float,2> location);
/// See Availability 2
vector<T,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler2D.GatherGreen(vector<float,2> location);
/// See Availability 2
vector<T,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler2D.GatherBlue(vector<float,2> location);
/// See Availability 2
vector<T,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RWSampler2D.GatherAlpha(vector<float,2> location);
/// See Availability 2
vector<T,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWSampler2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWSampler2D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler2D.Gather(vector<float,2> location);
/// See Availability 2
vector<float,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler2D.GatherRed(vector<float,2> location);
/// See Availability 2
vector<float,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler2D.GatherGreen(vector<float,2> location);
/// See Availability 2
vector<float,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler2D.GatherBlue(vector<float,2> location);
/// See Availability 2
vector<float,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RWSampler2D.GatherAlpha(vector<float,2> location);
/// See Availability 2
vector<float,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWSampler2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWSampler2D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler2D.Gather(vector<float,2> location);
/// See Availability 2
vector<int,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler2D.GatherRed(vector<float,2> location);
/// See Availability 2
vector<int,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler2D.GatherGreen(vector<float,2> location);
/// See Availability 2
vector<int,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler2D.GatherBlue(vector<float,2> location);
/// See Availability 2
vector<int,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RWSampler2D.GatherAlpha(vector<float,2> location);
/// See Availability 2
vector<int,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RWSampler2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RWSampler2D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler2D.Gather(vector<float,2> location);
/// See Availability 2
vector<uint,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler2D.GatherRed(vector<float,2> location);
/// See Availability 2
vector<uint,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler2D.GatherGreen(vector<float,2> location);
/// See Availability 2
vector<uint,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler2D.GatherBlue(vector<float,2> location);
/// See Availability 2
vector<uint,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RWSampler2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RWSampler2D.GatherAlpha(vector<float,2> location);
/// See Availability 2
vector<uint,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RWSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct RasterizerOrderedSampler2D<T>`

## Generic Parameters

* `T`

## Methods

* `CalculateLevelOfDetail`
* `CalculateLevelOfDetailUnclamped`
* `GetDimensions`
* `Load`
* `subscript`
* `Sample`
* `SampleBias`
* `SampleCmp`
* `SampleCmpLevelZero`
* `SampleGrad`
* `SampleLevel`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D<T>.CalculateLevelOfDetail`

## Signature 

```
float RasterizerOrderedSampler2D<T>.CalculateLevelOfDetail(vector<float,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D<T>.CalculateLevelOfDetailUnclamped`

## Signature 

```
float RasterizerOrderedSampler2D<T>.CalculateLevelOfDetailUnclamped(vector<float,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D<T>.GetDimensions`

## Signature 

```
void RasterizerOrderedSampler2D<T>.GetDimensions(
    out uint             width,
    out uint             height);
void RasterizerOrderedSampler2D<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             numberOfLevels);
void RasterizerOrderedSampler2D<T>.GetDimensions(
    out float            width,
    out float            height);
void RasterizerOrderedSampler2D<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D<T>.Load`

## Signature 

```
/// See Availability 1
T RasterizerOrderedSampler2D<T>.Load(vector<int,2> location);
T RasterizerOrderedSampler2D<T>.Load(
    vector<int,2>        location,
    vector<int,2>        offset);
/// See Availability 2
T RasterizerOrderedSampler2D<T>.Load(
    vector<int,2>        location,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D<T>.subscript`

## Signature 

```
T RasterizerOrderedSampler2D<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D<T>.Sample`

## Signature 

```
/// See Availability 1
T RasterizerOrderedSampler2D<T>.Sample(vector<float,2> location);
/// See Availability 2
T RasterizerOrderedSampler2D<T>.Sample(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
T RasterizerOrderedSampler2D<T>.Sample(
    vector<float,2>      location,
    vector<int,2>        offset,
    float                clamp);
T RasterizerOrderedSampler2D<T>.Sample(
    vector<float,2>      location,
    vector<int,2>        offset,
    float                clamp,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `clamp`
* `status`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D<T>.SampleBias`

## Signature 

```
T RasterizerOrderedSampler2D<T>.SampleBias(
    vector<float,2>      location,
    float                bias);
T RasterizerOrderedSampler2D<T>.SampleBias(
    vector<float,2>      location,
    float                bias,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `location`
* `bias`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D<T>.SampleCmp`

## Signature 

```
float RasterizerOrderedSampler2D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
float RasterizerOrderedSampler2D<T>.SampleCmp(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

**GLSL** **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D<T>.SampleCmpLevelZero`

## Signature 

```
/// See Availability 1
float RasterizerOrderedSampler2D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue);
/// See Availability 2
float RasterizerOrderedSampler2D<T>.SampleCmpLevelZero(
    SamplerComparisonState s,
    vector<float,2>      location,
    float                compareValue,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** 
2. **HLSL** 

## Parameters

* `s`
* `location`
* `compareValue`
* `offset`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D<T>.SampleGrad`

## Signature 

```
/// See Availability 1
T RasterizerOrderedSampler2D<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY);
T RasterizerOrderedSampler2D<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset);
/// See Availability 2
T RasterizerOrderedSampler2D<T>.SampleGrad(
    vector<float,2>      location,
    vector<float,2>      gradX,
    vector<float,2>      gradY,
    vector<int,2>        offset,
    float                lodClamp);
```

## Availability

1. **GLSL** **HLSL** 
2. **GLSL** `GL_ARB_sparse_texture_clamp` **HLSL** 

## Parameters

* `location`
* `gradX`
* `gradY`
* `offset`
* `lodClamp`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D<T>.SampleLevel`

## Signature 

```
/// See Availability 1
T RasterizerOrderedSampler2D<T>.SampleLevel(
    vector<float,2>      location,
    float                level);
/// See Availability 2
T RasterizerOrderedSampler2D<T>.SampleLevel(
    vector<float,2>      location,
    float                level,
    vector<int,2>        offset);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 

## Parameters

* `location`
* `level`
* `offset`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedSampler2D`

## Generic Parameters

* `T`
* `N`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.Gather`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler2D.Gather(vector<float,2> location);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler2D.GatherRed(vector<float,2> location);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler2D.GatherGreen(vector<float,2> location);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler2D.GatherBlue(vector<float,2> location);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<T,4> RasterizerOrderedSampler2D.GatherAlpha(vector<float,2> location);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<T,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<T,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<T,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedSampler2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.Gather`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler2D.Gather(vector<float,2> location);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler2D.GatherRed(vector<float,2> location);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler2D.GatherGreen(vector<float,2> location);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler2D.GatherBlue(vector<float,2> location);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<float,4> RasterizerOrderedSampler2D.GatherAlpha(vector<float,2> location);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<float,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<float,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<float,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedSampler2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.Gather`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler2D.Gather(vector<float,2> location);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler2D.GatherRed(vector<float,2> location);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler2D.GatherGreen(vector<float,2> location);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler2D.GatherBlue(vector<float,2> location);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<int,4> RasterizerOrderedSampler2D.GatherAlpha(vector<float,2> location);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<int,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<int,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<int,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `extension RasterizerOrderedSampler2D`

## Methods

* `Gather`
* `GatherRed`
* `GatherGreen`
* `GatherBlue`
* `GatherAlpha`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.Gather`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler2D.Gather(vector<float,2> location);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedSampler2D.Gather(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherRed`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler2D.GatherRed(vector<float,2> location);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedSampler2D.GatherRed(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherGreen`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler2D.GatherGreen(vector<float,2> location);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedSampler2D.GatherGreen(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherBlue`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler2D.GatherBlue(vector<float,2> location);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedSampler2D.GatherBlue(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `RasterizerOrderedSampler2D.GatherAlpha`

## Signature 

```
/// See Availability 1
vector<uint,4> RasterizerOrderedSampler2D.GatherAlpha(vector<float,2> location);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset);
/// See Availability 3
vector<uint,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset,
    out uint             status);
/// See Availability 2
vector<uint,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4);
/// See Availability 3
vector<uint,4> RasterizerOrderedSampler2D.GatherAlpha(
    vector<float,2>      location,
    vector<int,2>        offset1,
    vector<int,2>        offset2,
    vector<int,2>        offset3,
    vector<int,2>        offset4,
    out uint             status);
```

## Availability

1. **GLSL** **HLSL** **CUDA** 
2. **GLSL** **HLSL** 
3. **HLSL** 

## Parameters

* `location`
* `offset`
* `status`
* `offset1`
* `offset2`
* `offset3`
* `offset4`

--------------------------------------------------------------------------------
# `struct Sampler2DMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `Sampler2DMS<T>.GetDimensions`

## Signature 

```
void Sampler2DMS<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             sampleCount);
void Sampler2DMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             sampleCount,
    out uint             numberOfLevels);
void Sampler2DMS<T>.GetDimensions(
    out float            width,
    out float            height,
    out float            sampleCount);
void Sampler2DMS<T>.GetDimensions(
    uint                 mipLevel,
    out float            width,
    out float            height,
    out float            sampleCount,
    out float            numberOfLevels);
```

## Availability

**GLSL** `GLSL450`, `GL_EXT_samplerless_texture_functions` **HLSL** 

## Parameters

* `width`
* `height`
* `sampleCount`
* `mipLevel`
* `numberOfLevels`

--------------------------------------------------------------------------------
# `Sampler2DMS<T>.GetSamplePosition`

## Signature 

```
vector<float,2> Sampler2DMS<T>.GetSamplePosition(int s);
```

## Parameters

* `s`

--------------------------------------------------------------------------------
# `Sampler2DMS<T>.Load`

## Signature 

```
/// See Availability 1
T Sampler2DMS<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex);
T Sampler2DMS<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,2>        offset);
/// See Availability 2
T Sampler2DMS<T>.Load(
    vector<int,2>        location,
    int                  sampleIndex,
    vector<int,2>        offset,
    out uint             status);
```

## Availability

1. **GLSL** `GL_EXT_samplerless_texture_functions` **HLSL** 
2. **HLSL** 

## Parameters

* `location`
* `sampleIndex`
* `offset`
* `status`

--------------------------------------------------------------------------------
# `Sampler2DMS<T>.subscript`

## Signature 

```
T Sampler2DMS<T>.subscript(vector<uint,2> location);
```

## Parameters

* `location`

--------------------------------------------------------------------------------
# `struct RWSampler2DMS<T>`

## Generic Parameters

* `T`

## Methods

* `GetDimensions`
* `GetSamplePosition`
* `Load`
* `subscript`

--------------------------------------------------------------------------------
# `RWSampler2DMS<T>.GetDimensions`

## Signature 

```
void RWSampler2DMS<T>.GetDimensions(
    out uint             width,
    out uint             height,
    out uint             sampleCount);
void RWSampler2DMS<T>.GetDimensions(
    uint                 mipLevel,
    out uint             width,
    out uint             height,
    out uint             sam