// This file is part of the AliceVision project.
// Copyright (c) 2019 AliceVision contributors.
// This Source Code Form is subject to the terms of the Mozilla Public License,
// v. 2.0. If a copy of the MPL was not distributed with this file,
// You can obtain one at https://mozilla.org/MPL/2.0/.

#include "emorCurve.hpp"
#include <functional>
#include <fstream>
#include <iostream>
#include <sstream>

namespace aliceVision {
namespace hdr {

static const double kEmorInv[kEmorMDimension][kEmorQuantization] = {
  {0.000000e+000, 1.477256e-003, 2.737898e-003, 3.858105e-003, 4.877501e-003, 5.819777e-003, 6.700519e-003, 7.532015e-003, 8.323902e-003,
   9.085110e-003, 9.816742e-003, 1.051719e-002, 1.119348e-002, 1.184927e-002, 1.248706e-002, 1.310836e-002, 1.371501e-002, 1.430845e-002,
   1.488919e-002, 1.545915e-002, 1.601947e-002, 1.656868e-002, 1.710786e-002, 1.763954e-002, 1.816409e-002, 1.868202e-002, 1.919384e-002,
   1.970013e-002, 2.020145e-002, 2.069803e-002, 2.119012e-002, 2.167658e-002, 2.215623e-002, 2.263206e-002, 2.310436e-002, 2.357320e-002,
   2.403910e-002, 2.450196e-002, 2.496192e-002, 2.541903e-002, 2.587329e-002, 2.632477e-002, 2.677024e-002, 2.721375e-002, 2.765540e-002,
   2.809528e-002, 2.853420e-002, 2.897388e-002, 2.941151e-002, 2.984418e-002, 3.027385e-002, 3.070138e-002, 3.112383e-002, 3.154393e-002,
   3.196235e-002, 3.237907e-002, 3.279429e-002, 3.320812e-002, 3.362059e-002, 3.403191e-002, 3.444217e-002, 3.485135e-002, 3.525754e-002,
   3.566134e-002, 3.606424e-002, 3.646630e-002, 3.686738e-002, 3.726786e-002, 3.766775e-002, 3.806709e-002, 3.846602e-002, 3.886461e-002,
   3.926180e-002, 3.965717e-002, 4.005235e-002, 4.044736e-002, 4.084235e-002, 4.123742e-002, 4.163233e-002, 4.202693e-002, 4.242082e-002,
   4.281423e-002, 4.320657e-002, 4.359637e-002, 4.398566e-002, 4.437448e-002, 4.476288e-002, 4.515076e-002, 4.553832e-002, 4.592557e-002,
   4.631260e-002, 4.669941e-002, 4.708620e-002, 4.747111e-002, 4.785581e-002, 4.824055e-002, 4.862516e-002, 4.900963e-002, 4.939392e-002,
   4.977822e-002, 5.016234e-002, 5.054640e-002, 5.093011e-002, 5.131254e-002, 5.169442e-002, 5.207628e-002, 5.245792e-002, 5.283941e-002,
   5.322091e-002, 5.360254e-002, 5.398451e-002, 5.436656e-002, 5.474869e-002, 5.513042e-002, 5.551149e-002, 5.589278e-002, 5.627396e-002,
   5.665528e-002, 5.703689e-002, 5.741860e-002, 5.780036e-002, 5.818207e-002, 5.856357e-002, 5.894459e-002, 5.932454e-002, 5.970394e-002,
   6.008290e-002, 6.046159e-002, 6.084004e-002, 6.121843e-002, 6.159673e-002, 6.197504e-002, 6.235353e-002, 6.273225e-002, 6.311054e-002,
   6.348897e-002, 6.386763e-002, 6.424637e-002, 6.462534e-002, 6.500475e-002, 6.538453e-002, 6.576474e-002, 6.614533e-002, 6.652623e-002,
   6.690713e-002, 6.728824e-002, 6.766955e-002, 6.805103e-002, 6.843249e-002, 6.881406e-002, 6.919566e-002, 6.957729e-002, 6.995908e-002,
   7.034095e-002, 7.072298e-002, 7.110500e-002, 7.148700e-002, 7.186898e-002, 7.225112e-002, 7.263336e-002, 7.301572e-002, 7.339807e-002,
   7.378068e-002, 7.416369e-002, 7.454717e-002, 7.493111e-002, 7.531555e-002, 7.570061e-002, 7.608625e-002, 7.647253e-002, 7.685955e-002,
   7.724725e-002, 7.763534e-002, 7.802366e-002, 7.841244e-002, 7.880214e-002, 7.919242e-002, 7.958317e-002, 7.997455e-002, 8.036661e-002,
   8.075916e-002, 8.115193e-002, 8.154477e-002, 8.193767e-002, 8.233068e-002, 8.272424e-002, 8.311811e-002, 8.351236e-002, 8.390691e-002,
   8.430197e-002, 8.469743e-002, 8.509340e-002, 8.548978e-002, 8.588655e-002, 8.628385e-002, 8.668222e-002, 8.708152e-002, 8.748141e-002,
   8.788185e-002, 8.828293e-002, 8.868463e-002, 8.908685e-002, 8.948966e-002, 8.989305e-002, 9.029707e-002, 9.070218e-002, 9.110851e-002,
   9.151570e-002, 9.192383e-002, 9.233269e-002, 9.274223e-002, 9.315233e-002, 9.356289e-002, 9.397371e-002, 9.438483e-002, 9.479646e-002,
   9.520934e-002, 9.562284e-002, 9.603692e-002, 9.645145e-002, 9.686642e-002, 9.728162e-002, 9.769687e-002, 9.811201e-002, 9.852718e-002,
   9.894242e-002, 9.935901e-002, 9.977592e-002, 1.001931e-001, 1.006107e-001, 1.010286e-001, 1.014468e-001, 1.018654e-001, 1.022844e-001,
   1.027037e-001, 1.031234e-001, 1.035442e-001, 1.039658e-001, 1.043878e-001, 1.048103e-001, 1.052333e-001, 1.056568e-001, 1.060809e-001,
   1.065057e-001, 1.069312e-001, 1.073576e-001, 1.077852e-001, 1.082145e-001, 1.086448e-001, 1.090759e-001, 1.095079e-001, 1.099403e-001,
   1.103731e-001, 1.108063e-001, 1.112397e-001, 1.116734e-001, 1.121078e-001, 1.125435e-001, 1.129796e-001, 1.134162e-001, 1.138531e-001,
   1.142904e-001, 1.147279e-001, 1.151657e-001, 1.156038e-001, 1.160423e-001, 1.164814e-001, 1.169221e-001, 1.173633e-001, 1.178051e-001,
   1.182474e-001, 1.186904e-001, 1.191342e-001, 1.195789e-001, 1.200245e-001, 1.204710e-001, 1.209185e-001, 1.213680e-001, 1.218186e-001,
   1.222701e-001, 1.227224e-001, 1.231757e-001, 1.236300e-001, 1.240850e-001, 1.245409e-001, 1.249978e-001, 1.254555e-001, 1.259149e-001,
   1.263757e-001, 1.268369e-001, 1.272983e-001, 1.277599e-001, 1.282217e-001, 1.286837e-001, 1.291459e-001, 1.296084e-001, 1.300712e-001,
   1.305347e-001, 1.309996e-001, 1.314649e-001, 1.319308e-001, 1.323972e-001, 1.328641e-001, 1.333315e-001, 1.337996e-001, 1.342682e-001,
   1.347375e-001, 1.352075e-001, 1.356796e-001, 1.361524e-001, 1.366258e-001, 1.371000e-001, 1.375749e-001, 1.380505e-001, 1.385269e-001,
   1.390042e-001, 1.394824e-001, 1.399612e-001, 1.404423e-001, 1.409239e-001, 1.414060e-001, 1.418886e-001, 1.423715e-001, 1.428550e-001,
   1.433390e-001, 1.438233e-001, 1.443082e-001, 1.447935e-001, 1.452803e-001, 1.457679e-001, 1.462556e-001, 1.467435e-001, 1.472318e-001,
   1.477203e-001, 1.482094e-001, 1.486990e-001, 1.491891e-001, 1.496798e-001, 1.501717e-001, 1.506655e-001, 1.511598e-001, 1.516549e-001,
   1.521508e-001, 1.526477e-001, 1.531454e-001, 1.536440e-001, 1.541436e-001, 1.546444e-001, 1.551465e-001, 1.556510e-001, 1.561566e-001,
   1.566633e-001, 1.571706e-001, 1.576782e-001, 1.581861e-001, 1.586944e-001, 1.592029e-001, 1.597115e-001, 1.602205e-001, 1.607314e-001,
   1.612429e-001, 1.617547e-001, 1.622672e-001, 1.627801e-001, 1.632935e-001, 1.638076e-001, 1.643225e-001, 1.648382e-001, 1.653550e-001,
   1.658739e-001, 1.663941e-001, 1.669153e-001, 1.674375e-001, 1.679605e-001, 1.684844e-001, 1.690095e-001, 1.695355e-001, 1.700624e-001,
   1.705903e-001, 1.711201e-001, 1.716517e-001, 1.721842e-001, 1.727172e-001, 1.732512e-001, 1.737863e-001, 1.743220e-001, 1.748586e-001,
   1.753961e-001, 1.759341e-001, 1.764733e-001, 1.770141e-001, 1.775553e-001, 1.780969e-001, 1.786393e-001, 1.791824e-001, 1.797259e-001,
   1.802701e-001, 1.808149e-001, 1.813603e-001, 1.819062e-001, 1.824543e-001, 1.830029e-001, 1.835522e-001, 1.841021e-001, 1.846526e-001,
   1.852037e-001, 1.857557e-001, 1.863082e-001, 1.868613e-001, 1.874151e-001, 1.879708e-001, 1.885278e-001, 1.890854e-001, 1.896436e-001,
   1.902028e-001, 1.907630e-001, 1.913239e-001, 1.918856e-001, 1.924481e-001, 1.930113e-001, 1.935760e-001, 1.941417e-001, 1.947082e-001,
   1.952753e-001, 1.958428e-001, 1.964110e-001, 1.969798e-001, 1.975490e-001, 1.981188e-001, 1.986891e-001, 1.992606e-001, 1.998335e-001,
   2.004069e-001, 2.009809e-001, 2.015556e-001, 2.021313e-001, 2.027075e-001, 2.032845e-001, 2.038624e-001, 2.044413e-001, 2.050214e-001,
   2.056038e-001, 2.061875e-001, 2.067723e-001, 2.073581e-001, 2.079446e-001, 2.085321e-001, 2.091204e-001, 2.097096e-001, 2.103000e-001,
   2.108914e-001, 2.114851e-001, 2.120801e-001, 2.126761e-001, 2.132731e-001, 2.138707e-001, 2.144686e-001, 2.150669e-001, 2.156660e-001,
   2.162658e-001, 2.168663e-001, 2.174684e-001, 2.180718e-001, 2.186760e-001, 2.192811e-001, 2.198872e-001, 2.204940e-001, 2.211018e-001,
   2.217107e-001, 2.223205e-001, 2.229314e-001, 2.235436e-001, 2.241575e-001, 2.247723e-001, 2.253881e-001, 2.260048e-001, 2.266224e-001,
   2.272410e-001, 2.278605e-001, 2.284810e-001, 2.291025e-001, 2.297252e-001, 2.303496e-001, 2.309750e-001, 2.316014e-001, 2.322288e-001,
   2.328571e-001, 2.334866e-001, 2.341173e-001, 2.347496e-001, 2.353832e-001, 2.360178e-001, 2.366545e-001, 2.372924e-001, 2.379313e-001,
   2.385714e-001, 2.392125e-001, 2.398548e-001, 2.404980e-001, 2.411424e-001, 2.417877e-001, 2.424340e-001, 2.430818e-001, 2.437308e-001,
   2.443806e-001, 2.450310e-001, 2.456824e-001, 2.463345e-001, 2.469875e-001, 2.476415e-001, 2.482966e-001, 2.489524e-001, 2.496098e-001,
   2.502687e-001, 2.509285e-001, 2.515894e-001, 2.522517e-001, 2.529152e-001, 2.535800e-001, 2.542463e-001, 2.549144e-001, 2.555841e-001,
   2.562555e-001, 2.569287e-001, 2.576029e-001, 2.582783e-001, 2.589545e-001, 2.596323e-001, 2.603114e-001, 2.609921e-001, 2.616743e-001,
   2.623580e-001, 2.630435e-001, 2.637309e-001, 2.644197e-001, 2.651098e-001, 2.658010e-001, 2.664934e-001, 2.671868e-001, 2.678814e-001,
   2.685770e-001, 2.692738e-001, 2.699717e-001, 2.706715e-001, 2.713726e-001, 2.720750e-001, 2.727788e-001, 2.734841e-001, 2.741906e-001,
   2.748987e-001, 2.756084e-001, 2.763193e-001, 2.770315e-001, 2.777453e-001, 2.784602e-001, 2.791761e-001, 2.798931e-001, 2.806108e-001,
   2.813291e-001, 2.820484e-001, 2.827687e-001, 2.834894e-001, 2.842107e-001, 2.849328e-001, 2.856559e-001, 2.863794e-001, 2.871033e-001,
   2.878280e-001, 2.885538e-001, 2.892806e-001, 2.900085e-001, 2.907377e-001, 2.914678e-001, 2.921990e-001, 2.929322e-001, 2.936666e-001,
   2.944022e-001, 2.951392e-001, 2.958773e-001, 2.966168e-001, 2.973575e-001, 2.980994e-001, 2.988425e-001, 2.995872e-001, 3.003341e-001,
   3.010828e-001, 3.018327e-001, 3.025843e-001, 3.033377e-001, 3.040933e-001, 3.048509e-001, 3.056102e-001, 3.063707e-001, 3.071326e-001,
   3.078965e-001, 3.086619e-001, 3.094288e-001, 3.101971e-001, 3.109667e-001, 3.117377e-001, 3.125102e-001, 3.132843e-001, 3.140597e-001,
   3.148362e-001, 3.156143e-001, 3.163942e-001, 3.171757e-001, 3.179586e-001, 3.187431e-001, 3.195291e-001, 3.203168e-001, 3.211061e-001,
   3.218967e-001, 3.226890e-001, 3.234832e-001, 3.242806e-001, 3.250800e-001, 3.258812e-001, 3.266844e-001, 3.274893e-001, 3.282961e-001,
   3.291047e-001, 3.299151e-001, 3.307276e-001, 3.315426e-001, 3.323615e-001, 3.331823e-001, 3.340052e-001, 3.348296e-001, 3.356559e-001,
   3.364836e-001, 3.373129e-001, 3.381440e-001, 3.389768e-001, 3.398111e-001, 3.406486e-001, 3.414881e-001, 3.423288e-001, 3.431714e-001,
   3.440159e-001, 3.448618e-001, 3.457091e-001, 3.465585e-001, 3.474094e-001, 3.482619e-001, 3.491170e-001, 3.499750e-001, 3.508346e-001,
   3.516960e-001, 3.525590e-001, 3.534239e-001, 3.542906e-001, 3.551589e-001, 3.560288e-001, 3.569002e-001, 3.577739e-001, 3.586511e-001,
   3.595298e-001, 3.604101e-001, 3.612919e-001, 3.621754e-001, 3.630602e-001, 3.639464e-001, 3.648337e-001, 3.657226e-001, 3.666130e-001,
   3.675079e-001, 3.684047e-001, 3.693031e-001, 3.702028e-001, 3.711038e-001, 3.720055e-001, 3.729085e-001, 3.738129e-001, 3.747189e-001,
   3.756259e-001, 3.765372e-001, 3.774503e-001, 3.783655e-001, 3.792823e-001, 3.802004e-001, 3.811199e-001, 3.820413e-001, 3.829644e-001,
   3.838895e-001, 3.848165e-001, 3.857473e-001, 3.866814e-001, 3.876177e-001, 3.885556e-001, 3.894956e-001, 3.904372e-001, 3.913807e-001,
   3.923261e-001, 3.932734e-001, 3.942231e-001, 3.951765e-001, 3.961346e-001, 3.970947e-001, 3.980568e-001, 3.990208e-001, 3.999867e-001,
   4.009543e-001, 4.019241e-001, 4.028963e-001, 4.038703e-001, 4.048471e-001, 4.058301e-001, 4.068154e-001, 4.078022e-001, 4.087909e-001,
   4.097813e-001, 4.107738e-001, 4.117686e-001, 4.127655e-001, 4.137644e-001, 4.147651e-001, 4.157725e-001, 4.167821e-001, 4.177943e-001,
   4.188099e-001, 4.198286e-001, 4.208502e-001, 4.218751e-001, 4.229033e-001, 4.239342e-001, 4.249681e-001, 4.260087e-001, 4.270545e-001,
   4.281033e-001, 4.291544e-001, 4.302083e-001, 4.312648e-001, 4.323243e-001, 4.333859e-001, 4.344498e-001, 4.355162e-001, 4.365869e-001,
   4.376633e-001, 4.387419e-001, 4.398226e-001, 4.409054e-001, 4.419904e-001, 4.430772e-001, 4.441661e-001, 4.452577e-001, 4.463516e-001,
   4.474485e-001, 4.485527e-001, 4.496586e-001, 4.507668e-001, 4.518776e-001, 4.529909e-001, 4.541065e-001, 4.552241e-001, 4.563439e-001,
   4.574659e-001, 4.585899e-001, 4.597226e-001, 4.608568e-001, 4.619925e-001, 4.631293e-001, 4.642676e-001, 4.654081e-001, 4.665511e-001,
   4.676967e-001, 4.688444e-001, 4.699939e-001, 4.711507e-001, 4.723117e-001, 4.734752e-001, 4.746406e-001, 4.758081e-001, 4.769782e-001,
   4.781511e-001, 4.793259e-001, 4.805027e-001, 4.816828e-001, 4.828697e-001, 4.840633e-001, 4.852592e-001, 4.864575e-001, 4.876592e-001,
   4.888639e-001, 4.900715e-001, 4.912817e-001, 4.924951e-001, 4.937120e-001, 4.949337e-001, 4.961640e-001, 4.973977e-001, 4.986341e-001,
   4.998730e-001, 5.011138e-001, 5.023570e-001, 5.036028e-001, 5.048504e-001, 5.060995e-001, 5.073515e-001, 5.086140e-001, 5.098794e-001,
   5.111469e-001, 5.124161e-001, 5.136877e-001, 5.149620e-001, 5.162395e-001, 5.175194e-001, 5.188013e-001, 5.200862e-001, 5.213809e-001,
   5.226801e-001, 5.239816e-001, 5.252864e-001, 5.265944e-001, 5.279053e-001, 5.292193e-001, 5.305359e-001, 5.318561e-001, 5.331789e-001,
   5.345105e-001, 5.358494e-001, 5.371919e-001, 5.385380e-001, 5.398877e-001, 5.412416e-001, 5.425985e-001, 5.439588e-001, 5.453220e-001,
   5.466886e-001, 5.480612e-001, 5.494425e-001, 5.508270e-001, 5.522152e-001, 5.536064e-001, 5.550010e-001, 5.563989e-001, 5.578012e-001,
   5.592064e-001, 5.606141e-001, 5.620263e-001, 5.634495e-001, 5.648759e-001, 5.663060e-001, 5.677399e-001, 5.691766e-001, 5.706165e-001,
   5.720603e-001, 5.735081e-001, 5.749596e-001, 5.764154e-001, 5.778844e-001, 5.793581e-001, 5.808358e-001, 5.823175e-001, 5.838036e-001,
   5.852938e-001, 5.867884e-001, 5.882880e-001, 5.897926e-001, 5.913013e-001, 5.928210e-001, 5.943471e-001, 5.958764e-001, 5.974098e-001,
   5.989470e-001, 6.004887e-001, 6.020334e-001, 6.035817e-001, 6.051345e-001, 6.066907e-001, 6.082564e-001, 6.098326e-001, 6.114136e-001,
   6.129989e-001, 6.145888e-001, 6.161829e-001, 6.177816e-001, 6.193858e-001, 6.209950e-001, 6.226082e-001, 6.242284e-001, 6.258622e-001,
   6.275011e-001, 6.291444e-001, 6.307920e-001, 6.324457e-001, 6.341036e-001, 6.357665e-001, 6.374354e-001, 6.391098e-001, 6.407888e-001,
   6.424865e-001, 6.441900e-001, 6.458998e-001, 6.476140e-001, 6.493339e-001, 6.510594e-001, 6.527905e-001, 6.545270e-001, 6.562691e-001,
   6.580176e-001, 6.597829e-001, 6.615564e-001, 6.633360e-001, 6.651216e-001, 6.669126e-001, 6.687086e-001, 6.705112e-001, 6.723208e-001,
   6.741380e-001, 6.759613e-001, 6.777997e-001, 6.796534e-001, 6.815140e-001, 6.833799e-001, 6.852528e-001, 6.871315e-001, 6.890163e-001,
   6.909087e-001, 6.928068e-001, 6.947108e-001, 6.966290e-001, 6.985671e-001, 7.005132e-001, 7.024672e-001, 7.044298e-001, 7.063980e-001,
   7.083728e-001, 7.103546e-001, 7.123452e-001, 7.143444e-001, 7.163524e-001, 7.183896e-001, 7.204359e-001, 7.224905e-001, 7.245525e-001,
   7.266246e-001, 7.287066e-001, 7.307961e-001, 7.328947e-001, 7.350028e-001, 7.371211e-001, 7.392717e-001, 7.414343e-001, 7.436061e-001,
   7.457885e-001, 7.479840e-001, 7.501906e-001, 7.524064e-001, 7.546306e-001, 7.568639e-001, 7.591079e-001, 7.613802e-001, 7.636769e-001,
   7.659834e-001, 7.683037e-001, 7.706373e-001, 7.729814e-001, 7.753358e-001, 7.777012e-001, 7.800781e-001, 7.824678e-001, 7.848826e-001,
   7.873337e-001, 7.897965e-001, 7.922734e-001, 7.947627e-001, 7.972671e-001, 7.997864e-001, 8.023179e-001, 8.048668e-001, 8.074288e-001,
   8.100120e-001, 8.126469e-001, 8.152965e-001, 8.179622e-001, 8.206483e-001, 8.233516e-001, 8.260734e-001, 8.288131e-001, 8.315727e-001,
   8.343446e-001, 8.371342e-001, 8.399934e-001, 8.428773e-001, 8.457888e-001, 8.487272e-001, 8.516942e-001, 8.546887e-001, 8.577007e-001,
   8.607361e-001, 8.638108e-001, 8.669571e-001, 8.701564e-001, 8.734027e-001, 8.766781e-001, 8.799727e-001, 8.832960e-001, 8.866553e-001,
   8.900595e-001, 8.935105e-001, 8.969939e-001, 9.005120e-001, 9.045323e-001, 9.082241e-001, 9.119395e-001, 9.157112e-001, 9.195482e-001,
   9.234328e-001, 9.273786e-001, 9.314110e-001, 9.355407e-001, 9.397977e-001, 9.450196e-001, 9.509351e-001, 9.559072e-001, 9.607881e-001,
   9.656764e-001, 9.707481e-001, 9.773920e-001, 9.829417e-001, 9.885159e-001, 9.941525e-001, 1.000000e+000},
  {0.000000e+000,  -3.706679e-004, -6.814894e-004, -9.541366e-004, -1.200249e-003, -1.426712e-003, -1.637806e-003, -1.836267e-003, -2.024306e-003,
   -2.203649e-003, -2.376028e-003, -2.542911e-003, -2.704507e-003, -2.861239e-003, -3.013712e-003, -3.162217e-003, -3.307209e-003, -3.449026e-003,
   -3.587871e-003, -3.723937e-003, -3.857590e-003, -3.989245e-003, -4.119038e-003, -4.246882e-003, -4.372804e-003, -4.496979e-003, -4.619460e-003,
   -4.740346e-003, -4.859837e-003, -4.978036e-003, -5.094972e-003, -5.210795e-003, -5.325719e-003, -5.439404e-003, -5.551922e-003, -5.663349e-003,
   -5.773777e-003, -5.883208e-003, -5.991623e-003, -6.099054e-003, -6.205496e-003, -6.311011e-003, -6.415960e-003, -6.520054e-003, -6.623255e-003,
   -6.725578e-003, -6.826867e-003, -6.926829e-003, -7.026117e-003, -7.125291e-003, -7.223958e-003, -7.321931e-003, -7.419616e-003, -7.516768e-003,
   -7.613367e-003, -7.709394e-003, -7.804855e-003, -7.899793e-003, -7.994219e-003, -8.088160e-003, -8.181627e-003, -8.274628e-003, -8.367352e-003,
   -8.459712e-003, -8.551646e-003, -8.643177e-003, -8.734306e-003, -8.825122e-003, -8.915633e-003, -9.005845e-003, -9.095798e-003, -9.185478e-003,
   -9.275059e-003, -9.364625e-003, -9.454052e-003, -9.543292e-003, -9.632467e-003, -9.721534e-003, -9.810445e-003, -9.899013e-003, -9.987071e-003,
   -1.007457e-002, -1.016154e-002, -1.024815e-002, -1.033421e-002, -1.041978e-002, -1.050487e-002, -1.058952e-002, -1.067369e-002, -1.075741e-002,
   -1.084071e-002, -1.092361e-002, -1.100617e-002, -1.108853e-002, -1.117067e-002, -1.125255e-002, -1.133419e-002, -1.141559e-002, -1.149677e-002,
   -1.157775e-002, -1.165856e-002, -1.173920e-002, -1.181969e-002, -1.190009e-002, -1.198039e-002, -1.206064e-002, -1.214071e-002, -1.222067e-002,
   -1.230052e-002, -1.238033e-002, -1.246016e-002, -1.253995e-002, -1.261963e-002, -1.269928e-002, -1.277886e-002, -1.285834e-002, -1.293768e-002,
   -1.301696e-002, -1.309619e-002, -1.317537e-002, -1.325442e-002, -1.333328e-002, -1.341188e-002, -1.349014e-002, -1.356790e-002, -1.364519e-002,
   -1.372204e-002, -1.379850e-002, -1.387464e-002, -1.395054e-002, -1.402616e-002, -1.410158e-002, -1.417690e-002, -1.425209e-002, -1.432713e-002,
   -1.440206e-002, -1.447688e-002, -1.455162e-002, -1.462635e-002, -1.470105e-002, -1.477576e-002, -1.485047e-002, -1.492514e-002, -1.499979e-002,
   -1.507431e-002, -1.514875e-002, -1.522309e-002, -1.529729e-002, -1.537128e-002, -1.544510e-002, -1.551872e-002, -1.559211e-002, -1.566534e-002,
   -1.573837e-002, -1.581116e-002, -1.588368e-002, -1.595599e-002, -1.602805e-002, -1.609989e-002, -1.617154e-002, -1.624302e-002, -1.631431e-002,
   -1.638549e-002, -1.645658e-002, -1.652758e-002, -1.659843e-002, -1.666931e-002, -1.674024e-002, -1.681128e-002, -1.688244e-002, -1.695371e-002,
   -1.702501e-002, -1.709624e-002, -1.716739e-002, -1.723849e-002, -1.730947e-002, -1.738051e-002, -1.745163e-002, -1.752283e-002, -1.759406e-002,
   -1.766524e-002, -1.773627e-002, -1.780703e-002, -1.787745e-002, -1.794756e-002, -1.801728e-002, -1.808679e-002, -1.815616e-002, -1.822537e-002,
   -1.829451e-002, -1.836356e-002, -1.843253e-002, -1.850141e-002, -1.857021e-002, -1.863898e-002, -1.870764e-002, -1.877626e-002, -1.884488e-002,
   -1.891349e-002, -1.898213e-002, -1.905077e-002, -1.911940e-002, -1.918802e-002, -1.925665e-002, -1.932529e-002, -1.939390e-002, -1.946250e-002,
   -1.953126e-002, -1.960022e-002, -1.966929e-002, -1.973839e-002, -1.980742e-002, -1.987635e-002, -1.994515e-002, -2.001378e-002, -2.008226e-002,
   -2.015051e-002, -2.021878e-002, -2.028705e-002, -2.035529e-002, -2.042343e-002, -2.049135e-002, -2.055896e-002, -2.062620e-002, -2.069308e-002,
   -2.075966e-002, -2.082588e-002, -2.089190e-002, -2.095780e-002, -2.102356e-002, -2.108920e-002, -2.115471e-002, -2.122013e-002, -2.128543e-002,
   -2.135060e-002, -2.141563e-002, -2.148041e-002, -2.154502e-002, -2.160958e-002, -2.167410e-002, -2.173858e-002, -2.180305e-002, -2.186752e-002,
   -2.193206e-002, -2.199664e-002, -2.206132e-002, -2.212600e-002, -2.219079e-002, -2.225584e-002, -2.232107e-002, -2.238638e-002, -2.245158e-002,
   -2.251668e-002, -2.258156e-002, -2.264624e-002, -2.271071e-002, -2.277493e-002, -2.283878e-002, -2.290247e-002, -2.296599e-002, -2.302931e-002,
   -2.309241e-002, -2.315521e-002, -2.321774e-002, -2.328006e-002, -2.334218e-002, -2.340415e-002, -2.346577e-002, -2.352728e-002, -2.358872e-002,
   -2.365008e-002, -2.371140e-002, -2.377271e-002, -2.383406e-002, -2.389548e-002, -2.395701e-002, -2.401868e-002, -2.408025e-002, -2.414183e-002,
   -2.420345e-002, -2.426509e-002, -2.432674e-002, -2.438843e-002, -2.445014e-002, -2.451192e-002, -2.457374e-002, -2.463560e-002, -2.469736e-002,
   -2.475893e-002, -2.482029e-002, -2.488130e-002, -2.494192e-002, -2.500218e-002, -2.506217e-002, -2.512190e-002, -2.518141e-002, -2.524069e-002,
   -2.529971e-002, -2.535839e-002, -2.541694e-002, -2.547538e-002, -2.553373e-002, -2.559201e-002, -2.565024e-002, -2.570845e-002, -2.576659e-002,
   -2.582471e-002, -2.588276e-002, -2.594057e-002, -2.599835e-002, -2.605615e-002, -2.611396e-002, -2.617183e-002, -2.622978e-002, -2.628788e-002,
   -2.634617e-002, -2.640463e-002, -2.646321e-002, -2.652163e-002, -2.657998e-002, -2.663823e-002, -2.669640e-002, -2.675448e-002, -2.681251e-002,
   -2.687051e-002, -2.692845e-002, -2.698636e-002, -2.704422e-002, -2.710181e-002, -2.715913e-002, -2.721620e-002, -2.727303e-002, -2.732961e-002,
   -2.738607e-002, -2.744239e-002, -2.749860e-002, -2.755473e-002, -2.761084e-002, -2.766681e-002, -2.772261e-002, -2.777842e-002, -2.783429e-002,
   -2.789024e-002, -2.794629e-002, -2.800244e-002, -2.805873e-002, -2.811521e-002, -2.817192e-002, -2.822882e-002, -2.828570e-002, -2.834280e-002,
   -2.840004e-002, -2.845724e-002, -2.851419e-002, -2.857078e-002, -2.862705e-002, -2.868299e-002, -2.873860e-002, -2.879393e-002, -2.884878e-002,
   -2.890338e-002, -2.895779e-002, -2.901203e-002, -2.906603e-002, -2.911989e-002, -2.917366e-002, -2.922736e-002, -2.928097e-002, -2.933450e-002,
   -2.938782e-002, -2.944102e-002, -2.949424e-002, -2.954742e-002, -2.960054e-002, -2.965366e-002, -2.970681e-002, -2.975995e-002, -2.981312e-002,
   -2.986630e-002, -2.991938e-002, -2.997238e-002, -3.002534e-002, -3.007822e-002, -3.013107e-002, -3.018389e-002, -3.023667e-002, -3.028943e-002,
   -3.034215e-002, -3.039476e-002, -3.044718e-002, -3.049926e-002, -3.055110e-002, -3.060276e-002, -3.065431e-002, -3.070576e-002, -3.075712e-002,
   -3.080840e-002, -3.085961e-002, -3.091070e-002, -3.096169e-002, -3.101243e-002, -3.106309e-002, -3.111367e-002, -3.116420e-002, -3.121469e-002,
   -3.126514e-002, -3.131556e-002, -3.136598e-002, -3.141643e-002, -3.146690e-002, -3.151726e-002, -3.156767e-002, -3.161813e-002, -3.166863e-002,
   -3.171924e-002, -3.176988e-002, -3.182052e-002, -3.187118e-002, -3.192187e-002, -3.197253e-002, -3.202301e-002, -3.207326e-002, -3.212334e-002,
   -3.217328e-002, -3.222305e-002, -3.227273e-002, -3.232229e-002, -3.237167e-002, -3.242090e-002, -3.246988e-002, -3.251861e-002, -3.256704e-002,
   -3.261532e-002, -3.266345e-002, -3.271149e-002, -3.275949e-002, -3.280743e-002, -3.285532e-002, -3.290325e-002, -3.295123e-002, -3.299933e-002,
   -3.304744e-002, -3.309576e-002, -3.314423e-002, -3.319275e-002, -3.324120e-002, -3.328962e-002, -3.333797e-002, -3.338634e-002, -3.343478e-002,
   -3.348335e-002, -3.353190e-002, -3.358053e-002, -3.362921e-002, -3.367782e-002, -3.372615e-002, -3.377403e-002, -3.382148e-002, -3.386861e-002,
   -3.391553e-002, -3.396222e-002, -3.400862e-002, -3.405479e-002, -3.410073e-002, -3.414653e-002, -3.419220e-002, -3.423773e-002, -3.428312e-002,
   -3.432841e-002, -3.437359e-002, -3.441868e-002, -3.446361e-002, -3.450831e-002, -3.455297e-002, -3.459747e-002, -3.464185e-002, -3.468607e-002,
   -3.473020e-002, -3.477423e-002, -3.481817e-002, -3.486201e-002, -3.490574e-002, -3.494928e-002, -3.499275e-002, -3.503618e-002, -3.507956e-002,
   -3.512293e-002, -3.516630e-002, -3.520975e-002, -3.525324e-002, -3.529676e-002, -3.534028e-002, -3.538366e-002, -3.542705e-002, -3.547042e-002,
   -3.551377e-002, -3.555710e-002, -3.560045e-002, -3.564378e-002, -3.568709e-002, -3.573027e-002, -3.577331e-002, -3.581614e-002, -3.585881e-002,
   -3.590129e-002, -3.594360e-002, -3.598576e-002, -3.602773e-002, -3.606952e-002, -3.611116e-002, -3.615268e-002, -3.619413e-002, -3.623546e-002,
   -3.627668e-002, -3.631784e-002, -3.635900e-002, -3.640014e-002, -3.644132e-002, -3.648262e-002, -3.652412e-002, -3.656581e-002, -3.660775e-002,
   -3.664982e-002, -3.669177e-002, -3.673361e-002, -3.677528e-002, -3.681678e-002, -3.685804e-002, -3.689910e-002, -3.693993e-002, -3.698057e-002,
   -3.702106e-002, -3.706138e-002, -3.710139e-002, -3.714113e-002, -3.718066e-002, -3.721993e-002, -3.725895e-002, -3.729775e-002, -3.733637e-002,
   -3.737485e-002, -3.741322e-002, -3.745144e-002, -3.748950e-002, -3.752750e-002, -3.756548e-002, -3.760350e-002, -3.764158e-002, -3.767977e-002,
   -3.771805e-002, -3.775641e-002, -3.779489e-002, -3.783337e-002, -3.787178e-002, -3.791007e-002, -3.794830e-002, -3.798639e-002, -3.802438e-002,
   -3.806230e-002, -3.810014e-002, -3.813793e-002, -3.817563e-002, -3.821318e-002, -3.825045e-002, -3.828737e-002, -3.832406e-002, -3.836050e-002,
   -3.839677e-002, -3.843287e-002, -3.846884e-002, -3.850470e-002, -3.854052e-002, -3.857625e-002, -3.861182e-002, -3.864716e-002, -3.868239e-002,
   -3.871746e-002, -3.875244e-002, -3.878733e-002, -3.882217e-002, -3.885693e-002, -3.889170e-002, -3.892640e-002, -3.896107e-002, -3.899562e-002,
   -3.903022e-002, -3.906484e-002, -3.909959e-002, -3.913451e-002, -3.916969e-002, -3.920516e-002, -3.924068e-002, -3.927615e-002, -3.931141e-002,
   -3.934628e-002, -3.938083e-002, -3.941521e-002, -3.944940e-002, -3.948354e-002, -3.951762e-002, -3.955159e-002, -3.958545e-002, -3.961908e-002,
   -3.965240e-002, -3.968527e-002, -3.971775e-002, -3.975003e-002, -3.978216e-002, -3.981413e-002, -3.984592e-002, -3.987765e-002, -3.990928e-002,
   -3.994083e-002, -3.997228e-002, -4.000372e-002, -4.003494e-002, -4.006621e-002, -4.009753e-002, -4.012889e-002, -4.016029e-002, -4.019175e-002,
   -4.022323e-002, -4.025482e-002, -4.028651e-002, -4.031816e-002, -4.034928e-002, -4.038001e-002, -4.041021e-002, -4.043987e-002, -4.046904e-002,
   -4.049777e-002, -4.052604e-002, -4.055386e-002, -4.058123e-002, -4.060819e-002, -4.063445e-002, -4.066016e-002, -4.068559e-002, -4.071071e-002,
   -4.073550e-002, -4.075998e-002, -4.078422e-002, -4.080817e-002, -4.083200e-002, -4.085568e-002, -4.087897e-002, -4.090187e-002, -4.092459e-002,
   -4.094719e-002, -4.096969e-002, -4.099210e-002, -4.101449e-002, -4.103686e-002, -4.105920e-002, -4.108158e-002, -4.110390e-002, -4.112606e-002,
   -4.114836e-002, -4.117073e-002, -4.119310e-002, -4.121553e-002, -4.123802e-002, -4.126054e-002, -4.128316e-002, -4.130584e-002, -4.132856e-002,
   -4.135085e-002, -4.137302e-002, -4.139503e-002, -4.141678e-002, -4.143807e-002, -4.145884e-002, -4.147922e-002, -4.149924e-002, -4.151896e-002,
   -4.153841e-002, -4.155709e-002, -4.157537e-002, -4.159343e-002, -4.161128e-002, -4.162887e-002, -4.164627e-002, -4.166347e-002, -4.168053e-002,
   -4.169741e-002, -4.171409e-002, -4.173020e-002, -4.174598e-002, -4.176170e-002, -4.177730e-002, -4.179274e-002, -4.180804e-002, -4.182322e-002,
   -4.183832e-002, -4.185342e-002, -4.186857e-002, -4.188354e-002, -4.189808e-002, -4.191258e-002, -4.192692e-002, -4.194102e-002, -4.195492e-002,
   -4.196866e-002, -4.198221e-002, -4.199574e-002, -4.200906e-002, -4.202212e-002, -4.203427e-002, -4.204614e-002, -4.205764e-002, -4.206872e-002,
   -4.207938e-002, -4.208975e-002, -4.209985e-002, -4.210967e-002, -4.211916e-002, -4.212840e-002, -4.213661e-002, -4.214455e-002, -4.215232e-002,
   -4.216000e-002, -4.216734e-002, -4.217447e-002, -4.218140e-002, -4.218806e-002, -4.219447e-002, -4.220065e-002, -4.220590e-002, -4.221059e-002,
   -4.221494e-002, -4.221905e-002, -4.222291e-002, -4.222653e-002, -4.222977e-002, -4.223266e-002, -4.223517e-002, -4.223729e-002, -4.223869e-002,
   -4.223901e-002, -4.223891e-002, -4.223840e-002, -4.223757e-002, -4.223638e-002, -4.223492e-002, -4.223307e-002, -4.223087e-002, -4.222838e-002,
   -4.222556e-002, -4.222162e-002, -4.221757e-002, -4.221348e-002, -4.220947e-002, -4.220531e-002, -4.220112e-002, -4.219708e-002, -4.219321e-002,
   -4.218940e-002, -4.218563e-002, -4.218053e-002, -4.217517e-002, -4.216952e-002, -4.216340e-002, -4.215699e-002, -4.215031e-002, -4.214338e-002,
   -4.213612e-002, -4.212862e-002, -4.212073e-002, -4.211140e-002, -4.210105e-002, -4.209019e-002, -4.207889e-002, -4.206721e-002, -4.205518e-002,
   -4.204283e-002, -4.203028e-002, -4.201757e-002, -4.200449e-002, -4.199045e-002, -4.197544e-002, -4.196038e-002, -4.194520e-002, -4.192981e-002,
   -4.191421e-002, -4.189845e-002, -4.188271e-002, -4.186697e-002, -4.185102e-002, -4.183452e-002, -4.181683e-002, -4.179888e-002, -4.178052e-002,
   -4.176171e-002, -4.174234e-002, -4.172245e-002, -4.170208e-002, -4.168123e-002, -4.165968e-002, -4.163740e-002, -4.161329e-002, -4.158860e-002,
   -4.156345e-002, -4.153785e-002, -4.151176e-002, -4.148527e-002, -4.145833e-002, -4.143115e-002, -4.140336e-002, -4.137520e-002, -4.134533e-002,
   -4.131476e-002, -4.128380e-002, -4.125250e-002, -4.122076e-002, -4.118866e-002, -4.115623e-002, -4.112346e-002, -4.109010e-002, -4.105640e-002,
   -4.102135e-002, -4.098537e-002, -4.094922e-002, -4.091286e-002, -4.087644e-002, -4.083970e-002, -4.080263e-002, -4.076525e-002, -4.072758e-002,
   -4.068947e-002, -4.065014e-002, -4.060925e-002, -4.056795e-002, -4.052634e-002, -4.048442e-002, -4.044213e-002, -4.039922e-002, -4.035567e-002,
   -4.031139e-002, -4.026642e-002, -4.022038e-002, -4.017213e-002, -4.012325e-002, -4.007387e-002, -4.002381e-002, -3.997331e-002, -3.992227e-002,
   -3.987075e-002, -3.981876e-002, -3.976641e-002, -3.971344e-002, -3.965825e-002, -3.960252e-002, -3.954651e-002, -3.949009e-002, -3.943321e-002,
   -3.937609e-002, -3.931847e-002, -3.926059e-002, -3.920225e-002, -3.914344e-002, -3.908245e-002, -3.902008e-002, -3.895700e-002, -3.889304e-002,
   -3.882843e-002, -3.876326e-002, -3.869705e-002, -3.863003e-002, -3.856213e-002, -3.849353e-002, -3.842306e-002, -3.835093e-002, -3.827807e-002,
   -3.820454e-002, -3.813013e-002, -3.805510e-002, -3.797951e-002, -3.790342e-002, -3.782664e-002, -3.774921e-002, -3.767049e-002, -3.758917e-002,
   -3.750738e-002, -3.742498e-002, -3.734200e-002, -3.725849e-002, -3.717452e-002, -3.708996e-002, -3.700494e-002, -3.691950e-002, -3.683353e-002,
   -3.674412e-002, -3.665405e-002, -3.656320e-002, -3.647169e-002, -3.637960e-002, -3.628669e-002, -3.619290e-002, -3.609827e-002, -3.600281e-002,
   -3.590650e-002, -3.580699e-002, -3.570604e-002, -3.560407e-002, -3.550142e-002, -3.539778e-002, -3.529324e-002, -3.518797e-002, -3.508205e-002,
   -3.497529e-002, -3.486767e-002, -3.475733e-002, -3.464435e-002, -3.453039e-002, -3.441555e-002, -3.429960e-002, -3.418293e-002, -3.406567e-002,
   -3.394739e-002, -3.382821e-002, -3.370800e-002, -3.358524e-002, -3.345891e-002, -3.333127e-002, -3.320242e-002, -3.307204e-002, -3.294059e-002,
   -3.280808e-002, -3.267451e-002, -3.253969e-002, -3.240345e-002, -3.226576e-002, -3.212292e-002, -3.197874e-002, -3.183292e-002, -3.168610e-002,
   -3.153797e-002, -3.138799e-002, -3.123657e-002, -3.108369e-002, -3.092927e-002, -3.077294e-002, -3.061155e-002, -3.044834e-002, -3.028347e-002,
   -3.011670e-002, -2.994799e-002, -2.977748e-002, -2.960529e-002, -2.943169e-002, -2.925652e-002, -2.907966e-002, -2.889846e-002, -2.871340e-002,
   -2.852629e-002, -2.833704e-002, -2.814575e-002, -2.795228e-002, -2.775726e-002, -2.755995e-002, -2.736048e-002, -2.715863e-002, -2.695249e-002,
   -2.674042e-002, -2.652666e-002, -2.630985e-002, -2.609062e-002, -2.586830e-002, -2.564352e-002, -2.541669e-002, -2.518592e-002, -2.495234e-002,
   -2.471529e-002, -2.447100e-002, -2.422366e-002, -2.397329e-002, -2.371875e-002, -2.346003e-002, -2.319774e-002, -2.293137e-002, -2.266066e-002,
   -2.238920e-002, -2.211452e-002, -2.182980e-002, -2.154045e-002, -2.124386e-002, -2.094103e-002, -2.063227e-002, -2.031858e-002, -2.000225e-002,
   -1.968033e-002, -1.934677e-002, -1.898635e-002, -1.862573e-002, -1.826109e-002, -1.788969e-002, -1.751771e-002, -1.714099e-002, -1.675907e-002,
   -1.636672e-002, -1.596240e-002, -1.554893e-002, -1.512689e-002, -1.446370e-002, -1.400828e-002, -1.355645e-002, -1.309401e-002, -1.261733e-002,
   -1.213440e-002, -1.164163e-002, -1.113086e-002, -1.059870e-002, -1.003953e-002, -9.121323e-003, -7.871813e-003, -7.111556e-003, -6.411784e-003,
   -5.718638e-003, -4.962077e-003, -3.505064e-003, -2.593092e-003, -1.709185e-003, -8.650688e-004, 0.000000e+000},
  {0.000000e+000,  -1.380706e-003, -2.537619e-003, -3.548232e-003, -4.452111e-003, -5.273238e-003, -6.028433e-003, -6.728530e-003, -7.383660e-003,
   -7.999797e-003, -8.583057e-003, -9.135808e-003, -9.662426e-003, -1.016601e-002, -1.064938e-002, -1.111449e-002, -1.156316e-002, -1.199686e-002,
   -1.241708e-002, -1.282460e-002, -1.321998e-002, -1.360340e-002, -1.397568e-002, -1.433806e-002, -1.469119e-002, -1.503557e-002, -1.537149e-002,
   -1.569976e-002, -1.602076e-002, -1.633465e-002, -1.664175e-002, -1.694207e-002, -1.723519e-002, -1.752263e-002, -1.780453e-002, -1.808108e-002,
   -1.835268e-002, -1.861944e-002, -1.888151e-002, -1.913918e-002, -1.939260e-002, -1.964168e-002, -1.988536e-002, -2.012495e-002, -2.036070e-002,
   -2.059275e-002, -2.082114e-002, -2.104594e-002, -2.126740e-002, -2.148601e-002, -2.170167e-002, -2.191439e-002, -2.212292e-002, -2.232825e-002,
   -2.253078e-002, -2.273052e-002, -2.292768e-002, -2.312206e-002, -2.331385e-002, -2.350313e-002, -2.368987e-002, -2.387418e-002, -2.405547e-002,
   -2.423400e-002, -2.441034e-002, -2.458450e-002, -2.475648e-002, -2.492637e-002, -2.509422e-002, -2.526006e-002, -2.542396e-002, -2.558596e-002,
   -2.574561e-002, -2.590270e-002, -2.605803e-002, -2.621151e-002, -2.636305e-002, -2.651292e-002, -2.666100e-002, -2.680745e-002, -2.695221e-002,
   -2.709542e-002, -2.723671e-002, -2.737560e-002, -2.751293e-002, -2.764863e-002, -2.778284e-002, -2.791539e-002, -2.804663e-002, -2.817625e-002,
   -2.830440e-002, -2.843113e-002, -2.855648e-002, -2.867969e-002, -2.880139e-002, -2.892175e-002, -2.904081e-002, -2.915861e-002, -2.927501e-002,
   -2.939023e-002, -2.950419e-002, -2.961702e-002, -2.972864e-002, -2.983874e-002, -2.994745e-002, -3.005493e-002, -3.016126e-002, -3.026651e-002,
   -3.037072e-002, -3.047370e-002, -3.057557e-002, -3.067618e-002, -3.077586e-002, -3.087431e-002, -3.097135e-002, -3.106753e-002, -3.116268e-002,
   -3.125682e-002, -3.134997e-002, -3.144200e-002, -3.153315e-002, -3.162334e-002, -3.171247e-002, -3.180041e-002, -3.188698e-002, -3.197249e-002,
   -3.205701e-002, -3.214052e-002, -3.222297e-002, -3.230442e-002, -3.238497e-002, -3.246459e-002, -3.254320e-002, -3.262084e-002, -3.269717e-002,
   -3.277273e-002, -3.284746e-002, -3.292126e-002, -3.299417e-002, -3.306629e-002, -3.313748e-002, -3.320776e-002, -3.327724e-002, -3.334596e-002,
   -3.341351e-002, -3.348020e-002, -3.354618e-002, -3.361134e-002, -3.367560e-002, -3.373913e-002, -3.380186e-002, -3.386380e-002, -3.392484e-002,
   -3.398514e-002, -3.404450e-002, -3.410286e-002, -3.416045e-002, -3.421727e-002, -3.427326e-002, -3.432849e-002, -3.438296e-002, -3.443667e-002,
   -3.448964e-002, -3.454186e-002, -3.459316e-002, -3.464345e-002, -3.469297e-002, -3.474187e-002, -3.478997e-002, -3.483721e-002, -3.488369e-002,
   -3.492943e-002, -3.497440e-002, -3.501855e-002, -3.506201e-002, -3.510461e-002, -3.514654e-002, -3.518767e-002, -3.522810e-002, -3.526789e-002,
   -3.530703e-002, -3.534542e-002, -3.538307e-002, -3.542007e-002, -3.545643e-002, -3.549198e-002, -3.552687e-002, -3.556111e-002, -3.559473e-002,
   -3.562756e-002, -3.565969e-002, -3.569121e-002, -3.572212e-002, -3.575238e-002, -3.578202e-002, -3.581092e-002, -3.583915e-002, -3.586663e-002,
   -3.589350e-002, -3.591977e-002, -3.594546e-002, -3.597052e-002, -3.599497e-002, -3.601882e-002, -3.604210e-002, -3.606463e-002, -3.608645e-002,
   -3.610773e-002, -3.612835e-002, -3.614836e-002, -3.616768e-002, -3.618631e-002, -3.620431e-002, -3.622168e-002, -3.623839e-002, -3.625450e-002,
   -3.627005e-002, -3.628503e-002, -3.629932e-002, -3.631296e-002, -3.632598e-002, -3.633847e-002, -3.635038e-002, -3.636174e-002, -3.637250e-002,
   -3.638264e-002, -3.639216e-002, -3.640108e-002, -3.640939e-002, -3.641717e-002, -3.642438e-002, -3.643106e-002, -3.643709e-002, -3.644258e-002,
   -3.644748e-002, -3.645181e-002, -3.645561e-002, -3.645881e-002, -3.646151e-002, -3.646367e-002, -3.646530e-002, -3.646631e-002, -3.646684e-002,
   -3.646674e-002, -3.646602e-002, -3.646472e-002, -3.646297e-002, -3.646074e-002, -3.645806e-002, -3.645487e-002, -3.645102e-002, -3.644667e-002,
   -3.644175e-002, -3.643632e-002, -3.643045e-002, -3.642403e-002, -3.641717e-002, -3.640988e-002, -3.640208e-002, -3.639374e-002, -3.638486e-002,
   -3.637550e-002, -3.636551e-002, -3.635498e-002, -3.634391e-002, -3.633231e-002, -3.632014e-002, -3.630763e-002, -3.629470e-002, -3.628122e-002,
   -3.626727e-002, -3.625272e-002, -3.623763e-002, -3.622199e-002, -3.620586e-002, -3.618916e-002, -3.617198e-002, -3.615439e-002, -3.613635e-002,
   -3.611781e-002, -3.609870e-002, -3.607906e-002, -3.605882e-002, -3.603807e-002, -3.601676e-002, -3.599492e-002, -3.597259e-002, -3.594984e-002,
   -3.592654e-002, -3.590272e-002, -3.587838e-002, -3.585353e-002, -3.582817e-002, -3.580239e-002, -3.577611e-002, -3.574945e-002, -3.572249e-002,
   -3.569521e-002, -3.566761e-002, -3.563950e-002, -3.561093e-002, -3.558190e-002, -3.555245e-002, -3.552254e-002, -3.549221e-002, -3.546147e-002,
   -3.543020e-002, -3.539856e-002, -3.536657e-002, -3.533405e-002, -3.530107e-002, -3.526770e-002, -3.523396e-002, -3.519978e-002, -3.516531e-002,
   -3.513042e-002, -3.509512e-002, -3.505951e-002, -3.502372e-002, -3.498764e-002, -3.495120e-002, -3.491428e-002, -3.487697e-002, -3.483931e-002,
   -3.480125e-002, -3.476283e-002, -3.472405e-002, -3.468486e-002, -3.464545e-002, -3.460576e-002, -3.456561e-002, -3.452506e-002, -3.448406e-002,
   -3.444270e-002, -3.440093e-002, -3.435868e-002, -3.431606e-002, -3.427303e-002, -3.422971e-002, -3.418606e-002, -3.414212e-002, -3.409779e-002,
   -3.405301e-002, -3.400776e-002, -3.396208e-002, -3.391605e-002, -3.386957e-002, -3.382267e-002, -3.377538e-002, -3.372800e-002, -3.368010e-002,
   -3.363166e-002, -3.358280e-002, -3.353354e-002, -3.348386e-002, -3.343371e-002, -3.338318e-002, -3.333228e-002, -3.328091e-002, -3.322929e-002,
   -3.317728e-002, -3.312482e-002, -3.307187e-002, -3.301850e-002, -3.296473e-002, -3.291048e-002, -3.285585e-002, -3.280075e-002, -3.274511e-002,
   -3.268922e-002, -3.263287e-002, -3.257599e-002, -3.251866e-002, -3.246094e-002, -3.240277e-002, -3.234405e-002, -3.228488e-002, -3.222529e-002,
   -3.216523e-002, -3.210483e-002, -3.204412e-002, -3.198296e-002, -3.192145e-002, -3.185941e-002, -3.179673e-002, -3.173373e-002, -3.167030e-002,
   -3.160634e-002, -3.154205e-002, -3.147731e-002, -3.141236e-002, -3.134714e-002, -3.128146e-002, -3.121519e-002, -3.114855e-002, -3.108153e-002,
   -3.101401e-002, -3.094607e-002, -3.087780e-002, -3.080908e-002, -3.074024e-002, -3.067110e-002, -3.060149e-002, -3.053140e-002, -3.046100e-002,
   -3.039022e-002, -3.031896e-002, -3.024738e-002, -3.017548e-002, -3.010320e-002, -3.003072e-002, -2.995782e-002, -2.988463e-002, -2.981105e-002,
   -2.973687e-002, -2.966223e-002, -2.958726e-002, -2.951187e-002, -2.943599e-002, -2.935970e-002, -2.928309e-002, -2.920624e-002, -2.912890e-002,
   -2.905129e-002, -2.897328e-002, -2.889482e-002, -2.881596e-002, -2.873677e-002, -2.865708e-002, -2.857700e-002, -2.849654e-002, -2.841578e-002,
   -2.833468e-002, -2.825317e-002, -2.817117e-002, -2.808878e-002, -2.800621e-002, -2.792334e-002, -2.783999e-002, -2.775609e-002, -2.767181e-002,
   -2.758743e-002, -2.750263e-002, -2.741739e-002, -2.733178e-002, -2.724585e-002, -2.715948e-002, -2.707270e-002, -2.698558e-002, -2.689802e-002,
   -2.680999e-002, -2.672187e-002, -2.663339e-002, -2.654454e-002, -2.645518e-002, -2.636532e-002, -2.627522e-002, -2.618472e-002, -2.609368e-002,
   -2.600227e-002, -2.591044e-002, -2.581830e-002, -2.572573e-002, -2.563273e-002, -2.553920e-002, -2.544516e-002, -2.535077e-002, -2.525613e-002,
   -2.516088e-002, -2.506522e-002, -2.496913e-002, -2.487276e-002, -2.477599e-002, -2.467869e-002, -2.458091e-002, -2.448272e-002, -2.438410e-002,
   -2.428506e-002, -2.418560e-002, -2.408555e-002, -2.398503e-002, -2.388409e-002, -2.378300e-002, -2.368153e-002, -2.357962e-002, -2.347728e-002,
   -2.337452e-002, -2.327135e-002, -2.316767e-002, -2.306357e-002, -2.295886e-002, -2.285371e-002, -2.274818e-002, -2.264224e-002, -2.253584e-002,
   -2.242896e-002, -2.232174e-002, -2.221403e-002, -2.210588e-002, -2.199720e-002, -2.188807e-002, -2.177841e-002, -2.166840e-002, -2.155796e-002,
   -2.144709e-002, -2.133579e-002, -2.122389e-002, -2.111151e-002, -2.099879e-002, -2.088554e-002, -2.077186e-002, -2.065786e-002, -2.054348e-002,
   -2.042852e-002, -2.031323e-002, -2.019760e-002, -2.008134e-002, -1.996468e-002, -1.984768e-002, -1.973028e-002, -1.961242e-002, -1.949408e-002,
   -1.937530e-002, -1.925612e-002, -1.913650e-002, -1.901646e-002, -1.889604e-002, -1.877485e-002, -1.865308e-002, -1.853067e-002, -1.840764e-002,
   -1.828390e-002, -1.815937e-002, -1.803439e-002, -1.790873e-002, -1.778231e-002, -1.765525e-002, -1.752768e-002, -1.739967e-002, -1.727136e-002,
   -1.714254e-002, -1.701325e-002, -1.688353e-002, -1.675350e-002, -1.662305e-002, -1.649209e-002, -1.636058e-002, -1.622845e-002, -1.609593e-002,
   -1.596322e-002, -1.582997e-002, -1.569629e-002, -1.556213e-002, -1.542766e-002, -1.529277e-002, -1.515758e-002, -1.502197e-002, -1.488613e-002,
   -1.475005e-002, -1.461369e-002, -1.447692e-002, -1.433997e-002, -1.420284e-002, -1.406561e-002, -1.392816e-002, -1.379033e-002, -1.365225e-002,
   -1.351381e-002, -1.337487e-002, -1.323562e-002, -1.309598e-002, -1.295600e-002, -1.281558e-002, -1.267476e-002, -1.253351e-002, -1.239184e-002,
   -1.224976e-002, -1.210743e-002, -1.196473e-002, -1.182152e-002, -1.167779e-002, -1.153375e-002, -1.138952e-002, -1.124491e-002, -1.110006e-002,
   -1.095480e-002, -1.080910e-002, -1.066301e-002, -1.051664e-002, -1.036987e-002, -1.022263e-002, -1.007491e-002, -9.926863e-003, -9.778299e-003,
   -9.629206e-003, -9.479888e-003, -9.330225e-003, -9.180250e-003, -9.029736e-003, -8.878773e-003, -8.727338e-003, -8.575517e-003, -8.423305e-003,
   -8.270836e-003, -8.117941e-003, -7.964661e-003, -7.810990e-003, -7.656787e-003, -7.502118e-003, -7.347186e-003, -7.191605e-003, -7.035531e-003,
   -6.879039e-003, -6.722144e-003, -6.564889e-003, -6.407487e-003, -6.249413e-003, -6.090871e-003, -5.931831e-003, -5.772405e-003, -5.612440e-003,
   -5.452035e-003, -5.291017e-003, -5.129698e-003, -4.967789e-003, -4.805462e-003, -4.642417e-003, -4.478781e-003, -4.314676e-003, -4.149981e-003,
   -3.984674e-003, -3.818684e-003, -3.651952e-003, -3.484713e-003, -3.317105e-003, -3.149171e-003, -2.980807e-003, -2.811812e-003, -2.642034e-003,
   -2.471873e-003, -2.301294e-003, -2.130406e-003, -1.958804e-003, -1.786640e-003, -1.613924e-003, -1.440865e-003, -1.267425e-003, -1.093432e-003,
   -9.188499e-004, -7.437556e-004, -5.681595e-004, -3.918928e-004, -2.152634e-004, -3.840933e-005, 1.388878e-004,  3.167162e-004,  4.945427e-004,
   6.728475e-004,  8.514123e-004,  1.030223e-003,  1.209529e-003,  1.389108e-003,  1.569282e-003,  1.749760e-003,  1.930617e-003,  2.111944e-003,
   2.293420e-003,  2.475297e-003,  2.657542e-003,  2.840094e-003,  3.022974e-003,  3.206289e-003,  3.390227e-003,  3.574669e-003,  3.759420e-003,
   3.944650e-003,  4.129904e-003,  4.315339e-003,  4.501200e-003,  4.687318e-003,  4.873995e-003,  5.061234e-003,  5.248981e-003,  5.437239e-003,
   5.625715e-003,  5.814437e-003,  6.003174e-003,  6.192198e-003,  6.381767e-003,  6.571641e-003,  6.761942e-003,  6.952501e-003,  7.143531e-003,
   7.335128e-003,  7.526899e-003,  7.718937e-003,  7.911239e-003,  8.103503e-003,  8.296160e-003,  8.489272e-003,  8.682967e-003,  8.877145e-003,
   9.071732e-003,  9.266590e-003,  9.461674e-003,  9.657076e-003,  9.852716e-003,  1.004835e-002,  1.024472e-002,  1.044162e-002,  1.063897e-002,
   1.083673e-002,  1.103515e-002,  1.123390e-002,  1.143302e-002,  1.163246e-002,  1.183230e-002,  1.203209e-002,  1.223234e-002,  1.243312e-002,
   1.263429e-002,  1.283589e-002,  1.303791e-002,  1.324075e-002,  1.344416e-002,  1.364830e-002,  1.385287e-002,  1.405732e-002,  1.426189e-002,
   1.446701e-002,  1.467249e-002,  1.487877e-002,  1.508553e-002,  1.529243e-002,  1.549970e-002,  1.570735e-002,  1.591524e-002,  1.612325e-002,
   1.633149e-002,  1.653964e-002,  1.674808e-002,  1.695718e-002,  1.716665e-002,  1.737638e-002,  1.758647e-002,  1.779674e-002,  1.800720e-002,
   1.821791e-002,  1.842861e-002,  1.863974e-002,  1.885109e-002,  1.906238e-002,  1.927413e-002,  1.948622e-002,  1.969859e-002,  1.991134e-002,
   2.012457e-002,  2.033795e-002,  2.055052e-002,  2.076334e-002,  2.097614e-002,  2.118909e-002,  2.140257e-002,  2.161672e-002,  2.183073e-002,
   2.204468e-002,  2.225936e-002,  2.247434e-002,  2.268879e-002,  2.290243e-002,  2.311654e-002,  2.333120e-002,  2.354619e-002,  2.376138e-002,
   2.397638e-002,  2.419221e-002,  2.440812e-002,  2.462415e-002,  2.483977e-002,  2.505449e-002,  2.526956e-002,  2.548532e-002,  2.570141e-002,
   2.591753e-002,  2.613366e-002,  2.635010e-002,  2.656685e-002,  2.678406e-002,  2.700066e-002,  2.721644e-002,  2.743297e-002,  2.765008e-002,
   2.786691e-002,  2.808376e-002,  2.830037e-002,  2.851711e-002,  2.873420e-002,  2.895173e-002,  2.916914e-002,  2.938571e-002,  2.960230e-002,
   2.981918e-002,  3.003642e-002,  3.025388e-002,  3.047129e-002,  3.068832e-002,  3.090576e-002,  3.112341e-002,  3.134130e-002,  3.155832e-002,
   3.177516e-002,  3.199213e-002,  3.220943e-002,  3.242669e-002,  3.264375e-002,  3.286111e-002,  3.307851e-002,  3.329647e-002,  3.351449e-002,
   3.373148e-002,  3.394802e-002,  3.416480e-002,  3.438177e-002,  3.459905e-002,  3.481659e-002,  3.503397e-002,  3.525162e-002,  3.546922e-002,
   3.568671e-002,  3.590381e-002,  3.611971e-002,  3.633615e-002,  3.655233e-002,  3.676820e-002,  3.698390e-002,  3.719954e-002,  3.741477e-002,
   3.762999e-002,  3.784502e-002,  3.805927e-002,  3.827239e-002,  3.848548e-002,  3.869846e-002,  3.891112e-002,  3.912377e-002,  3.933628e-002,
   3.954853e-002,  3.976029e-002,  3.997216e-002,  4.018378e-002,  4.039365e-002,  4.060349e-002,  4.081284e-002,  4.102173e-002,  4.123006e-002,
   4.143837e-002,  4.164652e-002,  4.185434e-002,  4.206080e-002,  4.226710e-002,  4.247193e-002,  4.267628e-002,  4.288001e-002,  4.308339e-002,
   4.328656e-002,  4.348910e-002,  4.369158e-002,  4.389370e-002,  4.409512e-002,  4.429601e-002,  4.449555e-002,  4.469309e-002,  4.489005e-002,
   4.508657e-002,  4.528221e-002,  4.547716e-002,  4.567085e-002,  4.586390e-002,  4.605641e-002,  4.624848e-002,  4.643978e-002,  4.662839e-002,
   4.681564e-002,  4.700235e-002,  4.718857e-002,  4.737394e-002,  4.755836e-002,  4.774268e-002,  4.792619e-002,  4.810848e-002,  4.829004e-002,
   4.846807e-002,  4.864474e-002,  4.882018e-002,  4.899443e-002,  4.916763e-002,  4.933912e-002,  4.950947e-002,  4.967827e-002,  4.984503e-002,
   5.001084e-002,  5.017339e-002,  5.033537e-002,  5.049553e-002,  5.065465e-002,  5.081302e-002,  5.097031e-002,  5.112593e-002,  5.128044e-002,
   5.143252e-002,  5.158333e-002,  5.173167e-002,  5.187521e-002,  5.201761e-002,  5.215924e-002,  5.229866e-002,  5.243674e-002,  5.257302e-002,
   5.270632e-002,  5.283815e-002,  5.296871e-002,  5.309521e-002,  5.321711e-002,  5.333508e-002,  5.345026e-002,  5.356186e-002,  5.367134e-002,
   5.377853e-002,  5.388269e-002,  5.398251e-002,  5.407914e-002,  5.417283e-002,  5.425936e-002,  5.434245e-002,  5.442081e-002,  5.449691e-002,
   5.456919e-002,  5.463745e-002,  5.470278e-002,  5.476401e-002,  5.482035e-002,  5.487145e-002,  5.491466e-002,  5.495483e-002,  5.499070e-002,
   5.502202e-002,  5.504626e-002,  5.506480e-002,  5.507908e-002,  5.508837e-002,  5.509176e-002,  5.509037e-002,  5.508130e-002,  5.506469e-002,
   5.504226e-002,  5.501149e-002,  5.497314e-002,  5.492907e-002,  5.487915e-002,  5.482218e-002,  5.475930e-002,  5.468910e-002,  5.461169e-002,
   5.452295e-002,  5.442757e-002,  5.432349e-002,  5.421169e-002,  5.409030e-002,  5.396074e-002,  5.382497e-002,  5.367777e-002,  5.352149e-002,
   5.335712e-002,  5.318157e-002,  5.299479e-002,  5.279605e-002,  5.258339e-002,  5.235704e-002,  5.211555e-002,  5.186179e-002,  5.159240e-002,
   5.132070e-002,  5.103851e-002,  5.074100e-002,  5.043067e-002,  5.009421e-002,  4.973575e-002,  4.935512e-002,  4.895530e-002,  4.854740e-002,
   4.811690e-002,  4.764371e-002,  4.706587e-002,  4.650470e-002,  4.593629e-002,  4.534170e-002,  4.474376e-002,  4.412589e-002,  4.348096e-002,
   4.279121e-002,  4.205265e-002,  4.128471e-002,  4.048974e-002,  3.877263e-002,  3.788250e-002,  3.701317e-002,  3.610274e-002,  3.513388e-002,
   3.413506e-002,  3.308996e-002,  3.196537e-002,  3.074525e-002,  2.939912e-002,  2.658509e-002,  2.261612e-002,  2.050075e-002,  1.859532e-002,
   1.673826e-002,  1.467582e-002,  1.015304e-002,  7.539017e-003,  5.011997e-003,  2.597830e-003,  0.000000e+000},
  {0.000000e+000,  -1.966839e-003, -3.591180e-003, -4.993148e-003, -6.239044e-003, -7.361541e-003, -8.389511e-003, -9.339801e-003, -1.022619e-002,
   -1.106100e-002, -1.185191e-002, -1.259061e-002, -1.329160e-002, -1.396254e-002, -1.460719e-002, -1.522683e-002, -1.582421e-002, -1.639999e-002,
   -1.695729e-002, -1.749608e-002, -1.801787e-002, -1.851602e-002, -1.899179e-002, -1.945418e-002, -1.990387e-002, -2.034123e-002, -2.076620e-002,
   -2.117981e-002, -2.158230e-002, -2.197431e-002, -2.235616e-002, -2.272505e-002, -2.307672e-002, -2.342042e-002, -2.375600e-002, -2.408425e-002,
   -2.440564e-002, -2.472019e-002, -2.502813e-002, -2.532968e-002, -2.562541e-002, -2.591441e-002, -2.618794e-002, -2.645629e-002, -2.671985e-002,
   -2.697872e-002, -2.723388e-002, -2.748576e-002, -2.773307e-002, -2.797437e-002, -2.821109e-002, -2.844384e-002, -2.866481e-002, -2.887993e-002,
   -2.909166e-002, -2.929993e-002, -2.950482e-002, -2.970608e-002, -2.990367e-002, -3.009803e-002, -3.028875e-002, -3.047628e-002, -3.065546e-002,
   -3.082844e-002, -3.099849e-002, -3.116545e-002, -3.132970e-002, -3.149063e-002, -3.164834e-002, -3.180300e-002, -3.195478e-002, -3.210327e-002,
   -3.224521e-002, -3.237865e-002, -3.250892e-002, -3.263511e-002, -3.275758e-002, -3.287599e-002, -3.299138e-002, -3.310449e-002, -3.321632e-002,
   -3.332669e-002, -3.343441e-002, -3.353524e-002, -3.363447e-002, -3.373225e-002, -3.382829e-002, -3.392293e-002, -3.401612e-002, -3.410786e-002,
   -3.419812e-002, -3.428680e-002, -3.437388e-002, -3.445333e-002, -3.453058e-002, -3.460547e-002, -3.467862e-002, -3.474991e-002, -3.481909e-002,
   -3.488623e-002, -3.495141e-002, -3.501494e-002, -3.507679e-002, -3.513295e-002, -3.518527e-002, -3.523577e-002, -3.528423e-002, -3.533110e-002,
   -3.537587e-002, -3.541824e-002, -3.545852e-002, -3.549612e-002, -3.553209e-002, -3.556406e-002, -3.559189e-002, -3.561836e-002, -3.564298e-002,
   -3.566592e-002, -3.568723e-002, -3.570689e-002, -3.572536e-002, -3.574251e-002, -3.575848e-002, -3.577326e-002, -3.578487e-002, -3.579626e-002,
   -3.580776e-002, -3.581877e-002, -3.582928e-002, -3.583928e-002, -3.584837e-002, -3.585611e-002, -3.586263e-002, -3.586778e-002, -3.586777e-002,
   -3.586676e-002, -3.586409e-002, -3.585986e-002, -3.585433e-002, -3.584722e-002, -3.583791e-002, -3.582700e-002, -3.581450e-002, -3.580064e-002,
   -3.578282e-002, -3.576323e-002, -3.574255e-002, -3.572062e-002, -3.569772e-002, -3.567434e-002, -3.565025e-002, -3.562539e-002, -3.559966e-002,
   -3.557335e-002, -3.554447e-002, -3.551383e-002, -3.548306e-002, -3.545177e-002, -3.541966e-002, -3.538698e-002, -3.535371e-002, -3.531956e-002,
   -3.528466e-002, -3.524860e-002, -3.521048e-002, -3.516928e-002, -3.512678e-002, -3.508278e-002, -3.503683e-002, -3.498877e-002, -3.493888e-002,
   -3.488733e-002, -3.483457e-002, -3.478079e-002, -3.472583e-002, -3.466768e-002, -3.460757e-002, -3.454567e-002, -3.448217e-002, -3.441719e-002,
   -3.435115e-002, -3.428442e-002, -3.421753e-002, -3.415069e-002, -3.408377e-002, -3.401517e-002, -3.394597e-002, -3.387597e-002, -3.380535e-002,
   -3.373329e-002, -3.365997e-002, -3.358578e-002, -3.351067e-002, -3.343428e-002, -3.335670e-002, -3.327714e-002, -3.319585e-002, -3.311291e-002,
   -3.302862e-002, -3.294302e-002, -3.285606e-002, -3.276788e-002, -3.267851e-002, -3.258794e-002, -3.249626e-002, -3.240283e-002, -3.230723e-002,
   -3.220990e-002, -3.211058e-002, -3.200970e-002, -3.190722e-002, -3.180380e-002, -3.169973e-002, -3.159527e-002, -3.149043e-002, -3.138474e-002,
   -3.127840e-002, -3.117102e-002, -3.106265e-002, -3.095331e-002, -3.084328e-002, -3.073346e-002, -3.062434e-002, -3.051620e-002, -3.040860e-002,
   -3.030118e-002, -3.019367e-002, -3.008615e-002, -2.997844e-002, -2.987045e-002, -2.976202e-002, -2.965337e-002, -2.954412e-002, -2.943475e-002,
   -2.932485e-002, -2.921462e-002, -2.910414e-002, -2.899348e-002, -2.888244e-002, -2.877074e-002, -2.865821e-002, -2.854463e-002, -2.843042e-002,
   -2.831500e-002, -2.819846e-002, -2.808050e-002, -2.796133e-002, -2.784078e-002, -2.771842e-002, -2.759459e-002, -2.746935e-002, -2.734355e-002,
   -2.721726e-002, -2.709102e-002, -2.696490e-002, -2.683883e-002, -2.671293e-002, -2.658809e-002, -2.646330e-002, -2.633841e-002, -2.621351e-002,
   -2.608870e-002, -2.596409e-002, -2.583992e-002, -2.571572e-002, -2.559167e-002, -2.546747e-002, -2.534397e-002, -2.522034e-002, -2.509622e-002,
   -2.497177e-002, -2.484657e-002, -2.472044e-002, -2.459337e-002, -2.446517e-002, -2.433571e-002, -2.420496e-002, -2.407371e-002, -2.394179e-002,
   -2.380879e-002, -2.367483e-002, -2.353998e-002, -2.340412e-002, -2.326734e-002, -2.312955e-002, -2.299089e-002, -2.285134e-002, -2.271140e-002,
   -2.257144e-002, -2.243179e-002, -2.229282e-002, -2.215476e-002, -2.201766e-002, -2.188115e-002, -2.174519e-002, -2.160985e-002, -2.147536e-002,
   -2.134149e-002, -2.120844e-002, -2.107539e-002, -2.094222e-002, -2.080879e-002, -2.067517e-002, -2.054106e-002, -2.040646e-002, -2.027174e-002,
   -2.013647e-002, -2.000085e-002, -1.986546e-002, -1.972941e-002, -1.959259e-002, -1.945515e-002, -1.931705e-002, -1.917788e-002, -1.903774e-002,
   -1.889622e-002, -1.875334e-002, -1.860944e-002, -1.846543e-002, -1.832141e-002, -1.817748e-002, -1.803336e-002, -1.788895e-002, -1.774428e-002,
   -1.759905e-002, -1.745355e-002, -1.730772e-002, -1.716162e-002, -1.701596e-002, -1.687088e-002, -1.672629e-002, -1.658218e-002, -1.643854e-002,
   -1.629489e-002, -1.615134e-002, -1.600750e-002, -1.586341e-002, -1.571896e-002, -1.557404e-002, -1.542910e-002, -1.528392e-002, -1.513796e-002,
   -1.499090e-002, -1.484271e-002, -1.469360e-002, -1.454325e-002, -1.439152e-002, -1.423813e-002, -1.408320e-002, -1.392718e-002, -1.376950e-002,
   -1.361051e-002, -1.345110e-002, -1.329235e-002, -1.313460e-002, -1.297773e-002, -1.282185e-002, -1.266683e-002, -1.251242e-002, -1.235853e-002,
   -1.220519e-002, -1.205217e-002, -1.189931e-002, -1.174701e-002, -1.159466e-002, -1.144194e-002, -1.128911e-002, -1.113615e-002, -1.098294e-002,
   -1.082924e-002, -1.067501e-002, -1.051984e-002, -1.036434e-002, -1.020873e-002, -1.005245e-002, -9.895465e-003, -9.738041e-003, -9.579849e-003,
   -9.420823e-003, -9.261355e-003, -9.101149e-003, -8.940406e-003, -8.779631e-003, -8.618267e-003, -8.456074e-003, -8.293726e-003, -8.131020e-003,
   -7.967837e-003, -7.804873e-003, -7.641933e-003, -7.479290e-003, -7.317384e-003, -7.155562e-003, -6.993296e-003, -6.831157e-003, -6.669236e-003,
   -6.507261e-003, -6.345222e-003, -6.183646e-003, -6.022218e-003, -5.860293e-003, -5.698692e-003, -5.536748e-003, -5.374494e-003, -5.212143e-003,
   -5.049675e-003, -4.886855e-003, -4.723991e-003, -4.561025e-003, -4.397728e-003, -4.233721e-003, -4.068919e-003, -3.903604e-003, -3.737749e-003,
   -3.570730e-003, -3.403513e-003, -3.235868e-003, -3.067657e-003, -2.898930e-003, -2.729813e-003, -2.560363e-003, -2.391116e-003, -2.222493e-003,
   -2.054283e-003, -1.886625e-003, -1.718936e-003, -1.551512e-003, -1.384398e-003, -1.217584e-003, -1.051581e-003, -8.858093e-004, -7.201158e-004,
   -5.547316e-004, -3.895848e-004, -2.243384e-004, -5.921775e-005, 1.059822e-004,  2.712131e-004,  4.370167e-004,  6.036588e-004,  7.713905e-004,
   9.400408e-004,  1.110214e-003,  1.281555e-003,  1.453370e-003,  1.625212e-003,  1.797671e-003,  1.970354e-003,  2.143343e-003,  2.317256e-003,
   2.492200e-003,  2.668139e-003,  2.844772e-003,  3.021951e-003,  3.199321e-003,  3.376032e-003,  3.551143e-003,  3.724886e-003,  3.897569e-003,
   4.069707e-003,  4.241390e-003,  4.412715e-003,  4.583785e-003,  4.753939e-003,  4.924032e-003,  5.093895e-003,  5.263328e-003,  5.432351e-003,
   5.601433e-003,  5.770470e-003,  5.939402e-003,  6.108045e-003,  6.276087e-003,  6.444282e-003,  6.612206e-003,  6.779708e-003,  6.946687e-003,
   7.113328e-003,  7.279783e-003,  7.446017e-003,  7.612186e-003,  7.778048e-003,  7.943520e-003,  8.108631e-003,  8.273793e-003,  8.438541e-003,
   8.603300e-003,  8.768351e-003,  8.934221e-003,  9.100179e-003,  9.266750e-003,  9.433547e-003,  9.599827e-003,  9.766012e-003,  9.932237e-003,
   1.009857e-002,  1.026489e-002,  1.043112e-002,  1.059739e-002,  1.076378e-002,  1.092990e-002,  1.109568e-002,  1.126048e-002,  1.142460e-002,
   1.158801e-002,  1.175065e-002,  1.191302e-002,  1.207466e-002,  1.223591e-002,  1.239666e-002,  1.255705e-002,  1.271685e-002,  1.287597e-002,
   1.303478e-002,  1.319331e-002,  1.335189e-002,  1.351070e-002,  1.366987e-002,  1.382948e-002,  1.398999e-002,  1.415172e-002,  1.431458e-002,
   1.447820e-002,  1.464091e-002,  1.480350e-002,  1.496528e-002,  1.512640e-002,  1.528697e-002,  1.544713e-002,  1.560691e-002,  1.576672e-002,
   1.592610e-002,  1.608575e-002,  1.624329e-002,  1.639994e-002,  1.655645e-002,  1.671218e-002,  1.686687e-002,  1.702112e-002,  1.717496e-002,
   1.732864e-002,  1.748210e-002,  1.763514e-002,  1.778652e-002,  1.793727e-002,  1.808838e-002,  1.823991e-002,  1.839187e-002,  1.854457e-002,
   1.869797e-002,  1.885149e-002,  1.900568e-002,  1.915961e-002,  1.931247e-002,  1.946403e-002,  1.961523e-002,  1.976594e-002,  1.991587e-002,
   2.006527e-002,  2.021437e-002,  2.036332e-002,  2.051137e-002,  2.065815e-002,  2.080310e-002,  2.094557e-002,  2.108679e-002,  2.122632e-002,
   2.136482e-002,  2.150281e-002,  2.164089e-002,  2.177871e-002,  2.191563e-002,  2.205207e-002,  2.218757e-002,  2.232051e-002,  2.245280e-002,
   2.258438e-002,  2.271551e-002,  2.284626e-002,  2.297666e-002,  2.310622e-002,  2.323546e-002,  2.336454e-002,  2.349375e-002,  2.362020e-002,
   2.374685e-002,  2.387338e-002,  2.400049e-002,  2.412878e-002,  2.425854e-002,  2.438938e-002,  2.452046e-002,  2.465088e-002,  2.478022e-002,
   2.490717e-002,  2.503224e-002,  2.515708e-002,  2.528110e-002,  2.540465e-002,  2.552781e-002,  2.565030e-002,  2.577199e-002,  2.589283e-002,
   2.601235e-002,  2.612937e-002,  2.624383e-002,  2.635685e-002,  2.646946e-002,  2.658120e-002,  2.669239e-002,  2.680348e-002,  2.691442e-002,
   2.702523e-002,  2.713526e-002,  2.724457e-002,  2.735194e-002,  2.746013e-002,  2.756777e-002,  2.767555e-002,  2.778380e-002,  2.789195e-002,
   2.799997e-002,  2.810846e-002,  2.821642e-002,  2.832466e-002,  2.843016e-002,  2.853420e-002,  2.863659e-002,  2.873672e-002,  2.883550e-002,
   2.893277e-002,  2.902819e-002,  2.912165e-002,  2.921310e-002,  2.930243e-002,  2.938811e-002,  2.947135e-002,  2.955326e-002,  2.963369e-002,
   2.971291e-002,  2.979015e-002,  2.986640e-002,  2.994159e-002,  3.001591e-002,  3.008902e-002,  3.016003e-002,  3.022845e-002,  3.029631e-002,
   3.036281e-002,  3.042880e-002,  3.049392e-002,  3.055882e-002,  3.062330e-002,  3.068711e-002,  3.075038e-002,  3.081252e-002,  3.087263e-002,
   3.093255e-002,  3.099232e-002,  3.105140e-002,  3.111032e-002,  3.116886e-002,  3.122663e-002,  3.128395e-002,  3.134037e-002,  3.139612e-002,
   3.144927e-002,  3.150173e-002,  3.155311e-002,  3.160231e-002,  3.164882e-002,  3.169281e-002,  3.173454e-002,  3.177476e-002,  3.181250e-002,
   3.184878e-002,  3.188169e-002,  3.191346e-002,  3.194373e-002,  3.197212e-002,  3.199901e-002,  3.202554e-002,  3.205045e-002,  3.207361e-002,
   3.209555e-002,  3.211650e-002,  3.213518e-002,  3.215201e-002,  3.216799e-002,  3.218322e-002,  3.219685e-002,  3.220924e-002,  3.222039e-002,
   3.223028e-002,  3.224050e-002,  3.225093e-002,  3.226026e-002,  3.226707e-002,  3.227286e-002,  3.227752e-002,  3.228153e-002,  3.228387e-002,
   3.228520e-002,  3.228611e-002,  3.228593e-002,  3.228524e-002,  3.228232e-002,  3.227557e-002,  3.226718e-002,  3.225747e-002,  3.224612e-002,
   3.223264e-002,  3.221771e-002,  3.220026e-002,  3.218160e-002,  3.216118e-002,  3.213981e-002,  3.211469e-002,  3.208782e-002,  3.206007e-002,
   3.203126e-002,  3.200167e-002,  3.197165e-002,  3.194031e-002,  3.190743e-002,  3.187400e-002,  3.183946e-002,  3.180115e-002,  3.175928e-002,
   3.171587e-002,  3.167146e-002,  3.162530e-002,  3.157741e-002,  3.152789e-002,  3.147663e-002,  3.142246e-002,  3.136501e-002,  3.130346e-002,
   3.123699e-002,  3.116953e-002,  3.109936e-002,  3.102779e-002,  3.095295e-002,  3.087560e-002,  3.079631e-002,  3.071589e-002,  3.063382e-002,
   3.054973e-002,  3.045998e-002,  3.036949e-002,  3.027739e-002,  3.018344e-002,  3.008859e-002,  2.999360e-002,  2.989827e-002,  2.980283e-002,
   2.970704e-002,  2.960970e-002,  2.950349e-002,  2.939527e-002,  2.928523e-002,  2.917266e-002,  2.905757e-002,  2.894071e-002,  2.882180e-002,
   2.869959e-002,  2.857575e-002,  2.845008e-002,  2.831566e-002,  2.817780e-002,  2.803695e-002,  2.789301e-002,  2.774673e-002,  2.759854e-002,
   2.744850e-002,  2.729682e-002,  2.714465e-002,  2.699143e-002,  2.683162e-002,  2.666496e-002,  2.649675e-002,  2.632743e-002,  2.615595e-002,
   2.598346e-002,  2.581048e-002,  2.563700e-002,  2.546115e-002,  2.528375e-002,  2.510156e-002,  2.491103e-002,  2.471859e-002,  2.452439e-002,
   2.432807e-002,  2.412877e-002,  2.392610e-002,  2.372015e-002,  2.351167e-002,  2.329986e-002,  2.308513e-002,  2.285558e-002,  2.262340e-002,
   2.238864e-002,  2.215123e-002,  2.191134e-002,  2.166893e-002,  2.142404e-002,  2.117648e-002,  2.092594e-002,  2.067282e-002,  2.040455e-002,
   2.013124e-002,  1.985568e-002,  1.957826e-002,  1.929783e-002,  1.901505e-002,  1.872934e-002,  1.844247e-002,  1.815118e-002,  1.785771e-002,
   1.755223e-002,  1.723858e-002,  1.692252e-002,  1.660536e-002,  1.628761e-002,  1.596799e-002,  1.564605e-002,  1.532118e-002,  1.499559e-002,
   1.466648e-002,  1.432733e-002,  1.397388e-002,  1.361818e-002,  1.326007e-002,  1.290029e-002,  1.253904e-002,  1.217461e-002,  1.180746e-002,
   1.143719e-002,  1.106476e-002,  1.068498e-002,  1.028033e-002,  9.872624e-003,  9.461763e-003,  9.049343e-003,  8.634534e-003,  8.216368e-003,
   7.795413e-003,  7.370769e-003,  6.943927e-003,  6.514843e-003,  6.061363e-003,  5.602106e-003,  5.141048e-003,  4.677731e-003,  4.213148e-003,
   3.746919e-003,  3.281348e-003,  2.812686e-003,  2.341426e-003,  1.867539e-003,  1.372858e-003,  8.657118e-004,  3.559656e-004,  -1.565810e-004,
   -6.724358e-004, -1.194563e-003, -1.719430e-003, -2.248734e-003, -2.781376e-003, -3.315120e-003, -3.866493e-003, -4.438732e-003, -5.015597e-003,
   -5.594566e-003, -6.175830e-003, -6.759827e-003, -7.346464e-003, -7.936339e-003, -8.528588e-003, -9.122071e-003, -9.725078e-003, -1.035609e-002,
   -1.098837e-002, -1.162109e-002, -1.225259e-002, -1.288795e-002, -1.352328e-002, -1.415860e-002, -1.479598e-002, -1.543840e-002, -1.608183e-002,
   -1.675517e-002, -1.743171e-002, -1.810839e-002, -1.878658e-002, -1.946581e-002, -2.014412e-002, -2.082697e-002, -2.151165e-002, -2.219821e-002,
   -2.288776e-002, -2.360226e-002, -2.432553e-002, -2.504945e-002, -2.577604e-002, -2.650347e-002, -2.723117e-002, -2.796133e-002, -2.869360e-002,
   -2.942647e-002, -3.016289e-002, -3.091634e-002, -3.168529e-002, -3.245680e-002, -3.322924e-002, -3.400264e-002, -3.477588e-002, -3.554869e-002,
   -3.632230e-002, -3.709553e-002, -3.786996e-002, -3.864972e-002, -3.944912e-002, -4.024791e-002, -4.104873e-002, -4.185212e-002, -4.265380e-002,
   -4.345909e-002, -4.426347e-002, -4.506652e-002, -4.586677e-002, -4.666974e-002, -4.749296e-002, -4.831592e-002, -4.913525e-002, -4.995770e-002,
   -5.078286e-002, -5.160197e-002, -5.242122e-002, -5.323735e-002, -5.404900e-002, -5.485658e-002, -5.567221e-002, -5.648935e-002, -5.730473e-002,
   -5.811605e-002, -5.892537e-002, -5.972585e-002, -6.052435e-002, -6.131953e-002, -6.210712e-002, -6.288800e-002, -6.366737e-002, -6.444464e-002,
   -6.521699e-002, -6.598779e-002, -6.675729e-002, -6.751857e-002, -6.827863e-002, -6.902994e-002, -6.977257e-002, -7.051074e-002, -7.123471e-002,
   -7.194008e-002, -7.264710e-002, -7.334053e-002, -7.402887e-002, -7.471274e-002, -7.539262e-002, -7.607043e-002, -7.672512e-002, -7.736703e-002,
   -7.799883e-002, -7.859128e-002, -7.916153e-002, -7.970872e-002, -8.023127e-002, -8.071652e-002, -8.117552e-002, -8.161300e-002, -8.202531e-002,
   -8.244722e-002, -8.285887e-002, -8.320079e-002, -8.351897e-002, -8.378219e-002, -8.401684e-002, -8.422844e-002, -8.442230e-002, -8.459404e-002,
   -8.471103e-002, -8.468607e-002, -8.432258e-002, -8.403595e-002, -8.378662e-002, -8.346766e-002, -8.314768e-002, -8.278308e-002, -8.236903e-002,
   -8.184399e-002, -8.119819e-002, -8.046697e-002, -7.966105e-002, -7.533033e-002, -7.419390e-002, -7.321201e-002, -7.215726e-002, -7.100417e-002,
   -6.984035e-002, -6.859966e-002, -6.718541e-002, -6.555212e-002, -6.358785e-002, -5.725615e-002, -4.660865e-002, -4.258397e-002, -3.927632e-002,
   -3.603078e-002, -3.204807e-002, -1.945943e-002, -1.376409e-002, -8.588147e-003, -4.240431e-003, 0.000000e+000},
  {0.000000e+000,  -3.778279e-003, -6.786376e-003, -9.305227e-003, -1.146437e-002, -1.335215e-002, -1.503918e-002, -1.656443e-002, -1.795737e-002,
   -1.927228e-002, -2.049997e-002, -2.166384e-002, -2.275593e-002, -2.377559e-002, -2.473027e-002, -2.562439e-002, -2.645844e-002, -2.723503e-002,
   -2.795514e-002, -2.862921e-002, -2.925882e-002, -2.986054e-002, -3.043680e-002, -3.098096e-002, -3.149602e-002, -3.198254e-002, -3.244185e-002,
   -3.287617e-002, -3.328632e-002, -3.367069e-002, -3.403109e-002, -3.437539e-002, -3.471309e-002, -3.503462e-002, -3.534025e-002, -3.563049e-002,
   -3.590648e-002, -3.616836e-002, -3.641770e-002, -3.665554e-002, -3.688275e-002, -3.710044e-002, -3.731963e-002, -3.752959e-002, -3.773055e-002,
   -3.792154e-002, -3.810049e-002, -3.826385e-002, -3.842028e-002, -3.857853e-002, -3.873136e-002, -3.887740e-002, -3.902315e-002, -3.916298e-002,
   -3.929706e-002, -3.942464e-002, -3.954672e-002, -3.966221e-002, -3.977213e-002, -3.987679e-002, -3.997667e-002, -4.007119e-002, -4.016473e-002,
   -4.025457e-002, -4.033815e-002, -4.041639e-002, -4.048804e-002, -4.055275e-002, -4.061056e-002, -4.066069e-002, -4.070341e-002, -4.073849e-002,
   -4.076647e-002, -4.078798e-002, -4.080105e-002, -4.080581e-002, -4.080122e-002, -4.078796e-002, -4.076755e-002, -4.074489e-002, -4.072293e-002,
   -4.070347e-002, -4.068556e-002, -4.067113e-002, -4.065914e-002, -4.064936e-002, -4.064094e-002, -4.063291e-002, -4.062728e-002, -4.062356e-002,
   -4.062129e-002, -4.061951e-002, -4.061845e-002, -4.061581e-002, -4.061126e-002, -4.060528e-002, -4.059728e-002, -4.058678e-002, -4.057251e-002,
   -4.055510e-002, -4.053355e-002, -4.050791e-002, -4.047722e-002, -4.043970e-002, -4.039611e-002, -4.034732e-002, -4.029268e-002, -4.023342e-002,
   -4.016961e-002, -4.009870e-002, -4.002226e-002, -3.993963e-002, -3.985184e-002, -3.975855e-002, -3.965877e-002, -3.955583e-002, -3.944882e-002,
   -3.933742e-002, -3.922167e-002, -3.910243e-002, -3.898025e-002, -3.885630e-002, -3.873339e-002, -3.861230e-002, -3.849282e-002, -3.837921e-002,
   -3.826981e-002, -3.816366e-002, -3.806035e-002, -3.795891e-002, -3.785762e-002, -3.775618e-002, -3.765372e-002, -3.754939e-002, -3.743724e-002,
   -3.732328e-002, -3.720648e-002, -3.708665e-002, -3.696350e-002, -3.683761e-002, -3.670773e-002, -3.657465e-002, -3.643898e-002, -3.630097e-002,
   -3.615454e-002, -3.600468e-002, -3.585407e-002, -3.570336e-002, -3.555241e-002, -3.540270e-002, -3.525445e-002, -3.510735e-002, -3.496037e-002,
   -3.481558e-002, -3.466761e-002, -3.451752e-002, -3.436860e-002, -3.422294e-002, -3.407909e-002, -3.393714e-002, -3.379553e-002, -3.365411e-002,
   -3.351250e-002, -3.337086e-002, -3.322462e-002, -3.307061e-002, -3.291406e-002, -3.275470e-002, -3.258993e-002, -3.242004e-002, -3.224683e-002,
   -3.207156e-002, -3.189502e-002, -3.171721e-002, -3.153787e-002, -3.134765e-002, -3.115390e-002, -3.095620e-002, -3.075535e-002, -3.055249e-002,
   -3.034935e-002, -3.014740e-002, -2.994889e-002, -2.975657e-002, -2.956913e-002, -2.937579e-002, -2.918342e-002, -2.899210e-002, -2.880221e-002,
   -2.861228e-002, -2.842260e-002, -2.823329e-002, -2.804370e-002, -2.785353e-002, -2.766238e-002, -2.746323e-002, -2.725889e-002, -2.705256e-002,
   -2.684487e-002, -2.663572e-002, -2.642563e-002, -2.621417e-002, -2.600079e-002, -2.578586e-002, -2.556915e-002, -2.534612e-002, -2.511226e-002,
   -2.487396e-002, -2.463040e-002, -2.438355e-002, -2.413528e-002, -2.388760e-002, -2.364143e-002, -2.339698e-002, -2.315466e-002, -2.291105e-002,
   -2.265831e-002, -2.240438e-002, -2.214980e-002, -2.189457e-002, -2.164068e-002, -2.139037e-002, -2.114575e-002, -2.090801e-002, -2.067663e-002,
   -2.044984e-002, -2.021510e-002, -1.998235e-002, -1.975166e-002, -1.952281e-002, -1.929543e-002, -1.906901e-002, -1.884372e-002, -1.862016e-002,
   -1.839793e-002, -1.817734e-002, -1.794902e-002, -1.771818e-002, -1.748761e-002, -1.725687e-002, -1.702580e-002, -1.679363e-002, -1.656042e-002,
   -1.632509e-002, -1.608786e-002, -1.584773e-002, -1.559841e-002, -1.533764e-002, -1.507097e-002, -1.479962e-002, -1.452627e-002, -1.425381e-002,
   -1.398337e-002, -1.371665e-002, -1.345292e-002, -1.319278e-002, -1.293273e-002, -1.266685e-002, -1.240360e-002, -1.214321e-002, -1.188608e-002,
   -1.163218e-002, -1.138398e-002, -1.114070e-002, -1.090141e-002, -1.066518e-002, -1.043167e-002, -1.018890e-002, -9.947636e-003, -9.707482e-003,
   -9.467606e-003, -9.227907e-003, -8.988176e-003, -8.747325e-003, -8.504651e-003, -8.259597e-003, -8.010941e-003, -7.751194e-003, -7.487530e-003,
   -7.222049e-003, -6.955965e-003, -6.689267e-003, -6.421473e-003, -6.152446e-003, -5.881950e-003, -5.610049e-003, -5.337010e-003, -5.056806e-003,
   -4.773926e-003, -4.495110e-003, -4.222550e-003, -3.957375e-003, -3.699009e-003, -3.445065e-003, -3.195864e-003, -2.949634e-003, -2.706695e-003,
   -2.463269e-003, -2.215863e-003, -1.970884e-003, -1.727762e-003, -1.485847e-003, -1.244941e-003, -1.004227e-003, -7.631903e-004, -5.225846e-004,
   -2.824247e-004, -4.058919e-005, 2.088256e-004,  4.579873e-004,  7.083758e-004,  9.599893e-004,  1.213376e-003,  1.469624e-003,  1.729799e-003,
   1.994671e-003,  2.264396e-003,  2.537229e-003,  2.819314e-003,  3.102117e-003,  3.383547e-003,  3.663172e-003,  3.941704e-003,  4.220204e-003,
   4.498431e-003,  4.775988e-003,  5.053130e-003,  5.328684e-003,  5.607015e-003,  5.884909e-003,  6.157092e-003,  6.424691e-003,  6.687545e-003,
   6.947930e-003,  7.205827e-003,  7.461321e-003,  7.715465e-003,  7.968929e-003,  8.224624e-003,  8.484386e-003,  8.744709e-003,  9.005815e-003,
   9.268433e-003,  9.533049e-003,  9.799401e-003,  1.006873e-002,  1.034145e-002,  1.061917e-002,  1.090187e-002,  1.119417e-002,  1.149068e-002,
   1.178929e-002,  1.208710e-002,  1.237983e-002,  1.266487e-002,  1.294242e-002,  1.321323e-002,  1.347745e-002,  1.373491e-002,  1.399231e-002,
   1.424472e-002,  1.449267e-002,  1.473638e-002,  1.497507e-002,  1.521069e-002,  1.544412e-002,  1.567557e-002,  1.590417e-002,  1.613019e-002,
   1.635811e-002,  1.658504e-002,  1.681039e-002,  1.703417e-002,  1.725669e-002,  1.747816e-002,  1.769793e-002,  1.791665e-002,  1.813553e-002,
   1.835449e-002,  1.857572e-002,  1.879873e-002,  1.902092e-002,  1.924127e-002,  1.946022e-002,  1.967725e-002,  1.989383e-002,  2.010889e-002,
   2.032180e-002,  2.053218e-002,  2.074033e-002,  2.094727e-002,  2.114976e-002,  2.134810e-002,  2.154276e-002,  2.173464e-002,  2.192419e-002,
   2.211184e-002,  2.229833e-002,  2.248210e-002,  2.266389e-002,  2.284829e-002,  2.303042e-002,  2.321075e-002,  2.339011e-002,  2.356888e-002,
   2.374685e-002,  2.392377e-002,  2.410171e-002,  2.428013e-002,  2.445969e-002,  2.464310e-002,  2.482880e-002,  2.501589e-002,  2.520466e-002,
   2.539466e-002,  2.558473e-002,  2.577512e-002,  2.596579e-002,  2.615712e-002,  2.634738e-002,  2.653747e-002,  2.672515e-002,  2.690960e-002,
   2.709133e-002,  2.727007e-002,  2.744684e-002,  2.762048e-002,  2.779108e-002,  2.795816e-002,  2.812039e-002,  2.827889e-002,  2.843507e-002,
   2.858845e-002,  2.873918e-002,  2.888721e-002,  2.903349e-002,  2.917947e-002,  2.932488e-002,  2.946949e-002,  2.961416e-002,  2.976193e-002,
   2.991529e-002,  3.007295e-002,  3.023333e-002,  3.039424e-002,  3.055355e-002,  3.071090e-002,  3.086741e-002,  3.102406e-002,  3.118197e-002,
   3.134134e-002,  3.150632e-002,  3.167296e-002,  3.184051e-002,  3.200591e-002,  3.216559e-002,  3.231644e-002,  3.245866e-002,  3.259443e-002,
   3.272530e-002,  3.285083e-002,  3.297491e-002,  3.309552e-002,  3.321129e-002,  3.332461e-002,  3.343451e-002,  3.354172e-002,  3.364481e-002,
   3.374538e-002,  3.384330e-002,  3.393852e-002,  3.403254e-002,  3.412545e-002,  3.421600e-002,  3.430281e-002,  3.438603e-002,  3.446546e-002,
   3.454220e-002,  3.461640e-002,  3.468709e-002,  3.475510e-002,  3.482058e-002,  3.488620e-002,  3.494951e-002,  3.501130e-002,  3.507118e-002,
   3.513017e-002,  3.518758e-002,  3.524496e-002,  3.530133e-002,  3.535658e-002,  3.541029e-002,  3.546530e-002,  3.552015e-002,  3.557269e-002,
   3.562289e-002,  3.567232e-002,  3.572066e-002,  3.576720e-002,  3.581137e-002,  3.585158e-002,  3.588632e-002,  3.591873e-002,  3.594815e-002,
   3.597272e-002,  3.599178e-002,  3.600564e-002,  3.601334e-002,  3.601588e-002,  3.601235e-002,  3.600455e-002,  3.599313e-002,  3.598049e-002,
   3.596644e-002,  3.595112e-002,  3.593366e-002,  3.591373e-002,  3.589394e-002,  3.587401e-002,  3.585543e-002,  3.583887e-002,  3.582519e-002,
   3.581472e-002,  3.580629e-002,  3.579381e-002,  3.577553e-002,  3.575036e-002,  3.571467e-002,  3.566920e-002,  3.561397e-002,  3.555059e-002,
   3.547879e-002,  3.539771e-002,  3.531256e-002,  3.521788e-002,  3.511371e-002,  3.500000e-002,  3.487890e-002,  3.475106e-002,  3.461671e-002,
   3.447704e-002,  3.433351e-002,  3.418622e-002,  3.404142e-002,  3.389589e-002,  3.374873e-002,  3.359978e-002,  3.345138e-002,  3.330475e-002,
   3.316183e-002,  3.301949e-002,  3.287904e-002,  3.274005e-002,  3.260503e-002,  3.247271e-002,  3.234054e-002,  3.220715e-002,  3.207431e-002,
   3.194163e-002,  3.181024e-002,  3.167968e-002,  3.155125e-002,  3.142206e-002,  3.129537e-002,  3.117132e-002,  3.104506e-002,  3.091577e-002,
   3.078345e-002,  3.064711e-002,  3.050877e-002,  3.036833e-002,  3.022656e-002,  3.008333e-002,  2.993928e-002,  2.980142e-002,  2.966119e-002,
   2.951746e-002,  2.937187e-002,  2.922562e-002,  2.907754e-002,  2.892724e-002,  2.877700e-002,  2.862645e-002,  2.847513e-002,  2.833268e-002,
   2.819198e-002,  2.805166e-002,  2.791404e-002,  2.778043e-002,  2.765126e-002,  2.752608e-002,  2.740240e-002,  2.727615e-002,  2.714497e-002,
   2.701512e-002,  2.688412e-002,  2.674930e-002,  2.660927e-002,  2.646620e-002,  2.632217e-002,  2.617570e-002,  2.602662e-002,  2.587258e-002,
   2.571193e-002,  2.554786e-002,  2.538503e-002,  2.521658e-002,  2.504415e-002,  2.486729e-002,  2.468660e-002,  2.450211e-002,  2.431411e-002,
   2.412415e-002,  2.393243e-002,  2.374165e-002,  2.355967e-002,  2.337595e-002,  2.319129e-002,  2.300602e-002,  2.282144e-002,  2.263715e-002,
   2.245256e-002,  2.226703e-002,  2.208080e-002,  2.188962e-002,  2.170272e-002,  2.150401e-002,  2.129037e-002,  2.106234e-002,  2.081796e-002,
   2.056065e-002,  2.029051e-002,  2.000564e-002,  1.970785e-002,  1.939921e-002,  1.908967e-002,  1.877302e-002,  1.844759e-002,  1.811245e-002,
   1.776782e-002,  1.741628e-002,  1.705827e-002,  1.669040e-002,  1.631598e-002,  1.593677e-002,  1.556193e-002,  1.518988e-002,  1.481252e-002,
   1.443024e-002,  1.404298e-002,  1.365170e-002,  1.325897e-002,  1.286554e-002,  1.247225e-002,  1.207856e-002,  1.169218e-002,  1.132497e-002,
   1.096137e-002,  1.059795e-002,  1.023831e-002,  9.880217e-003,  9.523918e-003,  9.170284e-003,  8.821918e-003,  8.476080e-003,  8.134338e-003,
   7.813432e-003,  7.490492e-003,  7.165004e-003,  6.832579e-003,  6.492566e-003,  6.141795e-003,  5.782214e-003,  5.415402e-003,  5.039957e-003,
   4.660200e-003,  4.294224e-003,  3.927508e-003,  3.556450e-003,  3.181603e-003,  2.802940e-003,  2.420006e-003,  2.034341e-003,  1.645073e-003,
   1.253660e-003,  8.571973e-004,  4.747085e-004,  1.021895e-004,  -2.733159e-004, -6.490595e-004, -1.025983e-003, -1.404754e-003, -1.785844e-003,
   -2.166046e-003, -2.545054e-003, -2.920506e-003, -3.281447e-003, -3.622679e-003, -3.962294e-003, -4.303671e-003, -4.649887e-003, -4.997182e-003,
   -5.347716e-003, -5.701594e-003, -6.059682e-003, -6.417756e-003, -6.773829e-003, -7.105894e-003, -7.444165e-003, -7.789014e-003, -8.142199e-003,
   -8.501984e-003, -8.868333e-003, -9.240628e-003, -9.619499e-003, -1.000216e-002, -1.038806e-002, -1.074392e-002, -1.109773e-002, -1.145422e-002,
   -1.181540e-002, -1.217650e-002, -1.253541e-002, -1.289335e-002, -1.325066e-002, -1.360607e-002, -1.396207e-002, -1.429384e-002, -1.461788e-002,
   -1.494387e-002, -1.526627e-002, -1.559258e-002, -1.591848e-002, -1.624901e-002, -1.658510e-002, -1.692640e-002, -1.727298e-002, -1.760473e-002,
   -1.791894e-002, -1.823932e-002, -1.856727e-002, -1.890077e-002, -1.924063e-002, -1.958724e-002, -1.993984e-002, -2.030038e-002, -2.066603e-002,
   -2.102580e-002, -2.135140e-002, -2.167948e-002, -2.201023e-002, -2.234486e-002, -2.268429e-002, -2.302581e-002, -2.336487e-002, -2.370174e-002,
   -2.403963e-002, -2.438464e-002, -2.468537e-002, -2.499296e-002, -2.530747e-002, -2.563513e-002, -2.597161e-002, -2.631502e-002, -2.666266e-002,
   -2.701296e-002, -2.737040e-002, -2.773330e-002, -2.806068e-002, -2.838371e-002, -2.871775e-002, -2.905858e-002, -2.940521e-002, -2.975703e-002,
   -3.011314e-002, -3.047322e-002, -3.083481e-002, -3.120337e-002, -3.154174e-002, -3.184960e-002, -3.215853e-002, -3.246662e-002, -3.277743e-002,
   -3.308532e-002, -3.339424e-002, -3.370158e-002, -3.400935e-002, -3.431619e-002, -3.460076e-002, -3.483435e-002, -3.507512e-002, -3.531981e-002,
   -3.557086e-002, -3.583204e-002, -3.609830e-002, -3.637111e-002, -3.664899e-002, -3.693739e-002, -3.722864e-002, -3.745590e-002, -3.769140e-002,
   -3.793261e-002, -3.817856e-002, -3.842905e-002, -3.868603e-002, -3.895068e-002, -3.921906e-002, -3.949457e-002, -3.977421e-002, -3.998629e-002,
   -4.018775e-002, -4.038910e-002, -4.060019e-002, -4.081298e-002, -4.102751e-002, -4.124583e-002, -4.146780e-002, -4.169144e-002, -4.191705e-002,
   -4.208992e-002, -4.222661e-002, -4.236221e-002, -4.249943e-002, -4.263342e-002, -4.277061e-002, -4.290645e-002, -4.304704e-002, -4.319248e-002,
   -4.334020e-002, -4.345690e-002, -4.351198e-002, -4.357233e-002, -4.363041e-002, -4.369060e-002, -4.375327e-002, -4.381826e-002, -4.389215e-002,
   -4.397413e-002, -4.406673e-002, -4.414843e-002, -4.414210e-002, -4.414140e-002, -4.414826e-002, -4.416194e-002, -4.417435e-002, -4.419210e-002,
   -4.421092e-002, -4.423286e-002, -4.425444e-002, -4.427900e-002, -4.419100e-002, -4.409243e-002, -4.399721e-002, -4.390398e-002, -4.380575e-002,
   -4.370322e-002, -4.360344e-002, -4.350542e-002, -4.340950e-002, -4.331944e-002, -4.314580e-002, -4.293684e-002, -4.273682e-002, -4.254710e-002,
   -4.236491e-002, -4.219374e-002, -4.203339e-002, -4.187979e-002, -4.173122e-002, -4.159195e-002, -4.140052e-002, -4.113887e-002, -4.088439e-002,
   -4.063536e-002, -4.038995e-002, -4.014413e-002, -3.990019e-002, -3.966431e-002, -3.943176e-002, -3.919557e-002, -3.892895e-002, -3.854901e-002,
   -3.817390e-002, -3.779922e-002, -3.742891e-002, -3.706369e-002, -3.669877e-002, -3.634091e-002, -3.598140e-002, -3.561627e-002, -3.525173e-002,
   -3.473044e-002, -3.420338e-002, -3.368344e-002, -3.315862e-002, -3.263199e-002, -3.211346e-002, -3.160120e-002, -3.108926e-002, -3.057891e-002,
   -3.006655e-002, -2.943242e-002, -2.876613e-002, -2.810458e-002, -2.745152e-002, -2.680560e-002, -2.616883e-002, -2.553842e-002, -2.491822e-002,
   -2.430788e-002, -2.369176e-002, -2.299806e-002, -2.223044e-002, -2.146536e-002, -2.070532e-002, -1.994321e-002, -1.919159e-002, -1.844348e-002,
   -1.769618e-002, -1.695097e-002, -1.620312e-002, -1.541079e-002, -1.449686e-002, -1.358570e-002, -1.267635e-002, -1.177188e-002, -1.087594e-002,
   -9.972071e-003, -9.075723e-003, -8.186147e-003, -7.298838e-003, -6.403344e-003, -5.335510e-003, -4.277439e-003, -3.222898e-003, -2.171006e-003,
   -1.107659e-003, -4.540933e-005, 1.033960e-003,  2.115767e-003,  3.193851e-003,  4.272948e-003,  5.500896e-003,  6.763265e-003,  8.021898e-003,
   9.281093e-003,  1.053455e-002,  1.178868e-002,  1.305516e-002,  1.432125e-002,  1.557356e-002,  1.680887e-002,  1.814650e-002,  1.954310e-002,
   2.094075e-002,  2.235043e-002,  2.375893e-002,  2.515883e-002,  2.655285e-002,  2.793617e-002,  2.929203e-002,  3.063485e-002,  3.202690e-002,
   3.349920e-002,  3.495898e-002,  3.640019e-002,  3.783443e-002,  3.927635e-002,  4.071000e-002,  4.214031e-002,  4.353427e-002,  4.490859e-002,
   4.629790e-002,  4.782648e-002,  4.932651e-002,  5.078565e-002,  5.221646e-002,  5.359495e-002,  5.494292e-002,  5.627183e-002,  5.757462e-002,
   5.888570e-002,  6.021349e-002,  6.165751e-002,  6.310311e-002,  6.453080e-002,  6.597170e-002,  6.743673e-002,  6.893331e-002,  7.038959e-002,
   7.177035e-002,  7.300503e-002,  7.394534e-002,  7.511746e-002,  7.642173e-002,  7.758371e-002,  7.865834e-002,  7.954943e-002,  8.028040e-002,
   8.079938e-002,  8.113260e-002,  8.136380e-002,  8.145903e-002,  7.854080e-002,  7.841114e-002,  7.834592e-002,  7.813521e-002,  7.777400e-002,
   7.745587e-002,  7.708642e-002,  7.650118e-002,  7.566620e-002,  7.440254e-002,  6.815737e-002,  5.930303e-002,  5.581550e-002,  5.273708e-002,
   4.957380e-002,  4.519876e-002,  2.620510e-002,  1.889050e-002,  1.221843e-002,  6.258578e-003,  0.000000e+000},
  {0.000000e+000,  -2.360896e-003, -4.274943e-003, -5.905649e-003, -7.368838e-003, -8.715672e-003, -9.986865e-003, -1.127152e-002, -1.255103e-002,
   -1.401107e-002, -1.540896e-002, -1.661416e-002, -1.776548e-002, -1.887420e-002, -1.992056e-002, -2.089192e-002, -2.177797e-002, -2.255967e-002,
   -2.323417e-002, -2.385498e-002, -2.443536e-002, -2.494330e-002, -2.538212e-002, -2.579366e-002, -2.618314e-002, -2.655469e-002, -2.691086e-002,
   -2.725425e-002, -2.758442e-002, -2.790527e-002, -2.821810e-002, -2.850432e-002, -2.874125e-002, -2.897076e-002, -2.919356e-002, -2.941006e-002,
   -2.962066e-002, -2.982512e-002, -3.002458e-002, -3.021412e-002, -3.039782e-002, -3.057600e-002, -3.071039e-002, -3.085683e-002, -3.101921e-002,
   -3.120300e-002, -3.146204e-002, -3.188786e-002, -3.229566e-002, -3.250488e-002, -3.264314e-002, -3.276630e-002, -3.283809e-002, -3.289057e-002,
   -3.293160e-002, -3.296372e-002, -3.298658e-002, -3.300410e-002, -3.301314e-002, -3.301770e-002, -3.301732e-002, -3.301279e-002, -3.298054e-002,
   -3.292965e-002, -3.287543e-002, -3.281661e-002, -3.275425e-002, -3.268864e-002, -3.261840e-002, -3.254792e-002, -3.247575e-002, -3.240479e-002,
   -3.231332e-002, -3.219677e-002, -3.207115e-002, -3.193980e-002, -3.180072e-002, -3.165655e-002, -3.150798e-002, -3.136203e-002, -3.122037e-002,
   -3.108775e-002, -3.095780e-002, -3.081271e-002, -3.067594e-002, -3.054767e-002, -3.042727e-002, -3.031475e-002, -3.021188e-002, -3.012629e-002,
   -3.005729e-002, -3.000457e-002, -2.996459e-002, -2.991192e-002, -2.986609e-002, -2.982627e-002, -2.979014e-002, -2.975685e-002, -2.972446e-002,
   -2.969059e-002, -2.965303e-002, -2.961156e-002, -2.956256e-002, -2.948764e-002, -2.939490e-002, -2.928878e-002, -2.916809e-002, -2.903948e-002,
   -2.890468e-002, -2.876563e-002, -2.862065e-002, -2.846906e-002, -2.831303e-002, -2.814246e-002, -2.795660e-002, -2.776824e-002, -2.757558e-002,
   -2.737743e-002, -2.717653e-002, -2.697106e-002, -2.676146e-002, -2.655060e-002, -2.633791e-002, -2.612573e-002, -2.590844e-002, -2.569521e-002,
   -2.548775e-002, -2.528486e-002, -2.508429e-002, -2.488695e-002, -2.469060e-002, -2.449273e-002, -2.429495e-002, -2.409691e-002, -2.388210e-002,
   -2.366506e-002, -2.344623e-002, -2.322420e-002, -2.299895e-002, -2.277070e-002, -2.253783e-002, -2.230124e-002, -2.206187e-002, -2.181865e-002,
   -2.156294e-002, -2.130231e-002, -2.104026e-002, -2.077838e-002, -2.051815e-002, -2.025831e-002, -2.000006e-002, -1.974314e-002, -1.948838e-002,
   -1.923539e-002, -1.897857e-002, -1.871924e-002, -1.846154e-002, -1.820525e-002, -1.795018e-002, -1.769669e-002, -1.744302e-002, -1.718785e-002,
   -1.693206e-002, -1.667613e-002, -1.641509e-002, -1.614473e-002, -1.587220e-002, -1.559493e-002, -1.531124e-002, -1.502021e-002, -1.472502e-002,
   -1.442649e-002, -1.412617e-002, -1.382395e-002, -1.352061e-002, -1.320828e-002, -1.289145e-002, -1.256965e-002, -1.224447e-002, -1.191597e-002,
   -1.158634e-002, -1.125793e-002, -1.093432e-002, -1.061726e-002, -1.030640e-002, -9.993893e-003, -9.682586e-003, -9.373169e-003, -9.066173e-003,
   -8.760538e-003, -8.455617e-003, -8.151591e-003, -7.847199e-003, -7.543073e-003, -7.237269e-003, -6.928794e-003, -6.617495e-003, -6.305938e-003,
   -5.993645e-003, -5.679285e-003, -5.364366e-003, -5.048492e-003, -4.731993e-003, -4.414662e-003, -4.095669e-003, -3.774429e-003, -3.446633e-003,
   -3.114165e-003, -2.776847e-003, -2.437561e-003, -2.099448e-003, -1.764101e-003, -1.432330e-003, -1.104074e-003, -7.790922e-004, -4.543868e-004,
   -1.275020e-004, 2.002446e-004,  5.283561e-004,  8.574387e-004,  1.185628e-003,  1.510524e-003,  1.830254e-003,  2.141882e-003,  2.447411e-003,
   2.747272e-003,  3.044848e-003,  3.338406e-003,  3.629571e-003,  3.919979e-003,  4.208891e-003,  4.496244e-003,  4.781103e-003,  5.064221e-003,
   5.345375e-003,  5.624560e-003,  5.900758e-003,  6.175870e-003,  6.450757e-003,  6.726506e-003,  7.002304e-003,  7.277071e-003,  7.552118e-003,
   7.828428e-003,  8.105385e-003,  8.384147e-003,  8.664888e-003,  8.950609e-003,  9.243485e-003,  9.542554e-003,  9.841377e-003,  1.013791e-002,
   1.043041e-002,  1.071721e-002,  1.099986e-002,  1.127745e-002,  1.154890e-002,  1.181582e-002,  1.207918e-002,  1.233816e-002,  1.259130e-002,
   1.283850e-002,  1.307568e-002,  1.330593e-002,  1.352991e-002,  1.374851e-002,  1.396283e-002,  1.416982e-002,  1.437312e-002,  1.457440e-002,
   1.477219e-002,  1.496488e-002,  1.515135e-002,  1.533460e-002,  1.551404e-002,  1.569097e-002,  1.586731e-002,  1.603821e-002,  1.620491e-002,
   1.636772e-002,  1.652547e-002,  1.667613e-002,  1.682034e-002,  1.695802e-002,  1.709067e-002,  1.721987e-002,  1.734386e-002,  1.746008e-002,
   1.756567e-002,  1.766106e-002,  1.774322e-002,  1.781093e-002,  1.786764e-002,  1.791514e-002,  1.795522e-002,  1.798977e-002,  1.801989e-002,
   1.804206e-002,  1.805476e-002,  1.806296e-002,  1.806841e-002,  1.807116e-002,  1.807273e-002,  1.807456e-002,  1.807728e-002,  1.808166e-002,
   1.808750e-002,  1.809402e-002,  1.809617e-002,  1.810150e-002,  1.811140e-002,  1.812623e-002,  1.814668e-002,  1.817493e-002,  1.821286e-002,
   1.826138e-002,  1.832033e-002,  1.838854e-002,  1.845877e-002,  1.853527e-002,  1.861878e-002,  1.870843e-002,  1.880372e-002,  1.890667e-002,
   1.901622e-002,  1.913154e-002,  1.925391e-002,  1.938211e-002,  1.950902e-002,  1.963660e-002,  1.976425e-002,  1.989111e-002,  2.001646e-002,
   2.014201e-002,  2.026922e-002,  2.039623e-002,  2.052702e-002,  2.066212e-002,  2.079641e-002,  2.093092e-002,  2.107065e-002,  2.121470e-002,
   2.136350e-002,  2.151766e-002,  2.167667e-002,  2.184260e-002,  2.201580e-002,  2.219621e-002,  2.238208e-002,  2.256652e-002,  2.275779e-002,
   2.295384e-002,  2.315021e-002,  2.334222e-002,  2.352593e-002,  2.370248e-002,  2.387301e-002,  2.403658e-002,  2.419374e-002,  2.433362e-002,
   2.446694e-002,  2.459478e-002,  2.471821e-002,  2.483618e-002,  2.495028e-002,  2.506116e-002,  2.516786e-002,  2.527170e-002,  2.537354e-002,
   2.546428e-002,  2.554905e-002,  2.563264e-002,  2.571565e-002,  2.579792e-002,  2.587973e-002,  2.596072e-002,  2.604172e-002,  2.612296e-002,
   2.620385e-002,  2.627993e-002,  2.634934e-002,  2.641793e-002,  2.648479e-002,  2.654848e-002,  2.660933e-002,  2.666906e-002,  2.672773e-002,
   2.678375e-002,  2.683798e-002,  2.688663e-002,  2.692371e-002,  2.695753e-002,  2.698646e-002,  2.701216e-002,  2.703694e-002,  2.706029e-002,
   2.708222e-002,  2.710441e-002,  2.712650e-002,  2.714839e-002,  2.715769e-002,  2.716565e-002,  2.717228e-002,  2.717899e-002,  2.718524e-002,
   2.719172e-002,  2.719880e-002,  2.720865e-002,  2.722124e-002,  2.723657e-002,  2.724388e-002,  2.725178e-002,  2.726217e-002,  2.727563e-002,
   2.728934e-002,  2.730537e-002,  2.732247e-002,  2.733968e-002,  2.735655e-002,  2.737263e-002,  2.737971e-002,  2.737885e-002,  2.737602e-002,
   2.737024e-002,  2.736166e-002,  2.735150e-002,  2.733956e-002,  2.732451e-002,  2.730438e-002,  2.727793e-002,  2.724206e-002,  2.719246e-002,
   2.713968e-002,  2.708444e-002,  2.702614e-002,  2.696616e-002,  2.690682e-002,  2.684817e-002,  2.678989e-002,  2.673148e-002,  2.667604e-002,
   2.661577e-002,  2.656029e-002,  2.650729e-002,  2.645613e-002,  2.640410e-002,  2.635084e-002,  2.629706e-002,  2.624410e-002,  2.619299e-002,
   2.614627e-002,  2.609591e-002,  2.604961e-002,  2.600482e-002,  2.595933e-002,  2.590764e-002,  2.584154e-002,  2.576003e-002,  2.566730e-002,
   2.556480e-002,  2.545335e-002,  2.532731e-002,  2.519074e-002,  2.504769e-002,  2.489727e-002,  2.474134e-002,  2.458094e-002,  2.441477e-002,
   2.424408e-002,  2.406926e-002,  2.389065e-002,  2.370325e-002,  2.350808e-002,  2.330940e-002,  2.310516e-002,  2.289756e-002,  2.268670e-002,
   2.247216e-002,  2.225307e-002,  2.203178e-002,  2.180787e-002,  2.158273e-002,  2.134920e-002,  2.111582e-002,  2.088052e-002,  2.064596e-002,
   2.041193e-002,  2.018045e-002,  1.995076e-002,  1.972457e-002,  1.950034e-002,  1.927617e-002,  1.904591e-002,  1.881836e-002,  1.859350e-002,
   1.837115e-002,  1.815161e-002,  1.793664e-002,  1.772397e-002,  1.751181e-002,  1.730085e-002,  1.709166e-002,  1.687527e-002,  1.665797e-002,
   1.644159e-002,  1.622558e-002,  1.600662e-002,  1.578945e-002,  1.557444e-002,  1.535957e-002,  1.514813e-002,  1.493803e-002,  1.472395e-002,
   1.450698e-002,  1.429042e-002,  1.407539e-002,  1.386222e-002,  1.365111e-002,  1.344279e-002,  1.324022e-002,  1.304365e-002,  1.285188e-002,
   1.266125e-002,  1.246627e-002,  1.226600e-002,  1.206146e-002,  1.183758e-002,  1.156838e-002,  1.125646e-002,  1.090574e-002,  1.051599e-002,
   1.008868e-002,  9.627202e-003,  9.128324e-003,  8.597165e-003,  8.035804e-003,  7.447901e-003,  6.835471e-003,  6.202072e-003,  5.551010e-003,
   4.884796e-003,  4.206815e-003,  3.519273e-003,  2.818272e-003,  2.110670e-003,  1.401120e-003,  6.903936e-004,  -1.638198e-005, -7.135974e-004,
   -1.398900e-003, -2.074787e-003, -2.737984e-003, -3.384653e-003, -4.020880e-003, -4.640462e-003, -5.241373e-003, -5.823547e-003, -6.383119e-003,
   -6.919046e-003, -7.425275e-003, -7.902649e-003, -8.346696e-003, -8.756090e-003, -9.132169e-003, -9.479906e-003, -9.791314e-003, -1.007961e-002,
   -1.035880e-002, -1.063062e-002, -1.089370e-002, -1.114753e-002, -1.139318e-002, -1.163197e-002, -1.186163e-002, -1.208560e-002, -1.230246e-002,
   -1.251026e-002, -1.271252e-002, -1.290469e-002, -1.308656e-002, -1.325855e-002, -1.342436e-002, -1.357860e-002, -1.372395e-002, -1.386068e-002,
   -1.398954e-002, -1.410597e-002, -1.421204e-002, -1.430540e-002, -1.438351e-002, -1.444606e-002, -1.449812e-002, -1.454279e-002, -1.458684e-002,
   -1.463257e-002, -1.467814e-002, -1.472142e-002, -1.476059e-002, -1.479612e-002, -1.482843e-002, -1.485531e-002, -1.487635e-002, -1.489828e-002,
   -1.492339e-002, -1.495162e-002, -1.498154e-002, -1.500862e-002, -1.503822e-002, -1.506732e-002, -1.509371e-002, -1.511928e-002, -1.514425e-002,
   -1.516862e-002, -1.518908e-002, -1.521013e-002, -1.522560e-002, -1.523903e-002, -1.524846e-002, -1.524989e-002, -1.524585e-002, -1.524007e-002,
   -1.523235e-002, -1.521934e-002, -1.520238e-002, -1.518278e-002, -1.517016e-002, -1.516821e-002, -1.518027e-002, -1.520240e-002, -1.523723e-002,
   -1.528238e-002, -1.534124e-002, -1.541303e-002, -1.549901e-002, -1.559409e-002, -1.569997e-002, -1.581460e-002, -1.594058e-002, -1.607554e-002,
   -1.621647e-002, -1.636636e-002, -1.652340e-002, -1.668474e-002, -1.685008e-002, -1.702049e-002, -1.720293e-002, -1.739779e-002, -1.760038e-002,
   -1.780702e-002, -1.801748e-002, -1.823522e-002, -1.845753e-002, -1.868053e-002, -1.890412e-002, -1.912907e-002, -1.935389e-002, -1.957958e-002,
   -1.980122e-002, -2.001761e-002, -2.023081e-002, -2.043903e-002, -2.064446e-002, -2.084856e-002, -2.104685e-002, -2.123686e-002, -2.142329e-002,
   -2.161328e-002, -2.180088e-002, -2.198794e-002, -2.217370e-002, -2.236667e-002, -2.256801e-002, -2.277625e-002, -2.299049e-002, -2.320262e-002,
   -2.341636e-002, -2.363713e-002, -2.385964e-002, -2.407775e-002, -2.429353e-002, -2.450728e-002, -2.472070e-002, -2.493195e-002, -2.513812e-002,
   -2.533786e-002, -2.553328e-002, -2.572258e-002, -2.590886e-002, -2.608742e-002, -2.626136e-002, -2.642732e-002, -2.658576e-002, -2.673664e-002,
   -2.687400e-002, -2.699704e-002, -2.710480e-002, -2.720365e-002, -2.729421e-002, -2.737359e-002, -2.745109e-002, -2.752881e-002, -2.761109e-002,
   -2.769737e-002, -2.778342e-002, -2.787029e-002, -2.795776e-002, -2.804384e-002, -2.813663e-002, -2.823293e-002, -2.833815e-002, -2.844657e-002,
   -2.856556e-002, -2.869072e-002, -2.881630e-002, -2.894820e-002, -2.908186e-002, -2.921889e-002, -2.936393e-002, -2.951308e-002, -2.966011e-002,
   -2.982728e-002, -3.004358e-002, -3.030748e-002, -3.061102e-002, -3.095579e-002, -3.133872e-002, -3.175770e-002, -3.221663e-002, -3.270650e-002,
   -3.321987e-002, -3.375717e-002, -3.431416e-002, -3.489001e-002, -3.547975e-002, -3.608464e-002, -3.670345e-002, -3.733331e-002, -3.797427e-002,
   -3.862149e-002, -3.927308e-002, -3.992326e-002, -4.057412e-002, -4.121805e-002, -4.184837e-002, -4.246811e-002, -4.306527e-002, -4.364204e-002,
   -4.419689e-002, -4.472849e-002, -4.522967e-002, -4.569501e-002, -4.612203e-002, -4.650379e-002, -4.684126e-002, -4.712785e-002, -4.735643e-002,
   -4.752612e-002, -4.763849e-002, -4.770748e-002, -4.771900e-002, -4.767239e-002, -4.755962e-002, -4.738832e-002, -4.719806e-002, -4.699385e-002,
   -4.676563e-002, -4.652292e-002, -4.626246e-002, -4.599168e-002, -4.570958e-002, -4.542004e-002, -4.511216e-002, -4.478959e-002, -4.444727e-002,
   -4.408761e-002, -4.371019e-002, -4.331740e-002, -4.290329e-002, -4.248020e-002, -4.204135e-002, -4.157690e-002, -4.108876e-002, -4.057962e-002,
   -4.005352e-002, -3.950325e-002, -3.892208e-002, -3.831182e-002, -3.767926e-002, -3.703787e-002, -3.638723e-002, -3.570871e-002, -3.500656e-002,
   -3.428858e-002, -3.355839e-002, -3.282371e-002, -3.207244e-002, -3.131090e-002, -3.054011e-002, -2.976208e-002, -2.898263e-002, -2.818930e-002,
   -2.738675e-002, -2.657148e-002, -2.574571e-002, -2.491286e-002, -2.406676e-002, -2.321062e-002, -2.234741e-002, -2.146643e-002, -2.058671e-002,
   -1.969661e-002, -1.880264e-002, -1.789329e-002, -1.697492e-002, -1.604023e-002, -1.509356e-002, -1.413334e-002, -1.316553e-002, -1.219498e-002,
   -1.121350e-002, -1.022420e-002, -9.218249e-003, -8.194948e-003, -7.166028e-003, -6.118933e-003, -5.062977e-003, -4.002526e-003, -2.938600e-003,
   -1.874053e-003, -8.124279e-004, 2.426266e-004,  1.299519e-003,  2.356924e-003,  3.423349e-003,  4.494925e-003,  5.567379e-003,  6.637724e-003,
   7.705697e-003,  8.774098e-003,  9.833285e-003,  1.086581e-002,  1.189999e-002,  1.292715e-002,  1.395299e-002,  1.497549e-002,  1.600173e-002,
   1.703227e-002,  1.805900e-002,  1.908315e-002,  2.011093e-002,  2.112233e-002,  2.213348e-002,  2.314845e-002,  2.416172e-002,  2.517577e-002,
   2.618429e-002,  2.719920e-002,  2.821283e-002,  2.923392e-002,  3.025381e-002,  3.124036e-002,  3.220577e-002,  3.316308e-002,  3.410222e-002,
   3.502958e-002,  3.594870e-002,  3.685940e-002,  3.774501e-002,  3.862478e-002,  3.950079e-002,  4.035807e-002,  4.118645e-002,  4.201368e-002,
   4.283345e-002,  4.364499e-002,  4.444504e-002,  4.522483e-002,  4.600111e-002,  4.677178e-002,  4.752748e-002,  4.826989e-002,  4.897104e-002,
   4.966668e-002,  5.035375e-002,  5.102643e-002,  5.169880e-002,  5.237010e-002,  5.304156e-002,  5.370162e-002,  5.436628e-002,  5.501398e-002,
   5.560999e-002,  5.619190e-002,  5.677848e-002,  5.734037e-002,  5.788572e-002,  5.841639e-002,  5.893213e-002,  5.943382e-002,  5.992121e-002,
   6.039367e-002,  6.080280e-002,  6.117986e-002,  6.150898e-002,  6.180408e-002,  6.205528e-002,  6.228023e-002,  6.246853e-002,  6.263032e-002,
   6.276013e-002,  6.284891e-002,  6.287447e-002,  6.282524e-002,  6.272784e-002,  6.258828e-002,  6.241053e-002,  6.222478e-002,  6.201195e-002,
   6.177584e-002,  6.151671e-002,  6.123411e-002,  6.090018e-002,  6.048345e-002,  6.003673e-002,  5.956052e-002,  5.905527e-002,  5.853810e-002,
   5.799391e-002,  5.740801e-002,  5.679262e-002,  5.615924e-002,  5.548418e-002,  5.470384e-002,  5.389553e-002,  5.305557e-002,  5.214974e-002,
   5.116006e-002,  5.012557e-002,  4.902787e-002,  4.785994e-002,  4.663504e-002,  4.536721e-002,  4.395278e-002,  4.248978e-002,  4.099954e-002,
   3.947331e-002,  3.791131e-002,  3.633650e-002,  3.470608e-002,  3.305575e-002,  3.140630e-002,  2.974680e-002,  2.798749e-002,  2.616536e-002,
   2.434344e-002,  2.247793e-002,  2.057273e-002,  1.865802e-002,  1.672675e-002,  1.478296e-002,  1.284464e-002,  1.090682e-002,  8.908942e-003,
   6.784438e-003,  4.679112e-003,  2.573731e-003,  4.510803e-004,  -1.689202e-003, -3.864831e-003, -6.055147e-003, -8.218578e-003, -1.038528e-002,
   -1.258716e-002, -1.503817e-002, -1.742672e-002, -1.978906e-002, -2.213819e-002, -2.441817e-002, -2.674576e-002, -2.907635e-002, -3.139250e-002,
   -3.364778e-002, -3.592420e-002, -3.835364e-002, -4.077078e-002, -4.329452e-002, -4.592237e-002, -4.866156e-002, -5.149681e-002, -5.426273e-002,
   -5.699712e-002, -5.989997e-002, -6.346216e-002, -6.690931e-002, -7.034904e-002, -7.359218e-002, -7.650300e-002, -7.901830e-002, -8.141704e-002,
   -8.367779e-002, -8.590537e-002, -8.815674e-002, -9.019702e-002, -9.961888e-002, -1.015927e-001, -1.026727e-001, -1.034023e-001, -1.038345e-001,
   -1.044770e-001, -1.051726e-001, -1.057127e-001, -1.059350e-001, -1.060081e-001, -1.063140e-001, -1.128114e-001, -1.102135e-001, -1.078385e-001,
   -1.045745e-001, -9.780112e-002, -4.743233e-002, -3.300751e-002, -2.056588e-002, -1.011251e-002, 0.000000e+000},
  {0.000000e+000,  -2.773723e-003, -4.854843e-003, -6.537040e-003, -7.956489e-003, -9.196058e-003, -1.031661e-002, -1.132384e-002, -1.225372e-002,
   -1.323209e-002, -1.418436e-002, -1.500351e-002, -1.577165e-002, -1.650604e-002, -1.720260e-002, -1.785847e-002, -1.846182e-002, -1.901137e-002,
   -1.950023e-002, -1.995570e-002, -2.038386e-002, -2.073590e-002, -2.102544e-002, -2.129326e-002, -2.154253e-002, -2.178024e-002, -2.200291e-002,
   -2.221362e-002, -2.241197e-002, -2.259943e-002, -2.277387e-002, -2.291684e-002, -2.301039e-002, -2.310126e-002, -2.318915e-002, -2.326970e-002,
   -2.334448e-002, -2.341005e-002, -2.347200e-002, -2.353164e-002, -2.358840e-002, -2.363768e-002, -2.363332e-002, -2.362303e-002, -2.360548e-002,
   -2.358069e-002, -2.353762e-002, -2.345716e-002, -2.337799e-002, -2.334174e-002, -2.331857e-002, -2.329896e-002, -2.324169e-002, -2.318121e-002,
   -2.312415e-002, -2.306789e-002, -2.301328e-002, -2.296062e-002, -2.290671e-002, -2.285306e-002, -2.280327e-002, -2.275406e-002, -2.268464e-002,
   -2.260119e-002, -2.251352e-002, -2.242769e-002, -2.233479e-002, -2.223801e-002, -2.213990e-002, -2.203381e-002, -2.192517e-002, -2.181069e-002,
   -2.168435e-002, -2.153639e-002, -2.138741e-002, -2.123439e-002, -2.108018e-002, -2.092026e-002, -2.075997e-002, -2.059931e-002, -2.044242e-002,
   -2.029065e-002, -2.013830e-002, -1.996660e-002, -1.979834e-002, -1.963692e-002, -1.947518e-002, -1.931697e-002, -1.916456e-002, -1.902057e-002,
   -1.888423e-002, -1.875235e-002, -1.863058e-002, -1.848985e-002, -1.834862e-002, -1.821183e-002, -1.807312e-002, -1.793880e-002, -1.780330e-002,
   -1.766932e-002, -1.753524e-002, -1.739700e-002, -1.725468e-002, -1.709396e-002, -1.692083e-002, -1.674136e-002, -1.655437e-002, -1.636301e-002,
   -1.617213e-002, -1.597793e-002, -1.578063e-002, -1.558220e-002, -1.538167e-002, -1.516939e-002, -1.494237e-002, -1.471584e-002, -1.448789e-002,
   -1.425976e-002, -1.403041e-002, -1.379895e-002, -1.356745e-002, -1.333578e-002, -1.310682e-002, -1.287389e-002, -1.263232e-002, -1.239941e-002,
   -1.217103e-002, -1.194886e-002, -1.173000e-002, -1.151290e-002, -1.129883e-002, -1.108733e-002, -1.087525e-002, -1.066307e-002, -1.043565e-002,
   -1.020888e-002, -9.983225e-003, -9.758086e-003, -9.531589e-003, -9.304608e-003, -9.075345e-003, -8.845927e-003, -8.618173e-003, -8.388267e-003,
   -8.143587e-003, -7.897512e-003, -7.652927e-003, -7.409256e-003, -7.169066e-003, -6.930755e-003, -6.693640e-003, -6.458103e-003, -6.226913e-003,
   -5.999515e-003, -5.767580e-003, -5.530633e-003, -5.294449e-003, -5.063163e-003, -4.833209e-003, -4.605478e-003, -4.379075e-003, -4.154908e-003,
   -3.930795e-003, -3.709459e-003, -3.485946e-003, -3.257005e-003, -3.025861e-003, -2.792860e-003, -2.557654e-003, -2.320999e-003, -2.083722e-003,
   -1.847119e-003, -1.610125e-003, -1.374844e-003, -1.139747e-003, -8.959992e-004, -6.515005e-004, -4.064176e-004, -1.605657e-004, 8.614537e-005,
   3.322379e-004,  5.772164e-004,  8.177365e-004,  1.052941e-003,  1.283767e-003,  1.516818e-003,  1.747570e-003,  1.976353e-003,  2.203168e-003,
   2.427776e-003,  2.650000e-003,  2.869864e-003,  3.090004e-003,  3.309298e-003,  3.527853e-003,  3.747580e-003,  3.966900e-003,  4.186325e-003,
   4.406693e-003,  4.627078e-003,  4.846718e-003,  5.065333e-003,  5.285225e-003,  5.504989e-003,  5.724243e-003,  5.943804e-003,  6.164628e-003,
   6.387680e-003,  6.612736e-003,  6.838571e-003,  7.061752e-003,  7.281200e-003,  7.497617e-003,  7.712072e-003,  7.924858e-003,  8.136520e-003,
   8.347502e-003,  8.557643e-003,  8.766034e-003,  8.973214e-003,  9.176951e-003,  9.376415e-003,  9.570995e-003,  9.760186e-003,  9.943433e-003,
   1.012192e-002,  1.029510e-002,  1.046271e-002,  1.062658e-002,  1.078758e-002,  1.094585e-002,  1.110277e-002,  1.125601e-002,  1.140530e-002,
   1.155114e-002,  1.169401e-002,  1.183166e-002,  1.196807e-002,  1.210191e-002,  1.223464e-002,  1.236576e-002,  1.249559e-002,  1.262561e-002,
   1.275491e-002,  1.288140e-002,  1.300689e-002,  1.313187e-002,  1.325814e-002,  1.338813e-002,  1.352184e-002,  1.365515e-002,  1.378680e-002,
   1.391487e-002,  1.403752e-002,  1.415750e-002,  1.427464e-002,  1.438744e-002,  1.449782e-002,  1.460584e-002,  1.471094e-002,  1.481179e-002,
   1.490885e-002,  1.499748e-002,  1.508268e-002,  1.516277e-002,  1.523994e-002,  1.531415e-002,  1.538215e-002,  1.544761e-002,  1.551175e-002,
   1.557406e-002,  1.563298e-002,  1.568836e-002,  1.574181e-002,  1.579332e-002,  1.584306e-002,  1.589336e-002,  1.594036e-002,  1.598541e-002,
   1.602722e-002,  1.606434e-002,  1.609903e-002,  1.613283e-002,  1.616610e-002,  1.619901e-002,  1.623229e-002,  1.626467e-002,  1.629456e-002,
   1.631907e-002,  1.633794e-002,  1.635046e-002,  1.635541e-002,  1.635449e-002,  1.634876e-002,  1.633922e-002,  1.632753e-002,  1.631524e-002,
   1.629836e-002,  1.627631e-002,  1.625073e-002,  1.622310e-002,  1.619299e-002,  1.616208e-002,  1.613029e-002,  1.609781e-002,  1.606556e-002,
   1.603184e-002,  1.599701e-002,  1.596184e-002,  1.592570e-002,  1.589060e-002,  1.585592e-002,  1.582230e-002,  1.579127e-002,  1.576421e-002,
   1.574032e-002,  1.571750e-002,  1.569755e-002,  1.567980e-002,  1.566457e-002,  1.565092e-002,  1.563728e-002,  1.562261e-002,  1.560835e-002,
   1.559357e-002,  1.557705e-002,  1.556064e-002,  1.554346e-002,  1.552706e-002,  1.550919e-002,  1.548602e-002,  1.545850e-002,  1.542740e-002,
   1.539396e-002,  1.535685e-002,  1.531549e-002,  1.527369e-002,  1.523174e-002,  1.519097e-002,  1.515373e-002,  1.511799e-002,  1.508243e-002,
   1.504638e-002,  1.501094e-002,  1.497452e-002,  1.493944e-002,  1.490661e-002,  1.487576e-002,  1.484711e-002,  1.482622e-002,  1.480654e-002,
   1.478655e-002,  1.476559e-002,  1.474008e-002,  1.470736e-002,  1.466916e-002,  1.462529e-002,  1.457629e-002,  1.452189e-002,  1.446931e-002,
   1.441358e-002,  1.435340e-002,  1.428936e-002,  1.422026e-002,  1.414640e-002,  1.406896e-002,  1.398950e-002,  1.390865e-002,  1.382658e-002,
   1.374946e-002,  1.367392e-002,  1.359731e-002,  1.352170e-002,  1.344518e-002,  1.336808e-002,  1.328958e-002,  1.321204e-002,  1.313604e-002,
   1.305930e-002,  1.298936e-002,  1.292436e-002,  1.285846e-002,  1.279311e-002,  1.272439e-002,  1.265292e-002,  1.258242e-002,  1.251166e-002,
   1.243766e-002,  1.236302e-002,  1.228948e-002,  1.222220e-002,  1.215235e-002,  1.207619e-002,  1.199284e-002,  1.190767e-002,  1.182139e-002,
   1.173345e-002,  1.164387e-002,  1.155443e-002,  1.146493e-002,  1.138295e-002,  1.129904e-002,  1.120925e-002,  1.111652e-002,  1.102182e-002,
   1.092648e-002,  1.082955e-002,  1.073332e-002,  1.063740e-002,  1.054193e-002,  1.045484e-002,  1.036929e-002,  1.028253e-002,  1.019515e-002,
   1.010402e-002,  1.001275e-002,  9.920484e-003,  9.826290e-003,  9.729964e-003,  9.630945e-003,  9.536917e-003,  9.445100e-003,  9.351564e-003,
   9.254625e-003,  9.155807e-003,  9.053900e-003,  8.951083e-003,  8.847467e-003,  8.738950e-003,  8.627321e-003,  8.514583e-003,  8.402696e-003,
   8.288394e-003,  8.173106e-003,  8.056380e-003,  7.939492e-003,  7.823650e-003,  7.708244e-003,  7.591606e-003,  7.474110e-003,  7.361471e-003,
   7.262424e-003,  7.166043e-003,  7.071048e-003,  6.978374e-003,  6.884690e-003,  6.788941e-003,  6.693594e-003,  6.599997e-003,  6.507255e-003,
   6.416697e-003,  6.338541e-003,  6.265930e-003,  6.194026e-003,  6.121762e-003,  6.047146e-003,  5.968673e-003,  5.884628e-003,  5.799016e-003,
   5.713625e-003,  5.626518e-003,  5.543415e-003,  5.462759e-003,  5.383004e-003,  5.301757e-003,  5.221012e-003,  5.141119e-003,  5.060148e-003,
   4.979370e-003,  4.899344e-003,  4.817869e-003,  4.739570e-003,  4.665764e-003,  4.591655e-003,  4.514425e-003,  4.436876e-003,  4.359805e-003,
   4.281968e-003,  4.202791e-003,  4.122960e-003,  4.039086e-003,  3.956343e-003,  3.875757e-003,  3.797406e-003,  3.719577e-003,  3.643680e-003,
   3.568814e-003,  3.492859e-003,  3.414581e-003,  3.338210e-003,  3.259886e-003,  3.181758e-003,  3.106308e-003,  3.031204e-003,  2.954115e-003,
   2.876947e-003,  2.799848e-003,  2.723993e-003,  2.646426e-003,  2.566859e-003,  2.484680e-003,  2.398644e-003,  2.306304e-003,  2.209953e-003,
   2.111415e-003,  2.010258e-003,  1.902428e-003,  1.791665e-003,  1.677490e-003,  1.557822e-003,  1.432742e-003,  1.304630e-003,  1.172295e-003,
   1.035222e-003,  8.975401e-004,  7.590801e-004,  6.216158e-004,  4.844702e-004,  3.450865e-004,  2.066534e-004,  6.913420e-005,  -6.725644e-005,
   -2.057265e-004, -3.467687e-004, -4.887526e-004, -6.348563e-004, -7.905714e-004, -9.669508e-004, -1.164926e-003, -1.381963e-003, -1.619638e-003,
   -1.874832e-003, -2.148495e-003, -2.444814e-003, -2.756516e-003, -3.084647e-003, -3.425024e-003, -3.773993e-003, -4.134545e-003, -4.507166e-003,
   -4.886846e-003, -5.270575e-003, -5.657613e-003, -6.055782e-003, -6.456531e-003, -6.859689e-003, -7.263682e-003, -7.664792e-003, -8.058252e-003,
   -8.446927e-003, -8.829377e-003, -9.207939e-003, -9.576628e-003, -9.946104e-003, -1.030922e-002, -1.066142e-002, -1.100057e-002, -1.132720e-002,
   -1.164203e-002, -1.194423e-002, -1.223340e-002, -1.250574e-002, -1.276045e-002, -1.300292e-002, -1.323872e-002, -1.345882e-002, -1.366432e-002,
   -1.386224e-002, -1.405922e-002, -1.425492e-002, -1.444750e-002, -1.463415e-002, -1.481692e-002, -1.499512e-002, -1.517985e-002, -1.535965e-002,
   -1.553151e-002, -1.569829e-002, -1.586190e-002, -1.601993e-002, -1.616780e-002, -1.631217e-002, -1.645177e-002, -1.658583e-002, -1.672366e-002,
   -1.685881e-002, -1.698234e-002, -1.709916e-002, -1.720852e-002, -1.731054e-002, -1.739895e-002, -1.748040e-002, -1.755821e-002, -1.763391e-002,
   -1.771765e-002, -1.780179e-002, -1.788008e-002, -1.795728e-002, -1.802917e-002, -1.809748e-002, -1.815996e-002, -1.821714e-002, -1.827226e-002,
   -1.832845e-002, -1.838574e-002, -1.844509e-002, -1.850239e-002, -1.856038e-002, -1.861472e-002, -1.866709e-002, -1.871958e-002, -1.876557e-002,
   -1.880767e-002, -1.884718e-002, -1.888664e-002, -1.893083e-002, -1.897529e-002, -1.901423e-002, -1.904504e-002, -1.907092e-002, -1.909192e-002,
   -1.911067e-002, -1.912440e-002, -1.913393e-002, -1.914382e-002, -1.915449e-002, -1.916195e-002, -1.916885e-002, -1.917660e-002, -1.919077e-002,
   -1.920920e-002, -1.922931e-002, -1.924778e-002, -1.926894e-002, -1.928924e-002, -1.931301e-002, -1.934173e-002, -1.937471e-002, -1.940587e-002,
   -1.943797e-002, -1.947026e-002, -1.950912e-002, -1.954936e-002, -1.958761e-002, -1.962894e-002, -1.967594e-002, -1.972659e-002, -1.978702e-002,
   -1.985216e-002, -1.992150e-002, -1.999448e-002, -2.007210e-002, -2.014773e-002, -2.022535e-002, -2.030565e-002, -2.038502e-002, -2.046522e-002,
   -2.054659e-002, -2.062929e-002, -2.071136e-002, -2.079538e-002, -2.088257e-002, -2.097007e-002, -2.106025e-002, -2.115169e-002, -2.123780e-002,
   -2.131658e-002, -2.139560e-002, -2.147718e-002, -2.155657e-002, -2.163601e-002, -2.171915e-002, -2.180377e-002, -2.188823e-002, -2.197066e-002,
   -2.205428e-002, -2.213598e-002, -2.222287e-002, -2.230381e-002, -2.238141e-002, -2.245443e-002, -2.252323e-002, -2.258872e-002, -2.264542e-002,
   -2.270040e-002, -2.275400e-002, -2.279750e-002, -2.283179e-002, -2.285570e-002, -2.287307e-002, -2.288655e-002, -2.289254e-002, -2.289322e-002,
   -2.288004e-002, -2.286161e-002, -2.283576e-002, -2.279586e-002, -2.273507e-002, -2.266675e-002, -2.259296e-002, -2.251842e-002, -2.244123e-002,
   -2.235947e-002, -2.227163e-002, -2.218445e-002, -2.209385e-002, -2.199492e-002, -2.187452e-002, -2.174994e-002, -2.162391e-002, -2.148816e-002,
   -2.134779e-002, -2.120915e-002, -2.107143e-002, -2.093258e-002, -2.078652e-002, -2.063582e-002, -2.045986e-002, -2.027293e-002, -2.008454e-002,
   -1.989405e-002, -1.969086e-002, -1.947059e-002, -1.923131e-002, -1.897325e-002, -1.870094e-002, -1.841641e-002, -1.811045e-002, -1.778220e-002,
   -1.744522e-002, -1.709403e-002, -1.672489e-002, -1.634271e-002, -1.595194e-002, -1.555536e-002, -1.514776e-002, -1.473221e-002, -1.430512e-002,
   -1.386335e-002, -1.341936e-002, -1.297073e-002, -1.251919e-002, -1.206132e-002, -1.160160e-002, -1.114290e-002, -1.068782e-002, -1.022132e-002,
   -9.757470e-003, -9.285987e-003, -8.808177e-003, -8.330368e-003, -7.853724e-003, -7.374809e-003, -6.894174e-003, -6.408915e-003, -5.914210e-003,
   -5.421145e-003, -4.930913e-003, -4.443133e-003, -3.952020e-003, -3.467807e-003, -3.003789e-003, -2.534258e-003, -2.063009e-003, -1.587187e-003,
   -1.105597e-003, -6.145124e-004, -1.195783e-004, 3.786283e-004,  8.472878e-004,  1.313937e-003,  1.792348e-003,  2.281533e-003,  2.785763e-003,
   3.282833e-003,  3.786963e-003,  4.292176e-003,  4.799104e-003,  5.288551e-003,  5.780731e-003,  6.285562e-003,  6.799689e-003,  7.326510e-003,
   7.855405e-003,  8.389570e-003,  8.933646e-003,  9.487226e-003,  1.004485e-002,  1.059483e-002,  1.112622e-002,  1.166886e-002,  1.222207e-002,
   1.277386e-002,  1.332494e-002,  1.388038e-002,  1.443527e-002,  1.499523e-002,  1.554618e-002,  1.610172e-002,  1.660544e-002,  1.711204e-002,
   1.761668e-002,  1.812841e-002,  1.864169e-002,  1.916642e-002,  1.969251e-002,  2.022161e-002,  2.074220e-002,  2.127061e-002,  2.174093e-002,
   2.221935e-002,  2.271000e-002,  2.319654e-002,  2.368338e-002,  2.416340e-002,  2.465537e-002,  2.515596e-002,  2.566187e-002,  2.615421e-002,
   2.659238e-002,  2.699884e-002,  2.741717e-002,  2.784145e-002,  2.827092e-002,  2.871013e-002,  2.915557e-002,  2.960184e-002,  3.006013e-002,
   3.051912e-002,  3.093138e-002,  3.126677e-002,  3.160425e-002,  3.196362e-002,  3.234064e-002,  3.271900e-002,  3.309697e-002,  3.346249e-002,
   3.382050e-002,  3.419264e-002,  3.455212e-002,  3.479399e-002,  3.502965e-002,  3.525196e-002,  3.548711e-002,  3.572370e-002,  3.596105e-002,
   3.620329e-002,  3.645614e-002,  3.671814e-002,  3.697862e-002,  3.709290e-002,  3.720348e-002,  3.732277e-002,  3.743414e-002,  3.755795e-002,
   3.768074e-002,  3.780413e-002,  3.792862e-002,  3.804353e-002,  3.817294e-002,  3.818591e-002,  3.814615e-002,  3.809726e-002,  3.804761e-002,
   3.800844e-002,  3.797241e-002,  3.792083e-002,  3.785795e-002,  3.779673e-002,  3.774091e-002,  3.759108e-002,  3.732045e-002,  3.704199e-002,
   3.677636e-002,  3.649953e-002,  3.621698e-002,  3.593742e-002,  3.565432e-002,  3.537721e-002,  3.510028e-002,  3.479529e-002,  3.430971e-002,
   3.382525e-002,  3.335219e-002,  3.290044e-002,  3.243309e-002,  3.195748e-002,  3.150535e-002,  3.105769e-002,  3.060717e-002,  3.015091e-002,
   2.949569e-002,  2.884514e-002,  2.818003e-002,  2.752823e-002,  2.689935e-002,  2.624807e-002,  2.558363e-002,  2.491307e-002,  2.423669e-002,
   2.357128e-002,  2.275494e-002,  2.186031e-002,  2.095985e-002,  2.005913e-002,  1.916446e-002,  1.824767e-002,  1.730871e-002,  1.635408e-002,
   1.536332e-002,  1.436585e-002,  1.326096e-002,  1.203139e-002,  1.078647e-002,  9.543089e-003,  8.317263e-003,  7.048353e-003,  5.775684e-003,
   4.509309e-003,  3.229642e-003,  1.969391e-003,  6.297964e-004,  -8.156995e-004, -2.259355e-003, -3.698178e-003, -5.176835e-003, -6.670660e-003,
   -8.171561e-003, -9.643531e-003, -1.116153e-002, -1.272143e-002, -1.426735e-002, -1.590160e-002, -1.758423e-002, -1.924605e-002, -2.090828e-002,
   -2.257547e-002, -2.424289e-002, -2.590629e-002, -2.753986e-002, -2.917480e-002, -3.087626e-002, -3.255204e-002, -3.421043e-002, -3.588567e-002,
   -3.755808e-002, -3.924687e-002, -4.091323e-002, -4.253313e-002, -4.418032e-002, -4.584658e-002, -4.756897e-002, -4.920846e-002, -5.077447e-002,
   -5.234610e-002, -5.381682e-002, -5.526424e-002, -5.663091e-002, -5.797222e-002, -5.930607e-002, -6.066814e-002, -6.208514e-002, -6.343403e-002,
   -6.449715e-002, -6.556007e-002, -6.657406e-002, -6.762655e-002, -6.869886e-002, -6.975114e-002, -7.077011e-002, -7.169135e-002, -7.257124e-002,
   -7.322136e-002, -7.314771e-002, -7.311838e-002, -7.300001e-002, -7.266621e-002, -7.217943e-002, -7.125657e-002, -7.000705e-002, -6.839464e-002,
   -6.702601e-002, -6.565046e-002, -6.372023e-002, -6.185220e-002, -5.942380e-002, -5.690567e-002, -5.426280e-002, -5.154318e-002, -4.866927e-002,
   -4.523848e-002, -3.984226e-002, -2.892381e-002, -2.036873e-002, -1.322092e-002, -6.047445e-003, 4.023240e-004,  6.063601e-003,  1.163768e-002,
   1.739665e-002,  2.380727e-002,  3.138978e-002,  3.860991e-002,  1.101943e-001,  1.182915e-001,  1.205385e-001,  1.208058e-001,  1.195768e-001,
   1.187807e-001,  1.185533e-001,  1.183375e-001,  1.183317e-001,  1.199347e-001,  1.690672e-001,  2.689890e-001,  2.707646e-001,  2.683774e-001,
   2.623614e-001,  2.456289e-001,  1.179993e-001,  8.066072e-002,  4.828174e-002,  2.318181e-002,  0.000000e+000},
  {0.000000e+000,  -5.948584e-003, -1.046028e-002, -1.412192e-002, -1.718260e-002, -1.981969e-002, -2.210697e-002, -2.395837e-002, -2.550575e-002,
   -2.656707e-002, -2.756658e-002, -2.857295e-002, -2.943111e-002, -3.020161e-002, -3.092388e-002, -3.163091e-002, -3.235862e-002, -3.313731e-002,
   -3.398320e-002, -3.482197e-002, -3.563929e-002, -3.639301e-002, -3.708183e-002, -3.774827e-002, -3.839240e-002, -3.900497e-002, -3.958263e-002,
   -4.012135e-002, -4.062204e-002, -4.108001e-002, -4.149873e-002, -4.186575e-002, -4.215703e-002, -4.242737e-002, -4.267827e-002, -4.291057e-002,
   -4.312675e-002, -4.332709e-002, -4.351663e-002, -4.370100e-002, -4.387662e-002, -4.402898e-002, -4.408344e-002, -4.410699e-002, -4.408507e-002,
   -4.400904e-002, -4.375791e-002, -4.312853e-002, -4.252821e-002, -4.235124e-002, -4.231945e-002, -4.230396e-002, -4.224461e-002, -4.218807e-002,
   -4.214307e-002, -4.210902e-002, -4.208484e-002, -4.206985e-002, -4.205669e-002, -4.204964e-002, -4.204478e-002, -4.204052e-002, -4.199539e-002,
   -4.192053e-002, -4.184521e-002, -4.176766e-002, -4.168334e-002, -4.158970e-002, -4.148186e-002, -4.136096e-002, -4.122021e-002, -4.106306e-002,
   -4.087456e-002, -4.064578e-002, -4.040580e-002, -4.015549e-002, -3.989355e-002, -3.961990e-002, -3.933759e-002, -3.905504e-002, -3.877712e-002,
   -3.851058e-002, -3.824416e-002, -3.794630e-002, -3.765646e-002, -3.737032e-002, -3.708395e-002, -3.679851e-002, -3.651559e-002, -3.621877e-002,
   -3.590223e-002, -3.556911e-002, -3.522037e-002, -3.482059e-002, -3.440499e-002, -3.397425e-002, -3.353103e-002, -3.307909e-002, -3.262169e-002,
   -3.215940e-002, -3.169289e-002, -3.122540e-002, -3.075826e-002, -3.027230e-002, -2.978381e-002, -2.930554e-002, -2.884168e-002, -2.838044e-002,
   -2.791220e-002, -2.743917e-002, -2.696029e-002, -2.647392e-002, -2.598328e-002, -2.547690e-002, -2.495366e-002, -2.443086e-002, -2.390635e-002,
   -2.337981e-002, -2.285216e-002, -2.232433e-002, -2.179606e-002, -2.127013e-002, -2.075020e-002, -2.023887e-002, -1.973521e-002, -1.925105e-002,
   -1.878562e-002, -1.833284e-002, -1.788865e-002, -1.745424e-002, -1.702593e-002, -1.660021e-002, -1.617719e-002, -1.575667e-002, -1.532677e-002,
   -1.489798e-002, -1.446973e-002, -1.403917e-002, -1.360597e-002, -1.317021e-002, -1.272858e-002, -1.228229e-002, -1.183464e-002, -1.138420e-002,
   -1.092678e-002, -1.046724e-002, -1.000966e-002, -9.554884e-003, -9.105796e-003, -8.660513e-003, -8.220711e-003, -7.785510e-003, -7.356108e-003,
   -6.932939e-003, -6.515922e-003, -6.104922e-003, -5.698882e-003, -5.303549e-003, -4.915248e-003, -4.536020e-003, -4.162792e-003, -3.795156e-003,
   -3.432018e-003, -3.075013e-003, -2.721552e-003, -2.372963e-003, -2.024064e-003, -1.671348e-003, -1.311859e-003, -9.457630e-004, -5.768674e-004,
   -2.083540e-004, 1.585965e-004,  5.251824e-004,  8.888624e-004,  1.246487e-003,  1.608064e-003,  1.974160e-003,  2.342099e-003,  2.712027e-003,
   3.081043e-003,  3.445252e-003,  3.799746e-003,  4.139995e-003,  4.467597e-003,  4.776563e-003,  5.077320e-003,  5.373030e-003,  5.663168e-003,
   5.949986e-003,  6.234074e-003,  6.515621e-003,  6.797121e-003,  7.078203e-003,  7.360271e-003,  7.632729e-003,  7.901880e-003,  8.173229e-003,
   8.447280e-003,  8.725165e-003,  9.006207e-003,  9.291544e-003,  9.581457e-003,  9.874916e-003,  1.017250e-002,  1.046641e-002,  1.076046e-002,
   1.106547e-002,  1.138228e-002,  1.170738e-002,  1.203445e-002,  1.236181e-002,  1.268655e-002,  1.300964e-002,  1.333124e-002,  1.365057e-002,
   1.395585e-002,  1.426371e-002,  1.457022e-002,  1.487466e-002,  1.517438e-002,  1.546641e-002,  1.574707e-002,  1.601292e-002,  1.626505e-002,
   1.650610e-002,  1.672061e-002,  1.692630e-002,  1.712683e-002,  1.732448e-002,  1.751945e-002,  1.771236e-002,  1.790203e-002,  1.808812e-002,
   1.827063e-002,  1.845030e-002,  1.861054e-002,  1.876441e-002,  1.891985e-002,  1.907753e-002,  1.923785e-002,  1.940077e-002,  1.956861e-002,
   1.974178e-002,  1.991933e-002,  2.010331e-002,  2.028513e-002,  2.046811e-002,  2.066714e-002,  2.088008e-002,  2.109807e-002,  2.131675e-002,
   2.153312e-002,  2.174281e-002,  2.194993e-002,  2.215501e-002,  2.235024e-002,  2.252842e-002,  2.270546e-002,  2.287972e-002,  2.304994e-002,
   2.321695e-002,  2.337129e-002,  2.352155e-002,  2.366657e-002,  2.380986e-002,  2.395282e-002,  2.407193e-002,  2.419302e-002,  2.431763e-002,
   2.444566e-002,  2.458104e-002,  2.472854e-002,  2.488952e-002,  2.506544e-002,  2.525627e-002,  2.546600e-002,  2.567049e-002,  2.588437e-002,
   2.610956e-002,  2.634315e-002,  2.659193e-002,  2.685971e-002,  2.714631e-002,  2.745098e-002,  2.777483e-002,  2.811512e-002,  2.845346e-002,
   2.878696e-002,  2.912168e-002,  2.945281e-002,  2.977797e-002,  3.010048e-002,  3.042120e-002,  3.074058e-002,  3.106231e-002,  3.138533e-002,
   3.169710e-002,  3.198677e-002,  3.227495e-002,  3.256339e-002,  3.285098e-002,  3.313948e-002,  3.342794e-002,  3.371656e-002,  3.400471e-002,
   3.428926e-002,  3.456718e-002,  3.481441e-002,  3.505788e-002,  3.529949e-002,  3.553841e-002,  3.577588e-002,  3.601093e-002,  3.624765e-002,
   3.648528e-002,  3.671898e-002,  3.694927e-002,  3.714690e-002,  3.733192e-002,  3.750582e-002,  3.766425e-002,  3.780644e-002,  3.793386e-002,
   3.804862e-002,  3.814937e-002,  3.823731e-002,  3.831114e-002,  3.834863e-002,  3.835488e-002,  3.833633e-002,  3.829914e-002,  3.824622e-002,
   3.818108e-002,  3.810190e-002,  3.800849e-002,  3.790841e-002,  3.780139e-002,  3.767555e-002,  3.752722e-002,  3.737696e-002,  3.722564e-002,
   3.707149e-002,  3.691774e-002,  3.676275e-002,  3.661098e-002,  3.646524e-002,  3.632604e-002,  3.618752e-002,  3.603051e-002,  3.587972e-002,
   3.573158e-002,  3.558121e-002,  3.541856e-002,  3.523896e-002,  3.504661e-002,  3.484020e-002,  3.462295e-002,  3.439420e-002,  3.412198e-002,
   3.384067e-002,  3.355145e-002,  3.325646e-002,  3.295335e-002,  3.264685e-002,  3.233845e-002,  3.203041e-002,  3.171997e-002,  3.140753e-002,
   3.106842e-002,  3.071718e-002,  3.036373e-002,  3.000925e-002,  2.965086e-002,  2.929255e-002,  2.893394e-002,  2.857646e-002,  2.822257e-002,
   2.786956e-002,  2.750272e-002,  2.712157e-002,  2.674161e-002,  2.636277e-002,  2.598194e-002,  2.560004e-002,  2.522268e-002,  2.484980e-002,
   2.447667e-002,  2.410281e-002,  2.371642e-002,  2.329970e-002,  2.287848e-002,  2.244893e-002,  2.201228e-002,  2.157542e-002,  2.113880e-002,
   2.070140e-002,  2.026492e-002,  1.983083e-002,  1.939684e-002,  1.893046e-002,  1.846613e-002,  1.800138e-002,  1.753855e-002,  1.707984e-002,
   1.662469e-002,  1.617480e-002,  1.573530e-002,  1.530541e-002,  1.488438e-002,  1.444704e-002,  1.401517e-002,  1.359411e-002,  1.318446e-002,
   1.278145e-002,  1.238534e-002,  1.199644e-002,  1.161269e-002,  1.123216e-002,  1.085487e-002,  1.046048e-002,  1.005207e-002,  9.644108e-003,
   9.235605e-003,  8.827724e-003,  8.419217e-003,  8.013053e-003,  7.607237e-003,  7.196789e-003,  6.782582e-003,  6.355131e-003,  5.902252e-003,
   5.449632e-003,  4.998081e-003,  4.546524e-003,  4.098905e-003,  3.658531e-003,  3.225129e-003,  2.795811e-003,  2.371259e-003,  1.957602e-003,
   1.531842e-003,  1.120777e-003,  7.205106e-004,  3.283913e-004,  -5.933045e-005, -4.439777e-004, -8.223615e-004, -1.194654e-003, -1.559656e-003,
   -1.917887e-003, -2.289807e-003, -2.656050e-003, -3.019412e-003, -3.384292e-003, -3.754604e-003, -4.126454e-003, -4.498876e-003, -4.871506e-003,
   -5.238074e-003, -5.599641e-003, -5.970859e-003, -6.344308e-003, -6.711346e-003, -7.074197e-003, -7.432486e-003, -7.782779e-003, -8.126682e-003,
   -8.464074e-003, -8.795215e-003, -9.119613e-003, -9.446921e-003, -9.781706e-003, -1.011206e-002, -1.043890e-002, -1.076276e-002, -1.108266e-002,
   -1.140055e-002, -1.171700e-002, -1.203250e-002, -1.234679e-002, -1.265958e-002, -1.298452e-002, -1.330717e-002, -1.362826e-002, -1.394375e-002,
   -1.425439e-002, -1.455847e-002, -1.485700e-002, -1.514793e-002, -1.543700e-002, -1.572596e-002, -1.602852e-002, -1.633093e-002, -1.663258e-002,
   -1.693060e-002, -1.722624e-002, -1.752022e-002, -1.781593e-002, -1.811509e-002, -1.841830e-002, -1.873025e-002, -1.906276e-002, -1.940616e-002,
   -1.975771e-002, -2.011914e-002, -2.049229e-002, -2.087419e-002, -2.126528e-002, -2.166763e-002, -2.207789e-002, -2.249161e-002, -2.291329e-002,
   -2.334089e-002, -2.376481e-002, -2.418249e-002, -2.459265e-002, -2.499479e-002, -2.538694e-002, -2.576434e-002, -2.612284e-002, -2.646375e-002,
   -2.679377e-002, -2.712256e-002, -2.744789e-002, -2.776918e-002, -2.806224e-002, -2.829575e-002, -2.847228e-002, -2.859076e-002, -2.865676e-002,
   -2.867214e-002, -2.864107e-002, -2.857640e-002, -2.847552e-002, -2.834078e-002, -2.817526e-002, -2.797742e-002, -2.774997e-002, -2.749482e-002,
   -2.721815e-002, -2.691966e-002, -2.659914e-002, -2.626871e-002, -2.592373e-002, -2.556482e-002, -2.519327e-002, -2.480871e-002, -2.441472e-002,
   -2.401092e-002, -2.360332e-002, -2.319756e-002, -2.279512e-002, -2.241146e-002, -2.204302e-002, -2.169290e-002, -2.136524e-002, -2.106278e-002,
   -2.078899e-002, -2.054502e-002, -2.033929e-002, -2.017546e-002, -2.005890e-002, -1.999876e-002, -2.001068e-002, -2.008933e-002, -2.019889e-002,
   -2.031759e-002, -2.044829e-002, -2.058973e-002, -2.074222e-002, -2.090446e-002, -2.107718e-002, -2.125894e-002, -2.145787e-002, -2.166500e-002,
   -2.187264e-002, -2.208520e-002, -2.230130e-002, -2.252226e-002, -2.274373e-002, -2.296947e-002, -2.319341e-002, -2.341791e-002, -2.365163e-002,
   -2.388496e-002, -2.410825e-002, -2.432480e-002, -2.453164e-002, -2.472465e-002, -2.490171e-002, -2.507223e-002, -2.524614e-002, -2.542661e-002,
   -2.562317e-002, -2.582726e-002, -2.603106e-002, -2.623738e-002, -2.644263e-002, -2.664505e-002, -2.684109e-002, -2.703369e-002, -2.722865e-002,
   -2.743115e-002, -2.764978e-002, -2.788030e-002, -2.810709e-002, -2.833495e-002, -2.856174e-002, -2.878308e-002, -2.900204e-002, -2.921894e-002,
   -2.943169e-002, -2.963449e-002, -2.983521e-002, -3.003728e-002, -3.023066e-002, -3.040947e-002, -3.057211e-002, -3.072048e-002, -3.085741e-002,
   -3.098051e-002, -3.108812e-002, -3.117851e-002, -3.126310e-002, -3.138829e-002, -3.153534e-002, -3.170706e-002, -3.189900e-002, -3.211329e-002,
   -3.234613e-002, -3.259687e-002, -3.286321e-002, -3.314521e-002, -3.343420e-002, -3.375310e-002, -3.408381e-002, -3.442094e-002, -3.475789e-002,
   -3.509398e-002, -3.542514e-002, -3.574842e-002, -3.605705e-002, -3.635363e-002, -3.663700e-002, -3.692114e-002, -3.720193e-002, -3.746059e-002,
   -3.769447e-002, -3.790588e-002, -3.809212e-002, -3.824652e-002, -3.836200e-002, -3.844385e-002, -3.849019e-002, -3.850980e-002, -3.852192e-002,
   -3.849075e-002, -3.841692e-002, -3.830307e-002, -3.814343e-002, -3.793830e-002, -3.768983e-002, -3.739737e-002, -3.705420e-002, -3.667035e-002,
   -3.631146e-002, -3.593032e-002, -3.553103e-002, -3.511230e-002, -3.468110e-002, -3.425017e-002, -3.381660e-002, -3.338288e-002, -3.293831e-002,
   -3.248550e-002, -3.207288e-002, -3.166134e-002, -3.123436e-002, -3.079668e-002, -3.034961e-002, -2.989507e-002, -2.942900e-002, -2.895256e-002,
   -2.846753e-002, -2.797019e-002, -2.749438e-002, -2.703390e-002, -2.656510e-002, -2.608691e-002, -2.560159e-002, -2.510515e-002, -2.459696e-002,
   -2.407510e-002, -2.354001e-002, -2.298263e-002, -2.244101e-002, -2.193445e-002, -2.141711e-002, -2.087392e-002, -2.030779e-002, -1.972251e-002,
   -1.911495e-002, -1.848676e-002, -1.783762e-002, -1.716135e-002, -1.646670e-002, -1.582304e-002, -1.516356e-002, -1.448692e-002, -1.379425e-002,
   -1.308478e-002, -1.235917e-002, -1.162134e-002, -1.086739e-002, -1.008393e-002, -9.275987e-003, -8.527802e-003, -7.768778e-003, -6.981132e-003,
   -6.119956e-003, -5.120459e-003, -3.990800e-003, -2.741776e-003, -1.376983e-003, 9.828532e-005,  1.676223e-003,  3.280892e-003,  4.937018e-003,
   6.684108e-003,  8.512696e-003,  1.041702e-002,  1.238370e-002,  1.440147e-002,  1.646402e-002,  1.856965e-002,  2.070603e-002,  2.282164e-002,
   2.489381e-002,  2.697639e-002,  2.906437e-002,  3.115039e-002,  3.322969e-002,  3.529430e-002,  3.733764e-002,  3.935526e-002,  4.134601e-002,
   4.327241e-002,  4.506649e-002,  4.681959e-002,  4.852420e-002,  5.016666e-002,  5.174376e-002,  5.325207e-002,  5.469578e-002,  5.607293e-002,
   5.736846e-002,  5.856041e-002,  5.951937e-002,  6.036706e-002,  6.109094e-002,  6.168262e-002,  6.216786e-002,  6.262349e-002,  6.305866e-002,
   6.347619e-002,  6.386848e-002,  6.423255e-002,  6.447476e-002,  6.465171e-002,  6.479041e-002,  6.490509e-002,  6.499736e-002,  6.507549e-002,
   6.513269e-002,  6.517093e-002,  6.518208e-002,  6.518070e-002,  6.508500e-002,  6.490283e-002,  6.471472e-002,  6.450784e-002,  6.430075e-002,
   6.408874e-002,  6.387332e-002,  6.365391e-002,  6.343041e-002,  6.319381e-002,  6.290044e-002,  6.250051e-002,  6.209105e-002,  6.166723e-002,
   6.122417e-002,  6.076333e-002,  6.027323e-002,  5.975602e-002,  5.921839e-002,  5.864549e-002,  5.804034e-002,  5.727047e-002,  5.648582e-002,
   5.568698e-002,  5.487773e-002,  5.405462e-002,  5.320805e-002,  5.234901e-002,  5.147712e-002,  5.057954e-002,  4.967115e-002,  4.863255e-002,
   4.756180e-002,  4.648999e-002,  4.541126e-002,  4.433167e-002,  4.325763e-002,  4.218398e-002,  4.111786e-002,  4.003836e-002,  3.894626e-002,
   3.777685e-002,  3.656353e-002,  3.535622e-002,  3.416935e-002,  3.299730e-002,  3.184616e-002,  3.070309e-002,  2.956442e-002,  2.842832e-002,
   2.729558e-002,  2.610155e-002,  2.482173e-002,  2.355134e-002,  2.229819e-002,  2.106438e-002,  1.983652e-002,  1.861767e-002,  1.741414e-002,
   1.621598e-002,  1.501925e-002,  1.380812e-002,  1.246018e-002,  1.111967e-002,  9.788785e-003,  8.473901e-003,  7.177705e-003,  5.906202e-003,
   4.654812e-003,  3.432508e-003,  2.229914e-003,  1.064813e-003,  -2.173012e-004, -1.478580e-003, -2.721705e-003, -3.953264e-003, -5.148483e-003,
   -6.304037e-003, -7.412129e-003, -8.498079e-003, -9.550709e-003, -1.056701e-002, -1.167472e-002, -1.281602e-002, -1.393330e-002, -1.502508e-002,
   -1.611261e-002, -1.718486e-002, -1.824908e-002, -1.931062e-002, -2.034952e-002, -2.136453e-002, -2.243274e-002, -2.358288e-002, -2.470462e-002,
   -2.578893e-002, -2.682955e-002, -2.784701e-002, -2.884065e-002, -2.979270e-002, -3.071127e-002, -3.158953e-002, -3.247666e-002, -3.350379e-002,
   -3.448654e-002, -3.542902e-002, -3.633891e-002, -3.720409e-002, -3.802047e-002, -3.879421e-002, -3.952199e-002, -4.019919e-002, -4.082141e-002,
   -4.161062e-002, -4.235605e-002, -4.304160e-002, -4.367656e-002, -4.425568e-002, -4.479237e-002, -4.529534e-002, -4.573724e-002, -4.614122e-002,
   -4.650078e-002, -4.698633e-002, -4.747143e-002, -4.786270e-002, -4.816596e-002, -4.837634e-002, -4.848212e-002, -4.848778e-002, -4.841266e-002,
   -4.824191e-002, -4.798326e-002, -4.779639e-002, -4.765645e-002, -4.744163e-002, -4.717161e-002, -4.682562e-002, -4.638332e-002, -4.586779e-002,
   -4.527898e-002, -4.460445e-002, -4.384995e-002, -4.310654e-002, -4.252824e-002, -4.187401e-002, -4.113536e-002, -4.034341e-002, -3.947574e-002,
   -3.853392e-002, -3.754277e-002, -3.646945e-002, -3.531654e-002, -3.412551e-002, -3.326706e-002, -3.233921e-002, -3.132969e-002, -3.016532e-002,
   -2.885093e-002, -2.735353e-002, -2.568485e-002, -2.387733e-002, -2.191919e-002, -1.981274e-002, -1.802727e-002, -1.619401e-002, -1.423960e-002,
   -1.218404e-002, -1.003874e-002, -7.781791e-003, -5.413668e-003, -2.935296e-003, -3.712999e-004, 2.247255e-003,  4.527139e-003,  6.577857e-003,
   8.691127e-003,  1.083851e-002,  1.300684e-002,  1.518670e-002,  1.743227e-002,  1.972860e-002,  2.209641e-002,  2.454579e-002,  2.675521e-002,
   2.845350e-002,  3.019673e-002,  3.192092e-002,  3.367314e-002,  3.546429e-002,  3.724262e-002,  3.899910e-002,  4.075613e-002,  4.251294e-002,
   4.411621e-002,  4.480295e-002,  4.547760e-002,  4.607877e-002,  4.661217e-002,  4.708334e-002,  4.740441e-002,  4.760143e-002,  4.766157e-002,
   4.777167e-002,  4.793095e-002,  4.711552e-002,  4.626246e-002,  4.529052e-002,  4.434331e-002,  4.344736e-002,  4.266091e-002,  4.181582e-002,
   4.080910e-002,  3.921881e-002,  3.583952e-002,  3.259613e-002,  2.956175e-002,  2.651886e-002,  2.372247e-002,  2.105007e-002,  1.829475e-002,
   1.532199e-002,  1.216969e-002,  8.674116e-003,  5.452616e-003,  -1.948443e-002, -2.423340e-002, -2.695359e-002, -2.894229e-002, -3.018456e-002,
   -3.128056e-002, -3.235162e-002, -3.319580e-002, -3.395398e-002, -3.527155e-002, -5.551143e-002, -8.822319e-002, -8.978125e-002, -9.050980e-002,
   -8.976921e-002, -8.507800e-002, -4.157453e-002, -2.872418e-002, -1.732739e-002, -8.396579e-003, 0.000000e+000},
  {0.000000e+000,  -5.609543e-003, -1.020292e-002, -1.400415e-002, -1.719518e-002, -1.986023e-002, -2.209632e-002, -2.411757e-002, -2.583390e-002,
   -2.697271e-002, -2.767187e-002, -2.820270e-002, -2.873208e-002, -2.917226e-002, -2.953901e-002, -2.985445e-002, -3.014326e-002, -3.042552e-002,
   -3.071728e-002, -3.096373e-002, -3.115826e-002, -3.137235e-002, -3.158948e-002, -3.175253e-002, -3.186987e-002, -3.195711e-002, -3.201454e-002,
   -3.205246e-002, -3.206618e-002, -3.204799e-002, -3.199958e-002, -3.195769e-002, -3.195992e-002, -3.194288e-002, -3.190385e-002, -3.184448e-002,
   -3.176524e-002, -3.166172e-002, -3.153478e-002, -3.137627e-002, -3.119349e-002, -3.099761e-002, -3.085576e-002, -3.072802e-002, -3.062967e-002,
   -3.057547e-002, -3.071938e-002, -3.132002e-002, -3.187077e-002, -3.187862e-002, -3.169455e-002, -3.148052e-002, -3.128429e-002, -3.107780e-002,
   -3.086201e-002, -3.063436e-002, -3.039270e-002, -3.013730e-002, -2.986765e-002, -2.958591e-002, -2.929295e-002, -2.899273e-002, -2.870948e-002,
   -2.843268e-002, -2.815173e-002, -2.786922e-002, -2.758173e-002, -2.729196e-002, -2.700176e-002, -2.670976e-002, -2.641753e-002, -2.612207e-002,
   -2.582397e-002, -2.552362e-002, -2.520222e-002, -2.484961e-002, -2.447161e-002, -2.406098e-002, -2.362527e-002, -2.316570e-002, -2.268948e-002,
   -2.218656e-002, -2.165324e-002, -2.111701e-002, -2.055203e-002, -1.995805e-002, -1.933752e-002, -1.869388e-002, -1.803501e-002, -1.735155e-002,
   -1.664619e-002, -1.592049e-002, -1.518314e-002, -1.446989e-002, -1.375316e-002, -1.303381e-002, -1.231701e-002, -1.160900e-002, -1.091711e-002,
   -1.024353e-002, -9.595658e-003, -8.974928e-003, -8.387855e-003, -7.867135e-003, -7.382747e-003, -6.916496e-003, -6.467991e-003, -6.030855e-003,
   -5.597068e-003, -5.168507e-003, -4.741847e-003, -4.316002e-003, -3.894435e-003, -3.495257e-003, -3.124098e-003, -2.757691e-003, -2.390975e-003,
   -2.028343e-003, -1.666036e-003, -1.305747e-003, -9.489322e-004, -5.927505e-004, -2.422770e-004, 8.750156e-005,  3.706612e-004,  6.411290e-004,
   9.020341e-004,  1.155620e-003,  1.401542e-003,  1.643038e-003,  1.879963e-003,  2.113900e-003,  2.347571e-003,  2.577458e-003,  2.756647e-003,
   2.931890e-003,  3.105964e-003,  3.278941e-003,  3.453383e-003,  3.629719e-003,  3.808411e-003,  3.988230e-003,  4.169038e-003,  4.350300e-003,
   4.498474e-003,  4.636026e-003,  4.770906e-003,  4.905064e-003,  5.036287e-003,  5.162918e-003,  5.286399e-003,  5.409335e-003,  5.529413e-003,
   5.644914e-003,  5.733475e-003,  5.800998e-003,  5.866385e-003,  5.924919e-003,  5.981370e-003,  6.035549e-003,  6.088237e-003,  6.139955e-003,
   6.192982e-003,  6.246664e-003,  6.288008e-003,  6.301096e-003,  6.321934e-003,  6.350560e-003,  6.390177e-003,  6.440209e-003,  6.500632e-003,
   6.568284e-003,  6.643021e-003,  6.723242e-003,  6.806121e-003,  6.859700e-003,  6.924152e-003,  6.999026e-003,  7.084535e-003,  7.182118e-003,
   7.289638e-003,  7.401751e-003,  7.515808e-003,  7.629782e-003,  7.743879e-003,  7.825221e-003,  7.905603e-003,  7.993493e-003,  8.089495e-003,
   8.195815e-003,  8.310149e-003,  8.433364e-003,  8.566772e-003,  8.711999e-003,  8.866846e-003,  9.006287e-003,  9.140958e-003,  9.288091e-003,
   9.446488e-003,  9.614475e-003,  9.793774e-003,  9.985709e-003,  1.018946e-002,  1.040183e-002,  1.062232e-002,  1.083743e-002,  1.104407e-002,
   1.126445e-002,  1.149859e-002,  1.174416e-002,  1.199751e-002,  1.225622e-002,  1.251640e-002,  1.277863e-002,  1.304413e-002,  1.330912e-002,
   1.354784e-002,  1.379030e-002,  1.403692e-002,  1.428711e-002,  1.454022e-002,  1.479216e-002,  1.503939e-002,  1.528018e-002,  1.551532e-002,
   1.574603e-002,  1.594304e-002,  1.613612e-002,  1.632784e-002,  1.651897e-002,  1.671007e-002,  1.690124e-002,  1.709246e-002,  1.727991e-002,
   1.746462e-002,  1.764694e-002,  1.780513e-002,  1.795450e-002,  1.810445e-002,  1.825489e-002,  1.840676e-002,  1.856097e-002,  1.871700e-002,
   1.887492e-002,  1.903423e-002,  1.919784e-002,  1.935343e-002,  1.950450e-002,  1.966746e-002,  1.984002e-002,  2.001872e-002,  2.019768e-002,
   2.037482e-002,  2.054703e-002,  2.071587e-002,  2.088163e-002,  2.103652e-002,  2.116813e-002,  2.129715e-002,  2.142034e-002,  2.153846e-002,
   2.165173e-002,  2.175480e-002,  2.185070e-002,  2.193956e-002,  2.202483e-002,  2.210691e-002,  2.215792e-002,  2.220650e-002,  2.225214e-002,
   2.229691e-002,  2.234433e-002,  2.239508e-002,  2.245017e-002,  2.251060e-002,  2.257590e-002,  2.264920e-002,  2.270431e-002,  2.275820e-002,
   2.281393e-002,  2.287054e-002,  2.292186e-002,  2.296524e-002,  2.300089e-002,  2.303012e-002,  2.305296e-002,  2.306820e-002,  2.305910e-002,
   2.302630e-002,  2.297897e-002,  2.291270e-002,  2.282715e-002,  2.272179e-002,  2.259517e-002,  2.244862e-002,  2.228654e-002,  2.210611e-002,
   2.190042e-002,  2.165822e-002,  2.140254e-002,  2.113492e-002,  2.085599e-002,  2.056860e-002,  2.027364e-002,  1.997160e-002,  1.966354e-002,
   1.934877e-002,  1.902737e-002,  1.867195e-002,  1.831300e-002,  1.795264e-002,  1.759081e-002,  1.723051e-002,  1.687111e-002,  1.651856e-002,
   1.617237e-002,  1.583302e-002,  1.549854e-002,  1.513897e-002,  1.477886e-002,  1.442248e-002,  1.406648e-002,  1.371336e-002,  1.336316e-002,
   1.301864e-002,  1.268391e-002,  1.235797e-002,  1.204155e-002,  1.171069e-002,  1.137267e-002,  1.103821e-002,  1.070490e-002,  1.037233e-002,
   1.004464e-002,  9.717938e-003,  9.394737e-003,  9.078261e-003,  8.767793e-003,  8.449835e-003,  8.117357e-003,  7.794951e-003,  7.485632e-003,
   7.186830e-003,  6.899464e-003,  6.626385e-003,  6.368375e-003,  6.127295e-003,  5.903327e-003,  5.690922e-003,  5.464393e-003,  5.255171e-003,
   5.059746e-003,  4.873714e-003,  4.692101e-003,  4.510382e-003,  4.330155e-003,  4.149792e-003,  3.973841e-003,  3.800534e-003,  3.591132e-003,
   3.386525e-003,  3.188905e-003,  2.998406e-003,  2.814495e-003,  2.639968e-003,  2.477539e-003,  2.328904e-003,  2.214565e-003,  2.152230e-003,
   2.107248e-003,  2.097384e-003,  2.132826e-003,  2.209479e-003,  2.324765e-003,  2.479425e-003,  2.669323e-003,  2.892824e-003,  3.150776e-003,
   3.438777e-003,  3.731097e-003,  4.028262e-003,  4.346258e-003,  4.683846e-003,  5.037701e-003,  5.403796e-003,  5.783733e-003,  6.173879e-003,
   6.571312e-003,  6.975531e-003,  7.374744e-003,  7.743463e-003,  8.114540e-003,  8.483192e-003,  8.848271e-003,  9.210386e-003,  9.567733e-003,
   9.916865e-003,  1.025665e-002,  1.058486e-002,  1.089737e-002,  1.114930e-002,  1.138346e-002,  1.159686e-002,  1.178847e-002,  1.195601e-002,
   1.209684e-002,  1.221104e-002,  1.229770e-002,  1.235401e-002,  1.237758e-002,  1.233230e-002,  1.224274e-002,  1.211450e-002,  1.194769e-002,
   1.174325e-002,  1.152313e-002,  1.129014e-002,  1.104205e-002,  1.077954e-002,  1.050322e-002,  1.018728e-002,  9.836217e-003,  9.469754e-003,
   9.086069e-003,  8.687566e-003,  8.273359e-003,  7.847524e-003,  7.408781e-003,  6.954362e-003,  6.485158e-003,  5.989630e-003,  5.452539e-003,
   4.904407e-003,  4.346624e-003,  3.779418e-003,  3.206588e-003,  2.629062e-003,  2.047606e-003,  1.458756e-003,  8.647198e-004,  2.692816e-004,
   -3.544114e-004, -9.737030e-004, -1.589628e-003, -2.206354e-003, -2.825203e-003, -3.445050e-003, -4.062865e-003, -4.678760e-003, -5.291797e-003,
   -5.901404e-003, -6.533748e-003, -7.165009e-003, -7.793608e-003, -8.422054e-003, -9.062479e-003, -9.728908e-003, -1.041701e-002, -1.112802e-002,
   -1.185287e-002, -1.259134e-002, -1.335763e-002, -1.414169e-002, -1.493571e-002, -1.573761e-002, -1.654454e-002, -1.735285e-002, -1.816057e-002,
   -1.896625e-002, -1.977008e-002, -2.056986e-002, -2.137308e-002, -2.218369e-002, -2.299155e-002, -2.379052e-002, -2.458579e-002, -2.537356e-002,
   -2.615754e-002, -2.693491e-002, -2.770569e-002, -2.846715e-002, -2.922214e-002, -2.997941e-002, -3.072721e-002, -3.146359e-002, -3.218500e-002,
   -3.289130e-002, -3.357847e-002, -3.424629e-002, -3.489545e-002, -3.552906e-002, -3.614490e-002, -3.675121e-002, -3.733952e-002, -3.790807e-002,
   -3.845563e-002, -3.898046e-002, -3.948301e-002, -3.996247e-002, -4.041980e-002, -4.085415e-002, -4.127160e-002, -4.167252e-002, -4.205151e-002,
   -4.240900e-002, -4.274547e-002, -4.305746e-002, -4.334545e-002, -4.360872e-002, -4.384774e-002, -4.406094e-002, -4.425287e-002, -4.442318e-002,
   -4.457628e-002, -4.470857e-002, -4.481867e-002, -4.490666e-002, -4.497520e-002, -4.502040e-002, -4.504492e-002, -4.504375e-002, -4.501415e-002,
   -4.496311e-002, -4.489659e-002, -4.481548e-002, -4.472174e-002, -4.460564e-002, -4.444506e-002, -4.424325e-002, -4.400043e-002, -4.372041e-002,
   -4.340048e-002, -4.304127e-002, -4.264799e-002, -4.222865e-002, -4.178732e-002, -4.132973e-002, -4.085450e-002, -4.036287e-002, -3.985839e-002,
   -3.934609e-002, -3.882400e-002, -3.829546e-002, -3.775228e-002, -3.720548e-002, -3.665955e-002, -3.611718e-002, -3.558143e-002, -3.505563e-002,
   -3.454224e-002, -3.404174e-002, -3.356345e-002, -3.310855e-002, -3.267469e-002, -3.226179e-002, -3.187716e-002, -3.152511e-002, -3.121264e-002,
   -3.093793e-002, -3.070672e-002, -3.051399e-002, -3.035898e-002, -3.024288e-002, -3.016763e-002, -3.013690e-002, -3.015837e-002, -3.021076e-002,
   -3.027725e-002, -3.035939e-002, -3.045214e-002, -3.055773e-002, -3.067715e-002, -3.080632e-002, -3.094361e-002, -3.107647e-002, -3.121544e-002,
   -3.135756e-002, -3.150256e-002, -3.164995e-002, -3.179803e-002, -3.194612e-002, -3.209115e-002, -3.223317e-002, -3.237179e-002, -3.249983e-002,
   -3.261444e-002, -3.271806e-002, -3.280989e-002, -3.288672e-002, -3.294479e-002, -3.298477e-002, -3.300870e-002, -3.302849e-002, -3.303906e-002,
   -3.303823e-002, -3.302549e-002, -3.299939e-002, -3.296521e-002, -3.291420e-002, -3.284295e-002, -3.275281e-002, -3.264845e-002, -3.253079e-002,
   -3.239972e-002, -3.225656e-002, -3.209977e-002, -3.192673e-002, -3.173207e-002, -3.152171e-002, -3.128617e-002, -3.102538e-002, -3.073882e-002,
   -3.042679e-002, -3.008612e-002, -2.972135e-002, -2.933698e-002, -2.891916e-002, -2.846609e-002, -2.797823e-002, -2.745716e-002, -2.690313e-002,
   -2.631054e-002, -2.568272e-002, -2.501522e-002, -2.423081e-002, -2.327379e-002, -2.213933e-002, -2.083558e-002, -1.937900e-002, -1.777280e-002,
   -1.602882e-002, -1.415470e-002, -1.216174e-002, -1.005800e-002, -7.852785e-003, -5.577669e-003, -3.225707e-003, -7.950705e-004, 1.705089e-003,
   4.264522e-003,  6.878565e-003,  9.538148e-003,  1.223065e-002,  1.495671e-002,  1.771635e-002,  2.048061e-002,  2.324050e-002,  2.600766e-002,
   2.877234e-002,  3.151481e-002,  3.423751e-002,  3.693500e-002,  3.958961e-002,  4.218836e-002,  4.472905e-002,  4.718425e-002,  4.952104e-002,
   5.177306e-002,  5.392289e-002,  5.595635e-002,  5.787058e-002,  5.965460e-002,  6.129793e-002,  6.278696e-002,  6.411225e-002,  6.528875e-002,
   6.635753e-002,  6.740654e-002,  6.842936e-002,  6.941785e-002,  7.037484e-002,  7.129397e-002,  7.217953e-002,  7.302982e-002,  7.384295e-002,
   7.462526e-002,  7.531136e-002,  7.595260e-002,  7.656510e-002,  7.714040e-002,  7.768690e-002,  7.820494e-002,  7.869486e-002,  7.915010e-002,
   7.957722e-002,  7.998262e-002,  8.030348e-002,  8.055689e-002,  8.077996e-002,  8.097339e-002,  8.113253e-002,  8.126649e-002,  8.137266e-002,
   8.144338e-002,  8.148531e-002,  8.150996e-002,  8.146725e-002,  8.133055e-002,  8.116286e-002,  8.097584e-002,  8.077114e-002,  8.054803e-002,
   8.030825e-002,  8.005100e-002,  7.977142e-002,  7.947684e-002,  7.915042e-002,  7.868925e-002,  7.820427e-002,  7.770436e-002,  7.718218e-002,
   7.663719e-002,  7.606605e-002,  7.546112e-002,  7.483145e-002,  7.418819e-002,  7.353566e-002,  7.274333e-002,  7.191560e-002,  7.106967e-002,
   7.014388e-002,  6.907394e-002,  6.787116e-002,  6.652866e-002,  6.505626e-002,  6.346981e-002,  6.177939e-002,  5.989445e-002,  5.785643e-002,
   5.573531e-002,  5.354293e-002,  5.129314e-002,  4.898206e-002,  4.661231e-002,  4.419842e-002,  4.174299e-002,  3.925274e-002,  3.667568e-002,
   3.399441e-002,  3.130476e-002,  2.862103e-002,  2.594957e-002,  2.329398e-002,  2.065878e-002,  1.805871e-002,  1.549285e-002,  1.299559e-002,
   1.052828e-002,  8.012932e-003,  5.579455e-003,  3.236911e-003,  9.938308e-004,  -1.150984e-003, -3.174735e-003, -5.059686e-003, -6.809659e-003,
   -8.412335e-003, -9.880705e-003, -1.134897e-002, -1.265636e-002, -1.379655e-002, -1.477553e-002, -1.562985e-002, -1.643292e-002, -1.718090e-002,
   -1.789842e-002, -1.856768e-002, -1.919719e-002, -1.990426e-002, -2.061248e-002, -2.128293e-002, -2.192866e-002, -2.253926e-002, -2.310378e-002,
   -2.362728e-002, -2.411584e-002, -2.457203e-002, -2.499363e-002, -2.544621e-002, -2.592946e-002, -2.638024e-002, -2.680883e-002, -2.718994e-002,
   -2.751874e-002, -2.780663e-002, -2.806841e-002, -2.829710e-002, -2.849539e-002, -2.869767e-002, -2.894609e-002, -2.917919e-002, -2.939030e-002,
   -2.959010e-002, -2.976742e-002, -2.993230e-002, -3.008729e-002, -3.022927e-002, -3.036955e-002, -3.049923e-002, -3.072052e-002, -3.092149e-002,
   -3.111119e-002, -3.128595e-002, -3.144230e-002, -3.158714e-002, -3.171439e-002, -3.183511e-002, -3.195244e-002, -3.206430e-002, -3.223227e-002,
   -3.239407e-002, -3.254359e-002, -3.268446e-002, -3.281057e-002, -3.292358e-002, -3.303140e-002, -3.311759e-002, -3.320461e-002, -3.328666e-002,
   -3.339610e-002, -3.350562e-002, -3.361439e-002, -3.371436e-002, -3.380370e-002, -3.386828e-002, -3.392261e-002, -3.398305e-002, -3.404143e-002,
   -3.410032e-002, -3.416745e-002, -3.425610e-002, -3.433801e-002, -3.439257e-002, -3.442454e-002, -3.445381e-002, -3.446423e-002, -3.445652e-002,
   -3.444137e-002, -3.442753e-002, -3.440449e-002, -3.437195e-002, -3.434489e-002, -3.431202e-002, -3.425952e-002, -3.419591e-002, -3.412652e-002,
   -3.405660e-002, -3.397037e-002, -3.386071e-002, -3.373766e-002, -3.358638e-002, -3.342210e-002, -3.324240e-002, -3.306331e-002, -3.287532e-002,
   -3.266469e-002, -3.243061e-002, -3.219270e-002, -3.194425e-002, -3.168588e-002, -3.137974e-002, -3.105209e-002, -3.073460e-002, -3.041001e-002,
   -3.008346e-002, -2.976094e-002, -2.943923e-002, -2.909910e-002, -2.874775e-002, -2.837853e-002, -2.798124e-002, -2.754629e-002, -2.709499e-002,
   -2.663031e-002, -2.615798e-002, -2.567753e-002, -2.517289e-002, -2.465078e-002, -2.410762e-002, -2.355098e-002, -2.294501e-002, -2.226624e-002,
   -2.157321e-002, -2.086015e-002, -2.010767e-002, -1.937109e-002, -1.861038e-002, -1.781892e-002, -1.701951e-002, -1.620382e-002, -1.536266e-002,
   -1.443233e-002, -1.347535e-002, -1.251570e-002, -1.152925e-002, -1.049380e-002, -9.454898e-003, -8.412042e-003, -7.360208e-003, -6.294182e-003,
   -5.200498e-003, -4.087726e-003, -2.968007e-003, -1.810612e-003, -6.067522e-004, 6.302428e-004,  1.892252e-003,  3.198992e-003,  4.546572e-003,
   5.901268e-003,  7.291148e-003,  8.664949e-003,  1.001731e-002,  1.138519e-002,  1.278020e-002,  1.423137e-002,  1.569641e-002,  1.720541e-002,
   1.874068e-002,  2.028562e-002,  2.185744e-002,  2.336896e-002,  2.475774e-002,  2.616468e-002,  2.759369e-002,  2.902556e-002,  3.044395e-002,
   3.185632e-002,  3.328766e-002,  3.470071e-002,  3.610923e-002,  3.750439e-002,  3.853541e-002,  3.952907e-002,  4.051893e-002,  4.139801e-002,
   4.211495e-002,  4.274570e-002,  4.326666e-002,  4.372189e-002,  4.408742e-002,  4.434519e-002,  4.400735e-002,  4.347527e-002,  4.287175e-002,
   4.221931e-002,  4.151379e-002,  4.081665e-002,  4.008411e-002,  3.929407e-002,  3.843269e-002,  3.753149e-002,  3.599452e-002,  3.409139e-002,
   3.220871e-002,  3.039499e-002,  2.859782e-002,  2.685830e-002,  2.515944e-002,  2.352059e-002,  2.190952e-002,  2.034107e-002,  1.829571e-002,
   1.549800e-002,  1.277763e-002,  1.024268e-002,  7.809282e-003,  5.582108e-003,  3.479477e-003,  1.563834e-003,  -8.121426e-005, -1.495434e-003,
   -3.060928e-003, -6.032519e-003, -8.871614e-003, -1.148263e-002, -1.384117e-002, -1.589989e-002, -1.754176e-002, -1.881581e-002, -1.954533e-002,
   -2.012737e-002, -2.044263e-002, -2.304076e-002, -2.546563e-002, -2.722867e-002, -2.850422e-002, -2.929996e-002, -2.978185e-002, -2.999934e-002,
   -2.980564e-002, -2.860301e-002, -2.476663e-002, -2.430392e-002, -2.519189e-002, -2.564640e-002, -2.601808e-002, -2.618570e-002, -2.617154e-002,
   -2.595932e-002, -2.530687e-002, -2.424254e-002, -2.321012e-002, 1.663367e-003,  -1.540108e-003, -6.532874e-003, -1.179565e-002, -1.711408e-002,
   -2.178092e-002, -2.548677e-002, -2.801166e-002, -2.912911e-002, -2.735056e-002, 3.193593e-002,  9.422371e-002,  1.004558e-001,  9.912590e-002,
   9.465689e-002,  8.663026e-002,  4.994391e-002,  3.638524e-002,  2.312703e-002,  1.122065e-002,  0.000000e+000},
  {0.000000e+000,  -1.917446e-002, -3.357208e-002, -4.485993e-002, -5.392290e-002, -6.133844e-002, -6.740496e-002, -7.236591e-002, -7.645188e-002,
   -8.000724e-002, -8.299973e-002, -8.573523e-002, -8.813601e-002, -9.013370e-002, -9.176863e-002, -9.305295e-002, -9.400689e-002, -9.464648e-002,
   -9.498033e-002, -9.506144e-002, -9.491476e-002, -9.476642e-002, -9.458767e-002, -9.423030e-002, -9.371314e-002, -9.303643e-002, -9.222339e-002,
   -9.128921e-002, -9.024554e-002, -8.908451e-002, -8.781100e-002, -8.654811e-002, -8.545081e-002, -8.426564e-002, -8.299402e-002, -8.163693e-002,
   -8.020261e-002, -7.869511e-002, -7.711815e-002, -7.548039e-002, -7.378460e-002, -7.206211e-002, -7.060756e-002, -6.911360e-002, -6.757632e-002,
   -6.599840e-002, -6.438893e-002, -6.277236e-002, -6.112213e-002, -5.940795e-002, -5.765177e-002, -5.586309e-002, -5.433067e-002, -5.282395e-002,
   -5.129899e-002, -4.975244e-002, -4.818755e-002, -4.660027e-002, -4.499140e-002, -4.336808e-002, -4.172639e-002, -4.006777e-002, -3.858851e-002,
   -3.720490e-002, -3.580733e-002, -3.438978e-002, -3.294948e-002, -3.149376e-002, -3.001498e-002, -2.852463e-002, -2.700631e-002, -2.547403e-002,
   -2.402804e-002, -2.273288e-002, -2.141482e-002, -2.007256e-002, -1.870569e-002, -1.732251e-002, -1.591873e-002, -1.450606e-002, -1.308348e-002,
   -1.166399e-002, -1.026940e-002, -9.083404e-003, -7.893131e-003, -6.695535e-003, -5.494698e-003, -4.287636e-003, -3.085106e-003, -1.885421e-003,
   -6.951573e-004, 4.881600e-004,  1.662182e-003,  2.623669e-003,  3.563596e-003,  4.505491e-003,  5.443136e-003,  6.384833e-003,  7.320107e-003,
   8.259680e-003,  9.200667e-003,  1.014429e-002,  1.109345e-002,  1.190536e-002,  1.266814e-002,  1.344581e-002,  1.423572e-002,  1.503570e-002,
   1.584482e-002,  1.665877e-002,  1.747891e-002,  1.830714e-002,  1.913794e-002,  1.989411e-002,  2.055821e-002,  2.122006e-002,  2.188852e-002,
   2.255585e-002,  2.322480e-002,  2.389807e-002,  2.456945e-002,  2.524273e-002,  2.591617e-002,  2.653953e-002,  2.703306e-002,  2.751417e-002,
   2.797891e-002,  2.843113e-002,  2.888141e-002,  2.932330e-002,  2.975701e-002,  3.018879e-002,  3.061672e-002,  3.103566e-002,  3.132751e-002,
   3.161941e-002,  3.191093e-002,  3.220225e-002,  3.249863e-002,  3.279823e-002,  3.309734e-002,  3.339875e-002,  3.370476e-002,  3.401055e-002,
   3.423728e-002,  3.444550e-002,  3.465039e-002,  3.485282e-002,  3.505077e-002,  3.524521e-002,  3.543399e-002,  3.561996e-002,  3.580024e-002,
   3.597413e-002,  3.609436e-002,  3.617334e-002,  3.624943e-002,  3.631673e-002,  3.637839e-002,  3.643366e-002,  3.648319e-002,  3.653290e-002,
   3.658274e-002,  3.662739e-002,  3.664504e-002,  3.661775e-002,  3.659165e-002,  3.656757e-002,  3.654867e-002,  3.653761e-002,  3.653013e-002,
   3.652263e-002,  3.651496e-002,  3.650953e-002,  3.649904e-002,  3.643903e-002,  3.638514e-002,  3.633951e-002,  3.629677e-002,  3.625838e-002,
   3.622128e-002,  3.618553e-002,  3.614227e-002,  3.608796e-002,  3.602448e-002,  3.592186e-002,  3.581270e-002,  3.570182e-002,  3.559374e-002,
   3.548919e-002,  3.538912e-002,  3.528891e-002,  3.519033e-002,  3.509710e-002,  3.500855e-002,  3.490307e-002,  3.478914e-002,  3.467962e-002,
   3.457497e-002,  3.447593e-002,  3.438088e-002,  3.429267e-002,  3.420769e-002,  3.412331e-002,  3.404129e-002,  3.395038e-002,  3.385377e-002,
   3.376349e-002,  3.367717e-002,  3.359452e-002,  3.351075e-002,  3.342211e-002,  3.332489e-002,  3.321856e-002,  3.310648e-002,  3.299112e-002,
   3.286239e-002,  3.273023e-002,  3.259424e-002,  3.244970e-002,  3.229691e-002,  3.213224e-002,  3.195314e-002,  3.175759e-002,  3.154535e-002,
   3.131696e-002,  3.107177e-002,  3.081463e-002,  3.054844e-002,  3.027322e-002,  2.998869e-002,  2.969435e-002,  2.939066e-002,  2.907574e-002,
   2.875039e-002,  2.841608e-002,  2.807611e-002,  2.773074e-002,  2.737984e-002,  2.702442e-002,  2.666572e-002,  2.630341e-002,  2.593684e-002,
   2.556620e-002,  2.519267e-002,  2.481882e-002,  2.445268e-002,  2.409979e-002,  2.375497e-002,  2.341708e-002,  2.307716e-002,  2.273164e-002,
   2.237549e-002,  2.200921e-002,  2.163239e-002,  2.124693e-002,  2.085590e-002,  2.047269e-002,  2.008043e-002,  1.967697e-002,  1.926279e-002,
   1.883700e-002,  1.839302e-002,  1.793299e-002,  1.745895e-002,  1.697244e-002,  1.647985e-002,  1.600584e-002,  1.552323e-002,  1.503196e-002,
   1.453342e-002,  1.402785e-002,  1.351147e-002,  1.298759e-002,  1.245719e-002,  1.192083e-002,  1.138255e-002,  1.086985e-002,  1.035852e-002,
   9.840363e-003,  9.312295e-003,  8.775670e-003,  8.231568e-003,  7.681165e-003,  7.126639e-003,  6.568512e-003,  6.005336e-003,  5.462882e-003,
   4.929542e-003,  4.382658e-003,  3.815087e-003,  3.224469e-003,  2.616268e-003,  1.990636e-003,  1.350767e-003,  7.016947e-004,  4.389856e-005,
   -6.067232e-004, -1.231697e-003, -1.868920e-003, -2.513248e-003, -3.164459e-003, -3.818774e-003, -4.476777e-003, -5.137901e-003, -5.800929e-003,
   -6.464408e-003, -7.122740e-003, -7.727417e-003, -8.332544e-003, -8.937141e-003, -9.542490e-003, -1.014530e-002, -1.074228e-002, -1.133222e-002,
   -1.191453e-002, -1.248632e-002, -1.305039e-002, -1.354845e-002, -1.403250e-002, -1.451553e-002, -1.499934e-002, -1.548424e-002, -1.596907e-002,
   -1.645463e-002, -1.693731e-002, -1.741907e-002, -1.789961e-002, -1.833226e-002, -1.874193e-002, -1.916374e-002, -1.959630e-002, -2.003797e-002,
   -2.048484e-002, -2.093619e-002, -2.139084e-002, -2.184684e-002, -2.230407e-002, -2.272553e-002, -2.309865e-002, -2.346817e-002, -2.383434e-002,
   -2.419793e-002, -2.455811e-002, -2.491016e-002, -2.525650e-002, -2.559477e-002, -2.592536e-002, -2.623229e-002, -2.645505e-002, -2.667012e-002,
   -2.688084e-002, -2.709237e-002, -2.731168e-002, -2.754372e-002, -2.778848e-002, -2.804347e-002, -2.830894e-002, -2.858594e-002, -2.878516e-002,
   -2.899026e-002, -2.920274e-002, -2.942234e-002, -2.964643e-002, -2.987455e-002, -3.011029e-002, -3.035074e-002, -3.058768e-002, -3.081560e-002,
   -3.096361e-002, -3.107537e-002, -3.117723e-002, -3.126817e-002, -3.134781e-002, -3.141687e-002, -3.147970e-002, -3.153434e-002, -3.157991e-002,
   -3.161908e-002, -3.160049e-002, -3.152558e-002, -3.144618e-002, -3.136124e-002, -3.127568e-002, -3.119045e-002, -3.110238e-002, -3.101343e-002,
   -3.092555e-002, -3.083977e-002, -3.073487e-002, -3.056175e-002, -3.039486e-002, -3.024078e-002, -3.009392e-002, -2.995230e-002, -2.981630e-002,
   -2.968627e-002, -2.956511e-002, -2.945145e-002, -2.934473e-002, -2.914892e-002, -2.896167e-002, -2.878619e-002, -2.862006e-002, -2.846599e-002,
   -2.832434e-002, -2.819575e-002, -2.807609e-002, -2.796652e-002, -2.786538e-002, -2.769262e-002, -2.751077e-002, -2.734129e-002, -2.718233e-002,
   -2.703879e-002, -2.690162e-002, -2.677085e-002, -2.664745e-002, -2.653349e-002, -2.642912e-002, -2.628001e-002, -2.609563e-002, -2.592181e-002,
   -2.575652e-002, -2.560114e-002, -2.545607e-002, -2.531877e-002, -2.519355e-002, -2.508190e-002, -2.498252e-002, -2.486268e-002, -2.469393e-002,
   -2.453210e-002, -2.437617e-002, -2.422835e-002, -2.408568e-002, -2.394476e-002, -2.380653e-002, -2.367064e-002, -2.353609e-002, -2.338756e-002,
   -2.314842e-002, -2.290056e-002, -2.264949e-002, -2.239572e-002, -2.214139e-002, -2.189076e-002, -2.164275e-002, -2.139338e-002, -2.114066e-002,
   -2.088098e-002, -2.053391e-002, -2.016921e-002, -1.980130e-002, -1.943307e-002, -1.907297e-002, -1.872935e-002, -1.840240e-002, -1.808596e-002,
   -1.777645e-002, -1.747299e-002, -1.711816e-002, -1.673914e-002, -1.636362e-002, -1.599391e-002, -1.562728e-002, -1.526190e-002, -1.489888e-002,
   -1.453651e-002, -1.417805e-002, -1.382231e-002, -1.343602e-002, -1.300491e-002, -1.257843e-002, -1.215241e-002, -1.172580e-002, -1.130559e-002,
   -1.089582e-002, -1.049300e-002, -1.009362e-002, -9.695659e-003, -9.285519e-003, -8.816713e-003, -8.352234e-003, -7.895409e-003, -7.441561e-003,
   -6.988173e-003, -6.532293e-003, -6.076290e-003, -5.617894e-003, -5.162532e-003, -4.716524e-003, -4.213511e-003, -3.709718e-003, -3.206436e-003,
   -2.707442e-003, -2.209886e-003, -1.711461e-003, -1.218845e-003, -7.329040e-004, -2.519923e-004, 2.189814e-004,  7.196384e-004,  1.224210e-003,
   1.719773e-003,  2.201916e-003,  2.672677e-003,  3.133300e-003,  3.584433e-003,  4.022172e-003,  4.445831e-003,  4.859802e-003,  5.288276e-003,
   5.729418e-003,  6.164774e-003,  6.595163e-003,  7.019463e-003,  7.435052e-003,  7.844685e-003,  8.253468e-003,  8.662508e-003,  9.075197e-003,
   9.494715e-003,  9.933839e-003,  1.035931e-002,  1.077187e-002,  1.115711e-002,  1.148821e-002,  1.176705e-002,  1.200211e-002,  1.219583e-002,
   1.234683e-002,  1.246053e-002,  1.256879e-002,  1.263062e-002,  1.264619e-002,  1.262526e-002,  1.257657e-002,  1.249829e-002,  1.239119e-002,
   1.226101e-002,  1.210424e-002,  1.192751e-002,  1.176205e-002,  1.159270e-002,  1.141325e-002,  1.122008e-002,  1.102307e-002,  1.081814e-002,
   1.061591e-002,  1.041970e-002,  1.022444e-002,  1.003443e-002,  9.857186e-003,  9.697819e-003,  9.543568e-003,  9.394526e-003,  9.259355e-003,
   9.135011e-003,  9.023077e-003,  8.925633e-003,  8.847889e-003,  8.792825e-003,  8.768596e-003,  8.771325e-003,  8.793507e-003,  8.823824e-003,
   8.850958e-003,  8.873715e-003,  8.896308e-003,  8.919653e-003,  8.933983e-003,  8.939269e-003,  8.947762e-003,  8.975280e-003,  9.002827e-003,
   9.031671e-003,  9.057938e-003,  9.084063e-003,  9.105906e-003,  9.132004e-003,  9.164379e-003,  9.200538e-003,  9.239389e-003,  9.298251e-003,
   9.366940e-003,  9.447092e-003,  9.539115e-003,  9.638633e-003,  9.749691e-003,  9.878277e-003,  1.001388e-002,  1.014726e-002,  1.028210e-002,
   1.043178e-002,  1.058861e-002,  1.074030e-002,  1.088568e-002,  1.103104e-002,  1.118389e-002,  1.134514e-002,  1.151074e-002,  1.166761e-002,
   1.181343e-002,  1.195476e-002,  1.210631e-002,  1.225648e-002,  1.240763e-002,  1.255400e-002,  1.269543e-002,  1.283047e-002,  1.295913e-002,
   1.308551e-002,  1.321516e-002,  1.334864e-002,  1.350993e-002,  1.366855e-002,  1.383075e-002,  1.399476e-002,  1.416295e-002,  1.433064e-002,
   1.449699e-002,  1.466705e-002,  1.483713e-002,  1.502819e-002,  1.529944e-002,  1.560268e-002,  1.592598e-002,  1.626904e-002,  1.662632e-002,
   1.699631e-002,  1.737554e-002,  1.775944e-002,  1.813723e-002,  1.851182e-002,  1.892832e-002,  1.936569e-002,  1.979890e-002,  2.022158e-002,
   2.062698e-002,  2.102278e-002,  2.140795e-002,  2.178210e-002,  2.214103e-002,  2.247572e-002,  2.281408e-002,  2.315818e-002,  2.347566e-002,
   2.376343e-002,  2.401848e-002,  2.422955e-002,  2.440734e-002,  2.454562e-002,  2.464994e-002,  2.471761e-002,  2.477157e-002,  2.483714e-002,
   2.486794e-002,  2.484086e-002,  2.475764e-002,  2.462347e-002,  2.443064e-002,  2.418035e-002,  2.387274e-002,  2.350931e-002,  2.308710e-002,
   2.272446e-002,  2.233632e-002,  2.191968e-002,  2.147619e-002,  2.100039e-002,  2.048852e-002,  1.993961e-002,  1.935590e-002,  1.874341e-002,
   1.810521e-002,  1.753298e-002,  1.695167e-002,  1.634195e-002,  1.571312e-002,  1.506808e-002,  1.440274e-002,  1.371353e-002,  1.301384e-002,
   1.229053e-002,  1.155709e-002,  1.089028e-002,  1.026460e-002,  9.623148e-003,  8.968709e-003,  8.297757e-003,  7.617934e-003,  6.937591e-003,
   6.259397e-003,  5.567104e-003,  4.877408e-003,  4.234189e-003,  3.681638e-003,  3.123003e-003,  2.563191e-003,  1.993958e-003,  1.405985e-003,
   8.075303e-004,  1.878482e-004,  -4.555642e-004, -1.106193e-003, -1.741581e-003, -2.249442e-003, -2.773752e-003, -3.310069e-003, -3.867641e-003,
   -4.443892e-003, -5.038108e-003, -5.656982e-003, -6.290361e-003, -6.920992e-003, -7.566403e-003, -8.062841e-003, -8.545951e-003, -9.037743e-003,
   -9.551054e-003, -1.008472e-002, -1.063359e-002, -1.119183e-002, -1.175770e-002, -1.233640e-002, -1.293430e-002, -1.342456e-002, -1.388017e-002,
   -1.433659e-002, -1.479283e-002, -1.525609e-002, -1.573319e-002, -1.622192e-002, -1.672732e-002, -1.724396e-002, -1.777834e-002, -1.824211e-002,
   -1.859649e-002, -1.896824e-002, -1.935861e-002, -1.976412e-002, -2.018267e-002, -2.060665e-002, -2.104167e-002, -2.149765e-002, -2.196816e-002,
   -2.238555e-002, -2.263105e-002, -2.286099e-002, -2.309679e-002, -2.335761e-002, -2.360879e-002, -2.383739e-002, -2.404131e-002, -2.421688e-002,
   -2.438284e-002, -2.455886e-002, -2.453385e-002, -2.450025e-002, -2.446302e-002, -2.441445e-002, -2.435980e-002, -2.430471e-002, -2.425663e-002,
   -2.421236e-002, -2.417048e-002, -2.412329e-002, -2.393496e-002, -2.371439e-002, -2.349890e-002, -2.328333e-002, -2.306380e-002, -2.285338e-002,
   -2.265720e-002, -2.245591e-002, -2.225555e-002, -2.204958e-002, -2.175324e-002, -2.138768e-002, -2.100773e-002, -2.061061e-002, -2.019770e-002,
   -1.979063e-002, -1.939110e-002, -1.898675e-002, -1.857286e-002, -1.815986e-002, -1.768190e-002, -1.707631e-002, -1.646493e-002, -1.586174e-002,
   -1.527974e-002, -1.469667e-002, -1.412950e-002, -1.359741e-002, -1.306783e-002, -1.254024e-002, -1.202383e-002, -1.135842e-002, -1.070901e-002,
   -1.007462e-002, -9.442801e-003, -8.819133e-003, -8.224198e-003, -7.651293e-003, -7.099552e-003, -6.545813e-003, -6.013025e-003, -5.357565e-003,
   -4.699674e-003, -4.034334e-003, -3.381717e-003, -2.742704e-003, -2.119204e-003, -1.518067e-003, -9.144723e-004, -3.191589e-004, 2.692416e-004,
   9.154375e-004,  1.611244e-003,  2.300195e-003,  2.999192e-003,  3.691826e-003,  4.367659e-003,  5.012450e-003,  5.640230e-003,  6.257071e-003,
   6.847229e-003,  7.467051e-003,  8.164145e-003,  8.843807e-003,  9.512631e-003,  1.016594e-002,  1.079930e-002,  1.140911e-002,  1.200100e-002,
   1.258150e-002,  1.312002e-002,  1.362417e-002,  1.421968e-002,  1.479411e-002,  1.535432e-002,  1.587872e-002,  1.639481e-002,  1.689175e-002,
   1.735602e-002,  1.779859e-002,  1.821660e-002,  1.862369e-002,  1.910846e-002,  1.959168e-002,  2.002075e-002,  2.042901e-002,  2.082711e-002,
   2.121867e-002,  2.158960e-002,  2.191764e-002,  2.219604e-002,  2.244719e-002,  2.272196e-002,  2.298230e-002,  2.322330e-002,  2.343503e-002,
   2.358212e-002,  2.367929e-002,  2.376000e-002,  2.381506e-002,  2.382425e-002,  2.378198e-002,  2.373273e-002,  2.370051e-002,  2.363768e-002,
   2.354695e-002,  2.346150e-002,  2.333068e-002,  2.316178e-002,  2.296032e-002,  2.271135e-002,  2.245856e-002,  2.219101e-002,  2.197463e-002,
   2.172716e-002,  2.145696e-002,  2.110164e-002,  2.071442e-002,  2.031747e-002,  1.989726e-002,  1.943063e-002,  1.892547e-002,  1.841200e-002,
   1.801767e-002,  1.758195e-002,  1.711026e-002,  1.662520e-002,  1.606876e-002,  1.547467e-002,  1.484573e-002,  1.419956e-002,  1.351311e-002,
   1.276732e-002,  1.221456e-002,  1.168424e-002,  1.112611e-002,  1.048345e-002,  9.771772e-003,  9.006919e-003,  8.209925e-003,  7.291518e-003,
   6.303868e-003,  5.262990e-003,  4.369873e-003,  3.622963e-003,  2.800930e-003,  1.908438e-003,  9.301908e-004,  -6.751147e-005, -1.194167e-003,
   -2.400381e-003, -3.650491e-003, -4.973638e-003, -6.172517e-003, -7.077792e-003, -8.140636e-003, -9.311190e-003, -1.056024e-002, -1.187086e-002,
   -1.318945e-002, -1.458420e-002, -1.607262e-002, -1.762410e-002, -1.910481e-002, -1.990147e-002, -2.075472e-002, -2.166737e-002, -2.258154e-002,
   -2.354181e-002, -2.455364e-002, -2.554955e-002, -2.661309e-002, -2.771601e-002, -2.887493e-002, -2.924331e-002, -2.948401e-002, -2.977495e-002,
   -3.017102e-002, -3.077033e-002, -3.155324e-002, -3.228826e-002, -3.296981e-002, -3.366864e-002, -3.448449e-002, -3.440618e-002, -3.395232e-002,
   -3.357070e-002, -3.337851e-002, -3.329987e-002, -3.334036e-002, -3.349073e-002, -3.367563e-002, -3.396043e-002, -3.427566e-002, -3.387107e-002,
   -3.239505e-002, -3.104770e-002, -2.987876e-002, -2.878359e-002, -2.783670e-002, -2.702611e-002, -2.640568e-002, -2.611636e-002, -2.596032e-002,
   -2.551346e-002, -2.288226e-002, -2.024662e-002, -1.773271e-002, -1.531131e-002, -1.297201e-002, -1.082345e-002, -8.923257e-003, -7.666208e-003,
   -6.381686e-003, -5.168593e-003, -7.141463e-004, 3.875751e-003,  7.865452e-003,  1.127558e-002,  1.435102e-002,  1.748499e-002,  2.080198e-002,
   2.397681e-002,  2.641973e-002,  2.652330e-002,  3.077613e-002,  3.656855e-002,  4.173548e-002,  4.632218e-002,  4.950615e-002,  5.196148e-002,
   5.385484e-002,  5.571919e-002,  5.787208e-002,  6.100562e-002,  4.281794e-002,  5.140241e-002,  6.137765e-002,  7.164735e-002,  8.226066e-002,
   9.222150e-002,  1.001564e-001,  1.059300e-001,  1.087946e-001,  1.051641e-001,  -5.533066e-002, -1.499467e-001, -1.670421e-001, -1.696878e-001,
   -1.655690e-001, -1.543446e-001, -8.028114e-002, -5.674685e-002, -3.469316e-002, -1.615907e-002, 0.000000e+000},
  {0.000000e+000,  -1.513089e-002, -2.602010e-002, -3.431418e-002, -4.090427e-002, -4.616818e-002, -5.043410e-002, -5.385045e-002, -5.663978e-002,
   -5.873895e-002, -6.041027e-002, -6.202552e-002, -6.324324e-002, -6.409526e-002, -6.465596e-002, -6.497530e-002, -6.512038e-002, -6.510237e-002,
   -6.496655e-002, -6.467680e-002, -6.425072e-002, -6.390810e-002, -6.360686e-002, -6.318816e-002, -6.265719e-002, -6.200858e-002, -6.123204e-002,
   -6.034566e-002, -5.934985e-002, -5.825208e-002, -5.706811e-002, -5.592179e-002, -5.495033e-002, -5.391145e-002, -5.280582e-002, -5.164470e-002,
   -5.043659e-002, -4.917047e-002, -4.786199e-002, -4.651296e-002, -4.512187e-002, -4.372417e-002, -4.259674e-002, -4.142757e-002, -4.021568e-002,
   -3.895281e-002, -3.756986e-002, -3.595483e-002, -3.432941e-002, -3.291504e-002, -3.155027e-002, -3.015986e-002, -2.900770e-002, -2.787021e-002,
   -2.670250e-002, -2.551076e-002, -2.429558e-002, -2.306075e-002, -2.180418e-002, -2.053092e-002, -1.923246e-002, -1.792083e-002, -1.676809e-002,
   -1.569928e-002, -1.461997e-002, -1.352298e-002, -1.240453e-002, -1.126905e-002, -1.011961e-002, -8.946282e-003, -7.761666e-003, -6.560747e-003,
   -5.441541e-003, -4.469995e-003, -3.486162e-003, -2.482251e-003, -1.468615e-003, -4.419604e-004, 5.903142e-004,  1.616780e-003,  2.627548e-003,
   3.614490e-003,  4.530195e-003,  5.220392e-003,  5.888836e-003,  6.535997e-003,  7.162740e-003,  7.777999e-003,  8.383193e-003,  8.984390e-003,
   9.598139e-003,  1.021886e-002,  1.084786e-002,  1.129105e-002,  1.173658e-002,  1.220060e-002,  1.267773e-002,  1.317340e-002,  1.369284e-002,
   1.423043e-002,  1.478897e-002,  1.536608e-002,  1.596958e-002,  1.646712e-002,  1.691547e-002,  1.736213e-002,  1.781475e-002,  1.827348e-002,
   1.875152e-002,  1.924053e-002,  1.974396e-002,  2.027162e-002,  2.080416e-002,  2.126764e-002,  2.164977e-002,  2.203226e-002,  2.243031e-002,
   2.283490e-002,  2.324175e-002,  2.365723e-002,  2.407445e-002,  2.449577e-002,  2.491619e-002,  2.528548e-002,  2.552624e-002,  2.575306e-002,
   2.596864e-002,  2.617468e-002,  2.636997e-002,  2.656103e-002,  2.674751e-002,  2.693041e-002,  2.711586e-002,  2.730100e-002,  2.736327e-002,
   2.743111e-002,  2.750780e-002,  2.759409e-002,  2.769150e-002,  2.779709e-002,  2.791160e-002,  2.803236e-002,  2.815873e-002,  2.829422e-002,
   2.835326e-002,  2.839156e-002,  2.843231e-002,  2.847664e-002,  2.852130e-002,  2.855997e-002,  2.859675e-002,  2.863326e-002,  2.866769e-002,
   2.869808e-002,  2.867806e-002,  2.861527e-002,  2.854657e-002,  2.847173e-002,  2.838941e-002,  2.830141e-002,  2.820868e-002,  2.811522e-002,
   2.801889e-002,  2.792201e-002,  2.779906e-002,  2.762858e-002,  2.745881e-002,  2.729264e-002,  2.713420e-002,  2.698653e-002,  2.684412e-002,
   2.670519e-002,  2.656679e-002,  2.642590e-002,  2.627830e-002,  2.608067e-002,  2.588844e-002,  2.570033e-002,  2.551674e-002,  2.533743e-002,
   2.515533e-002,  2.496436e-002,  2.476015e-002,  2.454025e-002,  2.430273e-002,  2.401812e-002,  2.371948e-002,  2.341444e-002,  2.310233e-002,
   2.278806e-002,  2.246851e-002,  2.214482e-002,  2.181777e-002,  2.149282e-002,  2.116704e-002,  2.082180e-002,  2.046688e-002,  2.011597e-002,
   1.976830e-002,  1.941910e-002,  1.907145e-002,  1.872795e-002,  1.838517e-002,  1.804258e-002,  1.770120e-002,  1.735962e-002,  1.701964e-002,
   1.668808e-002,  1.636594e-002,  1.604862e-002,  1.573716e-002,  1.542418e-002,  1.510695e-002,  1.478228e-002,  1.445394e-002,  1.412564e-002,
   1.379080e-002,  1.345690e-002,  1.312278e-002,  1.278771e-002,  1.244913e-002,  1.209882e-002,  1.173455e-002,  1.135088e-002,  1.095260e-002,
   1.054188e-002,  1.012414e-002,  9.700809e-003,  9.271810e-003,  8.839668e-003,  8.404347e-003,  7.965961e-003,  7.525859e-003,  7.081762e-003,
   6.635759e-003,  6.189788e-003,  5.751523e-003,  5.316125e-003,  4.882661e-003,  4.451991e-003,  4.028038e-003,  3.611153e-003,  3.198070e-003,
   2.792951e-003,  2.393370e-003,  2.005082e-003,  1.635519e-003,  1.288480e-003,  9.567046e-004,  6.365004e-004,  3.212361e-004,  5.928453e-006,
   -3.154944e-004, -6.411000e-004, -9.740552e-004, -1.312533e-003, -1.650670e-003, -1.975120e-003, -2.302251e-003, -2.634752e-003, -2.972395e-003,
   -3.317597e-003, -3.672522e-003, -4.038256e-003, -4.410585e-003, -4.787997e-003, -5.165835e-003, -5.515990e-003, -5.867216e-003, -6.218242e-003,
   -6.567719e-003, -6.910353e-003, -7.247149e-003, -7.572990e-003, -7.889551e-003, -8.193243e-003, -8.481195e-003, -8.727862e-003, -8.956996e-003,
   -9.175427e-003, -9.385148e-003, -9.585352e-003, -9.773606e-003, -9.949173e-003, -1.011002e-002, -1.025693e-002, -1.039295e-002, -1.049508e-002,
   -1.057427e-002, -1.065307e-002, -1.074220e-002, -1.084373e-002, -1.095054e-002, -1.105919e-002, -1.116762e-002, -1.127459e-002, -1.138394e-002,
   -1.147771e-002, -1.154217e-002, -1.160747e-002, -1.167134e-002, -1.173498e-002, -1.179759e-002, -1.185616e-002, -1.191271e-002, -1.196644e-002,
   -1.201577e-002, -1.205772e-002, -1.205812e-002, -1.205706e-002, -1.205574e-002, -1.205392e-002, -1.205244e-002, -1.204529e-002, -1.203073e-002,
   -1.201014e-002, -1.197757e-002, -1.194330e-002, -1.187221e-002, -1.180150e-002, -1.173956e-002, -1.168769e-002, -1.164754e-002, -1.161830e-002,
   -1.159623e-002, -1.157804e-002, -1.156409e-002, -1.155810e-002, -1.153615e-002, -1.151150e-002, -1.150891e-002, -1.152607e-002, -1.156002e-002,
   -1.160697e-002, -1.166409e-002, -1.172874e-002, -1.180173e-002, -1.188266e-002, -1.194855e-002, -1.198838e-002, -1.203193e-002, -1.207790e-002,
   -1.212458e-002, -1.217171e-002, -1.221373e-002, -1.224913e-002, -1.227811e-002, -1.230136e-002, -1.230835e-002, -1.227079e-002, -1.222652e-002,
   -1.217982e-002, -1.213951e-002, -1.211423e-002, -1.210894e-002, -1.212638e-002, -1.216219e-002, -1.221750e-002, -1.228936e-002, -1.233243e-002,
   -1.239153e-002, -1.246416e-002, -1.254977e-002, -1.264650e-002, -1.275324e-002, -1.286705e-002, -1.299239e-002, -1.314277e-002, -1.333006e-002,
   -1.351766e-002, -1.372490e-002, -1.396419e-002, -1.423343e-002, -1.452615e-002, -1.484362e-002, -1.518574e-002, -1.554928e-002, -1.593152e-002,
   -1.632979e-002, -1.672023e-002, -1.710162e-002, -1.749700e-002, -1.790507e-002, -1.832401e-002, -1.875083e-002, -1.918725e-002, -1.963176e-002,
   -2.007908e-002, -2.053454e-002, -2.098924e-002, -2.142072e-002, -2.186073e-002, -2.230760e-002, -2.275536e-002, -2.320168e-002, -2.364440e-002,
   -2.408173e-002, -2.451069e-002, -2.493208e-002, -2.534058e-002, -2.569365e-002, -2.603318e-002, -2.635640e-002, -2.666028e-002, -2.694545e-002,
   -2.720776e-002, -2.744377e-002, -2.765074e-002, -2.782437e-002, -2.796399e-002, -2.803225e-002, -2.805593e-002, -2.804239e-002, -2.798377e-002,
   -2.789074e-002, -2.777740e-002, -2.764849e-002, -2.750532e-002, -2.734751e-002, -2.717681e-002, -2.697115e-002, -2.673534e-002, -2.649358e-002,
   -2.624620e-002, -2.599445e-002, -2.573498e-002, -2.546694e-002, -2.519169e-002, -2.491340e-002, -2.463827e-002, -2.435246e-002, -2.404021e-002,
   -2.372551e-002, -2.340497e-002, -2.307568e-002, -2.274493e-002, -2.240708e-002, -2.206356e-002, -2.171308e-002, -2.135277e-002, -2.097535e-002,
   -2.054366e-002, -2.009561e-002, -1.963690e-002, -1.917174e-002, -1.870415e-002, -1.823301e-002, -1.776092e-002, -1.728131e-002, -1.679752e-002,
   -1.630996e-002, -1.578492e-002, -1.525017e-002, -1.471318e-002, -1.418124e-002, -1.365779e-002, -1.315225e-002, -1.266586e-002, -1.219142e-002,
   -1.172513e-002, -1.126747e-002, -1.079278e-002, -1.030947e-002, -9.834041e-003, -9.368302e-003, -8.910686e-003, -8.458190e-003, -8.015212e-003,
   -7.581713e-003, -7.153917e-003, -6.738466e-003, -6.321619e-003, -5.887598e-003, -5.464705e-003, -5.051872e-003, -4.648289e-003, -4.256226e-003,
   -3.879666e-003, -3.519215e-003, -3.167309e-003, -2.824317e-003, -2.481970e-003, -2.118697e-003, -1.761598e-003, -1.412446e-003, -1.070596e-003,
   -7.359840e-004, -4.031155e-004, -7.382592e-005, 2.493033e-004,  5.663020e-004,  8.801216e-004,  1.220723e-003,  1.555849e-003,  1.886527e-003,
   2.205650e-003,  2.517195e-003,  2.825822e-003,  3.130473e-003,  3.422240e-003,  3.699429e-003,  3.962649e-003,  4.238399e-003,  4.510396e-003,
   4.770329e-003,  5.016804e-003,  5.245843e-003,  5.459187e-003,  5.658271e-003,  5.835690e-003,  5.997559e-003,  6.150148e-003,  6.317235e-003,
   6.496123e-003,  6.669149e-003,  6.840892e-003,  7.011295e-003,  7.183894e-003,  7.363536e-003,  7.553048e-003,  7.747728e-003,  7.957222e-003,
   8.185795e-003,  8.444409e-003,  8.696779e-003,  8.947623e-003,  9.205545e-003,  9.495967e-003,  9.815850e-003,  1.016410e-002,  1.053676e-002,
   1.093401e-002,  1.135721e-002,  1.183538e-002,  1.233183e-002,  1.284113e-002,  1.336313e-002,  1.389175e-002,  1.443221e-002,  1.498371e-002,
   1.554731e-002,  1.613216e-002,  1.672906e-002,  1.736281e-002,  1.800920e-002,  1.865990e-002,  1.931648e-002,  1.998390e-002,  2.068246e-002,
   2.139496e-002,  2.210936e-002,  2.282174e-002,  2.353467e-002,  2.426263e-002,  2.500194e-002,  2.573484e-002,  2.644758e-002,  2.713721e-002,
   2.780455e-002,  2.845263e-002,  2.907733e-002,  2.967072e-002,  3.023386e-002,  3.076778e-002,  3.126826e-002,  3.171708e-002,  3.213243e-002,
   3.252981e-002,  3.291081e-002,  3.328521e-002,  3.364506e-002,  3.398167e-002,  3.430133e-002,  3.461760e-002,  3.495420e-002,  3.527415e-002,
   3.557752e-002,  3.585584e-002,  3.611807e-002,  3.637563e-002,  3.661985e-002,  3.685572e-002,  3.707784e-002,  3.728932e-002,  3.753044e-002,
   3.777532e-002,  3.801211e-002,  3.823868e-002,  3.845884e-002,  3.868194e-002,  3.890723e-002,  3.913044e-002,  3.933410e-002,  3.951265e-002,
   3.969467e-002,  3.986620e-002,  4.000583e-002,  4.012215e-002,  4.021885e-002,  4.029810e-002,  4.035742e-002,  4.039236e-002,  4.039712e-002,
   4.036616e-002,  4.033204e-002,  4.029648e-002,  4.022641e-002,  4.012608e-002,  3.999744e-002,  3.984918e-002,  3.967742e-002,  3.949117e-002,
   3.928316e-002,  3.904585e-002,  3.879365e-002,  3.855934e-002,  3.830877e-002,  3.803975e-002,  3.776626e-002,  3.747283e-002,  3.715729e-002,
   3.682571e-002,  3.648086e-002,  3.611114e-002,  3.564106e-002,  3.506949e-002,  3.433176e-002,  3.343043e-002,  3.237910e-002,  3.118928e-002,
   2.986394e-002,  2.840973e-002,  2.683723e-002,  2.514909e-002,  2.334923e-002,  2.149750e-002,  1.957726e-002,  1.758677e-002,  1.553095e-002,
   1.342743e-002,  1.127428e-002,  9.082457e-003,  6.852831e-003,  4.600274e-003,  2.330826e-003,  9.670992e-005,  -2.107442e-003, -4.299697e-003,
   -6.464254e-003, -8.591899e-003, -1.068140e-002, -1.271764e-002, -1.470220e-002, -1.663056e-002, -1.848616e-002, -2.023605e-002, -2.184191e-002,
   -2.334117e-002, -2.472527e-002, -2.598871e-002, -2.713681e-002, -2.816199e-002, -2.904829e-002, -2.979090e-002, -3.038971e-002, -3.082379e-002,
   -3.114503e-002, -3.143273e-002, -3.170015e-002, -3.195930e-002, -3.222633e-002, -3.248056e-002, -3.272020e-002, -3.295030e-002, -3.318250e-002,
   -3.340173e-002, -3.354345e-002, -3.365604e-002, -3.375452e-002, -3.384938e-002, -3.393122e-002, -3.400394e-002, -3.407440e-002, -3.413313e-002,
   -3.417345e-002, -3.419318e-002, -3.415055e-002, -3.406551e-002, -3.397012e-002, -3.387051e-002, -3.376835e-002, -3.365763e-002, -3.354182e-002,
   -3.341585e-002, -3.327238e-002, -3.311810e-002, -3.292451e-002, -3.264383e-002, -3.235724e-002, -3.206325e-002, -3.174711e-002, -3.142888e-002,
   -3.110587e-002, -3.076615e-002, -3.042550e-002, -3.008008e-002, -2.971628e-002, -2.925026e-002, -2.879026e-002, -2.832373e-002, -2.784696e-002,
   -2.738232e-002, -2.692980e-002, -2.648655e-002, -2.605672e-002, -2.562160e-002, -2.517508e-002, -2.461720e-002, -2.404321e-002, -2.346606e-002,
   -2.287759e-002, -2.222208e-002, -2.149028e-002, -2.070422e-002, -1.987461e-002, -1.899694e-002, -1.807579e-002, -1.703213e-002, -1.589604e-002,
   -1.474006e-002, -1.356661e-002, -1.236401e-002, -1.115557e-002, -9.944304e-003, -8.711230e-003, -7.494120e-003, -6.293101e-003, -5.044246e-003,
   -3.726440e-003, -2.437434e-003, -1.155878e-003, 9.647393e-005,  1.291261e-003,  2.445642e-003,  3.555132e-003,  4.633891e-003,  5.670950e-003,
   6.696062e-003,  7.798756e-003,  8.843143e-003,  9.824123e-003,  1.074537e-002,  1.159825e-002,  1.238098e-002,  1.309580e-002,  1.374602e-002,
   1.432323e-002,  1.481198e-002,  1.537097e-002,  1.583122e-002,  1.618339e-002,  1.643916e-002,  1.660044e-002,  1.670655e-002,  1.676105e-002,
   1.675012e-002,  1.669459e-002,  1.659681e-002,  1.661749e-002,  1.663854e-002,  1.659712e-002,  1.650681e-002,  1.636235e-002,  1.618850e-002,
   1.597120e-002,  1.572013e-002,  1.543482e-002,  1.511241e-002,  1.487642e-002,  1.470792e-002,  1.450853e-002,  1.428672e-002,  1.402424e-002,
   1.372127e-002,  1.340156e-002,  1.305132e-002,  1.266906e-002,  1.227141e-002,  1.191321e-002,  1.171112e-002,  1.148816e-002,  1.124837e-002,
   1.095445e-002,  1.060459e-002,  1.018300e-002,  9.717040e-003,  9.206530e-003,  8.658816e-003,  8.082181e-003,  7.737456e-003,  7.362713e-003,
   6.935706e-003,  6.468731e-003,  5.961535e-003,  5.401857e-003,  4.820511e-003,  4.189308e-003,  3.543445e-003,  2.881612e-003,  2.432564e-003,
   2.014114e-003,  1.546133e-003,  1.061830e-003,  5.330611e-004,  -3.362993e-005, -6.294411e-004, -1.241024e-003, -1.885588e-003, -2.549440e-003,
   -3.026354e-003, -3.377187e-003, -3.742061e-003, -4.124591e-003, -4.550839e-003, -4.964029e-003, -5.386749e-003, -5.846407e-003, -6.332562e-003,
   -6.866081e-003, -7.254485e-003, -7.450363e-003, -7.663864e-003, -7.920798e-003, -8.217576e-003, -8.533979e-003, -8.889309e-003, -9.311523e-003,
   -9.783102e-003, -1.029099e-002, -1.078664e-002, -1.100014e-002, -1.125494e-002, -1.155534e-002, -1.187344e-002, -1.223715e-002, -1.263889e-002,
   -1.305366e-002, -1.350251e-002, -1.396097e-002, -1.446717e-002, -1.462256e-002, -1.477720e-002, -1.490871e-002, -1.503539e-002, -1.521567e-002,
   -1.544783e-002, -1.567307e-002, -1.591118e-002, -1.616483e-002, -1.645135e-002, -1.643566e-002, -1.629165e-002, -1.618123e-002, -1.614083e-002,
   -1.614478e-002, -1.621127e-002, -1.630524e-002, -1.645702e-002, -1.665345e-002, -1.682803e-002, -1.684368e-002, -1.665494e-002, -1.650930e-002,
   -1.642573e-002, -1.643562e-002, -1.648983e-002, -1.658580e-002, -1.674169e-002, -1.693109e-002, -1.719313e-002, -1.732301e-002, -1.703257e-002,
   -1.678137e-002, -1.655648e-002, -1.628178e-002, -1.610941e-002, -1.595264e-002, -1.577218e-002, -1.566355e-002, -1.559035e-002, -1.555006e-002,
   -1.497363e-002, -1.444341e-002, -1.393114e-002, -1.345663e-002, -1.297505e-002, -1.257072e-002, -1.220047e-002, -1.187661e-002, -1.160767e-002,
   -1.141694e-002, -1.084774e-002, -1.018487e-002, -9.569694e-003, -8.939467e-003, -8.287321e-003, -7.641859e-003, -7.056578e-003, -6.394240e-003,
   -5.795823e-003, -5.263189e-003, -4.442910e-003, -3.448303e-003, -2.535747e-003, -1.621275e-003, -7.260830e-004, 1.375633e-004,  1.075411e-003,
   1.965429e-003,  2.797509e-003,  3.668721e-003,  4.648531e-003,  6.124067e-003,  7.634131e-003,  9.165679e-003,  1.055493e-002,  1.193715e-002,
   1.325220e-002,  1.452959e-002,  1.563019e-002,  1.666391e-002,  1.764498e-002,  1.914960e-002,  2.046899e-002,  2.167188e-002,  2.281378e-002,
   2.380969e-002,  2.478135e-002,  2.563907e-002,  2.648461e-002,  2.719727e-002,  2.776752e-002,  2.892368e-002,  3.012721e-002,  3.133186e-002,
   3.250705e-002,  3.363869e-002,  3.486495e-002,  3.586056e-002,  3.667342e-002,  3.725278e-002,  3.769292e-002,  3.836079e-002,  3.930516e-002,
   4.014423e-002,  4.085759e-002,  4.135771e-002,  4.177264e-002,  4.202298e-002,  4.207538e-002,  4.209631e-002,  4.182417e-002,  4.164579e-002,
   4.170295e-002,  4.160686e-002,  4.142726e-002,  4.097206e-002,  4.033538e-002,  3.939414e-002,  3.839591e-002,  3.748286e-002,  3.653628e-002,
   3.545324e-002,  3.442050e-002,  3.292972e-002,  3.116934e-002,  2.884119e-002,  2.620559e-002,  2.318819e-002,  1.989661e-002,  1.709863e-002,
   1.416076e-002,  1.091104e-002,  7.880190e-003,  5.002088e-003,  2.084999e-003,  -7.328482e-004, -3.575068e-003, -7.438734e-003, -1.187920e-002,
   -1.685218e-002, -2.263953e-002, -2.924758e-002, -3.557124e-002, -4.171639e-002, -4.706453e-002, -5.128701e-002, -5.329986e-002, -5.537853e-002,
   -5.836344e-002, -6.301186e-002, -6.957576e-002, -7.841475e-002, -9.388745e-002, -1.040602e-001, -1.139593e-001, -1.247853e-001, -1.369840e-001,
   -1.488220e-001, -1.587383e-001, -1.663195e-001, -1.708929e-001, -1.675713e-001, 6.724573e-002,  1.666673e-001,  1.996120e-001,  2.069068e-001,
   2.043245e-001,  1.926459e-001,  1.199260e-001,  9.215341e-002,  6.162724e-002,  3.163523e-002,  0.000000e+000},
  {0.000000e+000,  -4.856922e-003, -7.797558e-003, -9.800473e-003, -1.121839e-002, -1.223044e-002, -1.306480e-002, -1.417176e-002, -1.547379e-002,
   -1.512333e-002, -1.392695e-002, -1.220049e-002, -1.004090e-002, -7.701016e-003, -5.350951e-003, -3.119363e-003, -1.152351e-003, 3.966756e-004,
   1.478055e-003,  2.412627e-003,  3.273140e-003,  4.024938e-003,  4.665786e-003,  5.210662e-003,  5.665931e-003,  6.055951e-003,  6.384196e-003,
   6.655974e-003,  6.895986e-003,  7.106323e-003,  7.308845e-003,  7.464070e-003,  7.542954e-003,  7.575636e-003,  7.564101e-003,  7.516342e-003,
   7.432449e-003,  7.308473e-003,  7.152465e-003,  6.978991e-003,  6.767019e-003,  6.484863e-003,  6.086415e-003,  5.582920e-003,  4.961080e-003,
   4.205145e-003,  3.051051e-003,  1.058027e-003,  -8.547807e-004, -1.790344e-003, -2.370950e-003, -2.877308e-003, -3.331628e-003, -3.712797e-003,
   -4.022733e-003, -4.260729e-003, -4.433593e-003, -4.553958e-003, -4.617323e-003, -4.628564e-003, -4.601372e-003, -4.525079e-003, -4.429871e-003,
   -4.314367e-003, -4.192840e-003, -4.077131e-003, -3.962830e-003, -3.862601e-003, -3.765819e-003, -3.694589e-003, -3.635897e-003, -3.601307e-003,
   -3.569543e-003, -3.541411e-003, -3.503562e-003, -3.455397e-003, -3.392916e-003, -3.323962e-003, -3.248919e-003, -3.182511e-003, -3.123196e-003,
   -3.099703e-003, -3.110497e-003, -3.181069e-003, -3.275963e-003, -3.396936e-003, -3.532542e-003, -3.672277e-003, -3.815999e-003, -3.889596e-003,
   -3.894224e-003, -3.822332e-003, -3.691888e-003, -3.518700e-003, -3.300783e-003, -3.046091e-003, -2.757129e-003, -2.444887e-003, -2.117053e-003,
   -1.773479e-003, -1.433625e-003, -1.099302e-003, -7.770000e-004, -4.867924e-004, -2.445902e-004, -7.630767e-005, 8.833000e-006,  7.241074e-005,
   1.344135e-004,  2.047474e-004,  2.854939e-004,  3.695760e-004,  4.624777e-004,  5.617435e-004,  6.533292e-004,  7.506734e-004,  8.589372e-004,
   9.746040e-004,  1.098536e-003,  1.233180e-003,  1.370130e-003,  1.507251e-003,  1.647509e-003,  1.770882e-003,  1.866994e-003,  1.953834e-003,
   2.026856e-003,  2.080389e-003,  2.127840e-003,  2.166153e-003,  2.192347e-003,  2.214957e-003,  2.237369e-003,  2.256441e-003,  2.270853e-003,
   2.295213e-003,  2.326118e-003,  2.356767e-003,  2.396810e-003,  2.444491e-003,  2.494487e-003,  2.547283e-003,  2.610851e-003,  2.676518e-003,
   2.740894e-003,  2.811856e-003,  2.886097e-003,  2.955066e-003,  3.018135e-003,  3.078140e-003,  3.130240e-003,  3.177071e-003,  3.218638e-003,
   3.254481e-003,  3.286119e-003,  3.315053e-003,  3.333162e-003,  3.335136e-003,  3.320827e-003,  3.292995e-003,  3.249629e-003,  3.198801e-003,
   3.141942e-003,  3.078167e-003,  3.008139e-003,  2.939895e-003,  2.869716e-003,  2.798165e-003,  2.729892e-003,  2.666711e-003,  2.606649e-003,
   2.545901e-003,  2.480095e-003,  2.407263e-003,  2.329681e-003,  2.255950e-003,  2.184141e-003,  2.116196e-003,  2.044853e-003,  1.970801e-003,
   1.890859e-003,  1.801009e-003,  1.684110e-003,  1.540080e-003,  1.372006e-003,  1.194146e-003,  1.000811e-003,  7.870687e-004,  5.588102e-004,
   3.167153e-004,  6.412076e-005,  -2.042919e-004, -4.845298e-004, -7.748176e-004, -1.070353e-003, -1.363857e-003, -1.661607e-003, -1.965822e-003,
   -2.275591e-003, -2.587123e-003, -2.900902e-003, -3.219790e-003, -3.539381e-003, -3.857585e-003, -4.170251e-003, -4.472438e-003, -4.757131e-003,
   -5.026918e-003, -5.277096e-003, -5.512495e-003, -5.738517e-003, -5.962576e-003, -6.185068e-003, -6.404012e-003, -6.621647e-003, -6.836731e-003,
   -7.038834e-003, -7.235891e-003, -7.423240e-003, -7.600055e-003, -7.769626e-003, -7.940192e-003, -8.116458e-003, -8.301150e-003, -8.491787e-003,
   -8.684934e-003, -8.859752e-003, -9.029611e-003, -9.189742e-003, -9.341093e-003, -9.484292e-003, -9.618507e-003, -9.745354e-003, -9.862700e-003,
   -9.971128e-003, -1.007033e-002, -1.014919e-002, -1.021342e-002, -1.026728e-002, -1.030661e-002, -1.033114e-002, -1.034255e-002, -1.033965e-002,
   -1.032033e-002, -1.028365e-002, -1.022803e-002, -1.014893e-002, -1.004039e-002, -9.909934e-003, -9.761733e-003, -9.606863e-003, -9.450117e-003,
   -9.295345e-003, -9.143226e-003, -8.993239e-003, -8.850340e-003, -8.707891e-003, -8.556398e-003, -8.406264e-003, -8.257916e-003, -8.111991e-003,
   -7.969978e-003, -7.836645e-003, -7.712076e-003, -7.591351e-003, -7.472876e-003, -7.354239e-003, -7.219640e-003, -7.082564e-003, -6.940301e-003,
   -6.791794e-003, -6.619163e-003, -6.410814e-003, -6.166066e-003, -5.885576e-003, -5.565149e-003, -5.206569e-003, -4.802120e-003, -4.364344e-003,
   -3.898753e-003, -3.408761e-003, -2.908409e-003, -2.403541e-003, -1.892103e-003, -1.374557e-003, -8.509448e-004, -3.253861e-004, 2.105536e-004,
   7.491376e-004,  1.278509e-003,  1.788779e-003,  2.279869e-003,  2.755211e-003,  3.221253e-003,  3.678170e-003,  4.129796e-003,  4.573108e-003,
   5.013763e-003,  5.454052e-003,  5.885033e-003,  6.308304e-003,  6.724194e-003,  7.131750e-003,  7.533505e-003,  7.927138e-003,  8.314160e-003,
   8.692192e-003,  9.061267e-003,  9.428853e-003,  9.786954e-003,  1.013314e-002,  1.046838e-002,  1.079260e-002,  1.110901e-002,  1.142016e-002,
   1.172804e-002,  1.203487e-002,  1.232962e-002,  1.261798e-002,  1.288854e-002,  1.313712e-002,  1.336320e-002,  1.356544e-002,  1.374656e-002,
   1.391929e-002,  1.409042e-002,  1.425882e-002,  1.442357e-002,  1.458734e-002,  1.474970e-002,  1.490055e-002,  1.503533e-002,  1.515102e-002,
   1.525213e-002,  1.534316e-002,  1.542383e-002,  1.549723e-002,  1.556430e-002,  1.562707e-002,  1.568857e-002,  1.574861e-002,  1.580736e-002,
   1.586792e-002,  1.593153e-002,  1.600000e-002,  1.607358e-002,  1.615429e-002,  1.624424e-002,  1.634407e-002,  1.645955e-002,  1.658548e-002,
   1.671757e-002,  1.684581e-002,  1.696048e-002,  1.705468e-002,  1.712895e-002,  1.718580e-002,  1.722492e-002,  1.724802e-002,  1.725705e-002,
   1.725352e-002,  1.724027e-002,  1.721765e-002,  1.718597e-002,  1.714919e-002,  1.710594e-002,  1.705622e-002,  1.697404e-002,  1.684391e-002,
   1.666913e-002,  1.644566e-002,  1.617152e-002,  1.584866e-002,  1.548343e-002,  1.507842e-002,  1.463441e-002,  1.415418e-002,  1.363896e-002,
   1.309270e-002,  1.251808e-002,  1.191517e-002,  1.128679e-002,  1.063423e-002,  9.958812e-003,  9.261276e-003,  8.545314e-003,  7.813906e-003,
   7.068469e-003,  6.313799e-003,  5.552226e-003,  4.784047e-003,  4.013348e-003,  3.241349e-003,  2.476287e-003,  1.720264e-003,  9.750474e-004,
   2.444405e-004,  -4.656470e-004, -1.156831e-003, -1.827323e-003, -2.471959e-003, -3.089240e-003, -3.675171e-003, -4.225426e-003, -4.739292e-003,
   -5.211057e-003, -5.642171e-003, -6.024289e-003, -6.356913e-003, -6.636672e-003, -6.861995e-003, -7.029255e-003, -7.135036e-003, -7.174809e-003,
   -7.160690e-003, -7.118426e-003, -7.050900e-003, -6.962384e-003, -6.848482e-003, -6.715869e-003, -6.570266e-003, -6.414751e-003, -6.246789e-003,
   -6.069580e-003, -5.882607e-003, -5.683664e-003, -5.479210e-003, -5.274834e-003, -5.067081e-003, -4.864037e-003, -4.666441e-003, -4.471345e-003,
   -4.276821e-003, -4.085980e-003, -3.898442e-003, -3.710466e-003, -3.521978e-003, -3.333253e-003, -3.143460e-003, -2.955023e-003, -2.763748e-003,
   -2.566963e-003, -2.361774e-003, -2.155293e-003, -1.951647e-003, -1.756880e-003, -1.576616e-003, -1.408484e-003, -1.250337e-003, -1.107480e-003,
   -9.904570e-004, -8.935136e-004, -8.218025e-004, -7.796171e-004, -7.697472e-004, -8.119122e-004, -9.368835e-004, -1.139844e-003, -1.413483e-003,
   -1.754786e-003, -2.158373e-003, -2.618482e-003, -3.138798e-003, -3.717561e-003, -4.349897e-003, -5.034746e-003, -5.768179e-003, -6.545524e-003,
   -7.364606e-003, -8.231856e-003, -9.140267e-003, -1.008919e-002, -1.107273e-002, -1.208841e-002, -1.313190e-002, -1.420299e-002, -1.530630e-002,
   -1.643387e-002, -1.758268e-002, -1.874789e-002, -1.992210e-002, -2.110670e-002, -2.230096e-002, -2.350307e-002, -2.471145e-002, -2.591927e-002,
   -2.712059e-002, -2.831095e-002, -2.948783e-002, -3.065368e-002, -3.180461e-002, -3.294179e-002, -3.405473e-002, -3.514112e-002, -3.620186e-002,
   -3.723925e-002, -3.825113e-002, -3.923299e-002, -4.018362e-002, -4.109978e-002, -4.197676e-002, -4.282013e-002, -4.362876e-002, -4.439862e-002,
   -4.513344e-002, -4.582962e-002, -4.648142e-002, -4.708788e-002, -4.764182e-002, -4.814823e-002, -4.859859e-002, -4.900013e-002, -4.935584e-002,
   -4.966339e-002, -4.992259e-002, -5.013327e-002, -5.029317e-002, -5.040240e-002, -5.045486e-002, -5.044740e-002, -5.037674e-002, -5.023967e-002,
   -5.004070e-002, -4.978462e-002, -4.947275e-002, -4.911440e-002, -4.861781e-002, -4.782472e-002, -4.674256e-002, -4.538863e-002, -4.377555e-002,
   -4.191599e-002, -3.982134e-002, -3.751253e-002, -3.502048e-002, -3.235309e-002, -2.952736e-002, -2.655978e-002, -2.345772e-002, -2.023432e-002,
   -1.690001e-002, -1.348255e-002, -9.991049e-003, -6.426447e-003, -2.815340e-003, 8.306865e-004,  4.497869e-003,  8.178001e-003,  1.185789e-002,
   1.552592e-002,  1.915924e-002,  2.274017e-002,  2.625087e-002,  2.967588e-002,  3.299736e-002,  3.618726e-002,  3.923067e-002,  4.211031e-002,
   4.481045e-002,  4.731890e-002,  4.961770e-002,  5.169624e-002,  5.353633e-002,  5.512204e-002,  5.643853e-002,  5.746098e-002,  5.831167e-002,
   5.908479e-002,  5.979136e-002,  6.042757e-002,  6.099349e-002,  6.149216e-002,  6.193154e-002,  6.230856e-002,  6.263745e-002,  6.290598e-002,
   6.310869e-002,  6.324621e-002,  6.333105e-002,  6.335752e-002,  6.333506e-002,  6.326651e-002,  6.315326e-002,  6.298552e-002,  6.278615e-002,
   6.253807e-002,  6.224730e-002,  6.192504e-002,  6.157565e-002,  6.119687e-002,  6.078473e-002,  6.033113e-002,  5.983083e-002,  5.927852e-002,
   5.868971e-002,  5.805212e-002,  5.736492e-002,  5.662728e-002,  5.584500e-002,  5.502872e-002,  5.417635e-002,  5.328846e-002,  5.234840e-002,
   5.136024e-002,  5.032991e-002,  4.926755e-002,  4.816927e-002,  4.703306e-002,  4.585954e-002,  4.465075e-002,  4.340807e-002,  4.214199e-002,
   4.085785e-002,  3.956025e-002,  3.824528e-002,  3.693187e-002,  3.560361e-002,  3.426674e-002,  3.291969e-002,  3.157632e-002,  3.022915e-002,
   2.887328e-002,  2.751569e-002,  2.615730e-002,  2.469161e-002,  2.301826e-002,  2.113143e-002,  1.904336e-002,  1.676286e-002,  1.430226e-002,
   1.168306e-002,  8.909044e-003,  5.992595e-003,  2.952766e-003,  -1.892900e-004, -3.397965e-003, -6.669562e-003, -9.999171e-003, -1.337929e-002,
   -1.679456e-002, -2.021883e-002, -2.363413e-002, -2.702580e-002, -3.037485e-002, -3.363979e-002, -3.678325e-002, -3.979290e-002, -4.266420e-002,
   -4.538687e-002, -4.796075e-002, -5.037204e-002, -5.260844e-002, -5.467233e-002, -5.653789e-002, -5.820016e-002, -5.964370e-002, -6.084748e-002,
   -6.181373e-002, -6.254969e-002, -6.304255e-002, -6.327373e-002, -6.324151e-002, -6.294476e-002, -6.236275e-002, -6.148544e-002, -6.033713e-002,
   -5.903884e-002, -5.765950e-002, -5.620022e-002, -5.467904e-002, -5.311244e-002, -5.150894e-002, -4.987509e-002, -4.819521e-002, -4.646704e-002,
   -4.470178e-002, -4.288423e-002, -4.103245e-002, -3.916343e-002, -3.727568e-002, -3.536237e-002, -3.342494e-002, -3.148087e-002, -2.953602e-002,
   -2.759655e-002, -2.566318e-002, -2.371155e-002, -2.174901e-002, -1.979182e-002, -1.786487e-002, -1.596224e-002, -1.409055e-002, -1.224699e-002,
   -1.043538e-002, -8.661397e-003, -6.916669e-003, -5.196874e-003, -3.504715e-003, -1.841873e-003, -1.780654e-004, 1.484192e-003,  3.149436e-003,
   4.808750e-003,  6.458432e-003,  8.106839e-003,  9.744319e-003,  1.137902e-002,  1.303264e-002,  1.466682e-002,  1.626450e-002,  1.783889e-002,
   1.937177e-002,  2.087280e-002,  2.235456e-002,  2.380537e-002,  2.521882e-002,  2.658731e-002,  2.797466e-002,  2.933828e-002,  3.067543e-002,
   3.187833e-002,  3.279689e-002,  3.344084e-002,  3.384055e-002,  3.401162e-002,  3.396640e-002,  3.370251e-002,  3.325991e-002,  3.261960e-002,
   3.181643e-002,  3.085165e-002,  2.973501e-002,  2.848709e-002,  2.710628e-002,  2.559623e-002,  2.396612e-002,  2.223702e-002,  2.045567e-002,
   1.863930e-002,  1.675435e-002,  1.480918e-002,  1.281351e-002,  1.080206e-002,  8.788696e-003,  6.768468e-003,  4.761420e-003,  2.791298e-003,
   8.870138e-004,  -8.944459e-004, -2.607997e-003, -4.247135e-003, -5.799043e-003, -7.232417e-003, -8.517655e-003, -9.649423e-003, -1.063188e-002,
   -1.143942e-002, -1.208886e-002, -1.248187e-002, -1.266355e-002, -1.263433e-002, -1.237607e-002, -1.195304e-002, -1.152056e-002, -1.109690e-002,
   -1.067519e-002, -1.024217e-002, -9.818682e-003, -9.357641e-003, -8.875726e-003, -8.413351e-003, -7.968957e-003, -7.538938e-003, -7.122375e-003,
   -6.714695e-003, -6.319160e-003, -5.932280e-003, -5.570293e-003, -5.172370e-003, -4.709242e-003, -4.245202e-003, -3.783897e-003, -3.341789e-003,
   -2.904934e-003, -2.482400e-003, -2.051428e-003, -1.613131e-003, -1.190421e-003, -7.410203e-004, -2.403449e-004, 2.371472e-004,  6.749396e-004,
   1.081014e-003,  1.440097e-003,  1.748999e-003,  1.999745e-003,  2.199480e-003,  2.360461e-003,  2.500574e-003,  2.727689e-003,  2.902678e-003,
   3.038703e-003,  3.130206e-003,  3.191180e-003,  3.235709e-003,  3.242823e-003,  3.214985e-003,  3.147778e-003,  3.043213e-003,  3.043040e-003,
   3.058252e-003,  3.027769e-003,  2.963041e-003,  2.873734e-003,  2.777619e-003,  2.659181e-003,  2.527951e-003,  2.379990e-003,  2.215818e-003,
   2.115075e-003,  2.041910e-003,  1.984158e-003,  1.926378e-003,  1.842009e-003,  1.720719e-003,  1.577646e-003,  1.416919e-003,  1.269385e-003,
   1.076693e-003,  9.256708e-004,  8.693585e-004,  7.933710e-004,  6.953306e-004,  5.967592e-004,  4.455451e-004,  2.500369e-004,  -3.055137e-006,
   -2.852052e-004, -5.961842e-004, -9.679909e-004, -1.192123e-003, -1.458065e-003, -1.772853e-003, -2.152422e-003, -2.549979e-003, -2.978306e-003,
   -3.459624e-003, -4.001965e-003, -4.573486e-003, -5.154011e-003, -5.569628e-003, -5.991373e-003, -6.475385e-003, -6.973923e-003, -7.456755e-003,
   -7.939632e-003, -8.485955e-003, -9.064276e-003, -9.641666e-003, -1.021734e-002, -1.072896e-002, -1.121748e-002, -1.174854e-002, -1.230922e-002,
   -1.287446e-002, -1.347310e-002, -1.410634e-002, -1.474239e-002, -1.537940e-002, -1.607671e-002, -1.669049e-002, -1.715158e-002, -1.760523e-002,
   -1.805979e-002, -1.850653e-002, -1.896897e-002, -1.947440e-002, -1.996283e-002, -2.044566e-002, -2.095126e-002, -2.141347e-002, -2.169484e-002,
   -2.197146e-002, -2.224554e-002, -2.261821e-002, -2.295843e-002, -2.327421e-002, -2.355856e-002, -2.384337e-002, -2.408142e-002, -2.435257e-002,
   -2.432310e-002, -2.429629e-002, -2.428195e-002, -2.431411e-002, -2.439305e-002, -2.442885e-002, -2.444895e-002, -2.451547e-002, -2.450285e-002,
   -2.444349e-002, -2.423158e-002, -2.387136e-002, -2.333306e-002, -2.262491e-002, -2.184613e-002, -2.092344e-002, -1.975534e-002, -1.849346e-002,
   -1.712376e-002, -1.562661e-002, -1.378032e-002, -1.169451e-002, -9.561633e-003, -7.294840e-003, -4.877750e-003, -2.331490e-003, 1.918740e-004,
   2.860863e-003,  5.597581e-003,  8.310346e-003,  1.115764e-002,  1.419641e-002,  1.715427e-002,  2.006114e-002,  2.316149e-002,  2.624645e-002,
   2.939548e-002,  3.258940e-002,  3.574167e-002,  3.885196e-002,  4.198922e-002,  4.531407e-002,  4.857910e-002,  5.187097e-002,  5.495274e-002,
   5.773757e-002,  6.027281e-002,  6.251270e-002,  6.440582e-002,  6.607591e-002,  6.746395e-002,  6.863296e-002,  6.951023e-002,  7.001863e-002,
   7.018182e-002,  6.992285e-002,  6.917695e-002,  6.813385e-002,  6.681020e-002,  6.546399e-002,  6.383476e-002,  6.208695e-002,  6.000727e-002,
   5.764712e-002,  5.486842e-002,  5.164122e-002,  4.821130e-002,  4.432303e-002,  4.041151e-002,  3.600239e-002,  3.132369e-002,  2.638080e-002,
   2.158386e-002,  1.661232e-002,  1.170591e-002,  6.543272e-003,  1.020782e-003,  -4.668697e-003, -1.063140e-002, -1.666677e-002, -2.298555e-002,
   -2.949187e-002, -3.568009e-002, -4.132885e-002, -4.648578e-002, -5.071933e-002, -5.385082e-002, -5.590550e-002, -5.723617e-002, -5.863943e-002,
   -6.092091e-002, -6.333213e-002, -6.650548e-002, -7.035511e-002, -7.383440e-002, -7.883410e-002, -8.527805e-002, -9.176060e-002, -9.663816e-002,
   -9.912976e-002, -9.575496e-002, -7.726779e-002, -6.869294e-002, -6.656362e-002, -6.449412e-002, -6.524034e-002, -6.933107e-002, -7.351112e-002,
   -7.429125e-002, -7.030367e-002, -6.018157e-002, -4.679271e-002, 1.422884e-001,  1.575366e-001,  1.583155e-001,  1.564559e-001,  1.530732e-001,
   1.468045e-001,  1.367844e-001,  1.231302e-001,  1.067971e-001,  8.476677e-002,  -1.448345e-001, -4.031660e-003, -4.795623e-002, -7.588450e-002,
   -9.669753e-002, -1.090431e-001, 5.082690e-003,  8.394798e-003,  7.591663e-003,  4.277548e-003,  0.000000e+000},
  {0.000000e+000,  -4.713623e-003, -8.461471e-003, -1.131121e-002, -1.352718e-002, -1.522101e-002, -1.646142e-002, -1.660101e-002, -1.594242e-002,
   -1.616667e-002, -1.698847e-002, -1.865810e-002, -2.058347e-002, -2.252969e-002, -2.438746e-002, -2.604271e-002, -2.743505e-002, -2.848094e-002,
   -2.912798e-002, -2.957346e-002, -2.986101e-002, -3.013659e-002, -3.037188e-002, -3.045830e-002, -3.039691e-002, -3.020734e-002, -2.989494e-002,
   -2.946942e-002, -2.894221e-002, -2.834007e-002, -2.765181e-002, -2.693955e-002, -2.629918e-002, -2.558006e-002, -2.478699e-002, -2.391490e-002,
   -2.297952e-002, -2.198773e-002, -2.094183e-002, -1.986793e-002, -1.874830e-002, -1.755636e-002, -1.642267e-002, -1.514948e-002, -1.370367e-002,
   -1.205764e-002, -9.795483e-003, -6.185665e-003, -2.688713e-003, -7.178430e-004, 7.077328e-004,  2.041205e-003,  3.132938e-003,  4.113482e-003,
   4.994092e-003,  5.801635e-003,  6.540405e-003,  7.212934e-003,  7.834690e-003,  8.406193e-003,  8.938129e-003,  9.441840e-003,  9.823566e-003,
   1.012927e-002,  1.043522e-002,  1.075410e-002,  1.109851e-002,  1.146882e-002,  1.188344e-002,  1.233604e-002,  1.283849e-002,  1.339243e-002,
   1.390364e-002,  1.434256e-002,  1.478471e-002,  1.524706e-002,  1.572374e-002,  1.620846e-002,  1.669868e-002,  1.719232e-002,  1.768109e-002,
   1.816622e-002,  1.864482e-002,  1.900531e-002,  1.937295e-002,  1.973439e-002,  2.009582e-002,  2.045399e-002,  2.079784e-002,  2.109825e-002,
   2.132762e-002,  2.151008e-002,  2.163928e-002,  2.160883e-002,  2.153013e-002,  2.142231e-002,  2.129885e-002,  2.115756e-002,  2.100997e-002,
   2.087045e-002,  2.073200e-002,  2.060230e-002,  2.049016e-002,  2.030815e-002,  2.013726e-002,  2.001514e-002,  1.995525e-002,  1.993193e-002,
   1.991291e-002,  1.991085e-002,  1.991890e-002,  1.994203e-002,  1.997453e-002,  1.996590e-002,  1.988990e-002,  1.981695e-002,  1.975862e-002,
   1.970583e-002,  1.965604e-002,  1.961394e-002,  1.956972e-002,  1.952275e-002,  1.947662e-002,  1.938495e-002,  1.918864e-002,  1.898158e-002,
   1.876022e-002,  1.852217e-002,  1.828555e-002,  1.805056e-002,  1.781089e-002,  1.757448e-002,  1.734555e-002,  1.710835e-002,  1.677672e-002,
   1.645448e-002,  1.614119e-002,  1.582916e-002,  1.552408e-002,  1.522972e-002,  1.494276e-002,  1.465956e-002,  1.439069e-002,  1.412751e-002,
   1.380212e-002,  1.346673e-002,  1.314077e-002,  1.281616e-002,  1.249071e-002,  1.216388e-002,  1.183735e-002,  1.151084e-002,  1.118527e-002,
   1.086246e-002,  1.050016e-002,  1.010668e-002,  9.706162e-003,  9.311423e-003,  8.921922e-003,  8.538639e-003,  8.156564e-003,  7.783310e-003,
   7.418576e-003,  7.065247e-003,  6.699417e-003,  6.307754e-003,  5.921926e-003,  5.549213e-003,  5.195271e-003,  4.858417e-003,  4.536362e-003,
   4.225104e-003,  3.918104e-003,  3.615698e-003,  3.316930e-003,  2.985200e-003,  2.666817e-003,  2.365532e-003,  2.073442e-003,  1.790043e-003,
   1.513109e-003,  1.244039e-003,  9.693134e-004,  6.904532e-004,  4.080493e-004,  1.031503e-004,  -2.017061e-004, -5.055182e-004, -8.028671e-004,
   -1.086190e-003, -1.354927e-003, -1.620734e-003, -1.879273e-003, -2.124027e-003, -2.359218e-003, -2.595341e-003, -2.832047e-003, -3.054551e-003,
   -3.269015e-003, -3.472344e-003, -3.664995e-003, -3.851323e-003, -4.032000e-003, -4.201020e-003, -4.358556e-003, -4.510027e-003, -4.659001e-003,
   -4.799358e-003, -4.925300e-003, -5.042488e-003, -5.153462e-003, -5.266591e-003, -5.385103e-003, -5.506836e-003, -5.629359e-003, -5.750630e-003,
   -5.875117e-003, -5.994131e-003, -6.109630e-003, -6.229002e-003, -6.355586e-003, -6.495816e-003, -6.654872e-003, -6.835951e-003, -7.036619e-003,
   -7.252827e-003, -7.481668e-003, -7.720512e-003, -7.964326e-003, -8.215241e-003, -8.473052e-003, -8.735194e-003, -9.005095e-003, -9.281891e-003,
   -9.566089e-003, -9.854700e-003, -1.014099e-002, -1.043066e-002, -1.072766e-002, -1.103076e-002, -1.133607e-002, -1.163864e-002, -1.194147e-002,
   -1.223991e-002, -1.253343e-002, -1.282155e-002, -1.309455e-002, -1.334777e-002, -1.358747e-002, -1.381884e-002, -1.404280e-002, -1.426584e-002,
   -1.448941e-002, -1.471681e-002, -1.495310e-002, -1.519490e-002, -1.543585e-002, -1.567320e-002, -1.591181e-002, -1.615343e-002, -1.640047e-002,
   -1.665469e-002, -1.691570e-002, -1.718174e-002, -1.745506e-002, -1.773033e-002, -1.800739e-002, -1.826983e-002, -1.853201e-002, -1.879460e-002,
   -1.905230e-002, -1.931746e-002, -1.959255e-002, -1.987790e-002, -2.016933e-002, -2.046161e-002, -2.075402e-002, -2.103312e-002, -2.130641e-002,
   -2.157721e-002, -2.184507e-002, -2.209356e-002, -2.231169e-002, -2.249859e-002, -2.265625e-002, -2.278740e-002, -2.288986e-002, -2.295752e-002,
   -2.299217e-002, -2.300748e-002, -2.301311e-002, -2.300829e-002, -2.300031e-002, -2.298415e-002, -2.295754e-002, -2.292168e-002, -2.287775e-002,
   -2.281715e-002, -2.273690e-002, -2.264308e-002, -2.253608e-002, -2.241274e-002, -2.227574e-002, -2.212487e-002, -2.195930e-002, -2.177856e-002,
   -2.158219e-002, -2.137023e-002, -2.114137e-002, -2.089585e-002, -2.063841e-002, -2.036878e-002, -2.008531e-002, -1.979044e-002, -1.948031e-002,
   -1.915033e-002, -1.880193e-002, -1.843711e-002, -1.806277e-002, -1.768532e-002, -1.730534e-002, -1.692645e-002, -1.654619e-002, -1.616543e-002,
   -1.579351e-002, -1.542930e-002, -1.508147e-002, -1.475115e-002, -1.444791e-002, -1.417352e-002, -1.392940e-002, -1.370197e-002, -1.348476e-002,
   -1.327603e-002, -1.307339e-002, -1.287541e-002, -1.268246e-002, -1.249538e-002, -1.231546e-002, -1.214748e-002, -1.198210e-002, -1.181727e-002,
   -1.165219e-002, -1.148354e-002, -1.131155e-002, -1.113299e-002, -1.094408e-002, -1.074492e-002, -1.053940e-002, -1.033945e-002, -1.012520e-002,
   -9.900338e-003, -9.673028e-003, -9.455389e-003, -9.249096e-003, -9.050679e-003, -8.863586e-003, -8.685030e-003, -8.517968e-003, -8.380234e-003,
   -8.248764e-003, -8.123202e-003, -8.001716e-003, -7.882832e-003, -7.762558e-003, -7.640104e-003, -7.519018e-003, -7.371249e-003, -7.183817e-003,
   -6.977688e-003, -6.738099e-003, -6.457487e-003, -6.141583e-003, -5.786206e-003, -5.390729e-003, -4.956735e-003, -4.487566e-003, -3.985677e-003,
   -3.452805e-003, -2.906289e-003, -2.343574e-003, -1.753622e-003, -1.139323e-003, -4.978658e-004, 1.694942e-004,  8.523953e-004,  1.554296e-003,
   2.271666e-003,  2.993467e-003,  3.698789e-003,  4.364003e-003,  5.013530e-003,  5.654338e-003,  6.287922e-003,  6.907636e-003,  7.513205e-003,
   8.101611e-003,  8.674067e-003,  9.225401e-003,  9.752114e-003,  1.021955e-002,  1.066488e-002,  1.109314e-002,  1.149512e-002,  1.186972e-002,
   1.222058e-002,  1.254076e-002,  1.283118e-002,  1.308874e-002,  1.331122e-002,  1.347140e-002,  1.359262e-002,  1.368141e-002,  1.373196e-002,
   1.375349e-002,  1.376232e-002,  1.375840e-002,  1.374708e-002,  1.372930e-002,  1.370029e-002,  1.364036e-002,  1.355215e-002,  1.344941e-002,
   1.333411e-002,  1.320734e-002,  1.307482e-002,  1.293099e-002,  1.277531e-002,  1.261562e-002,  1.244437e-002,  1.224801e-002,  1.202732e-002,
   1.180179e-002,  1.157480e-002,  1.135231e-002,  1.112988e-002,  1.090907e-002,  1.069138e-002,  1.048235e-002,  1.028649e-002,  1.009986e-002,
   9.894653e-003,  9.711192e-003,  9.543640e-003,  9.389412e-003,  9.244944e-003,  9.112489e-003,  8.989307e-003,  8.880592e-003,  8.796610e-003,
   8.749073e-003,  8.705311e-003,  8.693531e-003,  8.712899e-003,  8.758798e-003,  8.834276e-003,  8.964297e-003,  9.146580e-003,  9.382400e-003,
   9.676461e-003,  1.003482e-002,  1.043368e-002,  1.087360e-002,  1.136367e-002,  1.190836e-002,  1.249545e-002,  1.312966e-002,  1.381527e-002,
   1.455099e-002,  1.532904e-002,  1.615067e-002,  1.700602e-002,  1.787936e-002,  1.878769e-002,  1.972765e-002,  2.069279e-002,  2.167062e-002,
   2.267133e-002,  2.368609e-002,  2.471565e-002,  2.576789e-002,  2.683141e-002,  2.788334e-002,  2.893690e-002,  2.999677e-002,  3.105740e-002,
   3.211713e-002,  3.318095e-002,  3.424568e-002,  3.529364e-002,  3.632682e-002,  3.735170e-002,  3.835333e-002,  3.933486e-002,  4.029688e-002,
   4.123149e-002,  4.213350e-002,  4.299802e-002,  4.382735e-002,  4.462050e-002,  4.538044e-002,  4.608513e-002,  4.673659e-002,  4.732998e-002,
   4.785523e-002,  4.831957e-002,  4.872167e-002,  4.905536e-002,  4.931550e-002,  4.949831e-002,  4.960858e-002,  4.965961e-002,  4.966050e-002,
   4.962326e-002,  4.953502e-002,  4.939799e-002,  4.920892e-002,  4.897286e-002,  4.869499e-002,  4.837725e-002,  4.802540e-002,  4.764011e-002,
   4.722278e-002,  4.677275e-002,  4.628071e-002,  4.573608e-002,  4.507303e-002,  4.418428e-002,  4.308285e-002,  4.177172e-002,  4.027178e-002,
   3.859858e-002,  3.675521e-002,  3.477892e-002,  3.264901e-002,  3.038526e-002,  2.798872e-002,  2.546935e-002,  2.285136e-002,  2.015142e-002,
   1.738808e-002,  1.455719e-002,  1.167716e-002,  8.779001e-003,  5.854273e-003,  2.920392e-003,  -1.340298e-005, -2.949905e-003, -5.861264e-003,
   -8.738511e-003, -1.158059e-002, -1.437030e-002, -1.709062e-002, -1.971315e-002, -2.223866e-002, -2.467531e-002, -2.699992e-002, -2.921507e-002,
   -3.129680e-002, -3.323237e-002, -3.501967e-002, -3.666468e-002, -3.816118e-002, -3.947889e-002, -4.059011e-002, -4.151853e-002, -4.235526e-002,
   -4.315371e-002, -4.389491e-002, -4.459013e-002, -4.524625e-002, -4.585662e-002, -4.641378e-002, -4.692591e-002, -4.735978e-002, -4.775180e-002,
   -4.811260e-002, -4.844398e-002, -4.872604e-002, -4.896913e-002, -4.917029e-002, -4.932932e-002, -4.944855e-002, -4.954092e-002, -4.955247e-002,
   -4.951866e-002, -4.944649e-002, -4.932636e-002, -4.915154e-002, -4.892310e-002, -4.865897e-002, -4.836382e-002, -4.804132e-002, -4.769181e-002,
   -4.729224e-002, -4.685501e-002, -4.639413e-002, -4.590446e-002, -4.539431e-002, -4.485351e-002, -4.428826e-002, -4.371194e-002, -4.311785e-002,
   -4.251433e-002, -4.187123e-002, -4.118875e-002, -4.048474e-002, -3.976142e-002, -3.902561e-002, -3.828870e-002, -3.753574e-002, -3.676480e-002,
   -3.596189e-002, -3.514502e-002, -3.429981e-002, -3.340030e-002, -3.248095e-002, -3.154216e-002, -3.059431e-002, -2.962296e-002, -2.863126e-002,
   -2.762846e-002, -2.661056e-002, -2.559059e-002, -2.446012e-002, -2.314566e-002, -2.169830e-002, -2.012766e-002, -1.844914e-002, -1.668148e-002,
   -1.481463e-002, -1.286641e-002, -1.085741e-002, -8.800850e-003, -6.698471e-003, -4.525604e-003, -2.318420e-003, -7.741094e-005, 2.179343e-003,
   4.426094e-003,  6.666810e-003,  8.899098e-003,  1.112830e-002,  1.331237e-002,  1.541396e-002,  1.742510e-002,  1.933557e-002,  2.114899e-002,
   2.284487e-002,  2.441157e-002,  2.586077e-002,  2.718179e-002,  2.836234e-002,  2.939914e-002,  3.029158e-002,  3.104601e-002,  3.165168e-002,
   3.210292e-002,  3.238983e-002,  3.250718e-002,  3.244487e-002,  3.219354e-002,  3.175104e-002,  3.112146e-002,  3.027953e-002,  2.925394e-002,
   2.817499e-002,  2.702899e-002,  2.582779e-002,  2.456803e-002,  2.323451e-002,  2.184043e-002,  2.038424e-002,  1.888647e-002,  1.734005e-002,
   1.576075e-002,  1.414830e-002,  1.251981e-002,  1.085497e-002,  9.162951e-003,  7.468766e-003,  5.781762e-003,  4.082016e-003,  2.368757e-003,
   6.386597e-004,  -1.085542e-003, -2.791414e-003, -4.477473e-003, -6.138893e-003, -7.786760e-003, -9.407374e-003, -1.099547e-002, -1.255307e-002,
   -1.408202e-002, -1.556607e-002, -1.698193e-002, -1.834070e-002, -1.964440e-002, -2.090390e-002, -2.215728e-002, -2.339410e-002, -2.461931e-002,
   -2.583650e-002, -2.704105e-002, -2.821814e-002, -2.938490e-002, -3.054566e-002, -3.168128e-002, -3.280079e-002, -3.390817e-002, -3.497384e-002,
   -3.603030e-002, -3.704888e-002, -3.804474e-002, -3.900092e-002, -3.992377e-002, -4.081448e-002, -4.166368e-002, -4.246471e-002, -4.320552e-002,
   -4.371969e-002, -4.378821e-002, -4.343905e-002, -4.269852e-002, -4.157231e-002, -4.006949e-002, -3.824511e-002, -3.612176e-002, -3.372429e-002,
   -3.103154e-002, -2.810399e-002, -2.495196e-002, -2.158720e-002, -1.807852e-002, -1.440622e-002, -1.061231e-002, -6.722151e-003, -2.719380e-003,
   1.357687e-003,  5.475065e-003,  9.611192e-003,  1.373340e-002,  1.783313e-002,  2.189552e-002,  2.588848e-002,  2.981978e-002,  3.365138e-002,
   3.737157e-002,  4.098652e-002,  4.442521e-002,  4.766748e-002,  5.068531e-002,  5.349434e-002,  5.607558e-002,  5.840248e-002,  6.043361e-002,
   6.216915e-002,  6.354925e-002,  6.461177e-002,  6.529436e-002,  6.556189e-002,  6.542974e-002,  6.492639e-002,  6.432537e-002,  6.365076e-002,
   6.290768e-002,  6.212321e-002,  6.125987e-002,  6.037955e-002,  5.947797e-002,  5.849970e-002,  5.745104e-002,  5.633184e-002,  5.516051e-002,
   5.391280e-002,  5.261984e-002,  5.128178e-002,  4.989437e-002,  4.852980e-002,  4.718461e-002,  4.581112e-002,  4.439685e-002,  4.292200e-002,
   4.140369e-002,  3.984047e-002,  3.827082e-002,  3.667324e-002,  3.502883e-002,  3.342208e-002,  3.190241e-002,  3.033201e-002,  2.872386e-002,
   2.713366e-002,  2.550315e-002,  2.381814e-002,  2.208133e-002,  2.030270e-002,  1.851927e-002,  1.676667e-002,  1.521299e-002,  1.360083e-002,
   1.198033e-002,  1.032670e-002,  8.637095e-003,  6.950588e-003,  5.233412e-003,  3.488609e-003,  1.743776e-003,  -4.745230e-005, -1.602607e-003,
   -3.111694e-003, -4.643086e-003, -6.211488e-003, -7.808966e-003, -9.413800e-003, -1.101909e-002, -1.261480e-002, -1.423759e-002, -1.587844e-002,
   -1.730359e-002, -1.861370e-002, -1.990528e-002, -2.117223e-002, -2.244167e-002, -2.376683e-002, -2.510206e-002, -2.644421e-002, -2.774308e-002,
   -2.908395e-002, -3.026829e-002, -3.119018e-002, -3.209791e-002, -3.302699e-002, -3.392057e-002, -3.482963e-002, -3.575647e-002, -3.668427e-002,
   -3.760748e-002, -3.850449e-002, -3.937009e-002, -3.979700e-002, -4.021182e-002, -4.061585e-002, -4.104901e-002, -4.144667e-002, -4.183181e-002,
   -4.226113e-002, -4.269487e-002, -4.312297e-002, -4.351950e-002, -4.338229e-002, -4.319939e-002, -4.303924e-002, -4.282204e-002, -4.256248e-002,
   -4.226691e-002, -4.198461e-002, -4.168752e-002, -4.139502e-002, -4.106155e-002, -4.034006e-002, -3.943272e-002, -3.852165e-002, -3.758874e-002,
   -3.668377e-002, -3.584676e-002, -3.506036e-002, -3.429806e-002, -3.352810e-002, -3.282830e-002, -3.185844e-002, -3.050199e-002, -2.919978e-002,
   -2.792364e-002, -2.665707e-002, -2.541197e-002, -2.425181e-002, -2.311851e-002, -2.200266e-002, -2.093763e-002, -1.977861e-002, -1.814129e-002,
   -1.655312e-002, -1.499241e-002, -1.352224e-002, -1.208473e-002, -1.065415e-002, -9.214675e-003, -7.812041e-003, -6.484053e-003, -5.197964e-003,
   -3.170371e-003, -1.233728e-003, 6.316442e-004,  2.374450e-003,  4.053007e-003,  5.738868e-003,  7.392482e-003,  8.886661e-003,  1.040991e-002,
   1.189278e-002,  1.376890e-002,  1.582702e-002,  1.765333e-002,  1.926291e-002,  2.058458e-002,  2.175448e-002,  2.283450e-002,  2.373517e-002,
   2.446281e-002,  2.495359e-002,  2.573104e-002,  2.660638e-002,  2.726524e-002,  2.779764e-002,  2.820041e-002,  2.851658e-002,  2.867275e-002,
   2.873865e-002,  2.866095e-002,  2.839745e-002,  2.810428e-002,  2.790687e-002,  2.741684e-002,  2.666144e-002,  2.591947e-002,  2.501657e-002,
   2.400407e-002,  2.292073e-002,  2.172963e-002,  2.044169e-002,  1.904815e-002,  1.767621e-002,  1.622684e-002,  1.489903e-002,  1.385920e-002,
   1.309787e-002,  1.273786e-002,  1.257725e-002,  1.256473e-002,  1.292620e-002,  1.355177e-002,  1.421233e-002,  1.500685e-002,  1.584864e-002,
   1.680606e-002,  1.778773e-002,  1.883422e-002,  1.992003e-002,  2.112893e-002,  2.283663e-002,  2.460697e-002,  2.622387e-002,  2.758451e-002,
   2.901900e-002,  3.029680e-002,  3.132349e-002,  3.256750e-002,  3.352167e-002,  3.449371e-002,  3.506972e-002,  3.527533e-002,  3.481014e-002,
   3.385279e-002,  3.268399e-002,  3.163099e-002,  3.023607e-002,  2.808737e-002,  2.560235e-002,  2.279149e-002,  1.988521e-002,  1.645659e-002,
   1.234501e-002,  6.662850e-003,  1.429498e-003,  -3.509806e-003, -7.708264e-003, -1.068938e-002, -1.300923e-002, -1.493199e-002, -1.717973e-002,
   -2.077967e-002, -2.471463e-002, -3.180092e-002, -3.965489e-002, -4.678590e-002, -5.541211e-002, -6.553649e-002, -7.577997e-002, -8.439822e-002,
   -9.013586e-002, -8.907055e-002, -6.985264e-002, -6.482686e-002, -6.850541e-002, -7.163153e-002, -7.757975e-002, -8.642750e-002, -9.521655e-002,
   -1.002562e-001, -9.983558e-002, -9.283261e-002, -8.142507e-002, 1.359803e-001,  1.456601e-001,  1.393731e-001,  1.315151e-001,  1.222863e-001,
   1.081791e-001,  8.908593e-002,  6.564607e-002,  3.880305e-002,  8.329103e-003,  -1.631899e-001, 4.213222e-002,  -8.431494e-003, -5.309251e-002,
   -9.238936e-002, -1.202449e-001, 1.408189e-001,  1.287963e-001,  9.699595e-002,  5.427525e-002,  0.000000e+000},
  {0.000000e+000,  -6.693485e-003, -1.294773e-002, -1.814577e-002, -2.256261e-002, -2.634021e-002, -2.952633e-002, -3.217320e-002, -3.421927e-002,
   -3.426096e-002, -3.340300e-002, -3.205595e-002, -3.043553e-002, -2.864168e-002, -2.680805e-002, -2.503563e-002, -2.349020e-002, -2.230590e-002,
   -2.154552e-002, -2.087697e-002, -2.026709e-002, -1.967836e-002, -1.909192e-002, -1.851375e-002, -1.793373e-002, -1.736241e-002, -1.680028e-002,
   -1.622133e-002, -1.565219e-002, -1.506597e-002, -1.446187e-002, -1.385450e-002, -1.326067e-002, -1.265091e-002, -1.202754e-002, -1.138099e-002,
   -1.073003e-002, -1.007086e-002, -9.388444e-003, -8.668834e-003, -7.917089e-003, -7.153140e-003, -6.449564e-003, -5.780813e-003, -5.133422e-003,
   -4.538399e-003, -4.135674e-003, -4.182686e-003, -4.214046e-003, -3.738145e-003, -3.101879e-003, -2.436709e-003, -1.869963e-003, -1.300673e-003,
   -7.397106e-004, -1.519417e-004, 4.244970e-004,  1.011232e-003,  1.610644e-003,  2.188950e-003,  2.781288e-003,  3.353420e-003,  3.866476e-003,
   4.332129e-003,  4.769868e-003,  5.182462e-003,  5.556861e-003,  5.912080e-003,  6.216131e-003,  6.504827e-003,  6.745843e-003,  6.961166e-003,
   7.109640e-003,  7.179905e-003,  7.215556e-003,  7.231026e-003,  7.238283e-003,  7.207275e-003,  7.180739e-003,  7.203119e-003,  7.277554e-003,
   7.438674e-003,  7.700950e-003,  7.986767e-003,  8.353675e-003,  8.811949e-003,  9.369863e-003,  9.998604e-003,  1.071346e-002,  1.156391e-002,
   1.254112e-002,  1.363230e-002,  1.481153e-002,  1.600154e-002,  1.722121e-002,  1.847426e-002,  1.975367e-002,  2.102355e-002,  2.228654e-002,
   2.350206e-002,  2.467333e-002,  2.576514e-002,  2.676642e-002,  2.763008e-002,  2.837490e-002,  2.900262e-002,  2.951695e-002,  2.995902e-002,
   3.034449e-002,  3.067492e-002,  3.090827e-002,  3.109544e-002,  3.122809e-002,  3.128815e-002,  3.128090e-002,  3.122068e-002,  3.111723e-002,
   3.097060e-002,  3.076822e-002,  3.050650e-002,  3.021419e-002,  2.990161e-002,  2.957176e-002,  2.925286e-002,  2.894738e-002,  2.866404e-002,
   2.842325e-002,  2.819935e-002,  2.796000e-002,  2.771697e-002,  2.747279e-002,  2.721136e-002,  2.694066e-002,  2.663635e-002,  2.630772e-002,
   2.594561e-002,  2.555494e-002,  2.514794e-002,  2.468882e-002,  2.418716e-002,  2.365983e-002,  2.310497e-002,  2.250999e-002,  2.188728e-002,
   2.125951e-002,  2.060970e-002,  1.994304e-002,  1.927778e-002,  1.862575e-002,  1.797199e-002,  1.732854e-002,  1.669014e-002,  1.605846e-002,
   1.543219e-002,  1.481900e-002,  1.422666e-002,  1.365648e-002,  1.309630e-002,  1.254524e-002,  1.199264e-002,  1.143998e-002,  1.087712e-002,
   1.030404e-002,  9.715979e-003,  9.128826e-003,  8.541857e-003,  7.915682e-003,  7.256074e-003,  6.560548e-003,  5.817272e-003,  5.030207e-003,
   4.211878e-003,  3.364925e-003,  2.509462e-003,  1.647285e-003,  8.119442e-004,  -5.402251e-005, -9.392538e-004, -1.845450e-003, -2.778769e-003,
   -3.724100e-003, -4.646999e-003, -5.515035e-003, -6.331723e-003, -7.093569e-003, -7.764387e-003, -8.390977e-003, -8.982185e-003, -9.544656e-003,
   -1.007692e-002, -1.058629e-002, -1.107654e-002, -1.153931e-002, -1.198036e-002, -1.241179e-002, -1.279401e-002, -1.314022e-002, -1.346548e-002,
   -1.379127e-002, -1.411480e-002, -1.443119e-002, -1.473808e-002, -1.503863e-002, -1.532941e-002, -1.562005e-002, -1.589084e-002, -1.614571e-002,
   -1.643526e-002, -1.676443e-002, -1.711711e-002, -1.748646e-002, -1.785341e-002, -1.821472e-002, -1.855724e-002, -1.888808e-002, -1.921648e-002,
   -1.949293e-002, -1.978350e-002, -2.008587e-002, -2.039188e-002, -2.070065e-002, -2.099399e-002, -2.124832e-002, -2.145993e-002, -2.163708e-002,
   -2.178363e-002, -2.185332e-002, -2.191208e-002, -2.197305e-002, -2.203925e-002, -2.210688e-002, -2.216662e-002, -2.223017e-002, -2.229619e-002,
   -2.237077e-002, -2.244720e-002, -2.246909e-002, -2.247184e-002, -2.248659e-002, -2.252188e-002, -2.258084e-002, -2.265803e-002, -2.275656e-002,
   -2.287641e-002, -2.302607e-002, -2.321385e-002, -2.339214e-002, -2.357494e-002, -2.381229e-002, -2.409274e-002, -2.439379e-002, -2.468684e-002,
   -2.496256e-002, -2.522243e-002, -2.546393e-002, -2.567950e-002, -2.585027e-002, -2.593755e-002, -2.601518e-002, -2.607444e-002, -2.611492e-002,
   -2.613388e-002, -2.611784e-002, -2.605962e-002, -2.598242e-002, -2.588476e-002, -2.578429e-002, -2.558481e-002, -2.538536e-002, -2.518970e-002,
   -2.499249e-002, -2.478886e-002, -2.456887e-002, -2.434148e-002, -2.411501e-002, -2.389855e-002, -2.369737e-002, -2.343449e-002, -2.315804e-002,
   -2.288578e-002, -2.261848e-002, -2.236259e-002, -2.212186e-002, -2.189675e-002, -2.169800e-002, -2.152452e-002, -2.137112e-002, -2.117956e-002,
   -2.095622e-002, -2.072166e-002, -2.044726e-002, -2.012801e-002, -1.978345e-002, -1.941739e-002, -1.903633e-002, -1.864595e-002, -1.824437e-002,
   -1.781227e-002, -1.731162e-002, -1.680984e-002, -1.631170e-002, -1.582071e-002, -1.534803e-002, -1.489623e-002, -1.446814e-002, -1.406447e-002,
   -1.368750e-002, -1.332438e-002, -1.289673e-002, -1.249344e-002, -1.211623e-002, -1.176388e-002, -1.144329e-002, -1.116648e-002, -1.094638e-002,
   -1.078607e-002, -1.069276e-002, -1.064457e-002, -1.054423e-002, -1.045869e-002, -1.039783e-002, -1.035797e-002, -1.034037e-002, -1.034271e-002,
   -1.036491e-002, -1.041810e-002, -1.049191e-002, -1.058207e-002, -1.061079e-002, -1.059246e-002, -1.054362e-002, -1.047493e-002, -1.038423e-002,
   -1.028991e-002, -1.020030e-002, -1.012203e-002, -1.004888e-002, -9.986849e-003, -9.898462e-003, -9.761454e-003, -9.643756e-003, -9.561119e-003,
   -9.510934e-003, -9.497622e-003, -9.530261e-003, -9.597066e-003, -9.708153e-003, -9.865028e-003, -1.005742e-002, -1.021501e-002, -1.041573e-002,
   -1.064656e-002, -1.087350e-002, -1.107320e-002, -1.122605e-002, -1.131998e-002, -1.136358e-002, -1.135903e-002, -1.130991e-002, -1.110936e-002,
   -1.086190e-002, -1.058158e-002, -1.027354e-002, -9.938190e-003, -9.578338e-003, -9.196867e-003, -8.797478e-003, -8.350004e-003, -7.848842e-003,
   -7.205530e-003, -6.480771e-003, -5.723023e-003, -4.925750e-003, -4.092231e-003, -3.232676e-003, -2.358117e-003, -1.463165e-003, -5.547719e-004,
   3.596005e-004,  1.341049e-003,  2.392029e-003,  3.455207e-003,  4.533609e-003,  5.616888e-003,  6.704661e-003,  7.795771e-003,  8.885145e-003,
   9.961922e-003,  1.104659e-002,  1.217140e-002,  1.339734e-002,  1.463204e-002,  1.588551e-002,  1.713527e-002,  1.837039e-002,  1.959724e-002,
   2.080418e-002,  2.198571e-002,  2.314644e-002,  2.428758e-002,  2.550195e-002,  2.668274e-002,  2.783431e-002,  2.894100e-002,  2.999709e-002,
   3.099952e-002,  3.193879e-002,  3.281240e-002,  3.361305e-002,  3.433498e-002,  3.505910e-002,  3.571928e-002,  3.629826e-002,  3.677535e-002,
   3.715820e-002,  3.748671e-002,  3.775406e-002,  3.797455e-002,  3.815082e-002,  3.828028e-002,  3.843320e-002,  3.861411e-002,  3.876839e-002,
   3.889820e-002,  3.900629e-002,  3.908488e-002,  3.913562e-002,  3.917206e-002,  3.919556e-002,  3.921333e-002,  3.924672e-002,  3.934289e-002,
   3.941994e-002,  3.948043e-002,  3.952227e-002,  3.952480e-002,  3.949563e-002,  3.942645e-002,  3.931440e-002,  3.916330e-002,  3.896279e-002,
   3.877358e-002,  3.851000e-002,  3.818189e-002,  3.781467e-002,  3.740781e-002,  3.696524e-002,  3.649172e-002,  3.598600e-002,  3.542723e-002,
   3.480358e-002,  3.417948e-002,  3.350221e-002,  3.276813e-002,  3.199495e-002,  3.121736e-002,  3.045231e-002,  2.968739e-002,  2.892140e-002,
   2.813863e-002,  2.734835e-002,  2.658640e-002,  2.582387e-002,  2.504896e-002,  2.425499e-002,  2.343191e-002,  2.258856e-002,  2.171204e-002,
   2.081311e-002,  1.990436e-002,  1.898855e-002,  1.809123e-002,  1.720834e-002,  1.631150e-002,  1.538872e-002,  1.445443e-002,  1.350406e-002,
   1.255481e-002,  1.159189e-002,  1.061867e-002,  9.640475e-003,  8.671699e-003,  7.727532e-003,  6.784858e-003,  5.845462e-003,  4.899365e-003,
   3.943273e-003,  2.961435e-003,  1.947640e-003,  9.049884e-004,  -1.455246e-004, -1.189896e-003, -2.197595e-003, -3.204635e-003, -4.216577e-003,
   -5.228208e-003, -6.240984e-003, -7.252716e-003, -8.260536e-003, -9.253422e-003, -1.021743e-002, -1.115506e-002, -1.203558e-002, -1.287596e-002,
   -1.367734e-002, -1.442266e-002, -1.512085e-002, -1.576614e-002, -1.638393e-002, -1.696377e-002, -1.748441e-002, -1.797201e-002, -1.842032e-002,
   -1.881223e-002, -1.918271e-002, -1.954592e-002, -1.990405e-002, -2.024293e-002, -2.059832e-002, -2.095779e-002, -2.131297e-002, -2.170726e-002,
   -2.210858e-002, -2.246456e-002, -2.278915e-002, -2.308242e-002, -2.322342e-002, -2.306052e-002, -2.261349e-002, -2.191240e-002, -2.095594e-002,
   -1.977207e-002, -1.840487e-002, -1.681573e-002, -1.502679e-002, -1.305332e-002, -1.091170e-002, -8.610341e-003, -6.190770e-003, -3.656235e-003,
   -1.029037e-003, 1.674037e-003,  4.433113e-003,  7.212017e-003,  1.000389e-002,  1.278387e-002,  1.552692e-002,  1.818788e-002,  2.076655e-002,
   2.324651e-002,  2.559140e-002,  2.781222e-002,  2.991169e-002,  3.187577e-002,  3.369424e-002,  3.534980e-002,  3.683330e-002,  3.814610e-002,
   3.927348e-002,  4.019439e-002,  4.087410e-002,  4.132283e-002,  4.151913e-002,  4.147579e-002,  4.120426e-002,  4.066848e-002,  3.999271e-002,
   3.925733e-002,  3.846311e-002,  3.759921e-002,  3.666230e-002,  3.566932e-002,  3.461171e-002,  3.349462e-002,  3.232089e-002,  3.107934e-002,
   2.977838e-002,  2.841009e-002,  2.700373e-002,  2.553549e-002,  2.400854e-002,  2.240906e-002,  2.073283e-002,  1.899488e-002,  1.722445e-002,
   1.537956e-002,  1.347586e-002,  1.152001e-002,  9.495525e-003,  7.368148e-003,  5.156433e-003,  2.890722e-003,  5.973835e-004,  -1.709326e-003,
   -3.996570e-003, -6.248824e-003, -8.482986e-003, -1.067745e-002, -1.287573e-002, -1.508739e-002, -1.730918e-002, -1.952652e-002, -2.171116e-002,
   -2.387995e-002, -2.596276e-002, -2.795315e-002, -2.989260e-002, -3.180817e-002, -3.368798e-002, -3.556614e-002, -3.744486e-002, -3.930562e-002,
   -4.113043e-002, -4.295031e-002, -4.474827e-002, -4.643930e-002, -4.813832e-002, -4.983717e-002, -5.152703e-002, -5.320793e-002, -5.486855e-002,
   -5.653315e-002, -5.819642e-002, -5.987110e-002, -6.137353e-002, -6.250467e-002, -6.336649e-002, -6.398757e-002, -6.434836e-002, -6.449744e-002,
   -6.439587e-002, -6.405544e-002, -6.349345e-002, -6.273850e-002, -6.180153e-002, -6.060963e-002, -5.922795e-002, -5.768980e-002, -5.600828e-002,
   -5.421894e-002, -5.232540e-002, -5.034515e-002, -4.825366e-002, -4.608968e-002, -4.385939e-002, -4.145852e-002, -3.891009e-002, -3.629935e-002,
   -3.367289e-002, -3.102229e-002, -2.837196e-002, -2.573596e-002, -2.311528e-002, -2.055056e-002, -1.806803e-002, -1.562220e-002, -1.317428e-002,
   -1.087637e-002, -8.701875e-003, -6.630098e-003, -4.744750e-003, -3.070384e-003, -1.582159e-003, -2.914927e-004, 7.335285e-004,  1.553592e-003,
   2.508960e-003,  3.389987e-003,  4.243592e-003,  5.125554e-003,  6.018631e-003,  6.936716e-003,  7.854009e-003,  8.758132e-003,  9.636745e-003,
   1.049402e-002,  1.149073e-002,  1.250395e-002,  1.350478e-002,  1.449061e-002,  1.542413e-002,  1.628812e-002,  1.708948e-002,  1.783974e-002,
   1.848572e-002,  1.903254e-002,  1.968004e-002,  2.035633e-002,  2.092502e-002,  2.142063e-002,  2.184386e-002,  2.216788e-002,  2.235990e-002,
   2.247126e-002,  2.244626e-002,  2.230984e-002,  2.215398e-002,  2.207862e-002,  2.189175e-002,  2.163851e-002,  2.134905e-002,  2.102868e-002,
   2.066273e-002,  2.026087e-002,  1.982760e-002,  1.934869e-002,  1.883445e-002,  1.861759e-002,  1.835068e-002,  1.804909e-002,  1.776918e-002,
   1.750116e-002,  1.723944e-002,  1.692107e-002,  1.655837e-002,  1.618388e-002,  1.575332e-002,  1.562169e-002,  1.550359e-002,  1.531092e-002,
   1.498434e-002,  1.451629e-002,  1.384733e-002,  1.298442e-002,  1.197104e-002,  1.079613e-002,  9.424703e-003,  8.157830e-003,  6.937001e-003,
   5.640427e-003,  4.215221e-003,  2.658892e-003,  9.804203e-004,  -8.441043e-004, -2.722842e-003, -4.638962e-003, -6.611850e-003, -8.412307e-003,
   -9.986228e-003, -1.159821e-002, -1.322716e-002, -1.484843e-002, -1.648289e-002, -1.809514e-002, -1.971193e-002, -2.125397e-002, -2.278520e-002,
   -2.420092e-002, -2.520827e-002, -2.618178e-002, -2.712257e-002, -2.805888e-002, -2.891514e-002, -2.973233e-002, -3.051873e-002, -3.123351e-002,
   -3.187630e-002, -3.240308e-002, -3.235571e-002, -3.217919e-002, -3.188676e-002, -3.136805e-002, -3.067525e-002, -3.001468e-002, -2.938975e-002,
   -2.869444e-002, -2.800532e-002, -2.731670e-002, -2.620078e-002, -2.497031e-002, -2.375862e-002, -2.248068e-002, -2.119424e-002, -1.990328e-002,
   -1.872219e-002, -1.754529e-002, -1.638864e-002, -1.523373e-002, -1.388387e-002, -1.239738e-002, -1.096089e-002, -9.538881e-003, -8.181707e-003,
   -6.950143e-003, -5.797964e-003, -4.686261e-003, -3.651562e-003, -2.739660e-003, -1.776657e-003, -5.363480e-004, 6.626466e-004,  1.793124e-003,
   2.950057e-003,  4.024141e-003,  5.063086e-003,  6.029834e-003,  6.953163e-003,  7.873540e-003,  8.776532e-003,  1.008271e-002,  1.131156e-002,
   1.251903e-002,  1.368173e-002,  1.473871e-002,  1.569125e-002,  1.656390e-002,  1.737614e-002,  1.817089e-002,  1.890068e-002,  1.993477e-002,
   2.094860e-002,  2.192921e-002,  2.279139e-002,  2.355434e-002,  2.421806e-002,  2.486279e-002,  2.542970e-002,  2.589966e-002,  2.621816e-002,
   2.671673e-002,  2.727773e-002,  2.775717e-002,  2.814537e-002,  2.843552e-002,  2.854905e-002,  2.857807e-002,  2.853260e-002,  2.841490e-002,
   2.820644e-002,  2.808304e-002,  2.817982e-002,  2.820464e-002,  2.810875e-002,  2.790979e-002,  2.769404e-002,  2.741801e-002,  2.713019e-002,
   2.677760e-002,  2.640030e-002,  2.607361e-002,  2.606227e-002,  2.601481e-002,  2.591623e-002,  2.581737e-002,  2.571329e-002,  2.550586e-002,
   2.520680e-002,  2.491147e-002,  2.450612e-002,  2.406190e-002,  2.391009e-002,  2.370905e-002,  2.340746e-002,  2.302998e-002,  2.253963e-002,
   2.198485e-002,  2.142238e-002,  2.075097e-002,  1.979952e-002,  1.873667e-002,  1.791233e-002,  1.719947e-002,  1.644673e-002,  1.569372e-002,
   1.488955e-002,  1.404621e-002,  1.314600e-002,  1.221373e-002,  1.138797e-002,  1.054174e-002,  9.789920e-003,  9.175487e-003,  8.475372e-003,
   7.754511e-003,  7.154047e-003,  6.532273e-003,  5.813567e-003,  5.029210e-003,  4.170620e-003,  3.290527e-003,  2.461252e-003,  1.762054e-003,
   9.264634e-004,  5.088638e-005,  -8.103291e-004, -1.731029e-003, -2.737163e-003, -3.898755e-003, -5.094573e-003, -6.473116e-003, -7.903319e-003,
   -8.736905e-003, -9.744800e-003, -1.092015e-002, -1.205169e-002, -1.326090e-002, -1.451070e-002, -1.584482e-002, -1.733432e-002, -1.891294e-002,
   -2.066027e-002, -2.187797e-002, -2.275431e-002, -2.364719e-002, -2.441949e-002, -2.501507e-002, -2.544148e-002, -2.572159e-002, -2.599709e-002,
   -2.615154e-002, -2.633808e-002, -2.596696e-002, -2.515847e-002, -2.430194e-002, -2.344515e-002, -2.276829e-002, -2.209294e-002, -2.135182e-002,
   -2.073453e-002, -2.014671e-002, -1.940560e-002, -1.838702e-002, -1.693106e-002, -1.552453e-002, -1.425790e-002, -1.309467e-002, -1.197368e-002,
   -1.101558e-002, -1.028193e-002, -9.523562e-003, -8.670417e-003, -8.028634e-003, -6.448768e-003, -4.857823e-003, -3.297200e-003, -2.188113e-003,
   -1.207461e-003, -2.277449e-004, 3.905405e-004,  5.450266e-004,  5.865983e-004,  5.800508e-004,  1.645117e-003,  2.698534e-003,  3.226162e-003,
   3.258084e-003,  2.865015e-003,  2.653676e-003,  2.132567e-003,  1.151595e-003,  1.848941e-004,  -1.400429e-003, -1.808496e-003, -1.942259e-003,
   -2.326727e-003, -3.152509e-003, -4.359287e-003, -5.916347e-003, -7.676281e-003, -9.729204e-003, -1.192822e-002, -1.451381e-002, -1.567311e-002,
   -1.507943e-002, -1.446563e-002, -1.393169e-002, -1.333215e-002, -1.327462e-002, -1.359070e-002, -1.389884e-002, -1.475839e-002, -1.597238e-002,
   -1.633836e-002, -1.345749e-002, -1.009753e-002, -7.133926e-003, -4.200006e-003, -6.689719e-004, 1.349175e-003,  2.473474e-003,  3.137331e-003,
   4.086499e-003,  4.453958e-003,  9.679730e-003,  1.532065e-002,  2.007844e-002,  2.492736e-002,  3.066648e-002,  3.647310e-002,  3.988489e-002,
   4.126106e-002,  3.799109e-002,  2.707282e-002,  2.562059e-002,  2.847733e-002,  3.032211e-002,  3.188822e-002,  3.292856e-002,  3.233655e-002,
   2.665533e-002,  1.806627e-002,  6.428464e-003,  -1.459043e-003, -9.594090e-002, -9.119271e-002, -7.541453e-002, -5.254466e-002, -2.774788e-002,
   -1.125875e-002, -1.815898e-003, 4.892343e-004,  -5.961389e-003, -1.667448e-002, 1.712418e-001,  5.307609e-003,  -4.415489e-002, -8.993407e-002,
   -1.295619e-001, -1.594212e-001, 4.023480e-001,  3.574481e-001,  2.632863e-001,  1.506829e-001,  0.000000e+000},
  {0.000000e+000,  -6.532769e-003, -1.221520e-002, -1.697523e-002, -2.106447e-002, -2.463361e-002, -2.766687e-002, -3.023530e-002, -3.229652e-002,
   -3.270719e-002, -3.258645e-002, -3.225349e-002, -3.179513e-002, -3.122651e-002, -3.056982e-002, -2.998388e-002, -2.954841e-002, -2.932281e-002,
   -2.934284e-002, -2.938877e-002, -2.942205e-002, -2.942762e-002, -2.939737e-002, -2.931269e-002, -2.916779e-002, -2.897899e-002, -2.873675e-002,
   -2.844817e-002, -2.807642e-002, -2.763964e-002, -2.714619e-002, -2.663448e-002, -2.611184e-002, -2.552600e-002, -2.488855e-002, -2.418947e-002,
   -2.342618e-002, -2.259059e-002, -2.170309e-002, -2.076071e-002, -1.975378e-002, -1.867971e-002, -1.765358e-002, -1.656691e-002, -1.546373e-002,
   -1.434789e-002, -1.325191e-002, -1.221392e-002, -1.116856e-002, -1.007257e-002, -8.955893e-003, -7.860193e-003, -6.875012e-003, -5.942372e-003,
   -5.032705e-003, -4.162771e-003, -3.292865e-003, -2.440887e-003, -1.599497e-003, -7.645774e-004, 4.396297e-005,  8.612120e-004,  1.563730e-003,
   2.224807e-003,  2.859342e-003,  3.464963e-003,  4.068511e-003,  4.641987e-003,  5.214387e-003,  5.764755e-003,  6.303663e-003,  6.829034e-003,
   7.304328e-003,  7.664827e-003,  8.046272e-003,  8.422555e-003,  8.797710e-003,  9.199348e-003,  9.620624e-003,  1.005912e-002,  1.056150e-002,
   1.113807e-002,  1.176332e-002,  1.235435e-002,  1.303921e-002,  1.378340e-002,  1.459241e-002,  1.547492e-002,  1.643004e-002,  1.747024e-002,
   1.863229e-002,  1.987287e-002,  2.119061e-002,  2.243226e-002,  2.372384e-002,  2.504550e-002,  2.636809e-002,  2.769457e-002,  2.900882e-002,
   3.029153e-002,  3.152997e-002,  3.269797e-002,  3.380591e-002,  3.474244e-002,  3.554791e-002,  3.627125e-002,  3.689908e-002,  3.746465e-002,
   3.798510e-002,  3.845275e-002,  3.887780e-002,  3.924963e-002,  3.957058e-002,  3.979395e-002,  3.994540e-002,  4.004658e-002,  4.009969e-002,
   4.011033e-002,  4.006704e-002,  3.999811e-002,  3.988609e-002,  3.973129e-002,  3.956733e-002,  3.936929e-002,  3.911411e-002,  3.887087e-002,
   3.860951e-002,  3.833137e-002,  3.806034e-002,  3.776318e-002,  3.744403e-002,  3.711637e-002,  3.675740e-002,  3.637314e-002,  3.591082e-002,
   3.543117e-002,  3.492546e-002,  3.439018e-002,  3.384263e-002,  3.327197e-002,  3.267202e-002,  3.204874e-002,  3.140814e-002,  3.075396e-002,
   3.003942e-002,  2.930089e-002,  2.856224e-002,  2.781853e-002,  2.706392e-002,  2.631752e-002,  2.556885e-002,  2.481096e-002,  2.404462e-002,
   2.328925e-002,  2.252295e-002,  2.174263e-002,  2.095703e-002,  2.018365e-002,  1.940994e-002,  1.863031e-002,  1.784201e-002,  1.705700e-002,
   1.626022e-002,  1.545164e-002,  1.461251e-002,  1.376739e-002,  1.291306e-002,  1.204207e-002,  1.113629e-002,  1.021071e-002,  9.251255e-003,
   8.271566e-003,  7.294434e-003,  6.308318e-003,  5.308622e-003,  4.300932e-003,  3.286563e-003,  2.258181e-003,  1.221221e-003,  1.856722e-004,
   -8.484221e-004, -1.870305e-003, -2.871901e-003, -3.831116e-003, -4.749567e-003, -5.605662e-003, -6.422759e-003, -7.214490e-003, -7.980585e-003,
   -8.716716e-003, -9.414298e-003, -1.007661e-002, -1.071457e-002, -1.132671e-002, -1.190911e-002, -1.244595e-002, -1.294670e-002, -1.343559e-002,
   -1.389265e-002, -1.432164e-002, -1.472680e-002, -1.511983e-002, -1.550296e-002, -1.586391e-002, -1.620859e-002, -1.652523e-002, -1.680998e-002,
   -1.710784e-002, -1.742824e-002, -1.776645e-002, -1.810618e-002, -1.843820e-002, -1.875733e-002, -1.907606e-002, -1.939679e-002, -1.970824e-002,
   -1.998130e-002, -2.026089e-002, -2.055476e-002, -2.086256e-002, -2.117866e-002, -2.149220e-002, -2.179572e-002, -2.208485e-002, -2.236024e-002,
   -2.263321e-002, -2.285947e-002, -2.309123e-002, -2.332934e-002, -2.356983e-002, -2.381360e-002, -2.406797e-002, -2.433305e-002, -2.460252e-002,
   -2.487001e-002, -2.513968e-002, -2.536943e-002, -2.559775e-002, -2.583922e-002, -2.609500e-002, -2.636832e-002, -2.664742e-002, -2.693605e-002,
   -2.724405e-002, -2.756673e-002, -2.790910e-002, -2.823045e-002, -2.854201e-002, -2.887594e-002, -2.922008e-002, -2.956359e-002, -2.989772e-002,
   -3.021727e-002, -3.052412e-002, -3.081950e-002, -3.110098e-002, -3.135615e-002, -3.155377e-002, -3.174011e-002, -3.191216e-002, -3.207831e-002,
   -3.223499e-002, -3.237371e-002, -3.248931e-002, -3.259216e-002, -3.267866e-002, -3.275664e-002, -3.275622e-002, -3.275601e-002, -3.275557e-002,
   -3.275116e-002, -3.274125e-002, -3.271000e-002, -3.266844e-002, -3.261945e-002, -3.256547e-002, -3.251442e-002, -3.239875e-002, -3.226059e-002,
   -3.211191e-002, -3.195549e-002, -3.179556e-002, -3.163133e-002, -3.146321e-002, -3.130578e-002, -3.115138e-002, -3.099567e-002, -3.079775e-002,
   -3.056239e-002, -3.031606e-002, -3.003899e-002, -2.972840e-002, -2.940357e-002, -2.906419e-002, -2.871059e-002, -2.835501e-002, -2.799315e-002,
   -2.760298e-002, -2.715330e-002, -2.670030e-002, -2.625279e-002, -2.580607e-002, -2.536566e-002, -2.493380e-002, -2.450932e-002, -2.409701e-002,
   -2.369579e-002, -2.330004e-002, -2.285275e-002, -2.242532e-002, -2.200968e-002, -2.160385e-002, -2.121101e-002, -2.084833e-002, -2.051915e-002,
   -2.021701e-002, -1.995330e-002, -1.971270e-002, -1.944017e-002, -1.917966e-002, -1.893869e-002, -1.871736e-002, -1.851847e-002, -1.833742e-002,
   -1.816985e-002, -1.802679e-002, -1.790473e-002, -1.780269e-002, -1.766665e-002, -1.750875e-002, -1.734317e-002, -1.717203e-002, -1.699149e-002,
   -1.681776e-002, -1.664286e-002, -1.648072e-002, -1.633152e-002, -1.619108e-002, -1.602849e-002, -1.583851e-002, -1.566326e-002, -1.550811e-002,
   -1.536736e-002, -1.524332e-002, -1.514554e-002, -1.507281e-002, -1.502812e-002, -1.500439e-002, -1.499129e-002, -1.494226e-002, -1.490819e-002,
   -1.488418e-002, -1.485479e-002, -1.480539e-002, -1.473257e-002, -1.463575e-002, -1.449811e-002, -1.432567e-002, -1.412065e-002, -1.382656e-002,
   -1.349918e-002, -1.314904e-002, -1.277454e-002, -1.236837e-002, -1.193744e-002, -1.148267e-002, -1.101964e-002, -1.050058e-002, -9.914246e-003,
   -9.210445e-003, -8.427679e-003, -7.588576e-003, -6.699325e-003, -5.772045e-003, -4.809852e-003, -3.807464e-003, -2.770907e-003, -1.705200e-003,
   -6.126022e-004, 5.347291e-004,  1.734790e-003,  2.965399e-003,  4.222764e-003,  5.489783e-003,  6.779274e-003,  8.078061e-003,  9.393902e-003,
   1.070917e-002,  1.203311e-002,  1.337517e-002,  1.476663e-002,  1.616265e-002,  1.755690e-002,  1.893940e-002,  2.031305e-002,  2.167301e-002,
   2.300717e-002,  2.431966e-002,  2.560680e-002,  2.685927e-002,  2.813641e-002,  2.938496e-002,  3.057478e-002,  3.171276e-002,  3.280427e-002,
   3.384355e-002,  3.482533e-002,  3.574690e-002,  3.660502e-002,  3.738863e-002,  3.813544e-002,  3.880533e-002,  3.938214e-002,  3.987092e-002,
   4.028217e-002,  4.065090e-002,  4.098059e-002,  4.126640e-002,  4.150830e-002,  4.171333e-002,  4.190909e-002,  4.208877e-002,  4.222789e-002,
   4.234609e-002,  4.243207e-002,  4.249591e-002,  4.252966e-002,  4.254075e-002,  4.253665e-002,  4.251042e-002,  4.247599e-002,  4.246337e-002,
   4.243445e-002,  4.239171e-002,  4.233124e-002,  4.223682e-002,  4.212051e-002,  4.198111e-002,  4.182352e-002,  4.164358e-002,  4.143106e-002,
   4.120318e-002,  4.093083e-002,  4.061422e-002,  4.027909e-002,  3.993275e-002,  3.957463e-002,  3.919706e-002,  3.879307e-002,  3.835790e-002,
   3.787175e-002,  3.736688e-002,  3.683735e-002,  3.627026e-002,  3.567735e-002,  3.507217e-002,  3.448559e-002,  3.390631e-002,  3.332196e-002,
   3.273279e-002,  3.214137e-002,  3.155165e-002,  3.095250e-002,  3.035020e-002,  2.974177e-002,  2.911109e-002,  2.847719e-002,  2.785070e-002,
   2.720581e-002,  2.656645e-002,  2.590273e-002,  2.524310e-002,  2.458191e-002,  2.391886e-002,  2.324437e-002,  2.256791e-002,  2.187044e-002,
   2.118013e-002,  2.048169e-002,  1.977477e-002,  1.904599e-002,  1.832074e-002,  1.761222e-002,  1.690101e-002,  1.618814e-002,  1.546799e-002,
   1.473969e-002,  1.400776e-002,  1.327174e-002,  1.252345e-002,  1.174386e-002,  1.096737e-002,  1.020283e-002,  9.430363e-003,  8.654778e-003,
   7.892528e-003,  7.129173e-003,  6.362172e-003,  5.597354e-003,  4.840385e-003,  4.073366e-003,  3.325491e-003,  2.603397e-003,  1.901038e-003,
   1.214563e-003,  5.588496e-004,  -8.223302e-005, -6.981275e-004, -1.285970e-003, -1.849201e-003, -2.418336e-003, -2.960654e-003, -3.486445e-003,
   -3.977198e-003, -4.461584e-003, -4.937863e-003, -5.408262e-003, -5.865971e-003, -6.323754e-003, -6.787078e-003, -7.281227e-003, -7.798834e-003,
   -8.306025e-003, -8.781440e-003, -9.229845e-003, -9.657470e-003, -9.975900e-003, -1.007702e-002, -9.959517e-003, -9.645284e-003, -9.164888e-003,
   -8.517471e-003, -7.731123e-003, -6.773238e-003, -5.687595e-003, -4.456536e-003, -3.101519e-003, -1.636108e-003, -7.315816e-005, 1.555848e-003,
   3.239161e-003,  4.970823e-003,  6.759802e-003,  8.566932e-003,  1.037725e-002,  1.217637e-002,  1.396598e-002,  1.569090e-002,  1.736337e-002,
   1.895222e-002,  2.042967e-002,  2.181469e-002,  2.311226e-002,  2.432504e-002,  2.543318e-002,  2.641692e-002,  2.728402e-002,  2.801533e-002,
   2.858587e-002,  2.899779e-002,  2.923672e-002,  2.929332e-002,  2.915666e-002,  2.885519e-002,  2.836062e-002,  2.765575e-002,  2.682927e-002,
   2.595272e-002,  2.501202e-002,  2.401254e-002,  2.294979e-002,  2.183288e-002,  2.067284e-002,  1.947250e-002,  1.824441e-002,  1.696697e-002,
   1.563558e-002,  1.424939e-002,  1.279818e-002,  1.130050e-002,  9.761677e-003,  8.169598e-003,  6.544112e-003,  4.870416e-003,  3.201319e-003,
   1.495312e-003,  -2.391932e-004, -2.028801e-003, -3.868455e-003, -5.752482e-003, -7.677679e-003, -9.623411e-003, -1.156313e-002, -1.350417e-002,
   -1.541146e-002, -1.729453e-002, -1.916687e-002, -2.104142e-002, -2.292456e-002, -2.479666e-002, -2.665514e-002, -2.850366e-002, -3.031820e-002,
   -3.209595e-002, -3.379983e-002, -3.542183e-002, -3.703161e-002, -3.863159e-002, -4.018645e-002, -4.171311e-002, -4.321981e-002, -4.470625e-002,
   -4.615018e-002, -4.759044e-002, -4.899370e-002, -5.035916e-002, -5.171634e-002, -5.305718e-002, -5.437612e-002, -5.567143e-002, -5.693880e-002,
   -5.817563e-002, -5.938301e-002, -6.057495e-002, -6.165224e-002, -6.239996e-002, -6.288807e-002, -6.310813e-002, -6.304225e-002, -6.274588e-002,
   -6.223194e-002, -6.151374e-002, -6.060617e-002, -5.951362e-002, -5.823577e-002, -5.669260e-002, -5.497676e-002, -5.312546e-002, -5.115961e-002,
   -4.908480e-002, -4.692624e-002, -4.469585e-002, -4.239173e-002, -4.003179e-002, -3.762882e-002, -3.510542e-002, -3.248061e-002, -2.983615e-002,
   -2.718292e-002, -2.450721e-002, -2.186227e-002, -1.928651e-002, -1.675118e-002, -1.427079e-002, -1.186932e-002, -9.534933e-003, -7.243229e-003,
   -5.089121e-003, -3.083293e-003, -1.213478e-003, 4.731847e-004,  1.981149e-003,  3.270859e-003,  4.333614e-003,  5.161470e-003,  5.741807e-003,
   6.406489e-003,  7.034348e-003,  7.616438e-003,  8.167287e-003,  8.714513e-003,  9.273391e-003,  9.793022e-003,  1.028839e-002,  1.073545e-002,
   1.115733e-002,  1.169378e-002,  1.222857e-002,  1.271281e-002,  1.315413e-002,  1.353840e-002,  1.389054e-002,  1.418729e-002,  1.443103e-002,
   1.460469e-002,  1.471177e-002,  1.487664e-002,  1.504678e-002,  1.514392e-002,  1.516624e-002,  1.510223e-002,  1.498710e-002,  1.481404e-002,
   1.458769e-002,  1.431196e-002,  1.388478e-002,  1.346083e-002,  1.309219e-002,  1.267070e-002,  1.224261e-002,  1.178148e-002,  1.129222e-002,
   1.077762e-002,  1.022005e-002,  9.613861e-003,  8.964988e-003,  8.339712e-003,  7.957197e-003,  7.547688e-003,  7.104776e-003,  6.659806e-003,
   6.220743e-003,  5.750010e-003,  5.278891e-003,  4.813104e-003,  4.305861e-003,  3.780783e-003,  3.493868e-003,  3.213514e-003,  2.930936e-003,
   2.577392e-003,  2.103517e-003,  1.588320e-003,  1.031697e-003,  4.160159e-004,  -2.302921e-004, -9.216502e-004, -1.441445e-003, -1.877119e-003,
   -2.408108e-003, -2.971337e-003, -3.592728e-003, -4.240805e-003, -4.905256e-003, -5.591039e-003, -6.274458e-003, -6.966553e-003, -7.533210e-003,
   -7.939772e-003, -8.315049e-003, -8.679835e-003, -9.048308e-003, -9.410999e-003, -9.786281e-003, -1.015407e-002, -1.051360e-002, -1.089604e-002,
   -1.122111e-002, -1.128243e-002, -1.133351e-002, -1.137950e-002, -1.143854e-002, -1.148168e-002, -1.158462e-002, -1.169562e-002, -1.178234e-002,
   -1.188448e-002, -1.197091e-002, -1.168305e-002, -1.135325e-002, -1.099651e-002, -1.062240e-002, -1.018116e-002, -9.751312e-003, -9.338056e-003,
   -8.937818e-003, -8.577245e-003, -8.201494e-003, -7.495357e-003, -6.715825e-003, -5.988625e-003, -5.229338e-003, -4.485564e-003, -3.763601e-003,
   -3.054500e-003, -2.371826e-003, -1.712284e-003, -1.076098e-003, -3.043154e-004, 6.480224e-004,  1.626253e-003,  2.564702e-003,  3.408403e-003,
   4.187223e-003,  4.902202e-003,  5.590339e-003,  6.173503e-003,  6.698124e-003,  7.307476e-003,  8.139043e-003,  8.930406e-003,  9.680552e-003,
   1.035973e-002,  1.098169e-002,  1.153050e-002,  1.206770e-002,  1.255645e-002,  1.300816e-002,  1.347322e-002,  1.429620e-002,  1.502401e-002,
   1.570974e-002,  1.634626e-002,  1.691635e-002,  1.742726e-002,  1.787101e-002,  1.825502e-002,  1.856556e-002,  1.877927e-002,  1.930438e-002,
   1.986019e-002,  2.038222e-002,  2.080783e-002,  2.112561e-002,  2.135111e-002,  2.146985e-002,  2.149711e-002,  2.142067e-002,  2.129241e-002,
   2.145973e-002,  2.168974e-002,  2.183086e-002,  2.188543e-002,  2.182534e-002,  2.169179e-002,  2.150543e-002,  2.125158e-002,  2.092572e-002,
   2.053000e-002,  2.023790e-002,  2.019688e-002,  2.007790e-002,  1.983821e-002,  1.956790e-002,  1.924107e-002,  1.881699e-002,  1.823102e-002,
   1.762668e-002,  1.709430e-002,  1.660872e-002,  1.641530e-002,  1.625456e-002,  1.604916e-002,  1.568893e-002,  1.522204e-002,  1.478688e-002,
   1.434127e-002,  1.377839e-002,  1.314822e-002,  1.241307e-002,  1.206826e-002,  1.166967e-002,  1.121055e-002,  1.069433e-002,  1.016206e-002,
   9.413642e-003,  8.503509e-003,  7.520136e-003,  6.519220e-003,  5.500631e-003,  4.769646e-003,  4.178043e-003,  3.592338e-003,  2.913984e-003,
   2.199171e-003,  1.462972e-003,  7.779389e-004,  2.084787e-005,  -9.078644e-004, -1.853984e-003, -2.466524e-003, -2.824434e-003, -3.278836e-003,
   -3.700410e-003, -4.395717e-003, -5.134335e-003, -5.896478e-003, -6.823869e-003, -7.822774e-003, -8.828758e-003, -9.819009e-003, -1.041423e-002,
   -1.098042e-002, -1.160713e-002, -1.224551e-002, -1.291294e-002, -1.365564e-002, -1.435375e-002, -1.509704e-002, -1.593947e-002, -1.676769e-002,
   -1.732561e-002, -1.789189e-002, -1.828965e-002, -1.888761e-002, -1.955111e-002, -2.024290e-002, -2.095046e-002, -2.160426e-002, -2.236804e-002,
   -2.314956e-002, -2.364632e-002, -2.404785e-002, -2.421678e-002, -2.439650e-002, -2.444100e-002, -2.435540e-002, -2.441270e-002, -2.431735e-002,
   -2.412379e-002, -2.387394e-002, -2.336155e-002, -2.259983e-002, -2.164169e-002, -2.057117e-002, -1.945146e-002, -1.832349e-002, -1.712395e-002,
   -1.594495e-002, -1.466801e-002, -1.340086e-002, -1.204418e-002, -1.008648e-002, -8.133784e-003, -6.166518e-003, -4.660371e-003, -3.121583e-003,
   -1.512601e-003, 6.328473e-005,  1.461581e-003,  2.537343e-003,  3.743347e-003,  5.776703e-003,  7.632033e-003,  9.183599e-003,  1.070731e-002,
   1.194166e-002,  1.268088e-002,  1.345295e-002,  1.411483e-002,  1.442900e-002,  1.429950e-002,  1.505580e-002,  1.589600e-002,  1.682960e-002,
   1.775878e-002,  1.857271e-002,  1.863971e-002,  1.847128e-002,  1.833125e-002,  1.768502e-002,  1.711928e-002,  1.708569e-002,  1.766101e-002,
   1.782570e-002,  1.759655e-002,  1.710381e-002,  1.643837e-002,  1.561701e-002,  1.460302e-002,  1.390973e-002,  1.331350e-002,  1.298934e-002,
   1.328848e-002,  1.346237e-002,  1.297064e-002,  1.208138e-002,  1.094080e-002,  9.929589e-003,  8.716210e-003,  7.684127e-003,  6.666715e-003,
   5.965556e-003,  6.340534e-003,  5.833938e-003,  5.243076e-003,  3.878449e-003,  1.108714e-003,  -1.281258e-003, -3.548815e-003, -5.998027e-003,
   -8.507627e-003, -1.107071e-002, -1.110974e-002, -1.138689e-002, -1.200857e-002, -1.289555e-002, -1.499827e-002, -1.808298e-002, -2.029365e-002,
   -2.191161e-002, -2.269953e-002, -2.616956e-002, -2.731351e-002, -2.711919e-002, -2.581373e-002, -2.250549e-002, -1.629162e-002, -8.876738e-003,
   2.463739e-003,  1.361066e-002,  2.374440e-002,  2.782711e-002,  1.328086e-002,  1.319623e-002,  1.016226e-002,  7.906934e-007,  -1.263750e-002,
   -1.672337e-002, -1.318413e-002, -2.919178e-003, 1.521017e-002,  3.611961e-002,  -6.700800e-002, -3.611864e-002, 2.810918e-002,  9.138928e-002,
   1.482023e-001,  1.936481e-001,  -4.153961e-001, -3.605610e-001, -2.574813e-001, -1.429867e-001, 0.000000e+000},
  {0.000000e+000,  -1.134635e-002, -1.761768e-002, -2.172598e-002, -2.450887e-002, -2.662351e-002, -2.840945e-002, -3.073955e-002, -3.358147e-002,
   -3.760858e-002, -4.122392e-002, -4.399597e-002, -4.614641e-002, -4.788043e-002, -4.921348e-002, -5.007621e-002, -5.042675e-002, -5.016633e-002,
   -4.930281e-002, -4.810463e-002, -4.676141e-002, -4.550188e-002, -4.431838e-002, -4.308964e-002, -4.182416e-002, -4.043271e-002, -3.893848e-002,
   -3.737988e-002, -3.579509e-002, -3.417506e-002, -3.252385e-002, -3.093217e-002, -2.950361e-002, -2.796727e-002, -2.633065e-002, -2.460131e-002,
   -2.279524e-002, -2.090474e-002, -1.894569e-002, -1.690435e-002, -1.481552e-002, -1.276824e-002, -1.105210e-002, -9.432472e-003, -7.923308e-003,
   -6.576621e-003, -5.777790e-003, -6.166661e-003, -6.449559e-003, -5.335349e-003, -3.724531e-003, -2.005136e-003, -4.424515e-004, 1.186672e-003,
   2.918413e-003,  4.750159e-003,  6.649490e-003,  8.603801e-003,  1.062992e-002,  1.268659e-002,  1.476939e-002,  1.687841e-002,  1.879841e-002,
   2.060377e-002,  2.239515e-002,  2.414483e-002,  2.586930e-002,  2.752673e-002,  2.910300e-002,  3.060077e-002,  3.198057e-002,  3.326320e-002,
   3.434649e-002,  3.516638e-002,  3.586284e-002,  3.645734e-002,  3.691280e-002,  3.724127e-002,  3.746032e-002,  3.763468e-002,  3.782962e-002,
   3.802922e-002,  3.817559e-002,  3.809230e-002,  3.801298e-002,  3.792488e-002,  3.785148e-002,  3.775788e-002,  3.766953e-002,  3.754227e-002,
   3.735041e-002,  3.713261e-002,  3.687700e-002,  3.636428e-002,  3.582948e-002,  3.529925e-002,  3.480637e-002,  3.432396e-002,  3.388674e-002,
   3.352976e-002,  3.323339e-002,  3.304068e-002,  3.295169e-002,  3.281370e-002,  3.270403e-002,  3.261787e-002,  3.259480e-002,  3.257314e-002,
   3.249488e-002,  3.233885e-002,  3.209231e-002,  3.177377e-002,  3.138544e-002,  3.085058e-002,  3.014784e-002,  2.939064e-002,  2.859129e-002,
   2.770948e-002,  2.677170e-002,  2.577703e-002,  2.472110e-002,  2.366825e-002,  2.264275e-002,  2.164012e-002,  2.061104e-002,  1.968232e-002,
   1.885304e-002,  1.810784e-002,  1.741880e-002,  1.676511e-002,  1.613576e-002,  1.551279e-002,  1.490572e-002,  1.430344e-002,  1.351942e-002,
   1.273312e-002,  1.193898e-002,  1.114232e-002,  1.032225e-002,  9.481449e-003,  8.626952e-003,  7.760422e-003,  6.879351e-003,  5.986261e-003,
   4.966975e-003,  3.908592e-003,  2.863065e-003,  1.868125e-003,  9.172080e-004,  1.046373e-005,  -8.433607e-004, -1.644120e-003, -2.405945e-003,
   -3.101746e-003, -3.830488e-003, -4.576447e-003, -5.270790e-003, -5.886227e-003, -6.424027e-003, -6.907665e-003, -7.345706e-003, -7.757575e-003,
   -8.152908e-003, -8.531001e-003, -8.940108e-003, -9.448186e-003, -9.983748e-003, -1.055782e-002, -1.119748e-002, -1.191269e-002, -1.268668e-002,
   -1.349656e-002, -1.430581e-002, -1.511025e-002, -1.593260e-002, -1.687315e-002, -1.785384e-002, -1.886695e-002, -1.991287e-002, -2.097233e-002,
   -2.201288e-002, -2.298774e-002, -2.382877e-002, -2.450900e-002, -2.504305e-002, -2.553002e-002, -2.593288e-002, -2.623671e-002, -2.646666e-002,
   -2.660288e-002, -2.665385e-002, -2.663567e-002, -2.654713e-002, -2.638919e-002, -2.618274e-002, -2.598657e-002, -2.578506e-002, -2.552246e-002,
   -2.522183e-002, -2.488480e-002, -2.450918e-002, -2.409939e-002, -2.366219e-002, -2.319039e-002, -2.271563e-002, -2.227302e-002, -2.192462e-002,
   -2.165914e-002, -2.149167e-002, -2.139348e-002, -2.132619e-002, -2.124987e-002, -2.116362e-002, -2.105774e-002, -2.092112e-002, -2.078883e-002,
   -2.071523e-002, -2.067486e-002, -2.065688e-002, -2.066002e-002, -2.066081e-002, -2.062131e-002, -2.050353e-002, -2.027333e-002, -1.994908e-002,
   -1.954934e-002, -1.917789e-002, -1.879192e-002, -1.840185e-002, -1.801653e-002, -1.762463e-002, -1.722439e-002, -1.682430e-002, -1.642662e-002,
   -1.603284e-002, -1.563143e-002, -1.525672e-002, -1.489269e-002, -1.454465e-002, -1.423131e-002, -1.394509e-002, -1.367500e-002, -1.342363e-002,
   -1.321398e-002, -1.303203e-002, -1.289496e-002, -1.282691e-002, -1.288545e-002, -1.307339e-002, -1.335941e-002, -1.366069e-002, -1.394481e-002,
   -1.418422e-002, -1.438234e-002, -1.454117e-002, -1.464306e-002, -1.470022e-002, -1.472815e-002, -1.471898e-002, -1.467934e-002, -1.459673e-002,
   -1.446339e-002, -1.424109e-002, -1.392312e-002, -1.354917e-002, -1.312112e-002, -1.265796e-002, -1.217671e-002, -1.168649e-002, -1.120191e-002,
   -1.071206e-002, -1.025145e-002, -9.822574e-003, -9.461608e-003, -9.170917e-003, -8.969195e-003, -8.873108e-003, -8.873420e-003, -8.928497e-003,
   -9.043345e-003, -9.197409e-003, -9.402699e-003, -9.669787e-003, -9.999986e-003, -1.041953e-002, -1.091938e-002, -1.147845e-002, -1.209849e-002,
   -1.272653e-002, -1.332109e-002, -1.382004e-002, -1.419416e-002, -1.447632e-002, -1.469482e-002, -1.485244e-002, -1.495762e-002, -1.503236e-002,
   -1.506365e-002, -1.504705e-002, -1.497501e-002, -1.486682e-002, -1.471548e-002, -1.453218e-002, -1.433200e-002, -1.413336e-002, -1.392293e-002,
   -1.370104e-002, -1.345866e-002, -1.319155e-002, -1.289780e-002, -1.258034e-002, -1.223440e-002, -1.185874e-002, -1.151726e-002, -1.121679e-002,
   -1.095117e-002, -1.073422e-002, -1.052613e-002, -1.029444e-002, -1.000695e-002, -9.640678e-003, -9.202590e-003, -8.682031e-003, -8.097335e-003,
   -7.463596e-003, -6.806655e-003, -6.132800e-003, -5.421541e-003, -4.642184e-003, -3.783921e-003, -2.794062e-003, -1.694022e-003, -4.783440e-004,
   7.974099e-004,  2.094092e-003,  3.421952e-003,  4.763768e-003,  6.103750e-003,  7.448706e-003,  8.775891e-003,  1.007622e-002,  1.134523e-002,
   1.255775e-002,  1.369763e-002,  1.475516e-002,  1.572160e-002,  1.658871e-002,  1.733925e-002,  1.797791e-002,  1.849035e-002,  1.889432e-002,
   1.920618e-002,  1.949973e-002,  1.984141e-002,  2.026283e-002,  2.078879e-002,  2.138739e-002,  2.207597e-002,  2.283496e-002,  2.365560e-002,
   2.453674e-002,  2.544379e-002,  2.636669e-002,  2.729971e-002,  2.822946e-002,  2.914986e-002,  3.005259e-002,  3.085186e-002,  3.148772e-002,
   3.196431e-002,  3.231862e-002,  3.253866e-002,  3.262549e-002,  3.256768e-002,  3.237697e-002,  3.206063e-002,  3.162061e-002,  3.105718e-002,
   3.036829e-002,  2.954590e-002,  2.863446e-002,  2.763093e-002,  2.656309e-002,  2.542809e-002,  2.423808e-002,  2.299217e-002,  2.170289e-002,
   2.036785e-002,  1.901731e-002,  1.769542e-002,  1.641823e-002,  1.519938e-002,  1.405123e-002,  1.293986e-002,  1.186017e-002,  1.082860e-002,
   9.827379e-003,  8.851931e-003,  7.925650e-003,  7.044618e-003,  6.204161e-003,  5.432177e-003,  4.728357e-003,  4.078939e-003,  3.495290e-003,
   2.976061e-003,  2.539528e-003,  2.155430e-003,  1.829250e-003,  1.560023e-003,  1.346070e-003,  1.190943e-003,  1.108082e-003,  1.083473e-003,
   1.121048e-003,  1.172564e-003,  1.236166e-003,  1.320187e-003,  1.420453e-003,  1.545502e-003,  1.702099e-003,  1.918865e-003,  2.198350e-003,
   2.520087e-003,  2.900698e-003,  3.319243e-003,  3.790287e-003,  4.316773e-003,  4.921100e-003,  5.622181e-003,  6.405014e-003,  7.267590e-003,
   8.176287e-003,  9.134689e-003,  1.012979e-002,  1.113330e-002,  1.214428e-002,  1.315724e-002,  1.414591e-002,  1.510960e-002,  1.601309e-002,
   1.680948e-002,  1.749631e-002,  1.811641e-002,  1.870098e-002,  1.927058e-002,  1.985717e-002,  2.045737e-002,  2.101223e-002,  2.151884e-002,
   2.198180e-002,  2.236947e-002,  2.270164e-002,  2.299610e-002,  2.329606e-002,  2.363499e-002,  2.407524e-002,  2.462409e-002,  2.520773e-002,
   2.581184e-002,  2.643603e-002,  2.704215e-002,  2.761865e-002,  2.817393e-002,  2.868923e-002,  2.915006e-002,  2.956677e-002,  2.995479e-002,
   3.027849e-002,  3.053895e-002,  3.073239e-002,  3.088223e-002,  3.095852e-002,  3.096713e-002,  3.093097e-002,  3.082940e-002,  3.066766e-002,
   3.046607e-002,  3.021635e-002,  2.990748e-002,  2.952837e-002,  2.910198e-002,  2.862251e-002,  2.806914e-002,  2.745959e-002,  2.680496e-002,
   2.607363e-002,  2.527104e-002,  2.438915e-002,  2.342297e-002,  2.236284e-002,  2.126747e-002,  2.014990e-002,  1.895835e-002,  1.772616e-002,
   1.647878e-002,  1.519420e-002,  1.385465e-002,  1.248300e-002,  1.112366e-002,  9.780798e-003,  8.450238e-003,  7.197687e-003,  5.995258e-003,
   4.836105e-003,  3.740746e-003,  2.744282e-003,  1.831381e-003,  9.665268e-004,  1.915072e-004,  -5.209305e-004, -1.204745e-003, -1.871157e-003,
   -2.486003e-003, -3.106375e-003, -3.735158e-003, -4.360172e-003, -5.002425e-003, -5.706630e-003, -6.521167e-003, -7.406076e-003, -8.398183e-003,
   -9.457623e-003, -1.050339e-002, -1.149675e-002, -1.245200e-002, -1.344093e-002, -1.457827e-002, -1.585482e-002, -1.727961e-002, -1.884394e-002,
   -2.049308e-002, -2.227052e-002, -2.409919e-002, -2.597378e-002, -2.784197e-002, -2.973761e-002, -3.164099e-002, -3.356992e-002, -3.552059e-002,
   -3.750655e-002, -3.953418e-002, -4.155175e-002, -4.357000e-002, -4.559511e-002, -4.762808e-002, -4.962741e-002, -5.161729e-002, -5.362187e-002,
   -5.563920e-002, -5.762012e-002, -5.956637e-002, -6.145480e-002, -6.321095e-002, -6.481960e-002, -6.629907e-002, -6.759619e-002, -6.871628e-002,
   -6.964697e-002, -7.041450e-002, -7.096888e-002, -7.128985e-002, -7.137707e-002, -7.115765e-002, -7.054324e-002, -6.957915e-002, -6.839251e-002,
   -6.706672e-002, -6.561954e-002, -6.409303e-002, -6.249140e-002, -6.079951e-002, -5.900849e-002, -5.715343e-002, -5.520496e-002, -5.318135e-002,
   -5.109537e-002, -4.895027e-002, -4.675397e-002, -4.450474e-002, -4.222495e-002, -3.994460e-002, -3.766433e-002, -3.539337e-002, -3.310195e-002,
   -3.078810e-002, -2.848031e-002, -2.621025e-002, -2.399685e-002, -2.187435e-002, -1.986084e-002, -1.787407e-002, -1.586948e-002, -1.378054e-002,
   -1.158356e-002, -9.252804e-003, -6.802743e-003, -4.287197e-003, -1.742612e-003, 8.169265e-004,  3.399585e-003,  5.981001e-003,  8.651186e-003,
   1.142270e-002,  1.432335e-002,  1.731409e-002,  2.034700e-002,  2.340521e-002,  2.647639e-002,  2.955898e-002,  3.262615e-002,  3.562890e-002,
   3.859948e-002,  4.147859e-002,  4.427144e-002,  4.699205e-002,  4.962761e-002,  5.213458e-002,  5.443235e-002,  5.655623e-002,  5.854896e-002,
   6.040730e-002,  6.208631e-002,  6.356527e-002,  6.466013e-002,  6.515486e-002,  6.516355e-002,  6.474298e-002,  6.390809e-002,  6.271160e-002,
   6.114620e-002,  5.924839e-002,  5.702263e-002,  5.454731e-002,  5.178598e-002,  4.876061e-002,  4.546938e-002,  4.197774e-002,  3.830514e-002,
   3.447554e-002,  3.048987e-002,  2.634874e-002,  2.212412e-002,  1.782598e-002,  1.345852e-002,  9.023357e-003,  4.608042e-003,  2.105558e-004,
   -4.184511e-003, -8.512561e-003, -1.269997e-002, -1.676956e-002, -2.071264e-002, -2.453194e-002, -2.817014e-002, -3.162267e-002, -3.492074e-002,
   -3.802052e-002, -4.083489e-002, -4.333077e-002, -4.548768e-002, -4.726003e-002, -4.860121e-002, -4.953436e-002, -5.005490e-002, -5.019485e-002,
   -5.026031e-002, -5.025901e-002, -5.017142e-002, -4.994816e-002, -4.950109e-002, -4.885383e-002, -4.805245e-002, -4.705928e-002, -4.596582e-002,
   -4.474548e-002, -4.342378e-002, -4.195684e-002, -4.036735e-002, -3.867625e-002, -3.690848e-002, -3.504698e-002, -3.308433e-002, -3.103943e-002,
   -2.897716e-002, -2.684049e-002, -2.467231e-002, -2.248166e-002, -2.025574e-002, -1.794159e-002, -1.557267e-002, -1.313351e-002, -1.065813e-002,
   -8.174320e-003, -5.664156e-003, -3.140808e-003, -6.521983e-004, 1.780212e-003,  4.187863e-003,  6.588942e-003,  9.028893e-003,  1.150922e-002,
   1.403551e-002,  1.653118e-002,  1.898734e-002,  2.143321e-002,  2.384589e-002,  2.619629e-002,  2.857339e-002,  3.098273e-002,  3.346770e-002,
   3.610277e-002,  3.878851e-002,  4.140053e-002,  4.402770e-002,  4.666774e-002,  4.930988e-002,  5.181500e-002,  5.425086e-002,  5.658311e-002,
   5.865812e-002,  6.037949e-002,  6.163002e-002,  6.242446e-002,  6.281408e-002,  6.282743e-002,  6.249198e-002,  6.180059e-002,  6.072940e-002,
   5.935801e-002,  5.768675e-002,  5.580688e-002,  5.367001e-002,  5.127884e-002,  4.868102e-002,  4.596570e-002,  4.315876e-002,  4.023312e-002,
   3.716553e-002,  3.404403e-002,  3.087525e-002,  2.778545e-002,  2.468402e-002,  2.154486e-002,  1.851727e-002,  1.549370e-002,  1.256584e-002,
   9.655635e-003,  6.738544e-003,  3.898521e-003,  1.180852e-003,  -1.529485e-003, -4.137514e-003, -6.665332e-003, -9.092490e-003, -1.142159e-002,
   -1.361609e-002, -1.565811e-002, -1.750006e-002, -1.898851e-002, -2.006091e-002, -2.068463e-002, -2.103815e-002, -2.136345e-002, -2.162603e-002,
   -2.185402e-002, -2.198784e-002, -2.204479e-002, -2.212886e-002, -2.210631e-002, -2.195764e-002, -2.175342e-002, -2.143846e-002, -2.109432e-002,
   -2.080349e-002, -2.046973e-002, -2.012012e-002, -1.963370e-002, -1.915468e-002, -1.883033e-002, -1.855668e-002, -1.835668e-002, -1.812133e-002,
   -1.791395e-002, -1.776481e-002, -1.772381e-002, -1.778464e-002, -1.791073e-002, -1.807600e-002, -1.831436e-002, -1.864740e-002, -1.889951e-002,
   -1.901273e-002, -1.899729e-002, -1.891988e-002, -1.879647e-002, -1.856912e-002, -1.825729e-002, -1.775627e-002, -1.717409e-002, -1.655150e-002,
   -1.582685e-002, -1.500763e-002, -1.411156e-002, -1.318791e-002, -1.235616e-002, -1.148102e-002, -1.055413e-002, -9.598753e-003, -8.599481e-003,
   -7.702566e-003, -6.699917e-003, -5.682008e-003, -4.645966e-003, -3.701883e-003, -2.781817e-003, -1.835791e-003, -9.534839e-004, -1.358727e-004,
   7.645920e-004,  1.650160e-003,  2.380812e-003,  3.039520e-003,  3.667354e-003,  4.217587e-003,  4.730223e-003,  5.257617e-003,  5.782789e-003,
   6.378371e-003,  6.958047e-003,  7.662739e-003,  8.456015e-003,  9.257192e-003,  9.893800e-003,  1.034700e-002,  1.080941e-002,  1.139111e-002,
   1.194571e-002,  1.253214e-002,  1.325023e-002,  1.413519e-002,  1.495963e-002,  1.581326e-002,  1.661442e-002,  1.732529e-002,  1.798195e-002,
   1.853289e-002,  1.900233e-002,  1.927075e-002,  1.950451e-002,  1.986926e-002,  2.008369e-002,  1.998674e-002,  1.975759e-002,  1.937581e-002,
   1.880336e-002,  1.810052e-002,  1.724109e-002,  1.622051e-002,  1.508894e-002,  1.417387e-002,  1.336427e-002,  1.250931e-002,  1.179961e-002,
   1.107098e-002,  1.024073e-002,  9.518839e-003,  8.938140e-003,  8.282847e-003,  7.703428e-003,  7.377786e-003,  7.167064e-003,  6.834357e-003,
   6.545050e-003,  6.282050e-003,  6.102883e-003,  5.866253e-003,  5.460511e-003,  5.150162e-003,  4.929310e-003,  4.548783e-003,  4.411511e-003,
   4.324230e-003,  4.202749e-003,  4.087639e-003,  3.786271e-003,  3.442715e-003,  2.974692e-003,  2.394955e-003,  1.544147e-003,  8.778835e-004,
   4.522713e-004,  3.530497e-005,  -3.063444e-004, -6.972603e-004, -1.039101e-003, -1.309780e-003, -1.669319e-003, -2.035110e-003, -2.346166e-003,
   -2.567850e-003, -2.479517e-003, -2.225912e-003, -1.964386e-003, -2.096616e-003, -2.368138e-003, -2.593145e-003, -3.040563e-003, -3.441872e-003,
   -3.874818e-003, -4.411709e-003, -4.987393e-003, -5.445991e-003, -5.639614e-003, -6.051010e-003, -6.485067e-003, -7.117362e-003, -7.936652e-003,
   -8.953812e-003, -9.892648e-003, -1.089533e-002, -1.166788e-002, -1.201519e-002, -1.236891e-002, -1.219419e-002, -1.211962e-002, -1.212494e-002,
   -1.211329e-002, -1.180531e-002, -1.140572e-002, -1.048261e-002, -9.355053e-003, -8.280176e-003, -6.966247e-003, -5.767157e-003, -4.951729e-003,
   -4.522208e-003, -4.305421e-003, -4.249426e-003, -4.522457e-003, -4.834559e-003, -5.059925e-003, -5.843616e-003, -6.688421e-003, -7.958458e-003,
   -9.172632e-003, -1.018046e-002, -1.154384e-002, -1.274315e-002, -1.368567e-002, -1.469643e-002, -1.594366e-002, -1.779117e-002, -1.989509e-002,
   -2.216908e-002, -2.380087e-002, -2.536860e-002, -2.637852e-002, -2.705018e-002, -2.768121e-002, -2.750716e-002, -2.716176e-002, -2.695065e-002,
   -2.718447e-002, -2.722912e-002, -2.712754e-002, -2.668310e-002, -2.614494e-002, -2.507963e-002, -2.352640e-002, -2.022987e-002, -1.610201e-002,
   -1.155828e-002, -8.420893e-003, -5.926222e-003, -3.661171e-003, -1.491929e-003, 7.715562e-004,  3.631197e-003,  7.567342e-003,  1.182876e-002,
   1.664294e-002,  2.233888e-002,  2.625049e-002,  2.852705e-002,  3.084693e-002,  3.224908e-002,  3.214723e-002,  3.402001e-002,  3.717919e-002,
   4.158347e-002,  4.632704e-002,  5.109931e-002,  5.293910e-002,  5.398879e-002,  5.392872e-002,  5.179496e-002,  4.715900e-002,  3.908661e-002,
   3.299274e-002,  2.851598e-002,  2.509327e-002,  2.093308e-002,  2.970031e-002,  1.645794e-002,  5.349363e-004,  -1.330958e-002, -2.130251e-002,
   -2.298760e-002, -1.978978e-002, -1.212300e-002, -6.487657e-003, -4.397713e-003, -4.579569e-001, -1.238441e-001, 1.341668e-002,  6.288721e-002,
   9.382289e-002,  1.147923e-001,  8.623371e-002,  8.311075e-002,  6.155081e-002,  3.434061e-002,  0.000000e+000},
  {0.000000e+000,  -2.895906e-003, -4.464823e-003, -5.525560e-003, -6.418178e-003, -7.351525e-003, -8.433005e-003, -9.848137e-003, -1.172874e-002,
   -1.475416e-002, -1.767415e-002, -2.025072e-002, -2.253928e-002, -2.455384e-002, -2.637298e-002, -2.791555e-002, -2.897849e-002, -2.963993e-002,
   -2.986200e-002, -2.984942e-002, -2.965339e-002, -2.947005e-002, -2.934270e-002, -2.909344e-002, -2.873585e-002, -2.823720e-002, -2.765083e-002,
   -2.696246e-002, -2.622431e-002, -2.540962e-002, -2.452170e-002, -2.360582e-002, -2.281415e-002, -2.195914e-002, -2.104289e-002, -2.004385e-002,
   -1.897010e-002, -1.785561e-002, -1.664630e-002, -1.537661e-002, -1.407451e-002, -1.281055e-002, -1.180363e-002, -1.083833e-002, -9.926934e-003,
   -9.065134e-003, -8.452136e-003, -8.423315e-003, -8.347153e-003, -7.601521e-003, -6.583448e-003, -5.488648e-003, -4.505461e-003, -3.485897e-003,
   -2.393524e-003, -1.236086e-003, -4.525137e-005, 1.226292e-003,  2.516364e-003,  3.835360e-003,  5.175180e-003,  6.488151e-003,  7.676985e-003,
   8.771173e-003,  9.878409e-003,  1.101293e-002,  1.212535e-002,  1.324902e-002,  1.434264e-002,  1.538974e-002,  1.642345e-002,  1.743267e-002,
   1.831022e-002,  1.905284e-002,  1.974648e-002,  2.041558e-002,  2.103339e-002,  2.161407e-002,  2.212496e-002,  2.264361e-002,  2.311965e-002,
   2.357565e-002,  2.394200e-002,  2.412315e-002,  2.424235e-002,  2.435109e-002,  2.443311e-002,  2.449073e-002,  2.451687e-002,  2.448145e-002,
   2.437815e-002,  2.422221e-002,  2.401314e-002,  2.362008e-002,  2.317030e-002,  2.275354e-002,  2.233428e-002,  2.196548e-002,  2.161464e-002,
   2.129583e-002,  2.106744e-002,  2.091527e-002,  2.085410e-002,  2.075596e-002,  2.066528e-002,  2.066551e-002,  2.071400e-002,  2.077096e-002,
   2.082086e-002,  2.087344e-002,  2.089415e-002,  2.089392e-002,  2.088146e-002,  2.074785e-002,  2.051784e-002,  2.026943e-002,  1.998084e-002,
   1.968316e-002,  1.936832e-002,  1.902071e-002,  1.865995e-002,  1.828210e-002,  1.789596e-002,  1.749490e-002,  1.698811e-002,  1.648612e-002,
   1.598793e-002,  1.550545e-002,  1.503698e-002,  1.457407e-002,  1.411040e-002,  1.364017e-002,  1.316552e-002,  1.269563e-002,  1.207341e-002,
   1.144819e-002,  1.083859e-002,  1.022878e-002,  9.619818e-003,  9.028038e-003,  8.429258e-003,  7.847054e-003,  7.278926e-003,  6.712614e-003,
   6.044726e-003,  5.366690e-003,  4.692043e-003,  4.032066e-003,  3.394625e-003,  2.783495e-003,  2.195134e-003,  1.629404e-003,  1.094357e-003,
   5.715504e-004,  -1.924332e-006, -5.883363e-004, -1.148628e-003, -1.690679e-003, -2.196571e-003, -2.668668e-003, -3.142679e-003, -3.605847e-003,
   -4.031041e-003, -4.440960e-003, -4.906874e-003, -5.445514e-003, -5.960068e-003, -6.476339e-003, -7.007528e-003, -7.544886e-003, -8.078363e-003,
   -8.619945e-003, -9.157969e-003, -9.683805e-003, -1.020333e-002, -1.081033e-002, -1.141298e-002, -1.201852e-002, -1.262208e-002, -1.321078e-002,
   -1.376765e-002, -1.427985e-002, -1.473918e-002, -1.513532e-002, -1.546545e-002, -1.581542e-002, -1.613551e-002, -1.640617e-002, -1.661191e-002,
   -1.676290e-002, -1.687407e-002, -1.693655e-002, -1.694720e-002, -1.690485e-002, -1.683114e-002, -1.675189e-002, -1.665936e-002, -1.652267e-002,
   -1.634763e-002, -1.614576e-002, -1.589294e-002, -1.559875e-002, -1.526284e-002, -1.489721e-002, -1.451902e-002, -1.415455e-002, -1.382346e-002,
   -1.350522e-002, -1.320864e-002, -1.292238e-002, -1.263742e-002, -1.234357e-002, -1.205038e-002, -1.175984e-002, -1.146408e-002, -1.116925e-002,
   -1.092516e-002, -1.068761e-002, -1.046723e-002, -1.027163e-002, -1.008301e-002, -9.890534e-003, -9.683735e-003, -9.459873e-003, -9.223617e-003,
   -8.978837e-003, -8.789214e-003, -8.604700e-003, -8.433281e-003, -8.272549e-003, -8.114165e-003, -7.964128e-003, -7.821400e-003, -7.694295e-003,
   -7.580952e-003, -7.470115e-003, -7.394893e-003, -7.338279e-003, -7.289685e-003, -7.257113e-003, -7.232058e-003, -7.205882e-003, -7.173739e-003,
   -7.150500e-003, -7.133038e-003, -7.112905e-003, -7.112220e-003, -7.151833e-003, -7.216250e-003, -7.311456e-003, -7.406469e-003, -7.495108e-003,
   -7.567721e-003, -7.630161e-003, -7.682957e-003, -7.721432e-003, -7.756669e-003, -7.810954e-003, -7.853388e-003, -7.885001e-003, -7.915443e-003,
   -7.936768e-003, -7.939238e-003, -7.917802e-003, -7.883684e-003, -7.830309e-003, -7.775427e-003, -7.735771e-003, -7.693301e-003, -7.654644e-003,
   -7.603417e-003, -7.565258e-003, -7.540294e-003, -7.546296e-003, -7.570913e-003, -7.612079e-003, -7.690470e-003, -7.813111e-003, -7.946947e-003,
   -8.095672e-003, -8.254648e-003, -8.428349e-003, -8.619320e-003, -8.822900e-003, -9.058603e-003, -9.318053e-003, -9.586064e-003, -9.886948e-003,
   -1.018891e-002, -1.048979e-002, -1.076981e-002, -1.100713e-002, -1.122380e-002, -1.143523e-002, -1.162771e-002, -1.181175e-002, -1.198539e-002,
   -1.214402e-002, -1.228983e-002, -1.240941e-002, -1.251081e-002, -1.259367e-002, -1.265230e-002, -1.269296e-002, -1.272227e-002, -1.273351e-002,
   -1.272334e-002, -1.268136e-002, -1.262898e-002, -1.254743e-002, -1.243833e-002, -1.229681e-002, -1.210789e-002, -1.191259e-002, -1.169413e-002,
   -1.145026e-002, -1.119393e-002, -1.090709e-002, -1.059710e-002, -1.024378e-002, -9.844418e-003, -9.405516e-003, -8.916922e-003, -8.386253e-003,
   -7.823314e-003, -7.238365e-003, -6.632083e-003, -6.000171e-003, -5.344412e-003, -4.665563e-003, -3.944884e-003, -3.185076e-003, -2.374058e-003,
   -1.538019e-003, -6.914272e-004, 1.691596e-004,  1.035474e-003,  1.901827e-003,  2.766182e-003,  3.606600e-003,  4.440018e-003,  5.270932e-003,
   6.090301e-003,  6.893398e-003,  7.670102e-003,  8.419785e-003,  9.152211e-003,  9.850711e-003,  1.050815e-002,  1.112748e-002,  1.171961e-002,
   1.228205e-002,  1.282661e-002,  1.337111e-002,  1.392199e-002,  1.449591e-002,  1.507698e-002,  1.567535e-002,  1.627194e-002,  1.684452e-002,
   1.742683e-002,  1.800101e-002,  1.856623e-002,  1.912478e-002,  1.967418e-002,  2.020713e-002,  2.071729e-002,  2.114986e-002,  2.148201e-002,
   2.169531e-002,  2.182030e-002,  2.186470e-002,  2.182147e-002,  2.168727e-002,  2.148126e-002,  2.121285e-002,  2.087042e-002,  2.045338e-002,
   1.997442e-002,  1.941427e-002,  1.879391e-002,  1.812959e-002,  1.742822e-002,  1.668334e-002,  1.591088e-002,  1.510745e-002,  1.428426e-002,
   1.343524e-002,  1.257503e-002,  1.170492e-002,  1.081745e-002,  9.947712e-003,  9.101623e-003,  8.278347e-003,  7.478579e-003,  6.702645e-003,
   5.945762e-003,  5.207282e-003,  4.499157e-003,  3.816988e-003,  3.144614e-003,  2.524327e-003,  1.943203e-003,  1.402940e-003,  9.132676e-004,
   4.726362e-004,  9.247422e-005,  -2.349733e-004, -5.208951e-004, -7.558555e-004, -9.505382e-004, -1.085498e-003, -1.153604e-003, -1.142865e-003,
   -1.066518e-003, -9.692178e-004, -8.511381e-004, -7.084129e-004, -5.427060e-004, -3.561664e-004, -1.619200e-004, 3.297684e-005,  2.574188e-004,
   5.092378e-004,  7.915528e-004,  1.098749e-003,  1.429837e-003,  1.787303e-003,  2.186829e-003,  2.624918e-003,  3.090365e-003,  3.578799e-003,
   4.090701e-003,  4.624179e-003,  5.185787e-003,  5.766086e-003,  6.344665e-003,  6.932760e-003,  7.526280e-003,  8.115839e-003,  8.693244e-003,
   9.239771e-003,  9.772190e-003,  1.029266e-002,  1.081350e-002,  1.135100e-002,  1.187986e-002,  1.241125e-002,  1.294258e-002,  1.347139e-002,
   1.400196e-002,  1.451148e-002,  1.501099e-002,  1.549069e-002,  1.598339e-002,  1.649516e-002,  1.701565e-002,  1.755711e-002,  1.808801e-002,
   1.860392e-002,  1.911005e-002,  1.959061e-002,  2.004789e-002,  2.047338e-002,  2.086984e-002,  2.121310e-002,  2.151204e-002,  2.179053e-002,
   2.203184e-002,  2.224275e-002,  2.240821e-002,  2.254101e-002,  2.259524e-002,  2.260500e-002,  2.259319e-002,  2.253704e-002,  2.243576e-002,
   2.231657e-002,  2.215813e-002,  2.195189e-002,  2.170850e-002,  2.142237e-002,  2.109643e-002,  2.073096e-002,  2.033677e-002,  1.990054e-002,
   1.942159e-002,  1.890792e-002,  1.836862e-002,  1.779056e-002,  1.717282e-002,  1.653228e-002,  1.587155e-002,  1.517728e-002,  1.446302e-002,
   1.375210e-002,  1.302340e-002,  1.226644e-002,  1.150086e-002,  1.074547e-002,  1.000549e-002,  9.253581e-003,  8.522999e-003,  7.801707e-003,
   7.059598e-003,  6.353603e-003,  5.692258e-003,  5.043856e-003,  4.401581e-003,  3.795547e-003,  3.188180e-003,  2.595718e-003,  2.031507e-003,
   1.498770e-003,  9.651665e-004,  4.240185e-004,  -1.201551e-004, -6.916726e-004, -1.288413e-003, -1.901323e-003, -2.501959e-003, -3.120815e-003,
   -3.753148e-003, -4.397629e-003, -5.001226e-003, -5.587435e-003, -6.210333e-003, -6.966526e-003, -7.878422e-003, -8.935542e-003, -1.011580e-002,
   -1.136985e-002, -1.272470e-002, -1.414021e-002, -1.562536e-002, -1.717489e-002, -1.879780e-002, -2.045918e-002, -2.216300e-002, -2.390259e-002,
   -2.568639e-002, -2.748516e-002, -2.930914e-002, -3.111260e-002, -3.291103e-002, -3.468550e-002, -3.640377e-002, -3.809050e-002, -3.977118e-002,
   -4.142429e-002, -4.300137e-002, -4.450899e-002, -4.593934e-002, -4.725377e-002, -4.846852e-002, -4.955912e-002, -5.048918e-002, -5.128622e-002,
   -5.195803e-002, -5.252838e-002, -5.294701e-002, -5.321368e-002, -5.329822e-002, -5.314361e-002, -5.273527e-002, -5.210057e-002, -5.134556e-002,
   -5.052950e-002, -4.962850e-002, -4.866098e-002, -4.761244e-002, -4.651075e-002, -4.534712e-002, -4.415966e-002, -4.290235e-002, -4.158936e-002,
   -4.020965e-002, -3.874669e-002, -3.725596e-002, -3.579002e-002, -3.428820e-002, -3.275328e-002, -3.118744e-002, -2.957358e-002, -2.790267e-002,
   -2.622745e-002, -2.452074e-002, -2.278267e-002, -2.104753e-002, -1.932038e-002, -1.757531e-002, -1.583212e-002, -1.406981e-002, -1.223917e-002,
   -1.033164e-002, -8.374774e-003, -6.365209e-003, -4.336652e-003, -2.282602e-003, -1.808615e-004, 1.970489e-003,  4.128700e-003,  6.309519e-003,
   8.512354e-003,  1.077475e-002,  1.308374e-002,  1.540965e-002,  1.775649e-002,  2.010185e-002,  2.238316e-002,  2.463366e-002,  2.689072e-002,
   2.915634e-002,  3.139433e-002,  3.359466e-002,  3.570379e-002,  3.775920e-002,  3.975985e-002,  4.170336e-002,  4.358031e-002,  4.539872e-002,
   4.713158e-002,  4.875560e-002,  5.027912e-002,  5.157686e-002,  5.247656e-002,  5.300849e-002,  5.319464e-002,  5.303326e-002,  5.250785e-002,
   5.167433e-002,  5.056504e-002,  4.918997e-002,  4.753039e-002,  4.563479e-002,  4.350352e-002,  4.116075e-002,  3.863327e-002,  3.596173e-002,
   3.305089e-002,  3.000979e-002,  2.686306e-002,  2.366395e-002,  2.038668e-002,  1.704614e-002,  1.364654e-002,  1.024045e-002,  6.856643e-003,
   3.466348e-003,  5.875601e-005,  -3.307264e-003, -6.598334e-003, -9.749456e-003, -1.275693e-002, -1.561575e-002, -1.833906e-002, -2.099320e-002,
   -2.344960e-002, -2.568928e-002, -2.767122e-002, -2.937104e-002, -3.077514e-002, -3.191021e-002, -3.272843e-002, -3.317282e-002, -3.325608e-002,
   -3.330263e-002, -3.335122e-002, -3.336680e-002, -3.332552e-002, -3.315081e-002, -3.284741e-002, -3.245110e-002, -3.202930e-002, -3.153729e-002,
   -3.097497e-002, -3.041446e-002, -2.983495e-002, -2.917549e-002, -2.848900e-002, -2.774751e-002, -2.691547e-002, -2.601255e-002, -2.507773e-002,
   -2.408554e-002, -2.303801e-002, -2.199807e-002, -2.092559e-002, -1.982249e-002, -1.870107e-002, -1.752915e-002, -1.625157e-002, -1.487391e-002,
   -1.346619e-002, -1.207701e-002, -1.067574e-002, -9.251440e-003, -7.814469e-003, -6.327027e-003, -4.787390e-003, -3.271370e-003, -1.726254e-003,
   -1.529438e-004, 1.462697e-003,  3.100103e-003,  4.729046e-003,  6.355159e-003,  7.890779e-003,  9.468260e-003,  1.109560e-002,  1.273188e-002,
   1.440334e-002,  1.609472e-002,  1.777874e-002,  1.953474e-002,  2.128281e-002,  2.300867e-002,  2.457659e-002,  2.608889e-002,  2.758439e-002,
   2.898884e-002,  3.013536e-002,  3.113125e-002,  3.192459e-002,  3.254076e-002,  3.299312e-002,  3.323980e-002,  3.324899e-002,  3.304963e-002,
   3.274242e-002,  3.231826e-002,  3.173545e-002,  3.104721e-002,  3.024884e-002,  2.942498e-002,  2.852565e-002,  2.753117e-002,  2.642734e-002,
   2.515901e-002,  2.388345e-002,  2.264221e-002,  2.133101e-002,  2.004799e-002,  1.873219e-002,  1.739506e-002,  1.605337e-002,  1.476935e-002,
   1.347621e-002,  1.211635e-002,  1.079782e-002,  9.461802e-003,  8.207426e-003,  7.039309e-003,  5.953897e-003,  4.970915e-003,  4.002333e-003,
   3.137217e-003,  2.419656e-003,  1.695315e-003,  1.132315e-003,  7.089885e-004,  4.230986e-004,  2.533508e-004,  1.389238e-004,  4.120303e-005,
   -8.160652e-005, -1.890669e-004, -2.807092e-004, -3.917643e-004, -5.685651e-004, -6.709751e-004, -7.719697e-004, -8.905584e-004, -9.420413e-004,
   -9.454197e-004, -9.470350e-004, -9.538474e-004, -1.020428e-003, -1.211397e-003, -1.396753e-003, -1.547524e-003, -1.744936e-003, -1.939063e-003,
   -2.102766e-003, -2.227246e-003, -2.353098e-003, -2.536886e-003, -2.843572e-003, -3.147850e-003, -3.403881e-003, -3.615920e-003, -3.974689e-003,
   -4.360772e-003, -4.666655e-003, -4.852051e-003, -4.994405e-003, -5.125881e-003, -5.202605e-003, -5.283485e-003, -5.468525e-003, -5.613555e-003,
   -5.684059e-003, -5.746751e-003, -5.806051e-003, -5.833280e-003, -5.683889e-003, -5.516310e-003, -5.391907e-003, -5.476400e-003, -5.496997e-003,
   -5.390747e-003, -5.186210e-003, -5.102042e-003, -4.997250e-003, -4.799437e-003, -4.511355e-003, -4.243228e-003, -3.990894e-003, -3.717442e-003,
   -3.463521e-003, -3.274180e-003, -3.149733e-003, -3.002300e-003, -2.773586e-003, -2.546415e-003, -2.321648e-003, -2.113070e-003, -1.902433e-003,
   -1.703079e-003, -1.420173e-003, -1.027869e-003, -6.548129e-004, -3.697415e-004, -6.437482e-005, 2.957334e-004,  5.142775e-004,  6.624678e-004,
   8.875241e-004,  1.128183e-003,  1.207066e-003,  1.334665e-003,  1.469024e-003,  1.615944e-003,  1.793237e-003,  1.962123e-003,  2.097334e-003,
   1.976319e-003,  1.916191e-003,  1.953858e-003,  1.982340e-003,  1.976629e-003,  1.943095e-003,  1.992013e-003,  1.805357e-003,  1.625819e-003,
   1.451886e-003,  1.273445e-003,  9.913299e-004,  3.332435e-004,  -4.174300e-004, -1.007848e-003, -1.459722e-003, -2.014522e-003, -2.587113e-003,
   -3.178267e-003, -3.729888e-003, -4.364633e-003, -4.924820e-003, -5.338855e-003, -5.971534e-003, -6.563858e-003, -7.072349e-003, -7.496660e-003,
   -7.799408e-003, -8.023004e-003, -8.356203e-003, -8.492284e-003, -8.511378e-003, -8.718785e-003, -8.824603e-003, -8.655957e-003, -8.548967e-003,
   -8.601374e-003, -8.682815e-003, -8.587934e-003, -8.363263e-003, -8.268450e-003, -8.131185e-003, -7.797836e-003, -7.669833e-003, -7.531043e-003,
   -6.898948e-003, -6.383240e-003, -6.024343e-003, -5.441887e-003, -4.902526e-003, -4.239498e-003, -3.573383e-003, -2.902921e-003, -2.372178e-003,
   -1.871299e-003, -1.096393e-003, -1.208313e-004, 6.915064e-004,  1.528646e-003,  2.242243e-003,  2.605212e-003,  3.002374e-003,  2.825727e-003,
   2.567379e-003,  2.201180e-003,  1.899184e-003,  1.645488e-003,  1.401010e-003,  1.377255e-003,  1.031189e-003,  7.158648e-004,  6.046962e-004,
   3.416966e-004,  7.448484e-005,  -1.494720e-004, -2.331207e-004, -9.208803e-004, -1.125401e-003, -1.790668e-003, -2.287919e-003, -2.421438e-003,
   -2.348767e-003, -2.235243e-003, -1.627230e-003, -1.439908e-003, -9.333177e-004, -8.409756e-004, -4.811531e-004, 3.662682e-004,  1.376310e-003,
   2.673120e-003,  4.076369e-003,  5.600318e-003,  7.349060e-003,  9.409257e-003,  1.126075e-002,  1.276453e-002,  1.377358e-002,  1.477480e-002,
   1.533651e-002,  1.542818e-002,  1.577156e-002,  1.623779e-002,  1.640112e-002,  1.668012e-002,  1.737140e-002,  1.765654e-002,  1.732049e-002,
   1.720878e-002,  1.644030e-002,  1.618503e-002,  1.552297e-002,  1.510542e-002,  1.461779e-002,  1.340778e-002,  1.248509e-002,  1.133303e-002,
   9.203703e-003,  6.743065e-003,  4.084167e-003,  1.782272e-003,  -9.143943e-005, -1.704768e-003, -3.155441e-003, -6.513394e-003, -9.988042e-003,
   -1.324924e-002, -1.669170e-002, -1.864311e-002, -1.943906e-002, -1.893830e-002, -1.787968e-002, -1.663707e-002, -1.596578e-002, -1.553081e-002,
   -1.523850e-002, -1.571381e-002, -1.988256e-002, -2.293123e-002, -2.511904e-002, -2.397287e-002, -1.815730e-002, -1.279813e-002, -1.208478e-002,
   -1.477643e-002, -1.775459e-002, -1.935032e-002, -2.034986e-002, -1.999212e-002, -1.947548e-002, -1.878953e-002, -1.788303e-002, -1.265993e-002,
   -1.095196e-002, -1.054474e-002, -1.312532e-002, -1.248866e-002, -3.717453e-002, -3.313920e-002, -2.169731e-002, -8.489919e-003, 2.666525e-003,
   9.678586e-003,  1.382860e-002,  1.561125e-002,  2.100526e-002,  3.343839e-002,  7.193176e-001,  1.717793e-001,  -4.653494e-002, -1.186034e-001,
   -1.577868e-001, -1.799818e-001, -1.359648e-001, -1.210820e-001, -8.039277e-002, -4.017433e-002, 0.000000e+000},
  {0.000000e+000,  -8.314882e-003, -1.214427e-002, -1.397798e-002, -1.413916e-002, -1.309681e-002, -1.151897e-002, -1.011041e-002, -8.980506e-003,
   -8.291364e-003, -7.318111e-003, -6.200238e-003, -4.978476e-003, -3.524834e-003, -1.963995e-003, -1.493663e-004, 1.855671e-003,  4.097649e-003,
   6.638784e-003,  9.281093e-003,  1.215902e-002,  1.493508e-002,  1.751472e-002,  2.006816e-002,  2.256076e-002,  2.488330e-002,  2.710192e-002,
   2.923334e-002,  3.129733e-002,  3.329943e-002,  3.522162e-002,  3.683590e-002,  3.787682e-002,  3.861551e-002,  3.902013e-002,  3.907740e-002,
   3.877123e-002,  3.813095e-002,  3.714798e-002,  3.589837e-002,  3.435825e-002,  3.253388e-002,  3.003365e-002,  2.730811e-002,  2.438620e-002,
   2.131187e-002,  1.787936e-002,  1.373568e-002,  9.715030e-003,  6.595445e-003,  3.848081e-003,  1.239837e-003,  -1.560779e-003, -4.258007e-003,
   -6.819166e-003, -9.261151e-003, -1.161055e-002, -1.384680e-002, -1.598256e-002, -1.801644e-002, -1.992247e-002, -2.168721e-002, -2.355726e-002,
   -2.542837e-002, -2.716248e-002, -2.873893e-002, -3.012056e-002, -3.129400e-002, -3.220952e-002, -3.288944e-002, -3.330264e-002, -3.346114e-002,
   -3.343684e-002, -3.326852e-002, -3.272613e-002, -3.180066e-002, -3.050995e-002, -2.883626e-002, -2.693497e-002, -2.504219e-002, -2.338987e-002,
   -2.204601e-002, -2.108912e-002, -2.074267e-002, -2.070341e-002, -2.096347e-002, -2.149348e-002, -2.224218e-002, -2.326420e-002, -2.453805e-002,
   -2.599374e-002, -2.764303e-002, -2.942562e-002, -3.162062e-002, -3.389692e-002, -3.622675e-002, -3.858631e-002, -4.094184e-002, -4.325982e-002,
   -4.553865e-002, -4.777001e-002, -4.992242e-002, -5.197023e-002, -5.409171e-002, -5.614701e-002, -5.800829e-002, -5.962675e-002, -6.101010e-002,
   -6.209607e-002, -6.278338e-002, -6.304502e-002, -6.286673e-002, -6.235581e-002, -6.165680e-002, -6.083060e-002, -5.971815e-002, -5.827016e-002,
   -5.649870e-002, -5.438519e-002, -5.192937e-002, -4.919680e-002, -4.629389e-002, -4.335540e-002, -4.057667e-002, -3.830305e-002, -3.631731e-002,
   -3.455504e-002, -3.294236e-002, -3.140877e-002, -2.990113e-002, -2.837085e-002, -2.679649e-002, -2.514481e-002, -2.340962e-002, -2.182702e-002,
   -2.011859e-002, -1.824650e-002, -1.623305e-002, -1.402872e-002, -1.163013e-002, -9.020126e-003, -6.246486e-003, -3.309229e-003, -2.192636e-004,
   2.789408e-003,  5.838591e-003,  8.932708e-003,  1.198445e-002,  1.495843e-002,  1.783441e-002,  2.059369e-002,  2.325143e-002,  2.585189e-002,
   2.834079e-002,  3.061277e-002,  3.265585e-002,  3.453614e-002,  3.622958e-002,  3.778459e-002,  3.921485e-002,  4.056810e-002,  4.189163e-002,
   4.320668e-002,  4.455505e-002,  4.589989e-002,  4.719453e-002,  4.861365e-002,  5.025050e-002,  5.219569e-002,  5.445140e-002,  5.695403e-002,
   5.961118e-002,  6.232314e-002,  6.505968e-002,  6.782083e-002,  7.050828e-002,  7.336985e-002,  7.640868e-002,  7.958134e-002,  8.281435e-002,
   8.598961e-002,  8.896602e-002,  9.151284e-002,  9.353041e-002,  9.504628e-002,  9.599028e-002,  9.654441e-002,  9.674534e-002,  9.662923e-002,
   9.621510e-002,  9.550850e-002,  9.451984e-002,  9.326172e-002,  9.177010e-002,  9.005690e-002,  8.807237e-002,  8.588413e-002,  8.354767e-002,
   8.107459e-002,  7.847111e-002,  7.571886e-002,  7.283895e-002,  6.983660e-002,  6.675107e-002,  6.365252e-002,  6.055100e-002,  5.756604e-002,
   5.482386e-002,  5.242520e-002,  5.025176e-002,  4.820512e-002,  4.616262e-002,  4.406634e-002,  4.189831e-002,  3.967971e-002,  3.747421e-002,
   3.522984e-002,  3.312063e-002,  3.116928e-002,  2.934707e-002,  2.759782e-002,  2.578284e-002,  2.376928e-002,  2.143967e-002,  1.884987e-002,
   1.609959e-002,  1.323863e-002,  1.040292e-002,  7.617090e-003,  4.897678e-003,  2.249575e-003,  -3.418324e-004, -2.851178e-003, -5.278713e-003,
   -7.604864e-003, -9.845528e-003, -1.205778e-002, -1.420748e-002, -1.625914e-002, -1.816674e-002, -1.992295e-002, -2.149943e-002, -2.290515e-002,
   -2.408294e-002, -2.503741e-002, -2.575722e-002, -2.622308e-002, -2.630050e-002, -2.591947e-002, -2.519259e-002, -2.431060e-002, -2.345588e-002,
   -2.269295e-002, -2.208301e-002, -2.160905e-002, -2.125748e-002, -2.104131e-002, -2.097284e-002, -2.098350e-002, -2.107989e-002, -2.129818e-002,
   -2.164706e-002, -2.227338e-002, -2.313989e-002, -2.419430e-002, -2.538000e-002, -2.660868e-002, -2.790422e-002, -2.919309e-002, -3.045081e-002,
   -3.167193e-002, -3.282749e-002, -3.388024e-002, -3.478495e-002, -3.546696e-002, -3.591521e-002, -3.603301e-002, -3.589677e-002, -3.554882e-002,
   -3.502349e-002, -3.437739e-002, -3.359922e-002, -3.267848e-002, -3.160964e-002, -3.037386e-002, -2.896348e-002, -2.738427e-002, -2.569818e-002,
   -2.400701e-002, -2.249387e-002, -2.134164e-002, -2.060519e-002, -2.021226e-002, -2.005397e-002, -2.009856e-002, -2.033090e-002, -2.071513e-002,
   -2.123446e-002, -2.188884e-002, -2.265927e-002, -2.350648e-002, -2.441158e-002, -2.534408e-002, -2.630212e-002, -2.724218e-002, -2.816622e-002,
   -2.909401e-002, -3.002980e-002, -3.097580e-002, -3.191047e-002, -3.280690e-002, -3.368923e-002, -3.450088e-002, -3.514637e-002, -3.554622e-002,
   -3.564167e-002, -3.549832e-002, -3.517248e-002, -3.475900e-002, -3.434242e-002, -3.395669e-002, -3.363093e-002, -3.335363e-002, -3.307163e-002,
   -3.279399e-002, -3.245230e-002, -3.204050e-002, -3.160042e-002, -3.119661e-002, -3.091458e-002, -3.091207e-002, -3.111855e-002, -3.154078e-002,
   -3.206652e-002, -3.264087e-002, -3.325962e-002, -3.386915e-002, -3.443535e-002, -3.493568e-002, -3.532038e-002, -3.559964e-002, -3.569686e-002,
   -3.560904e-002, -3.526085e-002, -3.467062e-002, -3.378925e-002, -3.255760e-002, -3.092663e-002, -2.891186e-002, -2.651421e-002, -2.371395e-002,
   -2.066204e-002, -1.757159e-002, -1.472297e-002, -1.222191e-002, -1.005326e-002, -8.248768e-003, -6.781584e-003, -5.643017e-003, -4.762886e-003,
   -4.144187e-003, -3.743104e-003, -3.508253e-003, -3.482403e-003, -3.583149e-003, -3.757692e-003, -3.982184e-003, -4.238290e-003, -4.520016e-003,
   -4.797167e-003, -5.100102e-003, -5.407131e-003, -5.703626e-003, -6.003890e-003, -6.262524e-003, -6.472473e-003, -6.622646e-003, -6.685760e-003,
   -6.688536e-003, -6.586974e-003, -6.433897e-003, -6.272620e-003, -6.148543e-003, -6.000292e-003, -5.851127e-003, -5.688492e-003, -5.515025e-003,
   -5.365348e-003, -5.253670e-003, -5.233729e-003, -5.378289e-003, -5.721915e-003, -6.244067e-003, -6.861522e-003, -7.521404e-003, -8.229376e-003,
   -8.938164e-003, -9.639608e-003, -1.037826e-002, -1.114131e-002, -1.190155e-002, -1.265114e-002, -1.336198e-002, -1.405424e-002, -1.469614e-002,
   -1.523767e-002, -1.567995e-002, -1.598066e-002, -1.610669e-002, -1.605403e-002, -1.579472e-002, -1.526666e-002, -1.450323e-002, -1.351015e-002,
   -1.227650e-002, -1.088386e-002, -9.349970e-003, -7.667860e-003, -5.879824e-003, -4.023490e-003, -2.132192e-003, -2.948683e-004, 1.468337e-003,
   3.172856e-003,  4.791685e-003,  6.367505e-003,  7.874745e-003,  9.267990e-003,  1.052197e-002,  1.154567e-002,  1.237899e-002,  1.301110e-002,
   1.350593e-002,  1.392912e-002,  1.430485e-002,  1.463437e-002,  1.495012e-002,  1.529638e-002,  1.571025e-002,  1.623413e-002,  1.698895e-002,
   1.802890e-002,  1.941257e-002,  2.100582e-002,  2.269359e-002,  2.434218e-002,  2.593060e-002,  2.747632e-002,  2.905885e-002,  3.077923e-002,
   3.271724e-002,  3.484808e-002,  3.716065e-002,  3.955898e-002,  4.188621e-002,  4.387398e-002,  4.532203e-002,  4.621289e-002,  4.671138e-002,
   4.694314e-002,  4.689775e-002,  4.667432e-002,  4.625877e-002,  4.564761e-002,  4.489984e-002,  4.401184e-002,  4.300108e-002,  4.191434e-002,
   4.077846e-002,  3.961095e-002,  3.840836e-002,  3.719403e-002,  3.594599e-002,  3.468220e-002,  3.336849e-002,  3.202811e-002,  3.062517e-002,
   2.921073e-002,  2.774179e-002,  2.625490e-002,  2.476858e-002,  2.331878e-002,  2.190560e-002,  2.055339e-002,  1.929193e-002,  1.811844e-002,
   1.705694e-002,  1.614760e-002,  1.549043e-002,  1.504321e-002,  1.476662e-002,  1.465042e-002,  1.464435e-002,  1.475299e-002,  1.497324e-002,
   1.528604e-002,  1.573754e-002,  1.633743e-002,  1.705884e-002,  1.782093e-002,  1.856909e-002,  1.918381e-002,  1.970306e-002,  2.012915e-002,
   2.043581e-002,  2.061432e-002,  2.065430e-002,  2.049266e-002,  2.020329e-002,  1.978998e-002,  1.929382e-002,  1.873926e-002,  1.814392e-002,
   1.758190e-002,  1.704201e-002,  1.656703e-002,  1.618391e-002,  1.596274e-002,  1.593947e-002,  1.622842e-002,  1.688612e-002,  1.795864e-002,
   1.932105e-002,  2.078411e-002,  2.212645e-002,  2.331804e-002,  2.432497e-002,  2.509072e-002,  2.559407e-002,  2.584017e-002,  2.588234e-002,
   2.570999e-002,  2.527885e-002,  2.466548e-002,  2.377324e-002,  2.254496e-002,  2.097669e-002,  1.913314e-002,  1.713211e-002,  1.500224e-002,
   1.279031e-002,  1.054430e-002,  8.280434e-003,  6.037589e-003,  3.860073e-003,  1.795740e-003,  -1.577306e-004, -1.922859e-003, -3.403175e-003,
   -4.518631e-003, -5.401236e-003, -6.026843e-003, -6.433284e-003, -6.669949e-003, -6.827662e-003, -6.929924e-003, -6.978719e-003, -6.977192e-003,
   -6.922183e-003, -6.766523e-003, -6.498726e-003, -6.204775e-003, -5.976846e-003, -5.787163e-003, -5.737284e-003, -5.875624e-003, -6.243593e-003,
   -6.704881e-003, -7.218633e-003, -7.761482e-003, -8.308928e-003, -8.832836e-003, -9.358152e-003, -9.899875e-003, -1.041207e-002, -1.091565e-002,
   -1.139323e-002, -1.185717e-002, -1.226977e-002, -1.263671e-002, -1.291934e-002, -1.312766e-002, -1.323335e-002, -1.324545e-002, -1.309801e-002,
   -1.278512e-002, -1.231110e-002, -1.160575e-002, -1.055649e-002, -9.040379e-003, -7.131954e-003, -5.092515e-003, -3.142014e-003, -1.411262e-003,
   -1.898454e-005, 1.038535e-003,  1.809495e-003,  2.334536e-003,  2.670320e-003,  2.918828e-003,  3.097227e-003,  3.131980e-003,  2.975484e-003,
   2.421463e-003,  1.398257e-003,  -4.873895e-006, -1.628040e-003, -3.457387e-003, -5.434670e-003, -7.517325e-003, -9.618603e-003, -1.176228e-002,
   -1.388537e-002, -1.593838e-002, -1.783532e-002, -1.953999e-002, -2.103217e-002, -2.224965e-002, -2.316859e-002, -2.377240e-002, -2.403690e-002,
   -2.393815e-002, -2.349852e-002, -2.269220e-002, -2.162039e-002, -2.067846e-002, -2.002139e-002, -1.967569e-002, -1.965994e-002, -2.004818e-002,
   -2.075769e-002, -2.171009e-002, -2.298889e-002, -2.458415e-002, -2.636054e-002, -2.837136e-002, -3.061276e-002, -3.300283e-002, -3.546464e-002,
   -3.799923e-002, -4.056122e-002, -4.313535e-002, -4.567395e-002, -4.814676e-002, -5.059900e-002, -5.300078e-002, -5.535863e-002, -5.761134e-002,
   -5.975373e-002, -6.178706e-002, -6.369728e-002, -6.547494e-002, -6.703842e-002, -6.838506e-002, -6.945415e-002, -7.015620e-002, -7.043717e-002,
   -7.028019e-002, -6.974489e-002, -6.891711e-002, -6.774633e-002, -6.628096e-002, -6.442102e-002, -6.214798e-002, -5.942604e-002, -5.630268e-002,
   -5.296826e-002, -4.943303e-002, -4.585925e-002, -4.239875e-002, -3.923106e-002, -3.645276e-002, -3.394769e-002, -3.168728e-002, -2.966857e-002,
   -2.778969e-002, -2.602952e-002, -2.439461e-002, -2.283418e-002, -2.132982e-002, -1.986217e-002, -1.842977e-002, -1.698172e-002, -1.550134e-002,
   -1.395901e-002, -1.235353e-002, -1.070910e-002, -9.023296e-003, -7.291271e-003, -5.479705e-003, -3.557488e-003, -1.549658e-003, 5.564255e-004,
   2.802747e-003,  5.260800e-003,  8.048814e-003,  1.107766e-002,  1.423207e-002,  1.751106e-002,  2.088465e-002,  2.421389e-002,  2.744676e-002,
   3.053203e-002,  3.355952e-002,  3.656980e-002,  3.956623e-002,  4.250432e-002,  4.527695e-002,  4.785232e-002,  5.018729e-002,  5.219569e-002,
   5.378229e-002,  5.509735e-002,  5.615218e-002,  5.700265e-002,  5.776914e-002,  5.844216e-002,  5.890537e-002,  5.927925e-002,  5.969945e-002,
   6.003172e-002,  6.016181e-002,  6.028092e-002,  6.035480e-002,  6.033611e-002,  6.029416e-002,  6.015561e-002,  5.980664e-002,  5.932148e-002,
   5.878442e-002,  5.820905e-002,  5.755276e-002,  5.693183e-002,  5.621960e-002,  5.537998e-002,  5.439386e-002,  5.319016e-002,  5.171648e-002,
   4.995683e-002,  4.808044e-002,  4.600721e-002,  4.371623e-002,  4.131488e-002,  3.879353e-002,  3.618073e-002,  3.354653e-002,  3.087554e-002,
   2.820287e-002,  2.552823e-002,  2.300020e-002,  2.061985e-002,  1.843862e-002,  1.661689e-002,  1.515581e-002,  1.419155e-002,  1.382657e-002,
   1.390681e-002,  1.420661e-002,  1.443051e-002,  1.464489e-002,  1.489214e-002,  1.511864e-002,  1.538845e-002,  1.549986e-002,  1.559736e-002,
   1.568372e-002,  1.566740e-002,  1.547274e-002,  1.488800e-002,  1.384174e-002,  1.251158e-002,  1.098287e-002,  9.305562e-003,  7.634180e-003,
   5.882303e-003,  4.124550e-003,  2.414411e-003,  9.042916e-004,  -6.399725e-004, -2.225526e-003, -3.588092e-003, -4.781813e-003, -5.680894e-003,
   -6.299279e-003, -6.759759e-003, -6.858433e-003, -6.624373e-003, -6.111911e-003, -5.312695e-003, -4.321593e-003, -3.191453e-003, -2.037281e-003,
   -1.008249e-003, -2.991145e-004, 1.688053e-004,  4.623919e-004,  4.929528e-004,  2.101769e-004,  -1.499626e-004, -8.580950e-004, -1.803943e-003,
   -2.933338e-003, -4.197170e-003, -5.620194e-003, -7.051558e-003, -8.564941e-003, -1.012789e-002, -1.168095e-002, -1.335022e-002, -1.527070e-002,
   -1.714455e-002, -1.887578e-002, -2.065887e-002, -2.243261e-002, -2.412717e-002, -2.576599e-002, -2.728908e-002, -2.868775e-002, -3.001662e-002,
   -3.111974e-002, -3.200917e-002, -3.268664e-002, -3.293811e-002, -3.271042e-002, -3.227955e-002, -3.167055e-002, -3.099527e-002, -3.023967e-002,
   -2.946364e-002, -2.883664e-002, -2.827613e-002, -2.768670e-002, -2.699441e-002, -2.621280e-002, -2.543866e-002, -2.468854e-002, -2.396084e-002,
   -2.358775e-002, -2.353090e-002, -2.367776e-002, -2.414825e-002, -2.455431e-002, -2.492611e-002, -2.542570e-002, -2.584717e-002, -2.618143e-002,
   -2.657014e-002, -2.672536e-002, -2.668475e-002, -2.649623e-002, -2.596728e-002, -2.523371e-002, -2.421047e-002, -2.288739e-002, -2.117055e-002,
   -1.919119e-002, -1.690636e-002, -1.424532e-002, -1.136749e-002, -8.438141e-003, -5.633368e-003, -3.264368e-003, -1.086725e-003, 8.744862e-004,
   2.453987e-003,  3.858068e-003,  4.934877e-003,  5.606505e-003,  6.149258e-003,  6.458543e-003,  6.702346e-003,  6.885592e-003,  6.829033e-003,
   6.761415e-003,  6.585951e-003,  6.407147e-003,  6.252599e-003,  5.978161e-003,  5.754342e-003,  5.686486e-003,  5.486184e-003,  5.192213e-003,
   4.963796e-003,  4.778872e-003,  4.625216e-003,  4.378029e-003,  4.127960e-003,  4.111922e-003,  4.423410e-003,  4.719645e-003,  5.271957e-003,
   5.848503e-003,  6.608577e-003,  7.447792e-003,  8.264125e-003,  9.329361e-003,  1.036227e-002,  1.148208e-002,  1.272198e-002,  1.392730e-002,
   1.523307e-002,  1.651988e-002,  1.756538e-002,  1.857606e-002,  1.933851e-002,  2.012837e-002,  2.090279e-002,  2.158067e-002,  2.232188e-002,
   2.321189e-002,  2.412642e-002,  2.491838e-002,  2.537833e-002,  2.584297e-002,  2.605452e-002,  2.625767e-002,  2.637555e-002,  2.682653e-002,
   2.737885e-002,  2.769306e-002,  2.807710e-002,  2.821182e-002,  2.825533e-002,  2.816799e-002,  2.776007e-002,  2.696080e-002,  2.596051e-002,
   2.478514e-002,  2.332095e-002,  2.184115e-002,  2.000287e-002,  1.816172e-002,  1.596944e-002,  1.358374e-002,  1.120211e-002,  8.664961e-003,
   5.983523e-003,  3.163603e-003,  4.066898e-004,  -2.468366e-003, -5.420400e-003, -8.539890e-003, -1.197731e-002, -1.535054e-002, -1.876234e-002,
   -2.190554e-002, -2.490533e-002, -2.746909e-002, -2.949696e-002, -3.100798e-002, -3.234805e-002, -3.376502e-002, -3.521267e-002, -3.655737e-002,
   -3.755129e-002, -3.798594e-002, -3.814980e-002, -3.766012e-002, -3.673401e-002, -3.554442e-002, -3.384875e-002, -3.174523e-002, -2.978311e-002,
   -2.831105e-002, -2.634376e-002, -2.417503e-002, -2.189795e-002, -1.971832e-002, -1.733827e-002, -1.479952e-002, -1.190572e-002, -9.089458e-003,
   -5.965177e-003, -3.967650e-003, -1.836910e-003, 1.753282e-004,  2.221123e-003,  4.001362e-003,  5.826173e-003,  7.536525e-003,  9.343409e-003,
   1.124509e-002,  1.283287e-002,  1.300477e-002,  1.271599e-002,  1.322069e-002,  1.423961e-002,  1.616196e-002,  1.834366e-002,  1.963333e-002,
   2.057535e-002,  2.138029e-002,  2.299162e-002,  2.249253e-002,  2.096949e-002,  1.904116e-002,  1.717823e-002,  1.503418e-002,  1.307222e-002,
   1.083819e-002,  9.001618e-003,  6.873305e-003,  5.226429e-003,  1.534100e-002,  1.221989e-002,  8.999945e-003,  5.091102e-003,  -4.323942e-005,
   -5.375925e-003, -1.199750e-002, -2.052476e-002, -3.024706e-002, -3.914775e-002, 1.101606e-002,  2.761208e-002,  1.422365e-002,  -5.480630e-003,
   -2.120639e-002, -3.316217e-002, -1.433359e-002, -1.164899e-002, -9.080894e-003, -6.215513e-003, 0.000000e+000},
  {0.000000e+000,  1.501404e-002,  2.675527e-002,  3.614956e-002,  4.362018e-002,  4.952670e-002,  5.395076e-002,  5.653874e-002,  5.741402e-002,
   5.695936e-002,  5.601914e-002,  5.467730e-002,  5.283976e-002,  5.055186e-002,  4.795155e-002,  4.518244e-002,  4.220474e-002,  3.939714e-002,
   3.677121e-002,  3.428768e-002,  3.182600e-002,  2.956258e-002,  2.756989e-002,  2.562994e-002,  2.367399e-002,  2.175405e-002,  1.990211e-002,
   1.816895e-002,  1.657333e-002,  1.515477e-002,  1.383215e-002,  1.267713e-002,  1.172603e-002,  1.080093e-002,  9.968298e-003,  9.196439e-003,
   8.456928e-003,  7.789885e-003,  7.068752e-003,  6.390930e-003,  5.696381e-003,  4.937290e-003,  4.279773e-003,  3.423816e-003,  2.398301e-003,
   1.156128e-003,  -5.018710e-004, -3.024583e-003, -5.513283e-003, -7.161650e-003, -8.547121e-003, -9.871581e-003, -1.099641e-002, -1.203447e-002,
   -1.312868e-002, -1.421610e-002, -1.530593e-002, -1.643958e-002, -1.756278e-002, -1.873203e-002, -1.986257e-002, -2.101171e-002, -2.204744e-002,
   -2.295460e-002, -2.387843e-002, -2.473667e-002, -2.552750e-002, -2.626305e-002, -2.696421e-002, -2.750113e-002, -2.798513e-002, -2.836832e-002,
   -2.844781e-002, -2.816556e-002, -2.769364e-002, -2.696063e-002, -2.597773e-002, -2.479971e-002, -2.345834e-002, -2.209589e-002, -2.090948e-002,
   -1.993992e-002, -1.919768e-002, -1.845367e-002, -1.795031e-002, -1.763024e-002, -1.750450e-002, -1.753807e-002, -1.774282e-002, -1.812573e-002,
   -1.861620e-002, -1.920470e-002, -1.987274e-002, -2.039575e-002, -2.094707e-002, -2.149221e-002, -2.206314e-002, -2.263581e-002, -2.312161e-002,
   -2.358774e-002, -2.394426e-002, -2.425846e-002, -2.444571e-002, -2.442703e-002, -2.432448e-002, -2.418371e-002, -2.393621e-002, -2.358707e-002,
   -2.313662e-002, -2.255561e-002, -2.186833e-002, -2.094038e-002, -1.987396e-002, -1.870086e-002, -1.742380e-002, -1.608475e-002, -1.467237e-002,
   -1.313648e-002, -1.150959e-002, -9.858806e-003, -8.139649e-003, -6.369735e-003, -4.751138e-003, -3.385411e-003, -2.299906e-003, -1.593823e-003,
   -1.149227e-003, -9.120278e-004, -8.978519e-004, -1.024928e-003, -1.241544e-003, -1.520014e-003, -1.770416e-003, -2.054056e-003, -2.307042e-003,
   -2.523748e-003, -2.685209e-003, -2.777543e-003, -2.737716e-003, -2.597001e-003, -2.359466e-003, -2.010643e-003, -1.557876e-003, -1.010198e-003,
   -3.897581e-004, 2.810318e-004,  9.788746e-004,  1.643854e-003,  2.244357e-003,  2.753310e-003,  3.195241e-003,  3.543008e-003,  3.852893e-003,
   4.081177e-003,  4.227028e-003,  4.240224e-003,  4.165085e-003,  3.935951e-003,  3.579394e-003,  3.136642e-003,  2.627024e-003,  2.068571e-003,
   1.488772e-003,  9.037743e-004,  3.213221e-004,  -2.585471e-004, -7.696606e-004, -1.140207e-003, -1.319012e-003, -1.296010e-003, -1.124094e-003,
   -8.652310e-004, -5.953430e-004, -2.786981e-004, 9.548847e-005,  5.218224e-004,  1.097731e-003,  1.814202e-003,  2.698970e-003,  3.694862e-003,
   4.719930e-003,  5.665967e-003,  6.472175e-003,  7.033085e-003,  7.370574e-003,  7.517428e-003,  7.587684e-003,  7.651691e-003,  7.686221e-003,
   7.750179e-003,  7.821939e-003,  7.893558e-003,  7.985629e-003,  8.146011e-003,  8.360299e-003,  8.591294e-003,  8.876246e-003,  9.258850e-003,
   9.721485e-003,  1.027418e-002,  1.090728e-002,  1.163656e-002,  1.244671e-002,  1.331377e-002,  1.428332e-002,  1.528764e-002,  1.640246e-002,
   1.771791e-002,  1.929181e-002,  2.103055e-002,  2.284942e-002,  2.465255e-002,  2.637460e-002,  2.800776e-002,  2.954945e-002,  3.104880e-002,
   3.246117e-002,  3.393016e-002,  3.545474e-002,  3.697662e-002,  3.842416e-002,  3.970082e-002,  4.076453e-002,  4.154567e-002,  4.205222e-002,
   4.233808e-002,  4.237306e-002,  4.228097e-002,  4.209667e-002,  4.184300e-002,  4.153341e-002,  4.118159e-002,  4.077671e-002,  4.029475e-002,
   3.973094e-002,  3.911119e-002,  3.837536e-002,  3.757707e-002,  3.677392e-002,  3.597934e-002,  3.522889e-002,  3.454251e-002,  3.391512e-002,
   3.339691e-002,  3.298252e-002,  3.271453e-002,  3.256114e-002,  3.262468e-002,  3.299840e-002,  3.361594e-002,  3.432675e-002,  3.501847e-002,
   3.559857e-002,  3.606495e-002,  3.638453e-002,  3.660566e-002,  3.669078e-002,  3.659997e-002,  3.644165e-002,  3.620303e-002,  3.581695e-002,
   3.530073e-002,  3.454154e-002,  3.359402e-002,  3.247423e-002,  3.121280e-002,  2.988042e-002,  2.834887e-002,  2.677186e-002,  2.516195e-002,
   2.354025e-002,  2.193807e-002,  2.035768e-002,  1.881712e-002,  1.739637e-002,  1.610358e-002,  1.500777e-002,  1.394765e-002,  1.297859e-002,
   1.209973e-002,  1.127062e-002,  1.049872e-002,  9.756006e-003,  9.071597e-003,  8.473033e-003,  7.969857e-003,  7.566724e-003,  7.150943e-003,
   6.666785e-003,  6.039938e-003,  5.140593e-003,  3.895992e-003,  2.406961e-003,  7.469011e-004,  -1.041623e-003, -2.944114e-003, -4.913780e-003,
   -7.004366e-003, -9.231060e-003, -1.151712e-002, -1.383589e-002, -1.611668e-002, -1.835416e-002, -2.056037e-002, -2.267186e-002, -2.472291e-002,
   -2.666821e-002, -2.851262e-002, -3.042286e-002, -3.227740e-002, -3.401621e-002, -3.564719e-002, -3.712836e-002, -3.840162e-002, -3.943143e-002,
   -4.015906e-002, -4.061689e-002, -4.080478e-002, -4.093799e-002, -4.100624e-002, -4.108497e-002, -4.114607e-002, -4.121089e-002, -4.119559e-002,
   -4.113674e-002, -4.099912e-002, -4.081530e-002, -4.060031e-002, -4.047009e-002, -4.044096e-002, -4.059466e-002, -4.091997e-002, -4.138339e-002,
   -4.193076e-002, -4.247934e-002, -4.304657e-002, -4.360595e-002, -4.414040e-002, -4.466472e-002, -4.516735e-002, -4.561147e-002, -4.592835e-002,
   -4.609937e-002, -4.608153e-002, -4.587538e-002, -4.542647e-002, -4.471680e-002, -4.372593e-002, -4.245173e-002, -4.100314e-002, -3.930093e-002,
   -3.737867e-002, -3.542577e-002, -3.360832e-002, -3.198355e-002, -3.056659e-002, -2.937924e-002, -2.840959e-002, -2.762898e-002, -2.713571e-002,
   -2.680452e-002, -2.659911e-002, -2.647545e-002, -2.644631e-002, -2.647749e-002, -2.653655e-002, -2.660343e-002, -2.660998e-002, -2.658651e-002,
   -2.661561e-002, -2.668029e-002, -2.672568e-002, -2.671498e-002, -2.661871e-002, -2.647780e-002, -2.626927e-002, -2.599711e-002, -2.560102e-002,
   -2.511724e-002, -2.454556e-002, -2.396242e-002, -2.332751e-002, -2.268531e-002, -2.199295e-002, -2.120769e-002, -2.040313e-002, -1.959211e-002,
   -1.876967e-002, -1.796737e-002, -1.723923e-002, -1.669583e-002, -1.629057e-002, -1.598547e-002, -1.572655e-002, -1.547378e-002, -1.521097e-002,
   -1.495160e-002, -1.469595e-002, -1.443602e-002, -1.421582e-002, -1.412983e-002, -1.406643e-002, -1.397346e-002, -1.385340e-002, -1.371613e-002,
   -1.351691e-002, -1.325837e-002, -1.290921e-002, -1.245218e-002, -1.190698e-002, -1.131765e-002, -1.057798e-002, -9.695734e-003, -8.675923e-003,
   -7.522610e-003, -6.268031e-003, -4.944671e-003, -3.579427e-003, -2.176625e-003, -7.733236e-004, 5.722445e-004,  1.852179e-003,  3.053172e-003,
   4.209109e-003,  5.296903e-003,  6.298534e-003,  7.253376e-003,  8.138786e-003,  8.932026e-003,  9.604197e-003,  1.007843e-002,  1.034744e-002,
   1.052302e-002,  1.068282e-002,  1.086930e-002,  1.105497e-002,  1.128185e-002,  1.152960e-002,  1.180641e-002,  1.221662e-002,  1.279886e-002,
   1.352489e-002,  1.454168e-002,  1.573280e-002,  1.706084e-002,  1.842875e-002,  1.978448e-002,  2.112174e-002,  2.254353e-002,  2.412879e-002,
   2.588876e-002,  2.774566e-002,  2.978064e-002,  3.192346e-002,  3.401088e-002,  3.591440e-002,  3.744643e-002,  3.856027e-002,  3.944359e-002,
   4.017912e-002,  4.069773e-002,  4.100396e-002,  4.116275e-002,  4.123460e-002,  4.119629e-002,  4.107694e-002,  4.088190e-002,  4.056714e-002,
   4.021147e-002,  3.986857e-002,  3.948005e-002,  3.900581e-002,  3.845351e-002,  3.783716e-002,  3.716798e-002,  3.644569e-002,  3.562307e-002,
   3.469138e-002,  3.365634e-002,  3.256613e-002,  3.149847e-002,  3.038090e-002,  2.916939e-002,  2.799506e-002,  2.687474e-002,  2.577440e-002,
   2.472889e-002,  2.377324e-002,  2.294498e-002,  2.224729e-002,  2.167081e-002,  2.116315e-002,  2.064505e-002,  2.020041e-002,  1.978367e-002,
   1.940349e-002,  1.910798e-002,  1.893308e-002,  1.881528e-002,  1.866138e-002,  1.852537e-002,  1.834058e-002,  1.804102e-002,  1.763313e-002,
   1.719802e-002,  1.667923e-002,  1.602037e-002,  1.528232e-002,  1.448103e-002,  1.355136e-002,  1.259286e-002,  1.161682e-002,  1.062728e-002,
   9.596208e-003,  8.605518e-003,  7.668865e-003,  6.812864e-003,  6.096071e-003,  5.571371e-003,  5.309490e-003,  5.300141e-003,  5.588711e-003,
   6.107579e-003,  6.724874e-003,  7.262687e-003,  7.723409e-003,  8.099186e-003,  8.292989e-003,  8.284691e-003,  8.201897e-003,  8.059779e-003,
   7.800365e-003,  7.400955e-003,  6.847416e-003,  6.074136e-003,  5.070236e-003,  3.865899e-003,  2.505067e-003,  1.060338e-003,  -4.681771e-004,
   -2.082808e-003, -3.793828e-003, -5.516300e-003, -7.247917e-003, -8.953507e-003, -1.063524e-002, -1.227864e-002, -1.383796e-002, -1.517912e-002,
   -1.617843e-002, -1.701948e-002, -1.773273e-002, -1.825447e-002, -1.873320e-002, -1.919589e-002, -1.962354e-002, -1.998354e-002, -2.041876e-002,
   -2.081455e-002, -2.103727e-002, -2.118270e-002, -2.133251e-002, -2.145151e-002, -2.161301e-002, -2.200201e-002, -2.251142e-002, -2.313208e-002,
   -2.381234e-002, -2.446862e-002, -2.509654e-002, -2.576868e-002, -2.647903e-002, -2.723871e-002, -2.795656e-002, -2.872925e-002, -2.948776e-002,
   -3.019841e-002, -3.092551e-002, -3.161750e-002, -3.233383e-002, -3.292437e-002, -3.335930e-002, -3.370382e-002, -3.393837e-002, -3.413667e-002,
   -3.417657e-002, -3.405492e-002, -3.362960e-002, -3.288873e-002, -3.170337e-002, -3.010884e-002, -2.830774e-002, -2.651975e-002, -2.473055e-002,
   -2.299301e-002, -2.132492e-002, -1.974036e-002, -1.817932e-002, -1.661511e-002, -1.494371e-002, -1.313860e-002, -1.127152e-002, -9.419480e-003,
   -7.830693e-003, -6.508062e-003, -5.380248e-003, -4.346038e-003, -3.231614e-003, -2.047696e-003, -8.816118e-004, 2.069530e-004,  1.366026e-003,
   2.575400e-003,  3.808420e-003,  5.119838e-003,  6.466931e-003,  7.928078e-003,  9.568137e-003,  1.142905e-002,  1.344670e-002,  1.566934e-002,
   1.809514e-002,  2.065702e-002,  2.334654e-002,  2.613439e-002,  2.870720e-002,  3.098371e-002,  3.290708e-002,  3.450315e-002,  3.566950e-002,
   3.637615e-002,  3.676933e-002,  3.696048e-002,  3.668672e-002,  3.607253e-002,  3.517382e-002,  3.394396e-002,  3.243441e-002,  3.075917e-002,
   2.896066e-002,  2.704964e-002,  2.503045e-002,  2.298467e-002,  2.081959e-002,  1.858409e-002,  1.618575e-002,  1.367976e-002,  1.121953e-002,
   8.795286e-003,  6.472796e-003,  4.172173e-003,  1.976641e-003,  -5.328337e-005, -1.925131e-003, -3.636096e-003, -5.099034e-003, -6.423456e-003,
   -7.478137e-003, -8.250317e-003, -8.670337e-003, -8.867427e-003, -8.804187e-003, -8.389072e-003, -7.754179e-003, -6.838496e-003, -5.609708e-003,
   -4.460076e-003, -3.136346e-003, -1.803560e-003, -5.954180e-004, 3.657056e-004,  1.003278e-003,  1.483799e-003,  1.725659e-003,  1.789930e-003,
   1.742922e-003,  1.292404e-003,  7.691100e-004,  1.546144e-004,  -4.415753e-004, -1.043009e-003, -1.599019e-003, -2.104413e-003, -2.540090e-003,
   -2.959674e-003, -3.316073e-003, -3.719601e-003, -4.145118e-003, -4.518890e-003, -4.757048e-003, -4.850624e-003, -4.911240e-003, -4.766399e-003,
   -4.428469e-003, -3.895926e-003, -3.141637e-003, -2.264484e-003, -1.384009e-003, -2.801248e-004, 8.829345e-004,  2.141843e-003,  3.374391e-003,
   4.554040e-003,  5.743581e-003,  7.032032e-003,  8.356266e-003,  9.618950e-003,  1.067662e-002,  1.160083e-002,  1.246626e-002,  1.315464e-002,
   1.357332e-002,  1.387637e-002,  1.411984e-002,  1.437675e-002,  1.465594e-002,  1.484617e-002,  1.460485e-002,  1.437275e-002,  1.427242e-002,
   1.411926e-002,  1.372761e-002,  1.335066e-002,  1.279202e-002,  1.222752e-002,  1.157621e-002,  1.076035e-002,  9.381629e-003,  8.009808e-003,
   6.781207e-003,  5.529658e-003,  4.186819e-003,  2.751348e-003,  1.133561e-003,  -5.333343e-004, -2.076137e-003, -3.762820e-003, -5.875053e-003,
   -8.421414e-003, -1.102940e-002, -1.360039e-002, -1.632884e-002, -1.923733e-002, -2.214881e-002, -2.502928e-002, -2.757689e-002, -3.021137e-002,
   -3.305707e-002, -3.619807e-002, -3.907154e-002, -4.172068e-002, -4.422352e-002, -4.627127e-002, -4.779479e-002, -4.876994e-002, -4.898738e-002,
   -4.885023e-002, -4.838706e-002, -4.826726e-002, -4.783396e-002, -4.733132e-002, -4.657461e-002, -4.543613e-002, -4.433107e-002, -4.289528e-002,
   -4.135788e-002, -3.990491e-002, -3.863572e-002, -3.778555e-002, -3.705567e-002, -3.638005e-002, -3.554519e-002, -3.469835e-002, -3.373414e-002,
   -3.265153e-002, -3.151729e-002, -3.024103e-002, -2.872420e-002, -2.746105e-002, -2.622725e-002, -2.481369e-002, -2.324112e-002, -2.141199e-002,
   -1.918223e-002, -1.665116e-002, -1.390624e-002, -1.102733e-002, -7.823725e-003, -4.397689e-003, -1.394234e-003, 1.874586e-003,  5.247523e-003,
   8.825730e-003,  1.214821e-002,  1.543379e-002,  1.831574e-002,  2.101968e-002,  2.358845e-002,  2.614027e-002,  2.772117e-002,  2.909679e-002,
   3.037257e-002,  3.144348e-002,  3.232040e-002,  3.294138e-002,  3.362637e-002,  3.420778e-002,  3.495432e-002,  3.571228e-002,  3.572251e-002,
   3.553804e-002,  3.545613e-002,  3.516768e-002,  3.491466e-002,  3.472392e-002,  3.439878e-002,  3.427980e-002,  3.441678e-002,  3.462475e-002,
   3.444321e-002,  3.400219e-002,  3.412091e-002,  3.471550e-002,  3.553293e-002,  3.639727e-002,  3.743272e-002,  3.858050e-002,  3.981307e-002,
   4.101958e-002,  4.198502e-002,  4.221974e-002,  4.242649e-002,  4.266842e-002,  4.308569e-002,  4.358844e-002,  4.393469e-002,  4.419350e-002,
   4.430443e-002,  4.418491e-002,  4.401873e-002,  4.279920e-002,  4.155245e-002,  4.020462e-002,  3.871430e-002,  3.728169e-002,  3.589779e-002,
   3.468428e-002,  3.374872e-002,  3.265843e-002,  3.168782e-002,  2.994301e-002,  2.829207e-002,  2.664120e-002,  2.540363e-002,  2.449357e-002,
   2.397366e-002,  2.353265e-002,  2.345708e-002,  2.347587e-002,  2.361731e-002,  2.270580e-002,  2.113998e-002,  1.950122e-002,  1.765561e-002,
   1.565946e-002,  1.376865e-002,  1.152124e-002,  9.102662e-003,  7.218206e-003,  5.183816e-003,  2.615289e-003,  -3.851779e-004, -3.486018e-003,
   -6.480625e-003, -9.270210e-003, -1.197558e-002, -1.454167e-002, -1.694198e-002, -1.944175e-002, -2.172460e-002, -2.390355e-002, -2.710397e-002,
   -2.999039e-002, -3.241241e-002, -3.464384e-002, -3.668108e-002, -3.853862e-002, -4.014019e-002, -4.107149e-002, -4.173655e-002, -4.213476e-002,
   -4.390268e-002, -4.538513e-002, -4.623604e-002, -4.683822e-002, -4.703178e-002, -4.699299e-002, -4.629671e-002, -4.539325e-002, -4.424150e-002,
   -4.337699e-002, -4.321138e-002, -4.351186e-002, -4.381334e-002, -4.412244e-002, -4.411127e-002, -4.395834e-002, -4.366798e-002, -4.315568e-002,
   -4.202498e-002, -4.108187e-002, -4.095222e-002, -4.086003e-002, -4.089966e-002, -4.108777e-002, -4.048994e-002, -4.010219e-002, -4.003440e-002,
   -3.962959e-002, -3.943975e-002, -3.906411e-002, -3.864130e-002, -3.934392e-002, -4.020141e-002, -4.078777e-002, -4.146702e-002, -4.211575e-002,
   -4.188463e-002, -4.161813e-002, -4.064818e-002, -3.880230e-002, -3.722759e-002, -3.687198e-002, -3.497854e-002, -3.266861e-002, -3.046936e-002,
   -2.717855e-002, -2.346514e-002, -1.928974e-002, -1.472053e-002, -1.015454e-002, -4.516786e-003, 2.329857e-004,  4.369109e-003,  8.947472e-003,
   1.412497e-002,  2.021628e-002,  2.640411e-002,  3.340344e-002,  4.074637e-002,  4.820081e-002,  5.582310e-002,  6.165875e-002,  6.652469e-002,
   7.171450e-002,  7.664670e-002,  8.149182e-002,  8.644357e-002,  9.082694e-002,  9.504190e-002,  9.855155e-002,  1.010657e-001,  1.010114e-001,
   9.896326e-002,  9.662385e-002,  9.385036e-002,  9.123267e-002,  8.758923e-002,  8.470248e-002,  8.097590e-002,  7.678541e-002,  7.146030e-002,
   6.519561e-002,  5.347126e-002,  4.219965e-002,  3.056071e-002,  1.982283e-002,  1.022471e-002,  8.917409e-004,  -8.912022e-003, -1.834578e-002,
   -2.694842e-002, -3.359628e-002, -4.289161e-002, -5.034406e-002, -5.785256e-002, -6.288975e-002, -6.750979e-002, -6.953640e-002, -7.155991e-002,
   -7.309523e-002, -7.516657e-002, -7.813948e-002, -7.791139e-002, -7.299977e-002, -6.622939e-002, -6.147947e-002, -5.473512e-002, -4.772231e-002,
   -3.431692e-002, -2.025227e-002, -8.478797e-003, 3.198007e-003,  -6.584606e-002, -6.411181e-002, -5.398894e-002, -3.316145e-002, -5.279194e-003,
   2.619006e-002,  5.776649e-002,  9.217250e-002,  1.291238e-001,  1.624301e-001,  -1.305243e-002, -1.214986e-001, -6.671667e-002, 2.265593e-002,
   7.548315e-002,  1.106684e-001,  1.015218e-001,  6.539594e-002,  2.757593e-002,  7.803696e-003,  0.000000e+000},
  {0.000000e+000,  1.470711e-002,  2.385155e-002,  2.943746e-002,  3.310653e-002,  3.528947e-002,  3.614555e-002,  3.573553e-002,  3.468827e-002,
   3.313360e-002,  3.151139e-002,  2.978435e-002,  2.794378e-002,  2.602758e-002,  2.415664e-002,  2.223808e-002,  2.034137e-002,  1.853469e-002,
   1.682527e-002,  1.521173e-002,  1.394494e-002,  1.297383e-002,  1.228537e-002,  1.168492e-002,  1.112089e-002,  1.054153e-002,  9.993937e-003,
   9.455909e-003,  9.098443e-003,  8.994597e-003,  9.151954e-003,  9.438410e-003,  9.759535e-003,  9.963619e-003,  1.002215e-002,  9.974793e-003,
   9.814044e-003,  9.506074e-003,  9.021554e-003,  8.357113e-003,  7.452010e-003,  6.409430e-003,  5.346455e-003,  4.121137e-003,  2.714912e-003,
   1.167412e-003,  -5.629090e-004, -2.588928e-003, -4.663203e-003, -6.572644e-003, -8.385926e-003, -1.019694e-002, -1.179590e-002, -1.335754e-002,
   -1.482028e-002, -1.630572e-002, -1.779036e-002, -1.924632e-002, -2.076650e-002, -2.223736e-002, -2.372259e-002, -2.518320e-002, -2.647949e-002,
   -2.767239e-002, -2.870553e-002, -2.962614e-002, -3.036966e-002, -3.089289e-002, -3.109989e-002, -3.107696e-002, -3.062923e-002, -2.984201e-002,
   -2.853710e-002, -2.674290e-002, -2.435398e-002, -2.155808e-002, -1.814607e-002, -1.433476e-002, -1.011818e-002, -6.014490e-003, -2.227455e-003,
   9.976232e-004,  3.757014e-003,  6.040084e-003,  7.864813e-003,  9.196447e-003,  1.005105e-002,  1.051958e-002,  1.057811e-002,  1.020957e-002,
   9.597641e-003,  8.660077e-003,  7.548973e-003,  6.315226e-003,  4.948290e-003,  3.491835e-003,  1.917654e-003,  2.998424e-004,  -1.356914e-003,
   -3.048465e-003, -4.712144e-003, -6.346172e-003, -7.946848e-003, -9.448634e-003, -1.086962e-002, -1.212656e-002, -1.325434e-002, -1.420563e-002,
   -1.488492e-002, -1.514394e-002, -1.496689e-002, -1.441363e-002, -1.356572e-002, -1.240904e-002, -1.106441e-002, -9.507677e-003, -7.711646e-003,
   -5.624763e-003, -3.228497e-003, -5.318444e-004, 2.345981e-003,  5.237627e-003,  7.952566e-003,  1.022494e-002,  1.177790e-002,  1.263004e-002,
   1.292398e-002,  1.273553e-002,  1.224276e-002,  1.157787e-002,  1.071685e-002,  9.753229e-003,  8.726438e-003,  7.715507e-003,  6.720108e-003,
   5.812779e-003,  5.066223e-003,  4.457271e-003,  4.103393e-003,  3.989846e-003,  4.114796e-003,  4.432667e-003,  4.973587e-003,  5.721168e-003,
   6.634362e-003,  7.694951e-003,  8.796092e-003,  9.810055e-003,  1.066374e-002,  1.131030e-002,  1.174820e-002,  1.203343e-002,  1.221536e-002,
   1.221320e-002,  1.203265e-002,  1.167418e-002,  1.108941e-002,  1.017248e-002,  8.974302e-003,  7.592122e-003,  6.090285e-003,  4.523239e-003,
   2.948218e-003,  1.388182e-003,  -9.256327e-005, -1.458377e-003, -2.632660e-003, -3.514435e-003, -3.891082e-003, -3.788542e-003, -3.312267e-003,
   -2.620472e-003, -1.820118e-003, -9.344224e-004, 5.392192e-005,  1.156364e-003,  2.562547e-003,  4.311238e-003,  6.352743e-003,  8.581351e-003,
   1.084688e-002,  1.296575e-002,  1.459358e-002,  1.555002e-002,  1.588446e-002,  1.579683e-002,  1.541216e-002,  1.477602e-002,  1.391546e-002,
   1.291801e-002,  1.179997e-002,  1.053476e-002,  9.165277e-003,  7.752711e-003,  6.352653e-003,  4.980773e-003,  3.641334e-003,  2.370103e-003,
   1.191830e-003,  1.116674e-004,  -8.792832e-004, -1.785580e-003, -2.609592e-003, -3.335372e-003, -3.914223e-003, -4.299522e-003, -4.295807e-003,
   -3.772846e-003, -2.655522e-003, -1.143427e-003, 5.637108e-004,  2.274672e-003,  3.878278e-003,  5.321573e-003,  6.662664e-003,  7.956749e-003,
   9.285087e-003,  1.078610e-002,  1.245877e-002,  1.421325e-002,  1.590190e-002,  1.735163e-002,  1.834284e-002,  1.872289e-002,  1.854148e-002,
   1.791307e-002,  1.702929e-002,  1.598325e-002,  1.486169e-002,  1.366520e-002,  1.242341e-002,  1.114317e-002,  9.821118e-003,  8.448514e-003,
   7.016483e-003,  5.551032e-003,  4.040702e-003,  2.556537e-003,  1.140457e-003,  -1.771865e-004, -1.340068e-003, -2.344153e-003, -3.144545e-003,
   -3.673781e-003, -3.936651e-003, -3.841174e-003, -3.375091e-003, -2.277329e-003, -4.862951e-004, 1.834071e-003,  4.364304e-003,  6.845582e-003,
   9.125441e-003,  1.116167e-002,  1.288378e-002,  1.433479e-002,  1.547698e-002,  1.631827e-002,  1.696117e-002,  1.738144e-002,  1.745793e-002,
   1.720195e-002,  1.641115e-002,  1.516779e-002,  1.354264e-002,  1.160831e-002,  9.489553e-003,  7.139206e-003,  4.696358e-003,  2.207035e-003,
   -2.813720e-004, -2.708248e-003, -5.043422e-003, -7.203406e-003, -9.102018e-003, -1.060872e-002, -1.167423e-002, -1.243313e-002, -1.288619e-002,
   -1.308742e-002, -1.306915e-002, -1.287343e-002, -1.246478e-002, -1.179227e-002, -1.084795e-002, -9.631046e-003, -8.160636e-003, -6.540336e-003,
   -4.900948e-003, -3.516607e-003, -2.699473e-003, -2.502866e-003, -2.806651e-003, -3.496135e-003, -4.472033e-003, -5.713971e-003, -7.171004e-003,
   -8.792053e-003, -1.057979e-002, -1.246672e-002, -1.441861e-002, -1.638540e-002, -1.831207e-002, -2.020253e-002, -2.198026e-002, -2.364943e-002,
   -2.517514e-002, -2.659319e-002, -2.798528e-002, -2.927107e-002, -3.042557e-002, -3.144010e-002, -3.224967e-002, -3.271862e-002, -3.272642e-002,
   -3.215030e-002, -3.102259e-002, -2.954508e-002, -2.796432e-002, -2.631467e-002, -2.476525e-002, -2.331590e-002, -2.197125e-002, -2.064269e-002,
   -1.931720e-002, -1.789307e-002, -1.643602e-002, -1.503663e-002, -1.386663e-002, -1.301899e-002, -1.269086e-002, -1.279574e-002, -1.329274e-002,
   -1.405473e-002, -1.491935e-002, -1.587941e-002, -1.692808e-002, -1.797803e-002, -1.903819e-002, -2.009670e-002, -2.102141e-002, -2.174129e-002,
   -2.222438e-002, -2.235091e-002, -2.209540e-002, -2.138649e-002, -2.012845e-002, -1.830958e-002, -1.594769e-002, -1.311616e-002, -9.700340e-003,
   -5.866316e-003, -2.012977e-003, 1.502048e-003,  4.461081e-003,  6.842384e-003,  8.678816e-003,  1.000649e-002,  1.085659e-002,  1.116776e-002,
   1.109034e-002,  1.067505e-002,  1.004355e-002,  9.199033e-003,  8.201746e-003,  7.133353e-003,  5.990511e-003,  4.888105e-003,  3.845893e-003,
   2.784146e-003,  1.755062e-003,  8.729911e-004,  1.356723e-004,  -4.535081e-004, -8.955309e-004, -1.126969e-003, -1.156235e-003, -9.611690e-004,
   -5.628710e-004, 6.937336e-005,  7.867038e-004,  1.582231e-003,  2.398588e-003,  3.353008e-003,  4.391331e-003,  5.494600e-003,  6.678781e-003,
   7.866830e-003,  8.965230e-003,  9.892573e-003,  1.044324e-002,  1.065738e-002,  1.062343e-002,  1.046079e-002,  1.019896e-002,  9.863480e-003,
   9.507157e-003,  9.078057e-003,  8.576337e-003,  8.011159e-003,  7.262284e-003,  6.440581e-003,  5.598109e-003,  4.768016e-003,  3.965540e-003,
   3.213183e-003,  2.557267e-003,  2.049415e-003,  1.722377e-003,  1.600211e-003,  1.594289e-003,  1.841733e-003,  2.312273e-003,  3.035115e-003,
   3.976170e-003,  5.118478e-003,  6.424807e-003,  7.865854e-003,  9.423603e-003,  1.102541e-002,  1.250951e-002,  1.381528e-002,  1.497229e-002,
   1.600104e-002,  1.689607e-002,  1.769248e-002,  1.835399e-002,  1.882459e-002,  1.907794e-002,  1.897096e-002,  1.848564e-002,  1.765139e-002,
   1.660749e-002,  1.548396e-002,  1.431971e-002,  1.311694e-002,  1.191261e-002,  1.076754e-002,  9.751177e-003,  8.927444e-003,  8.484394e-003,
   8.402696e-003,  8.895643e-003,  9.772000e-003,  1.087216e-002,  1.198649e-002,  1.309024e-002,  1.417865e-002,  1.536594e-002,  1.679154e-002,
   1.860074e-002,  2.068077e-002,  2.307871e-002,  2.566506e-002,  2.817436e-002,  3.019921e-002,  3.138889e-002,  3.184115e-002,  3.172504e-002,
   3.124642e-002,  3.041845e-002,  2.927096e-002,  2.786794e-002,  2.624973e-002,  2.446846e-002,  2.256396e-002,  2.053936e-002,  1.845890e-002,
   1.635989e-002,  1.426599e-002,  1.215043e-002,  9.982670e-003,  7.785211e-003,  5.573257e-003,  3.354093e-003,  1.131536e-003,  -1.148988e-003,
   -3.448758e-003, -5.749069e-003, -8.013942e-003, -1.022495e-002, -1.240847e-002, -1.456944e-002, -1.662273e-002, -1.852153e-002, -2.024174e-002,
   -2.173623e-002, -2.297699e-002, -2.376509e-002, -2.416364e-002, -2.424957e-002, -2.410876e-002, -2.383642e-002, -2.341724e-002, -2.281133e-002,
   -2.201590e-002, -2.103281e-002, -1.981775e-002, -1.841899e-002, -1.695471e-002, -1.555817e-002, -1.428638e-002, -1.322024e-002, -1.235011e-002,
   -1.165369e-002, -1.116427e-002, -1.087814e-002, -1.085910e-002, -1.105487e-002, -1.136123e-002, -1.180925e-002, -1.235999e-002, -1.301223e-002,
   -1.364250e-002, -1.424872e-002, -1.475660e-002, -1.508621e-002, -1.517844e-002, -1.496501e-002, -1.420867e-002, -1.285344e-002, -1.082202e-002,
   -8.365882e-003, -5.785780e-003, -3.336778e-003, -1.193717e-003, 6.801640e-004,  2.280567e-003,  3.602129e-003,  4.717797e-003,  5.637716e-003,
   6.370149e-003,  6.833955e-003,  7.004490e-003,  6.801548e-003,  6.264650e-003,  5.267874e-003,  3.877531e-003,  2.242962e-003,  3.643376e-004,
   -1.580770e-003, -3.577096e-003, -5.544203e-003, -7.473947e-003, -9.300466e-003, -1.104167e-002, -1.261402e-002, -1.383091e-002, -1.457939e-002,
   -1.481601e-002, -1.463911e-002, -1.409853e-002, -1.329989e-002, -1.242430e-002, -1.145663e-002, -1.046610e-002, -9.489297e-003, -8.566849e-003,
   -7.693679e-003, -6.747475e-003, -5.757359e-003, -4.797247e-003, -3.965659e-003, -3.403659e-003, -3.380450e-003, -3.785446e-003, -4.572035e-003,
   -5.607451e-003, -6.762622e-003, -7.993625e-003, -9.263330e-003, -1.058310e-002, -1.189013e-002, -1.319313e-002, -1.457319e-002, -1.599399e-002,
   -1.742066e-002, -1.890288e-002, -2.035007e-002, -2.172099e-002, -2.293360e-002, -2.394568e-002, -2.481295e-002, -2.547663e-002, -2.590480e-002,
   -2.599411e-002, -2.579836e-002, -2.511562e-002, -2.386895e-002, -2.192175e-002, -1.919548e-002, -1.611875e-002, -1.307152e-002, -1.025466e-002,
   -7.719859e-003, -5.596299e-003, -3.911633e-003, -2.363471e-003, -8.285868e-004, 7.752581e-004,  2.510695e-003,  4.246003e-003,  5.642713e-003,
   6.616438e-003,  7.041042e-003,  6.961679e-003,  6.645664e-003,  6.291001e-003,  5.824113e-003,  5.329249e-003,  4.797726e-003,  4.297902e-003,
   3.964360e-003,  3.844453e-003,  3.884863e-003,  4.100297e-003,  4.698220e-003,  5.656172e-003,  7.071381e-003,  8.996613e-003,  1.139343e-002,
   1.421904e-002,  1.752031e-002,  2.127268e-002,  2.540652e-002,  2.959688e-002,  3.347268e-002,  3.686824e-002,  3.972817e-002,  4.203517e-002,
   4.378206e-002,  4.508630e-002,  4.589776e-002,  4.625833e-002,  4.610721e-002,  4.560014e-002,  4.468902e-002,  4.348849e-002,  4.205359e-002,
   4.036838e-002,  3.845582e-002,  3.639558e-002,  3.433881e-002,  3.220125e-002,  2.999954e-002,  2.768287e-002,  2.520036e-002,  2.273808e-002,
   2.026208e-002,  1.788083e-002,  1.559905e-002,  1.346054e-002,  1.147134e-002,  9.689246e-003,  8.140408e-003,  6.989203e-003,  6.207392e-003,
   5.891740e-003,  5.909570e-003,  6.321913e-003,  6.973676e-003,  7.879743e-003,  9.111558e-003,  1.064071e-002,  1.253280e-002,  1.479296e-002,
   1.725812e-002,  1.985134e-002,  2.243682e-002,  2.473297e-002,  2.640858e-002,  2.729291e-002,  2.765708e-002,  2.762647e-002,  2.712463e-002,
   2.628925e-002,  2.493381e-002,  2.320106e-002,  2.132884e-002,  1.940003e-002,  1.733626e-002,  1.511586e-002,  1.283987e-002,  1.057440e-002,
   8.466864e-003,  6.365020e-003,  4.132742e-003,  1.880097e-003,  -3.885574e-004, -2.590050e-003, -4.607024e-003, -6.536851e-003, -8.244533e-003,
   -9.613716e-003, -1.076934e-002, -1.134622e-002, -1.147631e-002, -1.139889e-002, -1.111425e-002, -1.066005e-002, -1.018438e-002, -9.681517e-003,
   -9.307159e-003, -9.019717e-003, -8.557387e-003, -8.053603e-003, -7.435151e-003, -7.120488e-003, -7.125101e-003, -7.409970e-003, -8.036044e-003,
   -9.167196e-003, -1.059239e-002, -1.225682e-002, -1.415920e-002, -1.610398e-002, -1.816266e-002, -2.050262e-002, -2.275878e-002, -2.491432e-002,
   -2.687274e-002, -2.863240e-002, -3.018673e-002, -3.146643e-002, -3.243032e-002, -3.321314e-002, -3.385925e-002, -3.468951e-002, -3.538832e-002,
   -3.582917e-002, -3.603409e-002, -3.598898e-002, -3.574494e-002, -3.550947e-002, -3.533068e-002, -3.514670e-002, -3.496124e-002, -3.512897e-002,
   -3.560504e-002, -3.625453e-002, -3.707319e-002, -3.805180e-002, -3.913440e-002, -4.032742e-002, -4.160446e-002, -4.272987e-002, -4.390710e-002,
   -4.505960e-002, -4.630658e-002, -4.731210e-002, -4.799662e-002, -4.819791e-002, -4.785928e-002, -4.691640e-002, -4.528066e-002, -4.261562e-002,
   -3.937079e-002, -3.590262e-002, -3.297435e-002, -3.015635e-002, -2.735242e-002, -2.456243e-002, -2.182234e-002, -1.917192e-002, -1.684551e-002,
   -1.424818e-002, -1.171513e-002, -9.355638e-003, -7.544183e-003, -6.348535e-003, -5.704801e-003, -5.266788e-003, -4.844053e-003, -4.451315e-003,
   -4.058483e-003, -3.646156e-003, -3.547113e-003, -3.348308e-003, -3.013289e-003, -2.721100e-003, -2.008997e-003, -8.561069e-004, 6.229952e-004,
   2.294624e-003,  4.136630e-003,  6.505292e-003,  9.518733e-003,  1.332785e-002,  1.739096e-002,  2.138379e-002,  2.597635e-002,  3.056757e-002,
   3.488160e-002,  3.862853e-002,  4.171508e-002,  4.439780e-002,  4.674723e-002,  4.876814e-002,  5.026799e-002,  5.073940e-002,  5.081714e-002,
   5.053382e-002,  4.990740e-002,  4.892916e-002,  4.773838e-002,  4.635828e-002,  4.486604e-002,  4.338609e-002,  4.185752e-002,  3.980144e-002,
   3.775149e-002,  3.562064e-002,  3.356114e-002,  3.139212e-002,  2.921529e-002,  2.724230e-002,  2.521192e-002,  2.328925e-002,  2.159055e-002,
   1.971744e-002,  1.821229e-002,  1.734659e-002,  1.697206e-002,  1.685442e-002,  1.722541e-002,  1.763724e-002,  1.818866e-002,  1.860193e-002,
   1.920408e-002,  1.932537e-002,  1.900383e-002,  1.875683e-002,  1.864936e-002,  1.854494e-002,  1.848039e-002,  1.857740e-002,  1.870498e-002,
   1.815293e-002,  1.694992e-002,  1.511929e-002,  1.295371e-002,  1.055159e-002,  8.137107e-003,  5.932524e-003,  3.712202e-003,  1.514624e-003,
   -5.221908e-004, -2.181047e-003, -3.453448e-003, -4.363185e-003, -5.135264e-003, -5.573816e-003, -5.883735e-003, -5.456369e-003, -4.354433e-003,
   -2.902829e-003, -9.522627e-004, 1.261179e-003,  3.982725e-003,  6.904775e-003,  9.436941e-003,  1.123109e-002,  1.239348e-002,  1.314885e-002,
   1.357073e-002,  1.358050e-002,  1.345837e-002,  1.299462e-002,  1.206866e-002,  1.101548e-002,  9.342446e-003,  7.181895e-003,  4.639884e-003,
   2.168803e-003,  -5.403141e-004, -3.338211e-003, -6.171053e-003, -9.023248e-003, -1.162414e-002, -1.404210e-002, -1.674262e-002, -1.974507e-002,
   -2.261353e-002, -2.562683e-002, -2.864360e-002, -3.120368e-002, -3.382842e-002, -3.609842e-002, -3.770309e-002, -3.877005e-002, -3.951570e-002,
   -4.011970e-002, -4.028098e-002, -4.029244e-002, -4.001073e-002, -3.948306e-002, -3.907075e-002, -3.868763e-002, -3.776890e-002, -3.650010e-002,
   -3.510149e-002, -3.379399e-002, -3.280304e-002, -3.133605e-002, -2.992369e-002, -2.836996e-002, -2.665070e-002, -2.480328e-002, -2.247509e-002,
   -2.065475e-002, -1.837571e-002, -1.649092e-002, -1.536351e-002, -1.424033e-002, -1.287557e-002, -1.144852e-002, -1.038414e-002, -8.784072e-003,
   -6.564428e-003, -4.390617e-003, -1.746136e-003, 4.940023e-004,  2.163875e-003,  4.790194e-003,  7.776668e-003,  1.056719e-002,  1.276960e-002,
   1.472856e-002,  1.674335e-002,  1.850011e-002,  2.042297e-002,  2.257840e-002,  2.354449e-002,  2.397875e-002,  2.501819e-002,  2.611174e-002,
   2.718280e-002,  2.793536e-002,  2.940966e-002,  3.081194e-002,  3.246195e-002,  3.477144e-002,  3.474753e-002,  3.408739e-002,  3.393655e-002,
   3.393179e-002,  3.354272e-002,  3.378031e-002,  3.485546e-002,  3.585239e-002,  3.693504e-002,  3.557862e-002,  3.269076e-002,  2.784042e-002,
   2.238909e-002,  1.779192e-002,  1.396547e-002,  1.038320e-002,  6.693330e-003,  3.371938e-003,  7.805305e-004,  -1.052442e-003, -3.757153e-003,
   -9.158682e-003, -1.434758e-002, -1.954858e-002, -2.527382e-002, -2.960517e-002, -3.412770e-002, -3.798694e-002, -4.088231e-002, -4.280558e-002,
   -4.423660e-002, -4.927104e-002, -5.465330e-002, -5.909645e-002, -6.273243e-002, -6.574110e-002, -6.924741e-002, -6.972638e-002, -6.982251e-002,
   -7.020630e-002, -6.968040e-002, -7.097161e-002, -6.968716e-002, -6.457170e-002, -5.561283e-002, -3.731794e-002, -1.522860e-002, 4.483525e-003,
   2.533814e-002,  4.846764e-002,  8.473675e-002,  1.078937e-001,  1.266752e-001,  1.410687e-001,  1.475165e-001,  1.414715e-001,  1.255990e-001,
   9.738725e-002,  6.864809e-002,  4.626563e-002,  2.822161e-002,  1.643456e-001,  1.419734e-001,  1.064186e-001,  6.252018e-002,  1.540676e-002,
   -3.864968e-002, -1.045274e-001, -1.780579e-001, -2.537739e-001, -3.185459e-001, -1.184888e-001, 2.421630e-001,  1.608806e-001,  -2.613183e-002,
   -1.404076e-001, -1.937554e-001, -8.880239e-002, -3.489049e-002, 2.083226e-002,  2.721374e-002,  0.000000e+000},
  {0.000000e+000,  2.903965e-003,  4.551270e-003,  5.550537e-003,  7.088522e-003,  9.235748e-003,  1.183259e-002,  1.414636e-002,  1.606116e-002,
   1.773237e-002,  1.954150e-002,  2.074767e-002,  2.163211e-002,  2.241228e-002,  2.311145e-002,  2.373633e-002,  2.423796e-002,  2.465463e-002,
   2.479083e-002,  2.449318e-002,  2.343567e-002,  2.127563e-002,  1.836984e-002,  1.534739e-002,  1.234594e-002,  9.432343e-003,  6.501517e-003,
   3.509311e-003,  3.097889e-004,  -3.205616e-003, -7.026396e-003, -1.098717e-002, -1.487007e-002, -1.834551e-002, -2.138312e-002, -2.392421e-002,
   -2.592638e-002, -2.743838e-002, -2.842199e-002, -2.894234e-002, -2.892510e-002, -2.848022e-002, -2.776194e-002, -2.656646e-002, -2.498017e-002,
   -2.313135e-002, -2.117085e-002, -1.941252e-002, -1.747569e-002, -1.505768e-002, -1.246127e-002, -9.862632e-003, -7.358711e-003, -4.810425e-003,
   -2.180808e-003, 5.746727e-004,  3.452635e-003,  6.446432e-003,  9.528409e-003,  1.264267e-002,  1.577304e-002,  1.887730e-002,  2.187374e-002,
   2.472561e-002,  2.739921e-002,  2.979362e-002,  3.193125e-002,  3.354298e-002,  3.458326e-002,  3.503686e-002,  3.475509e-002,  3.369066e-002,
   3.181080e-002,  2.898566e-002,  2.512481e-002,  2.015588e-002,  1.417063e-002,  7.112311e-003,  -5.840502e-004, -8.225754e-003, -1.510219e-002,
   -2.098056e-002, -2.582160e-002, -2.960299e-002, -3.244873e-002, -3.441860e-002, -3.553086e-002, -3.587288e-002, -3.532921e-002, -3.406279e-002,
   -3.216600e-002, -2.979004e-002, -2.695857e-002, -2.372520e-002, -2.022121e-002, -1.649154e-002, -1.262246e-002, -8.674661e-003, -4.591839e-003,
   -4.831050e-004, 3.665114e-003,  7.806292e-003,  1.187523e-002,  1.592741e-002,  1.982119e-002,  2.348562e-002,  2.686094e-002,  2.980455e-002,
   3.210517e-002,  3.355003e-002,  3.410042e-002,  3.374502e-002,  3.272004e-002,  3.106026e-002,  2.892735e-002,  2.631819e-002,  2.311648e-002,
   1.925999e-002,  1.474846e-002,  9.629507e-003,  4.049881e-003,  -1.671922e-003, -7.060979e-003, -1.158693e-002, -1.472824e-002, -1.650719e-002,
   -1.716546e-002, -1.701081e-002, -1.629142e-002, -1.518312e-002, -1.381375e-002, -1.227107e-002, -1.062022e-002, -9.007506e-003, -7.501829e-003,
   -6.235036e-003, -5.307823e-003, -4.733938e-003, -4.647284e-003, -5.057323e-003, -5.966086e-003, -7.253277e-003, -8.970710e-003, -1.110617e-002,
   -1.358424e-002, -1.634171e-002, -1.920731e-002, -2.186520e-002, -2.412815e-002, -2.596909e-002, -2.739667e-002, -2.846019e-002, -2.924857e-002,
   -2.966273e-002, -2.978334e-002, -2.948667e-002, -2.867123e-002, -2.716701e-002, -2.507119e-002, -2.256560e-002, -1.978001e-002, -1.686272e-002,
   -1.389290e-002, -1.097277e-002, -8.232648e-003, -5.791433e-003, -3.738574e-003, -2.278915e-003, -1.758821e-003, -2.250355e-003, -3.521877e-003,
   -5.261935e-003, -7.193045e-003, -9.270621e-003, -1.150837e-002, -1.408357e-002, -1.725168e-002, -2.107568e-002, -2.548093e-002, -3.026646e-002,
   -3.512395e-002, -3.957360e-002, -4.297703e-002, -4.502347e-002, -4.576292e-002, -4.563647e-002, -4.474825e-002, -4.325349e-002, -4.117800e-002,
   -3.865640e-002, -3.576485e-002, -3.245915e-002, -2.891773e-002, -2.516291e-002, -2.129258e-002, -1.737856e-002, -1.344807e-002, -9.606887e-003,
   -5.848233e-003, -2.159702e-003, 1.452782e-003,  5.020457e-003,  8.493934e-003,  1.180846e-002,  1.489786e-002,  1.760093e-002,  1.948115e-002,
   2.035584e-002,  2.001960e-002,  1.891443e-002,  1.743112e-002,  1.594588e-002,  1.465340e-002,  1.360020e-002,  1.273618e-002,  1.185549e-002,
   1.084541e-002,  9.477125e-003,  7.756907e-003,  5.775659e-003,  3.807651e-003,  2.323873e-003,  1.693783e-003,  2.305711e-003,  3.986422e-003,
   6.477062e-003,  9.331964e-003,  1.241282e-002,  1.561938e-002,  1.889441e-002,  2.220165e-002,  2.551698e-002,  2.886633e-002,  3.226507e-002,
   3.569845e-002,  3.914379e-002,  4.253840e-002,  4.584315e-002,  4.897508e-002,  5.183965e-002,  5.438190e-002,  5.656875e-002,  5.834856e-002,
   5.959992e-002,  6.023653e-002,  6.013837e-002,  5.918656e-002,  5.690729e-002,  5.324077e-002,  4.850239e-002,  4.329176e-002,  3.817963e-002,
   3.345825e-002,  2.922105e-002,  2.552150e-002,  2.236279e-002,  1.970633e-002,  1.755050e-002,  1.578780e-002,  1.443777e-002,  1.370612e-002,
   1.354713e-002,  1.437329e-002,  1.606397e-002,  1.844334e-002,  2.134042e-002,  2.458742e-002,  2.801208e-002,  3.154385e-002,  3.507640e-002,
   3.848130e-002,  4.166550e-002,  4.453822e-002,  4.693822e-002,  4.873894e-002,  4.966375e-002,  4.962977e-002,  4.879704e-002,  4.727710e-002,
   4.519356e-002,  4.261602e-002,  3.965044e-002,  3.617417e-002,  3.209664e-002,  2.744718e-002,  2.219940e-002,  1.639825e-002,  1.021042e-002,
   3.940754e-003,  -1.814134e-003, -6.396885e-003, -9.754607e-003, -1.203659e-002, -1.344233e-002, -1.413407e-002, -1.421277e-002, -1.370530e-002,
   -1.279864e-002, -1.151323e-002, -9.897399e-003, -8.013783e-003, -5.966343e-003, -3.821294e-003, -1.631281e-003, 5.732588e-004,  2.727075e-003,
   4.814094e-003,  6.843707e-003,  8.841219e-003,  1.078738e-002,  1.265093e-002,  1.432882e-002,  1.570842e-002,  1.658658e-002,  1.663880e-002,
   1.567624e-002,  1.370330e-002,  1.114992e-002,  8.310912e-003,  5.423848e-003,  2.721047e-003,  3.174960e-004,  -1.834667e-003, -3.883656e-003,
   -5.921138e-003, -8.117367e-003, -1.037790e-002, -1.251587e-002, -1.428429e-002, -1.547109e-002, -1.560435e-002, -1.486408e-002, -1.334719e-002,
   -1.136525e-002, -9.080045e-003, -6.636922e-003, -4.091481e-003, -1.561440e-003, 8.877030e-004,  3.183046e-003,  5.170876e-003,  6.748899e-003,
   7.804888e-003,  8.168572e-003,  7.804114e-003,  6.557082e-003,  4.240496e-003,  7.961289e-004,  -3.791933e-003, -9.549484e-003, -1.649954e-002,
   -2.418507e-002, -3.186816e-002, -3.881352e-002, -4.462729e-002, -4.926522e-002, -5.274478e-002, -5.517225e-002, -5.654780e-002, -5.700857e-002,
   -5.670113e-002, -5.567749e-002, -5.413287e-002, -5.206094e-002, -4.961058e-002, -4.695038e-002, -4.419420e-002, -4.142630e-002, -3.873961e-002,
   -3.614558e-002, -3.373720e-002, -3.158762e-002, -2.966027e-002, -2.801392e-002, -2.670007e-002, -2.576479e-002, -2.519870e-002, -2.508457e-002,
   -2.536392e-002, -2.607981e-002, -2.708229e-002, -2.821320e-002, -2.936455e-002, -3.072838e-002, -3.219702e-002, -3.378657e-002, -3.548186e-002,
   -3.716719e-002, -3.870788e-002, -3.990459e-002, -4.050053e-002, -4.046142e-002, -3.983771e-002, -3.886458e-002, -3.766583e-002, -3.625778e-002,
   -3.470421e-002, -3.302617e-002, -3.115019e-002, -2.909447e-002, -2.691215e-002, -2.459068e-002, -2.219684e-002, -1.981312e-002, -1.745218e-002,
   -1.516696e-002, -1.308596e-002, -1.125337e-002, -9.717934e-003, -8.548588e-003, -7.757027e-003, -7.411686e-003, -7.532101e-003, -8.129871e-003,
   -9.052552e-003, -1.033411e-002, -1.194588e-002, -1.379388e-002, -1.587451e-002, -1.804303e-002, -2.007155e-002, -2.179881e-002, -2.321280e-002,
   -2.429431e-002, -2.506179e-002, -2.565606e-002, -2.596282e-002, -2.590073e-002, -2.540739e-002, -2.416777e-002, -2.221724e-002, -1.967879e-002,
   -1.671831e-002, -1.353065e-002, -1.022668e-002, -6.874738e-003, -3.587444e-003, -4.470855e-004, 2.460915e-003,  5.056786e-003,  6.893127e-003,
   7.725265e-003,  7.398390e-003,  6.276422e-003,  4.757260e-003,  3.231280e-003,  1.742098e-003,  1.893774e-004,  -1.626567e-003, -3.978422e-003,
   -7.095687e-003, -1.099635e-002, -1.553248e-002, -2.047565e-002, -2.533202e-002, -2.925930e-002, -3.165973e-002, -3.266447e-002, -3.255699e-002,
   -3.176642e-002, -3.033697e-002, -2.850322e-002, -2.626690e-002, -2.356390e-002, -2.055603e-002, -1.732216e-002, -1.388217e-002, -1.036695e-002,
   -6.782662e-003, -3.172544e-003, 4.666572e-004,  4.067384e-003,  7.688181e-003,  1.137087e-002,  1.509412e-002,  1.891199e-002,  2.281536e-002,
   2.677526e-002,  3.071932e-002,  3.467252e-002,  3.861704e-002,  4.250325e-002,  4.625008e-002,  4.983143e-002,  5.320130e-002,  5.624774e-002,
   5.892016e-002,  6.111458e-002,  6.250517e-002,  6.322374e-002,  6.340869e-002,  6.319145e-002,  6.268511e-002,  6.190029e-002,  6.076463e-002,
   5.923023e-002,  5.730386e-002,  5.499541e-002,  5.238516e-002,  4.966512e-002,  4.705273e-002,  4.475538e-002,  4.283232e-002,  4.126986e-002,
   4.013926e-002,  3.943480e-002,  3.910891e-002,  3.939581e-002,  4.010017e-002,  4.110729e-002,  4.240911e-002,  4.389196e-002,  4.548561e-002,
   4.701554e-002,  4.841366e-002,  4.953239e-002,  5.028419e-002,  5.049994e-002,  5.001986e-002,  4.856059e-002,  4.575029e-002,  4.148986e-002,
   3.633267e-002,  3.089043e-002,  2.559653e-002,  2.076487e-002,  1.650965e-002,  1.274772e-002,  9.456806e-003,  6.609605e-003,  4.161350e-003,
   1.946013e-003,  1.797243e-004,  -1.025282e-003, -1.485920e-003, -1.302189e-003, -2.600500e-004, 1.580810e-003,  3.799347e-003,  6.279195e-003,
   8.946090e-003,  1.172525e-002,  1.444011e-002,  1.704434e-002,  1.949055e-002,  2.161131e-002,  2.322780e-002,  2.420492e-002,  2.438489e-002,
   2.352068e-002,  2.194818e-002,  1.975590e-002,  1.704693e-002,  1.398885e-002,  1.083562e-002,  7.687217e-003,  4.645514e-003,  1.722737e-003,
   -1.155283e-003, -4.086258e-003, -7.092166e-003, -9.972959e-003, -1.253068e-002, -1.441959e-002, -1.518829e-002, -1.498858e-002, -1.395004e-002,
   -1.239518e-002, -1.059267e-002, -8.638810e-003, -6.535975e-003, -4.316868e-003, -2.030414e-003, 3.702029e-004,  2.929673e-003,  5.504399e-003,
   8.189959e-003,  1.092767e-002,  1.362203e-002,  1.615205e-002,  1.851279e-002,  2.053284e-002,  2.211315e-002,  2.333857e-002,  2.421483e-002,
   2.455376e-002,  2.431118e-002,  2.315807e-002,  2.083719e-002,  1.690008e-002,  1.151427e-002,  5.651011e-003,  -5.634574e-005, -5.194678e-003,
   -9.595223e-003, -1.316636e-002, -1.598720e-002, -1.828934e-002, -2.046845e-002, -2.262012e-002, -2.489354e-002, -2.700870e-002, -2.857751e-002,
   -2.913870e-002, -2.860192e-002, -2.698582e-002, -2.476880e-002, -2.222908e-002, -1.941955e-002, -1.650614e-002, -1.354547e-002, -1.064393e-002,
   -7.994551e-003, -5.645866e-003, -3.762501e-003, -2.380835e-003, -1.825044e-003, -1.966932e-003, -2.943547e-003, -4.911158e-003, -7.883081e-003,
   -1.182422e-002, -1.676633e-002, -2.268884e-002, -2.935443e-002, -3.625373e-002, -4.270168e-002, -4.828776e-002, -5.295343e-002, -5.677413e-002,
   -5.968806e-002, -6.173655e-002, -6.290016e-002, -6.327632e-002, -6.290611e-002, -6.184118e-002, -5.997159e-002, -5.763910e-002, -5.497702e-002,
   -5.202501e-002, -4.888281e-002, -4.564516e-002, -4.231252e-002, -3.884301e-002, -3.533109e-002, -3.169639e-002, -2.809249e-002, -2.451304e-002,
   -2.097820e-002, -1.755683e-002, -1.431549e-002, -1.123544e-002, -8.319231e-003, -5.780658e-003, -3.784024e-003, -2.448145e-003, -1.946476e-003,
   -2.276817e-003, -3.235685e-003, -4.722558e-003, -6.737024e-003, -9.073209e-003, -1.172202e-002, -1.490486e-002, -1.858991e-002, -2.274950e-002,
   -2.742943e-002, -3.243966e-002, -3.741303e-002, -4.170966e-002, -4.477044e-002, -4.627941e-002, -4.650502e-002, -4.581912e-002, -4.443573e-002,
   -4.242074e-002, -3.984120e-002, -3.678194e-002, -3.336607e-002, -2.950967e-002, -2.537150e-002, -2.110304e-002, -1.674583e-002, -1.237731e-002,
   -8.039277e-003, -3.751405e-003, 5.001453e-004,  4.647559e-003,  8.665964e-003,  1.260914e-002,  1.646962e-002,  2.003740e-002,  2.332881e-002,
   2.619192e-002,  2.834767e-002,  2.951775e-002,  2.974790e-002,  2.916707e-002,  2.820025e-002,  2.707123e-002,  2.592391e-002,  2.480510e-002,
   2.380951e-002,  2.286337e-002,  2.174543e-002,  2.058071e-002,  1.934375e-002,  1.814667e-002,  1.727507e-002,  1.710032e-002,  1.776219e-002,
   1.942991e-002,  2.189586e-002,  2.490814e-002,  2.818312e-002,  3.174992e-002,  3.541249e-002,  3.898550e-002,  4.251094e-002,  4.594722e-002,
   4.895170e-002,  5.137001e-002,  5.295146e-002,  5.373031e-002,  5.392752e-002,  5.362938e-002,  5.283267e-002,  5.153610e-002,  4.985130e-002,
   4.781779e-002,  4.529525e-002,  4.227034e-002,  3.894294e-002,  3.522443e-002,  3.156056e-002,  2.827878e-002,  2.530943e-002,  2.263495e-002,
   2.028609e-002,  1.837129e-002,  1.691071e-002,  1.602413e-002,  1.560739e-002,  1.551733e-002,  1.571671e-002,  1.621657e-002,  1.675323e-002,
   1.732805e-002,  1.779234e-002,  1.803222e-002,  1.806142e-002,  1.769858e-002,  1.670374e-002,  1.469256e-002,  1.151409e-002,  7.162216e-003,
   1.980148e-003,  -3.380628e-003, -8.549981e-003, -1.315693e-002, -1.700542e-002, -2.015679e-002, -2.261154e-002, -2.476243e-002, -2.688792e-002,
   -2.887061e-002, -3.051177e-002, -3.181000e-002, -3.225165e-002, -3.164702e-002, -3.029224e-002, -2.822603e-002, -2.570137e-002, -2.280467e-002,
   -1.966869e-002, -1.639304e-002, -1.332997e-002, -1.038651e-002, -7.588269e-003, -5.117209e-003, -3.102093e-003, -1.792497e-003, -1.130565e-003,
   -1.076477e-003, -1.984826e-003, -3.899544e-003, -6.665022e-003, -1.035650e-002, -1.516097e-002, -2.091116e-002, -2.717813e-002, -3.322081e-002,
   -3.840594e-002, -4.274913e-002, -4.615626e-002, -4.864241e-002, -5.026737e-002, -5.102287e-002, -5.097278e-002, -5.010137e-002, -4.849653e-002,
   -4.606747e-002, -4.307629e-002, -3.972214e-002, -3.590592e-002, -3.176558e-002, -2.734085e-002, -2.291755e-002, -1.840974e-002, -1.368165e-002,
   -8.588742e-003, -3.532312e-003, 1.412709e-003,  6.297495e-003,  1.125664e-002,  1.613608e-002,  2.065485e-002,  2.491149e-002,  2.889154e-002,
   3.247673e-002,  3.550839e-002,  3.736617e-002,  3.801210e-002,  3.776070e-002,  3.681005e-002,  3.534989e-002,  3.380802e-002,  3.225928e-002,
   3.073152e-002,  2.930474e-002,  2.799888e-002,  2.649529e-002,  2.462645e-002,  2.236404e-002,  1.999340e-002,  1.772206e-002,  1.586982e-002,
   1.487248e-002,  1.490514e-002,  1.612830e-002,  1.799089e-002,  2.017966e-002,  2.272674e-002,  2.517020e-002,  2.766345e-002,  3.014670e-002,
   3.243905e-002,  3.435746e-002,  3.584838e-002,  3.673737e-002,  3.731557e-002,  3.727186e-002,  3.611260e-002,  3.387466e-002,  3.040956e-002,
   2.592020e-002,  2.051163e-002,  1.391462e-002,  6.612652e-003,  -7.495148e-004, -7.361528e-003, -1.325752e-002, -1.823926e-002, -2.222734e-002,
   -2.518264e-002, -2.712174e-002, -2.825703e-002, -2.910472e-002, -2.900281e-002, -2.803136e-002, -2.597702e-002, -2.321457e-002, -2.029995e-002,
   -1.732715e-002, -1.404130e-002, -1.066803e-002, -7.531682e-003, -4.340497e-003, -9.945766e-004, 2.088904e-003,  5.046225e-003,  8.349078e-003,
   1.166875e-002,  1.452480e-002,  1.689194e-002,  1.901252e-002,  2.054228e-002,  2.170250e-002,  2.190509e-002,  2.162890e-002,  2.068200e-002,
   1.960475e-002,  1.843888e-002,  1.686678e-002,  1.486641e-002,  1.287485e-002,  9.834250e-003,  6.192565e-003,  2.550508e-003,  -1.244934e-003,
   -4.717020e-003, -7.673204e-003, -1.036406e-002, -1.292957e-002, -1.546390e-002, -1.768102e-002, -2.010618e-002, -2.243746e-002, -2.511888e-002,
   -2.816856e-002, -3.120366e-002, -3.328967e-002, -3.532705e-002, -3.735430e-002, -3.915202e-002, -4.083428e-002, -4.276110e-002, -4.473334e-002,
   -4.658149e-002, -4.839883e-002, -4.956778e-002, -5.063867e-002, -5.036792e-002, -4.995281e-002, -4.906193e-002, -4.719672e-002, -4.472203e-002,
   -4.177322e-002, -3.802671e-002, -3.343007e-002, -2.856957e-002, -2.286628e-002, -1.655722e-002, -1.005405e-002, -3.272533e-003, 3.329761e-003,
   9.583982e-003,  1.514163e-002,  2.018721e-002,  2.450668e-002,  2.810988e-002,  3.112643e-002,  3.396646e-002,  3.699023e-002,  4.013234e-002,
   4.291642e-002,  4.437672e-002,  4.466439e-002,  4.302839e-002,  3.997029e-002,  3.713232e-002,  3.310879e-002,  2.934735e-002,  2.600571e-002,
   2.213868e-002,  1.856913e-002,  1.369196e-002,  8.729759e-003,  3.543025e-003,  -1.829430e-003, -6.654446e-003, -1.148450e-002, -1.586154e-002,
   -1.979985e-002, -2.246088e-002, -2.467860e-002, -2.704177e-002, -2.901125e-002, -3.091356e-002, -3.223086e-002, -3.173460e-002, -3.076383e-002,
   -2.789636e-002, -2.316488e-002, -1.722342e-002, -1.029480e-002, -2.777485e-003, 5.761202e-003,  1.468155e-002,  2.467446e-002,  3.466033e-002,
   4.324878e-002,  5.026680e-002,  5.536700e-002,  5.856712e-002,  6.149206e-002,  6.026970e-002,  5.351028e-002,  4.122796e-002,  3.042455e-002,
   2.315248e-002,  2.080529e-002,  3.340854e-002,  2.981382e-002,  1.347153e-002,  -3.023675e-003, -1.909938e-002, -3.648361e-002, -5.485777e-002,
   -7.278697e-002, -8.722149e-002, -9.239338e-002, -9.050156e-002, 9.741840e-002,  1.041446e-001,  9.384228e-002,  7.430607e-002,  4.637446e-002,
   9.591476e-003,  -3.195461e-002, -7.473722e-002, -1.167334e-001, -1.512537e-001, -5.959754e-002, 2.222565e-001,  1.317222e-001,  -1.381181e-002,
   -9.940933e-002, -1.247848e-001, -9.378049e-002, -4.058175e-002, 2.354583e-002,  3.346896e-002,  0.000000e+000},
  {0.000000e+000,  9.818952e-003,  1.499853e-002,  1.960759e-002,  2.318434e-002,  2.574080e-002,  2.775447e-002,  2.919040e-002,  2.986353e-002,
   3.062855e-002,  3.093559e-002,  3.075389e-002,  3.022282e-002,  2.946587e-002,  2.867888e-002,  2.776140e-002,  2.655273e-002,  2.523487e-002,
   2.388931e-002,  2.245326e-002,  2.096800e-002,  1.952847e-002,  1.819901e-002,  1.691291e-002,  1.559457e-002,  1.421219e-002,  1.272927e-002,
   1.151155e-002,  1.045734e-002,  9.549822e-003,  8.758938e-003,  7.988960e-003,  7.219299e-003,  6.379215e-003,  5.495536e-003,  4.575293e-003,
   3.639805e-003,  2.729030e-003,  1.747399e-003,  7.205253e-004,  -3.480036e-004, -1.440240e-003, -2.577243e-003, -3.698620e-003, -4.776840e-003,
   -5.806156e-003, -6.649715e-003, -7.099926e-003, -7.575808e-003, -8.478272e-003, -9.537000e-003, -1.061276e-002, -1.179234e-002, -1.295519e-002,
   -1.412190e-002, -1.533599e-002, -1.651362e-002, -1.775972e-002, -1.900462e-002, -2.021569e-002, -2.137935e-002, -2.250282e-002, -2.364676e-002,
   -2.478457e-002, -2.589103e-002, -2.697979e-002, -2.796784e-002, -2.890759e-002, -2.967078e-002, -3.027311e-002, -3.071611e-002, -3.096854e-002,
   -3.105190e-002, -3.102692e-002, -3.076439e-002, -3.025368e-002, -2.948175e-002, -2.851022e-002, -2.731511e-002, -2.607015e-002, -2.491273e-002,
   -2.384010e-002, -2.296114e-002, -2.231210e-002, -2.184028e-002, -2.143241e-002, -2.114417e-002, -2.092675e-002, -2.080701e-002, -2.074090e-002,
   -2.067651e-002, -2.062297e-002, -2.055393e-002, -2.061712e-002, -2.063863e-002, -2.064731e-002, -2.054500e-002, -2.047579e-002, -2.030318e-002,
   -2.012116e-002, -1.983829e-002, -1.945955e-002, -1.904054e-002, -1.860399e-002, -1.818951e-002, -1.776911e-002, -1.719226e-002, -1.649034e-002,
   -1.566333e-002, -1.466559e-002, -1.351006e-002, -1.213505e-002, -1.058953e-002, -9.011192e-003, -7.436323e-003, -5.727292e-003, -3.928316e-003,
   -1.992445e-003, 8.974192e-005,  2.286372e-003,  4.583033e-003,  6.908961e-003,  9.143606e-003,  1.114208e-002,  1.271212e-002,  1.402692e-002,
   1.513441e-002,  1.607007e-002,  1.691147e-002,  1.766337e-002,  1.832133e-002,  1.895954e-002,  1.957698e-002,  2.018666e-002,  2.065226e-002,
   2.114686e-002,  2.166820e-002,  2.225948e-002,  2.296650e-002,  2.372614e-002,  2.455569e-002,  2.546958e-002,  2.644958e-002,  2.752431e-002,
   2.851189e-002,  2.951335e-002,  3.050184e-002,  3.146221e-002,  3.232278e-002,  3.303491e-002,  3.363656e-002,  3.414801e-002,  3.459613e-002,
   3.491764e-002,  3.508044e-002,  3.507885e-002,  3.497195e-002,  3.466044e-002,  3.418780e-002,  3.362565e-002,  3.299376e-002,  3.227039e-002,
   3.150613e-002,  3.073637e-002,  2.994313e-002,  2.903156e-002,  2.819884e-002,  2.747530e-002,  2.690047e-002,  2.647676e-002,  2.622011e-002,
   2.608115e-002,  2.596183e-002,  2.584847e-002,  2.574799e-002,  2.560297e-002,  2.554504e-002,  2.561403e-002,  2.582091e-002,  2.615039e-002,
   2.650537e-002,  2.677004e-002,  2.685763e-002,  2.675525e-002,  2.640230e-002,  2.576988e-002,  2.497120e-002,  2.409940e-002,  2.309558e-002,
   2.203420e-002,  2.088754e-002,  1.969956e-002,  1.850255e-002,  1.725753e-002,  1.600512e-002,  1.465650e-002,  1.331349e-002,  1.201564e-002,
   1.073941e-002,  9.496871e-003,  8.295270e-003,  7.138164e-003,  6.004973e-003,  4.916170e-003,  3.863354e-003,  2.872630e-003,  1.955567e-003,
   1.257139e-003,  7.911283e-004,  4.794258e-004,  2.494848e-004,  3.281915e-005,  -2.197102e-004, -5.021397e-004, -8.235734e-004, -1.163783e-003,
   -1.541540e-003, -1.865229e-003, -2.116324e-003, -2.303805e-003, -2.474289e-003, -2.738509e-003, -3.161664e-003, -3.818222e-003, -4.682141e-003,
   -5.723067e-003, -6.864108e-003, -8.059218e-003, -9.309062e-003, -1.057468e-002, -1.184490e-002, -1.311913e-002, -1.438953e-002, -1.569123e-002,
   -1.698183e-002, -1.828132e-002, -1.960103e-002, -2.092429e-002, -2.221503e-002, -2.344670e-002, -2.462166e-002, -2.575667e-002, -2.680329e-002,
   -2.776792e-002, -2.858255e-002, -2.926052e-002, -2.980080e-002, -3.007042e-002, -3.005558e-002, -2.980785e-002, -2.944098e-002, -2.907803e-002,
   -2.875239e-002, -2.845489e-002, -2.821704e-002, -2.804577e-002, -2.795959e-002, -2.796684e-002, -2.801437e-002, -2.808171e-002, -2.821775e-002,
   -2.841022e-002, -2.873036e-002, -2.914958e-002, -2.963509e-002, -3.016792e-002, -3.069416e-002, -3.122114e-002, -3.171156e-002, -3.212624e-002,
   -3.242061e-002, -3.254931e-002, -3.255869e-002, -3.240474e-002, -3.207796e-002, -3.150742e-002, -3.069440e-002, -2.973404e-002, -2.861308e-002,
   -2.734976e-002, -2.592394e-002, -2.438604e-002, -2.268187e-002, -2.083735e-002, -1.887880e-002, -1.676358e-002, -1.452828e-002, -1.222683e-002,
   -9.910996e-003, -7.697149e-003, -5.716295e-003, -3.975002e-003, -2.488011e-003, -1.229395e-003, -1.670860e-004, 7.130248e-004,  1.411115e-003,
   1.959777e-003,  2.363878e-003,  2.656359e-003,  2.817558e-003,  2.878800e-003,  2.851522e-003,  2.722292e-003,  2.499478e-003,  2.187900e-003,
   1.849979e-003,  1.464369e-003,  9.661331e-004,  3.871142e-004,  -2.031869e-004, -7.812035e-004, -1.339399e-003, -1.857097e-003, -2.251226e-003,
   -2.438960e-003, -2.404215e-003, -2.293223e-003, -2.202542e-003, -2.091514e-003, -2.016983e-003, -1.991163e-003, -2.003679e-003, -1.992696e-003,
   -1.951984e-003, -1.847343e-003, -1.715001e-003, -1.588561e-003, -1.534143e-003, -1.579311e-003, -1.801305e-003, -2.156941e-003, -2.605777e-003,
   -3.099607e-003, -3.594543e-003, -4.052082e-003, -4.487315e-003, -4.847348e-003, -5.198994e-003, -5.509514e-003, -5.721553e-003, -5.828530e-003,
   -5.787028e-003, -5.571880e-003, -5.160663e-003, -4.556881e-003, -3.733389e-003, -2.664242e-003, -1.336846e-003, 1.539213e-004,  1.904126e-003,
   3.781230e-003,  5.644687e-003,  7.420633e-003,  9.022404e-003,  1.042075e-002,  1.160056e-002,  1.257340e-002,  1.334066e-002,  1.388105e-002,
   1.426462e-002,  1.450891e-002,  1.467015e-002,  1.472679e-002,  1.467987e-002,  1.458256e-002,  1.448421e-002,  1.438271e-002,  1.429728e-002,
   1.416026e-002,  1.400090e-002,  1.392387e-002,  1.391444e-002,  1.399772e-002,  1.413361e-002,  1.435515e-002,  1.463092e-002,  1.500522e-002,
   1.544482e-002,  1.594138e-002,  1.643885e-002,  1.695983e-002,  1.748986e-002,  1.805780e-002,  1.865893e-002,  1.929642e-002,  1.995485e-002,
   2.062352e-002,  2.126716e-002,  2.179798e-002,  2.215527e-002,  2.237878e-002,  2.249903e-002,  2.257034e-002,  2.258675e-002,  2.256356e-002,
   2.247760e-002,  2.234394e-002,  2.215448e-002,  2.191510e-002,  2.158588e-002,  2.121658e-002,  2.083518e-002,  2.045490e-002,  2.006889e-002,
   1.964884e-002,  1.932550e-002,  1.904644e-002,  1.880722e-002,  1.859034e-002,  1.831803e-002,  1.810240e-002,  1.796490e-002,  1.792158e-002,
   1.790376e-002,  1.797503e-002,  1.805034e-002,  1.814337e-002,  1.825604e-002,  1.839174e-002,  1.842334e-002,  1.837123e-002,  1.822765e-002,
   1.799744e-002,  1.769709e-002,  1.734309e-002,  1.692787e-002,  1.644510e-002,  1.590430e-002,  1.518190e-002,  1.429688e-002,  1.326115e-002,
   1.215314e-002,  1.103236e-002,  9.895627e-003,  8.752769e-003,  7.653537e-003,  6.603188e-003,  5.610760e-003,  4.701681e-003,  3.924955e-003,
   3.301927e-003,  2.894317e-003,  2.694415e-003,  2.645150e-003,  2.629501e-003,  2.644132e-003,  2.747410e-003,  2.931045e-003,  3.220153e-003,
   3.733451e-003,  4.404081e-003,  5.215752e-003,  6.166793e-003,  7.133896e-003,  7.929002e-003,  8.467028e-003,  8.833208e-003,  9.057195e-003,
   9.199244e-003,  9.238016e-003,  9.189351e-003,  9.055917e-003,  8.858668e-003,  8.610864e-003,  8.366360e-003,  8.075824e-003,  7.760105e-003,
   7.416999e-003,  7.060883e-003,  6.682435e-003,  6.282338e-003,  5.837888e-003,  5.301670e-003,  4.678782e-003,  3.974181e-003,  3.195038e-003,
   2.353805e-003,  1.476325e-003,  5.434002e-004,  -5.081121e-004, -1.645974e-003, -2.853877e-003, -4.038449e-003, -5.204055e-003, -6.369474e-003,
   -7.547923e-003, -8.737855e-003, -9.825684e-003, -1.086921e-002, -1.177890e-002, -1.264025e-002, -1.347650e-002, -1.432887e-002, -1.519078e-002,
   -1.600234e-002, -1.676552e-002, -1.740941e-002, -1.800516e-002, -1.862422e-002, -1.931601e-002, -2.005760e-002, -2.087387e-002, -2.176012e-002,
   -2.269169e-002, -2.370805e-002, -2.477159e-002, -2.594063e-002, -2.719655e-002, -2.856106e-002, -2.997227e-002, -3.140935e-002, -3.280504e-002,
   -3.412025e-002, -3.538679e-002, -3.661685e-002, -3.771098e-002, -3.862776e-002, -3.936233e-002, -3.985066e-002, -3.989864e-002, -3.960605e-002,
   -3.915261e-002, -3.859154e-002, -3.791605e-002, -3.730514e-002, -3.670521e-002, -3.607472e-002, -3.546330e-002, -3.493799e-002, -3.442089e-002,
   -3.384176e-002, -3.319052e-002, -3.251444e-002, -3.189977e-002, -3.131892e-002, -3.090251e-002, -3.056792e-002, -3.024164e-002, -2.990268e-002,
   -2.954720e-002, -2.922679e-002, -2.895843e-002, -2.871650e-002, -2.839022e-002, -2.799755e-002, -2.747805e-002, -2.681051e-002, -2.601491e-002,
   -2.509757e-002, -2.411890e-002, -2.297619e-002, -2.171981e-002, -2.036507e-002, -1.901194e-002, -1.770296e-002, -1.657189e-002, -1.541283e-002,
   -1.424472e-002, -1.303963e-002, -1.182615e-002, -1.062778e-002, -9.587364e-003, -8.713138e-003, -7.996271e-003, -7.467818e-003, -7.093225e-003,
   -6.815596e-003, -6.590219e-003, -6.517382e-003, -6.405199e-003, -6.290927e-003, -6.175201e-003, -6.064980e-003, -5.931363e-003, -5.914312e-003,
   -6.011194e-003, -6.080280e-003, -6.118879e-003, -6.122844e-003, -6.082825e-003, -6.014157e-003, -5.996981e-003, -5.814225e-003, -5.510816e-003,
   -5.066012e-003, -4.527321e-003, -3.778197e-003, -2.832654e-003, -1.625958e-003, -6.447437e-005, 1.594093e-003,  3.235853e-003,  4.762420e-003,
   6.190860e-003,  7.458158e-003,  8.647440e-003,  9.717336e-003,  1.077773e-002,  1.181389e-002,  1.293992e-002,  1.399268e-002,  1.500162e-002,
   1.578588e-002,  1.637458e-002,  1.670778e-002,  1.692333e-002,  1.700429e-002,  1.708975e-002,  1.718453e-002,  1.724557e-002,  1.723412e-002,
   1.730729e-002,  1.737457e-002,  1.757240e-002,  1.790742e-002,  1.841615e-002,  1.900802e-002,  1.972604e-002,  2.057461e-002,  2.170112e-002,
   2.306120e-002,  2.455276e-002,  2.624552e-002,  2.803873e-002,  2.971778e-002,  3.126964e-002,  3.269919e-002,  3.395767e-002,  3.504138e-002,
   3.588449e-002,  3.650894e-002,  3.698695e-002,  3.728401e-002,  3.742317e-002,  3.742415e-002,  3.722783e-002,  3.683653e-002,  3.640420e-002,
   3.598058e-002,  3.548319e-002,  3.499686e-002,  3.451763e-002,  3.391820e-002,  3.333686e-002,  3.270185e-002,  3.209919e-002,  3.148502e-002,
   3.089143e-002,  3.031302e-002,  2.978750e-002,  2.930912e-002,  2.879062e-002,  2.826145e-002,  2.778948e-002,  2.729830e-002,  2.696557e-002,
   2.677843e-002,  2.677912e-002,  2.689909e-002,  2.701968e-002,  2.710962e-002,  2.726493e-002,  2.751488e-002,  2.786936e-002,  2.821392e-002,
   2.849835e-002,  2.883997e-002,  2.915898e-002,  2.932674e-002,  2.929333e-002,  2.889473e-002,  2.814475e-002,  2.728518e-002,  2.629229e-002,
   2.517251e-002,  2.379686e-002,  2.235207e-002,  2.080437e-002,  1.923009e-002,  1.757583e-002,  1.580078e-002,  1.406571e-002,  1.242824e-002,
   1.071497e-002,  8.972393e-003,  7.180904e-003,  5.235611e-003,  3.346815e-003,  1.513523e-003,  -2.579204e-004, -1.965171e-003, -3.541809e-003,
   -4.926594e-003, -6.142107e-003, -7.302929e-003, -8.271808e-003, -9.236613e-003, -1.002795e-002, -1.065096e-002, -1.132375e-002, -1.208104e-002,
   -1.267029e-002, -1.328805e-002, -1.381081e-002, -1.417126e-002, -1.462658e-002, -1.530833e-002, -1.600202e-002, -1.677686e-002, -1.758068e-002,
   -1.844714e-002, -1.946390e-002, -2.049727e-002, -2.158445e-002, -2.257904e-002, -2.349654e-002, -2.473067e-002, -2.589758e-002, -2.705105e-002,
   -2.795039e-002, -2.856232e-002, -2.890781e-002, -2.899630e-002, -2.881555e-002, -2.838621e-002, -2.779307e-002, -2.716146e-002, -2.642629e-002,
   -2.563436e-002, -2.459047e-002, -2.344287e-002, -2.224039e-002, -2.117459e-002, -2.010681e-002, -1.883035e-002, -1.749474e-002, -1.642101e-002,
   -1.572584e-002, -1.510100e-002, -1.448735e-002, -1.384904e-002, -1.343251e-002, -1.319576e-002, -1.299673e-002, -1.275999e-002, -1.240224e-002,
   -1.216959e-002, -1.244756e-002, -1.278806e-002, -1.295762e-002, -1.309362e-002, -1.302481e-002, -1.303374e-002, -1.304769e-002, -1.273059e-002,
   -1.234906e-002, -1.165460e-002, -1.150704e-002, -1.157438e-002, -1.183180e-002, -1.211213e-002, -1.245410e-002, -1.289924e-002, -1.338677e-002,
   -1.367434e-002, -1.400805e-002, -1.448440e-002, -1.523205e-002, -1.625185e-002, -1.724650e-002, -1.821619e-002, -1.934396e-002, -2.034902e-002,
   -2.146216e-002, -2.255429e-002, -2.345794e-002, -2.407578e-002, -2.473330e-002, -2.518774e-002, -2.545110e-002, -2.567605e-002, -2.549367e-002,
   -2.532339e-002, -2.484521e-002, -2.400662e-002, -2.284301e-002, -2.140593e-002, -1.980293e-002, -1.802680e-002, -1.626461e-002, -1.433539e-002,
   -1.243969e-002, -1.063240e-002, -8.995594e-003, -7.495592e-003, -6.149849e-003, -4.766671e-003, -3.434923e-003, -2.462650e-003, -1.622619e-003,
   -1.011871e-003, -4.786046e-004, -3.020620e-004, -8.110432e-005, -4.487170e-005, 1.467182e-004,  3.158955e-004,  5.757456e-004,  8.635201e-004,
   9.685339e-004,  1.077888e-003,  1.148168e-003,  1.222796e-003,  1.391458e-003,  1.372016e-003,  1.363429e-003,  1.558088e-003,  2.060552e-003,
   2.780482e-003,  3.324287e-003,  3.885454e-003,  4.743050e-003,  6.009577e-003,  7.458520e-003,  8.827932e-003,  1.033729e-002,  1.188023e-002,
   1.362263e-002,  1.538781e-002,  1.728339e-002,  1.895719e-002,  2.025471e-002,  2.155070e-002,  2.310467e-002,  2.442670e-002,  2.522437e-002,
   2.581312e-002,  2.626836e-002,  2.656676e-002,  2.664083e-002,  2.676569e-002,  2.698517e-002,  2.667176e-002,  2.619389e-002,  2.575163e-002,
   2.534815e-002,  2.466483e-002,  2.396365e-002,  2.356251e-002,  2.311114e-002,  2.284606e-002,  2.280984e-002,  2.289681e-002,  2.285924e-002,
   2.308825e-002,  2.379225e-002,  2.450944e-002,  2.539423e-002,  2.658280e-002,  2.752424e-002,  2.813001e-002,  2.851226e-002,  2.856533e-002,
   2.838481e-002,  2.822024e-002,  2.801485e-002,  2.717028e-002,  2.623165e-002,  2.539912e-002,  2.488814e-002,  2.394945e-002,  2.332171e-002,
   2.260363e-002,  2.219154e-002,  2.185633e-002,  2.081541e-002,  1.943175e-002,  1.827618e-002,  1.682313e-002,  1.487857e-002,  1.339682e-002,
   1.203659e-002,  1.077357e-002,  9.861793e-003,  9.231827e-003,  8.530502e-003,  8.093550e-003,  7.343214e-003,  6.680474e-003,  6.202204e-003,
   4.883752e-003,  3.693219e-003,  2.134174e-003,  6.472897e-004,  -4.158220e-004, -1.520951e-003, -2.337441e-003, -2.751046e-003, -3.519085e-003,
   -4.697765e-003, -6.970567e-003, -8.872353e-003, -1.199513e-002, -1.504418e-002, -1.777444e-002, -2.069096e-002, -2.323264e-002, -2.502690e-002,
   -2.564339e-002, -2.654564e-002, -2.730912e-002, -2.933909e-002, -3.045904e-002, -3.150551e-002, -3.235453e-002, -3.208958e-002, -3.136155e-002,
   -2.987756e-002, -2.731704e-002, -2.489743e-002, -2.326479e-002, -2.181036e-002, -2.214287e-002, -2.231096e-002, -2.173983e-002, -2.072493e-002,
   -2.063736e-002, -1.999907e-002, -1.884769e-002, -1.759909e-002, -1.611805e-002, -1.534827e-002, -1.392029e-002, -1.291553e-002, -1.164990e-002,
   -1.059609e-002, -1.020992e-002, -1.097686e-002, -1.242700e-002, -1.429676e-002, -1.659844e-002, -1.975934e-002, -2.150793e-002, -2.320610e-002,
   -2.416167e-002, -2.508076e-002, -2.643128e-002, -2.996249e-002, -3.435714e-002, -3.700306e-002, -3.891282e-002, -4.046107e-002, -4.049479e-002,
   -4.021163e-002, -3.794242e-002, -3.686781e-002, -3.464605e-002, -3.216059e-002, -3.042789e-002, -2.725401e-002, -2.508145e-002, -2.170724e-002,
   -1.935225e-002, -1.553053e-002, -1.210502e-002, -8.666101e-003, -6.973144e-003, -5.024003e-003, -3.480946e-003, -5.228054e-004, 2.267057e-003,
   9.421416e-003,  1.842274e-002,  3.038311e-002,  4.458987e-002,  6.054491e-002,  7.895482e-002,  9.876903e-002,  1.189849e-001,  1.384521e-001,
   1.575101e-001,  1.720200e-001,  1.779706e-001,  1.762056e-001,  1.708525e-001,  1.556881e-001,  1.253158e-001,  8.449835e-002,  5.209848e-002,
   2.777749e-002,  9.482413e-003,  5.796663e-003,  -2.169195e-002, -7.291030e-002, -1.185558e-001, -1.550983e-001, -1.821728e-001, -2.005274e-001,
   -2.072493e-001, -2.072711e-001, -1.935315e-001, -1.699918e-001, 4.359585e-002,  6.546174e-002,  6.839055e-002,  6.320990e-002,  4.901168e-002,
   2.848470e-002,  1.760527e-002,  1.620791e-002,  1.774181e-002,  2.077249e-002,  -5.406846e-002, 1.896780e-001,  1.055573e-001,  -7.790436e-004,
   -5.801000e-002, -6.767297e-002, -4.673779e-002, -2.526352e-002, 1.251539e-002,  2.315873e-002,  0.000000e+000},
  {0.000000e+000,  3.321641e-003,  2.592714e-003,  4.280579e-005,  -2.882593e-003, -5.925705e-003, -7.913692e-003, -9.429694e-003, -1.091851e-002,
   -1.183267e-002, -1.213341e-002, -1.224831e-002, -1.237848e-002, -1.220007e-002, -1.199929e-002, -1.180922e-002, -1.137188e-002, -1.112867e-002,
   -1.089602e-002, -1.042829e-002, -9.658761e-003, -8.949333e-003, -8.242575e-003, -7.401133e-003, -6.496119e-003, -5.475952e-003, -4.452048e-003,
   -3.293769e-003, -1.999249e-003, -3.974334e-004, 1.446205e-003,  3.243150e-003,  4.707863e-003,  6.007970e-003,  7.194176e-003,  8.228231e-003,
   9.146394e-003,  9.962331e-003,  1.062768e-002,  1.111311e-002,  1.143714e-002,  1.156361e-002,  1.129829e-002,  1.085753e-002,  1.029031e-002,
   9.681833e-003,  8.853340e-003,  7.551216e-003,  6.275372e-003,  5.500891e-003,  4.911019e-003,  4.319252e-003,  3.708039e-003,  3.093804e-003,
   2.514981e-003,  1.988017e-003,  1.433421e-003,  8.832911e-004,  3.624873e-004,  -2.069689e-004, -8.146495e-004, -1.390755e-003, -2.007189e-003,
   -2.663301e-003, -3.305663e-003, -3.917010e-003, -4.419469e-003, -4.735825e-003, -4.750429e-003, -4.605938e-003, -4.107765e-003, -3.345906e-003,
   -2.214510e-003, -7.036625e-004, 1.250681e-003,  3.629979e-003,  6.429778e-003,  9.668604e-003,  1.308283e-002,  1.644156e-002,  1.945215e-002,
   2.200512e-002,  2.414019e-002,  2.591602e-002,  2.731274e-002,  2.824080e-002,  2.880303e-002,  2.899341e-002,  2.876166e-002,  2.821096e-002,
   2.732553e-002,  2.624545e-002,  2.489571e-002,  2.348202e-002,  2.193128e-002,  2.022440e-002,  1.845329e-002,  1.657484e-002,  1.458244e-002,
   1.254092e-002,  1.038282e-002,  8.258515e-003,  6.113134e-003,  4.042283e-003,  2.118848e-003,  2.733252e-004,  -1.506062e-003, -3.124258e-003,
   -4.585993e-003, -5.747893e-003, -6.586137e-003, -7.116251e-003, -7.394826e-003, -7.391032e-003, -7.171211e-003, -6.798335e-003, -6.203427e-003,
   -5.413548e-003, -4.399422e-003, -3.168143e-003, -1.837456e-003, -4.632310e-004, 7.893468e-004,  1.679231e-003,  2.095900e-003,  1.942356e-003,
   1.277794e-003,  2.310348e-004,  -1.088318e-003, -2.608093e-003, -4.237469e-003, -5.927652e-003, -7.668679e-003, -9.388632e-003, -1.095194e-002,
   -1.238680e-002, -1.367821e-002, -1.487474e-002, -1.584987e-002, -1.661869e-002, -1.719889e-002, -1.762585e-002, -1.784472e-002, -1.789710e-002,
   -1.770237e-002, -1.732614e-002, -1.690975e-002, -1.658697e-002, -1.635392e-002, -1.624064e-002, -1.628977e-002, -1.646193e-002, -1.669166e-002,
   -1.705178e-002, -1.750696e-002, -1.800730e-002, -1.867744e-002, -1.962459e-002, -2.080652e-002, -2.207092e-002, -2.339631e-002, -2.479402e-002,
   -2.619586e-002, -2.754845e-002, -2.879991e-002, -2.991007e-002, -3.083729e-002, -3.145902e-002, -3.167492e-002, -3.154713e-002, -3.111039e-002,
   -3.046822e-002, -2.973984e-002, -2.896846e-002, -2.806556e-002, -2.687628e-002, -2.542783e-002, -2.376462e-002, -2.185718e-002, -1.976353e-002,
   -1.765176e-002, -1.569133e-002, -1.412402e-002, -1.304862e-002, -1.244769e-002, -1.208620e-002, -1.196199e-002, -1.199680e-002, -1.215593e-002,
   -1.248310e-002, -1.290529e-002, -1.343862e-002, -1.402539e-002, -1.461904e-002, -1.517468e-002, -1.560700e-002, -1.595057e-002, -1.625716e-002,
   -1.647335e-002, -1.656054e-002, -1.655177e-002, -1.644792e-002, -1.625446e-002, -1.594047e-002, -1.546482e-002, -1.479407e-002, -1.372266e-002,
   -1.225945e-002, -1.028976e-002, -7.997435e-003, -5.528429e-003, -3.089199e-003, -7.783393e-004, 1.395333e-003,  3.477471e-003,  5.584500e-003,
   7.777331e-003,  1.009818e-002,  1.252344e-002,  1.498759e-002,  1.738373e-002,  1.952703e-002,  2.126577e-002,  2.253444e-002,  2.334288e-002,
   2.381004e-002,  2.410260e-002,  2.423595e-002,  2.425126e-002,  2.421877e-002,  2.414368e-002,  2.398768e-002,  2.375503e-002,  2.348476e-002,
   2.318161e-002,  2.285410e-002,  2.251209e-002,  2.217114e-002,  2.184192e-002,  2.158209e-002,  2.149380e-002,  2.153663e-002,  2.169011e-002,
   2.205254e-002,  2.257134e-002,  2.334863e-002,  2.447820e-002,  2.607915e-002,  2.819691e-002,  3.073058e-002,  3.339784e-002,  3.602718e-002,
   3.842250e-002,  4.053192e-002,  4.236719e-002,  4.393802e-002,  4.529136e-002,  4.645622e-002,  4.740013e-002,  4.811708e-002,  4.850362e-002,
   4.858522e-002,  4.815847e-002,  4.727514e-002,  4.599768e-002,  4.443069e-002,  4.263553e-002,  4.072684e-002,  3.868882e-002,  3.651920e-002,
   3.426334e-002,  3.193309e-002,  2.962606e-002,  2.738232e-002,  2.528651e-002,  2.340912e-002,  2.182334e-002,  2.052161e-002,  1.942030e-002,
   1.846308e-002,  1.756713e-002,  1.677856e-002,  1.607202e-002,  1.552932e-002,  1.515795e-002,  1.494451e-002,  1.491904e-002,  1.505772e-002,
   1.521077e-002,  1.514021e-002,  1.461861e-002,  1.359342e-002,  1.219405e-002,  1.049815e-002,  8.612150e-003,  6.570142e-003,  4.433888e-003,
   2.235836e-003,  3.929407e-006,  -2.306059e-003, -4.623356e-003, -6.908913e-003, -9.117191e-003, -1.122007e-002, -1.314495e-002, -1.494481e-002,
   -1.663283e-002, -1.821543e-002, -1.965112e-002, -2.095159e-002, -2.209822e-002, -2.310385e-002, -2.392870e-002, -2.444801e-002, -2.456159e-002,
   -2.422051e-002, -2.347184e-002, -2.240059e-002, -2.113360e-002, -1.978791e-002, -1.853191e-002, -1.738460e-002, -1.629606e-002, -1.525086e-002,
   -1.423495e-002, -1.319321e-002, -1.217349e-002, -1.122856e-002, -1.037935e-002, -9.782279e-003, -9.631885e-003, -9.885508e-003, -1.051052e-002,
   -1.134994e-002, -1.233006e-002, -1.343798e-002, -1.461849e-002, -1.586901e-002, -1.705980e-002, -1.821320e-002, -1.930498e-002, -2.026401e-002,
   -2.106954e-002, -2.161733e-002, -2.192752e-002, -2.190976e-002, -2.147518e-002, -2.059904e-002, -1.929402e-002, -1.742499e-002, -1.518140e-002,
   -1.261313e-002, -1.001896e-002, -7.708937e-003, -5.836388e-003, -4.432362e-003, -3.487981e-003, -2.962518e-003, -2.825114e-003, -2.964421e-003,
   -3.386123e-003, -4.090620e-003, -5.002058e-003, -6.109543e-003, -7.327273e-003, -8.610146e-003, -9.900601e-003, -1.119323e-002, -1.244158e-002,
   -1.356597e-002, -1.465918e-002, -1.568940e-002, -1.658761e-002, -1.742321e-002, -1.816052e-002, -1.876619e-002, -1.923035e-002, -1.950885e-002,
   -1.959682e-002, -1.939644e-002, -1.900029e-002, -1.853808e-002, -1.805686e-002, -1.753369e-002, -1.694627e-002, -1.627330e-002, -1.558482e-002,
   -1.488460e-002, -1.424723e-002, -1.372812e-002, -1.339523e-002, -1.326354e-002, -1.336702e-002, -1.358236e-002, -1.384628e-002, -1.416378e-002,
   -1.451196e-002, -1.488297e-002, -1.527593e-002, -1.573709e-002, -1.618844e-002, -1.670405e-002, -1.722606e-002, -1.777150e-002, -1.822953e-002,
   -1.863186e-002, -1.900493e-002, -1.924612e-002, -1.931916e-002, -1.926304e-002, -1.891365e-002, -1.827377e-002, -1.745609e-002, -1.643715e-002,
   -1.524327e-002, -1.394049e-002, -1.250083e-002, -1.087176e-002, -9.173000e-003, -7.468558e-003, -5.720147e-003, -4.067719e-003, -2.609732e-003,
   -1.214611e-003, 8.934172e-005,  1.271293e-003,  2.332239e-003,  3.245626e-003,  3.928270e-003,  4.312802e-003,  4.528306e-003,  4.519030e-003,
   4.338210e-003,  4.053178e-003,  3.714664e-003,  3.340160e-003,  2.994906e-003,  2.736800e-003,  2.508877e-003,  2.409950e-003,  2.603621e-003,
   3.154887e-003,  4.128622e-003,  5.408086e-003,  6.803820e-003,  8.222514e-003,  9.569210e-003,  1.084218e-002,  1.212399e-002,  1.359248e-002,
   1.533512e-002,  1.734573e-002,  1.962636e-002,  2.202229e-002,  2.425235e-002,  2.599880e-002,  2.710987e-002,  2.758736e-002,  2.749764e-002,
   2.714775e-002,  2.648015e-002,  2.551842e-002,  2.435354e-002,  2.305600e-002,  2.160904e-002,  1.999600e-002,  1.831226e-002,  1.651710e-002,
   1.466036e-002,  1.281827e-002,  1.102577e-002,  9.206446e-003,  7.400837e-003,  5.593449e-003,  3.786305e-003,  1.972613e-003,  2.114853e-004,
   -1.515759e-003, -3.281600e-003, -5.011982e-003, -6.658060e-003, -8.222363e-003, -9.671738e-003, -1.096011e-002, -1.212414e-002, -1.315566e-002,
   -1.397659e-002, -1.454402e-002, -1.475317e-002, -1.458079e-002, -1.407919e-002, -1.344489e-002, -1.265710e-002, -1.175546e-002, -1.069331e-002,
   -9.431497e-003, -7.935916e-003, -6.251086e-003, -4.451768e-003, -2.663129e-003, -8.648447e-004, 8.309523e-004,  2.484674e-003,  4.066302e-003,
   5.491258e-003,  6.713115e-003,  7.666358e-003,  8.399299e-003,  9.039421e-003,  9.455859e-003,  9.730167e-003,  9.931253e-003,  9.994235e-003,
   9.993722e-003,  1.007099e-002,  1.028410e-002,  1.054874e-002,  1.095244e-002,  1.156079e-002,  1.250425e-002,  1.378384e-002,  1.560456e-002,
   1.778354e-002,  2.002093e-002,  2.210150e-002,  2.399389e-002,  2.561584e-002,  2.693659e-002,  2.801939e-002,  2.891124e-002,  2.961987e-002,
   3.008463e-002,  3.036073e-002,  3.036967e-002,  3.007197e-002,  2.938955e-002,  2.830023e-002,  2.685125e-002,  2.523869e-002,  2.351020e-002,
   2.167644e-002,  1.976183e-002,  1.782065e-002,  1.585395e-002,  1.398938e-002,  1.221838e-002,  1.064477e-002,  9.333372e-003,  8.346204e-003,
   7.674540e-003,  7.262850e-003,  7.146377e-003,  7.239997e-003,  7.480129e-003,  7.810700e-003,  8.086959e-003,  8.246213e-003,  8.348484e-003,
   8.448728e-003,  8.633581e-003,  8.890279e-003,  9.046792e-003,  9.032820e-003,  8.854836e-003,  8.394070e-003,  7.562755e-003,  6.502205e-003,
   5.237063e-003,  3.822572e-003,  2.267475e-003,  6.930835e-004,  -9.495906e-004, -2.608063e-003, -4.241719e-003, -5.971734e-003, -7.916746e-003,
   -9.854647e-003, -1.162972e-002, -1.337289e-002, -1.510281e-002, -1.677797e-002, -1.836914e-002, -1.979060e-002, -2.095685e-002, -2.190697e-002,
   -2.248561e-002, -2.278490e-002, -2.283621e-002, -2.256332e-002, -2.161577e-002, -1.999491e-002, -1.801104e-002, -1.606761e-002, -1.441126e-002,
   -1.305112e-002, -1.198191e-002, -1.105584e-002, -1.016212e-002, -9.235881e-003, -8.290432e-003, -7.377503e-003, -6.619576e-003, -5.967005e-003,
   -5.555641e-003, -5.530417e-003, -5.846932e-003, -6.501593e-003, -7.382442e-003, -8.206221e-003, -8.908396e-003, -9.636019e-003, -1.035491e-002,
   -1.105797e-002, -1.166029e-002, -1.205916e-002, -1.206248e-002, -1.173028e-002, -1.112025e-002, -1.016664e-002, -8.800269e-003, -7.166869e-003,
   -5.077839e-003, -2.654945e-003, 8.741897e-005,  3.017198e-003,  5.973519e-003,  8.655810e-003,  1.111326e-002,  1.311736e-002,  1.460243e-002,
   1.562391e-002,  1.613643e-002,  1.623685e-002,  1.606871e-002,  1.550503e-002,  1.471522e-002,  1.368147e-002,  1.238285e-002,  1.077292e-002,
   9.040615e-003,  7.254797e-003,  5.292937e-003,  3.270173e-003,  1.293779e-003,  -7.762852e-004, -2.764063e-003, -4.601199e-003, -6.468118e-003,
   -8.375900e-003, -1.036160e-002, -1.231126e-002, -1.413572e-002, -1.558418e-002, -1.688216e-002, -1.803804e-002, -1.892497e-002, -1.932002e-002,
   -1.931353e-002, -1.899873e-002, -1.848224e-002, -1.772208e-002, -1.672131e-002, -1.543699e-002, -1.387757e-002, -1.195271e-002, -9.794970e-003,
   -7.318321e-003, -4.693313e-003, -2.135113e-003, 2.479421e-004,  2.288364e-003,  3.763006e-003,  4.677839e-003,  5.084712e-003,  5.055777e-003,
   4.797264e-003,  4.580981e-003,  4.138838e-003,  3.394913e-003,  2.648068e-003,  1.791164e-003,  8.573600e-004,  -4.729002e-007, -9.352240e-004,
   -1.906338e-003, -2.844634e-003, -3.709358e-003, -4.473033e-003, -5.125306e-003, -5.737482e-003, -6.307470e-003, -6.833593e-003, -7.423291e-003,
   -7.860494e-003, -7.994462e-003, -7.664141e-003, -6.915605e-003, -5.844847e-003, -4.794827e-003, -3.664823e-003, -2.451599e-003, -1.301137e-003,
   -3.349384e-004, 3.277434e-004,  9.662997e-004,  1.805600e-003,  2.737111e-003,  3.879564e-003,  4.688074e-003,  5.181844e-003,  5.328146e-003,
   5.335267e-003,  4.952646e-003,  4.220014e-003,  3.308466e-003,  2.204764e-003,  1.091776e-003,  2.302012e-004,  -6.852518e-004, -1.590577e-003,
   -2.561536e-003, -3.659200e-003, -4.590463e-003, -5.522301e-003, -6.496577e-003, -7.492864e-003, -8.295959e-003, -8.921894e-003, -9.389135e-003,
   -9.857958e-003, -1.029640e-002, -1.063276e-002, -1.082072e-002, -1.107845e-002, -1.141187e-002, -1.191378e-002, -1.243624e-002, -1.309867e-002,
   -1.372544e-002, -1.430869e-002, -1.519166e-002, -1.628453e-002, -1.735740e-002, -1.868485e-002, -2.010048e-002, -2.149121e-002, -2.289539e-002,
   -2.412255e-002, -2.507247e-002, -2.583849e-002, -2.648481e-002, -2.666663e-002, -2.637743e-002, -2.589115e-002, -2.477853e-002, -2.288156e-002,
   -2.034675e-002, -1.785121e-002, -1.515602e-002, -1.251034e-002, -9.763373e-003, -6.947004e-003, -4.207495e-003, -1.683069e-003, 6.979801e-004,
   3.111165e-003,  5.657024e-003,  7.738675e-003,  9.652138e-003,  1.107152e-002,  1.212810e-002,  1.318344e-002,  1.401971e-002,  1.471052e-002,
   1.527857e-002,  1.575929e-002,  1.609279e-002,  1.652767e-002,  1.722855e-002,  1.784664e-002,  1.872166e-002,  1.956102e-002,  2.093209e-002,
   2.265772e-002,  2.441846e-002,  2.629279e-002,  2.833140e-002,  3.097102e-002,  3.388437e-002,  3.736146e-002,  4.094176e-002,  4.429463e-002,
   4.721266e-002,  4.979020e-002,  5.188926e-002,  5.363935e-002,  5.491537e-002,  5.589863e-002,  5.659179e-002,  5.676511e-002,  5.653564e-002,
   5.591879e-002,  5.511470e-002,  5.380422e-002,  5.199434e-002,  4.986991e-002,  4.760816e-002,  4.520731e-002,  4.218684e-002,  3.914884e-002,
   3.646176e-002,  3.357897e-002,  3.063625e-002,  2.733737e-002,  2.419918e-002,  2.118239e-002,  1.807655e-002,  1.485870e-002,  1.183040e-002,
   9.026062e-003,  6.620857e-003,  4.704913e-003,  2.987400e-003,  1.840756e-003,  1.242731e-003,  8.939618e-004,  5.587037e-005,  -9.270382e-004,
   -1.941550e-003, -2.841552e-003, -3.702227e-003, -4.698885e-003, -5.709013e-003, -6.632671e-003, -7.718830e-003, -8.423272e-003, -9.357050e-003,
   -1.054631e-002, -1.211548e-002, -1.428143e-002, -1.653279e-002, -1.873134e-002, -2.056412e-002, -2.283445e-002, -2.533304e-002, -2.762163e-002,
   -2.978274e-002, -3.188331e-002, -3.359572e-002, -3.475659e-002, -3.539514e-002, -3.578022e-002, -3.562228e-002, -3.525821e-002, -3.475633e-002,
   -3.406298e-002, -3.281330e-002, -3.113543e-002, -2.904255e-002, -2.702976e-002, -2.486391e-002, -2.290872e-002, -2.124425e-002, -2.010744e-002,
   -1.973424e-002, -1.953781e-002, -1.975753e-002, -2.053141e-002, -2.179165e-002, -2.267425e-002, -2.307240e-002, -2.385640e-002, -2.471124e-002,
   -2.550678e-002, -2.616918e-002, -2.670716e-002, -2.698499e-002, -2.722388e-002, -2.737727e-002, -2.810636e-002, -2.872728e-002, -2.901080e-002,
   -2.967948e-002, -3.063864e-002, -3.143548e-002, -3.247343e-002, -3.346848e-002, -3.406640e-002, -3.457848e-002, -3.461493e-002, -3.460132e-002,
   -3.435534e-002, -3.392541e-002, -3.398802e-002, -3.418863e-002, -3.414265e-002, -3.386730e-002, -3.300625e-002, -3.183807e-002, -3.120351e-002,
   -2.980161e-002, -2.831502e-002, -2.728346e-002, -2.710408e-002, -2.699529e-002, -2.687844e-002, -2.708906e-002, -2.688304e-002, -2.596364e-002,
   -2.351500e-002, -2.067922e-002, -1.722305e-002, -1.392980e-002, -1.039996e-002, -6.903864e-003, -3.067823e-003, 2.028519e-003,  8.041244e-003,
   1.414846e-002,  2.074916e-002,  2.733735e-002,  3.390441e-002,  4.194735e-002,  4.936889e-002,  5.598260e-002,  6.388697e-002,  7.169294e-002,
   7.814219e-002,  8.458951e-002,  9.041624e-002,  9.487703e-002,  9.980381e-002,  1.052409e-001,  1.095542e-001,  1.132784e-001,  1.165321e-001,
   1.183756e-001,  1.195366e-001,  1.185189e-001,  1.156774e-001,  1.116449e-001,  1.049208e-001,  9.821842e-002,  9.115314e-002,  8.341884e-002,
   7.504096e-002,  6.449259e-002,  5.356657e-002,  4.090816e-002,  2.710519e-002,  1.311753e-002,  -7.555144e-004, -1.348083e-002, -2.418057e-002,
   -3.599344e-002, -4.658415e-002, -5.642601e-002, -6.620353e-002, -7.438333e-002, -8.311919e-002, -9.137699e-002, -9.985629e-002, -1.059492e-001,
   -1.096370e-001, -1.115441e-001, -1.124293e-001, -1.146147e-001, -1.163821e-001, -1.174053e-001, -1.172222e-001, -1.168887e-001, -1.149060e-001,
   -1.083474e-001, -9.283483e-002, -7.553393e-002, -5.826291e-002, -3.989058e-002, -2.035611e-002, 9.032048e-004,  2.256097e-002,  4.528490e-002,
   6.725999e-002,  8.558692e-002,  1.046502e-001,  1.162965e-001,  1.238080e-001,  1.221044e-001,  1.128105e-001,  9.781889e-002,  8.576052e-002,
   7.408909e-002,  6.121316e-002,  4.141812e-002,  2.286778e-002,  1.366849e-003,  -2.141731e-002, -3.636421e-002, -5.005051e-002, -5.696638e-002,
   -6.666192e-002, -7.407884e-002, -7.893085e-002, -7.923572e-002, -8.687703e-002, -7.644238e-002, -6.619838e-002, -5.361237e-002, -3.777692e-002,
   -1.248031e-002, 3.198658e-002,  8.673090e-002,  1.358175e-001,  1.768163e-001,  1.353593e-002,  -5.293663e-002, -3.202199e-002, 1.470935e-002,
   3.990869e-002,  2.819456e-002,  5.089639e-002,  -2.047635e-002, -7.206468e-002, -5.793094e-002, 0.000000e+000},
  {0.000000e+000,  2.627828e-002,  4.356570e-002,  5.590066e-002,  6.513557e-002,  7.176401e-002,  7.619190e-002,  7.902456e-002,  8.052635e-002,
   8.069023e-002,  7.973241e-002,  7.958253e-002,  7.911345e-002,  7.803655e-002,  7.619397e-002,  7.366693e-002,  7.072099e-002,  6.703199e-002,
   6.262389e-002,  5.760897e-002,  5.207308e-002,  4.695460e-002,  4.210567e-002,  3.705850e-002,  3.188252e-002,  2.664688e-002,  2.123305e-002,
   1.557971e-002,  9.553154e-003,  3.115702e-003,  -3.597003e-003, -9.837649e-003, -1.495208e-002, -1.986732e-002, -2.448688e-002, -2.879064e-002,
   -3.255962e-002, -3.593399e-002, -3.872280e-002, -4.113721e-002, -4.305561e-002, -4.438058e-002, -4.419171e-002, -4.346354e-002, -4.227857e-002,
   -4.070248e-002, -3.863191e-002, -3.578455e-002, -3.300371e-002, -3.104144e-002, -2.947820e-002, -2.815277e-002, -2.631880e-002, -2.456747e-002,
   -2.288192e-002, -2.122934e-002, -1.968993e-002, -1.816338e-002, -1.675128e-002, -1.542182e-002, -1.424042e-002, -1.321213e-002, -1.201029e-002,
   -1.085904e-002, -9.875661e-003, -9.093173e-003, -8.682797e-003, -8.550510e-003, -8.935258e-003, -9.825035e-003, -1.115528e-002, -1.310271e-002,
   -1.553719e-002, -1.855467e-002, -2.229852e-002, -2.691959e-002, -3.226086e-002, -3.838606e-002, -4.491678e-002, -5.132055e-002, -5.707194e-002,
   -6.198682e-002, -6.592361e-002, -6.891807e-002, -7.108109e-002, -7.244639e-002, -7.304935e-002, -7.306753e-002, -7.234955e-002, -7.092714e-002,
   -6.894033e-002, -6.645877e-002, -6.351020e-002, -6.009382e-002, -5.631860e-002, -5.230395e-002, -4.806876e-002, -4.358208e-002, -3.902589e-002,
   -3.426490e-002, -2.934862e-002, -2.429013e-002, -1.918815e-002, -1.416938e-002, -9.207840e-003, -4.251368e-003, 4.599305e-004,  4.968922e-003,
   9.071060e-003,  1.253749e-002,  1.545266e-002,  1.766889e-002,  1.938519e-002,  2.064794e-002,  2.150962e-002,  2.206519e-002,  2.220465e-002,
   2.183589e-002,  2.100164e-002,  1.974939e-002,  1.812897e-002,  1.632388e-002,  1.471228e-002,  1.372267e-002,  1.357852e-002,  1.435166e-002,
   1.592284e-002,  1.804717e-002,  2.055896e-002,  2.333807e-002,  2.627446e-002,  2.923533e-002,  3.218247e-002,  3.508585e-002,  3.770380e-002,
   4.009361e-002,  4.223084e-002,  4.403938e-002,  4.543769e-002,  4.647158e-002,  4.703238e-002,  4.721819e-002,  4.708227e-002,  4.658257e-002,
   4.562471e-002,  4.440744e-002,  4.311149e-002,  4.188610e-002,  4.084983e-002,  4.003645e-002,  3.943564e-002,  3.902582e-002,  3.875864e-002,
   3.867983e-002,  3.867633e-002,  3.884930e-002,  3.931250e-002,  4.016473e-002,  4.135183e-002,  4.273392e-002,  4.423522e-002,  4.572808e-002,
   4.722831e-002,  4.865312e-002,  4.987304e-002,  5.071208e-002,  5.125245e-002,  5.128944e-002,  5.061868e-002,  4.918345e-002,  4.718244e-002,
   4.482501e-002,  4.230871e-002,  3.965336e-002,  3.686130e-002,  3.371874e-002,  3.012635e-002,  2.606147e-002,  2.156095e-002,  1.681697e-002,
   1.207351e-002,  7.645641e-003,  3.942093e-003,  1.261315e-003,  -4.727037e-004, -1.747022e-003, -2.521234e-003, -2.825036e-003, -2.706748e-003,
   -2.289798e-003, -1.615457e-003, -6.138811e-004, 5.522982e-004,  1.858184e-003,  3.252254e-003,  4.638838e-003,  5.958318e-003,  7.193464e-003,
   8.353948e-003,  9.482166e-003,  1.056264e-002,  1.158997e-002,  1.257172e-002,  1.349233e-002,  1.427194e-002,  1.475731e-002,  1.460136e-002,
   1.375607e-002,  1.206498e-002,  9.834518e-003,  7.357119e-003,  4.906672e-003,  2.626694e-003,  5.841220e-004,  -1.284419e-003, -3.180704e-003,
   -5.291252e-003, -7.671960e-003, -1.028605e-002, -1.308360e-002, -1.582610e-002, -1.821452e-002, -1.997544e-002, -2.085702e-002, -2.094075e-002,
   -2.041542e-002, -1.965968e-002, -1.869600e-002, -1.761817e-002, -1.646892e-002, -1.527820e-002, -1.408051e-002, -1.281317e-002, -1.146979e-002,
   -1.006414e-002, -8.645360e-003, -7.346602e-003, -6.177722e-003, -5.115387e-003, -4.225271e-003, -3.526228e-003, -3.055475e-003, -2.887008e-003,
   -3.130046e-003, -3.723315e-003, -4.816218e-003, -6.561010e-003, -9.329511e-003, -1.308004e-002, -1.760819e-002, -2.241196e-002, -2.707801e-002,
   -3.137429e-002, -3.521991e-002, -3.858883e-002, -4.152090e-002, -4.406801e-002, -4.632573e-002, -4.818105e-002, -4.956581e-002, -5.038003e-002,
   -5.065222e-002, -5.005562e-002, -4.870219e-002, -4.669505e-002, -4.415117e-002, -4.119369e-002, -3.809685e-002, -3.476382e-002, -3.125764e-002,
   -2.765345e-002, -2.397028e-002, -2.033630e-002, -1.682772e-002, -1.355076e-002, -1.067354e-002, -8.357976e-003, -6.646181e-003, -5.331191e-003,
   -4.304162e-003, -3.474017e-003, -2.859178e-003, -2.496668e-003, -2.484125e-003, -2.842075e-003, -3.545468e-003, -4.608330e-003, -6.037357e-003,
   -7.548477e-003, -8.666820e-003, -8.945608e-003, -8.333319e-003, -7.044790e-003, -5.299525e-003, -3.168177e-003, -7.802310e-004, 1.831121e-003,
   4.554385e-003,  7.302061e-003,  1.011387e-002,  1.289861e-002,  1.560955e-002,  1.823487e-002,  2.070637e-002,  2.295810e-002,  2.493980e-002,
   2.675169e-002,  2.837913e-002,  2.967944e-002,  3.078461e-002,  3.172341e-002,  3.238248e-002,  3.269337e-002,  3.244795e-002,  3.151916e-002,
   2.984039e-002,  2.745177e-002,  2.448391e-002,  2.107207e-002,  1.759081e-002,  1.421132e-002,  1.105214e-002,  8.079501e-003,  5.223456e-003,
   2.481226e-003,  -2.666574e-004, -2.984635e-003, -5.541628e-003, -7.835141e-003, -9.698211e-003, -1.073609e-002, -1.105750e-002, -1.065264e-002,
   -9.808848e-003, -8.619613e-003, -7.165417e-003, -5.528160e-003, -3.737545e-003, -2.027673e-003, -4.915721e-004, 9.000932e-004,  2.125781e-003,
   3.084694e-003,  3.606984e-003,  3.710216e-003,  3.224418e-003,  2.047428e-003,  8.909056e-005,  -2.685746e-003, -6.463310e-003, -1.106788e-002,
   -1.617413e-002, -2.126616e-002, -2.575522e-002, -2.937874e-002, -3.213212e-002, -3.404779e-002, -3.515282e-002, -3.548356e-002, -3.530158e-002,
   -3.457001e-002, -3.331769e-002, -3.166005e-002, -2.956109e-002, -2.716868e-002, -2.460390e-002, -2.199989e-002, -1.941678e-002, -1.687818e-002,
   -1.452556e-002, -1.234322e-002, -1.022435e-002, -8.267533e-003, -6.482712e-003, -4.925990e-003, -3.662302e-003, -2.644670e-003, -1.953745e-003,
   -1.541575e-003, -1.587935e-003, -1.906619e-003, -2.335506e-003, -2.794909e-003, -3.345137e-003, -3.966046e-003, -4.704764e-003, -5.528606e-003,
   -6.294894e-003, -6.970916e-003, -7.475556e-003, -7.650764e-003, -7.321992e-003, -6.547796e-003, -5.419448e-003, -4.151215e-003, -2.794719e-003,
   -1.331699e-003, 2.278603e-004,  1.888577e-003,  3.633895e-003,  5.296030e-003,  7.044443e-003,  8.851797e-003,  1.069586e-002,  1.251898e-002,
   1.422942e-002,  1.580922e-002,  1.718064e-002,  1.825214e-002,  1.907148e-002,  1.937802e-002,  1.922977e-002,  1.869040e-002,  1.781769e-002,
   1.661995e-002,  1.513754e-002,  1.341448e-002,  1.147469e-002,  9.346126e-003,  7.191739e-003,  4.980831e-003,  2.872377e-003,  1.044545e-003,
   -4.911375e-004, -1.820563e-003, -3.023930e-003, -4.040025e-003, -4.768080e-003, -5.134973e-003, -4.922964e-003, -4.274135e-003, -3.281274e-003,
   -1.981189e-003, -4.773831e-004, 1.178025e-003,  2.870916e-003,  4.530133e-003,  6.122256e-003,  7.598488e-003,  8.869598e-003,  9.583624e-003,
   9.452668e-003,  8.576515e-003,  7.207909e-003,  5.622641e-003,  4.157367e-003,  2.884576e-003,  1.662166e-003,  3.617494e-004,  -1.203779e-003,
   -3.162230e-003, -5.751424e-003, -8.731253e-003, -1.189467e-002, -1.483600e-002, -1.705839e-002, -1.807286e-002, -1.796341e-002, -1.698110e-002,
   -1.546264e-002, -1.336805e-002, -1.097402e-002, -8.277499e-003, -5.223383e-003, -1.952663e-003, 1.500560e-003,  5.084836e-003,  8.794249e-003,
   1.254274e-002,  1.631268e-002,  1.996194e-002,  2.348941e-002,  2.684761e-002,  3.014619e-002,  3.339131e-002,  3.663702e-002,  3.975877e-002,
   4.280762e-002,  4.575990e-002,  4.857074e-002,  5.123335e-002,  5.368155e-002,  5.584191e-002,  5.772099e-002,  5.927605e-002,  6.044074e-002,
   6.116607e-002,  6.139306e-002,  6.094741e-002,  5.997073e-002,  5.839929e-002,  5.642551e-002,  5.397851e-002,  5.127307e-002,  4.817413e-002,
   4.471312e-002,  4.091645e-002,  3.677714e-002,  3.241906e-002,  2.793954e-002,  2.352165e-002,  1.928957e-002,  1.524484e-002,  1.144570e-002,
   7.913581e-003,  4.728555e-003,  1.894251e-003,  -5.667448e-004, -2.675146e-003, -4.370449e-003, -5.828696e-003, -7.147513e-003, -8.359402e-003,
   -9.569339e-003, -1.085643e-002, -1.227528e-002, -1.383560e-002, -1.570066e-002, -1.798045e-002, -2.088356e-002, -2.451018e-002, -2.898965e-002,
   -3.404843e-002, -3.931568e-002, -4.424036e-002, -4.868870e-002, -5.264210e-002, -5.594705e-002, -5.865151e-002, -6.078702e-002, -6.240528e-002,
   -6.347179e-002, -6.394946e-002, -6.404549e-002, -6.344627e-002, -6.200448e-002, -5.982317e-002, -5.703574e-002, -5.381700e-002, -5.032320e-002,
   -4.659501e-002, -4.277154e-002, -3.886421e-002, -3.503232e-002, -3.137334e-002, -2.795653e-002, -2.484870e-002, -2.212347e-002, -2.005669e-002,
   -1.868707e-002, -1.784391e-002, -1.745094e-002, -1.745742e-002, -1.774705e-002, -1.826162e-002, -1.880551e-002, -1.921331e-002, -1.964651e-002,
   -2.020183e-002, -2.097378e-002, -2.173210e-002, -2.247803e-002, -2.307830e-002, -2.331256e-002, -2.298058e-002, -2.202869e-002, -2.056929e-002,
   -1.873198e-002, -1.666717e-002, -1.445166e-002, -1.210426e-002, -9.700113e-003, -7.142979e-003, -4.511546e-003, -1.918869e-003, 7.646193e-004,
   3.455287e-003,  6.092725e-003,  8.770852e-003,  1.134070e-002,  1.375535e-002,  1.595913e-002,  1.793026e-002,  1.967140e-002,  2.098857e-002,
   2.200259e-002,  2.260988e-002,  2.257011e-002,  2.170842e-002,  1.980402e-002,  1.697129e-002,  1.375342e-002,  1.072136e-002,  8.145979e-003,
   6.064675e-003,  4.619938e-003,  3.677349e-003,  3.102918e-003,  2.654093e-003,  2.276658e-003,  1.845243e-003,  1.598734e-003,  1.714934e-003,
   2.629802e-003,  4.244820e-003,  6.453924e-003,  8.952735e-003,  1.173808e-002,  1.460356e-002,  1.759296e-002,  2.059563e-002,  2.347594e-002,
   2.628005e-002,  2.883378e-002,  3.088405e-002,  3.233852e-002,  3.335692e-002,  3.385749e-002,  3.362438e-002,  3.266313e-002,  3.093414e-002,
   2.838777e-002,  2.500909e-002,  2.091384e-002,  1.620214e-002,  1.105623e-002,  6.223873e-003,  2.207844e-003,  -1.148476e-003, -3.896515e-003,
   -5.921253e-003, -7.175302e-003, -7.849110e-003, -7.802389e-003, -7.113798e-003, -6.136098e-003, -4.645588e-003, -2.724943e-003, -5.342138e-004,
   1.814076e-003,  4.357244e-003,  7.051008e-003,  9.808792e-003,  1.273379e-002,  1.582396e-002,  1.881185e-002,  2.169359e-002,  2.466471e-002,
   2.757530e-002,  3.038334e-002,  3.308778e-002,  3.564911e-002,  3.794767e-002,  4.004213e-002,  4.166380e-002,  4.264135e-002,  4.269543e-002,
   4.212728e-002,  4.088003e-002,  3.910308e-002,  3.692032e-002,  3.451467e-002,  3.170472e-002,  2.846038e-002,  2.471272e-002,  2.035176e-002,
   1.520271e-002,  9.747894e-003,  4.204373e-003,  -9.206672e-004, -5.113475e-003, -8.182988e-003, -1.037656e-002, -1.194051e-002, -1.297758e-002,
   -1.353458e-002, -1.415914e-002, -1.463003e-002, -1.471139e-002, -1.459854e-002, -1.434350e-002, -1.393638e-002, -1.341439e-002, -1.288608e-002,
   -1.212842e-002, -1.159193e-002, -1.154043e-002, -1.167506e-002, -1.183955e-002, -1.202065e-002, -1.213426e-002, -1.224055e-002, -1.256419e-002,
   -1.325272e-002, -1.432872e-002, -1.593480e-002, -1.823687e-002, -2.146896e-002, -2.492248e-002, -2.825205e-002, -3.139219e-002, -3.411288e-002,
   -3.651172e-002, -3.885327e-002, -4.111059e-002, -4.318833e-002, -4.497365e-002, -4.697960e-002, -4.867548e-002, -4.984547e-002, -5.016826e-002,
   -4.956363e-002, -4.804008e-002, -4.580773e-002, -4.307333e-002, -4.002110e-002, -3.674657e-002, -3.380281e-002, -3.097613e-002, -2.813784e-002,
   -2.504369e-002, -2.195559e-002, -1.908292e-002, -1.636935e-002, -1.383472e-002, -1.134776e-002, -8.728267e-003, -6.545807e-003, -4.838018e-003,
   -3.265082e-003, -1.787811e-003, -5.888244e-004, 5.441743e-004,  1.908081e-003,  3.255414e-003,  4.860432e-003,  6.896150e-003,  8.704352e-003,
   1.039198e-002,  1.243576e-002,  1.476070e-002,  1.744839e-002,  2.042175e-002,  2.368076e-002,  2.704792e-002,  3.052133e-002,  3.405434e-002,
   3.726289e-002,  3.978704e-002,  4.201769e-002,  4.378185e-002,  4.532412e-002,  4.633461e-002,  4.657057e-002,  4.582024e-002,  4.383243e-002,
   4.104639e-002,  3.770245e-002,  3.337082e-002,  2.917016e-002,  2.541346e-002,  2.186189e-002,  1.839014e-002,  1.519992e-002,  1.225911e-002,
   9.619294e-003,  7.152423e-003,  5.211359e-003,  3.037841e-003,  1.482596e-003,  8.586973e-004,  7.144907e-004,  1.068465e-003,  1.889440e-003,
   3.136620e-003,  4.446137e-003,  5.838287e-003,  7.281508e-003,  8.178957e-003,  8.469780e-003,  8.709169e-003,  8.774058e-003,  8.682823e-003,
   8.326442e-003,  7.176805e-003,  5.743723e-003,  3.964372e-003,  1.903091e-003,  -1.123500e-003, -5.651213e-003, -1.027072e-002, -1.489497e-002,
   -1.910395e-002, -2.255696e-002, -2.530102e-002, -2.697925e-002, -2.793650e-002, -2.812583e-002, -2.772935e-002, -2.804928e-002, -2.758423e-002,
   -2.650849e-002, -2.493337e-002, -2.285047e-002, -2.028780e-002, -1.743213e-002, -1.430325e-002, -1.066349e-002, -6.814016e-003, -4.284213e-003,
   -1.743712e-003, 9.990059e-004,  4.134005e-003,  7.182006e-003,  1.045095e-002,  1.382663e-002,  1.737234e-002,  2.079778e-002,  2.398726e-002,
   2.596310e-002,  2.709636e-002,  2.760158e-002,  2.729220e-002,  2.622348e-002,  2.504577e-002,  2.370765e-002,  2.198457e-002,  2.031694e-002,
   1.929364e-002,  1.792576e-002,  1.558601e-002,  1.327993e-002,  1.112930e-002,  8.995793e-003,  6.572884e-003,  4.731314e-003,  3.755613e-003,
   3.740523e-003,  4.365604e-003,  5.350226e-003,  5.337416e-003,  5.849048e-003,  6.781604e-003,  8.001264e-003,  9.179451e-003,  1.029018e-002,
   1.134280e-002,  1.242238e-002,  1.334398e-002,  1.406468e-002,  1.260589e-002,  1.039404e-002,  7.546527e-003,  4.408274e-003,  1.109559e-003,
   -2.896219e-003, -7.744406e-003, -1.281613e-002, -1.816120e-002, -2.368978e-002, -3.016315e-002, -3.638682e-002, -4.154844e-002, -4.597240e-002,
   -4.961307e-002, -5.211001e-002, -5.344302e-002, -5.374298e-002, -5.329088e-002, -5.217868e-002, -5.151090e-002, -5.154720e-002, -5.105957e-002,
   -4.987514e-002, -4.863344e-002, -4.686170e-002, -4.414574e-002, -4.104717e-002, -3.743972e-002, -3.319194e-002, -2.911455e-002, -2.670544e-002,
   -2.429220e-002, -2.165405e-002, -1.895595e-002, -1.625540e-002, -1.367699e-002, -1.108933e-002, -8.286070e-003, -5.442355e-003, -2.881166e-003,
   -2.614483e-003, -1.762658e-003, -1.165097e-003, -6.144086e-004, -2.642032e-004, 1.843571e-004,  6.141091e-004,  9.860957e-004,  1.572735e-003,
   2.975511e-003,  3.159087e-003,  2.998500e-003,  3.637179e-003,  4.878917e-003,  6.091669e-003,  7.524655e-003,  8.750707e-003,  9.784903e-003,
   1.074422e-002,  1.275156e-002,  1.306294e-002,  1.285488e-002,  1.395387e-002,  1.516617e-002,  1.667991e-002,  1.793865e-002,  1.927099e-002,
   2.077174e-002,  2.212471e-002,  2.390636e-002,  2.533258e-002,  2.500121e-002,  2.592449e-002,  2.731590e-002,  2.964147e-002,  3.240507e-002,
   3.572245e-002,  3.892379e-002,  4.222847e-002,  4.560767e-002,  4.891419e-002,  4.885967e-002,  4.782638e-002,  4.706603e-002,  4.697589e-002,
   4.698240e-002,  4.789162e-002,  4.933704e-002,  5.052240e-002,  5.220375e-002,  5.425961e-002,  5.209070e-002,  4.869086e-002,  4.508302e-002,
   4.169870e-002,  3.757880e-002,  3.421410e-002,  3.181283e-002,  2.941233e-002,  2.674478e-002,  2.418436e-002,  1.907172e-002,  1.191656e-002,
   4.452421e-003,  -2.718167e-003, -8.637004e-003, -1.443702e-002, -1.940271e-002, -2.347476e-002, -2.777385e-002, -3.113469e-002, -3.621604e-002,
   -4.422043e-002, -5.058789e-002, -5.483919e-002, -5.848729e-002, -5.970394e-002, -5.970384e-002, -5.792439e-002, -5.725175e-002, -5.498376e-002,
   -5.259520e-002, -5.493362e-002, -5.610667e-002, -5.671857e-002, -5.623606e-002, -5.475203e-002, -5.320966e-002, -5.055131e-002, -4.742022e-002,
   -4.302681e-002, -3.775431e-002, -3.654592e-002, -3.458210e-002, -3.180384e-002, -2.721688e-002, -1.477351e-002, 2.567142e-003,  1.660427e-002,
   2.870534e-002,  3.712421e-002,  4.358954e-002,  5.346284e-002,  7.094791e-002,  8.490620e-002,  9.454099e-002,  9.268352e-002,  8.603546e-002,
   6.487314e-002,  4.228133e-002,  2.109514e-002,  5.503028e-003,  -5.066366e-002, -6.957882e-002, -8.013058e-002, -7.944767e-002, -6.659527e-002,
   -4.008165e-002, -4.099015e-003, 3.777047e-002,  7.874712e-002,  1.184827e-001,  -1.491780e-002, -7.736965e-002, -4.061215e-002, 1.468958e-002,
   3.447876e-002,  -4.454113e-003, 1.276782e-001,  4.064773e-003,  -1.035723e-001, -9.401675e-002, 0.000000e+000},
  {0.000000e+000,  3.547621e-002,  5.696037e-002,  7.054234e-002,  7.921379e-002,  8.462385e-002,  8.677876e-002,  8.676355e-002,  8.457211e-002,
   8.161055e-002,  7.790201e-002,  7.549933e-002,  7.295599e-002,  6.965965e-002,  6.577509e-002,  6.128597e-002,  5.647937e-002,  5.087796e-002,
   4.458235e-002,  3.811087e-002,  3.154634e-002,  2.607396e-002,  2.160396e-002,  1.710168e-002,  1.271629e-002,  8.405392e-003,  4.004336e-003,
   -4.734750e-004, -4.990597e-003, -9.434139e-003, -1.372162e-002, -1.743055e-002, -1.995160e-002, -2.240339e-002, -2.476201e-002, -2.699072e-002,
   -2.917438e-002, -3.142751e-002, -3.355752e-002, -3.564985e-002, -3.775528e-002, -3.981663e-002, -4.095869e-002, -4.206586e-002, -4.316132e-002,
   -4.417180e-002, -4.508013e-002, -4.579583e-002, -4.641229e-002, -4.710728e-002, -4.778820e-002, -4.839605e-002, -4.832637e-002, -4.812894e-002,
   -4.785001e-002, -4.755650e-002, -4.724626e-002, -4.681329e-002, -4.653449e-002, -4.618425e-002, -4.576769e-002, -4.535510e-002, -4.450738e-002,
   -4.353494e-002, -4.245083e-002, -4.123470e-002, -4.003358e-002, -3.860603e-002, -3.707610e-002, -3.548101e-002, -3.367063e-002, -3.179131e-002,
   -2.977682e-002, -2.747965e-002, -2.512841e-002, -2.271883e-002, -2.026472e-002, -1.774486e-002, -1.526243e-002, -1.265968e-002, -1.011775e-002,
   -7.607875e-003, -5.158386e-003, -2.665612e-003, -2.611326e-004, 2.046611e-003,  4.233984e-003,  6.294196e-003,  8.347134e-003,  1.029622e-002,
   1.219682e-002,  1.404898e-002,  1.587074e-002,  1.767257e-002,  1.934008e-002,  2.093646e-002,  2.245389e-002,  2.391636e-002,  2.527077e-002,
   2.658674e-002,  2.781539e-002,  2.891410e-002,  2.984920e-002,  3.062593e-002,  3.125746e-002,  3.182117e-002,  3.217840e-002,  3.242923e-002,
   3.258587e-002,  3.275589e-002,  3.300144e-002,  3.312341e-002,  3.325567e-002,  3.328679e-002,  3.315130e-002,  3.299599e-002,  3.273514e-002,
   3.245011e-002,  3.220969e-002,  3.193666e-002,  3.162981e-002,  3.121950e-002,  3.069806e-002,  3.009597e-002,  2.928399e-002,  2.835065e-002,
   2.733145e-002,  2.618496e-002,  2.499223e-002,  2.381573e-002,  2.260288e-002,  2.138612e-002,  2.014255e-002,  1.889497e-002,  1.748627e-002,
   1.613892e-002,  1.484245e-002,  1.350696e-002,  1.219204e-002,  1.093037e-002,  9.702737e-003,  8.511953e-003,  7.416355e-003,  6.377393e-003,
   5.216926e-003,  4.069504e-003,  2.975464e-003,  1.879038e-003,  8.439002e-004,  -1.701288e-004, -1.117807e-003, -2.031869e-003, -2.914836e-003,
   -3.768302e-003, -4.695668e-003, -5.712544e-003, -6.722541e-003, -7.678584e-003, -8.616013e-003, -9.497367e-003, -1.035963e-002, -1.113541e-002,
   -1.184981e-002, -1.250016e-002, -1.315719e-002, -1.386956e-002, -1.454541e-002, -1.516843e-002, -1.570525e-002, -1.616157e-002, -1.648192e-002,
   -1.668764e-002, -1.686500e-002, -1.709050e-002, -1.733257e-002, -1.777004e-002, -1.818691e-002, -1.855436e-002, -1.888693e-002, -1.915149e-002,
   -1.939631e-002, -1.962951e-002, -1.979836e-002, -2.002083e-002, -2.027469e-002, -2.062242e-002, -2.091931e-002, -2.118309e-002, -2.135909e-002,
   -2.144381e-002, -2.137676e-002, -2.120710e-002, -2.096172e-002, -2.059042e-002, -2.008648e-002, -1.950090e-002, -1.885748e-002, -1.810397e-002,
   -1.720526e-002, -1.613868e-002, -1.496593e-002, -1.368650e-002, -1.226422e-002, -1.072302e-002, -9.049371e-003, -7.358039e-003, -5.663777e-003,
   -3.891258e-003, -2.045170e-003, -1.636382e-004, 1.744967e-003,  3.621917e-003,  5.496730e-003,  7.364511e-003,  9.164464e-003,  1.094357e-002,
   1.260896e-002,  1.434101e-002,  1.615333e-002,  1.793667e-002,  1.971428e-002,  2.145622e-002,  2.312011e-002,  2.466105e-002,  2.610530e-002,
   2.745963e-002,  2.857697e-002,  2.963034e-002,  3.069135e-002,  3.169880e-002,  3.265673e-002,  3.354319e-002,  3.433260e-002,  3.505830e-002,
   3.570706e-002,  3.633274e-002,  3.679244e-002,  3.716464e-002,  3.750240e-002,  3.783582e-002,  3.810767e-002,  3.836460e-002,  3.858148e-002,
   3.883698e-002,  3.915140e-002,  3.954073e-002,  3.991564e-002,  4.025981e-002,  4.071078e-002,  4.119783e-002,  4.173348e-002,  4.219503e-002,
   4.257693e-002,  4.289900e-002,  4.313780e-002,  4.320722e-002,  4.314518e-002,  4.285891e-002,  4.243274e-002,  4.186217e-002,  4.113770e-002,
   4.024297e-002,  3.920791e-002,  3.790835e-002,  3.646747e-002,  3.481174e-002,  3.295448e-002,  3.072675e-002,  2.836238e-002,  2.582710e-002,
   2.311948e-002,  2.028903e-002,  1.732425e-002,  1.428509e-002,  1.118910e-002,  7.970093e-003,  4.727332e-003,  1.307236e-003,  -2.212218e-003,
   -5.732595e-003, -9.279046e-003, -1.280237e-002, -1.627107e-002, -1.975832e-002, -2.318285e-002, -2.653184e-002, -2.981665e-002, -3.307268e-002,
   -3.629147e-002, -3.938566e-002, -4.240172e-002, -4.536910e-002, -4.822087e-002, -5.088447e-002, -5.338356e-002, -5.566535e-002, -5.771809e-002,
   -5.958486e-002, -6.129184e-002, -6.274121e-002, -6.394318e-002, -6.492695e-002, -6.563864e-002, -6.604333e-002, -6.617563e-002, -6.595979e-002,
   -6.548823e-002, -6.470836e-002, -6.388973e-002, -6.275980e-002, -6.137325e-002, -5.978953e-002, -5.796512e-002, -5.589693e-002, -5.364867e-002,
   -5.125099e-002, -4.866001e-002, -4.590269e-002, -4.311949e-002, -4.038648e-002, -3.763903e-002, -3.497113e-002, -3.235027e-002, -2.973690e-002,
   -2.717698e-002, -2.468817e-002, -2.224572e-002, -1.981741e-002, -1.762449e-002, -1.560499e-002, -1.375343e-002, -1.206404e-002, -1.063405e-002,
   -9.335874e-003, -8.187904e-003, -7.139321e-003, -6.193252e-003, -5.378602e-003, -4.764400e-003, -4.314171e-003, -3.941590e-003, -3.590591e-003,
   -3.306566e-003, -3.057758e-003, -2.780313e-003, -2.527669e-003, -2.201192e-003, -1.823313e-003, -1.492728e-003, -1.243533e-003, -8.872446e-004,
   -5.465315e-004, -1.659146e-004, 1.964756e-004,  4.756516e-004,  7.243700e-004,  9.169495e-004,  1.042731e-003,  1.065695e-003,  8.887363e-004,
   6.548888e-004,  4.257568e-004,  1.623994e-004,  -1.058271e-004, -2.925541e-004, -4.303827e-004, -5.030480e-004, -5.386141e-004, -5.106781e-004,
   -5.335284e-004, -5.460528e-004, -4.991939e-004, -4.136433e-004, -1.684378e-004, 2.416606e-004,  7.277907e-004,  1.270833e-003,  1.859861e-003,
   2.518680e-003,  3.130691e-003,  3.707352e-003,  4.332805e-003,  4.984243e-003,  5.691873e-003,  6.356036e-003,  7.090192e-003,  7.810875e-003,
   8.563157e-003,  9.300814e-003,  9.950161e-003,  1.045456e-002,  1.089457e-002,  1.126804e-002,  1.164306e-002,  1.201557e-002,  1.237488e-002,
   1.278852e-002,  1.325236e-002,  1.365240e-002,  1.406841e-002,  1.439940e-002,  1.478766e-002,  1.519718e-002,  1.563759e-002,  1.612838e-002,
   1.663351e-002,  1.712195e-002,  1.761671e-002,  1.816357e-002,  1.879989e-002,  1.935316e-002,  1.996410e-002,  2.065829e-002,  2.138201e-002,
   2.227852e-002,  2.321649e-002,  2.414859e-002,  2.519348e-002,  2.630376e-002,  2.734890e-002,  2.831907e-002,  2.915795e-002,  3.005297e-002,
   3.095296e-002,  3.179249e-002,  3.264209e-002,  3.341960e-002,  3.412970e-002,  3.481971e-002,  3.546491e-002,  3.601730e-002,  3.634579e-002,
   3.663454e-002,  3.689082e-002,  3.701661e-002,  3.712872e-002,  3.719527e-002,  3.722811e-002,  3.722395e-002,  3.712791e-002,  3.704749e-002,
   3.690542e-002,  3.670423e-002,  3.651267e-002,  3.626574e-002,  3.589362e-002,  3.539710e-002,  3.475347e-002,  3.403829e-002,  3.317088e-002,
   3.220293e-002,  3.105627e-002,  2.979557e-002,  2.840891e-002,  2.686821e-002,  2.520048e-002,  2.336865e-002,  2.127739e-002,  1.910732e-002,
   1.683556e-002,  1.441321e-002,  1.181497e-002,  9.122242e-003,  6.321727e-003,  3.511831e-003,  7.085633e-004,  -2.092576e-003, -4.886330e-003,
   -7.721182e-003, -1.059578e-002, -1.332059e-002, -1.597201e-002, -1.859856e-002, -2.106954e-002, -2.345178e-002, -2.570654e-002, -2.783431e-002,
   -2.966961e-002, -3.126138e-002, -3.271318e-002, -3.403561e-002, -3.517624e-002, -3.625713e-002, -3.723128e-002, -3.809538e-002, -3.868026e-002,
   -3.911762e-002, -3.943440e-002, -3.959776e-002, -3.963124e-002, -3.952376e-002, -3.919323e-002, -3.888431e-002, -3.839034e-002, -3.771546e-002,
   -3.702977e-002, -3.617299e-002, -3.527720e-002, -3.419630e-002, -3.295273e-002, -3.164608e-002, -3.041417e-002, -2.928898e-002, -2.813279e-002,
   -2.694768e-002, -2.578592e-002, -2.469363e-002, -2.373422e-002, -2.286685e-002, -2.197650e-002, -2.099563e-002, -1.995272e-002, -1.901370e-002,
   -1.824215e-002, -1.748614e-002, -1.677195e-002, -1.614666e-002, -1.553161e-002, -1.488914e-002, -1.427217e-002, -1.368859e-002, -1.311977e-002,
   -1.257429e-002, -1.219071e-002, -1.191097e-002, -1.165035e-002, -1.138351e-002, -1.095540e-002, -1.050061e-002, -9.961585e-003, -9.303637e-003,
   -8.627051e-003, -8.002157e-003, -7.420625e-003, -6.769707e-003, -6.271510e-003, -5.778752e-003, -5.253697e-003, -4.712777e-003, -4.107146e-003,
   -3.322076e-003, -2.377213e-003, -1.484745e-003, -6.093864e-004, 3.617376e-004,  1.448650e-003,  2.481607e-003,  3.630674e-003,  4.841672e-003,
   6.190834e-003,  7.577485e-003,  9.061530e-003,  1.055121e-002,  1.197034e-002,  1.327674e-002,  1.459672e-002,  1.585084e-002,  1.713619e-002,
   1.831245e-002,  1.924772e-002,  2.004078e-002,  2.076805e-002,  2.134358e-002,  2.170871e-002,  2.185719e-002,  2.178140e-002,  2.143583e-002,
   2.111330e-002,  2.071848e-002,  2.030859e-002,  1.992772e-002,  1.964012e-002,  1.933981e-002,  1.890874e-002,  1.837687e-002,  1.785506e-002,
   1.721102e-002,  1.651854e-002,  1.592481e-002,  1.532413e-002,  1.463462e-002,  1.397644e-002,  1.336471e-002,  1.263563e-002,  1.183665e-002,
   1.102487e-002,  1.017544e-002,  9.274391e-003,  8.459909e-003,  7.853330e-003,  7.147361e-003,  6.472924e-003,  6.009735e-003,  5.650874e-003,
   5.027562e-003,  4.306640e-003,  3.533646e-003,  2.771919e-003,  2.100479e-003,  1.493026e-003,  9.588593e-004,  4.967573e-004,  7.309668e-005,
   -2.205349e-004, -5.520499e-004, -1.019814e-003, -1.243300e-003, -1.391244e-003, -1.587863e-003, -1.735729e-003, -1.578080e-003, -1.421772e-003,
   -1.270895e-003, -9.989600e-004, -6.305420e-004, -3.582024e-004, -1.386532e-005, 4.372084e-004,  8.428798e-004,  1.318285e-003,  1.888251e-003,
   2.620867e-003,  3.426770e-003,  4.396926e-003,  5.611456e-003,  6.384280e-003,  7.087899e-003,  7.693087e-003,  8.146602e-003,  8.336808e-003,
   8.491206e-003,  8.676731e-003,  8.632668e-003,  8.373485e-003,  8.133570e-003,  7.358811e-003,  6.365847e-003,  5.429238e-003,  4.524259e-003,
   3.415815e-003,  2.338171e-003,  1.209745e-003,  -2.349047e-004, -1.761399e-003, -3.163080e-003, -4.641567e-003, -6.310759e-003, -7.966114e-003,
   -9.573688e-003, -1.128391e-002, -1.278044e-002, -1.420052e-002, -1.551112e-002, -1.661711e-002, -1.768753e-002, -1.875845e-002, -1.976623e-002,
   -2.051854e-002, -2.119314e-002, -2.195653e-002, -2.263158e-002, -2.325306e-002, -2.370221e-002, -2.386535e-002, -2.376975e-002, -2.353770e-002,
   -2.360874e-002, -2.350956e-002, -2.318895e-002, -2.286376e-002, -2.244608e-002, -2.191418e-002, -2.124015e-002, -2.053250e-002, -1.962835e-002,
   -1.863391e-002, -1.773704e-002, -1.697285e-002, -1.613033e-002, -1.553082e-002, -1.490081e-002, -1.424619e-002, -1.352697e-002, -1.279004e-002,
   -1.169463e-002, -1.066141e-002, -9.938796e-003, -9.426431e-003, -8.769972e-003, -8.022488e-003, -7.163118e-003, -6.230494e-003, -5.354855e-003,
   -4.626499e-003, -3.800046e-003, -2.821283e-003, -2.077848e-003, -1.720912e-003, -1.211957e-003, -5.139867e-004, 1.672896e-004,  7.380747e-004,
   1.231918e-003,  1.836812e-003,  2.588514e-003,  3.424586e-003,  4.310351e-003,  4.492074e-003,  4.857978e-003,  5.186351e-003,  5.287520e-003,
   5.017601e-003,  4.899668e-003,  5.075812e-003,  5.252189e-003,  5.406088e-003,  5.649376e-003,  5.074588e-003,  4.358268e-003,  3.678599e-003,
   3.274783e-003,  3.139339e-003,  3.153597e-003,  3.426805e-003,  3.607742e-003,  3.905392e-003,  4.436611e-003,  4.566128e-003,  4.283526e-003,
   4.044839e-003,  3.884442e-003,  3.950518e-003,  4.381439e-003,  5.230085e-003,  6.100573e-003,  6.921528e-003,  7.910408e-003,  8.788116e-003,
   9.206493e-003,  9.604025e-003,  1.032630e-002,  1.103261e-002,  1.194813e-002,  1.310615e-002,  1.451625e-002,  1.596162e-002,  1.770441e-002,
   1.949093e-002,  2.061415e-002,  2.176185e-002,  2.324692e-002,  2.509668e-002,  2.702619e-002,  2.925113e-002,  3.164147e-002,  3.382193e-002,
   3.611470e-002,  3.868504e-002,  4.032994e-002,  4.191587e-002,  4.365399e-002,  4.505602e-002,  4.602139e-002,  4.703545e-002,  4.828186e-002,
   4.950167e-002,  5.056748e-002,  5.159618e-002,  5.140171e-002,  5.091424e-002,  5.052093e-002,  4.952834e-002,  4.812491e-002,  4.659471e-002,
   4.530327e-002,  4.399353e-002,  4.279523e-002,  4.131729e-002,  3.915855e-002,  3.672639e-002,  3.422345e-002,  3.162054e-002,  2.886251e-002,
   2.609826e-002,  2.346507e-002,  2.101739e-002,  1.885243e-002,  1.670885e-002,  1.428507e-002,  1.101200e-002,  7.376377e-003,  3.821890e-003,
   1.631110e-004,  -3.441841e-003, -6.837429e-003, -9.625744e-003, -1.232796e-002, -1.509366e-002, -1.773156e-002, -2.152922e-002, -2.487684e-002,
   -2.821601e-002, -3.144637e-002, -3.439800e-002, -3.656986e-002, -3.871948e-002, -4.066808e-002, -4.237258e-002, -4.364921e-002, -4.626492e-002,
   -4.924201e-002, -5.204788e-002, -5.437201e-002, -5.628460e-002, -5.767088e-002, -5.875988e-002, -5.963978e-002, -5.998494e-002, -5.999040e-002,
   -6.086009e-002, -6.220630e-002, -6.352688e-002, -6.450047e-002, -6.509565e-002, -6.536775e-002, -6.543613e-002, -6.509523e-002, -6.454990e-002,
   -6.332388e-002, -6.251115e-002, -6.259580e-002, -6.253274e-002, -6.204282e-002, -6.127282e-002, -6.019903e-002, -5.879818e-002, -5.693768e-002,
   -5.482688e-002, -5.256728e-002, -5.046707e-002, -5.017654e-002, -4.930373e-002, -4.774042e-002, -4.563187e-002, -4.323567e-002, -4.064778e-002,
   -3.763459e-002, -3.419645e-002, -3.047666e-002, -2.653407e-002, -2.417219e-002, -2.160950e-002, -1.840240e-002, -1.456073e-002, -1.049088e-002,
   -6.001775e-003, -1.034906e-003, 4.698963e-003,  1.034955e-002,  1.615834e-002,  2.027239e-002,  2.352100e-002,  2.685419e-002,  3.013953e-002,
   3.336232e-002,  3.692365e-002,  4.060177e-002,  4.403997e-002,  4.779257e-002,  5.144838e-002,  5.346909e-002,  5.418464e-002,  5.525373e-002,
   5.576491e-002,  5.655827e-002,  5.773097e-002,  5.916615e-002,  6.029972e-002,  6.199814e-002,  6.407098e-002,  6.529458e-002,  6.488477e-002,
   6.441998e-002,  6.396437e-002,  6.344763e-002,  6.343303e-002,  6.340507e-002,  6.365962e-002,  6.389971e-002,  6.415027e-002,  6.437890e-002,
   6.137377e-002,  5.916727e-002,  5.650317e-002,  5.378682e-002,  5.175786e-002,  4.945596e-002,  4.711811e-002,  4.503453e-002,  4.304100e-002,
   4.128570e-002,  3.646880e-002,  3.115310e-002,  2.591698e-002,  2.061017e-002,  1.564980e-002,  1.097586e-002,  6.396060e-003,  2.617911e-003,
   -1.018952e-003, -3.934453e-003, -8.660800e-003, -1.466175e-002, -2.018296e-002, -2.571675e-002, -3.061892e-002, -3.445474e-002, -3.722479e-002,
   -3.890797e-002, -4.001355e-002, -4.085412e-002, -4.220000e-002, -4.563460e-002, -4.938268e-002, -5.240873e-002, -5.457861e-002, -5.594393e-002,
   -5.665137e-002, -5.625688e-002, -5.441459e-002, -5.150242e-002, -4.847541e-002, -4.897426e-002, -4.801716e-002, -4.628311e-002, -4.362039e-002,
   -4.056376e-002, -3.591383e-002, -3.069531e-002, -2.525436e-002, -1.867304e-002, -1.135140e-002, -7.748249e-003, -3.720367e-003, 3.022880e-004,
   5.286934e-003,  1.047223e-002,  1.602796e-002,  2.094498e-002,  2.468319e-002,  2.842591e-002,  3.315739e-002,  3.537407e-002,  3.557003e-002,
   3.559375e-002,  3.626486e-002,  3.562214e-002,  3.521006e-002,  3.426653e-002,  3.224883e-002,  2.911543e-002,  2.454977e-002,  1.751733e-002,
   9.782654e-003,  2.955298e-003,  -2.676502e-003, -5.892644e-003, -9.977203e-003, -1.416451e-002, -1.698550e-002, -2.214304e-002, -2.708398e-002,
   -3.271888e-002, -3.896387e-002, -4.202464e-002, -4.200670e-002, -4.084843e-002, -3.737876e-002, -3.303173e-002, -2.581727e-002, -1.959411e-002,
   -1.070993e-002, -1.840049e-003, 3.178440e-003,  8.753807e-003,  1.388705e-002,  1.870795e-002,  2.087077e-002,  2.178182e-002,  2.371899e-002,
   2.941934e-002,  3.357092e-002,  4.397517e-002,  4.914990e-002,  4.824721e-002,  4.816658e-002,  4.365053e-002,  3.172038e-002,  1.818547e-002,
   -9.579098e-003, -3.836193e-002, -6.022345e-002, -6.574692e-002, -4.170235e-002, -4.118005e-002, -4.242912e-002, -3.494630e-002, -2.406701e-002,
   -1.465459e-002, 1.795495e-003,  3.156696e-002,  5.742234e-002,  8.034192e-002,  -4.801566e-002, 2.853384e-002,  2.415555e-002,  1.567828e-002,
   -7.567735e-004, -3.003692e-002, 7.782000e-002,  -2.678888e-002, -7.699702e-002, -5.553528e-002, 0.000000e+000},
  {0.000000e+000,  3.008405e-002,  5.354544e-002,  7.067570e-002,  8.279900e-002,  9.123324e-002,  9.610622e-002,  9.700966e-002,  9.608442e-002,
   9.373228e-002,  8.968379e-002,  8.610728e-002,  8.239419e-002,  7.799348e-002,  7.347316e-002,  6.856660e-002,  6.320199e-002,  5.769970e-002,
   5.210802e-002,  4.626127e-002,  3.998981e-002,  3.439194e-002,  2.938732e-002,  2.426256e-002,  1.896747e-002,  1.364328e-002,  8.309543e-003,
   2.834052e-003,  -2.504120e-003, -7.962219e-003, -1.364893e-002, -1.910270e-002, -2.362982e-002, -2.791792e-002, -3.199797e-002, -3.590144e-002,
   -3.954212e-002, -4.285837e-002, -4.597219e-002, -4.882407e-002, -5.138121e-002, -5.362549e-002, -5.496518e-002, -5.593701e-002, -5.677308e-002,
   -5.748681e-002, -5.827729e-002, -5.930766e-002, -6.011182e-002, -6.016183e-002, -5.985998e-002, -5.946679e-002, -5.852603e-002, -5.745804e-002,
   -5.619291e-002, -5.483750e-002, -5.321896e-002, -5.154575e-002, -4.963832e-002, -4.754704e-002, -4.538433e-002, -4.303045e-002, -4.050474e-002,
   -3.790229e-002, -3.523516e-002, -3.254073e-002, -2.980780e-002, -2.717292e-002, -2.464618e-002, -2.209672e-002, -1.987734e-002, -1.770826e-002,
   -1.580308e-002, -1.420071e-002, -1.287072e-002, -1.184785e-002, -1.121186e-002, -1.079929e-002, -1.054156e-002, -1.041532e-002, -1.002742e-002,
   -9.359219e-003, -8.610346e-003, -7.789516e-003, -6.695096e-003, -5.453331e-003, -4.040506e-003, -2.436448e-003, -5.938020e-004, 1.317206e-003,
   3.402563e-003,  5.521493e-003,  7.855443e-003,  9.846045e-003,  1.205460e-002,  1.413745e-002,  1.629454e-002,  1.841037e-002,  2.053015e-002,
   2.269331e-002,  2.479379e-002,  2.682107e-002,  2.891425e-002,  3.070595e-002,  3.237254e-002,  3.387378e-002,  3.523501e-002,  3.640997e-002,
   3.733692e-002,  3.792465e-002,  3.828606e-002,  3.832309e-002,  3.813335e-002,  3.759891e-002,  3.678423e-002,  3.585357e-002,  3.472445e-002,
   3.344240e-002,  3.197320e-002,  3.029982e-002,  2.851151e-002,  2.668268e-002,  2.492155e-002,  2.335095e-002,  2.191184e-002,  2.087757e-002,
   2.017537e-002,  1.971369e-002,  1.938398e-002,  1.909021e-002,  1.891038e-002,  1.885656e-002,  1.883243e-002,  1.889309e-002,  1.860773e-002,
   1.819826e-002,  1.770701e-002,  1.715965e-002,  1.646123e-002,  1.566800e-002,  1.478379e-002,  1.381292e-002,  1.274049e-002,  1.163604e-002,
   1.016170e-002,  8.535842e-003,  7.029566e-003,  5.643495e-003,  4.405247e-003,  3.376433e-003,  2.481592e-003,  1.698639e-003,  1.063470e-003,
   6.251477e-004,  1.678162e-004,  -3.531079e-004, -7.029354e-004, -7.829977e-004, -6.556778e-004, -4.086731e-004, 4.495372e-005,  5.540523e-004,
   1.066889e-003,  1.581016e-003,  2.057286e-003,  2.265356e-003,  2.438156e-003,  2.492686e-003,  2.310561e-003,  1.829938e-003,  1.113294e-003,
   3.386383e-004,  -4.420929e-004, -1.265555e-003, -2.180625e-003, -3.340346e-003, -4.672067e-003, -6.190333e-003, -7.859201e-003, -9.593834e-003,
   -1.132352e-002, -1.296282e-002, -1.427747e-002, -1.519722e-002, -1.569738e-002, -1.609516e-002, -1.624571e-002, -1.615155e-002, -1.591443e-002,
   -1.548547e-002, -1.491936e-002, -1.420084e-002, -1.334600e-002, -1.239079e-002, -1.135042e-002, -1.042085e-002, -9.499740e-003, -8.555257e-003,
   -7.552962e-003, -6.509079e-003, -5.408240e-003, -4.263729e-003, -3.114538e-003, -1.943377e-003, -8.144698e-004, 1.911612e-004,  8.286117e-004,
   1.271274e-003,  1.401623e-003,  1.403688e-003,  1.300111e-003,  1.215844e-003,  1.243042e-003,  1.354118e-003,  1.536264e-003,  1.625615e-003,
   1.614898e-003,  1.571843e-003,  1.433526e-003,  1.207264e-003,  9.579352e-004,  8.281522e-004,  9.664205e-004,  1.477677e-003,  2.251320e-003,
   3.223537e-003,  4.235228e-003,  5.271962e-003,  6.332567e-003,  7.376271e-003,  8.423107e-003,  9.509160e-003,  1.061887e-002,  1.174063e-002,
   1.289915e-002,  1.404457e-002,  1.512919e-002,  1.612496e-002,  1.711214e-002,  1.803889e-002,  1.890345e-002,  1.967306e-002,  2.035113e-002,
   2.088208e-002,  2.124164e-002,  2.139319e-002,  2.127534e-002,  2.075450e-002,  1.979327e-002,  1.852713e-002,  1.716478e-002,  1.581413e-002,
   1.456343e-002,  1.342340e-002,  1.238704e-002,  1.148153e-002,  1.068397e-002,  1.000988e-002,  9.376271e-003,  8.761889e-003,  8.220361e-003,
   7.777956e-003,  7.526178e-003,  7.495194e-003,  7.569309e-003,  7.682555e-003,  7.811962e-003,  7.873380e-003,  7.897152e-003,  7.831993e-003,
   7.645498e-003,  7.319078e-003,  6.859914e-003,  6.198263e-003,  5.296796e-003,  4.090739e-003,  2.579168e-003,  7.711977e-004,  -1.290253e-003,
   -3.522542e-003, -5.906549e-003, -8.412200e-003, -1.110266e-002, -1.396291e-002, -1.702028e-002, -2.023735e-002, -2.358479e-002, -2.700684e-002,
   -3.043529e-002, -3.366038e-002, -3.646848e-002, -3.871031e-002, -4.051018e-002, -4.186214e-002, -4.291580e-002, -4.365371e-002, -4.406761e-002,
   -4.423191e-002, -4.413789e-002, -4.378445e-002, -4.321969e-002, -4.247935e-002, -4.158693e-002, -4.049991e-002, -3.923657e-002, -3.784975e-002,
   -3.637195e-002, -3.478674e-002, -3.316805e-002, -3.145803e-002, -2.963673e-002, -2.771265e-002, -2.574887e-002, -2.382527e-002, -2.204817e-002,
   -2.046586e-002, -1.908502e-002, -1.783134e-002, -1.673068e-002, -1.562509e-002, -1.448852e-002, -1.323276e-002, -1.189933e-002, -1.052606e-002,
   -9.182220e-003, -7.918119e-003, -6.731918e-003, -5.578053e-003, -4.430532e-003, -3.212122e-003, -1.717269e-003, 1.040194e-006,  1.905626e-003,
   3.941625e-003,  6.033642e-003,  8.117241e-003,  1.015749e-002,  1.208732e-002,  1.391085e-002,  1.558632e-002,  1.708237e-002,  1.837508e-002,
   1.943789e-002,  2.025372e-002,  2.082030e-002,  2.113406e-002,  2.105474e-002,  2.062285e-002,  1.983453e-002,  1.860578e-002,  1.694913e-002,
   1.509821e-002,  1.325031e-002,  1.157746e-002,  1.028237e-002,  9.319776e-003,  8.641473e-003,  8.296810e-003,  8.303841e-003,  8.463147e-003,
   8.819560e-003,  9.344127e-003,  9.999804e-003,  1.081452e-002,  1.170784e-002,  1.267403e-002,  1.366467e-002,  1.464904e-002,  1.556256e-002,
   1.636577e-002,  1.704302e-002,  1.762171e-002,  1.810833e-002,  1.843010e-002,  1.857367e-002,  1.855183e-002,  1.840953e-002,  1.816409e-002,
   1.774000e-002,  1.716043e-002,  1.644784e-002,  1.569096e-002,  1.490404e-002,  1.402384e-002,  1.306849e-002,  1.206425e-002,  1.104704e-002,
   9.997928e-003,  8.942546e-003,  7.951334e-003,  7.073824e-003,  6.383295e-003,  5.917138e-003,  5.557447e-003,  5.233586e-003,  4.999578e-003,
   4.767273e-003,  4.567348e-003,  4.462775e-003,  4.456770e-003,  4.468095e-003,  4.509381e-003,  4.540374e-003,  4.580288e-003,  4.654521e-003,
   4.753504e-003,  4.889820e-003,  5.023418e-003,  5.073131e-003,  4.985945e-003,  4.745505e-003,  4.396557e-003,  3.970935e-003,  3.458719e-003,
   2.912104e-003,  2.288086e-003,  1.648188e-003,  9.264925e-004,  2.283719e-004,  -4.196496e-004, -1.030445e-003, -1.605574e-003, -2.101392e-003,
   -2.414959e-003, -2.602164e-003, -2.778986e-003, -2.768669e-003, -2.612937e-003, -2.352614e-003, -1.816637e-003, -1.084505e-003, -1.919676e-004,
   8.196221e-004,  1.924901e-003,  3.085204e-003,  4.245679e-003,  5.449790e-003,  6.576491e-003,  7.522378e-003,  8.345502e-003,  8.906589e-003,
   9.030391e-003,  8.773458e-003,  8.210692e-003,  7.473661e-003,  6.637226e-003,  5.782729e-003,  4.973796e-003,  3.977038e-003,  2.744982e-003,
   1.202035e-003,  -7.269764e-004, -2.946195e-003, -5.283051e-003, -7.676133e-003, -9.926082e-003, -1.176729e-002, -1.311717e-002, -1.418911e-002,
   -1.513843e-002, -1.590096e-002, -1.664537e-002, -1.737418e-002, -1.795038e-002, -1.842037e-002, -1.893250e-002, -1.937972e-002, -1.972279e-002,
   -2.001546e-002, -2.032042e-002, -2.058377e-002, -2.082667e-002, -2.103949e-002, -2.122822e-002, -2.126898e-002, -2.116514e-002, -2.096586e-002,
   -2.062184e-002, -2.011895e-002, -1.957030e-002, -1.894582e-002, -1.824327e-002, -1.752905e-002, -1.676768e-002, -1.593264e-002, -1.504934e-002,
   -1.405314e-002, -1.307000e-002, -1.214887e-002, -1.131421e-002, -1.059897e-002, -9.962355e-003, -9.323827e-003, -8.681866e-003, -8.115931e-003,
   -7.588573e-003, -7.129258e-003, -6.775399e-003, -6.454371e-003, -6.130188e-003, -5.769189e-003, -5.259930e-003, -4.548030e-003, -3.720657e-003,
   -2.794778e-003, -1.782127e-003, -6.293710e-004, 7.967352e-004,  2.437844e-003,  4.113516e-003,  5.825785e-003,  7.540172e-003,  9.174169e-003,
   1.073491e-002,  1.229154e-002,  1.370033e-002,  1.489371e-002,  1.583074e-002,  1.656199e-002,  1.701140e-002,  1.702044e-002,  1.647421e-002,
   1.551873e-002,  1.441185e-002,  1.321235e-002,  1.202058e-002,  1.095902e-002,  9.952864e-003,  9.056477e-003,  8.080416e-003,  7.151087e-003,
   6.247071e-003,  5.399146e-003,  4.530389e-003,  3.786600e-003,  3.383828e-003,  3.094072e-003,  2.956218e-003,  3.046859e-003,  3.197785e-003,
   3.375202e-003,  3.533441e-003,  3.794123e-003,  3.993645e-003,  4.097964e-003,  4.184038e-003,  4.228373e-003,  4.122408e-003,  3.815368e-003,
   3.244704e-003,  2.388669e-003,  1.413433e-003,  3.385182e-004,  -7.860371e-004, -1.938996e-003, -3.015892e-003, -4.164362e-003, -5.287677e-003,
   -6.259267e-003, -7.035583e-003, -7.811050e-003, -8.531654e-003, -9.053277e-003, -9.370129e-003, -9.253522e-003, -8.816276e-003, -8.016489e-003,
   -6.975866e-003, -5.853146e-003, -4.714792e-003, -3.578552e-003, -2.340743e-003, -9.899246e-004, 3.704971e-004,  1.782649e-003,  3.146510e-003,
   4.519147e-003,  5.929608e-003,  7.363935e-003,  8.647948e-003,  9.826751e-003,  1.090127e-002,  1.186721e-002,  1.277458e-002,  1.352247e-002,
   1.404602e-002,  1.432284e-002,  1.425350e-002,  1.380108e-002,  1.302885e-002,  1.197329e-002,  1.074339e-002,  9.472158e-003,  8.242226e-003,
   7.161245e-003,  6.380906e-003,  5.865844e-003,  5.447363e-003,  5.061718e-003,  4.720278e-003,  4.340846e-003,  4.008292e-003,  3.898278e-003,
   4.098702e-003,  4.592019e-003,  5.344940e-003,  6.177450e-003,  7.088400e-003,  8.117630e-003,  9.267160e-003,  1.031940e-002,  1.135745e-002,
   1.240766e-002,  1.339735e-002,  1.426065e-002,  1.469619e-002,  1.488603e-002,  1.483787e-002,  1.465042e-002,  1.427137e-002,  1.361141e-002,
   1.258008e-002,  1.118583e-002,  9.587671e-003,  7.565902e-003,  5.318216e-003,  3.037401e-003,  8.539639e-004,  -1.155478e-003, -2.857207e-003,
   -4.395995e-003, -5.713256e-003, -6.710165e-003, -7.489356e-003, -8.152912e-003, -8.797044e-003, -9.263057e-003, -9.596502e-003, -9.924186e-003,
   -1.009800e-002, -1.018282e-002, -1.027376e-002, -1.045175e-002, -1.057013e-002, -1.064196e-002, -1.080933e-002, -1.103449e-002, -1.131040e-002,
   -1.152079e-002, -1.167464e-002, -1.191086e-002, -1.211246e-002, -1.224332e-002, -1.246513e-002, -1.277643e-002, -1.331544e-002, -1.405308e-002,
   -1.493622e-002, -1.579404e-002, -1.654438e-002, -1.729663e-002, -1.785920e-002, -1.832766e-002, -1.883196e-002, -1.949268e-002, -2.022842e-002,
   -2.114275e-002, -2.205966e-002, -2.286398e-002, -2.336680e-002, -2.356865e-002, -2.340582e-002, -2.286948e-002, -2.188795e-002, -2.059611e-002,
   -1.916389e-002, -1.773876e-002, -1.598523e-002, -1.430926e-002, -1.236706e-002, -1.029174e-002, -8.200068e-003, -5.982050e-003, -3.656390e-003,
   -1.407786e-003, 9.839511e-004,  3.213069e-003,  5.335747e-003,  7.429873e-003,  9.581503e-003,  1.174499e-002,  1.376435e-002,  1.559577e-002,
   1.729612e-002,  1.897359e-002,  2.020417e-002,  2.110752e-002,  2.154321e-002,  2.168114e-002,  2.169016e-002,  2.161999e-002,  2.163316e-002,
   2.180160e-002,  2.170052e-002,  2.171544e-002,  2.168486e-002,  2.144117e-002,  2.098717e-002,  2.039692e-002,  1.998528e-002,  1.988235e-002,
   2.005679e-002,  2.044900e-002,  2.079830e-002,  2.128448e-002,  2.204007e-002,  2.261329e-002,  2.268444e-002,  2.267682e-002,  2.263348e-002,
   2.252209e-002,  2.213057e-002,  2.140054e-002,  2.012606e-002,  1.859418e-002,  1.680597e-002,  1.489280e-002,  1.266524e-002,  1.025876e-002,
   7.573454e-003,  4.807049e-003,  1.651448e-003,  -1.526355e-003, -4.526581e-003, -7.507863e-003, -1.007024e-002, -1.232168e-002, -1.479224e-002,
   -1.723593e-002, -1.911296e-002, -2.091134e-002, -2.230611e-002, -2.349948e-002, -2.449371e-002, -2.495606e-002, -2.519168e-002, -2.531697e-002,
   -2.550824e-002, -2.610805e-002, -2.663825e-002, -2.695437e-002, -2.683276e-002, -2.663800e-002, -2.686426e-002, -2.730249e-002, -2.792274e-002,
   -2.855388e-002, -2.888278e-002, -2.949299e-002, -2.980621e-002, -2.984723e-002, -2.931396e-002, -2.837362e-002, -2.733471e-002, -2.615015e-002,
   -2.465895e-002, -2.307224e-002, -2.138107e-002, -1.976163e-002, -1.797382e-002, -1.582725e-002, -1.348870e-002, -1.068983e-002, -7.705052e-003,
   -4.980787e-003, -2.318467e-003, 4.168727e-004,  3.659154e-003,  6.571984e-003,  8.942336e-003,  1.120934e-002,  1.313263e-002,  1.489564e-002,
   1.612421e-002,  1.700769e-002,  1.757036e-002,  1.801883e-002,  1.826544e-002,  1.821835e-002,  1.739990e-002,  1.629204e-002,  1.537302e-002,
   1.467968e-002,  1.446658e-002,  1.466377e-002,  1.511077e-002,  1.585060e-002,  1.671712e-002,  1.803559e-002,  1.865758e-002,  1.921346e-002,
   1.998747e-002,  2.096945e-002,  2.210208e-002,  2.332777e-002,  2.468760e-002,  2.624481e-002,  2.794235e-002,  2.962765e-002,  3.061398e-002,
   3.141400e-002,  3.234296e-002,  3.329740e-002,  3.397380e-002,  3.422033e-002,  3.456078e-002,  3.481717e-002,  3.481675e-002,  3.464256e-002,
   3.427367e-002,  3.335879e-002,  3.209125e-002,  3.036126e-002,  2.849070e-002,  2.618503e-002,  2.375118e-002,  2.171200e-002,  1.983796e-002,
   1.810896e-002,  1.595337e-002,  1.322287e-002,  1.060974e-002,  8.008892e-003,  5.488808e-003,  3.177876e-003,  6.892999e-004,  -1.861419e-003,
   -3.905315e-003, -5.615933e-003, -6.477035e-003, -7.722098e-003, -8.802171e-003, -9.997406e-003, -1.143432e-002, -1.252381e-002, -1.305749e-002,
   -1.373092e-002, -1.430825e-002, -1.491452e-002, -1.587437e-002, -1.799698e-002, -2.028447e-002, -2.279145e-002, -2.518664e-002, -2.741485e-002,
   -2.987952e-002, -3.337085e-002, -3.710501e-002, -3.897720e-002, -4.081985e-002, -4.347000e-002, -4.649629e-002, -4.841765e-002, -4.979700e-002,
   -5.048892e-002, -5.040954e-002, -4.970096e-002, -4.863381e-002, -4.768624e-002, -4.706671e-002, -4.568281e-002, -4.395691e-002, -4.190381e-002,
   -3.990355e-002, -3.800627e-002, -3.556637e-002, -3.288106e-002, -3.003691e-002, -2.740138e-002, -2.464016e-002, -2.240822e-002, -2.184800e-002,
   -2.026057e-002, -1.822488e-002, -1.628862e-002, -1.400031e-002, -1.100350e-002, -8.228068e-003, -4.996591e-003, -1.386659e-003, 1.951940e-003,
   3.100905e-003,  3.915576e-003,  5.117104e-003,  6.359899e-003,  7.180362e-003,  8.266997e-003,  9.724186e-003,  1.130169e-002,  1.413361e-002,
   1.698530e-002,  1.885142e-002,  2.041549e-002,  2.187720e-002,  2.417740e-002,  2.637841e-002,  2.925352e-002,  3.216048e-002,  3.451182e-002,
   3.800080e-002,  4.140761e-002,  4.350901e-002,  4.445830e-002,  4.614707e-002,  4.797196e-002,  4.886392e-002,  4.951336e-002,  4.987282e-002,
   5.050930e-002,  5.088068e-002,  5.119124e-002,  5.022661e-002,  4.731176e-002,  4.628844e-002,  4.553865e-002,  4.552574e-002,  4.597417e-002,
   4.649745e-002,  4.633937e-002,  4.586071e-002,  4.531632e-002,  4.363126e-002,  4.048021e-002,  3.668521e-002,  3.171079e-002,  2.713207e-002,
   2.318774e-002,  1.711720e-002,  1.014823e-002,  3.297289e-003,  -5.042592e-003, -1.366325e-002, -2.347715e-002, -3.374385e-002, -4.334974e-002,
   -5.334651e-002, -5.932877e-002, -6.526050e-002, -7.100234e-002, -7.405059e-002, -7.714797e-002, -7.943400e-002, -8.326746e-002, -8.518238e-002,
   -8.542316e-002, -8.574789e-002, -8.321488e-002, -8.024120e-002, -7.727505e-002, -7.213023e-002, -6.479122e-002, -5.360654e-002, -4.304064e-002,
   -3.615465e-002, -2.824676e-002, -1.914719e-002, -1.053044e-002, 3.138012e-004,  1.229125e-002,  2.536504e-002,  4.203642e-002,  5.759952e-002,
   7.290663e-002,  7.889171e-002,  8.153252e-002,  8.120813e-002,  7.959665e-002,  7.350519e-002,  6.594953e-002,  5.632963e-002,  5.075325e-002,
   4.602097e-002,  4.254265e-002,  3.325535e-002,  2.223358e-002,  1.108514e-002,  2.195591e-003,  -7.477773e-003, -1.870994e-002, -2.681347e-002,
   -3.679152e-002, -4.646792e-002, -7.410067e-002, -9.741271e-002, -1.163309e-001, -1.310746e-001, -1.267222e-001, -9.415816e-002, -4.671337e-002,
   2.895577e-002,  1.067116e-001,  1.685572e-001,  1.989994e-001,  7.465895e-002,  8.237451e-002,  9.721190e-002,  9.244105e-002,  6.791985e-002,
   3.875252e-002,  -3.855179e-003, -7.265016e-002, -1.376942e-001, -1.874766e-001, 9.983949e-002,  -1.661128e-001, -1.045779e-001, -5.498856e-003,
   5.329486e-002,  6.718175e-002,  4.625283e-003,  7.501236e-002,  4.167842e-002,  1.054109e-002,  0.000000e+000}};

const double* getEmorInvCurve(int i) { return kEmorInv[i]; }

}  // namespace hdr
}  // namespace aliceVision
