#!/usr/bin/perl 

package ExportBase;

sub new
{
    my $class = shift;
    my $self = {
        _inputFile => shift,
        _outputFile  => shift,
        _description => shift,
        _devices => shift,
        _notes => shift,
        _version => shift,
        _extension => ".m4v",
    };
    bless $self, $class;
    return $self;
}

sub checkOutput{
    my( $self ) = @_;
    if (-e "$self->{_outputFile}$self->{_extension}"){
        return 1;
    }
    else{
        return 0;
    }
}

sub Description {
	my $self = shift;
	$self->{_description} = shift if @_;
	return $self->{_description};
} 

sub Devices {
	my $self = shift;
	$self->{_devices} = shift if @_;
	return $self->{_devices};
} 

sub Notes {
	my $self = shift;
	$self->{_notes} = shift if @_;
	return $self->{_notes};
} 

sub Extension {
	my $self = shift;
	$self->{_extension} = shift if @_;
	return $self->{_extension};
} 

sub Version {
	my $self = shift;
	$self->{_version} = shift if @_;
	return $self->{_version};
} 

1;
