#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Arise: A Simple Story
# send your bug reports to contact@dotslashplay.it
###

script_version=20230709.1

GAME_ID='arise-a-simple-story'
GAME_NAME='Arise: A Simple Story'

ARCHIVE_BASE_0='setup_arise_a_simple_story_1.20.3_(64bit)_(53242).exe'
ARCHIVE_BASE_0_MD5='7b0ce5207861d990aa4d2c4ba9baefb1'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_arise_a_simple_story_1.20.3_(64bit)_(53242)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='a364d73d653de062ff7f2808614bd6ef'
ARCHIVE_BASE_0_PART2='setup_arise_a_simple_story_1.20.3_(64bit)_(53242)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='ab2a758bd1885455e45336ba70cbc018'
ARCHIVE_BASE_0_SIZE='5800000'
ARCHIVE_BASE_0_VERSION='1.20.3-gog53242'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/arise_a_simple_story'

UNREALENGINE4_NAME='arise'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES="
engine
${UNREALENGINE4_NAME}/binaries
${UNREALENGINE4_NAME}/plugins
${UNREALENGINE4_NAME}.exe"
CONTENT_GAME_DATA_FILES="
${UNREALENGINE4_NAME}"

WINE_DIRECT3D_RENDERER='dxvk'

WINE_PERSISTENT_DIRECTORIES="
users/\${USER}/AppData/Roaming/${UNREALENGINE4_NAME}/Saved"

APP_MAIN_EXE="${UNREALENGINE4_NAME}.exe"
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=101'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'

# Install required Microsoft Visual C++ libraries

APP_WINETRICKS="${APP_WINETRICKS:-} vcrun2019"

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
