/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __ls10_nxbar_discovery_h__
#define __ls10_nxbar_discovery_h__
/* This file is autogenerated.  Do not edit */
#define NV_NXBAR_DISCOVERY                     /* R--4P */
#define NV_NXBAR_DISCOVERY_ENTRY                 1:0         /* R-EVF */
#define NV_NXBAR_DISCOVERY_ENTRY_INVALID         0x00000000   /* R-E-V */
#define NV_NXBAR_DISCOVERY_ENTRY_ENUM            0x00000001   /* R---V */
#define NV_NXBAR_DISCOVERY_ENTRY_DATA1           0x00000002   /* R---V */
#define NV_NXBAR_DISCOVERY_ENTRY_DATA2           0x00000003   /* R---V */
#define NV_NXBAR_DISCOVERY_CONTENTS              30:2         /* R-EVF */
#define NV_NXBAR_DISCOVERY_CONTENTS_INIT         0x00000000   /* R-E-V */
#define NV_NXBAR_DISCOVERY_CHAIN                 31:31        /* R-EVF */
#define NV_NXBAR_DISCOVERY_CHAIN_DISABLE           0x00000000   /* R-E-V */
#define NV_NXBAR_DISCOVERY_CHAIN_ENABLE            0x00000001   /* R---V */
#define NV_NXBAR_DISCOVERY_ENUM_DEVICE                           7:2   /* R--UF */
#define NV_NXBAR_DISCOVERY_ENUM_DEVICE_INVALID                       0x0   /* R---V */
#define NV_NXBAR_DISCOVERY_ENUM_DEVICE_NXBAR                        0x1   /* R---V */
#define NV_NXBAR_DISCOVERY_ENUM_DEVICE_TILE                      0x2   /* R---V */
#define NV_NXBAR_DISCOVERY_ENUM_DEVICE_TILE_MULTICAST             0x3   /* R---V */
#define NV_NXBAR_DISCOVERY_ENUM_DEVICE_NXBAR_PERFMON                0x4   /* R---V */
#define NV_NXBAR_DISCOVERY_ENUM_DEVICE_TILE_PERFMON              0x5   /* R---V */
#define NV_NXBAR_DISCOVERY_ENUM_DEVICE_TILE_PERFMON_MULTICAST     0x6   /* R---V */
#define NV_NXBAR_DISCOVERY_ENUM_DEVICE_TILEOUT                      0x7   /* R---V */
#define NV_NXBAR_DISCOVERY_ENUM_DEVICE_TILEOUT_MULTICAST          0x8   /* R---V */
#define NV_NXBAR_DISCOVERY_ENUM_DEVICE_TILEOUT_PERFMON              0x9   /* R---V */
#define NV_NXBAR_DISCOVERY_ENUM_DEVICE_TILEOUT_PERFMON_MULTICAST  0xA   /* R---V */
#define NV_NXBAR_DISCOVERY_ENUM_ID              15:8  /* R--UF */
#define NV_NXBAR_DISCOVERY_ENUM_RESERVED                  19:16 /* R--UF */
#define NV_NXBAR_DISCOVERY_ENUM_VERSION                  30:20 /* R--UF */
#define NV_NXBAR_DISCOVERY_ENUM_VERSION_1                      0x1   /* R---V */
#define NV_NXBAR_DISCOVERY_ENUM_VERSION_2                      0x2   /* R---V */
#define NV_NXBAR_DISCOVERY_ENUM_VERSION_3                      0x3   /* R---V */
#define NV_NXBAR_DISCOVERY_DATA1_RESET                    6:2  /* R--UF */
#define NV_NXBAR_DISCOVERY_DATA1_INTR                  11:7  /* R--UF */
#define NV_NXBAR_DISCOVERY_DATA1_RESERVED2         11:2  /* R--UF */
#define NV_NXBAR_DISCOVERY_DATA1_NXBAR_LENGTH                30:12  /* R--UF */
#define NV_NXBAR_DISCOVERY_DATA1_RESERVED                      30:12  /* R--UF */
#define NV_NXBAR_DISCOVERY_DATA2_TYPE                  30:26  /* R--UF */
#define NV_NXBAR_DISCOVERY_DATA2_TYPE_INVALID          0x0    /* R---V */
#define NV_NXBAR_DISCOVERY_DATA2_TYPE_RESERVED          0x1    /* R---V */
#define NV_NXBAR_DISCOVERY_DATA2_TYPE_RESETREG          0x2    /* R---V */
#define NV_NXBAR_DISCOVERY_DATA2_TYPE_INTRREG          0x3    /* R---V */
#define NV_NXBAR_DISCOVERY_DATA2_TYPE_DISCOVERY          0x4    /* R---V */
#define NV_NXBAR_DISCOVERY_DATA2_TYPE_UNICAST          0x5    /* R---V */
#define NV_NXBAR_DISCOVERY_DATA2_TYPE_BROADCAST          0x6    /* R---V */
#define NV_NXBAR_DISCOVERY_DATA2_TYPE_MULTICAST0      0x7     /* R---V */
#define NV_NXBAR_DISCOVERY_DATA2_TYPE_MULTICAST1      0x8     /* R---V */
#define NV_NXBAR_DISCOVERY_DATA2_TYPE_MULTICAST2      0x9     /* R---V */
#define NV_NXBAR_DISCOVERY_DATA2_ADDR                  25:2   /* R--UF */
#define NV_NXBAR_DISCOVERY_PRI_BASE_ALIGN              12     /*       */
#endif // __ls10_nxbar_discovery_h__
