# Development Report for Mar 17, 2017

## Testing Plan

Thanks to @gianarb for starting the discussion around a test and CI plan for containerd.  We want to make sure that users of containerd can feel secure depending on containerd; having a solid test plan is a must.

Testing a project like containerd is always a challenge because of the systems that it needs to support. ARM, Windows, Linux, and Power (as well as many more variations) are all examples of platforms that we support today and will need a CI.

You can view the issue and contribute to the testing plan [here](https://github.com/containerd/containerd/issues/634).

## Windows Runtime

Work has started on porting over the Windows execution code.  There is still a lot of testing to do after the port but a PR should be coming soon.

## Metrics

We started the work to get container level metrics exported over prometheus.  You can see the initial output here:

```
containerd_container_blkio_io_service_bytes_recursive_bytes{id="test",major="8",minor="0",op="Async"} 958464
containerd_container_blkio_io_service_bytes_recursive_bytes{id="test",major="8",minor="0",op="Read"} 958464
containerd_container_blkio_io_service_bytes_recursive_bytes{id="test",major="8",minor="0",op="Sync"} 0
containerd_container_blkio_io_service_bytes_recursive_bytes{id="test",major="8",minor="0",op="Total"} 958464
containerd_container_blkio_io_service_bytes_recursive_bytes{id="test",major="8",minor="0",op="Write"} 0
containerd_container_blkio_io_serviced_recursive_total{id="test",major="8",minor="0",op="Async"} 17
containerd_container_blkio_io_serviced_recursive_total{id="test",major="8",minor="0",op="Read"} 17
containerd_container_blkio_io_serviced_recursive_total{id="test",major="8",minor="0",op="Sync"} 0
containerd_container_blkio_io_serviced_recursive_total{id="test",major="8",minor="0",op="Total"} 17
containerd_container_blkio_io_serviced_recursive_total{id="test",major="8",minor="0",op="Write"} 0
containerd_container_cpu_kernel_nanoseconds{id="test"} 1e+07
containerd_container_cpu_throttle_periods_total{id="test"} 0
containerd_container_cpu_throttled_periods_total{id="test"} 0
containerd_container_cpu_throttled_time_nanoseconds{id="test"} 0
containerd_container_cpu_total_nanoseconds{id="test"} 2.1428791e+07
containerd_container_cpu_user_nanoseconds{id="test"} 0
containerd_container_hugetlb_failcnt_total{id="test",page="1GB"} 0
containerd_container_hugetlb_failcnt_total{id="test",page="2MB"} 0
containerd_container_hugetlb_max_bytes{id="test",page="1GB"} 0
containerd_container_hugetlb_max_bytes{id="test",page="2MB"} 0
containerd_container_hugetlb_usage_bytes{id="test",page="1GB"} 0
containerd_container_hugetlb_usage_bytes{id="test",page="2MB"} 0
containerd_container_memory_active_anon_bytes{id="test"} 0
containerd_container_memory_active_file_bytes{id="test"} 659456
containerd_container_memory_cache_bytes{id="test"} 925696
containerd_container_memory_dirty_bytes{id="test"} 0
containerd_container_memory_hierarchical_memory_limit_bytes{id="test"} 9.223372036854772e+18
containerd_container_memory_hierarchical_memsw_limit_bytes{id="test"} 9.223372036854772e+18
containerd_container_memory_inactive_anon_bytes{id="test"} 73728
containerd_container_memory_inactive_file_bytes{id="test"} 266240
containerd_container_memory_kernel_failcnt_total{id="test"} 0
containerd_container_memory_kernel_limit_bytes{id="test"} 9.223372036854772e+18
containerd_container_memory_kernel_max_bytes{id="test"} 0
containerd_container_memory_kernel_usage_bytes{id="test"} 0
containerd_container_memory_kerneltcp_failcnt_total{id="test"} 0
containerd_container_memory_kerneltcp_limit_bytes{id="test"} 9.223372036854772e+18
containerd_container_memory_kerneltcp_max_bytes{id="test"} 0
containerd_container_memory_kerneltcp_usage_bytes{id="test"} 0
containerd_container_memory_mapped_file_bytes{id="test"} 577536
containerd_container_memory_oom_total{id="test"} 0I
containerd_container_memory_pgfault_bytes{id="test"} 770
containerd_container_memory_pgmajfault_bytes{id="test"} 6
containerd_container_memory_pgpgin_bytes{id="test"} 651
containerd_container_memory_pgpgout_bytes{id="test"} 407
containerd_container_memory_rss_bytes{id="test"} 73728
containerd_container_memory_rss_huge_bytes{id="test"} 0
containerd_container_memory_swap_failcnt_total{id="test"} 0
containerd_container_memory_swap_limit_bytes{id="test"} 9.223372036854772e+18
containerd_container_memory_swap_max_bytes{id="test"} 1.527808e+06
containerd_container_memory_swap_usage_bytes{id="test"} 999424
containerd_container_memory_total_active_anon_bytes{id="test"} 0
containerd_container_memory_total_active_file_bytes{id="test"} 659456
containerd_container_memory_total_cache_bytes{id="test"} 925696
containerd_container_memory_total_dirty_bytes{id="test"} 0
containerd_container_memory_total_inactive_anon_bytes{id="test"} 73728
containerd_container_memory_total_inactive_file_bytes{id="test"} 266240
containerd_container_memory_total_mapped_file_bytes{id="test"} 577536
containerd_container_memory_total_pgfault_bytes{id="test"} 770
containerd_container_memory_total_pgmajfault_bytes{id="test"} 6
containerd_container_memory_total_pgpgin_bytes{id="test"} 651
containerd_container_memory_total_pgpgout_bytes{id="test"} 407
containerd_container_memory_total_rss_bytes{id="test"} 73728
containerd_container_memory_total_rss_huge_bytes{id="test"} 0
containerd_container_memory_total_unevictable_bytes{id="test"} 0
containerd_container_memory_total_writeback_bytes{id="test"} 0
containerd_container_memory_unevictable_bytes{id="test"} 0
containerd_container_memory_usage_failcnt_total{id="test"} 0
containerd_container_memory_usage_limit_bytes{id="test"} 9.223372036854772e+18
containerd_container_memory_usage_max_bytes{id="test"} 1.527808e+06
containerd_container_memory_usage_usage_bytes{id="test"} 999424
containerd_container_memory_writeback_bytes{id="test"} 0
containerd_container_per_cpu_nanoseconds{cpu="0",id="test"} 7.530139e+06
containerd_container_per_cpu_nanoseconds{cpu="1",id="test"} 4.586408e+06
containerd_container_per_cpu_nanoseconds{cpu="2",id="test"} 5.076059e+06
containerd_container_per_cpu_nanoseconds{cpu="3",id="test"} 4.236185e+06
containerd_container_pids_current{id="test"} 1
containerd_container_pids_limit{id="test"} 0
```

The `id` label will be the id of the container so users can filter on the metrics for only the containers that they care about.

The frequency of metric collection is configurable via the prometheus scrape time.  Every time the `/metrics` API is hit, that is when container metrics are collected.  There is no internal timer in containerd, you only pay the cost of collecting metrics when you are asking for them.  If you never ask for metrics the collection never happens.

There should be a PR up soon so that we can discuss the metrics and label names.

## Image Pull

* https://github.com/containerd/containerd/pull/640

We now have a proof of concept of end to end pull.  Up to this point, the
relationship between subsystems has been somewhat theoretical. We now leverage
fetching, the snapshot drivers, the rootfs service, image metadata and the
execution service, validating the proposed model for containerd.  There are a
few caveats, including the need to move some of the access into GRPC services,
but the basic components are there.

The first command we will cover here is `dist pull`. This is the analog of
`docker pull` and `git pull`. It performs a full resource fetch for an image
and unpacks the root filesystem into the snapshot drivers. An example follows:

``` console
$ sudo ./bin/dist pull docker.io/library/redis:latest
docker.io/library/redis:latest:                                                   resolved       |++++++++++++++++++++++++++++++++++++++|
manifest-sha256:4c8fb09e8d634ab823b1c125e64f0e1ceaf216025aa38283ea1b42997f1e8059: done           |++++++++++++++++++++++++++++++++++++++|
layer-sha256:3b281f2bcae3b25c701d53a219924fffe79bdb74385340b73a539ed4020999c4:    done           |++++++++++++++++++++++++++++++++++++++|
config-sha256:e4a35914679d05d25e2fccfd310fde1aa59ffbbf1b0b9d36f7b03db5ca0311b0:   done           |++++++++++++++++++++++++++++++++++++++|
layer-sha256:4b7726832aec75f0a742266c7190c4d2217492722dfd603406208eaa902648d8:    done           |++++++++++++++++++++++++++++++++++++++|
layer-sha256:338a7133395941c85087522582af182d2f6477dbf54ba769cb24ec4fd91d728f:    done           |++++++++++++++++++++++++++++++++++++++|
layer-sha256:83f12ff60ff1132d1e59845e26c41968406b4176c1a85a50506c954696b21570:    done           |++++++++++++++++++++++++++++++++++++++|
layer-sha256:693502eb7dfbc6b94964ae66ebc72d3e32facd981c72995b09794f1e87bac184:    done           |++++++++++++++++++++++++++++++++++++++|
layer-sha256:622732cddc347afc9360b4b04b46c6f758191a1dc73d007f95548658847ee67e:    done           |++++++++++++++++++++++++++++++++++++++|
layer-sha256:19a7e34366a6f558336c364693df538c38307484b729a36fede76432789f084f:    done           |++++++++++++++++++++++++++++++++++++++|
elapsed: 1.6 s                                                                    total:   0.0 B (0.0 B/s)
INFO[0001] unpacking rootfs
```

Note that we haven't integrated rootfs unpacking into the status output, but we
pretty much have what is in docker today (:P). We can see the result of our
pull with the following:

```console
$ sudo ./bin/dist images
REF                            TYPE                                                 DIGEST                                                                  SIZE
docker.io/library/redis:latest application/vnd.docker.distribution.manifest.v2+json sha256:4c8fb09e8d634ab823b1c125e64f0e1ceaf216025aa38283ea1b42997f1e8059 1.8 kB
```

The above shows that we have an image called "docker.io/library/redis:latest"
mapped to the given digest marked with a specific format. We get the size of
the manifest right now, not the full image, but we can add more as we need it.
For the most part, this is all that is needed, but a few tweaks to the model
for naming may need to be added. Specifically, we may want to index under a few
different names, including those qualified by hash or matched by tag versions.
We can do more work in this area as we develop the metadata store.

The name shown above can then be used to run the actual container image. We can
do this with the following command:

```console
$ sudo ./bin/ctr run --id foo docker.io/library/redis:latest /usr/local/bin/redis-server
1:C 17 Mar 17:20:25.316 # Warning: no config file specified, using the default config. In order to specify a config file use /usr/local/bin/redis-server /path/to/redis.conf
1:M 17 Mar 17:20:25.317 * Increased maximum number of open files to 10032 (it was originally set to 1024).
				_._
		   _.-``__ ''-._
	  _.-``    `.  `_.  ''-._           Redis 3.2.8 (00000000/0) 64 bit
  .-`` .-```.  ```\/    _.,_ ''-._
 (    '      ,       .-`  | `,    )     Running in standalone mode
 |`-._`-...-` __...-.``-._|'` _.-'|     Port: 6379
 |    `-._   `._    /     _.-'    |     PID: 1
  `-._    `-._  `-./  _.-'    _.-'
 |`-._`-._    `-.__.-'    _.-'_.-'|
 |    `-._`-._        _.-'_.-'    |           http://redis.io
  `-._    `-._`-.__.-'_.-'    _.-'
 |`-._`-._    `-.__.-'    _.-'_.-'|
 |    `-._`-._        _.-'_.-'    |
  `-._    `-._`-.__.-'_.-'    _.-'
	  `-._    `-.__.-'    _.-'
		  `-._        _.-'
			  `-.__.-'

1:M 17 Mar 17:20:25.326 # WARNING: The TCP backlog setting of 511 cannot be enforced because /proc/sys/net/core/somaxconn is set to the lower value of 128.
1:M 17 Mar 17:20:25.326 # Server started, Redis version 3.2.8
1:M 17 Mar 17:20:25.326 # WARNING overcommit_memory is set to 0! Background save may fail under low memory condition. To fix this issue add 'vm.overcommit_memory = 1' to /etc/sysctl.conf and then reboot or run the command 'sysctl vm.overcommit_memory=1' for this to take effect.
1:M 17 Mar 17:20:25.326 # WARNING you have Transparent Huge Pages (THP) support enabled in your kernel. This will create latency and memory usage issues with Redis. To fix this issue run the command 'echo never > /sys/kernel/mm/transparent_hugepage/enabled' as root, and add it to your /etc/rc.local in order to retain the setting after a reboot. Redis must be restarted after THP is disabled.
1:M 17 Mar 17:20:25.326 * The server is now ready to accept connections on port 6379
```

Wow! So, now we are running `redis`!

There are still a few things to work out. Notice that we have to specify the
command as part of the arguments to `ctr run`. This is because are not yet
reading the image config and converting it to an OCI runtime config. With the
base laid in this PR, adding such functionality should be straightforward.

While this is a _little_ messy, this is great progress. It should be easy
sailing from here.



