<WEBPAGE chapter="hsc - Features - Macros - "
         PREV="macros.html"
         NEXT="attrib.html"
         title="Modifiers For Tag- And Macro Declarations">

<$macro LIFLAG SHORT:string/r LONG:string/r ONLYDEFTAG:bool>
<DT><CODE>/<(long)></CODE>
    (short: <CODE>/<(short)></CODE>)
<DD>
</$macro>

<P>Within  <ln-macro> and <ln-deftag>,
you can use several modifiers to tell <hsc> how to handle this macro/tag.</P>


Allowed modifiers for both <ln-macro> and <ln-deftag> are:
<DL>
<LIFLAG long="CLOSE" short="C">
    macro/tag is a container and requires a corresponding end tag.

<LIFLAG long="ONLYONCE" short="1">
    macro/tag is required at the most once within a document

<LIFLAG long="REQUIRED" short="R">
    macro/tag is required to appear at least once within a document

<LIFLAG long="RECOMMENDED" short="RCMD">
    macro/tag ought to appear at least once within a document

<LIFLAG long="MUST_BE_INSIDE" short="MBI">
    Needs a string as argument, that contains a list of container tags,
    that must be started before tag is allowed to be used.<BR>
    Example:<BR>
    The tag <TG>LI</TG> must be used inside some sort of lists only,
    therefore <CODE>/MBI="ul|ol|dir|menu"</CODE> is used.
    The <vbar> is used as a separator for multiple tags.<BR>
    In XHTML mode, this modifier is stricter than for traditional HTML: it
    means ``directly inside'' instead of ``somewhere inside''. I.e. the
    following would be legal in HTML, but not in XHTML
    (the actual definition is different, this is just an example!):
<$source PRE>
<$deftag P /MBI="BODY">
<BODY>
  <DIV>
    <P>Blah</P>
  </DIV>
</BODY>
</$source>

<LIFLAG long="NOT_ALLOWED_WITHIN" short="NAW">
    Like <CODE>/MBI</CODE>, but this time tags that must not be
    used before. For example, a nested usage of <TG>A</TG>
    is not allowed, therefore <CODE>/NAW="a"</CODE> is used.
</DL>

Additionally, the following modifiers can be used with <ln-deftag>
<DL>
<LIFLAG long="AUTOCLOSE" short="AC">
    Used for <TG>P</TG> and <TG>LI</TG>, which can be used as container
    or single tag depending on the HTML version. Tags marked with this
    modifier can not be nested.
<LIFLAG long="EMPTY" short="E">
    Marks tags with the SGML content model EMPTY, like <TG>BR</TG>, <TG>IMG</TG>,
    <TG>HR</TG> etc. In HTML mode, they simply must not have a closing tag. In
    XHTML mode, they should have a trailing slash or a closing tag
    immediately following. The latter is not supported yet, but HSC can
    complete these tags with a slash if you forget it (or want to produce
    HTML4 and XHTML documents from one source - not that I understood what
    for...). Warning 88 will be issued when this happens. 
<LIFLAG long="JERK" short="J" ONLYDEFTAG>
    tag is only used by jerks
<LIFLAG long="LAZY" short="L" ONLYDEFTAG>
    This modifier is just there for our laziness and defines some
    often needed attributes with a single letter;
    <qq><CODE>c</CODE></qq> for <qq><CODE>CLASS:string</CODE></qq>,
    <qq><CODE>d</CODE></qq> for <qq><CODE>DIR:enum("ltr|rtl")</CODE></qq>,
    <qq><CODE>h</CODE></qq> for <qq><CODE>HREF:uri</CODE></qq>,
    <qq><CODE>i</CODE></qq> for <qq><CODE>ID:id</CODE></qq>,
    <qq><CODE>k</CODE></qq> for <qq><CODE>CLEAR:bool</CODE></qq>,
    <qq><CODE>l</CODE></qq> for <qq><CODE>LANG:string</CODE></qq>,
    <qq><CODE>m</CODE></qq> for <qq><CODE>MD:string</CODE></qq>,
    <qq><CODE>s</CODE></qq> for <qq><CODE>SRC:uri</CODE></qq>,
    <qq><CODE>t</CODE></qq> for <qq><CODE>TITLE:string</CODE></qq>.
    <qq><CODE>y</CODE></qq> for <qq><CODE>STYLE:string</CODE></qq>.
    <qq><CODE>v</CODE></qq> for <qq><CODE>events</CODE></qq>.<BR>
    For example, use <CODE>/LAZY="cil"</CODE>.<BR>
    "Events" is special in that it declares several scripting-related
    attributes at once: <CODE>onclick, ondblclick, onmousedown, onmouseup,
    onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup</CODE>.
    These are the most frequent attributes, collected under an entity in HTML
    4.01.
<LIFLAG long="OBSOLETE" short="O">
    tag is obsolete and should not be used any more. This e.g.
    concerns <TG>LISTING</TG>.
<LIFLAG long="SKIPLF" short="S">
    skip a linefeed ("\n") that comes immediately after the tag. This
    is only useful for some of <hsc>'s special tags and only avoids
    some unnecessary empty lines.
<LIFLAG long="SPECIAL" short="SPC">
    This one marks tags which are no normal tags with some attributes,
    but have their own syntax. The only HTML tag which has this modifier
    set is <TG>!</TG> (for SGML comments).
<LIFLAG long="WHTSPC" short="W">
    If this modifier is set, any occurrence of the container is checked
    for succeeding/preceding white spaces. By default, this concerns
    the tags <TG>A</TG>, <TG>TITLE</TG>, headings and physical/logical
    styles like <TG>B</TG> or <TG>strong</TG>.
</DL>

</WEBPAGE>

<* vi: set ts=4 et: *>

