/*
 * $Id: AbstractNotificationLogger.java 10803 2008-02-14 13:31:25Z holger $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.context.notification;

import org.mule.api.context.notification.ServerNotification;

import java.util.LinkedList;
import java.util.List;

public abstract class AbstractNotificationLogger
{

    private LinkedList notifications = new LinkedList();

    public synchronized void onNotification(ServerNotification notification)
    {
        notifications.addLast(notification);
    }

    public List getNotifications()
    {
        return notifications;
    }

}
