
      PROGRAM NNEX09
C
C  Code to illustrate plotting neighbors with the display tool.
C
      PARAMETER(ISLIM = 131, NUMXOUT = 21, NUMYOUT = 21, 
     +          IDIM=2*NUMXOUT*NUMYOUT)
C
      REAL X(ISLIM), Y(ISLIM), Z(ISLIM)
      REAL XI(NUMXOUT),YI(NUMYOUT),ZI(NUMXOUT,NUMYOUT)
C
      INTEGER I,J
C
C  The data values for Z (defined in BLOCKDATA) are pressure fields.
C
      COMMON /DVALUE/X,Y,Z
C
C  Normalize Z to be between 0. and 1.
C
      ZMAX = Z(1)
      ZMIN = Z(1)
      DO 4 I=2,ISLIM
        ZMAX = MAX(ZMAX,Z(I))
        ZMIN = MIN(ZMIN,Z(I))
    4 CONTINUE
C
      RC = 1./(ZMAX-ZMIN)
      DO 5 I=1,ISLIM
        Z(I) = RC*(Z(I)-ZMIN)
    5 CONTINUE
C
C  Define the output grid.
C
      XMIN =  0.1
      XMAX =  0.9
      XINC = (XMAX-XMIN)/(NUMXOUT-1.) 
      DO 20 I=1,NUMXOUT
        XI(I) = XMIN+REAL(I-1) * XINC
   20 CONTINUE
C
      YMIN =  0.1
      YMAX =  0.5
      YINC = (YMAX-YMIN)/(NUMYOUT-1.)
      DO 30 J=1,NUMYOUT
        YI(J) = YMIN+REAL(J-1) * YINC
   30 CONTINUE 
C
      CALL NNSETI('ADF',1)
      CALL NNSETC('ALG','example9.dat')
      CALL NATGRIDS(ISLIM,X,Y,Z,NUMXOUT,NUMYOUT,XI,YI,ZI,IER)
C
      STOP
      END
      BLOCKDATA DATAV
      COMMON /DVALUE/X,Y,Z
      DIMENSION X(131),Y(131),Z(131)
C
      DATA X/
     +   0.120, 0.127, 0.135, 0.140, 0.140, 0.142, 0.146, 0.153, 0.153, 
     +   0.156, 0.169, 0.191, 0.200, 0.202, 0.208, 0.228, 0.228, 0.230,
     +   0.247, 0.251, 0.266, 0.277, 0.279, 0.279, 0.300, 0.326, 0.327,
     +   0.333, 0.342, 0.349, 0.350, 0.366, 0.379, 0.385, 0.386, 0.387,
     +   0.389, 0.393, 0.416, 0.431, 0.436, 0.440, 0.441, 0.449, 0.453,
     +   0.453, 0.458, 0.467, 0.476, 0.477, 0.486, 0.502, 0.503, 0.505,
     +   0.511, 0.511, 0.517, 0.524, 0.526, 0.527, 0.531, 0.550, 0.555,
     +   0.559, 0.563, 0.563, 0.567, 0.577, 0.585, 0.587, 0.602, 0.605,
     +   0.606, 0.607, 0.619, 0.626, 0.637, 0.638, 0.642, 0.642, 0.653,
     +   0.658, 0.660, 0.667, 0.670, 0.677, 0.686, 0.690, 0.694, 0.695,
     +   0.704, 0.705, 0.706, 0.718, 0.724, 0.727, 0.730, 0.738, 0.744,
     +   0.746, 0.763, 0.766, 0.770, 0.790, 0.790, 0.792, 0.793, 0.800,
     +   0.815, 0.817, 0.821, 0.822, 0.823, 0.823, 0.830, 0.833, 0.840,
     +   0.841, 0.846, 0.849, 0.849, 0.850, 0.853, 0.856, 0.865, 0.871,
     +   0.871, 0.878, 0.884, 0.097, 0.100
     +  /
      DATA Y/    
     +   0.398, 0.445, 0.317, 0.288, 0.522, 0.254, 0.557, 0.505, 0.374,
     +   0.222, 0.538, 0.394, 0.209, 0.490, 0.285, 0.349, 0.440, 0.523,
     +   0.310, 0.216, 0.185, 0.416, 0.371, 0.249, 0.488, 0.382, 0.329,
     +   0.491, 0.465, 0.238, 0.168, 0.404, 0.475, 0.338, 0.199, 0.366,
     +   0.307, 0.285, 0.426, 0.168, 0.329, 0.242, 0.510, 0.481, 0.367,
     +   0.403, 0.433, 0.297, 0.137, 0.181, 0.435, 0.486, 0.337, 0.118,
     +   0.297, 0.248, 0.397, 0.165, 0.195, 0.078, 0.033, 0.336, 0.453,
     +   0.384, 0.494, 0.132, 0.253, 0.297, 0.192, 0.438, 0.143, 0.248,
     +   0.464, 0.393, 0.338, 0.362, 0.431, 0.308, 0.262, 0.412, 0.201,
     +   0.476, 0.151, 0.334, 0.441, 0.375, 0.405, 0.298, 0.177, 0.347,
     +   0.437, 0.243, 0.370, 0.219, 0.282, 0.396, 0.430, 0.306, 0.366,
     +   0.259, 0.420, 0.478, 0.189, 0.268, 0.442, 0.360, 0.314, 0.495,
     +   0.246, 0.209, 0.467, 0.339, 0.148, 0.410, 0.381, 0.505, 0.443,
     +   0.167, 0.123, 0.469, 0.413, 0.316, 0.379, 0.499, 0.546, 0.519,
     +   0.608, 0.353, 0.118, 0.423, 0.349
     +  /
      DATA Z/
     +   137.0, 161.0, 161.0, 157.0, 161.0, 174.0, 173.0, 166.0, 124.0,
     +   179.0, 166.0, 133.0, 130.0, 150.0, 139.0, 134.0, 127.0, 155.0,
     +   175.0, 143.0, 155.0, 160.0, 150.0, 185.0, 240.0, 200.0, 218.0,
     +   245.0, 242.0, 169.0, 151.0, 197.0, 253.0, 189.0, 150.0, 194.0,
     +   188.0, 184.0, 205.0, 152.0, 168.0, 137.0, 291.0, 256.0, 150.0,
     +   160.0, 174.0, 143.0, 200.0, 165.0, 173.0, 212.0, 109.0, 181.1,
     +   143.0, 160.0, 113.0, 181.0, 173.0, 179.0, 173.0, 145.0, 169.0,
     +   143.0, 197.0, 188.0, 189.0, 181.0, 193.0, 166.0, 196.0, 192.0,
     +   189.0, 168.0, 184.0, 179.0, 178.0, 197.0, 199.0, 181.0, 198.0,
     +   174.0, 193.0, 200.0, 178.0, 200.0, 197.0, 214.0, 197.0, 202.0,
     +   192.0, 209.0, 210.0, 197.0, 205.0, 210.0, 200.0, 205.0, 208.0,
     +   200.0, 206.0, 183.0, 191.0, 195.0, 212.0, 207.0, 205.0, 174.0,
     +   204.0, 203.0, 184.0, 197.0, 195.0, 186.0, 189.0, 178.0, 180.1,
     +   200.0, 183.0, 179.9, 184.0, 193.0, 193.0, 176.0, 156.0, 163.0,
     +   139.0, 191.0, 179.0, 157.0, 159.0
     +  /
C
      END
