/*
 * Copyright (c) 2013 ARM Ltd
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the company may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ARM LTD ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ARM LTD BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#if defined (__OPTIMIZE_SIZE__) || defined (PREFER_SIZE_OVER_SPEED)
  /* Leave this field blank.  So the memcpy() is not defined, and this will
     automatically pull in the default C definition of memcpy() from
     ../../string/memcpy.c.  No need to include this file explicitely.
     The lib_a-memcpy.o will not be generated, so it won't replace the default
     lib_a-memcpy.o which is generated by ../../string/memcpy.c.
     See the commands in configure.in and Makefile.am for more details.

     However, if we need to rewrite this function to be more efficient, we
     can add the corresponding assembly code into this field and change the
     commands in configure.in and Makefile.am to allow the corresponding
     lib_a-memcpy.o to be generated.
  */

#elif defined (__ARM_ARCH_7A__) && defined (__ARM_FEATURE_UNALIGNED)
#include "memcpy-armv7a.S"

#elif defined (__ARM_ARCH_7M__) || defined (__ARM_ARCH_7EM__)
#include "memcpy-armv7m.S"

#else
  /* Leave this filed blank.  See the commands above.  */
#endif
