/* NVTV unix direct backend -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: back_unix.c,v 1.2 2003/05/02 16:28:25 dthierbach Exp $
 *
 * Contents:
 *
 * Backend for direct access of the card unter Unix
 *
 */

#include "local.h" /* before everything else */

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#include <fcntl.h>


#include "backend.h"
#include "back_direct.h"
#include "card_direct.h"

/* -------- Root backend -------- */

static CardPtr card_root_list = NULL;

/* 
 *  Check if root access is possible.
 */

Bool back_root_avail (void)
{
  if (getuid() != 0 || geteuid() != 0 ) return FALSE;
  return TRUE;
}

/*
 *  Find all cards in system, and return list.
 */

CardPtr back_root_init (void)
{
  back_access = &bdir_func;
  if (card_root_list) return card_root_list; 
    /* only probe once, and never free card_root_list once allocated. */

  scan_cards_pci (&card_root_list, DEV_MEM);
  return card_root_list;
}

/* -------- nvdev backend -------- */

static CardPtr card_nvdev_list = NULL;

/* Check if /dev/nvidiactl is accessible, and if the kernel module
 * is already in use (hopefully by the XFree 'nvdriver' module).
 */

Bool back_nvdev_avail (Bool force)
{
  FILE *f;
  int fd;
  char mod[80];
  int size, count;
  Bool ok;

  /* Better check /proc/modules first, because access /dev/nvidiactrl may
     autoload kernel module */
  if ((f = fopen ("/proc/modules", "r"))) {
    ok = FALSE;
    while (! feof(f)) {
      fscanf (f, "%80s %i %i", mod, &size, &count);
      while (! feof(f) && fgetc(f) != '\n');
      if ((strcmp ("NVdriver", mod) == 0 || strcmp ("nvidia", mod) == 0) && 
	   count > 0) 
      { 
	ok = TRUE;
	break;
      }
    }
    fclose (f);
    if (!ok) return FALSE;
  } else {
    if (!force) {
      fprintf (stderr, "Cannot open /proc/modules, won't allow nvdev access.\n");
      return FALSE;
    }
  }
  if ((fd = open (DEV_NVCTL, O_RDWR, 0)) < 0) return FALSE;
  close (fd);
  return TRUE;
}

CardPtr back_nvdev_init (void)
{
  back_access = &bdir_func;
  if (card_nvdev_list) return card_nvdev_list; 
    /* only probe once, and never free card_nvdev_list once allocated. */

  scan_cards_nvdev (&card_nvdev_list);
  return card_nvdev_list;
}

