/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.authorization.test;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.security.auth.DialogAuthListener;
import com.sourceforge.knecs.util.CMCSProperties;
import java.util.Enumeration;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.Privilege;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.properties.AclProperty;

public class TestShowAces {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: TestShowAces <url>");
            System.exit(-1);
        }
        String url = args[0];
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String serverURL = (String)props.get("samserver");
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = serverURL + url;
        }
        DialogAuthListener dal = new DialogAuthListener();
        DSI dsi = new DSI(url, dal);
        try {
            AclProperty aclProp = dsi.getACL();
            Ace[] aces = aclProp.getAces();
            System.out.println("-----------------");
            System.out.println("listing ACEs ");
            System.out.println("-----------------");
            int len = aces.length;
            int i = 0;
            for (i = 0; i < len; ++i) {
                Ace ace = aces[i];
                String principal = ace.getPrincipal();
                if (principal.equals("property")) {
                    PropertyName propName = ace.getProperty();
                    principal = "Property <" + propName.getNamespaceURI() + " : " + propName.getLocalName() + ">";
                }
                System.out.println((!ace.isNegative() ? "granted" : "denied") + " to " + principal + " " + "   (" + (ace.isProtected() ? "protected" : "not protected") + ")" + "   (" + (ace.isInherited() ? "inherited from '" + ace.getInheritedFrom() + "'" : "not inherited") + ")");
                Enumeration privileges = ace.enumeratePrivileges();
                while (privileges.hasMoreElements()) {
                    Privilege priv = (Privilege)privileges.nextElement();
                    System.out.println("   " + priv.getNamespace() + priv.getName() + "   " + (priv.getParameter() == null ? "" : "(" + priv.getParameter() + ")"));
                }
            }
            System.out.println("------------------------------------------------------------");
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        System.out.println("-----------------");
        System.out.println("Finished");
        System.out.println("-----------------");
        System.exit(0);
    }
}

