/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse;

import com.sourceforge.knecs.dsm.dsi.DSIProperty;
import com.sourceforge.knecs.dsm.util.PedigreeUtils;
import com.sourceforge.knecs.dsm.util.Xlink;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.NSProperty;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.chefproject.core.User;
import org.chefproject.service.UserDirectoryService;
import org.scidac.cmcs.tools.bse.BasisSetDescriptor;

public class BasisSetBrowse {
    public static final int GAUSSIAN = 0;
    public static final int PLANEWAVE = 1;
    public static final int SLATER = 2;
    protected long mLastUpdated = -1L;
    protected int mCategory;
    protected Vector[] mBasisSets;
    protected final String[] mCategoryName = new String[]{"Gaussian", "Plane-Wave", "Slater"};
    protected final String[][][] mTypeFilters = new String[][][]{{{"All", "All Electron", "Orbitals with Effective Core Potential"}, {"All", "All Electron", "Orbitals with Effective Core Potential", "Effective Core Potential", "Polarization", "Diffuse", "Tight", "Rydberg"}, {"Without spin-orbit", "With spin-obit"}}, {{"All", "AE (All Electron)", "PP (Pseudo Potential)"}}, {{"All", "RAE (Relativistic All Electron)", "RFC (Relativistic Frozen Core)", "NRAE (Non-Relativistic All Electron)", "NRFC (Non-Relativistic Frozen Core)"}}};
    protected BasisSetDescriptor mCurrentSet;

    public BasisSetBrowse(int category, Hashtable bsList) {
        this.mBasisSets = new Vector[3];
        this.mBasisSets[0] = null;
        this.mBasisSets[1] = null;
        this.mBasisSets[2] = null;
        this.setCategory(category, bsList);
        this.setCurrentSet(0);
    }

    public boolean setCategory(String categoryName, Hashtable bsList) {
        for (int i = 0; i < 3; ++i) {
            if (!this.mCategoryName[i].equals(categoryName)) continue;
            this.setCategory(i, bsList);
            return true;
        }
        return false;
    }

    public boolean setCategory(int category, Hashtable bsList) {
        if (category > -1 && category < 3) {
            this.mCategory = category;
            this.prepareSets(bsList);
            return true;
        }
        return false;
    }

    public boolean setCurrentSet(int index) {
        if (index > -1 && index < this.mBasisSets[this.mCategory].size()) {
            this.mCurrentSet = (BasisSetDescriptor)this.mBasisSets[this.mCategory].get(index);
            return true;
        }
        return false;
    }

    public boolean setCurrentSet(String url) {
        for (int i = 0; i < this.mBasisSets[this.mCategory].size(); ++i) {
            if (!((BasisSetDescriptor)this.mBasisSets[this.mCategory].get(i)).getUrl().equals(url)) continue;
            this.setCurrentSet(i);
            return true;
        }
        return false;
    }

    public BasisSetDescriptor getCurrentSet() {
        return this.mCurrentSet;
    }

    public int getCategory() {
        return this.mCategory;
    }

    public String getCategoryName() {
        return this.mCategoryName[this.mCategory];
    }

    public Vector getBasisSets() {
        return this.mBasisSets[this.mCategory];
    }

    public String[] getEcpFilters() {
        return this.mTypeFilters[this.mCategory][0];
    }

    public String[] getAllTypesFilters() {
        return this.mTypeFilters[this.mCategory][1];
    }

    public String[] getSoFilters() {
        return this.mTypeFilters[this.mCategory][2];
    }

    protected String getPropertyAsString(Hashtable propList, NSProperty prop) {
        String ret = "";
        if (propList.containsKey(prop)) {
            ret = ((DSIProperty)propList.get(prop)).getPropertyAsString().trim();
        }
        return ret;
    }

    protected String getPropertyAsXMLString(Hashtable propList, NSProperty prop) {
        String ret = "";
        if (propList.containsKey(prop)) {
            ret = ((DSIProperty)propList.get(prop)).getPropertyAsXMLString(true).trim();
        }
        return ret;
    }

    public void prepareSets(Hashtable bsList) {
        String cmcsns = CMCSProperties.getCMCSProperties().getProperty("cmcsns");
        String bsens = "http://purl.oclc.org/NET/EMSL/BSE";
        this.mBasisSets[this.mCategory] = new Vector();
        for (String url : bsList.keySet()) {
            Hashtable propList = (Hashtable)bsList.get(url);
            String title = this.getPropertyAsString(propList, new NSProperty("http://purl.org/dc/elements/1.1/:title"));
            String date = this.getPropertyAsString(propList, new NSProperty("DAV::getlastmodified"));
            String ecpLink = this.getPropertyAsXMLString(propList, new NSProperty(cmcsns, "effectivePotentialsLink"));
            String eltStr = this.getPropertyAsXMLString(propList, new NSProperty(bsens, "hasElements"));
            String curationStatus = this.getPropertyAsString(propList, new NSProperty(bsens, "curationStatus"));
            String isBseHidden = this.getPropertyAsString(propList, new NSProperty(bsens, "isBseHidden"));
            String contributionPI = this.getPropertyAsString(propList, new NSProperty(bsens, "contributionPI"));
            String contributorName = this.getPropertyAsString(propList, new NSProperty(bsens, "contributorName"));
            String contributorId = this.getPropertyAsString(propList, new NSProperty(bsens, "contributorId"));
            String bsAbstract = this.getPropertyAsString(propList, new NSProperty("http://purl.org/dc/terms/:abstract"));
            String bsType = this.getPropertyAsString(propList, new NSProperty(bsens, "basisSetType"));
            String primaryLinkXml = this.getPropertyAsXMLString(propList, new NSProperty(cmcsns, "primaryBasisSetLink"));
            String auxLinkXml = this.getPropertyAsXMLString(propList, new NSProperty(cmcsns, "basisSetLink"));
            Vector eltVec = new Vector();
            if (eltStr.equals("")) {
                Vector primaryLinks = new Vector();
                Vector auxLinks = new Vector();
                try {
                    PedigreeUtils.parseBag(primaryLinkXml, primaryLinks);
                    PedigreeUtils.parseBag(auxLinkXml, auxLinks);
                    auxLinks.add(primaryLinks.elementAt(0));
                    for (int i = 0; i < auxLinks.size(); ++i) {
                        Xlink link = new Xlink();
                        PedigreeUtils.parseXlink((String)auxLinks.elementAt(i), link);
                        String auxLinkUrl = url.substring(0, url.lastIndexOf(47) + 1) + link.getHref();
                        Hashtable auxPropList = (Hashtable)bsList.get(auxLinkUrl);
                        String tmpStr = ((DSIProperty)auxPropList.get(new NSProperty(bsens, "hasElements"))).getPropertyAsXMLString(true).trim();
                        Vector tmpVec = new Vector();
                        PedigreeUtils.parseBag(tmpStr, tmpVec);
                        if (i == 0) {
                            eltVec = tmpVec;
                            continue;
                        }
                        Iterator eltItor = eltVec.iterator();
                        while (eltItor.hasNext()) {
                            if (tmpVec.contains(eltItor.next())) continue;
                            eltItor.remove();
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception on parseXlink: " + e.getMessage());
                }
            } else {
                try {
                    PedigreeUtils.parseBag(eltStr, eltVec);
                }
                catch (Exception e) {
                    System.out.println("Exception on parse element list: " + e.getMessage());
                }
            }
            if (url.endsWith("-ECP.xml")) {
                bsType = "effective core potential";
            }
            if (contributorId != null && contributorId.length() > 0) {
                try {
                    User user = UserDirectoryService.getUser(contributorId);
                    contributorName = user.getFirstName() + " " + user.getLastName();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            BasisSetDescriptor bsd = new BasisSetDescriptor(url, title, bsType, curationStatus, !ecpLink.equals(""), false, eltVec, date, contributionPI, contributorName, bsAbstract);
            if (!isBseHidden.equals("false") || curationStatus.equals("Denied")) continue;
            this.mBasisSets[this.mCategory].add(bsd);
        }
    }

    public void setLastUpdated() {
        this.mLastUpdated = new Date().getTime();
    }

    public long getLastUpdated() {
        return this.mLastUpdated;
    }
}

