// TODO: consider using typescript?
console.log('ohai!');

// TODO: load list for all packages

var parts = document.location.pathname.split(/\//);
// TODO: error checking
var srcpackage = parts[2];
var srcversion = parts[3];
var path = parts.slice(4).join("/");

// TODO: error handling
fetch('/ls-R/' + srcpackage + '/' + srcversion).then(function(response) {
    return response.json();
}).then(function(list) {
    // TODO: expandable file tree browser widget. does codemirror have/recommend sth?
    var navigationList = document.createElement('ul');
    for (let fn of list) {
	var li = document.createElement('li');
	// TODO: click handler to load file in place without triggering a whole app reload
	var a = document.createElement('a');
	a.setAttribute('href', '/edit/' + srcpackage + '/' + srcversion + '/' + fn);
	a.appendChild(document.createTextNode(fn));
	li.appendChild(a);
	navigationList.appendChild(li);
    }
    document.getElementById('navigation').appendChild(navigationList);
});

var ta = document.getElementById('editor-ta');

function loadPending(srcpackage, srcversion) {
    var pendingKey = JSON.stringify({
	type: 'pending',
	srcpackage: srcpackage,
	srcversion: srcversion,
    });
    var pending = window.localStorage.getItem(pendingKey);
    if (pending === null) {
	return {};
    }
    return JSON.parse(pending);
}

var pending = loadPending(srcpackage, srcversion);

var pendingList = document.createElement('ul');
for (fn in pending) {
    var li = document.createElement('li');
    var a = document.createElement('a');
    a.setAttribute('href', '/edit/' + srcpackage + '/' + srcversion + '/' + fn);
    a.appendChild(document.createTextNode(fn));
    li.appendChild(a);
    pendingList.appendChild(li);
}
document.getElementById('pending').appendChild(pendingList);

var myCodeMirror;
function load(srcpackage, srcversion, path, pending) {
    if (pending[path] === undefined) {
	// TODO: error handling
	fetch('/orig/' + srcpackage + '/' + srcversion + '/' + path).then(function(response) {
	    return response.text();
	}).then(function(text) {
	    ta.value = text;
	    myCodeMirror = CodeMirror.fromTextArea(
		ta,
		{
		    lineNumbers: true,
		});
	});
	return;
    }
    var valueKey = JSON.stringify({
	type: 'file',
	srcpackage: srcpackage,
	srcversion: srcversion,
	path: path,
    });
    var value = window.localStorage.getItem(valueKey);
    if (!value) {
	// TODO: error message: corrupt localStorage
	return "corrupt localStorage";
    }
    ta.value = value;
    myCodeMirror = CodeMirror.fromTextArea(
	ta,
	{
	    lineNumbers: true,
	});
}

load(srcpackage, srcversion, path, pending);

var saveBtn = document.getElementById('savebtn');
saveBtn.addEventListener('click', function(ev) {
    console.log('save!');
    // TODO: is JSON.stringify guaranteed to be deterministic, or should we use a different key format?
    var valueKey = JSON.stringify({
	type: 'file',
	srcpackage: srcpackage,
	srcversion: srcversion,
	path: path,
    });
    window.localStorage.setItem(valueKey, myCodeMirror.getValue());
    var pendingKey = JSON.stringify({
	type: 'pending',
	srcpackage: srcpackage,
	srcversion: srcversion,
    });
    var pending = window.localStorage.getItem(pendingKey);
    if (pending !== null) {
	pending[path] = true
    } else {
	pending = {path: true};
    }
    window.localStorage.setItem(pendingKey, JSON.stringify(pending));
    ev.preventDefault();
});
