/*
 *   Copyright 2009 - 2010 by Giulio Camuffo <giuliocamuffo@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "scrollanimation.h"

#include <KDebug>
#include <Plasma/Label>

ScrollAnimation::ScrollAnimation(QObject *parent)
               : QPropertyAnimation(parent),
                 m_newStartValue(0),
                 m_newEndValue(0)
{
    setEasingCurve(QEasingCurve::InOutSine);
    connect(this, SIGNAL(finished()), this, SLOT(animationFinished()));
}

ScrollAnimation::~ScrollAnimation()
{

}

void ScrollAnimation::setNewStartValue(qreal value)
{
    if (state() != QAbstractAnimation::Running) {
        setStartValue(value);
        return;
    }

    m_newStartValue = value;
}

void ScrollAnimation::setNewEndValue(qreal value)
{
    if (state() != QAbstractAnimation::Running) {
        setEndValue(value);
        return;
    }

    m_newEndValue = value;
}

void ScrollAnimation::animationFinished()
{
    if (m_newEndValue != 0) {
        setEndValue(m_newEndValue);
        m_newEndValue = 0;
    }
    if (m_newStartValue != 0) {
        setStartValue(m_newStartValue);
        m_newStartValue = 0;
    }
    if (direction() == QAbstractAnimation::Backward) {
        setDirection(QAbstractAnimation::Forward);
        start();
    } else {
        setDirection(QAbstractAnimation::Backward);
        start();
    }
}

#include "scrollanimation.moc"
