/*
  pmap: simple mapping utilities
  Copyright (C) 2004 Andrew Howard  ahoward@usc.edu

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/** @file slap.h 
    @brief Small Linear Algrebra Package (SLAP); this code is auto-generated. */
/* Desc: Small Linear Algrebra Package (SLAP) */
/* Author: Andrew Howard */
/* Date: Sun Dec 12 15:22:13 2004 */
/* Code generated by slap.py */
#ifndef SLAP_H
#define SLAP_H

#if defined __cplusplus
extern "C" {
#endif


/** @brief 2 vector structure. */
typedef struct
{
  double x;
  double y;
} vector2_t;

#define VECTOR2



/** @brief 3 vector structure. */
typedef struct
{
  double x;
  double y;
  double z;
} vector3_t;

#define VECTOR3



/** @brief 4 vector structure. */
typedef struct
{
  double x;
  double y;
  double z;
  double w;
} vector4_t;

#define VECTOR4



/** @brief 3 by 3 matrix structure. */
typedef struct
{
  double m[3][3];
} matrix33_t;

#define MATRIX33



/** @brief 4 by 4 matrix structure. */
typedef struct
{
  double m[4][4];
} matrix44_t;

#define MATRIX44



/** @brief Basic 2D pose structure. */
typedef struct
{
  vector2_t pos;
  double rot;
} pose2_t;



/** @brief Set vector elements. */
vector2_t vector2_set(double v0, double v1);

/** @brief Add two vectors. */
vector2_t vector2_add(vector2_t a, vector2_t b);

/** @brief Subtract vectors: c = a - b. */
vector2_t vector2_sub(vector2_t a, vector2_t b);

/** @brief Return unit vector. */
vector2_t vector2_unit(vector2_t a);

/** @brief Scale vector: c = ab. */
vector2_t vector2_scale(double a, vector2_t b);

/** @brief Dot product: c = a.b. */
double vector2_dot(vector2_t a, vector2_t b);


/** @brief Vector magnitude: b = |a|. */
double vector2_mag(vector2_t a);

/** @brief Euclidian distance between points a and b. */
double vector2_dist(vector2_t a, vector2_t b);



/** @brief Set vector elements. */
vector3_t vector3_set(double v0, double v1, double v2);

/** @brief Add two vectors. */
vector3_t vector3_add(vector3_t a, vector3_t b);

/** @brief Subtract vectors: c = a - b. */
vector3_t vector3_sub(vector3_t a, vector3_t b);

/** @brief Return unit vector. */
vector3_t vector3_unit(vector3_t a);

/** @brief Scale vector: c = ab. */
vector3_t vector3_scale(double a, vector3_t b);

/** @brief Dot product: c = a.b. */
double vector3_dot(vector3_t a, vector3_t b);

/** @brief Cross product: c = a x b. */
vector3_t vector3_cross(vector3_t a, vector3_t b);

/** @brief Vector magnitude: b = |a|. */
double vector3_mag(vector3_t a);

/** @brief Euclidian distance between points a and b. */
double vector3_dist(vector3_t a, vector3_t b);



/** @brief Set vector elements. */
vector4_t vector4_set(double v0, double v1, double v2, double v3);

/** @brief Add two vectors. */
vector4_t vector4_add(vector4_t a, vector4_t b);

/** @brief Subtract vectors: c = a - b. */
vector4_t vector4_sub(vector4_t a, vector4_t b);

/** @brief Return unit vector. */
vector4_t vector4_unit(vector4_t a);

/** @brief Scale vector: c = ab. */
vector4_t vector4_scale(double a, vector4_t b);

/** @brief Dot product: c = a.b. */
double vector4_dot(vector4_t a, vector4_t b);


/** @brief Vector magnitude: b = |a|. */
double vector4_mag(vector4_t a);

/** @brief Euclidian distance between points a and b. */
double vector4_dist(vector4_t a, vector4_t b);



/** @brief Set matrix elements. */
matrix33_t matrix33_set(double v00, double v01, double v02, double v10, double v11, double v12, double v20, double v21, double v22);

/** @brief Set matrix elements. */
matrix33_t matrix33_setv(double v[16]);

/** @brief Construct identity matrix. */
matrix33_t matrix33_ident();

/** @brief Add two matrixs. */
matrix33_t matrix33_add(matrix33_t a, matrix33_t b);

/** @brief Subtract matrixs: c = a - b. */
matrix33_t matrix33_sub(matrix33_t a, matrix33_t b);

/** @brief Matrix multiplication c = ab. */
matrix33_t matrix33_mul(matrix33_t a, matrix33_t b);

#if defined VECTOR3
/** @brief Matrix/vector multiplication c = ab. */
vector3_t matrix33_mul_3(matrix33_t a, vector3_t b);
#endif

#if defined MATRIX33
/** @brief Transpose matrix. */
matrix33_t matrix33_trans(matrix33_t a);
#endif

/** @brief Inv matrix. */
matrix33_t matrix33_inv(matrix33_t a);

/** @brief Check for nan elements. */
int matrix33_isnan(matrix33_t a);

#if defined MATRIX31 && defined MATRIX31
/** @brief Matrix multiplication c = ab. */
matrix31_t matrix33_mul_31(matrix33_t a, matrix31_t b);
#endif

#if defined MATRIX32 && defined MATRIX32
/** @brief Matrix multiplication c = ab. */
matrix32_t matrix33_mul_32(matrix33_t a, matrix32_t b);
#endif

#if defined MATRIX33 && defined MATRIX33
/** @brief Matrix multiplication c = ab. */
matrix33_t matrix33_mul_33(matrix33_t a, matrix33_t b);
#endif



/** @brief Set matrix elements. */
matrix44_t matrix44_set(double v00, double v01, double v02, double v03, double v10, double v11, double v12, double v13, double v20, double v21, double v22, double v23, double v30, double v31, double v32, double v33);

/** @brief Set matrix elements. */
matrix44_t matrix44_setv(double v[16]);

/** @brief Construct identity matrix. */
matrix44_t matrix44_ident();

/** @brief Add two matrixs. */
matrix44_t matrix44_add(matrix44_t a, matrix44_t b);

/** @brief Subtract matrixs: c = a - b. */
matrix44_t matrix44_sub(matrix44_t a, matrix44_t b);

/** @brief Matrix multiplication c = ab. */
matrix44_t matrix44_mul(matrix44_t a, matrix44_t b);

#if defined VECTOR4
/** @brief Matrix/vector multiplication c = ab. */
vector4_t matrix44_mul_4(matrix44_t a, vector4_t b);
#endif

#if defined MATRIX44
/** @brief Transpose matrix. */
matrix44_t matrix44_trans(matrix44_t a);
#endif

/** @brief Inv matrix. */
matrix44_t matrix44_inv(matrix44_t a);

/** @brief Check for nan elements. */
int matrix44_isnan(matrix44_t a);

#if defined MATRIX41 && defined MATRIX41
/** @brief Matrix multiplication c = ab. */
matrix41_t matrix44_mul_41(matrix44_t a, matrix41_t b);
#endif

#if defined MATRIX42 && defined MATRIX42
/** @brief Matrix multiplication c = ab. */
matrix42_t matrix44_mul_42(matrix44_t a, matrix42_t b);
#endif

#if defined MATRIX43 && defined MATRIX43
/** @brief Matrix multiplication c = ab. */
matrix43_t matrix44_mul_43(matrix44_t a, matrix43_t b);
#endif

#if defined MATRIX44 && defined MATRIX44
/** @brief Matrix multiplication c = ab. */
matrix44_t matrix44_mul_44(matrix44_t a, matrix44_t b);
#endif



/** @brief Set pose elements. */
pose2_t pose2_set(vector2_t pos, double rot);

/** @brief Take pose "inverse"; i.e. if c = a + b, then b = -a + c. */
pose2_t pose2_inv(pose2_t a);

/** @brief Add two poses c = a + b */
pose2_t pose2_add(pose2_t a, pose2_t b);

/** @brief Add two poses c = a + b */
vector2_t pose2_add_pos(vector2_t a, pose2_t b);

/** @brief Add two poses (rotation component) c = a + b */
double pose2_add_rot(double a, pose2_t b);

/** @brief Subtract poses: c = a - b. */
pose2_t pose2_sub(pose2_t a, pose2_t b);

/** @brief Subtract two poses c = a - b */
vector2_t pose2_sub_pos(vector2_t a, pose2_t b);

/** @brief Subtract two poses (rotation component) c = a - b */
double pose2_sub_rot(double a, pose2_t b);



#if defined __cplusplus
}
#endif

#endif
