//
// BLOBStream.cpp
//
// $Id: //poco/1.3/Data/src/BLOBStream.cpp#2 $
//
// Library: Data
// Package: DataCore
// Module:  BLOBStream
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Data/BLOBStream.h"


namespace Poco {
namespace Data {


//
// BLOBStreamBuf
//


BLOBStreamBuf::BLOBStreamBuf(BLOB& blob): 
	_blob(blob),
	_it(_blob.begin())
{
}


BLOBStreamBuf::~BLOBStreamBuf()
{
}


UnbufferedStreamBuf::int_type BLOBStreamBuf::readFromDevice()
{
	if (_it != _blob.end())
		return charToInt(*_it++);
	else
		return -1;
}


UnbufferedStreamBuf::int_type BLOBStreamBuf::writeToDevice(char c)
{
	_blob._pContent->push_back(c);
	return 1;
}


//
// BLOBIOS
//


BLOBIOS::BLOBIOS(BLOB& blob, openmode mode) :_buf(blob)
{
	poco_ios_init(&_buf);
}
	

BLOBIOS::~BLOBIOS()
{
}


BLOBStreamBuf* BLOBIOS::rdbuf()
{
	return &_buf;
}


//
// BLOBOutputStream
//


BLOBOutputStream::BLOBOutputStream(BLOB& blob):
	BLOBIOS(blob, std::ios::out),
	std::ostream(&_buf)
{
}

BLOBOutputStream::~BLOBOutputStream()
{
}


//
// BLOBInputStream
//


BLOBInputStream::BLOBInputStream(BLOB& blob):
	BLOBIOS(blob, std::ios::in),
	std::istream(&_buf)
{
}

BLOBInputStream::~BLOBInputStream()
{
}


} } // namespace Poco::Data
