﻿#include "lang.h"

/* Based on BIP-39 with an accent-insensitive word order */

POLYSEED_PRIVATE const polyseed_lang polyseed_lang_es = {
    .name = u8"español",
    .name_en = "Spanish",
    .separator = " ",
    .is_sorted = true,
    .has_prefix = true,
    .has_accents = true,
    .compose = true,
    .words = {
        u8"ábaco",
        u8"abdomen",
        u8"abeja",
        u8"abierto",
        u8"abogado",
        u8"abono",
        u8"aborto",
        u8"abrazo",
        u8"abrir",
        u8"abuelo",
        u8"abuso",
        u8"acabar",
        u8"academia",
        u8"acceso",
        u8"acción",
        u8"aceite",
        u8"acelga",
        u8"acento",
        u8"aceptar",
        u8"ácido",
        u8"aclarar",
        u8"acné",
        u8"acoger",
        u8"acoso",
        u8"activo",
        u8"acto",
        u8"actriz",
        u8"actuar",
        u8"acudir",
        u8"acuerdo",
        u8"acusar",
        u8"adicto",
        u8"admitir",
        u8"adoptar",
        u8"adorno",
        u8"aduana",
        u8"adulto",
        u8"aéreo",
        u8"afectar",
        u8"afición",
        u8"afinar",
        u8"afirmar",
        u8"ágil",
        u8"agitar",
        u8"agonía",
        u8"agosto",
        u8"agotar",
        u8"agregar",
        u8"agrio",
        u8"agua",
        u8"agudo",
        u8"águila",
        u8"aguja",
        u8"ahogo",
        u8"ahorro",
        u8"aire",
        u8"aislar",
        u8"ajedrez",
        u8"ajeno",
        u8"ajuste",
        u8"alacrán",
        u8"alambre",
        u8"alarma",
        u8"alba",
        u8"álbum",
        u8"alcalde",
        u8"aldea",
        u8"alegre",
        u8"alejar",
        u8"alerta",
        u8"aleta",
        u8"alfiler",
        u8"alga",
        u8"algodón",
        u8"aliado",
        u8"aliento",
        u8"alivio",
        u8"alma",
        u8"almeja",
        u8"almíbar",
        u8"altar",
        u8"alteza",
        u8"altivo",
        u8"alto",
        u8"altura",
        u8"alumno",
        u8"alzar",
        u8"amable",
        u8"amante",
        u8"amapola",
        u8"amargo",
        u8"amasar",
        u8"ámbar",
        u8"ámbito",
        u8"ameno",
        u8"amigo",
        u8"amistad",
        u8"amor",
        u8"amparo",
        u8"amplio",
        u8"añadir",
        u8"ancho",
        u8"anciano",
        u8"ancla",
        u8"andar",
        u8"andén",
        u8"añejo",
        u8"anemia",
        u8"ángulo",
        u8"anillo",
        u8"ánimo",
        u8"anís",
        u8"año",
        u8"anotar",
        u8"antena",
        u8"antiguo",
        u8"antojo",
        u8"anual",
        u8"anular",
        u8"anuncio",
        u8"apagar",
        u8"aparato",
        u8"apetito",
        u8"apio",
        u8"aplicar",
        u8"apodo",
        u8"aporte",
        u8"apoyo",
        u8"aprender",
        u8"aprobar",
        u8"apuesta",
        u8"apuro",
        u8"arado",
        u8"araña",
        u8"arar",
        u8"árbitro",
        u8"árbol",
        u8"arbusto",
        u8"archivo",
        u8"arco",
        u8"arder",
        u8"ardilla",
        u8"arduo",
        u8"área",
        u8"árido",
        u8"aries",
        u8"armonía",
        u8"arnés",
        u8"aroma",
        u8"arpa",
        u8"arpón",
        u8"arreglo",
        u8"arroz",
        u8"arruga",
        u8"arte",
        u8"artista",
        u8"asa",
        u8"asado",
        u8"asalto",
        u8"ascenso",
        u8"asegurar",
        u8"aseo",
        u8"asesor",
        u8"asiento",
        u8"asilo",
        u8"asistir",
        u8"asno",
        u8"asombro",
        u8"áspero",
        u8"astilla",
        u8"astro",
        u8"astuto",
        u8"asumir",
        u8"asunto",
        u8"atajo",
        u8"ataque",
        u8"atar",
        u8"atento",
        u8"ateo",
        u8"ático",
        u8"atleta",
        u8"átomo",
        u8"atraer",
        u8"atroz",
        u8"atún",
        u8"audaz",
        u8"audio",
        u8"auge",
        u8"aula",
        u8"aumento",
        u8"ausente",
        u8"autor",
        u8"aval",
        u8"avance",
        u8"avaro",
        u8"ave",
        u8"avellana",
        u8"avena",
        u8"avestruz",
        u8"avión",
        u8"aviso",
        u8"ayer",
        u8"ayuda",
        u8"ayuno",
        u8"azafrán",
        u8"azar",
        u8"azote",
        u8"azúcar",
        u8"azufre",
        u8"azul",
        u8"baba",
        u8"babor",
        u8"bache",
        u8"bahía",
        u8"baile",
        u8"bajar",
        u8"balanza",
        u8"balcón",
        u8"balde",
        u8"bambú",
        u8"banco",
        u8"banda",
        u8"baño",
        u8"barba",
        u8"barco",
        u8"barniz",
        u8"barro",
        u8"báscula",
        u8"bastón",
        u8"basura",
        u8"batalla",
        u8"batería",
        u8"batir",
        u8"batuta",
        u8"baúl",
        u8"bazar",
        u8"bebé",
        u8"bebida",
        u8"bello",
        u8"besar",
        u8"beso",
        u8"bestia",
        u8"bicho",
        u8"bien",
        u8"bingo",
        u8"blanco",
        u8"bloque",
        u8"blusa",
        u8"boa",
        u8"bobina",
        u8"bobo",
        u8"boca",
        u8"bocina",
        u8"boda",
        u8"bodega",
        u8"boina",
        u8"bola",
        u8"bolero",
        u8"bolsa",
        u8"bomba",
        u8"bondad",
        u8"bonito",
        u8"bono",
        u8"bonsái",
        u8"borde",
        u8"borrar",
        u8"bosque",
        u8"bote",
        u8"botín",
        u8"bóveda",
        u8"bozal",
        u8"bravo",
        u8"brazo",
        u8"brecha",
        u8"breve",
        u8"brillo",
        u8"brinco",
        u8"brisa",
        u8"broca",
        u8"broma",
        u8"bronce",
        u8"brote",
        u8"bruja",
        u8"brusco",
        u8"bruto",
        u8"buceo",
        u8"bucle",
        u8"bueno",
        u8"buey",
        u8"bufanda",
        u8"bufón",
        u8"búho",
        u8"buitre",
        u8"bulto",
        u8"burbuja",
        u8"burla",
        u8"burro",
        u8"buscar",
        u8"butaca",
        u8"buzón",
        u8"caballo",
        u8"cabeza",
        u8"cabina",
        u8"cabra",
        u8"cacao",
        u8"cadáver",
        u8"cadena",
        u8"caer",
        u8"café",
        u8"caída",
        u8"caimán",
        u8"caja",
        u8"cajón",
        u8"cal",
        u8"calamar",
        u8"calcio",
        u8"caldo",
        u8"calidad",
        u8"calle",
        u8"calma",
        u8"calor",
        u8"calvo",
        u8"cama",
        u8"cambio",
        u8"camello",
        u8"camino",
        u8"campo",
        u8"caña",
        u8"cáncer",
        u8"candil",
        u8"canela",
        u8"canguro",
        u8"canica",
        u8"cañón",
        u8"canto",
        u8"caoba",
        u8"caos",
        u8"capaz",
        u8"capitán",
        u8"capote",
        u8"captar",
        u8"capucha",
        u8"cara",
        u8"carbón",
        u8"cárcel",
        u8"careta",
        u8"carga",
        u8"cariño",
        u8"carne",
        u8"carpeta",
        u8"carro",
        u8"carta",
        u8"casa",
        u8"casco",
        u8"casero",
        u8"caspa",
        u8"castor",
        u8"catorce",
        u8"catre",
        u8"caudal",
        u8"causa",
        u8"cazo",
        u8"cebolla",
        u8"ceder",
        u8"cedro",
        u8"celda",
        u8"célebre",
        u8"celoso",
        u8"célula",
        u8"cemento",
        u8"ceniza",
        u8"centro",
        u8"cerca",
        u8"cerdo",
        u8"cereza",
        u8"cero",
        u8"cerrar",
        u8"certeza",
        u8"césped",
        u8"cetro",
        u8"chacal",
        u8"chaleco",
        u8"champú",
        u8"chancla",
        u8"chapa",
        u8"charla",
        u8"chico",
        u8"chiste",
        u8"chivo",
        u8"choque",
        u8"choza",
        u8"chuleta",
        u8"chupar",
        u8"ciclón",
        u8"ciego",
        u8"cielo",
        u8"cien",
        u8"cierto",
        u8"cifra",
        u8"cigarro",
        u8"cima",
        u8"cinco",
        u8"cine",
        u8"cinta",
        u8"ciprés",
        u8"circo",
        u8"ciruela",
        u8"cisne",
        u8"cita",
        u8"ciudad",
        u8"clamor",
        u8"clan",
        u8"claro",
        u8"clase",
        u8"clave",
        u8"cliente",
        u8"clima",
        u8"clínica",
        u8"cobre",
        u8"cocción",
        u8"cochino",
        u8"cocina",
        u8"coco",
        u8"código",
        u8"codo",
        u8"cofre",
        u8"coger",
        u8"cohete",
        u8"cojín",
        u8"cojo",
        u8"cola",
        u8"colcha",
        u8"colegio",
        u8"colgar",
        u8"colina",
        u8"collar",
        u8"colmo",
        u8"columna",
        u8"combate",
        u8"comer",
        u8"comida",
        u8"cómodo",
        u8"compra",
        u8"conde",
        u8"conejo",
        u8"conga",
        u8"conocer",
        u8"consejo",
        u8"contar",
        u8"copa",
        u8"copia",
        u8"corazón",
        u8"corbata",
        u8"corcho",
        u8"cordón",
        u8"corona",
        u8"correr",
        u8"coser",
        u8"cosmos",
        u8"costa",
        u8"cráneo",
        u8"cráter",
        u8"crear",
        u8"crecer",
        u8"creído",
        u8"crema",
        u8"cría",
        u8"crimen",
        u8"cripta",
        u8"crisis",
        u8"cromo",
        u8"crónica",
        u8"croqueta",
        u8"crudo",
        u8"cruz",
        u8"cuadro",
        u8"cuarto",
        u8"cuatro",
        u8"cubo",
        u8"cubrir",
        u8"cuchara",
        u8"cuello",
        u8"cuento",
        u8"cuerda",
        u8"cuesta",
        u8"cueva",
        u8"cuidar",
        u8"culebra",
        u8"culpa",
        u8"culto",
        u8"cumbre",
        u8"cumplir",
        u8"cuna",
        u8"cuneta",
        u8"cuota",
        u8"cupón",
        u8"cúpula",
        u8"curar",
        u8"curioso",
        u8"curso",
        u8"curva",
        u8"cutis",
        u8"dama",
        u8"danza",
        u8"dar",
        u8"dardo",
        u8"dátil",
        u8"deber",
        u8"débil",
        u8"década",
        u8"decir",
        u8"dedo",
        u8"defensa",
        u8"definir",
        u8"dejar",
        u8"delfín",
        u8"delgado",
        u8"delito",
        u8"demora",
        u8"denso",
        u8"dental",
        u8"deporte",
        u8"derecho",
        u8"derrota",
        u8"desayuno",
        u8"deseo",
        u8"desfile",
        u8"desnudo",
        u8"destino",
        u8"desvío",
        u8"detalle",
        u8"detener",
        u8"deuda",
        u8"día",
        u8"diablo",
        u8"diadema",
        u8"diamante",
        u8"diana",
        u8"diario",
        u8"dibujo",
        u8"dictar",
        u8"diente",
        u8"dieta",
        u8"diez",
        u8"difícil",
        u8"digno",
        u8"dilema",
        u8"diluir",
        u8"dinero",
        u8"directo",
        u8"dirigir",
        u8"disco",
        u8"diseño",
        u8"disfraz",
        u8"diva",
        u8"divino",
        u8"doble",
        u8"doce",
        u8"dolor",
        u8"domingo",
        u8"don",
        u8"donar",
        u8"dorado",
        u8"dormir",
        u8"dorso",
        u8"dos",
        u8"dosis",
        u8"dragón",
        u8"droga",
        u8"ducha",
        u8"duda",
        u8"duelo",
        u8"dueño",
        u8"dulce",
        u8"dúo",
        u8"duque",
        u8"durar",
        u8"dureza",
        u8"duro",
        u8"ébano",
        u8"ebrio",
        u8"echar",
        u8"eco",
        u8"ecuador",
        u8"edad",
        u8"edición",
        u8"edificio",
        u8"editor",
        u8"educar",
        u8"efecto",
        u8"eficaz",
        u8"eje",
        u8"ejemplo",
        u8"elefante",
        u8"elegir",
        u8"elemento",
        u8"elevar",
        u8"elipse",
        u8"élite",
        u8"elixir",
        u8"elogio",
        u8"eludir",
        u8"embudo",
        u8"emitir",
        u8"emoción",
        u8"empate",
        u8"empeño",
        u8"empleo",
        u8"empresa",
        u8"enano",
        u8"encargo",
        u8"enchufe",
        u8"encía",
        u8"enemigo",
        u8"enero",
        u8"enfado",
        u8"enfermo",
        u8"engaño",
        u8"enigma",
        u8"enlace",
        u8"enorme",
        u8"enredo",
        u8"ensayo",
        u8"enseñar",
        u8"entero",
        u8"entrar",
        u8"envase",
        u8"envío",
        u8"época",
        u8"equipo",
        u8"erizo",
        u8"escala",
        u8"escena",
        u8"escolar",
        u8"escribir",
        u8"escudo",
        u8"esencia",
        u8"esfera",
        u8"esfuerzo",
        u8"espada",
        u8"espejo",
        u8"espía",
        u8"esposa",
        u8"espuma",
        u8"esquí",
        u8"estar",
        u8"este",
        u8"estilo",
        u8"estufa",
        u8"etapa",
        u8"eterno",
        u8"ética",
        u8"etnia",
        u8"evadir",
        u8"evaluar",
        u8"evento",
        u8"evitar",
        u8"exacto",
        u8"examen",
        u8"exceso",
        u8"excusa",
        u8"exento",
        u8"exigir",
        u8"exilio",
        u8"existir",
        u8"éxito",
        u8"experto",
        u8"explicar",
        u8"exponer",
        u8"extremo",
        u8"fábrica",
        u8"fábula",
        u8"fachada",
        u8"fácil",
        u8"factor",
        u8"faena",
        u8"faja",
        u8"falda",
        u8"fallo",
        u8"falso",
        u8"faltar",
        u8"fama",
        u8"familia",
        u8"famoso",
        u8"faraón",
        u8"farmacia",
        u8"farol",
        u8"farsa",
        u8"fase",
        u8"fatiga",
        u8"fauna",
        u8"favor",
        u8"fax",
        u8"febrero",
        u8"fecha",
        u8"feliz",
        u8"feo",
        u8"feria",
        u8"feroz",
        u8"fértil",
        u8"fervor",
        u8"festín",
        u8"fiable",
        u8"fianza",
        u8"fiar",
        u8"fibra",
        u8"ficción",
        u8"ficha",
        u8"fideo",
        u8"fiebre",
        u8"fiel",
        u8"fiera",
        u8"fiesta",
        u8"figura",
        u8"fijar",
        u8"fijo",
        u8"fila",
        u8"filete",
        u8"filial",
        u8"filtro",
        u8"fin",
        u8"finca",
        u8"fingir",
        u8"finito",
        u8"firma",
        u8"flaco",
        u8"flauta",
        u8"flecha",
        u8"flor",
        u8"flota",
        u8"fluir",
        u8"flujo",
        u8"flúor",
        u8"fobia",
        u8"foca",
        u8"fogata",
        u8"fogón",
        u8"folio",
        u8"folleto",
        u8"fondo",
        u8"forma",
        u8"forro",
        u8"fortuna",
        u8"forzar",
        u8"fosa",
        u8"foto",
        u8"fracaso",
        u8"frágil",
        u8"franja",
        u8"frase",
        u8"fraude",
        u8"freír",
        u8"freno",
        u8"fresa",
        u8"frío",
        u8"frito",
        u8"fruta",
        u8"fuego",
        u8"fuente",
        u8"fuerza",
        u8"fuga",
        u8"fumar",
        u8"función",
        u8"funda",
        u8"furgón",
        u8"furia",
        u8"fusil",
        u8"fútbol",
        u8"futuro",
        u8"gacela",
        u8"gafas",
        u8"gaita",
        u8"gajo",
        u8"gala",
        u8"galería",
        u8"gallo",
        u8"gamba",
        u8"ganar",
        u8"gancho",
        u8"ganga",
        u8"ganso",
        u8"garaje",
        u8"garza",
        u8"gasolina",
        u8"gastar",
        u8"gato",
        u8"gavilán",
        u8"gemelo",
        u8"gemir",
        u8"gen",
        u8"género",
        u8"genio",
        u8"gente",
        u8"geranio",
        u8"gerente",
        u8"germen",
        u8"gesto",
        u8"gigante",
        u8"gimnasio",
        u8"girar",
        u8"giro",
        u8"glaciar",
        u8"globo",
        u8"gloria",
        u8"gol",
        u8"golfo",
        u8"goloso",
        u8"golpe",
        u8"goma",
        u8"gordo",
        u8"gorila",
        u8"gorra",
        u8"gota",
        u8"goteo",
        u8"gozar",
        u8"grada",
        u8"gráfico",
        u8"grano",
        u8"grasa",
        u8"gratis",
        u8"grave",
        u8"grieta",
        u8"grillo",
        u8"gripe",
        u8"gris",
        u8"grito",
        u8"grosor",
        u8"grúa",
        u8"grueso",
        u8"grumo",
        u8"grupo",
        u8"guante",
        u8"guapo",
        u8"guardia",
        u8"guerra",
        u8"guía",
        u8"guiño",
        u8"guion",
        u8"guiso",
        u8"guitarra",
        u8"gusano",
        u8"gustar",
        u8"haber",
        u8"hábil",
        u8"hablar",
        u8"hacer",
        u8"hacha",
        u8"hada",
        u8"hallar",
        u8"hamaca",
        u8"harina",
        u8"haz",
        u8"hazaña",
        u8"hebilla",
        u8"hebra",
        u8"hecho",
        u8"helado",
        u8"helio",
        u8"hembra",
        u8"herir",
        u8"hermano",
        u8"héroe",
        u8"hervir",
        u8"hielo",
        u8"hierro",
        u8"hígado",
        u8"higiene",
        u8"hijo",
        u8"himno",
        u8"historia",
        u8"hocico",
        u8"hogar",
        u8"hoguera",
        u8"hoja",
        u8"hombre",
        u8"hongo",
        u8"honor",
        u8"honra",
        u8"hora",
        u8"hormiga",
        u8"horno",
        u8"hostil",
        u8"hoyo",
        u8"hueco",
        u8"huelga",
        u8"huerta",
        u8"hueso",
        u8"huevo",
        u8"huida",
        u8"huir",
        u8"humano",
        u8"húmedo",
        u8"humilde",
        u8"humo",
        u8"hundir",
        u8"huracán",
        u8"hurto",
        u8"icono",
        u8"ideal",
        u8"idioma",
        u8"ídolo",
        u8"iglesia",
        u8"iglú",
        u8"igual",
        u8"ilegal",
        u8"ilusión",
        u8"imagen",
        u8"imán",
        u8"imitar",
        u8"impar",
        u8"imperio",
        u8"imponer",
        u8"impulso",
        u8"incapaz",
        u8"índice",
        u8"inerte",
        u8"infiel",
        u8"informe",
        u8"ingenio",
        u8"inicio",
        u8"inmenso",
        u8"inmune",
        u8"innato",
        u8"insecto",
        u8"instante",
        u8"interés",
        u8"íntimo",
        u8"intuir",
        u8"inútil",
        u8"invierno",
        u8"ira",
        u8"iris",
        u8"ironía",
        u8"isla",
        u8"islote",
        u8"jabalí",
        u8"jabón",
        u8"jamón",
        u8"jarabe",
        u8"jardín",
        u8"jarra",
        u8"jaula",
        u8"jazmín",
        u8"jefe",
        u8"jeringa",
        u8"jinete",
        u8"jornada",
        u8"joroba",
        u8"joven",
        u8"joya",
        u8"juerga",
        u8"jueves",
        u8"juez",
        u8"jugador",
        u8"jugo",
        u8"juguete",
        u8"juicio",
        u8"junco",
        u8"jungla",
        u8"junio",
        u8"juntar",
        u8"júpiter",
        u8"jurar",
        u8"justo",
        u8"juvenil",
        u8"juzgar",
        u8"kilo",
        u8"koala",
        u8"labio",
        u8"lacio",
        u8"lacra",
        u8"lado",
        u8"ladrón",
        u8"lagarto",
        u8"lágrima",
        u8"laguna",
        u8"laico",
        u8"lamer",
        u8"lámina",
        u8"lámpara",
        u8"lana",
        u8"lancha",
        u8"langosta",
        u8"lanza",
        u8"lápiz",
        u8"largo",
        u8"larva",
        u8"lástima",
        u8"lata",
        u8"látex",
        u8"latir",
        u8"laurel",
        u8"lavar",
        u8"lazo",
        u8"leal",
        u8"lección",
        u8"leche",
        u8"lector",
        u8"leer",
        u8"legión",
        u8"legumbre",
        u8"lejano",
        u8"leña",
        u8"lengua",
        u8"lento",
        u8"león",
        u8"leopardo",
        u8"lesión",
        u8"letal",
        u8"letra",
        u8"leve",
        u8"leyenda",
        u8"libertad",
        u8"libro",
        u8"licor",
        u8"líder",
        u8"lidiar",
        u8"lienzo",
        u8"liga",
        u8"ligero",
        u8"lima",
        u8"límite",
        u8"limón",
        u8"limpio",
        u8"lince",
        u8"lindo",
        u8"línea",
        u8"lingote",
        u8"lino",
        u8"linterna",
        u8"líquido",
        u8"liso",
        u8"lista",
        u8"litera",
        u8"litio",
        u8"litro",
        u8"llaga",
        u8"llama",
        u8"llanto",
        u8"llave",
        u8"llegar",
        u8"llenar",
        u8"llevar",
        u8"llorar",
        u8"llover",
        u8"lluvia",
        u8"lobo",
        u8"loción",
        u8"loco",
        u8"locura",
        u8"lógica",
        u8"logro",
        u8"lombriz",
        u8"lomo",
        u8"lonja",
        u8"lote",
        u8"lucha",
        u8"lucir",
        u8"lugar",
        u8"lujo",
        u8"luna",
        u8"lunes",
        u8"lupa",
        u8"lustro",
        u8"luto",
        u8"luz",
        u8"maceta",
        u8"macho",
        u8"madera",
        u8"madre",
        u8"maduro",
        u8"maestro",
        u8"mafia",
        u8"magia",
        u8"mago",
        u8"maíz",
        u8"maldad",
        u8"maleta",
        u8"malla",
        u8"malo",
        u8"mamá",
        u8"mambo",
        u8"mamut",
        u8"mañana",
        u8"manco",
        u8"mando",
        u8"manejar",
        u8"manga",
        u8"maniquí",
        u8"manjar",
        u8"mano",
        u8"manso",
        u8"manta",
        u8"mapa",
        u8"máquina",
        u8"mar",
        u8"marco",
        u8"marea",
        u8"marfil",
        u8"margen",
        u8"marido",
        u8"mármol",
        u8"marrón",
        u8"martes",
        u8"marzo",
        u8"masa",
        u8"máscara",
        u8"masivo",
        u8"matar",
        u8"materia",
        u8"matiz",
        u8"matriz",
        u8"máximo",
        u8"mayor",
        u8"mazorca",
        u8"mecha",
        u8"medalla",
        u8"medio",
        u8"médula",
        u8"mejilla",
        u8"mejor",
        u8"melena",
        u8"melón",
        u8"memoria",
        u8"menor",
        u8"mensaje",
        u8"mente",
        u8"menú",
        u8"mercado",
        u8"merengue",
        u8"mérito",
        u8"mes",
        u8"mesón",
        u8"meta",
        u8"meter",
        u8"método",
        u8"metro",
        u8"mezcla",
        u8"miedo",
        u8"miel",
        u8"miembro",
        u8"miga",
        u8"mil",
        u8"milagro",
        u8"militar",
        u8"millón",
        u8"mimo",
        u8"mina",
        u8"minero",
        u8"mínimo",
        u8"minuto",
        u8"miope",
        u8"mirar",
        u8"misa",
        u8"miseria",
        u8"misil",
        u8"mismo",
        u8"mitad",
        u8"mito",
        u8"mochila",
        u8"moción",
        u8"moda",
        u8"modelo",
        u8"moho",
        u8"mojar",
        u8"molde",
        u8"moler",
        u8"molino",
        u8"momento",
        u8"momia",
        u8"monarca",
        u8"moneda",
        u8"monja",
        u8"moño",
        u8"monto",
        u8"morada",
        u8"morder",
        u8"moreno",
        u8"morir",
        u8"morro",
        u8"morsa",
        u8"mortal",
        u8"mosca",
        u8"mostrar",
        u8"motivo",
        u8"mover",
        u8"móvil",
        u8"mozo",
        u8"mucho",
        u8"mudar",
        u8"mueble",
        u8"muela",
        u8"muerte",
        u8"muestra",
        u8"mugre",
        u8"mujer",
        u8"mula",
        u8"muleta",
        u8"multa",
        u8"mundo",
        u8"muñeca",
        u8"mural",
        u8"muro",
        u8"músculo",
        u8"museo",
        u8"musgo",
        u8"música",
        u8"muslo",
        u8"nácar",
        u8"nación",
        u8"nadar",
        u8"naipe",
        u8"naranja",
        u8"nariz",
        u8"narrar",
        u8"nasal",
        u8"natal",
        u8"nativo",
        u8"natural",
        u8"náusea",
        u8"naval",
        u8"nave",
        u8"navidad",
        u8"necio",
        u8"néctar",
        u8"negar",
        u8"negocio",
        u8"negro",
        u8"neón",
        u8"nervio",
        u8"neto",
        u8"neutro",
        u8"nevar",
        u8"nevera",
        u8"nicho",
        u8"nido",
        u8"niebla",
        u8"nieto",
        u8"niñez",
        u8"niño",
        u8"nítido",
        u8"nivel",
        u8"nobleza",
        u8"noche",
        u8"nómina",
        u8"noria",
        u8"norma",
        u8"norte",
        u8"nota",
        u8"noticia",
        u8"novato",
        u8"novela",
        u8"novio",
        u8"nube",
        u8"nuca",
        u8"núcleo",
        u8"nudillo",
        u8"nudo",
        u8"nuera",
        u8"nueve",
        u8"nuez",
        u8"nulo",
        u8"número",
        u8"nutria",
        u8"oasis",
        u8"obeso",
        u8"obispo",
        u8"objeto",
        u8"obra",
        u8"obrero",
        u8"observar",
        u8"obtener",
        u8"obvio",
        u8"oca",
        u8"ocaso",
        u8"océano",
        u8"ochenta",
        u8"ocho",
        u8"ocio",
        u8"ocre",
        u8"octavo",
        u8"octubre",
        u8"oculto",
        u8"ocupar",
        u8"ocurrir",
        u8"odiar",
        u8"odio",
        u8"odisea",
        u8"oeste",
        u8"ofensa",
        u8"oferta",
        u8"oficio",
        u8"ofrecer",
        u8"ogro",
        u8"oído",
        u8"oír",
        u8"ojo",
        u8"ola",
        u8"oleada",
        u8"olfato",
        u8"olivo",
        u8"olla",
        u8"olmo",
        u8"olor",
        u8"olvido",
        u8"ombligo",
        u8"onda",
        u8"onza",
        u8"opaco",
        u8"opción",
        u8"ópera",
        u8"opinar",
        u8"oponer",
        u8"optar",
        u8"óptica",
        u8"opuesto",
        u8"oración",
        u8"orador",
        u8"oral",
        u8"órbita",
        u8"orca",
        u8"orden",
        u8"oreja",
        u8"órgano",
        u8"orgía",
        u8"orgullo",
        u8"oriente",
        u8"origen",
        u8"orilla",
        u8"oro",
        u8"orquesta",
        u8"oruga",
        u8"osadía",
        u8"oscuro",
        u8"osezno",
        u8"oso",
        u8"ostra",
        u8"otoño",
        u8"otro",
        u8"oveja",
        u8"óvulo",
        u8"óxido",
        u8"oxígeno",
        u8"oyente",
        u8"ozono",
        u8"pacto",
        u8"padre",
        u8"paella",
        u8"página",
        u8"pago",
        u8"país",
        u8"pájaro",
        u8"palabra",
        u8"palco",
        u8"paleta",
        u8"pálido",
        u8"palma",
        u8"paloma",
        u8"palpar",
        u8"pan",
        u8"panal",
        u8"pánico",
        u8"pantera",
        u8"pañuelo",
        u8"papá",
        u8"papel",
        u8"papilla",
        u8"paquete",
        u8"parar",
        u8"parcela",
        u8"pared",
        u8"parir",
        u8"paro",
        u8"párpado",
        u8"parque",
        u8"párrafo",
        u8"parte",
        u8"pasar",
        u8"paseo",
        u8"pasión",
        u8"paso",
        u8"pasta",
        u8"pata",
        u8"patio",
        u8"patria",
        u8"pausa",
        u8"pauta",
        u8"pavo",
        u8"payaso",
        u8"peatón",
        u8"pecado",
        u8"pecera",
        u8"pecho",
        u8"pedal",
        u8"pedir",
        u8"pegar",
        u8"peine",
        u8"pelar",
        u8"peldaño",
        u8"pelea",
        u8"peligro",
        u8"pellejo",
        u8"pelo",
        u8"peluca",
        u8"pena",
        u8"peñón",
        u8"pensar",
        u8"peón",
        u8"peor",
        u8"pepino",
        u8"pequeño",
        u8"pera",
        u8"percha",
        u8"perder",
        u8"pereza",
        u8"perfil",
        u8"perico",
        u8"perla",
        u8"permiso",
        u8"perro",
        u8"persona",
        u8"pesa",
        u8"pesca",
        u8"pésimo",
        u8"pestaña",
        u8"pétalo",
        u8"petróleo",
        u8"pez",
        u8"pezuña",
        u8"picar",
        u8"pichón",
        u8"pie",
        u8"piedra",
        u8"pierna",
        u8"pieza",
        u8"pijama",
        u8"pilar",
        u8"piloto",
        u8"pimienta",
        u8"piña",
        u8"pino",
        u8"pintor",
        u8"pinza",
        u8"piojo",
        u8"pipa",
        u8"pirata",
        u8"pisar",
        u8"piscina",
        u8"piso",
        u8"pista",
        u8"pitón",
        u8"pizca",
        u8"placa",
        u8"plan",
        u8"plata",
        u8"playa",
        u8"plaza",
        u8"pleito",
        u8"pleno",
        u8"plomo",
        u8"pluma",
        u8"plural",
        u8"pobre",
        u8"poco",
        u8"poder",
        u8"podio",
        u8"poema",
        u8"poesía",
        u8"poeta",
        u8"polen",
        u8"policía",
        u8"pollo",
        u8"polvo",
        u8"pomada",
        u8"pomelo",
        u8"pomo",
        u8"pompa",
        u8"poner",
        u8"porción",
        u8"portal",
        u8"posada",
        u8"poseer",
        u8"posible",
        u8"poste",
        u8"potencia",
        u8"potro",
        u8"pozo",
        u8"prado",
        u8"precoz",
        u8"pregunta",
        u8"premio",
        u8"prensa",
        u8"preso",
        u8"previo",
        u8"primo",
        u8"príncipe",
        u8"prisión",
        u8"privar",
        u8"proa",
        u8"probar",
        u8"proceso",
        u8"producto",
        u8"proeza",
        u8"profesor",
        u8"programa",
        u8"prole",
        u8"promesa",
        u8"pronto",
        u8"propio",
        u8"próximo",
        u8"prueba",
        u8"público",
        u8"puchero",
        u8"pudor",
        u8"pueblo",
        u8"puerta",
        u8"puesto",
        u8"pulga",
        u8"pulir",
        u8"pulmón",
        u8"pulpo",
        u8"pulso",
        u8"puma",
        u8"puñal",
        u8"puño",
        u8"punto",
        u8"pupa",
        u8"pupila",
        u8"puré",
        u8"quedar",
        u8"queja",
        u8"quemar",
        u8"querer",
        u8"queso",
        u8"quieto",
        u8"química",
        u8"quince",
        u8"quitar",
        u8"rábano",
        u8"rabia",
        u8"rabo",
        u8"ración",
        u8"radical",
        u8"raíz",
        u8"rama",
        u8"rampa",
        u8"rancho",
        u8"rango",
        u8"rapaz",
        u8"rápido",
        u8"rapto",
        u8"rasgo",
        u8"raspa",
        u8"rato",
        u8"rayo",
        u8"raza",
        u8"razón",
        u8"reacción",
        u8"realidad",
        u8"rebaño",
        u8"rebote",
        u8"recaer",
        u8"receta",
        u8"rechazo",
        u8"recoger",
        u8"recreo",
        u8"recto",
        u8"recurso",
        u8"red",
        u8"redondo",
        u8"reducir",
        u8"reflejo",
        u8"reforma",
        u8"refrán",
        u8"refugio",
        u8"regalo",
        u8"regir",
        u8"regla",
        u8"regreso",
        u8"rehén",
        u8"reino",
        u8"reír",
        u8"reja",
        u8"relato",
        u8"relevo",
        u8"relieve",
        u8"relleno",
        u8"reloj",
        u8"remar",
        u8"remedio",
        u8"remo",
        u8"rencor",
        u8"rendir",
        u8"renta",
        u8"reparto",
        u8"repetir",
        u8"reposo",
        u8"reptil",
        u8"res",
        u8"rescate",
        u8"resina",
        u8"respeto",
        u8"resto",
        u8"resumen",
        u8"retiro",
        u8"retorno",
        u8"retrato",
        u8"reunir",
        u8"revés",
        u8"revista",
        u8"rey",
        u8"rezar",
        u8"rico",
        u8"riego",
        u8"rienda",
        u8"riesgo",
        u8"rifa",
        u8"rígido",
        u8"rigor",
        u8"rincón",
        u8"riñón",
        u8"río",
        u8"riqueza",
        u8"risa",
        u8"ritmo",
        u8"rito",
        u8"rizo",
        u8"roble",
        u8"roce",
        u8"rociar",
        u8"rodar",
        u8"rodeo",
        u8"rodilla",
        u8"roer",
        u8"rojizo",
        u8"rojo",
        u8"romero",
        u8"romper",
        u8"ron",
        u8"ronco",
        u8"ronda",
        u8"ropa",
        u8"ropero",
        u8"rosa",
        u8"rosca",
        u8"rostro",
        u8"rotar",
        u8"rubí",
        u8"rubor",
        u8"rudo",
        u8"rueda",
        u8"rugir",
        u8"ruido",
        u8"ruina",
        u8"ruleta",
        u8"rulo",
        u8"rumbo",
        u8"rumor",
        u8"ruptura",
        u8"ruta",
        u8"rutina",
        u8"sábado",
        u8"saber",
        u8"sabio",
        u8"sable",
        u8"sacar",
        u8"sagaz",
        u8"sagrado",
        u8"sala",
        u8"saldo",
        u8"salero",
        u8"salir",
        u8"salmón",
        u8"salón",
        u8"salsa",
        u8"salto",
        u8"salud",
        u8"salvar",
        u8"samba",
        u8"sanción",
        u8"sandía",
        u8"sanear",
        u8"sangre",
        u8"sanidad",
        u8"sano",
        u8"santo",
        u8"sapo",
        u8"saque",
        u8"sardina",
        u8"sartén",
        u8"sastre",
        u8"satán",
        u8"sauna",
        u8"saxofón",
        u8"sección",
        u8"seco",
        u8"secreto",
        u8"secta",
        u8"sed",
        u8"seguir",
        u8"seis",
        u8"sello",
        u8"selva",
        u8"semana",
        u8"semilla",
        u8"señal",
        u8"senda",
        u8"señor",
        u8"sensor",
        u8"separar",
        u8"sepia",
        u8"sequía",
        u8"ser",
        u8"serie",
        u8"sermón",
        u8"servir",
        u8"sesenta",
        u8"sesión",
        u8"seta",
        u8"setenta",
        u8"severo",
        u8"sexo",
        u8"sexto",
        u8"sidra",
        u8"siesta",
        u8"siete",
        u8"siglo",
        u8"signo",
        u8"sílaba",
        u8"silbar",
        u8"silencio",
        u8"silla",
        u8"símbolo",
        u8"simio",
        u8"sirena",
        u8"sistema",
        u8"sitio",
        u8"situar",
        u8"sobre",
        u8"socio",
        u8"sodio",
        u8"sol",
        u8"solapa",
        u8"soldado",
        u8"soledad",
        u8"sólido",
        u8"soltar",
        u8"solución",
        u8"sombra",
        u8"sondeo",
        u8"sonido",
        u8"sonoro",
        u8"sonrisa",
        u8"sopa",
        u8"soplar",
        u8"soporte",
        u8"sordo",
        u8"sorpresa",
        u8"sorteo",
        u8"sostén",
        u8"sótano",
        u8"suave",
        u8"subir",
        u8"suceso",
        u8"sudor",
        u8"suegra",
        u8"suelo",
        u8"sueño",
        u8"suerte",
        u8"sufrir",
        u8"sujeto",
        u8"sultán",
        u8"sumar",
        u8"superar",
        u8"suplir",
        u8"suponer",
        u8"supremo",
        u8"sur",
        u8"surco",
        u8"sureño",
        u8"surgir",
        u8"susto",
        u8"sutil",
        u8"tabaco",
        u8"tabique",
        u8"tabla",
        u8"tabú",
        u8"taco",
        u8"tacto",
        u8"tajo",
        u8"talar",
        u8"talco",
        u8"talento",
        u8"talla",
        u8"talón",
        u8"tamaño",
        u8"tambor",
        u8"tango",
        u8"tanque",
        u8"tapa",
        u8"tapete",
        u8"tapia",
        u8"tapón",
        u8"taquilla",
        u8"tarde",
        u8"tarea",
        u8"tarifa",
        u8"tarjeta",
        u8"tarot",
        u8"tarro",
        u8"tarta",
        u8"tatuaje",
        u8"tauro",
        u8"taza",
        u8"tazón",
        u8"teatro",
        u8"techo",
        u8"tecla",
        u8"técnica",
        u8"tejado",
        u8"tejer",
        u8"tejido",
        u8"tela",
        u8"teléfono",
        u8"tema",
        u8"temor",
        u8"templo",
        u8"tenaz",
        u8"tender",
        u8"tener",
        u8"tenis",
        u8"tenso",
        u8"teoría",
        u8"terapia",
        u8"terco",
        u8"término",
        u8"ternura",
        u8"terror",
        u8"tesis",
        u8"tesoro",
        u8"testigo",
        u8"tetera",
        u8"texto",
        u8"tez",
        u8"tibio",
        u8"tiburón",
        u8"tiempo",
        u8"tienda",
        u8"tierra",
        u8"tieso",
        u8"tigre",
        u8"tijera",
        u8"tilde",
        u8"timbre",
        u8"tímido",
        u8"timo",
        u8"tinta",
        u8"tío",
        u8"típico",
        u8"tipo",
        u8"tira",
        u8"tirón",
        u8"titán",
        u8"títere",
        u8"título",
        u8"tiza",
        u8"toalla",
        u8"tobillo",
        u8"tocar",
        u8"tocino",
        u8"todo",
        u8"toga",
        u8"toldo",
        u8"tomar",
        u8"tono",
        u8"tonto",
        u8"topar",
        u8"tope",
        u8"toque",
        u8"tórax",
        u8"torero",
        u8"tormenta",
        u8"torneo",
        u8"toro",
        u8"torpedo",
        u8"torre",
        u8"torso",
        u8"tortuga",
        u8"tos",
        u8"tosco",
        u8"toser",
        u8"tóxico",
        u8"trabajo",
        u8"tractor",
        u8"traer",
        u8"tráfico",
        u8"trago",
        u8"traje",
        u8"tramo",
        u8"trance",
        u8"trato",
        u8"trauma",
        u8"trazar",
        u8"trébol",
        u8"tregua",
        u8"treinta",
        u8"tren",
        u8"trepar",
        u8"tres",
        u8"tribu",
        u8"trigo",
        u8"tripa",
        u8"triste",
        u8"triunfo",
        u8"trofeo",
        u8"trompa",
        u8"tronco",
        u8"tropa",
        u8"trote",
        u8"trozo",
        u8"truco",
        u8"trueno",
        u8"trufa",
        u8"tubería",
        u8"tubo",
        u8"tuerto",
        u8"tumba",
        u8"tumor",
        u8"túnel",
        u8"túnica",
        u8"turbina",
        u8"turismo",
        u8"turno",
        u8"tutor",
        u8"ubicar",
        u8"úlcera",
        u8"umbral",
        u8"uña",
        u8"unidad",
        u8"unir",
        u8"universo",
        u8"uno",
        u8"untar",
        u8"urbano",
        u8"urbe",
        u8"urgente",
        u8"urna",
        u8"usar",
        u8"usuario",
        u8"útil",
        u8"utopía",
        u8"uva",
        u8"vaca",
        u8"vacío",
        u8"vacuna",
        u8"vagar",
        u8"vago",
        u8"vaina",
        u8"vajilla",
        u8"vale",
        u8"válido",
        u8"valle",
        u8"valor",
        u8"válvula",
        u8"vampiro",
        u8"vara",
        u8"variar",
        u8"varón",
        u8"vaso",
        u8"vecino",
        u8"vector",
        u8"vehículo",
        u8"veinte",
        u8"vejez",
        u8"vela",
        u8"velero",
        u8"veloz",
        u8"vena",
        u8"vencer",
        u8"venda",
        u8"veneno",
        u8"vengar",
        u8"venir",
        u8"venta",
        u8"venus",
        u8"ver",
        u8"verano",
        u8"verbo",
        u8"verde",
        u8"vereda",
        u8"verja",
        u8"verso",
        u8"verter",
        u8"vía",
        u8"viaje",
        u8"vibrar",
        u8"vicio",
        u8"víctima",
        u8"vida",
        u8"vídeo",
        u8"vidrio",
        u8"viejo",
        u8"viernes",
        u8"vigor",
        u8"vil",
        u8"villa",
        u8"vinagre",
        u8"viñedo",
        u8"vino",
        u8"violín",
        u8"viral",
        u8"virgo",
        u8"virtud",
        u8"visor",
        u8"víspera",
        u8"vista",
        u8"vitamina",
        u8"viudo",
        u8"vivaz",
        u8"vivero",
        u8"vivir",
        u8"vivo",
        u8"volcán",
        u8"volumen",
        u8"volver",
        u8"voraz",
        u8"votar",
        u8"voto",
        u8"voz",
        u8"vuelo",
        u8"vulgar",
        u8"yacer",
        u8"yate",
        u8"yegua",
        u8"yema",
        u8"yerno",
        u8"yeso",
        u8"yodo",
        u8"yoga",
        u8"yogur",
        u8"zafiro",
        u8"zanja",
        u8"zapato",
        u8"zarza",
        u8"zona",
        u8"zorro",
        u8"zumo",
        u8"zurdo",
    }
};
