/*
 * Copyright 2013 Canonical Ltd.
 *
 * Authors:
 * Ricardo Mendoza: ricardo.mendoza@canonical.com
 *
 * This file is part of powerd.
 *
 * powerd is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * powerd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "powerd-internal.h"
#include "powerd-sensors.h"
#include "log.h"

#include <ubuntu/application/sensors/light.h>
#include <ubuntu/application/sensors/proximity.h>

UASensorsProximity* prox_sensor;
UASensorsLight* light_sensor;

void on_new_proximity_event(UASProximityEvent *event, void *context)
{
    switch (uas_proximity_event_get_distance(event))
    {
        case U_PROXIMITY_NEAR:
        {
            powerd_proximity_event(TRUE);
            break;
        }
        case U_PROXIMITY_FAR:
        {
            powerd_proximity_event(FALSE);
            break;
        }
    }
}

void powerd_sensors_proximity_enable(void)
{
    ua_sensors_proximity_enable(prox_sensor);
}

void powerd_sensors_proximity_disable(void)
{
    ua_sensors_proximity_disable(prox_sensor);
}

void on_new_als_event(UASLightEvent *event, void *context)
{
    float lux = uas_light_event_get_light(event);
    powerd_new_als_event(lux);
}

void powerd_sensors_als_enable(void)
{
    if (light_sensor)
        ua_sensors_light_enable(light_sensor);
}

void powerd_sensors_als_disable(void)
{
    if (light_sensor)
        ua_sensors_light_disable(light_sensor);
}

void powerd_sensors_init(void)
{
    prox_sensor = ua_sensors_proximity_new();
    if (prox_sensor != NULL) {
        ua_sensors_proximity_set_reading_cb(prox_sensor,
                                            on_new_proximity_event,
                                            NULL);
    } else {
        powerd_warn("Failed to allocate proximity sensor");
    }

    light_sensor = ua_sensors_light_new();
    if (light_sensor) {
        ua_sensors_light_set_reading_cb(light_sensor, on_new_als_event,
                                        NULL);
    } else {
        powerd_warn("Failed to allocate ambient light sensor");
    }
}
