/* $Cambridge: hermes/src/prayer/cmd/cmd_sizes.c,v 1.3 2008/09/17 17:20:25 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_sizes(struct session *session)
{
    struct template_vals *tvals = session->template_vals;
    struct folderlist *fl = folderlist_fetch(session);
    struct prefs *prefs = session->options->prefs;
    BOOL suppress_dotfiles = prefs->suppress_dotfiles;
    struct request *request = session->request;
    struct buffer *b = request->write_buffer;
    struct folderitem *fi;
    char *name;

    /* Record last command for compose/cancel and friends */
    if ((request->argc == 3) && !strcmp(request->argv[1], "toggle")) {
        name = string_canon_decode(request->argv[2]);
        fi   = folderlist_lookup(fl, name);

        if (fi) {
            if (fi->expanded) {
                session_message(session, "Collapsed \"%s\"", name);
                fi->expanded = NIL;
            } else {
                folderlist_expand(session, fi);
                session_message(session, "Expanded \"%s\"", name);
                fi->expanded = T;
            }
        }
    }

    /* Save options if anything changed */
    if (session->options->save)
        session_streams_save_options(session);

    if (!folderlist_update_sizes(folderlist_fetch(session), session))
        session_alert(session, "Failed to update folder sizes");

    folderlist_template_vals_tree(fl, suppress_dotfiles, tvals, "@folder");
    folderlist_template_vals_list(fl, suppress_dotfiles, tvals,
                                  T, "@dirlist");
    session_seed_template(session, tvals);
    template_expand("sizes", tvals, b);

    response_html(request, 200);
}
