# リファレンス
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## 目次

**クラス**

_パブリッククラス_

* [`mysql::bindings`](#mysqlbindings): MySQLバインディングの親クラス。
* [`mysql::client`](#mysqlclient): MySQLクライアントをインストールして設定します。
* [`mysql::server`](#mysqlserver): MySQLサーバをインストールして設定します。
* [`mysql::server::backup`](#mysqlserverbackup): MySQLバックアップを作成して管理します。
* [`mysql::server::monitor`](#mysqlservermonitor): モニタするユーザをデータベースに追加するヘルパクラスです。
* [`mysql::server::mysqltuner`](#mysqlservermysqltuner): MySQLTunerパッケージを管理します。

_プライベートクラス_

* `mysql::backup::mysqlbackup`: mysqlbackupクライアントを管理します。
* `mysql::backup::mysqldump`: mysqldumpの"プロバイダ"
* `mysql::backup::xtrabackup`: Percona XtraBackupの"プロバイダ"
* `mysql::bindings::client_dev`: クライアント開発バインディングのインストールに使用するプライベートクラス
* `mysql::bindings::daemon_dev`: デーモン開発バインディングのインストールに使用するプライベートクラス
* `mysql::bindings::java`: java言語バインディングのインストールに使用するプライベートクラス。
* `mysql::bindings::perl`: perl言語バインディングのインストールに使用するプライベートクラス。
* `mysql::bindings::php`: php言語バインディングのインストールに使用するプライベートクラス
* `mysql::bindings::python`: python言語バインディングのインストールに使用するプライベートクラス
* `mysql::bindings::ruby`: ruby言語バインディングのインストールに使用するプライベートクラス
* `mysql::client::install`: MySQLクライアントのインストールに使用するプライベートクラス。
* `mysql::params`: Paramsクラス。
* `mysql::server::account_security`: localhostアカウントが存在しないことを確認するためのプライベートクラス
* `mysql::server::binarylog`: バイナリログの設定では、mysqlユーザが必要です。パッケージのインストール後に行ってください
* `mysql::server::config`: MySQLサーバの設定に使用するプライベートクラス。
* `mysql::server::install`: MySQLパッケージの管理に使用するプライベートクラス。
* `mysql::server::installdb`: インストール時に初期データベースを構築します。
* `mysql::server::providers`: mysel::serverで指定された、対応するハッシュを使って3つのプロバイダを呼び出すためのコンビニエンスクラス。
* `mysql::server::root_password`: ルートパスワードの管理に使用するプライベートクラス
* `mysql::server::service`: MySQLサービスの管理に使用するプライベートクラス

**定義された型**

* [`mysql::db`](#mysqldb): MySQLデータベースを作成して設定します。

**リソース型**

_パブリックリソース型_

* [`mysql_plugin`](#mysql_plugin): MySQLプラグインを管理します。

_プライベートリソース型_

* `mysql_database`: MySQLデータベースを管理します。
* `mysql_datadir`: mysql_install_dbまたはmysqld (5.7.6以上)を使用してMySQL datadirsを管理します。
* `mysql_grant`: MySQLのユーザ権限を管理します。
* `mysql_user`: MySQLユーザを管理します。これには、ユーザパスワードおよび権限の管理が含まれます。

**関数**

* [`mysql::password`](#mysqlpassword): mysqlの"PASSWORD()"関数のように、文字列にハッシュをかけます
* [`mysql::strip_hash`](#mysqlstrip_hash): ハッシュが指定されると、この関数はすべての空白エントリを取り除きます。
* [`mysql_password`](#mysql_password): 4.xの関数'mysql::password'のラッパーとして、
  3.xの関数'mysql_password'とのギャップを埋めます。
* [`mysql_password`](#mysql_password): mysqlの"PASSWORD()"関数のように、文字列にハッシュをかけます
* [`mysql_strip_hash`](#mysql_strip_hash): 4.xの関数'mysql::strip_hash'のラッパーとして、
  3.xの関数'mysql_strip_hash'とのギャップを埋めます。
* [`mysql_strip_hash`](#mysql_strip_hash): TEMPORARY FUNCTION: EXPIRES 2014-03-10 ハッシュが指定されると、この関数はすべての空白エントリを取り除きます。

**タスク**

* [`export`](#export): ローカルファイルにデータベースのバックアップを作成できます。
* [`sql`](#sql): 任意のSQLを実行できます

## クラス

### mysql::bindings

MySQLバインディングの親クラス。

#### 例

##### Ruby言語バインディングをインストールします

```puppet
class { 'mysql::bindings':
  ruby_enable           => true,
  ruby_package_ensure   => 'present',
  ruby_package_name     => 'ruby-mysql-2.7.1-1mdv2007.0.sparc.rpm',
  ruby_package_provider => 'rpm',
}
```

#### パラメータ

`mysql::bindings`クラスでは、以下のパラメータを使用できます。

##### `install_options`

データ型: `Any`

管理対象のパッケージリソースに`install_options`を渡します。パッケージマネージャに対応する[正しいオプション](https://docs.puppetlabs.com/references/latest/type.html#package-attribute-install_options)を渡す必要があります。

デフォルト値: `undef`

##### `java_enable`

データ型: `Any`

`::mysql::bindings::java`を含めるかどうかを指定します。有効な値: `true`、`false`。

デフォルト値: `false`

##### `perl_enable`

データ型: `Any`

`mysql::bindings::perl`を含めるかどうかを指定します。有効な値: `true`、false`。

デフォルト値: `false`

##### `php_enable`

データ型: `Any`

`mysql::bindings::php`を含めるかどうかを指定します。有効な値: `true`、`false`。

デフォルト値: `false`

##### `python_enable`

データ型: `Any`

`mysql::bindings::python`を含めるかどうかを指定します。有効な値: `true`、`false`。

デフォルト値: `false`

##### `ruby_enable`

データ型: `Any`

`mysql::bindings::ruby`を含めるかどうかを指定します。有効な値: `true`、`false`。

デフォルト値: `false`

##### `client_dev`

データ型: `Any`

`::mysql::bindings::client_dev`を含めるかどうかを指定します。有効な値: `true`、`false`。

デフォルト値: `false`

##### `daemon_dev`

データ型: `Any`

`::mysql::bindings::daemon_dev`を含めるかどうかを指定します。有効な値: `true`、`false`。

デフォルト値: `false`

##### `java_package_ensure`

データ型: `Any`

パッケージが存在するかしないか、または特定のバージョンでなければならないかどうかを指定します。有効な値: 'present'、'absent'、'x.y.z'。適用されるのは`java_enable => true`の場合だけです。

デフォルト値: $mysql::params::java_package_ensure

##### `java_package_name`

データ型: `Any`

インストールするJavaパッケージの名前。適用されるのは`java_enable => true`の場合だけです。

デフォルト値: $mysql::params::java_package_name

##### `java_package_provider`

データ型: `Any`

Javaパッケージのインストールに使用するプロバイダ。適用されるのは`java_enable => true`の場合だけです。

デフォルト値: $mysql::params::java_package_provider

##### `perl_package_ensure`

データ型: `Any`

パッケージが存在するかしないか、または特定のバージョンでなければならないかどうかを指定します。有効な値: 'present'、'absent'、'x.y.z'。適用されるのは`perl_enable => true`の場合だけです。

デフォルト値: $mysql::params::perl_package_ensure

##### `perl_package_name`

データ型: `Any`

インストールするPerlパッケージの名前。適用されるのは`perl_enable => true`の場合だけです。

デフォルト値: $mysql::params::perl_package_name

##### `perl_package_provider`

データ型: `Any`

Perlパッケージのインストールに使用するプロバイダ。適用されるのは`perl_enable => true`の場合だけです。

デフォルト値: $mysql::params::perl_package_provider

##### `php_package_ensure`

データ型: `Any`

パッケージが存在するかしないか、または特定のバージョンでなければならないかどうかを指定します。有効な値: 'present'、'absent'、'x.y.z'。適用されるのは`php_enable => true`の場合だけです。

デフォルト値: $mysql::params::php_package_ensure

##### `php_package_name`

データ型: `Any`

インストールするPHPパッケージの名前。適用されるのは`php_enable => true`の場合だけです。

デフォルト値: $mysql::params::php_package_name

##### `php_package_provider`

データ型: `Any`

PHPパッケージのインストールに使用するプロバイダ。適用されるのは`php_enable => true`の場合だけです。

デフォルト値: $mysql::params::php_package_provider

##### `python_package_ensure`

データ型: `Any`

パッケージが存在するかしないか、または特定のバージョンでなければならないかどうかを指定します。有効な値: 'present'、'absent'、'x.y.z'。適用されるのは`python_enable => true`の場合だけです。

デフォルト値: $mysql::params::python_package_ensure

##### `python_package_name`

データ型: `Any`

インストールするPythonパッケージの名前。適用されるのは`python_enable => true`の場合だけです。

デフォルト値: $mysql::params::python_package_name

##### `python_package_provider`

データ型: `Any`

Pythonパッケージのインストールに使用するプロバイダ。適用されるのは`python_enable => true`の場合だけです。

デフォルト値: $mysql::params::python_package_provider

##### `ruby_package_ensure`

データ型: `Any`

パッケージが存在するかしないか、または特定のバージョンでなければならないかどうかを指定します。有効な値: 'present'、'absent'、'x.y.z'。適用されるのは`ruby_enable => true`の場合だけです。

デフォルト値: $mysql::params::ruby_package_ensure

##### `ruby_package_name`

データ型: `Any`

インストールするRubyパッケージの名前。適用されるのは`ruby_enable => true`の場合だけです。

デフォルト値: $mysql::params::ruby_package_name

##### `ruby_package_provider`

データ型: `Any`

Rubyパッケージのインストールに使用するプロバイダ。

デフォルト値: $mysql::params::ruby_package_provider

##### `client_dev_package_ensure`

データ型: `Any`

パッケージが存在するかしないか、または特定のバージョンでなければならないかどうかを指定します。有効な値: 'present'、'absent'、'x.y.z'。適用されるのは`client_dev => true`の場合だけです。

デフォルト値: $mysql::params::client_dev_package_ensure

##### `client_dev_package_name`

データ型: `Any`

インストールするclient_devパッケージの名前。適用されるのは`client_dev => true`の場合だけです。

デフォルト値: $mysql::params::client_dev_package_name

##### `client_dev_package_provider`

データ型: `Any`

client_devパッケージのインストールに使用するプロバイダ。適用されるのは`client_dev => true`の場合だけです。

デフォルト値: $mysql::params::client_dev_package_provider

##### `daemon_dev_package_ensure`

データ型: `Any`

パッケージが存在するかしないか、または特定のバージョンでなければならないかどうかを指定します。有効な値: 'present'、'absent'、'x.y.z'。適用されるのは`daemon_dev => true`の場合だけです。

デフォルト値: $mysql::params::daemon_dev_package_ensure

##### `daemon_dev_package_name`

データ型: `Any`

インストールするdaemon_devパッケージの名前。適用されるのは`daemon_dev => true`の場合だけです。

デフォルト値: $mysql::params::daemon_dev_package_name

##### `daemon_dev_package_provider`

データ型: `Any`

daemon_devパッケージのインストールに使用するプロバイダ。適用されるのは`daemon_dev => true`の場合だけです。

デフォルト値: $mysql::params::daemon_dev_package_provider

### mysql::client

MySQLクライアントをインストールして設定します。

#### 例

##### MySQLクライアントをインストールします

```puppet
class {'::mysql::client':
  package_name    => 'mysql-client',
  package_ensure  => 'present',
  bindings_enable => true,
}
```

#### パラメータ

`mysql::client`クラスでは、以下のパラメータを使用できます。

##### `bindings_enable`

データ型: `Any`

すべてのバインディングを自動的にインストールするかどうかを指定します。有効な値: `true`、`false`。デフォルト値: `false`。

デフォルト値: $mysql::params::bindings_enable

##### `install_options`

データ型: `Any`

管理対象のパッケージリソースに関するインストールオプションの配列。パッケージマネージャに対応する正しいオプションを渡す必要があります。

デフォルト値: `undef`

##### `package_ensure`

データ型: `Any`

MySQLパッケージが存在するかしないか、または特定のバージョンでなければならないかどうかを指定します。有効な値: 'present'、'absent'、'x.y.z'。

デフォルト値: $mysql::params::client_package_ensure

##### `package_manage`

データ型: `Any`

MySQLクライアントパッケージを管理するかどうかを指定します。デフォルト値: `true`。

デフォルト値: $mysql::params::client_package_manage

##### `package_name`

データ型: `Any`

インストールするMySQLクライアントパッケージの名前。

デフォルト値: $mysql::params::client_package_name

### mysql::server

MySQLサーバーをインストールして設定します。

#### 例

##### MySQLサーバをインストールします

```puppet
class { '::mysql::server':
  package_name            => 'mysql-server',
  package_ensure          => '5.7.1+mysql~trusty',
  root_password           => 'strongpassword',
  remove_default_accounts => true,
}
```

#### パラメータ

`mysql::server`クラスでは、以下のパラメータを使用できます。

##### `config_file`

データ型: `Any`

MySQL設定ファイルの場所を示すパス。

デフォルト値: $mysql::params::config_file

##### `includedir`

データ型: `Any`

カスタム設定オーバーライド用の!includedirの場所を示すパス。

デフォルト値: $mysql::params::includedir

##### `install_options`

データ型: `Any`

管理対象のパッケージリソースに[install_options](https://docs.puppetlabs.com/references/latest/type.html#package-attribute-install_options)配列を渡します。指定されているパッケージマネージャに対応する正しいオプションを渡す必要があります。

デフォルト値: `undef`

##### `install_secret_file`

データ型: `Any`

一時的なルートパスワードを含むシークレットファイルへのパス。

デフォルト値: $mysql::params::install_secret_file

##### `manage_config_file`

データ型: `Any`

MySQLの設定ファイルを管理するかどうかを指定します。有効な値: `true`、`false`。デフォルト値: `true`。

デフォルト値: $mysql::params::manage_config_file

##### `override_options`

データ型: `Any`

MySQLに渡すオーバーライドオプションを指定します。構造はmy.cnfファイルのハッシュと同様です。詳しい使用方法については、上記を参照してください。

デフォルト値: {}

##### `package_ensure`

データ型: `Any`

パッケージが存在するかしないか、または特定のバージョンでなければならないかどうかを指定します。有効な値: 'present'、'absent'、'x.y.z'。デフォルト値: 'present'。

デフォルト値: $mysql::params::server_package_ensure

##### `package_manage`

データ型: `Any`

MySQLサーバパッケージを管理するかどうかを指定します。デフォルト値: `true`。

デフォルト値: $mysql::params::server_package_manage

##### `package_name`

データ型: `Any`

インストールするMySQLサーバパッケージの名前。

デフォルト値: $mysql::params::server_package_name

##### `purge_conf_dir`

データ型: `Any`

`includedir`ディレクトリをパージするかどうかを指定します。有効な値: `true`、`false`。デフォルト値: `false`。

デフォルト値: $mysql::params::purge_conf_dir

##### `remove_default_accounts`

データ型: `Any`

`mysql::server::account_security`を自動的に含めるかどうかを指定します。有効な値: `true`、`false`。デフォルト値: `false`。

デフォルト値: `false`

##### `restart`

データ型: `Any`

何らかの変化があった場合にサービスを再起動するかどうかを指定します。有効な値: `true`、`false`。デフォルト値: `false`。

デフォルト値: $mysql::params::restart

##### `root_group`

データ型: `Any`

ルートに使用するグループの名前。グループ名またはグループIDのいずれかです。詳細については[group](https://docs.puppetlabs.com/references/latest/type.html#file-attribute-group)を参照してください。

デフォルト値: $mysql::params::root_group

##### `mysql_group`

データ型: `Any`

MySQLデーモンユーザのグループの名前、グループ名またはグループIDのいずれかです。詳細については[group](https://docs.puppetlabs.com/references/latest/type.html#file-attribute-group)を参照してください。

デフォルト値: $mysql::params::mysql_group

##### `root_password`

データ型: `Any`

MySQLのルートパスワード。Puppetは、このパラメータを使用して、ルートパスワードの設定や`/root/.my.cnf`の更新を試みます。`create_root_user`または`create_root_my_cnf`がtrueの場合にこのパラメータが必要です。`root_password`が'UNSET'の場合は`create_root_user`と`create_root_my_cnf`はfalseになります(MySQLルートユーザと`/root/.my.cnf`は作成されません)。パスワード変更はサポートされますが、`/root/.my.cnf`に旧パスワードが設定されている必要があります。実際には、Puppetは`/root/my.cnf`に設定されている旧パスワードを使用してMySQLで新しいパスワードを設定してから、`/root/.my.cnf`を新しいパスワードで更新します。

デフォルト値: $mysql::params::root_password

##### `service_enabled`

データ型: `Any`

サービスを有効化するかどうかを指定します。有効な値: `true`、`false`。デフォルト値: `true`。

デフォルト値: $mysql::params::server_service_enabled

##### `service_manage`

データ型: `Any`

サービスを管理するかどうかを指定します。有効な値: `true`、`false`。デフォルト値: `true`。

デフォルト値: $mysql::params::server_service_manage

##### `service_name`

データ型: `Any`

MySQLサーバサービスの名前。デフォルト値はOSにより異なり、'params.pp'に定義されています。

デフォルト値: $mysql::params::server_service_name

##### `service_provider`

データ型: `Any`

サービスの管理に使用するプロバイダ。Ubuntuの場合のデフォルト値は'upstart'、Ubuntu以外の場合のデフォルト値は定義されていません。

デフォルト値: $mysql::params::server_service_provider

##### `create_root_user`

データ型: `Any`

ルートユーザを作成するかどうかを指定します。有効な値: `true`、`false`。デフォルト値: `true`。このパラメータは、Galeraでクラスタをセットアップする場合に役立ちます。ルートユーザの作成が必要なのは一度だけです。このパラメータを、1つのノードに対しtrueに設定し、他のすべてのノードに対してfalseに設定できます。

デフォルト値: $mysql::params::create_root_user

##### `create_root_my_cnf`

データ型: `Any`

`/root/.my.cnf`を作成するかどうかを指定します。有効な値: `true`、`false`。デフォルト値: `true`。`create_root_my_cnf`を使用すると`create_root_user`に左右されずに`/root/.my.cnf`を作成できます。すべてのノードに`/root/.my.cnf`が存在するようにした場合に、Galeraでこの機能を使用してクラスタをセットアップできます。

デフォルト値: $mysql::params::create_root_my_cnf

##### `users`

データ型: `Any`

作成するユーザのハッシュ(オプション)。[mysql_user](#mysql_user)に渡されます。

デフォルト値: {}

##### `grants`

データ型: `Any`

[mysql_grant](#mysql_grant)に渡されるGRANT権限のハッシュ(オプション)。

デフォルト値: {}

##### `databases`

データ型: `Any`

作成されるデータベースのハッシュ(オプション)。[mysql_database](#mysql_database)に渡されます。

デフォルト値: {}

##### `enabled`

データ型: `Any`

_Deprecated_

デフォルト値: `undef`

##### `manage_service`

データ型: `Any`

_Deprecated_

デフォルト値: `undef`

##### `old_root_password`

データ型: `Any`

現在、このパラメータでは何も行わず、下位互換性を確保するためだけに存在します。ルートパスワードの変更についての詳細は、上記の`root_password`パラメータの説明を参照してください。

デフォルト値: `undef`

##### `create_root_login_file`

データ型: `Any`



デフォルト値: $mysql::params::create_root_login_file

##### `login_file`

データ型: `Any`



デフォルト値: $mysql::params::login_file

### mysql::server::backup

MySQLバックアップを作成し、管理します。

#### 例

##### 基本的なMySQLバックアップを作成します:

```puppet
class { 'mysql::server':
  root_password => 'password'
}
class { 'mysql::server::backup':
  backupuser     => 'myuser',
  backuppassword => 'mypassword',
  backupdir      => '/tmp/backups',
}
```

#### パラメータ

`mysql::server::backup`クラスでは、以下のパラメータを使用できます。

##### `backupuser`

データ型: `Any`

バックアップ管理者権限を持つMySQLユーザ。

デフォルト値: `undef`

##### `backuppassword`

データ型: `Any`

`backupuser`のパスワード。

デフォルト値: `undef`

##### `backupdir`

データ型: `Any`

バックアップを保存するディレクトリ。

デフォルト値: `undef`

##### `backupdirmode`

データ型: `Any`

バックアップディレクトリに適用されるパーミッション。このパラメータはfileリソースに直接渡されます。

デフォルト値: '0700'

##### `backupdirowner`

データ型: `Any`

バックアップディレクトリの所有者。このパラメータはfileリソースに直接渡されます。

デフォルト値: 'root'

##### `backupdirgroup`

データ型: `Any`

バックアップディレクトリのグループ所有者。このパラメータはfileリソースに直接渡されます。

デフォルト値: 'root'

##### `backupcompress`

データ型: `Any`

バックアップを圧縮するかどうかを指定します(mysqldumpプロバイダを使用する場合)。

デフォルト値: `true`

##### `backuprotate`

データ型: `Any`

バックアップの回転間隔(24時間形式)。

デフォルト値: 30

##### `ignore_events`

データ型: `Any`

mysql.eventテーブルを無視します。

デフォルト値: `true`

##### `delete_before_dump`

データ型: `Any`

バックアップ前に古い.sqlファイルを削除するかどうかを設定します。trueに設定すると古いファイルがバックアップ前に削除され、falseに設定するとバックアップ後に削除されます。

デフォルト値: `false`

##### `backupdatabases`

データ型: `Any`

バックアップするデータベース(xtrabackupプロバイダを使用する場合)。

デフォルト値: []

##### `file_per_database`

データ型: `Any`

データベースバックアップごとにファイルを1つ作成する、file per databaseモードを使用します。

デフォルト値: `false`

##### `include_routines`

データ型: `Any`

`file_per_database`バックアップを実行する際に、ダンプされたデータベースから保存済みのルーチン(プロシージャと関数)をダンプします。

デフォルト値: `false`

##### `include_triggers`

データ型: `Any`

`file_per_database`バックアップを実行する際に、ダンプされた各テーブルのトリガをダンプします。

デフォルト値: `false`

##### `ensure`

データ型: `Any`



デフォルト値: 'present'

##### `time`

データ型: `Any`

バックアップ時刻を設定する2つの要素の配列。時刻をHH:MM形式で['23', '5'](23:05)または['3', '45'](03:45)に設定できます。

デフォルト値: ['23', '5']

##### `prescript`

データ型: `Any`

バックアップ開始前に実行されるスクリプト。

デフォルト値: `false`

##### `postscript`

データ型: `Any`

バックアップ終了時に実行されるスクリプト。この機能を使用すると、バックアップを中央ストアに同期させることができます。このスクリプトは、直接実行される1つの行であっても、配列を形成する複数の行であっても構いません。あるいは、外部で管理される1つ以上の(実行可能な)ファイルにすることもできます。

デフォルト値: `false`

##### `execpath`

データ型: `Any`

MySQLを標準的でない場所にインストールする場合にカスタムパスを設定できます。デフォルト値：`/usr/bin:/usr/sbin:/bin:/sbin`。

デフォルト値: '/usr/bin:/usr/sbin:/bin:/sbin'

##### `provider`

データ型: `Any`

サーバのバックアップの実行について設定します。有効な値は以下のとおりです。

デフォルト値: 'mysqldump'

##### `maxallowedpacket`

データ型: `Any`

バックアップダンプスクリプト用のSQLステートメントの最大サイズを定義ます。デフォルト値は1MBで、MySQL Serverのデフォルト値と同じです。

デフォルト値: '1M'

##### `optional_args`

データ型: `Any`

バックアップツールに渡すべきオプションの引数の配列を指定します(xtrabackupプロバイダとmysqldumpプロバイダでのみサポート)。

デフォルト値: []

### mysql::server::monitor

モニタするユーザをデータベースに追加するヘルパクラスです

#### パラメータ

`mysql::server::monitor`クラスでは、以下のパラメータを使用できます。

##### `mysql_monitor_username`

データ型: `Any`

MySQLのモニタ用に作成するユーザ名。

デフォルト値: ''

##### `mysql_monitor_password`

データ型: `Any`

MySQLのモニタ用に作成するパスワード。

デフォルト値: ''

##### `mysql_monitor_hostname`

データ型: `Any`

モニタするユーザリクエストへのアクセスが許可されたホスト名。

デフォルト値: ''

### mysql::server::mysqltuner

MySQLTunerパッケージを管理します。

#### パラメータ

`mysql::server::mysqltuner`クラスでは、以下のパラメータを使用できます。

##### `ensure`

データ型: `Any`

リソースが存在することを確認します。有効な値: 'present'、'absent'。デフォルト値: 'present'。

デフォルト値: 'present'

##### `version`

データ型: `Any`

major/MySQLTuner-perl githubリポジトリからインストールするバージョン。有効なタグでなければなりません。デフォルト値: 'v1.3.0'。

デフォルト値: 'v1.3.0'

##### `source`

データ型: `Any`

mysqltunerパッケージのソースパス。

デフォルト値: `undef`

##### `tuner_location`

データ型: `Any`

mysqltunerパッケージの宛先。

デフォルト値: '/usr/local/bin/mysqltuner'

## 定義された型

### mysql::db

MySQLデータベースを作成し、設定します。

#### 例

##### データベースを作成します

```puppet
mysql::db { 'mydb':
  user     => 'myuser',
  password => 'mypass',
  host     => 'localhost',
  grant    => ['SELECT', 'UPDATE'],
}
```

#### パラメータ

`mysql::db`ユーザ定義タイプでは、以下のパラメータを使用できます。

##### `user`

データ型: `Any`

作成するデータベースのユーザ。

##### `password`

データ型: `Any`

作成するデータベースの$userのパスワード。

##### `tls_options`

データ型: `Any`

作成するデータベースの$userのtls_options。

デフォルト値: `undef`

##### `dbname`

データ型: `Any`

作成するデータベースの名前。

デフォルト値: $name

##### `charset`

データ型: `Any`

データベースに使用するキャラクタセット。

デフォルト値: 'utf8'

##### `collate`

データ型: `Any`

データベースの照合順序。

デフォルト値: 'utf8_general_ci'

##### `host`

データ型: `Any`

GRANT権限を付与するuser@hostの一部として使用するホスト。

デフォルト値: 'localhost'

##### `grant`

データ型: `Any`

データベースに対してuser@hostに付与される権限。

デフォルト値: 'ALL'

##### `grant_options`

データ型: `Any`

ホストデータベースに対してuser@hostに付与される権限オプション。

デフォルト値: `undef`

##### `sql`

データタイプ: `Optional[Variant[Array, Hash, String]]`

実行するsqlfileへのパス。文字列として指定された1つのファイル、または文字列の配列のいずれかです。

デフォルト値: `undef`

##### `enforce_sql`

データ型: `Any`

sqlfilesを毎回実行するかどうかを指定します。falseに設定した場合はsqlfilesは1回しか実行されません。

デフォルト値: `false`

##### `ensure`

データタイプ: `Enum['absent', 'present']`

データベースを作成するかどうかを指定します。有効な値: 'present'、'absent'。デフォルト値: 'present'。

デフォルト値: 'present'

##### `import_timeout`

データ型: `Any`

sqlfilesをロードするときのタイムアウト(秒)。デフォルト値: 300。

デフォルト値: 300

##### `import_cat_cmd`

データ型: `Any`

データベースをインポートするためにsqlfileを読み込むコマンド。sqlfilesが圧縮されている場合に役立ちます。例えば.gzファイルの場合に'zcat'を使用することができます。

デフォルト値: 'cat'

##### `mysql_exec_path`

データ型: `Any`



デフォルト値: $mysql::params::exec_path

## リソース型

### mysql_plugin

MySQLプラグインを管理します。

#### 例

##### 

```puppet
mysql_plugin { 'some_plugin':
  soname => 'some_pluginlib.so',
}
```

#### プロパティ

`mysql_plugin`タイプでは、以下のプロパティを使用できます。

##### `ensure`

デフォルト値: present、absent

リソースの基本的なプロパティ。

デフォルト値: present

##### `soname`

有効な値: %r{^\w+\.\w+$}

ライブラリの名前

#### パラメータ

`mysql_plugin`タイプでは、以下のパラメータを使用できます。

##### `name`

namevar

管理するMySQLプラグインの名前。

## 関数

### mysql::password

タイプ: Ruby 4.x API

mysqlの"PASSWORD()"関数のように、文字列にハッシュをかけます

#### `mysql::password(String $password)`

mysql::password関数。

結果: `String`ハッシュ。
平文のパスワードから返されたmysqlパスワードハッシュ。

##### `password`

データタイプ: `String`

平文のパスワード。

### mysql::strip_hash

タイプ: Ruby 4.x API

ハッシュが指定されると、この関数はすべての空白エントリを取り除きます。

#### `mysql::strip_hash(Hash $hash)`

mysql::strip_hash関数。

結果: `Hash`ハッシュ。
与えられたハッシュからすべての空白エントリを削除したもの。

##### `hash`

データ型: `Hash`

空白を取り除くハッシュ

### mysql_password

タイプ: Ruby 4.x API

4.xの関数'mysql::password'のラッパーとして、3.xの関数'mysql_password'とのギャップを埋めます。

#### `mysql_password(String $password)`

mysql_password関数。

結果: `String`。4.xの関数mysql::passwordから返されたmysqlパスワードハッシュ。

##### `password`

データタイプ: `String`

平文のパスワード。

### mysql_password

タイプ: Ruby 3.x API

mysqlの"PASSWORD()"関数のように、文字列にハッシュをかけます

#### `mysql_password(String $password)`

mysql_password関数。

結果: `String` 平文のパスワードから返されたmysqlパスワードハッシュ。

##### `password`

データタイプ: `String`

平文のパスワード。

### mysql_strip_hash

タイプ: Ruby 4.x API

4.xの関数'mysql::strip_hash'のラッパーとして、3.xの関数'mysql_strip_hash'とのギャップを埋めます。

#### `mysql_strip_hash(Hash $hash)`

mysql_strip_hash関数。

結果: `Hash`ハッシュ。
与えられたハッシュからすべての空白エントリを削除したもの。

##### `hash`

データ型: `Hash`

空白を取り除くハッシュ。

### mysql_strip_hash

タイプ: Ruby 3.x API

TEMPORARY FUNCTION: EXPIRES 2014-03-10
ハッシュが指定されると、この関数はすべての空白エントリを取り除きます。

#### `mysql_strip_hash()`

TEMPORARY FUNCTION: EXPIRES 2014-03-10
ハッシュが指定されると、この関数はすべての空白エントリを取り除きます。

結果: `Any`

## タスク

### export

ローカルファイルにデータベースのバックアップを作成できます。

**Supports noop?** false

#### パラメータ

##### `database`

データタイプ: `Optional[String[1]]`

接続先のデータベース

##### `user`

データタイプ: `Optional[String[1]]`

ユーザ

##### `password`

データタイプ: `Optional[String[1]]`

パスワード

##### `file`

データタイプ: `String[1]`

バックアップ先のファイルのパス

### sql

任意のSQLを実行できます

**Supports noop?** false

#### パラメータ

##### `database`

データタイプ: `Optional[String[1]]`

接続先のデータベース

##### `user`

データタイプ: `Optional[String[1]]`

ユーザ

##### `password`

データタイプ: `Optional[String[1]]`

パスワード

##### `sql`

データタイプ: `String[1]`

実行するSQL

