Using TLS: secure WebSocket
===========================

Example that shows how to do secure WebSocket (wss), on server and client for AutobahnPython,
and with a browser client.

Running
-------

Run the server by doing

    python server.py

and open

    http://localhost:8080/

in your browser.

Click to install the server certificate and start the echo client example.

To activate debug output on the server, start it

    python server.py debug

This will show up all WAMP messages exchanged between clients and server.

To run the Python client, do

    python client.py


Creating TLS Server Keys and Certificates
-----------------------------------------

TLS server keys and certificate can be generated by doing:

	openssl genrsa -out server.key 2048
	openssl req -new -key server.key -out server.csr
	openssl x509 -req -days 3650 -in server.csr -signkey server.key -out server.crt
	openssl x509 -in server.crt -out server.pem

To run the server 2 files are required.

Private key (with *no* passphrase set!):

	server.key

Certificate:

	server.crt

