# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class AddressResponse(msrest.serialization.Model):
    """Describes main public IP address and any extra virtual IPs.

    :param service_ip_address: Main public virtual IP.
    :type service_ip_address: str
    :param internal_ip_address: Virtual Network internal IP address of the App Service Environment
     if it is in internal load-balancing mode.
    :type internal_ip_address: str
    :param outbound_ip_addresses: IP addresses appearing on outbound connections.
    :type outbound_ip_addresses: list[str]
    :param vip_mappings: Additional virtual IPs.
    :type vip_mappings: list[~azure.mgmt.web.v2016_09_01.models.VirtualIPMapping]
    """

    _attribute_map = {
        'service_ip_address': {'key': 'serviceIpAddress', 'type': 'str'},
        'internal_ip_address': {'key': 'internalIpAddress', 'type': 'str'},
        'outbound_ip_addresses': {'key': 'outboundIpAddresses', 'type': '[str]'},
        'vip_mappings': {'key': 'vipMappings', 'type': '[VirtualIPMapping]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddressResponse, self).__init__(**kwargs)
        self.service_ip_address = kwargs.get('service_ip_address', None)
        self.internal_ip_address = kwargs.get('internal_ip_address', None)
        self.outbound_ip_addresses = kwargs.get('outbound_ip_addresses', None)
        self.vip_mappings = kwargs.get('vip_mappings', None)


class ApiDefinitionInfo(msrest.serialization.Model):
    """Information about the formal API definition for the app.

    :param url: The URL of the API definition.
    :type url: str
    """

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiDefinitionInfo, self).__init__(**kwargs)
        self.url = kwargs.get('url', None)


class AppServiceEnvironmentCollection(msrest.serialization.Model):
    """Collection of App Service Environments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_09_01.models.AppServiceEnvironmentResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServiceEnvironmentResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServiceEnvironmentCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ProxyOnlyResource(msrest.serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kwargs.get('kind', None)
        self.type = None


class AppServiceEnvironmentPatchResource(ProxyOnlyResource):
    """ARM resource for a app service environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param name_properties_name: Name of the App Service Environment.
    :type name_properties_name: str
    :param location: Location of the App Service Environment, e.g. "West US".
    :type location: str
    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2016_09_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Possible values include:
     "Preparing", "Ready", "Scaling", "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2016_09_01.models.HostingEnvironmentStatus
    :param vnet_name: Name of the Virtual Network for the App Service Environment.
    :type vnet_name: str
    :param vnet_resource_group_name: Resource group of the Virtual Network.
    :type vnet_resource_group_name: str
    :param vnet_subnet_name: Subnet of the Virtual Network.
    :type vnet_subnet_name: str
    :param virtual_network: Description of the Virtual Network.
    :type virtual_network: ~azure.mgmt.web.v2016_09_01.models.VirtualNetworkProfile
    :param internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Possible values include: "None", "Web",
     "Publishing".
    :type internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2016_09_01.models.InternalLoadBalancingMode
    :param multi_size: Front-end VM size, e.g. "Medium", "Large".
    :type multi_size: str
    :param multi_role_count: Number of front-end instances.
    :type multi_role_count: int
    :param worker_pools: Description of worker pools with worker size IDs, VM sizes, and number of
     workers in each pool.
    :type worker_pools: list[~azure.mgmt.web.v2016_09_01.models.WorkerPool]
    :param ipssl_address_count: Number of IP SSL addresses reserved for the App Service
     Environment.
    :type ipssl_address_count: int
    :ivar database_edition: Edition of the metadata database for the App Service Environment, e.g.
     "Standard".
    :vartype database_edition: str
    :ivar database_service_objective: Service objective of the metadata database for the App
     Service Environment, e.g. "S0".
    :vartype database_service_objective: str
    :ivar upgrade_domains: Number of upgrade domains of the App Service Environment.
    :vartype upgrade_domains: int
    :ivar subscription_id: Subscription of the App Service Environment.
    :vartype subscription_id: str
    :param dns_suffix: DNS suffix of the App Service Environment.
    :type dns_suffix: str
    :ivar last_action: Last deployment action on the App Service Environment.
    :vartype last_action: str
    :ivar last_action_result: Result of the last deployment action on the App Service Environment.
    :vartype last_action_result: str
    :ivar allowed_multi_sizes: List of comma separated strings describing which VM sizes are
     allowed for front-ends.
    :vartype allowed_multi_sizes: str
    :ivar allowed_worker_sizes: List of comma separated strings describing which VM sizes are
     allowed for workers.
    :vartype allowed_worker_sizes: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar vip_mappings: Description of IP SSL mapping for the App Service Environment.
    :vartype vip_mappings: list[~azure.mgmt.web.v2016_09_01.models.VirtualIPMapping]
    :ivar environment_capacities: Current total, used, and available worker capacities.
    :vartype environment_capacities: list[~azure.mgmt.web.v2016_09_01.models.StampCapacity]
    :param network_access_control_list: Access control list for controlling traffic to the App
     Service Environment.
    :type network_access_control_list:
     list[~azure.mgmt.web.v2016_09_01.models.NetworkAccessControlEntry]
    :ivar environment_is_healthy: True/false indicating whether the App Service Environment is
     healthy.
    :vartype environment_is_healthy: bool
    :ivar environment_status: Detailed message about with results of the last check of the App
     Service Environment.
    :vartype environment_status: str
    :ivar resource_group: Resource group of the App Service Environment.
    :vartype resource_group: str
    :param front_end_scale_factor: Scale factor for front-ends.
    :type front_end_scale_factor: int
    :ivar default_front_end_scale_factor: Default Scale Factor for FrontEnds.
    :vartype default_front_end_scale_factor: int
    :param api_management_account_id: API Management Account associated with the App Service
     Environment.
    :type api_management_account_id: str
    :param suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :type suspended: bool
    :param dynamic_cache_enabled: True/false indicating whether the App Service Environment is
     suspended. The environment can be suspended e.g. when the management endpoint is no longer
     available
     (most likely because NSG blocked the incoming traffic).
    :type dynamic_cache_enabled: bool
    :param cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :type cluster_settings: list[~azure.mgmt.web.v2016_09_01.models.NameValuePair]
    :param user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :type user_whitelisted_ip_ranges: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'database_edition': {'readonly': True},
        'database_service_objective': {'readonly': True},
        'upgrade_domains': {'readonly': True},
        'subscription_id': {'readonly': True},
        'last_action': {'readonly': True},
        'last_action_result': {'readonly': True},
        'allowed_multi_sizes': {'readonly': True},
        'allowed_worker_sizes': {'readonly': True},
        'maximum_number_of_machines': {'readonly': True},
        'vip_mappings': {'readonly': True},
        'environment_capacities': {'readonly': True},
        'environment_is_healthy': {'readonly': True},
        'environment_status': {'readonly': True},
        'resource_group': {'readonly': True},
        'default_front_end_scale_factor': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'location': {'key': 'properties.location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vnet_resource_group_name': {'key': 'properties.vnetResourceGroupName', 'type': 'str'},
        'vnet_subnet_name': {'key': 'properties.vnetSubnetName', 'type': 'str'},
        'virtual_network': {'key': 'properties.virtualNetwork', 'type': 'VirtualNetworkProfile'},
        'internal_load_balancing_mode': {'key': 'properties.internalLoadBalancingMode', 'type': 'str'},
        'multi_size': {'key': 'properties.multiSize', 'type': 'str'},
        'multi_role_count': {'key': 'properties.multiRoleCount', 'type': 'int'},
        'worker_pools': {'key': 'properties.workerPools', 'type': '[WorkerPool]'},
        'ipssl_address_count': {'key': 'properties.ipsslAddressCount', 'type': 'int'},
        'database_edition': {'key': 'properties.databaseEdition', 'type': 'str'},
        'database_service_objective': {'key': 'properties.databaseServiceObjective', 'type': 'str'},
        'upgrade_domains': {'key': 'properties.upgradeDomains', 'type': 'int'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
        'dns_suffix': {'key': 'properties.dnsSuffix', 'type': 'str'},
        'last_action': {'key': 'properties.lastAction', 'type': 'str'},
        'last_action_result': {'key': 'properties.lastActionResult', 'type': 'str'},
        'allowed_multi_sizes': {'key': 'properties.allowedMultiSizes', 'type': 'str'},
        'allowed_worker_sizes': {'key': 'properties.allowedWorkerSizes', 'type': 'str'},
        'maximum_number_of_machines': {'key': 'properties.maximumNumberOfMachines', 'type': 'int'},
        'vip_mappings': {'key': 'properties.vipMappings', 'type': '[VirtualIPMapping]'},
        'environment_capacities': {'key': 'properties.environmentCapacities', 'type': '[StampCapacity]'},
        'network_access_control_list': {'key': 'properties.networkAccessControlList', 'type': '[NetworkAccessControlEntry]'},
        'environment_is_healthy': {'key': 'properties.environmentIsHealthy', 'type': 'bool'},
        'environment_status': {'key': 'properties.environmentStatus', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'front_end_scale_factor': {'key': 'properties.frontEndScaleFactor', 'type': 'int'},
        'default_front_end_scale_factor': {'key': 'properties.defaultFrontEndScaleFactor', 'type': 'int'},
        'api_management_account_id': {'key': 'properties.apiManagementAccountId', 'type': 'str'},
        'suspended': {'key': 'properties.suspended', 'type': 'bool'},
        'dynamic_cache_enabled': {'key': 'properties.dynamicCacheEnabled', 'type': 'bool'},
        'cluster_settings': {'key': 'properties.clusterSettings', 'type': '[NameValuePair]'},
        'user_whitelisted_ip_ranges': {'key': 'properties.userWhitelistedIpRanges', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServiceEnvironmentPatchResource, self).__init__(**kwargs)
        self.name_properties_name = kwargs.get('name_properties_name', None)
        self.location = kwargs.get('location', None)
        self.provisioning_state = None
        self.status = None
        self.vnet_name = kwargs.get('vnet_name', None)
        self.vnet_resource_group_name = kwargs.get('vnet_resource_group_name', None)
        self.vnet_subnet_name = kwargs.get('vnet_subnet_name', None)
        self.virtual_network = kwargs.get('virtual_network', None)
        self.internal_load_balancing_mode = kwargs.get('internal_load_balancing_mode', None)
        self.multi_size = kwargs.get('multi_size', None)
        self.multi_role_count = kwargs.get('multi_role_count', None)
        self.worker_pools = kwargs.get('worker_pools', None)
        self.ipssl_address_count = kwargs.get('ipssl_address_count', None)
        self.database_edition = None
        self.database_service_objective = None
        self.upgrade_domains = None
        self.subscription_id = None
        self.dns_suffix = kwargs.get('dns_suffix', None)
        self.last_action = None
        self.last_action_result = None
        self.allowed_multi_sizes = None
        self.allowed_worker_sizes = None
        self.maximum_number_of_machines = None
        self.vip_mappings = None
        self.environment_capacities = None
        self.network_access_control_list = kwargs.get('network_access_control_list', None)
        self.environment_is_healthy = None
        self.environment_status = None
        self.resource_group = None
        self.front_end_scale_factor = kwargs.get('front_end_scale_factor', None)
        self.default_front_end_scale_factor = None
        self.api_management_account_id = kwargs.get('api_management_account_id', None)
        self.suspended = kwargs.get('suspended', None)
        self.dynamic_cache_enabled = kwargs.get('dynamic_cache_enabled', None)
        self.cluster_settings = kwargs.get('cluster_settings', None)
        self.user_whitelisted_ip_ranges = kwargs.get('user_whitelisted_ip_ranges', None)


class Resource(msrest.serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kwargs.get('kind', None)
        self.location = kwargs['location']
        self.type = None
        self.tags = kwargs.get('tags', None)


class AppServiceEnvironmentResource(Resource):
    """App Service Environment ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param name_properties_name: Name of the App Service Environment.
    :type name_properties_name: str
    :param location_properties_location: Location of the App Service Environment, e.g. "West US".
    :type location_properties_location: str
    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2016_09_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Possible values include:
     "Preparing", "Ready", "Scaling", "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2016_09_01.models.HostingEnvironmentStatus
    :param vnet_name: Name of the Virtual Network for the App Service Environment.
    :type vnet_name: str
    :param vnet_resource_group_name: Resource group of the Virtual Network.
    :type vnet_resource_group_name: str
    :param vnet_subnet_name: Subnet of the Virtual Network.
    :type vnet_subnet_name: str
    :param virtual_network: Description of the Virtual Network.
    :type virtual_network: ~azure.mgmt.web.v2016_09_01.models.VirtualNetworkProfile
    :param internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Possible values include: "None", "Web",
     "Publishing".
    :type internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2016_09_01.models.InternalLoadBalancingMode
    :param multi_size: Front-end VM size, e.g. "Medium", "Large".
    :type multi_size: str
    :param multi_role_count: Number of front-end instances.
    :type multi_role_count: int
    :param worker_pools: Description of worker pools with worker size IDs, VM sizes, and number of
     workers in each pool.
    :type worker_pools: list[~azure.mgmt.web.v2016_09_01.models.WorkerPool]
    :param ipssl_address_count: Number of IP SSL addresses reserved for the App Service
     Environment.
    :type ipssl_address_count: int
    :ivar database_edition: Edition of the metadata database for the App Service Environment, e.g.
     "Standard".
    :vartype database_edition: str
    :ivar database_service_objective: Service objective of the metadata database for the App
     Service Environment, e.g. "S0".
    :vartype database_service_objective: str
    :ivar upgrade_domains: Number of upgrade domains of the App Service Environment.
    :vartype upgrade_domains: int
    :ivar subscription_id: Subscription of the App Service Environment.
    :vartype subscription_id: str
    :param dns_suffix: DNS suffix of the App Service Environment.
    :type dns_suffix: str
    :ivar last_action: Last deployment action on the App Service Environment.
    :vartype last_action: str
    :ivar last_action_result: Result of the last deployment action on the App Service Environment.
    :vartype last_action_result: str
    :ivar allowed_multi_sizes: List of comma separated strings describing which VM sizes are
     allowed for front-ends.
    :vartype allowed_multi_sizes: str
    :ivar allowed_worker_sizes: List of comma separated strings describing which VM sizes are
     allowed for workers.
    :vartype allowed_worker_sizes: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar vip_mappings: Description of IP SSL mapping for the App Service Environment.
    :vartype vip_mappings: list[~azure.mgmt.web.v2016_09_01.models.VirtualIPMapping]
    :ivar environment_capacities: Current total, used, and available worker capacities.
    :vartype environment_capacities: list[~azure.mgmt.web.v2016_09_01.models.StampCapacity]
    :param network_access_control_list: Access control list for controlling traffic to the App
     Service Environment.
    :type network_access_control_list:
     list[~azure.mgmt.web.v2016_09_01.models.NetworkAccessControlEntry]
    :ivar environment_is_healthy: True/false indicating whether the App Service Environment is
     healthy.
    :vartype environment_is_healthy: bool
    :ivar environment_status: Detailed message about with results of the last check of the App
     Service Environment.
    :vartype environment_status: str
    :ivar resource_group: Resource group of the App Service Environment.
    :vartype resource_group: str
    :param front_end_scale_factor: Scale factor for front-ends.
    :type front_end_scale_factor: int
    :ivar default_front_end_scale_factor: Default Scale Factor for FrontEnds.
    :vartype default_front_end_scale_factor: int
    :param api_management_account_id: API Management Account associated with the App Service
     Environment.
    :type api_management_account_id: str
    :param suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :type suspended: bool
    :param dynamic_cache_enabled: True/false indicating whether the App Service Environment is
     suspended. The environment can be suspended e.g. when the management endpoint is no longer
     available
     (most likely because NSG blocked the incoming traffic).
    :type dynamic_cache_enabled: bool
    :param cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :type cluster_settings: list[~azure.mgmt.web.v2016_09_01.models.NameValuePair]
    :param user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :type user_whitelisted_ip_ranges: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'database_edition': {'readonly': True},
        'database_service_objective': {'readonly': True},
        'upgrade_domains': {'readonly': True},
        'subscription_id': {'readonly': True},
        'last_action': {'readonly': True},
        'last_action_result': {'readonly': True},
        'allowed_multi_sizes': {'readonly': True},
        'allowed_worker_sizes': {'readonly': True},
        'maximum_number_of_machines': {'readonly': True},
        'vip_mappings': {'readonly': True},
        'environment_capacities': {'readonly': True},
        'environment_is_healthy': {'readonly': True},
        'environment_status': {'readonly': True},
        'resource_group': {'readonly': True},
        'default_front_end_scale_factor': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'location_properties_location': {'key': 'properties.location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vnet_resource_group_name': {'key': 'properties.vnetResourceGroupName', 'type': 'str'},
        'vnet_subnet_name': {'key': 'properties.vnetSubnetName', 'type': 'str'},
        'virtual_network': {'key': 'properties.virtualNetwork', 'type': 'VirtualNetworkProfile'},
        'internal_load_balancing_mode': {'key': 'properties.internalLoadBalancingMode', 'type': 'str'},
        'multi_size': {'key': 'properties.multiSize', 'type': 'str'},
        'multi_role_count': {'key': 'properties.multiRoleCount', 'type': 'int'},
        'worker_pools': {'key': 'properties.workerPools', 'type': '[WorkerPool]'},
        'ipssl_address_count': {'key': 'properties.ipsslAddressCount', 'type': 'int'},
        'database_edition': {'key': 'properties.databaseEdition', 'type': 'str'},
        'database_service_objective': {'key': 'properties.databaseServiceObjective', 'type': 'str'},
        'upgrade_domains': {'key': 'properties.upgradeDomains', 'type': 'int'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
        'dns_suffix': {'key': 'properties.dnsSuffix', 'type': 'str'},
        'last_action': {'key': 'properties.lastAction', 'type': 'str'},
        'last_action_result': {'key': 'properties.lastActionResult', 'type': 'str'},
        'allowed_multi_sizes': {'key': 'properties.allowedMultiSizes', 'type': 'str'},
        'allowed_worker_sizes': {'key': 'properties.allowedWorkerSizes', 'type': 'str'},
        'maximum_number_of_machines': {'key': 'properties.maximumNumberOfMachines', 'type': 'int'},
        'vip_mappings': {'key': 'properties.vipMappings', 'type': '[VirtualIPMapping]'},
        'environment_capacities': {'key': 'properties.environmentCapacities', 'type': '[StampCapacity]'},
        'network_access_control_list': {'key': 'properties.networkAccessControlList', 'type': '[NetworkAccessControlEntry]'},
        'environment_is_healthy': {'key': 'properties.environmentIsHealthy', 'type': 'bool'},
        'environment_status': {'key': 'properties.environmentStatus', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'front_end_scale_factor': {'key': 'properties.frontEndScaleFactor', 'type': 'int'},
        'default_front_end_scale_factor': {'key': 'properties.defaultFrontEndScaleFactor', 'type': 'int'},
        'api_management_account_id': {'key': 'properties.apiManagementAccountId', 'type': 'str'},
        'suspended': {'key': 'properties.suspended', 'type': 'bool'},
        'dynamic_cache_enabled': {'key': 'properties.dynamicCacheEnabled', 'type': 'bool'},
        'cluster_settings': {'key': 'properties.clusterSettings', 'type': '[NameValuePair]'},
        'user_whitelisted_ip_ranges': {'key': 'properties.userWhitelistedIpRanges', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServiceEnvironmentResource, self).__init__(**kwargs)
        self.name_properties_name = kwargs.get('name_properties_name', None)
        self.location_properties_location = kwargs.get('location_properties_location', None)
        self.provisioning_state = None
        self.status = None
        self.vnet_name = kwargs.get('vnet_name', None)
        self.vnet_resource_group_name = kwargs.get('vnet_resource_group_name', None)
        self.vnet_subnet_name = kwargs.get('vnet_subnet_name', None)
        self.virtual_network = kwargs.get('virtual_network', None)
        self.internal_load_balancing_mode = kwargs.get('internal_load_balancing_mode', None)
        self.multi_size = kwargs.get('multi_size', None)
        self.multi_role_count = kwargs.get('multi_role_count', None)
        self.worker_pools = kwargs.get('worker_pools', None)
        self.ipssl_address_count = kwargs.get('ipssl_address_count', None)
        self.database_edition = None
        self.database_service_objective = None
        self.upgrade_domains = None
        self.subscription_id = None
        self.dns_suffix = kwargs.get('dns_suffix', None)
        self.last_action = None
        self.last_action_result = None
        self.allowed_multi_sizes = None
        self.allowed_worker_sizes = None
        self.maximum_number_of_machines = None
        self.vip_mappings = None
        self.environment_capacities = None
        self.network_access_control_list = kwargs.get('network_access_control_list', None)
        self.environment_is_healthy = None
        self.environment_status = None
        self.resource_group = None
        self.front_end_scale_factor = kwargs.get('front_end_scale_factor', None)
        self.default_front_end_scale_factor = None
        self.api_management_account_id = kwargs.get('api_management_account_id', None)
        self.suspended = kwargs.get('suspended', None)
        self.dynamic_cache_enabled = kwargs.get('dynamic_cache_enabled', None)
        self.cluster_settings = kwargs.get('cluster_settings', None)
        self.user_whitelisted_ip_ranges = kwargs.get('user_whitelisted_ip_ranges', None)


class AppServicePlan(Resource):
    """App Service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Description of a SKU for a scalable resource.
    :type sku: ~azure.mgmt.web.v2016_09_01.models.SkuDescription
    :param name_properties_name: Name for the App Service plan.
    :type name_properties_name: str
    :param worker_tier_name: Target worker tier assigned to the App Service plan.
    :type worker_tier_name: str
    :ivar status: App Service plan status. Possible values include: "Ready", "Pending", "Creating".
    :vartype status: str or ~azure.mgmt.web.v2016_09_01.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :param admin_site_name: App Service plan administration site.
    :type admin_site_name: str
    :param hosting_environment_profile: Specification for the App Service Environment to use for
     the App Service plan.
    :type hosting_environment_profile: ~azure.mgmt.web.v2016_09_01.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :param per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :type per_site_scaling: bool
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :param is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :type is_spot: bool
    :param spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :type spot_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :param reserved: If Linux app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :type reserved: bool
    :param target_worker_count: Scaling worker count.
    :type target_worker_count: int
    :param target_worker_size_id: Scaling worker size ID.
    :type target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2016_09_01.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'subscription': {'readonly': True},
        'maximum_number_of_workers': {'readonly': True},
        'geo_region': {'readonly': True},
        'number_of_sites': {'readonly': True},
        'resource_group': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'worker_tier_name': {'key': 'properties.workerTierName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'admin_site_name': {'key': 'properties.adminSiteName', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'maximum_number_of_workers': {'key': 'properties.maximumNumberOfWorkers', 'type': 'int'},
        'geo_region': {'key': 'properties.geoRegion', 'type': 'str'},
        'per_site_scaling': {'key': 'properties.perSiteScaling', 'type': 'bool'},
        'number_of_sites': {'key': 'properties.numberOfSites', 'type': 'int'},
        'is_spot': {'key': 'properties.isSpot', 'type': 'bool'},
        'spot_expiration_time': {'key': 'properties.spotExpirationTime', 'type': 'iso-8601'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'target_worker_count': {'key': 'properties.targetWorkerCount', 'type': 'int'},
        'target_worker_size_id': {'key': 'properties.targetWorkerSizeId', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServicePlan, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.name_properties_name = kwargs.get('name_properties_name', None)
        self.worker_tier_name = kwargs.get('worker_tier_name', None)
        self.status = None
        self.subscription = None
        self.admin_site_name = kwargs.get('admin_site_name', None)
        self.hosting_environment_profile = kwargs.get('hosting_environment_profile', None)
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = kwargs.get('per_site_scaling', False)
        self.number_of_sites = None
        self.is_spot = kwargs.get('is_spot', None)
        self.spot_expiration_time = kwargs.get('spot_expiration_time', None)
        self.resource_group = None
        self.reserved = kwargs.get('reserved', False)
        self.target_worker_count = kwargs.get('target_worker_count', None)
        self.target_worker_size_id = kwargs.get('target_worker_size_id', None)
        self.provisioning_state = None


class AppServicePlanCollection(msrest.serialization.Model):
    """Collection of App Service plans.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_09_01.models.AppServicePlan]
    :param next_link: Link to next page of resources.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServicePlan]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServicePlanCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class AppServicePlanPatchResource(ProxyOnlyResource):
    """ARM resource for a app service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param name_properties_name: Name for the App Service plan.
    :type name_properties_name: str
    :param worker_tier_name: Target worker tier assigned to the App Service plan.
    :type worker_tier_name: str
    :ivar status: App Service plan status. Possible values include: "Ready", "Pending", "Creating".
    :vartype status: str or ~azure.mgmt.web.v2016_09_01.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :param admin_site_name: App Service plan administration site.
    :type admin_site_name: str
    :param hosting_environment_profile: Specification for the App Service Environment to use for
     the App Service plan.
    :type hosting_environment_profile: ~azure.mgmt.web.v2016_09_01.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :param per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :type per_site_scaling: bool
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :param is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :type is_spot: bool
    :param spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :type spot_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :param reserved: If Linux app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :type reserved: bool
    :param target_worker_count: Scaling worker count.
    :type target_worker_count: int
    :param target_worker_size_id: Scaling worker size ID.
    :type target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2016_09_01.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'subscription': {'readonly': True},
        'maximum_number_of_workers': {'readonly': True},
        'geo_region': {'readonly': True},
        'number_of_sites': {'readonly': True},
        'resource_group': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'worker_tier_name': {'key': 'properties.workerTierName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'admin_site_name': {'key': 'properties.adminSiteName', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'maximum_number_of_workers': {'key': 'properties.maximumNumberOfWorkers', 'type': 'int'},
        'geo_region': {'key': 'properties.geoRegion', 'type': 'str'},
        'per_site_scaling': {'key': 'properties.perSiteScaling', 'type': 'bool'},
        'number_of_sites': {'key': 'properties.numberOfSites', 'type': 'int'},
        'is_spot': {'key': 'properties.isSpot', 'type': 'bool'},
        'spot_expiration_time': {'key': 'properties.spotExpirationTime', 'type': 'iso-8601'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'target_worker_count': {'key': 'properties.targetWorkerCount', 'type': 'int'},
        'target_worker_size_id': {'key': 'properties.targetWorkerSizeId', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServicePlanPatchResource, self).__init__(**kwargs)
        self.name_properties_name = kwargs.get('name_properties_name', None)
        self.worker_tier_name = kwargs.get('worker_tier_name', None)
        self.status = None
        self.subscription = None
        self.admin_site_name = kwargs.get('admin_site_name', None)
        self.hosting_environment_profile = kwargs.get('hosting_environment_profile', None)
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = kwargs.get('per_site_scaling', False)
        self.number_of_sites = None
        self.is_spot = kwargs.get('is_spot', None)
        self.spot_expiration_time = kwargs.get('spot_expiration_time', None)
        self.resource_group = None
        self.reserved = kwargs.get('reserved', False)
        self.target_worker_count = kwargs.get('target_worker_count', None)
        self.target_worker_size_id = kwargs.get('target_worker_size_id', None)
        self.provisioning_state = None


class AutoHealActions(msrest.serialization.Model):
    """Actions which to take by the auto-heal module when a rule is triggered.

    :param action_type: Predefined action to be taken. Possible values include: "Recycle",
     "LogEvent", "CustomAction".
    :type action_type: str or ~azure.mgmt.web.v2016_09_01.models.AutoHealActionType
    :param custom_action: Custom action to be taken.
    :type custom_action: ~azure.mgmt.web.v2016_09_01.models.AutoHealCustomAction
    :param min_process_execution_time: Minimum time the process must execute
     before taking the action.
    :type min_process_execution_time: str
    """

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
        'custom_action': {'key': 'customAction', 'type': 'AutoHealCustomAction'},
        'min_process_execution_time': {'key': 'minProcessExecutionTime', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoHealActions, self).__init__(**kwargs)
        self.action_type = kwargs.get('action_type', None)
        self.custom_action = kwargs.get('custom_action', None)
        self.min_process_execution_time = kwargs.get('min_process_execution_time', None)


class AutoHealCustomAction(msrest.serialization.Model):
    """Custom action to be executed
when an auto heal rule is triggered.

    :param exe: Executable to be run.
    :type exe: str
    :param parameters: Parameters for the executable.
    :type parameters: str
    """

    _attribute_map = {
        'exe': {'key': 'exe', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoHealCustomAction, self).__init__(**kwargs)
        self.exe = kwargs.get('exe', None)
        self.parameters = kwargs.get('parameters', None)


class AutoHealRules(msrest.serialization.Model):
    """Rules that can be defined for auto-heal.

    :param triggers: Conditions that describe when to execute the auto-heal actions.
    :type triggers: ~azure.mgmt.web.v2016_09_01.models.AutoHealTriggers
    :param actions: Actions to be executed when a rule is triggered.
    :type actions: ~azure.mgmt.web.v2016_09_01.models.AutoHealActions
    """

    _attribute_map = {
        'triggers': {'key': 'triggers', 'type': 'AutoHealTriggers'},
        'actions': {'key': 'actions', 'type': 'AutoHealActions'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoHealRules, self).__init__(**kwargs)
        self.triggers = kwargs.get('triggers', None)
        self.actions = kwargs.get('actions', None)


class AutoHealTriggers(msrest.serialization.Model):
    """Triggers for auto-heal.

    :param requests: A rule based on total requests.
    :type requests: ~azure.mgmt.web.v2016_09_01.models.RequestsBasedTrigger
    :param private_bytes_in_kb: A rule based on private bytes.
    :type private_bytes_in_kb: int
    :param status_codes: A rule based on status codes.
    :type status_codes: list[~azure.mgmt.web.v2016_09_01.models.StatusCodesBasedTrigger]
    :param slow_requests: A rule based on request execution time.
    :type slow_requests: ~azure.mgmt.web.v2016_09_01.models.SlowRequestsBasedTrigger
    """

    _attribute_map = {
        'requests': {'key': 'requests', 'type': 'RequestsBasedTrigger'},
        'private_bytes_in_kb': {'key': 'privateBytesInKB', 'type': 'int'},
        'status_codes': {'key': 'statusCodes', 'type': '[StatusCodesBasedTrigger]'},
        'slow_requests': {'key': 'slowRequests', 'type': 'SlowRequestsBasedTrigger'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoHealTriggers, self).__init__(**kwargs)
        self.requests = kwargs.get('requests', None)
        self.private_bytes_in_kb = kwargs.get('private_bytes_in_kb', None)
        self.status_codes = kwargs.get('status_codes', None)
        self.slow_requests = kwargs.get('slow_requests', None)


class Capability(msrest.serialization.Model):
    """Describes the capabilities/features allowed for a specific SKU.

    :param name: Name of the SKU capability.
    :type name: str
    :param value: Value of the SKU capability.
    :type value: str
    :param reason: Reason of the SKU capability.
    :type reason: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Capability, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)
        self.reason = kwargs.get('reason', None)


class CloningInfo(msrest.serialization.Model):
    """Information needed for cloning operation.

    All required parameters must be populated in order to send to Azure.

    :param correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
     operations
     together to use the same snapshot.
    :type correlation_id: str
    :param overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
     :code:`<code>false</code>`.
    :type overwrite: bool
    :param clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from source
     app; otherwise, :code:`<code>false</code>`.
    :type clone_custom_host_names: bool
    :param clone_source_control: :code:`<code>true</code>` to clone source control from source app;
     otherwise, :code:`<code>false</code>`.
    :type clone_source_control: bool
    :param source_web_app_id: Required. ARM resource ID of the source app. App resource ID is of
     the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :type source_web_app_id: str
    :param hosting_environment: App Service Environment.
    :type hosting_environment: str
    :param app_settings_overrides: Application setting overrides for cloned app. If specified,
     these settings override the settings cloned
     from source app. Otherwise, application settings from source app are retained.
    :type app_settings_overrides: dict[str, str]
    :param configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
     source and destination app.
    :type configure_load_balancing: bool
    :param traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if it
     exists. Traffic Manager resource ID is of the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
    :type traffic_manager_profile_id: str
    :param traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
     needed if Traffic Manager profile does not already exist.
    :type traffic_manager_profile_name: str
    :param ignore_quotas: :code:`<code>true</code>` if quotas should be ignored; otherwise,
     :code:`<code>false</code>`.
    :type ignore_quotas: bool
    """

    _validation = {
        'source_web_app_id': {'required': True},
    }

    _attribute_map = {
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'overwrite': {'key': 'overwrite', 'type': 'bool'},
        'clone_custom_host_names': {'key': 'cloneCustomHostNames', 'type': 'bool'},
        'clone_source_control': {'key': 'cloneSourceControl', 'type': 'bool'},
        'source_web_app_id': {'key': 'sourceWebAppId', 'type': 'str'},
        'hosting_environment': {'key': 'hostingEnvironment', 'type': 'str'},
        'app_settings_overrides': {'key': 'appSettingsOverrides', 'type': '{str}'},
        'configure_load_balancing': {'key': 'configureLoadBalancing', 'type': 'bool'},
        'traffic_manager_profile_id': {'key': 'trafficManagerProfileId', 'type': 'str'},
        'traffic_manager_profile_name': {'key': 'trafficManagerProfileName', 'type': 'str'},
        'ignore_quotas': {'key': 'ignoreQuotas', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloningInfo, self).__init__(**kwargs)
        self.correlation_id = kwargs.get('correlation_id', None)
        self.overwrite = kwargs.get('overwrite', None)
        self.clone_custom_host_names = kwargs.get('clone_custom_host_names', None)
        self.clone_source_control = kwargs.get('clone_source_control', None)
        self.source_web_app_id = kwargs['source_web_app_id']
        self.hosting_environment = kwargs.get('hosting_environment', None)
        self.app_settings_overrides = kwargs.get('app_settings_overrides', None)
        self.configure_load_balancing = kwargs.get('configure_load_balancing', None)
        self.traffic_manager_profile_id = kwargs.get('traffic_manager_profile_id', None)
        self.traffic_manager_profile_name = kwargs.get('traffic_manager_profile_name', None)
        self.ignore_quotas = kwargs.get('ignore_quotas', None)


class ConnStringInfo(msrest.serialization.Model):
    """Database connection string information.

    :param name: Name of connection string.
    :type name: str
    :param connection_string: Connection string value.
    :type connection_string: str
    :param type: Type of database. Possible values include: "MySql", "SQLServer", "SQLAzure",
     "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache",
     "PostgreSQL".
    :type type: str or ~azure.mgmt.web.v2016_09_01.models.ConnectionStringType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnStringInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.connection_string = kwargs.get('connection_string', None)
        self.type = kwargs.get('type', None)


class CorsSettings(msrest.serialization.Model):
    """Cross-Origin Resource Sharing (CORS) settings for the app.

    :param allowed_origins: Gets or sets the list of origins that should be allowed to make
     cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
    :type allowed_origins: list[str]
    """

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CorsSettings, self).__init__(**kwargs)
        self.allowed_origins = kwargs.get('allowed_origins', None)


class CsmUsageQuota(msrest.serialization.Model):
    """Usage of the quota resource.

    :param unit: Units of measurement for the quota resource.
    :type unit: str
    :param next_reset_time: Next reset time for the resource counter.
    :type next_reset_time: ~datetime.datetime
    :param current_value: The current value of the resource counter.
    :type current_value: long
    :param limit: The resource limit.
    :type limit: long
    :param name: Quota name.
    :type name: ~azure.mgmt.web.v2016_09_01.models.LocalizableString
    """

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmUsageQuota, self).__init__(**kwargs)
        self.unit = kwargs.get('unit', None)
        self.next_reset_time = kwargs.get('next_reset_time', None)
        self.current_value = kwargs.get('current_value', None)
        self.limit = kwargs.get('limit', None)
        self.name = kwargs.get('name', None)


class CsmUsageQuotaCollection(msrest.serialization.Model):
    """Collection of CSM usage quotas.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_09_01.models.CsmUsageQuota]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CsmUsageQuota]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmUsageQuotaCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ErrorEntity(msrest.serialization.Model):
    """Body of the error response returned from the API.

    :param extended_code: Type of error.
    :type extended_code: str
    :param message_template: Message template.
    :type message_template: str
    :param parameters: Parameters for the template.
    :type parameters: list[str]
    :param inner_errors: Inner errors.
    :type inner_errors: list[~azure.mgmt.web.v2016_09_01.models.ErrorEntity]
    :param code: Basic error code.
    :type code: str
    :param message: Any details of the error.
    :type message: str
    """

    _attribute_map = {
        'extended_code': {'key': 'extendedCode', 'type': 'str'},
        'message_template': {'key': 'messageTemplate', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[str]'},
        'inner_errors': {'key': 'innerErrors', 'type': '[ErrorEntity]'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorEntity, self).__init__(**kwargs)
        self.extended_code = kwargs.get('extended_code', None)
        self.message_template = kwargs.get('message_template', None)
        self.parameters = kwargs.get('parameters', None)
        self.inner_errors = kwargs.get('inner_errors', None)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class Experiments(msrest.serialization.Model):
    """Routing rules in production experiments.

    :param ramp_up_rules: List of ramp-up rules.
    :type ramp_up_rules: list[~azure.mgmt.web.v2016_09_01.models.RampUpRule]
    """

    _attribute_map = {
        'ramp_up_rules': {'key': 'rampUpRules', 'type': '[RampUpRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Experiments, self).__init__(**kwargs)
        self.ramp_up_rules = kwargs.get('ramp_up_rules', None)


class HandlerMapping(msrest.serialization.Model):
    """The IIS handler mappings used to define which handler processes HTTP requests with certain extension. 
For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php extension.

    :param extension: Requests with this extension will be handled using the specified FastCGI
     application.
    :type extension: str
    :param script_processor: The absolute path to the FastCGI application.
    :type script_processor: str
    :param arguments: Command-line arguments to be passed to the script processor.
    :type arguments: str
    """

    _attribute_map = {
        'extension': {'key': 'extension', 'type': 'str'},
        'script_processor': {'key': 'scriptProcessor', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HandlerMapping, self).__init__(**kwargs)
        self.extension = kwargs.get('extension', None)
        self.script_processor = kwargs.get('script_processor', None)
        self.arguments = kwargs.get('arguments', None)


class HostingEnvironmentDiagnostics(msrest.serialization.Model):
    """Diagnostics for an App Service Environment.

    :param name: Name/identifier of the diagnostics.
    :type name: str
    :param diagnosics_output: Diagnostics output.
    :type diagnosics_output: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'diagnosics_output': {'key': 'diagnosicsOutput', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostingEnvironmentDiagnostics, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.diagnosics_output = kwargs.get('diagnosics_output', None)


class HostingEnvironmentProfile(msrest.serialization.Model):
    """Specification for an App Service Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID of the App Service Environment.
    :type id: str
    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar type: Resource type of the App Service Environment.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostingEnvironmentProfile, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.type = None


class HostNameSslState(msrest.serialization.Model):
    """SSL-enabled hostname.

    :param name: Hostname.
    :type name: str
    :param ssl_state: SSL type. Possible values include: "Disabled", "SniEnabled",
     "IpBasedEnabled".
    :type ssl_state: str or ~azure.mgmt.web.v2016_09_01.models.SslState
    :param virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :type virtual_ip: str
    :param thumbprint: SSL certificate thumbprint.
    :type thumbprint: str
    :param to_update: Set to :code:`<code>true</code>` to update existing hostname.
    :type to_update: bool
    :param host_type: Indicates whether the hostname is a standard or repository hostname. Possible
     values include: "Standard", "Repository".
    :type host_type: str or ~azure.mgmt.web.v2016_09_01.models.HostType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'ssl_state': {'key': 'sslState', 'type': 'str'},
        'virtual_ip': {'key': 'virtualIP', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'to_update': {'key': 'toUpdate', 'type': 'bool'},
        'host_type': {'key': 'hostType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostNameSslState, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.ssl_state = kwargs.get('ssl_state', None)
        self.virtual_ip = kwargs.get('virtual_ip', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.to_update = kwargs.get('to_update', None)
        self.host_type = kwargs.get('host_type', None)


class HybridConnection(ProxyOnlyResource):
    """Hybrid Connection contract. This is used to configure a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param service_bus_namespace: The name of the Service Bus namespace.
    :type service_bus_namespace: str
    :param relay_name: The name of the Service Bus relay.
    :type relay_name: str
    :param relay_arm_uri: The ARM URI to the Service Bus relay.
    :type relay_arm_uri: str
    :param hostname: The hostname of the endpoint.
    :type hostname: str
    :param port: The port of the endpoint.
    :type port: int
    :param send_key_name: The name of the Service Bus key which has Send permissions. This is used
     to authenticate to Service Bus.
    :type send_key_name: str
    :param send_key_value: The value of the Service Bus key. This is used to authenticate to
     Service Bus. In ARM this key will not be returned
     normally, use the POST /listKeys API instead.
    :type send_key_value: str
    :param service_bus_suffix: The suffix for the service bus endpoint. By default this is
     .servicebus.windows.net.
    :type service_bus_suffix: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'relay_name': {'key': 'properties.relayName', 'type': 'str'},
        'relay_arm_uri': {'key': 'properties.relayArmUri', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
        'service_bus_suffix': {'key': 'properties.serviceBusSuffix', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridConnection, self).__init__(**kwargs)
        self.service_bus_namespace = kwargs.get('service_bus_namespace', None)
        self.relay_name = kwargs.get('relay_name', None)
        self.relay_arm_uri = kwargs.get('relay_arm_uri', None)
        self.hostname = kwargs.get('hostname', None)
        self.port = kwargs.get('port', None)
        self.send_key_name = kwargs.get('send_key_name', None)
        self.send_key_value = kwargs.get('send_key_value', None)
        self.service_bus_suffix = kwargs.get('service_bus_suffix', None)


class HybridConnectionCollection(msrest.serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_09_01.models.HybridConnection]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HybridConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridConnectionCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class HybridConnectionKey(ProxyOnlyResource):
    """Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar send_key_name: The name of the send key.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the send key.
    :vartype send_key_value: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'send_key_name': {'readonly': True},
        'send_key_value': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridConnectionKey, self).__init__(**kwargs)
        self.send_key_name = None
        self.send_key_value = None


class HybridConnectionLimits(ProxyOnlyResource):
    """Hybrid Connection limits contract. This is used to return the plan limits of Hybrid Connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar current: The current number of Hybrid Connections.
    :vartype current: int
    :ivar maximum: The maximum number of Hybrid Connections allowed.
    :vartype maximum: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'current': {'readonly': True},
        'maximum': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'current': {'key': 'properties.current', 'type': 'int'},
        'maximum': {'key': 'properties.maximum', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridConnectionLimits, self).__init__(**kwargs)
        self.current = None
        self.maximum = None


class IpSecurityRestriction(msrest.serialization.Model):
    """IP security restriction on an app.

    All required parameters must be populated in order to send to Azure.

    :param ip_address: Required. IP address the security restriction is valid for.
    :type ip_address: str
    :param subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
    :type subnet_mask: str
    """

    _validation = {
        'ip_address': {'required': True},
    }

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'subnet_mask': {'key': 'subnetMask', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IpSecurityRestriction, self).__init__(**kwargs)
        self.ip_address = kwargs['ip_address']
        self.subnet_mask = kwargs.get('subnet_mask', None)


class LocalizableString(msrest.serialization.Model):
    """Localizable string object containing the name and a localized value.

    :param value: Non-localized name.
    :type value: str
    :param localized_value: Localized name.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocalizableString, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class ManagedServiceIdentity(msrest.serialization.Model):
    """Managed service identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type: Type of managed service identity. Possible values include: "SystemAssigned".
    :type type: str or ~azure.mgmt.web.v2016_09_01.models.ManagedServiceIdentityType
    :ivar tenant_id: Tenant of managed service identity.
    :vartype tenant_id: str
    :ivar principal_id: Principal Id of managed service identity.
    :vartype principal_id: str
    """

    _validation = {
        'tenant_id': {'readonly': True},
        'principal_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.tenant_id = None
        self.principal_id = None


class MetricAvailabilily(msrest.serialization.Model):
    """Metric availability and retention.

    :param time_grain: Time grain.
    :type time_grain: str
    :param retention: Retention period for the current time grain.
    :type retention: str
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'retention': {'key': 'retention', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAvailabilily, self).__init__(**kwargs)
        self.time_grain = kwargs.get('time_grain', None)
        self.retention = kwargs.get('retention', None)


class MetricDefinition(ProxyOnlyResource):
    """Metadata for a metric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name of the metric.
    :vartype name_properties_name: str
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric together with
     retention period.
    :vartype metric_availabilities: list[~azure.mgmt.web.v2016_09_01.models.MetricAvailabilily]
    :ivar display_name: Friendly name shown in the UI.
    :vartype display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'unit': {'readonly': True},
        'primary_aggregation_type': {'readonly': True},
        'metric_availabilities': {'readonly': True},
        'display_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
        'primary_aggregation_type': {'key': 'properties.primaryAggregationType', 'type': 'str'},
        'metric_availabilities': {'key': 'properties.metricAvailabilities', 'type': '[MetricAvailabilily]'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricDefinition, self).__init__(**kwargs)
        self.name_properties_name = None
        self.unit = None
        self.primary_aggregation_type = None
        self.metric_availabilities = None
        self.display_name = None


class NameValuePair(msrest.serialization.Model):
    """Name value pair.

    :param name: Pair name.
    :type name: str
    :param value: Pair value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameValuePair, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class NetworkAccessControlEntry(msrest.serialization.Model):
    """Network access control entry.

    :param action: Action object. Possible values include: "Permit", "Deny".
    :type action: str or ~azure.mgmt.web.v2016_09_01.models.AccessControlEntryAction
    :param description: Description of network access control entry.
    :type description: str
    :param order: Order of precedence.
    :type order: int
    :param remote_subnet: Remote subnet.
    :type remote_subnet: str
    """

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'order': {'key': 'order', 'type': 'int'},
        'remote_subnet': {'key': 'remoteSubnet', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkAccessControlEntry, self).__init__(**kwargs)
        self.action = kwargs.get('action', None)
        self.description = kwargs.get('description', None)
        self.order = kwargs.get('order', None)
        self.remote_subnet = kwargs.get('remote_subnet', None)


class Operation(msrest.serialization.Model):
    """An operation on a resource.

    :param id: Operation ID.
    :type id: str
    :param name: Operation name.
    :type name: str
    :param status: The current status of the operation. Possible values include: "InProgress",
     "Failed", "Succeeded", "TimedOut", "Created".
    :type status: str or ~azure.mgmt.web.v2016_09_01.models.OperationStatus
    :param errors: Any errors associate with the operation.
    :type errors: list[~azure.mgmt.web.v2016_09_01.models.ErrorEntity]
    :param created_time: Time when operation has started.
    :type created_time: ~datetime.datetime
    :param modified_time: Time when operation has been updated.
    :type modified_time: ~datetime.datetime
    :param expiration_time: Time when operation will expire.
    :type expiration_time: ~datetime.datetime
    :param geo_master_operation_id: Applicable only for stamp operation ids.
    :type geo_master_operation_id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ErrorEntity]'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'expirationTime', 'type': 'iso-8601'},
        'geo_master_operation_id': {'key': 'geoMasterOperationId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.status = kwargs.get('status', None)
        self.errors = kwargs.get('errors', None)
        self.created_time = kwargs.get('created_time', None)
        self.modified_time = kwargs.get('modified_time', None)
        self.expiration_time = kwargs.get('expiration_time', None)
        self.geo_master_operation_id = kwargs.get('geo_master_operation_id', None)


class PushSettings(ProxyOnlyResource):
    """Push settings for the App.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
    :type is_push_enabled: bool
    :param tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are
     whitelisted for use by the push registration endpoint.
    :type tag_whitelist_json: str
    :param tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
     user authentication to be used in the push registration endpoint.
     Tags can consist of alphanumeric characters and the following:
     '_', '@', '#', '.', ':', '-'.
     Validation should be performed at the PushRequestHandler.
    :type tags_requiring_auth: str
    :param dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that
     will be evaluated from user claims in the push registration endpoint.
    :type dynamic_tags_json: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_push_enabled': {'key': 'properties.isPushEnabled', 'type': 'bool'},
        'tag_whitelist_json': {'key': 'properties.tagWhitelistJson', 'type': 'str'},
        'tags_requiring_auth': {'key': 'properties.tagsRequiringAuth', 'type': 'str'},
        'dynamic_tags_json': {'key': 'properties.dynamicTagsJson', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PushSettings, self).__init__(**kwargs)
        self.is_push_enabled = kwargs.get('is_push_enabled', None)
        self.tag_whitelist_json = kwargs.get('tag_whitelist_json', None)
        self.tags_requiring_auth = kwargs.get('tags_requiring_auth', None)
        self.dynamic_tags_json = kwargs.get('dynamic_tags_json', None)


class RampUpRule(msrest.serialization.Model):
    """Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually change routing % based on performance.

    :param action_host_name: Hostname of a slot to which the traffic will be redirected if decided
     to. E.g. myapp-stage.azurewebsites.net.
    :type action_host_name: str
    :param reroute_percentage: Percentage of the traffic which will be redirected to
     :code:`<code>ActionHostName</code>`.
    :type reroute_percentage: float
    :param change_step: In auto ramp up scenario this is the step to add/remove from
     :code:`<code>ReroutePercentage</code>` until it reaches
     :code:`<code>MinReroutePercentage</code>` or :code:`<code>MaxReroutePercentage</code>`. Site
     metrics are checked every N minutes specified in :code:`<code>ChangeIntervalInMinutes</code>`.
     Custom decision algorithm can be provided in TiPCallback site extension which URL can be
     specified in :code:`<code>ChangeDecisionCallbackUrl</code>`.
    :type change_step: float
    :param change_interval_in_minutes: Specifies interval in minutes to reevaluate
     ReroutePercentage.
    :type change_interval_in_minutes: int
    :param min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will
     stay.
    :type min_reroute_percentage: float
    :param max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will
     stay.
    :type max_reroute_percentage: float
    :param change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
     site extension which URL can be specified. See TiPCallback site extension for the scaffold and
     contracts.
     https://www.siteextensions.net/packages/TiPCallback/.
    :type change_decision_callback_url: str
    :param name: Name of the routing rule. The recommended name would be to point to the slot which
     will receive the traffic in the experiment.
    :type name: str
    """

    _attribute_map = {
        'action_host_name': {'key': 'actionHostName', 'type': 'str'},
        'reroute_percentage': {'key': 'reroutePercentage', 'type': 'float'},
        'change_step': {'key': 'changeStep', 'type': 'float'},
        'change_interval_in_minutes': {'key': 'changeIntervalInMinutes', 'type': 'int'},
        'min_reroute_percentage': {'key': 'minReroutePercentage', 'type': 'float'},
        'max_reroute_percentage': {'key': 'maxReroutePercentage', 'type': 'float'},
        'change_decision_callback_url': {'key': 'changeDecisionCallbackUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RampUpRule, self).__init__(**kwargs)
        self.action_host_name = kwargs.get('action_host_name', None)
        self.reroute_percentage = kwargs.get('reroute_percentage', None)
        self.change_step = kwargs.get('change_step', None)
        self.change_interval_in_minutes = kwargs.get('change_interval_in_minutes', None)
        self.min_reroute_percentage = kwargs.get('min_reroute_percentage', None)
        self.max_reroute_percentage = kwargs.get('max_reroute_percentage', None)
        self.change_decision_callback_url = kwargs.get('change_decision_callback_url', None)
        self.name = kwargs.get('name', None)


class RequestsBasedTrigger(msrest.serialization.Model):
    """Trigger based on total requests.

    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RequestsBasedTrigger, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.time_interval = kwargs.get('time_interval', None)


class ResourceCollection(msrest.serialization.Model):
    """Collection of resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[str]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[str]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ResourceMetric(msrest.serialization.Model):
    """Object representing a metric for any resource .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of metric.
    :vartype name: ~azure.mgmt.web.v2016_09_01.models.ResourceMetricName
    :ivar unit: Metric unit.
    :vartype unit: str
    :ivar time_grain: Metric granularity. E.g PT1H, PT5M, P1D.
    :vartype time_grain: str
    :ivar start_time: Metric start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Metric end time.
    :vartype end_time: ~datetime.datetime
    :ivar resource_id: Metric resource Id.
    :vartype resource_id: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar metric_values: Metric values.
    :vartype metric_values: list[~azure.mgmt.web.v2016_09_01.models.ResourceMetricValue]
    :ivar properties: Resource metric properties collection.
    :vartype properties: list[~azure.mgmt.web.v2016_09_01.models.ResourceMetricProperty]
    """

    _validation = {
        'name': {'readonly': True},
        'unit': {'readonly': True},
        'time_grain': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'resource_id': {'readonly': True},
        'id': {'readonly': True},
        'metric_values': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'ResourceMetricName'},
        'unit': {'key': 'unit', 'type': 'str'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'metric_values': {'key': 'metricValues', 'type': '[ResourceMetricValue]'},
        'properties': {'key': 'properties', 'type': '[ResourceMetricProperty]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetric, self).__init__(**kwargs)
        self.name = None
        self.unit = None
        self.time_grain = None
        self.start_time = None
        self.end_time = None
        self.resource_id = None
        self.id = None
        self.metric_values = None
        self.properties = None


class ResourceMetricAvailability(msrest.serialization.Model):
    """Metrics availability and retention.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time_grain: Time grain .
    :vartype time_grain: str
    :ivar retention: Retention period for the current time grain.
    :vartype retention: str
    """

    _validation = {
        'time_grain': {'readonly': True},
        'retention': {'readonly': True},
    }

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'retention': {'key': 'retention', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricAvailability, self).__init__(**kwargs)
        self.time_grain = None
        self.retention = None


class ResourceMetricCollection(msrest.serialization.Model):
    """Collection of metric responses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_09_01.models.ResourceMetric]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceMetric]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ResourceMetricDefinition(ProxyOnlyResource):
    """Metadata for the metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name of the metric.
    :vartype name_properties_name: ~azure.mgmt.web.v2016_09_01.models.ResourceMetricName
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric together with
     retention period.
    :vartype metric_availabilities:
     list[~azure.mgmt.web.v2016_09_01.models.ResourceMetricAvailability]
    :ivar resource_uri: Resource URI.
    :vartype resource_uri: str
    :ivar id_properties_id: Resource ID.
    :vartype id_properties_id: str
    :ivar properties: Resource metric definition properties.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'unit': {'readonly': True},
        'primary_aggregation_type': {'readonly': True},
        'metric_availabilities': {'readonly': True},
        'resource_uri': {'readonly': True},
        'id_properties_id': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'ResourceMetricName'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
        'primary_aggregation_type': {'key': 'properties.primaryAggregationType', 'type': 'str'},
        'metric_availabilities': {'key': 'properties.metricAvailabilities', 'type': '[ResourceMetricAvailability]'},
        'resource_uri': {'key': 'properties.resourceUri', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'properties': {'key': 'properties.properties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricDefinition, self).__init__(**kwargs)
        self.name_properties_name = None
        self.unit = None
        self.primary_aggregation_type = None
        self.metric_availabilities = None
        self.resource_uri = None
        self.id_properties_id = None
        self.properties = None


class ResourceMetricDefinitionCollection(msrest.serialization.Model):
    """Collection of metric definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_09_01.models.ResourceMetricDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceMetricDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricDefinitionCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ResourceMetricName(msrest.serialization.Model):
    """Name of a metric for any resource .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: metric name value.
    :vartype value: str
    :ivar localized_value: Localized metric name value.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class ResourceMetricProperty(msrest.serialization.Model):
    """Resource metric property.

    :param key: Key for resource metric property.
    :type key: str
    :param value: Value of pair.
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricProperty, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class ResourceMetricValue(msrest.serialization.Model):
    """Value of resource metric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: Value timestamp.
    :vartype timestamp: str
    :ivar average: Value average.
    :vartype average: float
    :ivar minimum: Value minimum.
    :vartype minimum: float
    :ivar maximum: Value maximum.
    :vartype maximum: float
    :ivar total: Value total.
    :vartype total: float
    :ivar count: Value count.
    :vartype count: float
    :ivar properties: Resource metric properties collection.
    :vartype properties: list[~azure.mgmt.web.v2016_09_01.models.ResourceMetricProperty]
    """

    _validation = {
        'timestamp': {'readonly': True},
        'average': {'readonly': True},
        'minimum': {'readonly': True},
        'maximum': {'readonly': True},
        'total': {'readonly': True},
        'count': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'str'},
        'average': {'key': 'average', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'total': {'key': 'total', 'type': 'float'},
        'count': {'key': 'count', 'type': 'float'},
        'properties': {'key': 'properties', 'type': '[ResourceMetricProperty]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricValue, self).__init__(**kwargs)
        self.timestamp = None
        self.average = None
        self.minimum = None
        self.maximum = None
        self.total = None
        self.count = None
        self.properties = None


class Site(Resource):
    """A web app, a mobile app backend, or an API app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: Managed service identity.
    :type identity: ~azure.mgmt.web.v2016_09_01.models.ManagedServiceIdentity
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Possible values include: "Normal", "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2016_09_01.models.UsageState
    :param enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :type enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Possible
     values include: "Normal", "Limited", "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2016_09_01.models.SiteAvailabilityState
    :param host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :type host_name_ssl_states: list[~azure.mgmt.web.v2016_09_01.models.HostNameSslState]
    :param server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    :param reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :type reserved: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :param site_config: Configuration of the app.
    :type site_config: ~azure.mgmt.web.v2016_09_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :param scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :type scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :param hosting_environment_profile: App Service Environment to use for the app.
    :type hosting_environment_profile: ~azure.mgmt.web.v2016_09_01.models.HostingEnvironmentProfile
    :param client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :type client_affinity_enabled: bool
    :param client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :type client_cert_enabled: bool
    :param host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :type host_names_disabled: bool
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants. Read-only.
    :vartype possible_outbound_ip_addresses: str
    :param container_size: Size of the function container.
    :type container_size: int
    :param daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :type daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :param cloning_info: If specified during app creation, the app is cloned from a source app.
    :type cloning_info: ~azure.mgmt.web.v2016_09_01.models.CloningInfo
    :param snapshot_info: If specified during app creation, the app is created from a previous
     snapshot.
    :type snapshot_info: ~azure.mgmt.web.v2016_09_01.models.SnapshotRecoveryRequest
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2016_09_01.models.SlotSwapStatus
    :param https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :type https_only: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'host_names': {'readonly': True},
        'repository_site_name': {'readonly': True},
        'usage_state': {'readonly': True},
        'enabled_host_names': {'readonly': True},
        'availability_state': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'traffic_manager_host_names': {'readonly': True},
        'target_swap_slot': {'readonly': True},
        'outbound_ip_addresses': {'readonly': True},
        'possible_outbound_ip_addresses': {'readonly': True},
        'suspended_till': {'readonly': True},
        'max_number_of_workers': {'readonly': True},
        'resource_group': {'readonly': True},
        'is_default_container': {'readonly': True},
        'default_host_name': {'readonly': True},
        'slot_swap_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'repository_site_name': {'key': 'properties.repositorySiteName', 'type': 'str'},
        'usage_state': {'key': 'properties.usageState', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'enabled_host_names': {'key': 'properties.enabledHostNames', 'type': '[str]'},
        'availability_state': {'key': 'properties.availabilityState', 'type': 'str'},
        'host_name_ssl_states': {'key': 'properties.hostNameSslStates', 'type': '[HostNameSslState]'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'site_config': {'key': 'properties.siteConfig', 'type': 'SiteConfig'},
        'traffic_manager_host_names': {'key': 'properties.trafficManagerHostNames', 'type': '[str]'},
        'scm_site_also_stopped': {'key': 'properties.scmSiteAlsoStopped', 'type': 'bool'},
        'target_swap_slot': {'key': 'properties.targetSwapSlot', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'client_affinity_enabled': {'key': 'properties.clientAffinityEnabled', 'type': 'bool'},
        'client_cert_enabled': {'key': 'properties.clientCertEnabled', 'type': 'bool'},
        'host_names_disabled': {'key': 'properties.hostNamesDisabled', 'type': 'bool'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': 'str'},
        'possible_outbound_ip_addresses': {'key': 'properties.possibleOutboundIpAddresses', 'type': 'str'},
        'container_size': {'key': 'properties.containerSize', 'type': 'int'},
        'daily_memory_time_quota': {'key': 'properties.dailyMemoryTimeQuota', 'type': 'int'},
        'suspended_till': {'key': 'properties.suspendedTill', 'type': 'iso-8601'},
        'max_number_of_workers': {'key': 'properties.maxNumberOfWorkers', 'type': 'int'},
        'cloning_info': {'key': 'properties.cloningInfo', 'type': 'CloningInfo'},
        'snapshot_info': {'key': 'properties.snapshotInfo', 'type': 'SnapshotRecoveryRequest'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'is_default_container': {'key': 'properties.isDefaultContainer', 'type': 'bool'},
        'default_host_name': {'key': 'properties.defaultHostName', 'type': 'str'},
        'slot_swap_status': {'key': 'properties.slotSwapStatus', 'type': 'SlotSwapStatus'},
        'https_only': {'key': 'properties.httpsOnly', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Site, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = kwargs.get('enabled', None)
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = kwargs.get('host_name_ssl_states', None)
        self.server_farm_id = kwargs.get('server_farm_id', None)
        self.reserved = kwargs.get('reserved', False)
        self.last_modified_time_utc = None
        self.site_config = kwargs.get('site_config', None)
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = kwargs.get('scm_site_also_stopped', False)
        self.target_swap_slot = None
        self.hosting_environment_profile = kwargs.get('hosting_environment_profile', None)
        self.client_affinity_enabled = kwargs.get('client_affinity_enabled', None)
        self.client_cert_enabled = kwargs.get('client_cert_enabled', None)
        self.host_names_disabled = kwargs.get('host_names_disabled', None)
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = kwargs.get('container_size', None)
        self.daily_memory_time_quota = kwargs.get('daily_memory_time_quota', None)
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = kwargs.get('cloning_info', None)
        self.snapshot_info = kwargs.get('snapshot_info', None)
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = kwargs.get('https_only', None)


class SiteConfig(msrest.serialization.Model):
    """Configuration of an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param number_of_workers: Number of workers.
    :type number_of_workers: int
    :param default_documents: Default documents.
    :type default_documents: list[str]
    :param net_framework_version: .NET Framework version.
    :type net_framework_version: str
    :param php_version: Version of PHP.
    :type php_version: str
    :param python_version: Version of Python.
    :type python_version: str
    :param node_version: Version of Node.js.
    :type node_version: str
    :param linux_fx_version: Linux App Framework and version.
    :type linux_fx_version: str
    :param request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :type request_tracing_enabled: bool
    :param request_tracing_expiration_time: Request tracing expiration time.
    :type request_tracing_expiration_time: ~datetime.datetime
    :param remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :type remote_debugging_enabled: bool
    :param remote_debugging_version: Remote debugging version.
    :type remote_debugging_version: str
    :param http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :type http_logging_enabled: bool
    :param logs_directory_size_limit: HTTP logs directory size limit.
    :type logs_directory_size_limit: int
    :param detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :type detailed_error_logging_enabled: bool
    :param publishing_username: Publishing user name.
    :type publishing_username: str
    :param app_settings: Application settings.
    :type app_settings: list[~azure.mgmt.web.v2016_09_01.models.NameValuePair]
    :param connection_strings: Connection strings.
    :type connection_strings: list[~azure.mgmt.web.v2016_09_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2016_09_01.models.SiteMachineKey
    :param handler_mappings: Handler mappings.
    :type handler_mappings: list[~azure.mgmt.web.v2016_09_01.models.HandlerMapping]
    :param document_root: Document root.
    :type document_root: str
    :param scm_type: SCM type. Possible values include: "None", "Dropbox", "Tfs", "LocalGit",
     "GitHub", "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit",
     "ExternalHg", "OneDrive", "VSO".
    :type scm_type: str or ~azure.mgmt.web.v2016_09_01.models.ScmType
    :param use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :type use32_bit_worker_process: bool
    :param web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :type web_sockets_enabled: bool
    :param always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :type always_on: bool
    :param java_version: Java version.
    :type java_version: str
    :param java_container: Java container.
    :type java_container: str
    :param java_container_version: Java container version.
    :type java_container_version: str
    :param app_command_line: App command line to launch.
    :type app_command_line: str
    :param managed_pipeline_mode: Managed pipeline mode. Possible values include: "Integrated",
     "Classic".
    :type managed_pipeline_mode: str or ~azure.mgmt.web.v2016_09_01.models.ManagedPipelineMode
    :param virtual_applications: Virtual applications.
    :type virtual_applications: list[~azure.mgmt.web.v2016_09_01.models.VirtualApplication]
    :param load_balancing: Site load balancing. Possible values include: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash".
    :type load_balancing: str or ~azure.mgmt.web.v2016_09_01.models.SiteLoadBalancing
    :param experiments: This is work around for polymorphic types.
    :type experiments: ~azure.mgmt.web.v2016_09_01.models.Experiments
    :param limits: Site limits.
    :type limits: ~azure.mgmt.web.v2016_09_01.models.SiteLimits
    :param auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :type auto_heal_enabled: bool
    :param auto_heal_rules: Auto Heal rules.
    :type auto_heal_rules: ~azure.mgmt.web.v2016_09_01.models.AutoHealRules
    :param tracing_options: Tracing options.
    :type tracing_options: str
    :param vnet_name: Virtual Network name.
    :type vnet_name: str
    :param cors: Cross-Origin Resource Sharing (CORS) settings.
    :type cors: ~azure.mgmt.web.v2016_09_01.models.CorsSettings
    :param push: Push endpoint settings.
    :type push: ~azure.mgmt.web.v2016_09_01.models.PushSettings
    :param api_definition: Information about the formal API definition for the app.
    :type api_definition: ~azure.mgmt.web.v2016_09_01.models.ApiDefinitionInfo
    :param auto_swap_slot_name: Auto-swap slot name.
    :type auto_swap_slot_name: str
    :param local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :type local_my_sql_enabled: bool
    :param ip_security_restrictions: IP security restrictions.
    :type ip_security_restrictions: list[~azure.mgmt.web.v2016_09_01.models.IpSecurityRestriction]
    :param http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :type http20_enabled: bool
    :param min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Possible values include: "1.0", "1.1", "1.2".
    :type min_tls_version: str or ~azure.mgmt.web.v2016_09_01.models.SupportedTlsVersions
    """

    _validation = {
        'machine_key': {'readonly': True},
    }

    _attribute_map = {
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'default_documents': {'key': 'defaultDocuments', 'type': '[str]'},
        'net_framework_version': {'key': 'netFrameworkVersion', 'type': 'str'},
        'php_version': {'key': 'phpVersion', 'type': 'str'},
        'python_version': {'key': 'pythonVersion', 'type': 'str'},
        'node_version': {'key': 'nodeVersion', 'type': 'str'},
        'linux_fx_version': {'key': 'linuxFxVersion', 'type': 'str'},
        'request_tracing_enabled': {'key': 'requestTracingEnabled', 'type': 'bool'},
        'request_tracing_expiration_time': {'key': 'requestTracingExpirationTime', 'type': 'iso-8601'},
        'remote_debugging_enabled': {'key': 'remoteDebuggingEnabled', 'type': 'bool'},
        'remote_debugging_version': {'key': 'remoteDebuggingVersion', 'type': 'str'},
        'http_logging_enabled': {'key': 'httpLoggingEnabled', 'type': 'bool'},
        'logs_directory_size_limit': {'key': 'logsDirectorySizeLimit', 'type': 'int'},
        'detailed_error_logging_enabled': {'key': 'detailedErrorLoggingEnabled', 'type': 'bool'},
        'publishing_username': {'key': 'publishingUsername', 'type': 'str'},
        'app_settings': {'key': 'appSettings', 'type': '[NameValuePair]'},
        'connection_strings': {'key': 'connectionStrings', 'type': '[ConnStringInfo]'},
        'machine_key': {'key': 'machineKey', 'type': 'SiteMachineKey'},
        'handler_mappings': {'key': 'handlerMappings', 'type': '[HandlerMapping]'},
        'document_root': {'key': 'documentRoot', 'type': 'str'},
        'scm_type': {'key': 'scmType', 'type': 'str'},
        'use32_bit_worker_process': {'key': 'use32BitWorkerProcess', 'type': 'bool'},
        'web_sockets_enabled': {'key': 'webSocketsEnabled', 'type': 'bool'},
        'always_on': {'key': 'alwaysOn', 'type': 'bool'},
        'java_version': {'key': 'javaVersion', 'type': 'str'},
        'java_container': {'key': 'javaContainer', 'type': 'str'},
        'java_container_version': {'key': 'javaContainerVersion', 'type': 'str'},
        'app_command_line': {'key': 'appCommandLine', 'type': 'str'},
        'managed_pipeline_mode': {'key': 'managedPipelineMode', 'type': 'str'},
        'virtual_applications': {'key': 'virtualApplications', 'type': '[VirtualApplication]'},
        'load_balancing': {'key': 'loadBalancing', 'type': 'str'},
        'experiments': {'key': 'experiments', 'type': 'Experiments'},
        'limits': {'key': 'limits', 'type': 'SiteLimits'},
        'auto_heal_enabled': {'key': 'autoHealEnabled', 'type': 'bool'},
        'auto_heal_rules': {'key': 'autoHealRules', 'type': 'AutoHealRules'},
        'tracing_options': {'key': 'tracingOptions', 'type': 'str'},
        'vnet_name': {'key': 'vnetName', 'type': 'str'},
        'cors': {'key': 'cors', 'type': 'CorsSettings'},
        'push': {'key': 'push', 'type': 'PushSettings'},
        'api_definition': {'key': 'apiDefinition', 'type': 'ApiDefinitionInfo'},
        'auto_swap_slot_name': {'key': 'autoSwapSlotName', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'localMySqlEnabled', 'type': 'bool'},
        'ip_security_restrictions': {'key': 'ipSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'http20_enabled': {'key': 'http20Enabled', 'type': 'bool'},
        'min_tls_version': {'key': 'minTlsVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteConfig, self).__init__(**kwargs)
        self.number_of_workers = kwargs.get('number_of_workers', None)
        self.default_documents = kwargs.get('default_documents', None)
        self.net_framework_version = kwargs.get('net_framework_version', "v4.6")
        self.php_version = kwargs.get('php_version', None)
        self.python_version = kwargs.get('python_version', None)
        self.node_version = kwargs.get('node_version', None)
        self.linux_fx_version = kwargs.get('linux_fx_version', None)
        self.request_tracing_enabled = kwargs.get('request_tracing_enabled', None)
        self.request_tracing_expiration_time = kwargs.get('request_tracing_expiration_time', None)
        self.remote_debugging_enabled = kwargs.get('remote_debugging_enabled', None)
        self.remote_debugging_version = kwargs.get('remote_debugging_version', None)
        self.http_logging_enabled = kwargs.get('http_logging_enabled', None)
        self.logs_directory_size_limit = kwargs.get('logs_directory_size_limit', None)
        self.detailed_error_logging_enabled = kwargs.get('detailed_error_logging_enabled', None)
        self.publishing_username = kwargs.get('publishing_username', None)
        self.app_settings = kwargs.get('app_settings', None)
        self.connection_strings = kwargs.get('connection_strings', None)
        self.machine_key = None
        self.handler_mappings = kwargs.get('handler_mappings', None)
        self.document_root = kwargs.get('document_root', None)
        self.scm_type = kwargs.get('scm_type', None)
        self.use32_bit_worker_process = kwargs.get('use32_bit_worker_process', None)
        self.web_sockets_enabled = kwargs.get('web_sockets_enabled', None)
        self.always_on = kwargs.get('always_on', None)
        self.java_version = kwargs.get('java_version', None)
        self.java_container = kwargs.get('java_container', None)
        self.java_container_version = kwargs.get('java_container_version', None)
        self.app_command_line = kwargs.get('app_command_line', None)
        self.managed_pipeline_mode = kwargs.get('managed_pipeline_mode', None)
        self.virtual_applications = kwargs.get('virtual_applications', None)
        self.load_balancing = kwargs.get('load_balancing', None)
        self.experiments = kwargs.get('experiments', None)
        self.limits = kwargs.get('limits', None)
        self.auto_heal_enabled = kwargs.get('auto_heal_enabled', None)
        self.auto_heal_rules = kwargs.get('auto_heal_rules', None)
        self.tracing_options = kwargs.get('tracing_options', None)
        self.vnet_name = kwargs.get('vnet_name', None)
        self.cors = kwargs.get('cors', None)
        self.push = kwargs.get('push', None)
        self.api_definition = kwargs.get('api_definition', None)
        self.auto_swap_slot_name = kwargs.get('auto_swap_slot_name', None)
        self.local_my_sql_enabled = kwargs.get('local_my_sql_enabled', False)
        self.ip_security_restrictions = kwargs.get('ip_security_restrictions', None)
        self.http20_enabled = kwargs.get('http20_enabled', True)
        self.min_tls_version = kwargs.get('min_tls_version', None)


class SiteLimits(msrest.serialization.Model):
    """Metric limits set on an app.

    :param max_percentage_cpu: Maximum allowed CPU usage percentage.
    :type max_percentage_cpu: float
    :param max_memory_in_mb: Maximum allowed memory usage in MB.
    :type max_memory_in_mb: long
    :param max_disk_size_in_mb: Maximum allowed disk size usage in MB.
    :type max_disk_size_in_mb: long
    """

    _attribute_map = {
        'max_percentage_cpu': {'key': 'maxPercentageCpu', 'type': 'float'},
        'max_memory_in_mb': {'key': 'maxMemoryInMb', 'type': 'long'},
        'max_disk_size_in_mb': {'key': 'maxDiskSizeInMb', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteLimits, self).__init__(**kwargs)
        self.max_percentage_cpu = kwargs.get('max_percentage_cpu', None)
        self.max_memory_in_mb = kwargs.get('max_memory_in_mb', None)
        self.max_disk_size_in_mb = kwargs.get('max_disk_size_in_mb', None)


class SiteMachineKey(msrest.serialization.Model):
    """MachineKey of an app.

    :param validation: MachineKey validation.
    :type validation: str
    :param validation_key: Validation key.
    :type validation_key: str
    :param decryption: Algorithm used for decryption.
    :type decryption: str
    :param decryption_key: Decryption key.
    :type decryption_key: str
    """

    _attribute_map = {
        'validation': {'key': 'validation', 'type': 'str'},
        'validation_key': {'key': 'validationKey', 'type': 'str'},
        'decryption': {'key': 'decryption', 'type': 'str'},
        'decryption_key': {'key': 'decryptionKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteMachineKey, self).__init__(**kwargs)
        self.validation = kwargs.get('validation', None)
        self.validation_key = kwargs.get('validation_key', None)
        self.decryption = kwargs.get('decryption', None)
        self.decryption_key = kwargs.get('decryption_key', None)


class SkuCapacity(msrest.serialization.Model):
    """Description of the App Service plan scale options.

    :param minimum: Minimum number of workers for this App Service plan SKU.
    :type minimum: int
    :param maximum: Maximum number of workers for this App Service plan SKU.
    :type maximum: int
    :param default: Default number of workers for this App Service plan SKU.
    :type default: int
    :param scale_type: Available scale configurations for an App Service plan.
    :type scale_type: str
    """

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuCapacity, self).__init__(**kwargs)
        self.minimum = kwargs.get('minimum', None)
        self.maximum = kwargs.get('maximum', None)
        self.default = kwargs.get('default', None)
        self.scale_type = kwargs.get('scale_type', None)


class SkuDescription(msrest.serialization.Model):
    """Description of a SKU for a scalable resource.

    :param name: Name of the resource SKU.
    :type name: str
    :param tier: Service tier of the resource SKU.
    :type tier: str
    :param size: Size specifier of the resource SKU.
    :type size: str
    :param family: Family code of the resource SKU.
    :type family: str
    :param capacity: Current number of instances assigned to the resource.
    :type capacity: int
    :param sku_capacity: Min, max, and default scale values of the SKU.
    :type sku_capacity: ~azure.mgmt.web.v2016_09_01.models.SkuCapacity
    :param locations: Locations of the SKU.
    :type locations: list[str]
    :param capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
    :type capabilities: list[~azure.mgmt.web.v2016_09_01.models.Capability]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
        'sku_capacity': {'key': 'skuCapacity', 'type': 'SkuCapacity'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[Capability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.size = kwargs.get('size', None)
        self.family = kwargs.get('family', None)
        self.capacity = kwargs.get('capacity', None)
        self.sku_capacity = kwargs.get('sku_capacity', None)
        self.locations = kwargs.get('locations', None)
        self.capabilities = kwargs.get('capabilities', None)


class SkuInfo(msrest.serialization.Model):
    """SKU discovery information.

    :param resource_type: Resource type that this SKU applies to.
    :type resource_type: str
    :param sku: Name and tier of the SKU.
    :type sku: ~azure.mgmt.web.v2016_09_01.models.SkuDescription
    :param capacity: Min, max, and default scale values of the SKU.
    :type capacity: ~azure.mgmt.web.v2016_09_01.models.SkuCapacity
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'capacity': {'key': 'capacity', 'type': 'SkuCapacity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuInfo, self).__init__(**kwargs)
        self.resource_type = kwargs.get('resource_type', None)
        self.sku = kwargs.get('sku', None)
        self.capacity = kwargs.get('capacity', None)


class SkuInfoCollection(msrest.serialization.Model):
    """Collection of SKU information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_09_01.models.SkuInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SkuInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuInfoCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class SlotSwapStatus(msrest.serialization.Model):
    """The status of the last successful slot swap operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp_utc: The time the last successful slot swap completed.
    :vartype timestamp_utc: ~datetime.datetime
    :ivar source_slot_name: The source slot of the last swap operation.
    :vartype source_slot_name: str
    :ivar destination_slot_name: The destination slot of the last swap operation.
    :vartype destination_slot_name: str
    """

    _validation = {
        'timestamp_utc': {'readonly': True},
        'source_slot_name': {'readonly': True},
        'destination_slot_name': {'readonly': True},
    }

    _attribute_map = {
        'timestamp_utc': {'key': 'timestampUtc', 'type': 'iso-8601'},
        'source_slot_name': {'key': 'sourceSlotName', 'type': 'str'},
        'destination_slot_name': {'key': 'destinationSlotName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SlotSwapStatus, self).__init__(**kwargs)
        self.timestamp_utc = None
        self.source_slot_name = None
        self.destination_slot_name = None


class SlowRequestsBasedTrigger(msrest.serialization.Model):
    """Trigger based on request execution time.

    :param time_taken: Time taken.
    :type time_taken: str
    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'time_taken': {'key': 'timeTaken', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SlowRequestsBasedTrigger, self).__init__(**kwargs)
        self.time_taken = kwargs.get('time_taken', None)
        self.count = kwargs.get('count', None)
        self.time_interval = kwargs.get('time_interval', None)


class SnapshotRecoveryRequest(ProxyOnlyResource):
    """Details about app recovery operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param snapshot_time: Point in time in which the app recovery should be attempted, formatted as
     a DateTime string.
    :type snapshot_time: str
    :param recovery_target: Specifies the web app that snapshot contents will be written to.
    :type recovery_target: ~azure.mgmt.web.v2016_09_01.models.SnapshotRecoveryTarget
    :param overwrite: If :code:`<code>true</code>` the recovery operation can overwrite source app;
     otherwise, :code:`<code>false</code>`.
    :type overwrite: bool
    :param recover_configuration: If true, site configuration, in addition to content, will be
     reverted.
    :type recover_configuration: bool
    :param ignore_conflicting_host_names: If true, custom hostname conflicts will be ignored when
     recovering to a target web app.
     This setting is only necessary when RecoverConfiguration is enabled.
    :type ignore_conflicting_host_names: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'snapshot_time': {'key': 'properties.snapshotTime', 'type': 'str'},
        'recovery_target': {'key': 'properties.recoveryTarget', 'type': 'SnapshotRecoveryTarget'},
        'overwrite': {'key': 'properties.overwrite', 'type': 'bool'},
        'recover_configuration': {'key': 'properties.recoverConfiguration', 'type': 'bool'},
        'ignore_conflicting_host_names': {'key': 'properties.ignoreConflictingHostNames', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SnapshotRecoveryRequest, self).__init__(**kwargs)
        self.snapshot_time = kwargs.get('snapshot_time', None)
        self.recovery_target = kwargs.get('recovery_target', None)
        self.overwrite = kwargs.get('overwrite', None)
        self.recover_configuration = kwargs.get('recover_configuration', None)
        self.ignore_conflicting_host_names = kwargs.get('ignore_conflicting_host_names', None)


class SnapshotRecoveryTarget(msrest.serialization.Model):
    """Specifies the web app that snapshot contents will be written to.

    :param location: Geographical location of the target web app, e.g. SouthEastAsia,
     SouthCentralUS.
    :type location: str
    :param id: ARM resource ID of the target app.
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :type id: str
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SnapshotRecoveryTarget, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.id = kwargs.get('id', None)


class StampCapacity(msrest.serialization.Model):
    """Stamp capacity information.

    :param name: Name of the stamp.
    :type name: str
    :param available_capacity: Available capacity (# of machines, bytes of storage etc...).
    :type available_capacity: long
    :param total_capacity: Total capacity (# of machines, bytes of storage etc...).
    :type total_capacity: long
    :param unit: Name of the unit.
    :type unit: str
    :param compute_mode: Shared/dedicated workers. Possible values include: "Shared", "Dedicated",
     "Dynamic".
    :type compute_mode: str or ~azure.mgmt.web.v2016_09_01.models.ComputeModeOptions
    :param worker_size: Size of the machines. Possible values include: "Default", "Small",
     "Medium", "Large", "D1", "D2", "D3".
    :type worker_size: str or ~azure.mgmt.web.v2016_09_01.models.WorkerSizeOptions
    :param worker_size_id: Size ID of machines:
     0 - Small
     1 - Medium
     2 - Large.
    :type worker_size_id: int
    :param exclude_from_capacity_allocation: If :code:`<code>true</code>`, it includes basic apps.
     Basic apps are not used for capacity allocation.
    :type exclude_from_capacity_allocation: bool
    :param is_applicable_for_all_compute_modes: :code:`<code>true</code>` if capacity is applicable
     for all apps; otherwise, :code:`<code>false</code>`.
    :type is_applicable_for_all_compute_modes: bool
    :param site_mode: Shared or Dedicated.
    :type site_mode: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'available_capacity': {'key': 'availableCapacity', 'type': 'long'},
        'total_capacity': {'key': 'totalCapacity', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
        'compute_mode': {'key': 'computeMode', 'type': 'str'},
        'worker_size': {'key': 'workerSize', 'type': 'str'},
        'worker_size_id': {'key': 'workerSizeId', 'type': 'int'},
        'exclude_from_capacity_allocation': {'key': 'excludeFromCapacityAllocation', 'type': 'bool'},
        'is_applicable_for_all_compute_modes': {'key': 'isApplicableForAllComputeModes', 'type': 'bool'},
        'site_mode': {'key': 'siteMode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StampCapacity, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.available_capacity = kwargs.get('available_capacity', None)
        self.total_capacity = kwargs.get('total_capacity', None)
        self.unit = kwargs.get('unit', None)
        self.compute_mode = kwargs.get('compute_mode', None)
        self.worker_size = kwargs.get('worker_size', None)
        self.worker_size_id = kwargs.get('worker_size_id', None)
        self.exclude_from_capacity_allocation = kwargs.get('exclude_from_capacity_allocation', None)
        self.is_applicable_for_all_compute_modes = kwargs.get('is_applicable_for_all_compute_modes', None)
        self.site_mode = kwargs.get('site_mode', None)


class StampCapacityCollection(msrest.serialization.Model):
    """Collection of stamp capacities.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_09_01.models.StampCapacity]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StampCapacity]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StampCapacityCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class StatusCodesBasedTrigger(msrest.serialization.Model):
    """Trigger based on status code.

    :param status: HTTP status code.
    :type status: int
    :param sub_status: Request Sub Status.
    :type sub_status: int
    :param win32_status: Win32 error code.
    :type win32_status: int
    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'int'},
        'sub_status': {'key': 'subStatus', 'type': 'int'},
        'win32_status': {'key': 'win32Status', 'type': 'int'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StatusCodesBasedTrigger, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.sub_status = kwargs.get('sub_status', None)
        self.win32_status = kwargs.get('win32_status', None)
        self.count = kwargs.get('count', None)
        self.time_interval = kwargs.get('time_interval', None)


class Usage(ProxyOnlyResource):
    """Usage of the quota resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Friendly name shown in the UI.
    :vartype display_name: str
    :ivar name_properties_name: Name of the quota.
    :vartype name_properties_name: str
    :ivar resource_name: Name of the quota resource.
    :vartype resource_name: str
    :ivar unit: Units of measurement for the quota resource.
    :vartype unit: str
    :ivar current_value: The current value of the resource counter.
    :vartype current_value: long
    :ivar limit: The resource limit.
    :vartype limit: long
    :ivar next_reset_time: Next reset time for the resource counter.
    :vartype next_reset_time: ~datetime.datetime
    :ivar compute_mode: Compute mode used for this usage. Possible values include: "Shared",
     "Dedicated", "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2016_09_01.models.ComputeModeOptions
    :ivar site_mode: Site mode used for this usage.
    :vartype site_mode: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'resource_name': {'readonly': True},
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'next_reset_time': {'readonly': True},
        'compute_mode': {'readonly': True},
        'site_mode': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'resource_name': {'key': 'properties.resourceName', 'type': 'str'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
        'current_value': {'key': 'properties.currentValue', 'type': 'long'},
        'limit': {'key': 'properties.limit', 'type': 'long'},
        'next_reset_time': {'key': 'properties.nextResetTime', 'type': 'iso-8601'},
        'compute_mode': {'key': 'properties.computeMode', 'type': 'str'},
        'site_mode': {'key': 'properties.siteMode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.display_name = None
        self.name_properties_name = None
        self.resource_name = None
        self.unit = None
        self.current_value = None
        self.limit = None
        self.next_reset_time = None
        self.compute_mode = None
        self.site_mode = None


class UsageCollection(msrest.serialization.Model):
    """Collection of usages.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_09_01.models.Usage]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class VirtualApplication(msrest.serialization.Model):
    """Virtual application in an app.

    :param virtual_path: Virtual path.
    :type virtual_path: str
    :param physical_path: Physical path.
    :type physical_path: str
    :param preload_enabled: :code:`<code>true</code>` if preloading is enabled; otherwise,
     :code:`<code>false</code>`.
    :type preload_enabled: bool
    :param virtual_directories: Virtual directories for virtual application.
    :type virtual_directories: list[~azure.mgmt.web.v2016_09_01.models.VirtualDirectory]
    """

    _attribute_map = {
        'virtual_path': {'key': 'virtualPath', 'type': 'str'},
        'physical_path': {'key': 'physicalPath', 'type': 'str'},
        'preload_enabled': {'key': 'preloadEnabled', 'type': 'bool'},
        'virtual_directories': {'key': 'virtualDirectories', 'type': '[VirtualDirectory]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualApplication, self).__init__(**kwargs)
        self.virtual_path = kwargs.get('virtual_path', None)
        self.physical_path = kwargs.get('physical_path', None)
        self.preload_enabled = kwargs.get('preload_enabled', None)
        self.virtual_directories = kwargs.get('virtual_directories', None)


class VirtualDirectory(msrest.serialization.Model):
    """Directory for virtual application.

    :param virtual_path: Path to virtual application.
    :type virtual_path: str
    :param physical_path: Physical path.
    :type physical_path: str
    """

    _attribute_map = {
        'virtual_path': {'key': 'virtualPath', 'type': 'str'},
        'physical_path': {'key': 'physicalPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualDirectory, self).__init__(**kwargs)
        self.virtual_path = kwargs.get('virtual_path', None)
        self.physical_path = kwargs.get('physical_path', None)


class VirtualIPMapping(msrest.serialization.Model):
    """Virtual IP mapping.

    :param virtual_ip: Virtual IP address.
    :type virtual_ip: str
    :param internal_http_port: Internal HTTP port.
    :type internal_http_port: int
    :param internal_https_port: Internal HTTPS port.
    :type internal_https_port: int
    :param in_use: Is virtual IP mapping in use.
    :type in_use: bool
    """

    _attribute_map = {
        'virtual_ip': {'key': 'virtualIP', 'type': 'str'},
        'internal_http_port': {'key': 'internalHttpPort', 'type': 'int'},
        'internal_https_port': {'key': 'internalHttpsPort', 'type': 'int'},
        'in_use': {'key': 'inUse', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualIPMapping, self).__init__(**kwargs)
        self.virtual_ip = kwargs.get('virtual_ip', None)
        self.internal_http_port = kwargs.get('internal_http_port', None)
        self.internal_https_port = kwargs.get('internal_https_port', None)
        self.in_use = kwargs.get('in_use', None)


class VirtualNetworkProfile(msrest.serialization.Model):
    """Specification for using a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource id of the Virtual Network.
    :type id: str
    :ivar name: Name of the Virtual Network (read-only).
    :vartype name: str
    :ivar type: Resource type of the Virtual Network (read-only).
    :vartype type: str
    :param subnet: Subnet within the Virtual Network.
    :type subnet: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkProfile, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.type = None
        self.subnet = kwargs.get('subnet', None)


class VnetGateway(ProxyOnlyResource):
    """The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_name: The Virtual Network name.
    :type vnet_name: str
    :param vpn_package_uri: The URI where the VPN package can be downloaded.
    :type vpn_package_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vpn_package_uri': {'key': 'properties.vpnPackageUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VnetGateway, self).__init__(**kwargs)
        self.vnet_name = kwargs.get('vnet_name', None)
        self.vpn_package_uri = kwargs.get('vpn_package_uri', None)


class VnetInfo(ProxyOnlyResource):
    """Virtual Network information contract.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_resource_id: The Virtual Network's resource ID.
    :type vnet_resource_id: str
    :ivar cert_thumbprint: The client certificate thumbprint.
    :vartype cert_thumbprint: str
    :param cert_blob: A certificate file (.cer) blob containing the public key of the private key
     used to authenticate a
     Point-To-Site VPN connection.
    :type cert_blob: bytearray
    :ivar routes: The routes that this Virtual Network connection uses.
    :vartype routes: list[~azure.mgmt.web.v2016_09_01.models.VnetRoute]
    :ivar resync_required: :code:`<code>true</code>` if a resync is required; otherwise,
     :code:`<code>false</code>`.
    :vartype resync_required: bool
    :param dns_servers: DNS servers to be used by this Virtual Network. This should be a
     comma-separated list of IP addresses.
    :type dns_servers: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'cert_thumbprint': {'readonly': True},
        'routes': {'readonly': True},
        'resync_required': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_resource_id': {'key': 'properties.vnetResourceId', 'type': 'str'},
        'cert_thumbprint': {'key': 'properties.certThumbprint', 'type': 'str'},
        'cert_blob': {'key': 'properties.certBlob', 'type': 'bytearray'},
        'routes': {'key': 'properties.routes', 'type': '[VnetRoute]'},
        'resync_required': {'key': 'properties.resyncRequired', 'type': 'bool'},
        'dns_servers': {'key': 'properties.dnsServers', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VnetInfo, self).__init__(**kwargs)
        self.vnet_resource_id = kwargs.get('vnet_resource_id', None)
        self.cert_thumbprint = None
        self.cert_blob = kwargs.get('cert_blob', None)
        self.routes = None
        self.resync_required = None
        self.dns_servers = kwargs.get('dns_servers', None)


class VnetRoute(ProxyOnlyResource):
    """Virtual Network route contract used to pass routing information for a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_route_name: The name of this route. This is only returned by the server and does
     not need to be set by the client.
    :type vnet_route_name: str
    :param start_address: The starting address for this route. This may also include a CIDR
     notation, in which case the end address must not be specified.
    :type start_address: str
    :param end_address: The ending address for this route. If the start address is specified in
     CIDR notation, this must be omitted.
    :type end_address: str
    :param route_type: The type of route this is:
     DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
     INHERITED - Routes inherited from the real Virtual Network routes
     STATIC - Static route set on the app only
    
     These values will be used for syncing an app's routes with those from a Virtual Network.
     Possible values include: "DEFAULT", "INHERITED", "STATIC".
    :type route_type: str or ~azure.mgmt.web.v2016_09_01.models.RouteType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_route_name': {'key': 'properties.name', 'type': 'str'},
        'start_address': {'key': 'properties.startAddress', 'type': 'str'},
        'end_address': {'key': 'properties.endAddress', 'type': 'str'},
        'route_type': {'key': 'properties.routeType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VnetRoute, self).__init__(**kwargs)
        self.vnet_route_name = kwargs.get('vnet_route_name', None)
        self.start_address = kwargs.get('start_address', None)
        self.end_address = kwargs.get('end_address', None)
        self.route_type = kwargs.get('route_type', None)


class WebAppCollection(msrest.serialization.Model):
    """Collection of App Service apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_09_01.models.Site]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Site]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebAppCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class WorkerPool(msrest.serialization.Model):
    """Worker pool of an App Service Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param worker_size_id: Worker size ID for referencing this worker pool.
    :type worker_size_id: int
    :param compute_mode: Shared or dedicated app hosting. Possible values include: "Shared",
     "Dedicated", "Dynamic".
    :type compute_mode: str or ~azure.mgmt.web.v2016_09_01.models.ComputeModeOptions
    :param worker_size: VM size of the worker pool instances.
    :type worker_size: str
    :param worker_count: Number of instances in the worker pool.
    :type worker_count: int
    :ivar instance_names: Names of all instances in the worker pool (read only).
    :vartype instance_names: list[str]
    """

    _validation = {
        'instance_names': {'readonly': True},
    }

    _attribute_map = {
        'worker_size_id': {'key': 'workerSizeId', 'type': 'int'},
        'compute_mode': {'key': 'computeMode', 'type': 'str'},
        'worker_size': {'key': 'workerSize', 'type': 'str'},
        'worker_count': {'key': 'workerCount', 'type': 'int'},
        'instance_names': {'key': 'instanceNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkerPool, self).__init__(**kwargs)
        self.worker_size_id = kwargs.get('worker_size_id', None)
        self.compute_mode = kwargs.get('compute_mode', None)
        self.worker_size = kwargs.get('worker_size', None)
        self.worker_count = kwargs.get('worker_count', None)
        self.instance_names = None


class WorkerPoolCollection(msrest.serialization.Model):
    """Collection of worker pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_09_01.models.WorkerPoolResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkerPoolResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkerPoolCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class WorkerPoolResource(ProxyOnlyResource):
    """Worker pool of an App Service Environment ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param sku: Description of a SKU for a scalable resource.
    :type sku: ~azure.mgmt.web.v2016_09_01.models.SkuDescription
    :param worker_size_id: Worker size ID for referencing this worker pool.
    :type worker_size_id: int
    :param compute_mode: Shared or dedicated app hosting. Possible values include: "Shared",
     "Dedicated", "Dynamic".
    :type compute_mode: str or ~azure.mgmt.web.v2016_09_01.models.ComputeModeOptions
    :param worker_size: VM size of the worker pool instances.
    :type worker_size: str
    :param worker_count: Number of instances in the worker pool.
    :type worker_count: int
    :ivar instance_names: Names of all instances in the worker pool (read only).
    :vartype instance_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'instance_names': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'worker_size_id': {'key': 'properties.workerSizeId', 'type': 'int'},
        'compute_mode': {'key': 'properties.computeMode', 'type': 'str'},
        'worker_size': {'key': 'properties.workerSize', 'type': 'str'},
        'worker_count': {'key': 'properties.workerCount', 'type': 'int'},
        'instance_names': {'key': 'properties.instanceNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkerPoolResource, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.worker_size_id = kwargs.get('worker_size_id', None)
        self.compute_mode = kwargs.get('compute_mode', None)
        self.worker_size = kwargs.get('worker_size', None)
        self.worker_count = kwargs.get('worker_count', None)
        self.instance_names = None
