# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, List, Optional, TypeVar, Union

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

class LogAnalyticsOperations(object):
    """LogAnalyticsOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.cdn.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    def get_log_analytics_metrics(
        self,
        resource_group_name,  # type: str
        profile_name,  # type: str
        metrics,  # type: List[Union[str, "_models.LogMetric"]]
        date_time_begin,  # type: datetime.datetime
        date_time_end,  # type: datetime.datetime
        granularity,  # type: Union[str, "_models.LogMetricsGranularity"]
        custom_domains,  # type: List[str]
        protocols,  # type: List[str]
        group_by=None,  # type: Optional[List[Union[str, "_models.LogMetricsGroupBy"]]]
        continents=None,  # type: Optional[List[str]]
        country_or_regions=None,  # type: Optional[List[str]]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.MetricsResponse"
        """Get log report for AFD profile.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the CDN profile which is unique within the resource group.
        :type profile_name: str
        :param metrics:
        :type metrics: list[str or ~azure.mgmt.cdn.models.LogMetric]
        :param date_time_begin:
        :type date_time_begin: ~datetime.datetime
        :param date_time_end:
        :type date_time_end: ~datetime.datetime
        :param granularity:
        :type granularity: str or ~azure.mgmt.cdn.models.LogMetricsGranularity
        :param custom_domains:
        :type custom_domains: list[str]
        :param protocols:
        :type protocols: list[str]
        :param group_by:
        :type group_by: list[str or ~azure.mgmt.cdn.models.LogMetricsGroupBy]
        :param continents:
        :type continents: list[str]
        :param country_or_regions:
        :type country_or_regions: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: MetricsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.MetricsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.MetricsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-09-01"
        accept = "application/json"

        # Construct URL
        url = self.get_log_analytics_metrics.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'profileName': self._serialize.url("profile_name", profile_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['metrics'] = [self._serialize.query("metrics", q, 'str') if q is not None else '' for q in metrics]
        query_parameters['dateTimeBegin'] = self._serialize.query("date_time_begin", date_time_begin, 'iso-8601')
        query_parameters['dateTimeEnd'] = self._serialize.query("date_time_end", date_time_end, 'iso-8601')
        query_parameters['granularity'] = self._serialize.query("granularity", granularity, 'str')
        if group_by is not None:
            query_parameters['groupBy'] = [self._serialize.query("group_by", q, 'str') if q is not None else '' for q in group_by]
        if continents is not None:
            query_parameters['continents'] = [self._serialize.query("continents", q, 'str') if q is not None else '' for q in continents]
        if country_or_regions is not None:
            query_parameters['countryOrRegions'] = [self._serialize.query("country_or_regions", q, 'str') if q is not None else '' for q in country_or_regions]
        query_parameters['customDomains'] = [self._serialize.query("custom_domains", q, 'str') if q is not None else '' for q in custom_domains]
        query_parameters['protocols'] = [self._serialize.query("protocols", q, 'str') if q is not None else '' for q in protocols]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.AfdErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('MetricsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_log_analytics_metrics.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsMetrics'}  # type: ignore

    def get_log_analytics_rankings(
        self,
        resource_group_name,  # type: str
        profile_name,  # type: str
        rankings,  # type: List[Union[str, "_models.LogRanking"]]
        metrics,  # type: List[Union[str, "_models.LogRankingMetric"]]
        max_ranking,  # type: int
        date_time_begin,  # type: datetime.datetime
        date_time_end,  # type: datetime.datetime
        custom_domains=None,  # type: Optional[List[str]]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.RankingsResponse"
        """Get log analytics ranking report for AFD profile.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the CDN profile which is unique within the resource group.
        :type profile_name: str
        :param rankings:
        :type rankings: list[str or ~azure.mgmt.cdn.models.LogRanking]
        :param metrics:
        :type metrics: list[str or ~azure.mgmt.cdn.models.LogRankingMetric]
        :param max_ranking:
        :type max_ranking: int
        :param date_time_begin:
        :type date_time_begin: ~datetime.datetime
        :param date_time_end:
        :type date_time_end: ~datetime.datetime
        :param custom_domains:
        :type custom_domains: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RankingsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.RankingsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RankingsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-09-01"
        accept = "application/json"

        # Construct URL
        url = self.get_log_analytics_rankings.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'profileName': self._serialize.url("profile_name", profile_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['rankings'] = [self._serialize.query("rankings", q, 'str') if q is not None else '' for q in rankings]
        query_parameters['metrics'] = [self._serialize.query("metrics", q, 'str') if q is not None else '' for q in metrics]
        query_parameters['maxRanking'] = self._serialize.query("max_ranking", max_ranking, 'int')
        query_parameters['dateTimeBegin'] = self._serialize.query("date_time_begin", date_time_begin, 'iso-8601')
        query_parameters['dateTimeEnd'] = self._serialize.query("date_time_end", date_time_end, 'iso-8601')
        if custom_domains is not None:
            query_parameters['customDomains'] = [self._serialize.query("custom_domains", q, 'str') if q is not None else '' for q in custom_domains]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.AfdErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('RankingsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_log_analytics_rankings.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsRankings'}  # type: ignore

    def get_log_analytics_locations(
        self,
        resource_group_name,  # type: str
        profile_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ContinentsResponse"
        """Get all available location names for AFD log analytics report.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the CDN profile which is unique within the resource group.
        :type profile_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ContinentsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.ContinentsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ContinentsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-09-01"
        accept = "application/json"

        # Construct URL
        url = self.get_log_analytics_locations.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'profileName': self._serialize.url("profile_name", profile_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.AfdErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ContinentsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_log_analytics_locations.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsLocations'}  # type: ignore

    def get_log_analytics_resources(
        self,
        resource_group_name,  # type: str
        profile_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ResourcesResponse"
        """Get all endpoints and custom domains available for AFD log report.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the CDN profile which is unique within the resource group.
        :type profile_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourcesResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.ResourcesResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ResourcesResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-09-01"
        accept = "application/json"

        # Construct URL
        url = self.get_log_analytics_resources.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'profileName': self._serialize.url("profile_name", profile_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.AfdErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ResourcesResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_log_analytics_resources.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsResources'}  # type: ignore

    def get_waf_log_analytics_metrics(
        self,
        resource_group_name,  # type: str
        profile_name,  # type: str
        metrics,  # type: List[Union[str, "_models.WafMetric"]]
        date_time_begin,  # type: datetime.datetime
        date_time_end,  # type: datetime.datetime
        granularity,  # type: Union[str, "_models.WafGranularity"]
        actions=None,  # type: Optional[List[Union[str, "_models.WafAction"]]]
        group_by=None,  # type: Optional[List[Union[str, "_models.WafRankingGroupBy"]]]
        rule_types=None,  # type: Optional[List[Union[str, "_models.WafRuleType"]]]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.WafMetricsResponse"
        """Get Waf related log analytics report for AFD profile.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the CDN profile which is unique within the resource group.
        :type profile_name: str
        :param metrics:
        :type metrics: list[str or ~azure.mgmt.cdn.models.WafMetric]
        :param date_time_begin:
        :type date_time_begin: ~datetime.datetime
        :param date_time_end:
        :type date_time_end: ~datetime.datetime
        :param granularity:
        :type granularity: str or ~azure.mgmt.cdn.models.WafGranularity
        :param actions:
        :type actions: list[str or ~azure.mgmt.cdn.models.WafAction]
        :param group_by:
        :type group_by: list[str or ~azure.mgmt.cdn.models.WafRankingGroupBy]
        :param rule_types:
        :type rule_types: list[str or ~azure.mgmt.cdn.models.WafRuleType]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WafMetricsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.WafMetricsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.WafMetricsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-09-01"
        accept = "application/json"

        # Construct URL
        url = self.get_waf_log_analytics_metrics.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'profileName': self._serialize.url("profile_name", profile_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['metrics'] = [self._serialize.query("metrics", q, 'str') if q is not None else '' for q in metrics]
        query_parameters['dateTimeBegin'] = self._serialize.query("date_time_begin", date_time_begin, 'iso-8601')
        query_parameters['dateTimeEnd'] = self._serialize.query("date_time_end", date_time_end, 'iso-8601')
        query_parameters['granularity'] = self._serialize.query("granularity", granularity, 'str')
        if actions is not None:
            query_parameters['actions'] = [self._serialize.query("actions", q, 'str') if q is not None else '' for q in actions]
        if group_by is not None:
            query_parameters['groupBy'] = [self._serialize.query("group_by", q, 'str') if q is not None else '' for q in group_by]
        if rule_types is not None:
            query_parameters['ruleTypes'] = [self._serialize.query("rule_types", q, 'str') if q is not None else '' for q in rule_types]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.AfdErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('WafMetricsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_waf_log_analytics_metrics.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getWafLogAnalyticsMetrics'}  # type: ignore

    def get_waf_log_analytics_rankings(
        self,
        resource_group_name,  # type: str
        profile_name,  # type: str
        metrics,  # type: List[Union[str, "_models.WafMetric"]]
        date_time_begin,  # type: datetime.datetime
        date_time_end,  # type: datetime.datetime
        max_ranking,  # type: int
        rankings,  # type: List[Union[str, "_models.WafRankingType"]]
        actions=None,  # type: Optional[List[Union[str, "_models.WafAction"]]]
        rule_types=None,  # type: Optional[List[Union[str, "_models.WafRuleType"]]]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.WafRankingsResponse"
        """Get WAF log analytics charts for AFD profile.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the CDN profile which is unique within the resource group.
        :type profile_name: str
        :param metrics:
        :type metrics: list[str or ~azure.mgmt.cdn.models.WafMetric]
        :param date_time_begin:
        :type date_time_begin: ~datetime.datetime
        :param date_time_end:
        :type date_time_end: ~datetime.datetime
        :param max_ranking:
        :type max_ranking: int
        :param rankings:
        :type rankings: list[str or ~azure.mgmt.cdn.models.WafRankingType]
        :param actions:
        :type actions: list[str or ~azure.mgmt.cdn.models.WafAction]
        :param rule_types:
        :type rule_types: list[str or ~azure.mgmt.cdn.models.WafRuleType]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WafRankingsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.WafRankingsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.WafRankingsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-09-01"
        accept = "application/json"

        # Construct URL
        url = self.get_waf_log_analytics_rankings.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'profileName': self._serialize.url("profile_name", profile_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['metrics'] = [self._serialize.query("metrics", q, 'str') if q is not None else '' for q in metrics]
        query_parameters['dateTimeBegin'] = self._serialize.query("date_time_begin", date_time_begin, 'iso-8601')
        query_parameters['dateTimeEnd'] = self._serialize.query("date_time_end", date_time_end, 'iso-8601')
        query_parameters['maxRanking'] = self._serialize.query("max_ranking", max_ranking, 'int')
        query_parameters['rankings'] = [self._serialize.query("rankings", q, 'str') if q is not None else '' for q in rankings]
        if actions is not None:
            query_parameters['actions'] = [self._serialize.query("actions", q, 'str') if q is not None else '' for q in actions]
        if rule_types is not None:
            query_parameters['ruleTypes'] = [self._serialize.query("rule_types", q, 'str') if q is not None else '' for q in rule_types]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.AfdErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('WafRankingsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_waf_log_analytics_rankings.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getWafLogAnalyticsRankings'}  # type: ignore
