/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.xact.Xact;

final class XactContext
extends ContextImpl {
    private RawTransaction xact;
    private RawStoreFactory factory;
    private boolean abortAll;

    XactContext(ContextManager contextManager, String string, Xact xact, boolean bl, RawStoreFactory rawStoreFactory) {
        super(contextManager, string);
        this.xact = xact;
        this.abortAll = bl;
        this.factory = rawStoreFactory;
        xact.xc = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupOnError(Throwable throwable) throws StandardException {
        boolean bl = false;
        if (throwable instanceof StandardException) {
            StandardException standardException = (StandardException)throwable;
            if (this.abortAll) {
                if (standardException.getSeverity() < 30000) {
                    throw StandardException.newException("40XT5", throwable);
                }
                bl = true;
            } else {
                if (standardException.getSeverity() < 30000) {
                    return;
                }
                if (standardException.getSeverity() >= 40000) {
                    bl = true;
                }
            }
        } else {
            bl = true;
        }
        try {
            if (this.xact != null) {
                this.xact.abort();
            }
        }
        catch (StandardException standardException) {
            bl = true;
            if (standardException.getSeverity() <= 40000 && standardException.getSeverity() >= ((StandardException)throwable).getSeverity()) {
                throw this.factory.markCorrupt(StandardException.newException("XSTB0.M", standardException));
            }
        }
        finally {
            if (bl) {
                this.xact.close();
                this.xact = null;
            }
        }
    }

    RawTransaction getTransaction() {
        return this.xact;
    }

    RawStoreFactory getFactory() {
        return this.factory;
    }

    void substituteTransaction(Xact xact) {
        Xact xact2 = (Xact)this.xact;
        if (xact2.xc == this) {
            xact2.xc = null;
        }
        this.xact = xact;
        ((Xact)this.xact).xc = this;
    }
}

