/* This file is autogenerated by scripts/decodetree.py.  */

typedef struct {
    int aq;
    int rd;
    int rl;
    int rs1;
    int rs2;
} arg_atomic;

typedef struct {
    int imm;
    int rs1;
    int rs2;
} arg_b;

typedef struct {
    int rd;
    int rm;
    int rs1;
    int rs2;
    int rs3;
} arg_decode_insn3210;

typedef struct {
    int rd;
    int rm;
    int rs1;
    int rs2;
} arg_decode_insn3211;

typedef struct {
    int rd;
    int rm;
    int rs1;
} arg_decode_insn3212;

typedef struct {
    int rd;
    int rs1;
} arg_decode_insn3213;

typedef struct {
    int rs1;
    int rs2;
} arg_decode_insn3214;

typedef struct {
    int rs1;
} arg_decode_insn3215;

typedef struct {
    int pred;
    int succ;
} arg_decode_insn3216;

typedef struct {
    int csr;
    int rd;
    int rs1;
} arg_decode_insn329;

typedef struct {
#ifdef _MSC_VER
    int dummy;  // MSVC does not allow empty struct
#endif
} arg_empty;

typedef struct {
    int imm;
    int rd;
    int rs1;
} arg_i;

typedef struct {
    int imm;
    int rd;
} arg_j;

typedef struct {
    int rd;
    int rs1;
    int rs2;
} arg_r;

typedef struct {
    int imm;
    int rs1;
    int rs2;
} arg_s;

typedef struct {
    int rd;
    int rs1;
    int shamt;
} arg_shift;

typedef struct {
    int imm;
    int rd;
} arg_u;

typedef arg_empty arg_ecall;
static bool trans_ecall(DisasContext *ctx, arg_ecall *a);
typedef arg_empty arg_ebreak;
static bool trans_ebreak(DisasContext *ctx, arg_ebreak *a);
typedef arg_empty arg_uret;
static bool trans_uret(DisasContext *ctx, arg_uret *a);
typedef arg_empty arg_sret;
static bool trans_sret(DisasContext *ctx, arg_sret *a);
typedef arg_empty arg_mret;
static bool trans_mret(DisasContext *ctx, arg_mret *a);
typedef arg_empty arg_wfi;
static bool trans_wfi(DisasContext *ctx, arg_wfi *a);
typedef arg_decode_insn3214 arg_hfence_gvma;
static bool trans_hfence_gvma(DisasContext *ctx, arg_hfence_gvma *a);
typedef arg_decode_insn3214 arg_hfence_bvma;
static bool trans_hfence_bvma(DisasContext *ctx, arg_hfence_bvma *a);
typedef arg_decode_insn3214 arg_sfence_vma;
static bool trans_sfence_vma(DisasContext *ctx, arg_sfence_vma *a);
typedef arg_decode_insn3215 arg_sfence_vm;
static bool trans_sfence_vm(DisasContext *ctx, arg_sfence_vm *a);
typedef arg_u arg_lui;
static bool trans_lui(DisasContext *ctx, arg_lui *a);
typedef arg_u arg_auipc;
static bool trans_auipc(DisasContext *ctx, arg_auipc *a);
typedef arg_j arg_jal;
static bool trans_jal(DisasContext *ctx, arg_jal *a);
typedef arg_i arg_jalr;
static bool trans_jalr(DisasContext *ctx, arg_jalr *a);
typedef arg_b arg_beq;
static bool trans_beq(DisasContext *ctx, arg_beq *a);
typedef arg_b arg_bne;
static bool trans_bne(DisasContext *ctx, arg_bne *a);
typedef arg_b arg_blt;
static bool trans_blt(DisasContext *ctx, arg_blt *a);
typedef arg_b arg_bge;
static bool trans_bge(DisasContext *ctx, arg_bge *a);
typedef arg_b arg_bltu;
static bool trans_bltu(DisasContext *ctx, arg_bltu *a);
typedef arg_b arg_bgeu;
static bool trans_bgeu(DisasContext *ctx, arg_bgeu *a);
typedef arg_i arg_lb;
static bool trans_lb(DisasContext *ctx, arg_lb *a);
typedef arg_i arg_lh;
static bool trans_lh(DisasContext *ctx, arg_lh *a);
typedef arg_i arg_lw;
static bool trans_lw(DisasContext *ctx, arg_lw *a);
typedef arg_i arg_lbu;
static bool trans_lbu(DisasContext *ctx, arg_lbu *a);
typedef arg_i arg_lhu;
static bool trans_lhu(DisasContext *ctx, arg_lhu *a);
typedef arg_s arg_sb;
static bool trans_sb(DisasContext *ctx, arg_sb *a);
typedef arg_s arg_sh;
static bool trans_sh(DisasContext *ctx, arg_sh *a);
typedef arg_s arg_sw;
static bool trans_sw(DisasContext *ctx, arg_sw *a);
typedef arg_i arg_addi;
static bool trans_addi(DisasContext *ctx, arg_addi *a);
typedef arg_i arg_slti;
static bool trans_slti(DisasContext *ctx, arg_slti *a);
typedef arg_i arg_sltiu;
static bool trans_sltiu(DisasContext *ctx, arg_sltiu *a);
typedef arg_i arg_xori;
static bool trans_xori(DisasContext *ctx, arg_xori *a);
typedef arg_i arg_ori;
static bool trans_ori(DisasContext *ctx, arg_ori *a);
typedef arg_i arg_andi;
static bool trans_andi(DisasContext *ctx, arg_andi *a);
typedef arg_shift arg_slli;
static bool trans_slli(DisasContext *ctx, arg_slli *a);
typedef arg_shift arg_srli;
static bool trans_srli(DisasContext *ctx, arg_srli *a);
typedef arg_shift arg_srai;
static bool trans_srai(DisasContext *ctx, arg_srai *a);
typedef arg_r arg_add;
static bool trans_add(DisasContext *ctx, arg_add *a);
typedef arg_r arg_sub;
static bool trans_sub(DisasContext *ctx, arg_sub *a);
typedef arg_r arg_sll;
static bool trans_sll(DisasContext *ctx, arg_sll *a);
typedef arg_r arg_slt;
static bool trans_slt(DisasContext *ctx, arg_slt *a);
typedef arg_r arg_sltu;
static bool trans_sltu(DisasContext *ctx, arg_sltu *a);
typedef arg_r arg_xor;
static bool trans_xor(DisasContext *ctx, arg_xor *a);
typedef arg_r arg_srl;
static bool trans_srl(DisasContext *ctx, arg_srl *a);
typedef arg_r arg_sra;
static bool trans_sra(DisasContext *ctx, arg_sra *a);
typedef arg_r arg_or;
static bool trans_or(DisasContext *ctx, arg_or *a);
typedef arg_r arg_and;
static bool trans_and(DisasContext *ctx, arg_and *a);
typedef arg_decode_insn3216 arg_fence;
static bool trans_fence(DisasContext *ctx, arg_fence *a);
typedef arg_empty arg_fence_i;
static bool trans_fence_i(DisasContext *ctx, arg_fence_i *a);
typedef arg_decode_insn329 arg_csrrw;
static bool trans_csrrw(DisasContext *ctx, arg_csrrw *a);
typedef arg_decode_insn329 arg_csrrs;
static bool trans_csrrs(DisasContext *ctx, arg_csrrs *a);
typedef arg_decode_insn329 arg_csrrc;
static bool trans_csrrc(DisasContext *ctx, arg_csrrc *a);
typedef arg_decode_insn329 arg_csrrwi;
static bool trans_csrrwi(DisasContext *ctx, arg_csrrwi *a);
typedef arg_decode_insn329 arg_csrrsi;
static bool trans_csrrsi(DisasContext *ctx, arg_csrrsi *a);
typedef arg_decode_insn329 arg_csrrci;
static bool trans_csrrci(DisasContext *ctx, arg_csrrci *a);
typedef arg_r arg_mul;
static bool trans_mul(DisasContext *ctx, arg_mul *a);
typedef arg_r arg_mulh;
static bool trans_mulh(DisasContext *ctx, arg_mulh *a);
typedef arg_r arg_mulhsu;
static bool trans_mulhsu(DisasContext *ctx, arg_mulhsu *a);
typedef arg_r arg_mulhu;
static bool trans_mulhu(DisasContext *ctx, arg_mulhu *a);
typedef arg_r arg_div;
static bool trans_div(DisasContext *ctx, arg_div *a);
typedef arg_r arg_divu;
static bool trans_divu(DisasContext *ctx, arg_divu *a);
typedef arg_r arg_rem;
static bool trans_rem(DisasContext *ctx, arg_rem *a);
typedef arg_r arg_remu;
static bool trans_remu(DisasContext *ctx, arg_remu *a);
typedef arg_atomic arg_lr_w;
static bool trans_lr_w(DisasContext *ctx, arg_lr_w *a);
typedef arg_atomic arg_sc_w;
static bool trans_sc_w(DisasContext *ctx, arg_sc_w *a);
typedef arg_atomic arg_amoswap_w;
static bool trans_amoswap_w(DisasContext *ctx, arg_amoswap_w *a);
typedef arg_atomic arg_amoadd_w;
static bool trans_amoadd_w(DisasContext *ctx, arg_amoadd_w *a);
typedef arg_atomic arg_amoxor_w;
static bool trans_amoxor_w(DisasContext *ctx, arg_amoxor_w *a);
typedef arg_atomic arg_amoand_w;
static bool trans_amoand_w(DisasContext *ctx, arg_amoand_w *a);
typedef arg_atomic arg_amoor_w;
static bool trans_amoor_w(DisasContext *ctx, arg_amoor_w *a);
typedef arg_atomic arg_amomin_w;
static bool trans_amomin_w(DisasContext *ctx, arg_amomin_w *a);
typedef arg_atomic arg_amomax_w;
static bool trans_amomax_w(DisasContext *ctx, arg_amomax_w *a);
typedef arg_atomic arg_amominu_w;
static bool trans_amominu_w(DisasContext *ctx, arg_amominu_w *a);
typedef arg_atomic arg_amomaxu_w;
static bool trans_amomaxu_w(DisasContext *ctx, arg_amomaxu_w *a);
typedef arg_i arg_flw;
static bool trans_flw(DisasContext *ctx, arg_flw *a);
typedef arg_s arg_fsw;
static bool trans_fsw(DisasContext *ctx, arg_fsw *a);
typedef arg_decode_insn3210 arg_fmadd_s;
static bool trans_fmadd_s(DisasContext *ctx, arg_fmadd_s *a);
typedef arg_decode_insn3210 arg_fmsub_s;
static bool trans_fmsub_s(DisasContext *ctx, arg_fmsub_s *a);
typedef arg_decode_insn3210 arg_fnmsub_s;
static bool trans_fnmsub_s(DisasContext *ctx, arg_fnmsub_s *a);
typedef arg_decode_insn3210 arg_fnmadd_s;
static bool trans_fnmadd_s(DisasContext *ctx, arg_fnmadd_s *a);
typedef arg_decode_insn3211 arg_fadd_s;
static bool trans_fadd_s(DisasContext *ctx, arg_fadd_s *a);
typedef arg_decode_insn3211 arg_fsub_s;
static bool trans_fsub_s(DisasContext *ctx, arg_fsub_s *a);
typedef arg_decode_insn3211 arg_fmul_s;
static bool trans_fmul_s(DisasContext *ctx, arg_fmul_s *a);
typedef arg_decode_insn3211 arg_fdiv_s;
static bool trans_fdiv_s(DisasContext *ctx, arg_fdiv_s *a);
typedef arg_decode_insn3212 arg_fsqrt_s;
static bool trans_fsqrt_s(DisasContext *ctx, arg_fsqrt_s *a);
typedef arg_r arg_fsgnj_s;
static bool trans_fsgnj_s(DisasContext *ctx, arg_fsgnj_s *a);
typedef arg_r arg_fsgnjn_s;
static bool trans_fsgnjn_s(DisasContext *ctx, arg_fsgnjn_s *a);
typedef arg_r arg_fsgnjx_s;
static bool trans_fsgnjx_s(DisasContext *ctx, arg_fsgnjx_s *a);
typedef arg_r arg_fmin_s;
static bool trans_fmin_s(DisasContext *ctx, arg_fmin_s *a);
typedef arg_r arg_fmax_s;
static bool trans_fmax_s(DisasContext *ctx, arg_fmax_s *a);
typedef arg_decode_insn3212 arg_fcvt_w_s;
static bool trans_fcvt_w_s(DisasContext *ctx, arg_fcvt_w_s *a);
typedef arg_decode_insn3212 arg_fcvt_wu_s;
static bool trans_fcvt_wu_s(DisasContext *ctx, arg_fcvt_wu_s *a);
typedef arg_decode_insn3213 arg_fmv_x_w;
static bool trans_fmv_x_w(DisasContext *ctx, arg_fmv_x_w *a);
typedef arg_r arg_feq_s;
static bool trans_feq_s(DisasContext *ctx, arg_feq_s *a);
typedef arg_r arg_flt_s;
static bool trans_flt_s(DisasContext *ctx, arg_flt_s *a);
typedef arg_r arg_fle_s;
static bool trans_fle_s(DisasContext *ctx, arg_fle_s *a);
typedef arg_decode_insn3213 arg_fclass_s;
static bool trans_fclass_s(DisasContext *ctx, arg_fclass_s *a);
typedef arg_decode_insn3212 arg_fcvt_s_w;
static bool trans_fcvt_s_w(DisasContext *ctx, arg_fcvt_s_w *a);
typedef arg_decode_insn3212 arg_fcvt_s_wu;
static bool trans_fcvt_s_wu(DisasContext *ctx, arg_fcvt_s_wu *a);
typedef arg_decode_insn3213 arg_fmv_w_x;
static bool trans_fmv_w_x(DisasContext *ctx, arg_fmv_w_x *a);
typedef arg_i arg_fld;
static bool trans_fld(DisasContext *ctx, arg_fld *a);
typedef arg_s arg_fsd;
static bool trans_fsd(DisasContext *ctx, arg_fsd *a);
typedef arg_decode_insn3210 arg_fmadd_d;
static bool trans_fmadd_d(DisasContext *ctx, arg_fmadd_d *a);
typedef arg_decode_insn3210 arg_fmsub_d;
static bool trans_fmsub_d(DisasContext *ctx, arg_fmsub_d *a);
typedef arg_decode_insn3210 arg_fnmsub_d;
static bool trans_fnmsub_d(DisasContext *ctx, arg_fnmsub_d *a);
typedef arg_decode_insn3210 arg_fnmadd_d;
static bool trans_fnmadd_d(DisasContext *ctx, arg_fnmadd_d *a);
typedef arg_decode_insn3211 arg_fadd_d;
static bool trans_fadd_d(DisasContext *ctx, arg_fadd_d *a);
typedef arg_decode_insn3211 arg_fsub_d;
static bool trans_fsub_d(DisasContext *ctx, arg_fsub_d *a);
typedef arg_decode_insn3211 arg_fmul_d;
static bool trans_fmul_d(DisasContext *ctx, arg_fmul_d *a);
typedef arg_decode_insn3211 arg_fdiv_d;
static bool trans_fdiv_d(DisasContext *ctx, arg_fdiv_d *a);
typedef arg_decode_insn3212 arg_fsqrt_d;
static bool trans_fsqrt_d(DisasContext *ctx, arg_fsqrt_d *a);
typedef arg_r arg_fsgnj_d;
static bool trans_fsgnj_d(DisasContext *ctx, arg_fsgnj_d *a);
typedef arg_r arg_fsgnjn_d;
static bool trans_fsgnjn_d(DisasContext *ctx, arg_fsgnjn_d *a);
typedef arg_r arg_fsgnjx_d;
static bool trans_fsgnjx_d(DisasContext *ctx, arg_fsgnjx_d *a);
typedef arg_r arg_fmin_d;
static bool trans_fmin_d(DisasContext *ctx, arg_fmin_d *a);
typedef arg_r arg_fmax_d;
static bool trans_fmax_d(DisasContext *ctx, arg_fmax_d *a);
typedef arg_decode_insn3212 arg_fcvt_s_d;
static bool trans_fcvt_s_d(DisasContext *ctx, arg_fcvt_s_d *a);
typedef arg_decode_insn3212 arg_fcvt_d_s;
static bool trans_fcvt_d_s(DisasContext *ctx, arg_fcvt_d_s *a);
typedef arg_r arg_feq_d;
static bool trans_feq_d(DisasContext *ctx, arg_feq_d *a);
typedef arg_r arg_flt_d;
static bool trans_flt_d(DisasContext *ctx, arg_flt_d *a);
typedef arg_r arg_fle_d;
static bool trans_fle_d(DisasContext *ctx, arg_fle_d *a);
typedef arg_decode_insn3213 arg_fclass_d;
static bool trans_fclass_d(DisasContext *ctx, arg_fclass_d *a);
typedef arg_decode_insn3212 arg_fcvt_w_d;
static bool trans_fcvt_w_d(DisasContext *ctx, arg_fcvt_w_d *a);
typedef arg_decode_insn3212 arg_fcvt_wu_d;
static bool trans_fcvt_wu_d(DisasContext *ctx, arg_fcvt_wu_d *a);
typedef arg_decode_insn3212 arg_fcvt_d_w;
static bool trans_fcvt_d_w(DisasContext *ctx, arg_fcvt_d_w *a);
typedef arg_decode_insn3212 arg_fcvt_d_wu;
static bool trans_fcvt_d_wu(DisasContext *ctx, arg_fcvt_d_wu *a);
typedef arg_i arg_lwu;
static bool trans_lwu(DisasContext *ctx, arg_lwu *a);
typedef arg_i arg_ld;
static bool trans_ld(DisasContext *ctx, arg_ld *a);
typedef arg_s arg_sd;
static bool trans_sd(DisasContext *ctx, arg_sd *a);
typedef arg_i arg_addiw;
static bool trans_addiw(DisasContext *ctx, arg_addiw *a);
typedef arg_shift arg_slliw;
static bool trans_slliw(DisasContext *ctx, arg_slliw *a);
typedef arg_shift arg_srliw;
static bool trans_srliw(DisasContext *ctx, arg_srliw *a);
typedef arg_shift arg_sraiw;
static bool trans_sraiw(DisasContext *ctx, arg_sraiw *a);
typedef arg_r arg_addw;
static bool trans_addw(DisasContext *ctx, arg_addw *a);
typedef arg_r arg_subw;
static bool trans_subw(DisasContext *ctx, arg_subw *a);
typedef arg_r arg_sllw;
static bool trans_sllw(DisasContext *ctx, arg_sllw *a);
typedef arg_r arg_srlw;
static bool trans_srlw(DisasContext *ctx, arg_srlw *a);
typedef arg_r arg_sraw;
static bool trans_sraw(DisasContext *ctx, arg_sraw *a);
typedef arg_r arg_mulw;
static bool trans_mulw(DisasContext *ctx, arg_mulw *a);
typedef arg_r arg_divw;
static bool trans_divw(DisasContext *ctx, arg_divw *a);
typedef arg_r arg_divuw;
static bool trans_divuw(DisasContext *ctx, arg_divuw *a);
typedef arg_r arg_remw;
static bool trans_remw(DisasContext *ctx, arg_remw *a);
typedef arg_r arg_remuw;
static bool trans_remuw(DisasContext *ctx, arg_remuw *a);
typedef arg_atomic arg_lr_d;
static bool trans_lr_d(DisasContext *ctx, arg_lr_d *a);
typedef arg_atomic arg_sc_d;
static bool trans_sc_d(DisasContext *ctx, arg_sc_d *a);
typedef arg_atomic arg_amoswap_d;
static bool trans_amoswap_d(DisasContext *ctx, arg_amoswap_d *a);
typedef arg_atomic arg_amoadd_d;
static bool trans_amoadd_d(DisasContext *ctx, arg_amoadd_d *a);
typedef arg_atomic arg_amoxor_d;
static bool trans_amoxor_d(DisasContext *ctx, arg_amoxor_d *a);
typedef arg_atomic arg_amoand_d;
static bool trans_amoand_d(DisasContext *ctx, arg_amoand_d *a);
typedef arg_atomic arg_amoor_d;
static bool trans_amoor_d(DisasContext *ctx, arg_amoor_d *a);
typedef arg_atomic arg_amomin_d;
static bool trans_amomin_d(DisasContext *ctx, arg_amomin_d *a);
typedef arg_atomic arg_amomax_d;
static bool trans_amomax_d(DisasContext *ctx, arg_amomax_d *a);
typedef arg_atomic arg_amominu_d;
static bool trans_amominu_d(DisasContext *ctx, arg_amominu_d *a);
typedef arg_atomic arg_amomaxu_d;
static bool trans_amomaxu_d(DisasContext *ctx, arg_amomaxu_d *a);
typedef arg_decode_insn3212 arg_fcvt_l_s;
static bool trans_fcvt_l_s(DisasContext *ctx, arg_fcvt_l_s *a);
typedef arg_decode_insn3212 arg_fcvt_lu_s;
static bool trans_fcvt_lu_s(DisasContext *ctx, arg_fcvt_lu_s *a);
typedef arg_decode_insn3212 arg_fcvt_s_l;
static bool trans_fcvt_s_l(DisasContext *ctx, arg_fcvt_s_l *a);
typedef arg_decode_insn3212 arg_fcvt_s_lu;
static bool trans_fcvt_s_lu(DisasContext *ctx, arg_fcvt_s_lu *a);
typedef arg_decode_insn3212 arg_fcvt_l_d;
static bool trans_fcvt_l_d(DisasContext *ctx, arg_fcvt_l_d *a);
typedef arg_decode_insn3212 arg_fcvt_lu_d;
static bool trans_fcvt_lu_d(DisasContext *ctx, arg_fcvt_lu_d *a);
typedef arg_decode_insn3213 arg_fmv_x_d;
static bool trans_fmv_x_d(DisasContext *ctx, arg_fmv_x_d *a);
typedef arg_decode_insn3212 arg_fcvt_d_l;
static bool trans_fcvt_d_l(DisasContext *ctx, arg_fcvt_d_l *a);
typedef arg_decode_insn3212 arg_fcvt_d_lu;
static bool trans_fcvt_d_lu(DisasContext *ctx, arg_fcvt_d_lu *a);
typedef arg_decode_insn3213 arg_fmv_d_x;
static bool trans_fmv_d_x(DisasContext *ctx, arg_fmv_d_x *a);

static void decode_insn32_extract_atom_ld(DisasContext *ctx, arg_atomic *a, uint32_t insn)
{
    a->aq = extract32(insn, 26, 1);
    a->rl = extract32(insn, 25, 1);
    a->rs2 = 0;
    a->rs1 = extract32(insn, 15, 5);
    a->rd = extract32(insn, 7, 5);
}

static void decode_insn32_extract_atom_st(DisasContext *ctx, arg_atomic *a, uint32_t insn)
{
    a->aq = extract32(insn, 26, 1);
    a->rl = extract32(insn, 25, 1);
    a->rs2 = extract32(insn, 20, 5);
    a->rs1 = extract32(insn, 15, 5);
    a->rd = extract32(insn, 7, 5);
}

static void decode_insn32_extract_b(DisasContext *ctx, arg_b *a, uint32_t insn)
{
    a->imm = ex_shift_1(ctx, deposit32(deposit32(deposit32(extract32(insn, 8, 4), 4, 28, extract32(insn, 25, 6)), 10, 22, extract32(insn, 7, 1)), 11, 21, sextract32(insn, 31, 1)));
    a->rs2 = extract32(insn, 20, 5);
    a->rs1 = extract32(insn, 15, 5);
}

static void decode_insn32_extract_csr(DisasContext *ctx, arg_decode_insn329 *a, uint32_t insn)
{
    a->csr = extract32(insn, 20, 12);
    a->rs1 = extract32(insn, 15, 5);
    a->rd = extract32(insn, 7, 5);
}

static void decode_insn32_extract_decode_insn32_Fmt_18(DisasContext *ctx, arg_empty *a, uint32_t insn)
{
}

static void decode_insn32_extract_decode_insn32_Fmt_19(DisasContext *ctx, arg_decode_insn3216 *a, uint32_t insn)
{
    a->pred = extract32(insn, 24, 4);
    a->succ = extract32(insn, 20, 4);
}

static void decode_insn32_extract_hfence_bvma(DisasContext *ctx, arg_decode_insn3214 *a, uint32_t insn)
{
    a->rs2 = extract32(insn, 20, 5);
    a->rs1 = extract32(insn, 15, 5);
}

static void decode_insn32_extract_hfence_gvma(DisasContext *ctx, arg_decode_insn3214 *a, uint32_t insn)
{
    a->rs2 = extract32(insn, 20, 5);
    a->rs1 = extract32(insn, 15, 5);
}

static void decode_insn32_extract_i(DisasContext *ctx, arg_i *a, uint32_t insn)
{
    a->imm = sextract32(insn, 20, 12);
    a->rs1 = extract32(insn, 15, 5);
    a->rd = extract32(insn, 7, 5);
}

static void decode_insn32_extract_j(DisasContext *ctx, arg_j *a, uint32_t insn)
{
    a->imm = ex_shift_1(ctx, deposit32(deposit32(deposit32(extract32(insn, 21, 10), 10, 22, extract32(insn, 20, 1)), 11, 21, extract32(insn, 12, 8)), 19, 13, sextract32(insn, 31, 1)));
    a->rd = extract32(insn, 7, 5);
}

static void decode_insn32_extract_r(DisasContext *ctx, arg_r *a, uint32_t insn)
{
    a->rs2 = extract32(insn, 20, 5);
    a->rs1 = extract32(insn, 15, 5);
    a->rd = extract32(insn, 7, 5);
}

static void decode_insn32_extract_r2(DisasContext *ctx, arg_decode_insn3213 *a, uint32_t insn)
{
    a->rs1 = extract32(insn, 15, 5);
    a->rd = extract32(insn, 7, 5);
}

static void decode_insn32_extract_r2_rm(DisasContext *ctx, arg_decode_insn3212 *a, uint32_t insn)
{
    a->rs1 = extract32(insn, 15, 5);
    a->rm = extract32(insn, 12, 3);
    a->rd = extract32(insn, 7, 5);
}

static void decode_insn32_extract_r4_rm(DisasContext *ctx, arg_decode_insn3210 *a, uint32_t insn)
{
    a->rs3 = extract32(insn, 27, 5);
    a->rs2 = extract32(insn, 20, 5);
    a->rs1 = extract32(insn, 15, 5);
    a->rm = extract32(insn, 12, 3);
    a->rd = extract32(insn, 7, 5);
}

static void decode_insn32_extract_r_rm(DisasContext *ctx, arg_decode_insn3211 *a, uint32_t insn)
{
    a->rs2 = extract32(insn, 20, 5);
    a->rs1 = extract32(insn, 15, 5);
    a->rm = extract32(insn, 12, 3);
    a->rd = extract32(insn, 7, 5);
}

static void decode_insn32_extract_s(DisasContext *ctx, arg_s *a, uint32_t insn)
{
    a->imm = deposit32(extract32(insn, 7, 5), 5, 27, sextract32(insn, 25, 7));
    a->rs2 = extract32(insn, 20, 5);
    a->rs1 = extract32(insn, 15, 5);
}

static void decode_insn32_extract_sfence_vm(DisasContext *ctx, arg_decode_insn3215 *a, uint32_t insn)
{
    a->rs1 = extract32(insn, 15, 5);
}

static void decode_insn32_extract_sfence_vma(DisasContext *ctx, arg_decode_insn3214 *a, uint32_t insn)
{
    a->rs2 = extract32(insn, 20, 5);
    a->rs1 = extract32(insn, 15, 5);
}

static void decode_insn32_extract_sh(DisasContext *ctx, arg_shift *a, uint32_t insn)
{
    a->shamt = extract32(insn, 20, 10);
    a->rs1 = extract32(insn, 15, 5);
    a->rd = extract32(insn, 7, 5);
}

static void decode_insn32_extract_sh5(DisasContext *ctx, arg_shift *a, uint32_t insn)
{
    a->shamt = extract32(insn, 20, 5);
    a->rs1 = extract32(insn, 15, 5);
    a->rd = extract32(insn, 7, 5);
}

static void decode_insn32_extract_u(DisasContext *ctx, arg_u *a, uint32_t insn)
{
    a->imm = ex_shift_12(ctx, sextract32(insn, 12, 20));
    a->rd = extract32(insn, 7, 5);
}

static bool decode_insn32(DisasContext *ctx, uint32_t insn)
{
    union {
        arg_atomic f_atomic;
        arg_b f_b;
        arg_decode_insn3210 f_decode_insn3210;
        arg_decode_insn3211 f_decode_insn3211;
        arg_decode_insn3212 f_decode_insn3212;
        arg_decode_insn3213 f_decode_insn3213;
        arg_decode_insn3214 f_decode_insn3214;
        arg_decode_insn3215 f_decode_insn3215;
        arg_decode_insn3216 f_decode_insn3216;
        arg_decode_insn329 f_decode_insn329;
        arg_empty f_empty;
        arg_i f_i;
        arg_j f_j;
        arg_r f_r;
        arg_s f_s;
        arg_shift f_shift;
        arg_u f_u;
    } u;

    switch (insn & 0x0000007f) {
    case 0x00000003:
        /* ........ ........ ........ .0000011 */
        decode_insn32_extract_i(ctx, &u.f_i, insn);
        switch ((insn >> 12) & 0x7) {
        case 0x0:
            /* ........ ........ .000.... .0000011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:96 */
            if (trans_lb(ctx, &u.f_i)) return true;
            return false;
        case 0x1:
            /* ........ ........ .001.... .0000011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:97 */
            if (trans_lh(ctx, &u.f_i)) return true;
            return false;
        case 0x2:
            /* ........ ........ .010.... .0000011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:98 */
            if (trans_lw(ctx, &u.f_i)) return true;
            return false;
        case 0x3:
            /* ........ ........ .011.... .0000011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:28 */
            if (trans_ld(ctx, &u.f_i)) return true;
            return false;
        case 0x4:
            /* ........ ........ .100.... .0000011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:99 */
            if (trans_lbu(ctx, &u.f_i)) return true;
            return false;
        case 0x5:
            /* ........ ........ .101.... .0000011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:100 */
            if (trans_lhu(ctx, &u.f_i)) return true;
            return false;
        case 0x6:
            /* ........ ........ .110.... .0000011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:27 */
            if (trans_lwu(ctx, &u.f_i)) return true;
            return false;
        }
        return false;
    case 0x00000007:
        /* ........ ........ ........ .0000111 */
        decode_insn32_extract_i(ctx, &u.f_i, insn);
        switch ((insn >> 12) & 0x7) {
        case 0x2:
            /* ........ ........ .010.... .0000111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:156 */
            if (trans_flw(ctx, &u.f_i)) return true;
            return false;
        case 0x3:
            /* ........ ........ .011.... .0000111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:184 */
            if (trans_fld(ctx, &u.f_i)) return true;
            return false;
        }
        return false;
    case 0x0000000f:
        /* ........ ........ ........ .0001111 */
        switch ((insn >> 12) & 0x7) {
        case 0x0:
            /* ........ ........ .000.... .0001111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:123 */
            decode_insn32_extract_decode_insn32_Fmt_19(ctx, &u.f_decode_insn3216, insn);
            if (trans_fence(ctx, &u.f_decode_insn3216)) return true;
            return false;
        case 0x1:
            /* ........ ........ .001.... .0001111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:124 */
            decode_insn32_extract_decode_insn32_Fmt_18(ctx, &u.f_empty, insn);
            if (trans_fence_i(ctx, &u.f_empty)) return true;
            return false;
        }
        return false;
    case 0x00000013:
        /* ........ ........ ........ .0010011 */
        switch ((insn >> 12) & 0x7) {
        case 0x0:
            /* ........ ........ .000.... .0010011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:104 */
            decode_insn32_extract_i(ctx, &u.f_i, insn);
            if (trans_addi(ctx, &u.f_i)) return true;
            return false;
        case 0x1:
            /* ........ ........ .001.... .0010011 */
            decode_insn32_extract_sh(ctx, &u.f_shift, insn);
            switch ((insn >> 30) & 0x3) {
            case 0x0:
                /* 00...... ........ .001.... .0010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:110 */
                if (trans_slli(ctx, &u.f_shift)) return true;
                return false;
            }
            return false;
        case 0x2:
            /* ........ ........ .010.... .0010011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:105 */
            decode_insn32_extract_i(ctx, &u.f_i, insn);
            if (trans_slti(ctx, &u.f_i)) return true;
            return false;
        case 0x3:
            /* ........ ........ .011.... .0010011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:106 */
            decode_insn32_extract_i(ctx, &u.f_i, insn);
            if (trans_sltiu(ctx, &u.f_i)) return true;
            return false;
        case 0x4:
            /* ........ ........ .100.... .0010011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:107 */
            decode_insn32_extract_i(ctx, &u.f_i, insn);
            if (trans_xori(ctx, &u.f_i)) return true;
            return false;
        case 0x5:
            /* ........ ........ .101.... .0010011 */
            decode_insn32_extract_sh(ctx, &u.f_shift, insn);
            switch ((insn >> 30) & 0x3) {
            case 0x0:
                /* 00...... ........ .101.... .0010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:111 */
                if (trans_srli(ctx, &u.f_shift)) return true;
                return false;
            case 0x1:
                /* 01...... ........ .101.... .0010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:112 */
                if (trans_srai(ctx, &u.f_shift)) return true;
                return false;
            }
            return false;
        case 0x6:
            /* ........ ........ .110.... .0010011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:108 */
            decode_insn32_extract_i(ctx, &u.f_i, insn);
            if (trans_ori(ctx, &u.f_i)) return true;
            return false;
        case 0x7:
            /* ........ ........ .111.... .0010011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:109 */
            decode_insn32_extract_i(ctx, &u.f_i, insn);
            if (trans_andi(ctx, &u.f_i)) return true;
            return false;
        }
        return false;
    case 0x00000017:
        /* ........ ........ ........ .0010111 */
        /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:87 */
        decode_insn32_extract_u(ctx, &u.f_u, insn);
        if (trans_auipc(ctx, &u.f_u)) return true;
        return false;
    case 0x0000001b:
        /* ........ ........ ........ .0011011 */
        switch ((insn >> 12) & 0x7) {
        case 0x0:
            /* ........ ........ .000.... .0011011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:30 */
            decode_insn32_extract_i(ctx, &u.f_i, insn);
            if (trans_addiw(ctx, &u.f_i)) return true;
            return false;
        case 0x1:
            /* ........ ........ .001.... .0011011 */
            decode_insn32_extract_sh5(ctx, &u.f_shift, insn);
            switch ((insn >> 25) & 0x7f) {
            case 0x0:
                /* 0000000. ........ .001.... .0011011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:31 */
                if (trans_slliw(ctx, &u.f_shift)) return true;
                return false;
            }
            return false;
        case 0x5:
            /* ........ ........ .101.... .0011011 */
            decode_insn32_extract_sh5(ctx, &u.f_shift, insn);
            switch ((insn >> 25) & 0x7f) {
            case 0x0:
                /* 0000000. ........ .101.... .0011011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:32 */
                if (trans_srliw(ctx, &u.f_shift)) return true;
                return false;
            case 0x20:
                /* 0100000. ........ .101.... .0011011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:33 */
                if (trans_sraiw(ctx, &u.f_shift)) return true;
                return false;
            }
            return false;
        }
        return false;
    case 0x00000023:
        /* ........ ........ ........ .0100011 */
        decode_insn32_extract_s(ctx, &u.f_s, insn);
        switch ((insn >> 12) & 0x7) {
        case 0x0:
            /* ........ ........ .000.... .0100011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:101 */
            if (trans_sb(ctx, &u.f_s)) return true;
            return false;
        case 0x1:
            /* ........ ........ .001.... .0100011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:102 */
            if (trans_sh(ctx, &u.f_s)) return true;
            return false;
        case 0x2:
            /* ........ ........ .010.... .0100011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:103 */
            if (trans_sw(ctx, &u.f_s)) return true;
            return false;
        case 0x3:
            /* ........ ........ .011.... .0100011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:29 */
            if (trans_sd(ctx, &u.f_s)) return true;
            return false;
        }
        return false;
    case 0x00000027:
        /* ........ ........ ........ .0100111 */
        decode_insn32_extract_s(ctx, &u.f_s, insn);
        switch ((insn >> 12) & 0x7) {
        case 0x2:
            /* ........ ........ .010.... .0100111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:157 */
            if (trans_fsw(ctx, &u.f_s)) return true;
            return false;
        case 0x3:
            /* ........ ........ .011.... .0100111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:185 */
            if (trans_fsd(ctx, &u.f_s)) return true;
            return false;
        }
        return false;
    case 0x0000002f:
        /* ........ ........ ........ .0101111 */
        switch (insn & 0xf8007000) {
        case 0x00002000:
            /* 00000... ........ .010.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:146 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amoadd_w(ctx, &u.f_atomic)) return true;
            return false;
        case 0x00003000:
            /* 00000... ........ .011.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:51 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amoadd_d(ctx, &u.f_atomic)) return true;
            return false;
        case 0x08002000:
            /* 00001... ........ .010.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:145 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amoswap_w(ctx, &u.f_atomic)) return true;
            return false;
        case 0x08003000:
            /* 00001... ........ .011.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:50 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amoswap_d(ctx, &u.f_atomic)) return true;
            return false;
        case 0x10002000:
            /* 00010... ........ .010.... .0101111 */
            decode_insn32_extract_atom_ld(ctx, &u.f_atomic, insn);
            switch ((insn >> 20) & 0x1f) {
            case 0x0:
                /* 00010..0 0000.... .010.... .0101111 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:143 */
                if (trans_lr_w(ctx, &u.f_atomic)) return true;
                return false;
            }
            return false;
        case 0x10003000:
            /* 00010... ........ .011.... .0101111 */
            decode_insn32_extract_atom_ld(ctx, &u.f_atomic, insn);
            switch ((insn >> 20) & 0x1f) {
            case 0x0:
                /* 00010..0 0000.... .011.... .0101111 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:48 */
                if (trans_lr_d(ctx, &u.f_atomic)) return true;
                return false;
            }
            return false;
        case 0x18002000:
            /* 00011... ........ .010.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:144 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_sc_w(ctx, &u.f_atomic)) return true;
            return false;
        case 0x18003000:
            /* 00011... ........ .011.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:49 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_sc_d(ctx, &u.f_atomic)) return true;
            return false;
        case 0x20002000:
            /* 00100... ........ .010.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:147 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amoxor_w(ctx, &u.f_atomic)) return true;
            return false;
        case 0x20003000:
            /* 00100... ........ .011.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:52 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amoxor_d(ctx, &u.f_atomic)) return true;
            return false;
        case 0x40002000:
            /* 01000... ........ .010.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:149 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amoor_w(ctx, &u.f_atomic)) return true;
            return false;
        case 0x40003000:
            /* 01000... ........ .011.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:54 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amoor_d(ctx, &u.f_atomic)) return true;
            return false;
        case 0x60002000:
            /* 01100... ........ .010.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:148 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amoand_w(ctx, &u.f_atomic)) return true;
            return false;
        case 0x60003000:
            /* 01100... ........ .011.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:53 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amoand_d(ctx, &u.f_atomic)) return true;
            return false;
        case 0x80002000:
            /* 10000... ........ .010.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:150 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amomin_w(ctx, &u.f_atomic)) return true;
            return false;
        case 0x80003000:
            /* 10000... ........ .011.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:55 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amomin_d(ctx, &u.f_atomic)) return true;
            return false;
        case 0xa0002000:
            /* 10100... ........ .010.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:151 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amomax_w(ctx, &u.f_atomic)) return true;
            return false;
        case 0xa0003000:
            /* 10100... ........ .011.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:56 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amomax_d(ctx, &u.f_atomic)) return true;
            return false;
        case 0xc0002000:
            /* 11000... ........ .010.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:152 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amominu_w(ctx, &u.f_atomic)) return true;
            return false;
        case 0xc0003000:
            /* 11000... ........ .011.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:57 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amominu_d(ctx, &u.f_atomic)) return true;
            return false;
        case 0xe0002000:
            /* 11100... ........ .010.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:153 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amomaxu_w(ctx, &u.f_atomic)) return true;
            return false;
        case 0xe0003000:
            /* 11100... ........ .011.... .0101111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:58 */
            decode_insn32_extract_atom_st(ctx, &u.f_atomic, insn);
            if (trans_amomaxu_d(ctx, &u.f_atomic)) return true;
            return false;
        }
        return false;
    case 0x00000033:
        /* ........ ........ ........ .0110011 */
        decode_insn32_extract_r(ctx, &u.f_r, insn);
        switch (insn & 0xfe007000) {
        case 0x00000000:
            /* 0000000. ........ .000.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:113 */
            if (trans_add(ctx, &u.f_r)) return true;
            return false;
        case 0x00001000:
            /* 0000000. ........ .001.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:115 */
            if (trans_sll(ctx, &u.f_r)) return true;
            return false;
        case 0x00002000:
            /* 0000000. ........ .010.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:116 */
            if (trans_slt(ctx, &u.f_r)) return true;
            return false;
        case 0x00003000:
            /* 0000000. ........ .011.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:117 */
            if (trans_sltu(ctx, &u.f_r)) return true;
            return false;
        case 0x00004000:
            /* 0000000. ........ .100.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:118 */
            if (trans_xor(ctx, &u.f_r)) return true;
            return false;
        case 0x00005000:
            /* 0000000. ........ .101.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:119 */
            if (trans_srl(ctx, &u.f_r)) return true;
            return false;
        case 0x00006000:
            /* 0000000. ........ .110.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:121 */
            if (trans_or(ctx, &u.f_r)) return true;
            return false;
        case 0x00007000:
            /* 0000000. ........ .111.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:122 */
            if (trans_and(ctx, &u.f_r)) return true;
            return false;
        case 0x02000000:
            /* 0000001. ........ .000.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:133 */
            if (trans_mul(ctx, &u.f_r)) return true;
            return false;
        case 0x02001000:
            /* 0000001. ........ .001.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:134 */
            if (trans_mulh(ctx, &u.f_r)) return true;
            return false;
        case 0x02002000:
            /* 0000001. ........ .010.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:135 */
            if (trans_mulhsu(ctx, &u.f_r)) return true;
            return false;
        case 0x02003000:
            /* 0000001. ........ .011.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:136 */
            if (trans_mulhu(ctx, &u.f_r)) return true;
            return false;
        case 0x02004000:
            /* 0000001. ........ .100.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:137 */
            if (trans_div(ctx, &u.f_r)) return true;
            return false;
        case 0x02005000:
            /* 0000001. ........ .101.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:138 */
            if (trans_divu(ctx, &u.f_r)) return true;
            return false;
        case 0x02006000:
            /* 0000001. ........ .110.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:139 */
            if (trans_rem(ctx, &u.f_r)) return true;
            return false;
        case 0x02007000:
            /* 0000001. ........ .111.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:140 */
            if (trans_remu(ctx, &u.f_r)) return true;
            return false;
        case 0x40000000:
            /* 0100000. ........ .000.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:114 */
            if (trans_sub(ctx, &u.f_r)) return true;
            return false;
        case 0x40005000:
            /* 0100000. ........ .101.... .0110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:120 */
            if (trans_sra(ctx, &u.f_r)) return true;
            return false;
        }
        return false;
    case 0x00000037:
        /* ........ ........ ........ .0110111 */
        /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:86 */
        decode_insn32_extract_u(ctx, &u.f_u, insn);
        if (trans_lui(ctx, &u.f_u)) return true;
        return false;
    case 0x0000003b:
        /* ........ ........ ........ .0111011 */
        decode_insn32_extract_r(ctx, &u.f_r, insn);
        switch (insn & 0xfe007000) {
        case 0x00000000:
            /* 0000000. ........ .000.... .0111011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:34 */
            if (trans_addw(ctx, &u.f_r)) return true;
            return false;
        case 0x00001000:
            /* 0000000. ........ .001.... .0111011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:36 */
            if (trans_sllw(ctx, &u.f_r)) return true;
            return false;
        case 0x00005000:
            /* 0000000. ........ .101.... .0111011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:37 */
            if (trans_srlw(ctx, &u.f_r)) return true;
            return false;
        case 0x02000000:
            /* 0000001. ........ .000.... .0111011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:41 */
            if (trans_mulw(ctx, &u.f_r)) return true;
            return false;
        case 0x02004000:
            /* 0000001. ........ .100.... .0111011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:42 */
            if (trans_divw(ctx, &u.f_r)) return true;
            return false;
        case 0x02005000:
            /* 0000001. ........ .101.... .0111011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:43 */
            if (trans_divuw(ctx, &u.f_r)) return true;
            return false;
        case 0x02006000:
            /* 0000001. ........ .110.... .0111011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:44 */
            if (trans_remw(ctx, &u.f_r)) return true;
            return false;
        case 0x02007000:
            /* 0000001. ........ .111.... .0111011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:45 */
            if (trans_remuw(ctx, &u.f_r)) return true;
            return false;
        case 0x40000000:
            /* 0100000. ........ .000.... .0111011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:35 */
            if (trans_subw(ctx, &u.f_r)) return true;
            return false;
        case 0x40005000:
            /* 0100000. ........ .101.... .0111011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:38 */
            if (trans_sraw(ctx, &u.f_r)) return true;
            return false;
        }
        return false;
    case 0x00000043:
        /* ........ ........ ........ .1000011 */
        decode_insn32_extract_r4_rm(ctx, &u.f_decode_insn3210, insn);
        switch ((insn >> 25) & 0x3) {
        case 0x0:
            /* .....00. ........ ........ .1000011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:158 */
            if (trans_fmadd_s(ctx, &u.f_decode_insn3210)) return true;
            return false;
        case 0x1:
            /* .....01. ........ ........ .1000011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:186 */
            if (trans_fmadd_d(ctx, &u.f_decode_insn3210)) return true;
            return false;
        }
        return false;
    case 0x00000047:
        /* ........ ........ ........ .1000111 */
        decode_insn32_extract_r4_rm(ctx, &u.f_decode_insn3210, insn);
        switch ((insn >> 25) & 0x3) {
        case 0x0:
            /* .....00. ........ ........ .1000111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:159 */
            if (trans_fmsub_s(ctx, &u.f_decode_insn3210)) return true;
            return false;
        case 0x1:
            /* .....01. ........ ........ .1000111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:187 */
            if (trans_fmsub_d(ctx, &u.f_decode_insn3210)) return true;
            return false;
        }
        return false;
    case 0x0000004b:
        /* ........ ........ ........ .1001011 */
        decode_insn32_extract_r4_rm(ctx, &u.f_decode_insn3210, insn);
        switch ((insn >> 25) & 0x3) {
        case 0x0:
            /* .....00. ........ ........ .1001011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:160 */
            if (trans_fnmsub_s(ctx, &u.f_decode_insn3210)) return true;
            return false;
        case 0x1:
            /* .....01. ........ ........ .1001011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:188 */
            if (trans_fnmsub_d(ctx, &u.f_decode_insn3210)) return true;
            return false;
        }
        return false;
    case 0x0000004f:
        /* ........ ........ ........ .1001111 */
        decode_insn32_extract_r4_rm(ctx, &u.f_decode_insn3210, insn);
        switch ((insn >> 25) & 0x3) {
        case 0x0:
            /* .....00. ........ ........ .1001111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:161 */
            if (trans_fnmadd_s(ctx, &u.f_decode_insn3210)) return true;
            return false;
        case 0x1:
            /* .....01. ........ ........ .1001111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:189 */
            if (trans_fnmadd_d(ctx, &u.f_decode_insn3210)) return true;
            return false;
        }
        return false;
    case 0x00000053:
        /* ........ ........ ........ .1010011 */
        switch ((insn >> 25) & 0x7f) {
        case 0x0:
            /* 0000000. ........ ........ .1010011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:162 */
            decode_insn32_extract_r_rm(ctx, &u.f_decode_insn3211, insn);
            if (trans_fadd_s(ctx, &u.f_decode_insn3211)) return true;
            return false;
        case 0x1:
            /* 0000001. ........ ........ .1010011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:190 */
            decode_insn32_extract_r_rm(ctx, &u.f_decode_insn3211, insn);
            if (trans_fadd_d(ctx, &u.f_decode_insn3211)) return true;
            return false;
        case 0x4:
            /* 0000100. ........ ........ .1010011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:163 */
            decode_insn32_extract_r_rm(ctx, &u.f_decode_insn3211, insn);
            if (trans_fsub_s(ctx, &u.f_decode_insn3211)) return true;
            return false;
        case 0x5:
            /* 0000101. ........ ........ .1010011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:191 */
            decode_insn32_extract_r_rm(ctx, &u.f_decode_insn3211, insn);
            if (trans_fsub_d(ctx, &u.f_decode_insn3211)) return true;
            return false;
        case 0x8:
            /* 0001000. ........ ........ .1010011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:164 */
            decode_insn32_extract_r_rm(ctx, &u.f_decode_insn3211, insn);
            if (trans_fmul_s(ctx, &u.f_decode_insn3211)) return true;
            return false;
        case 0x9:
            /* 0001001. ........ ........ .1010011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:192 */
            decode_insn32_extract_r_rm(ctx, &u.f_decode_insn3211, insn);
            if (trans_fmul_d(ctx, &u.f_decode_insn3211)) return true;
            return false;
        case 0xc:
            /* 0001100. ........ ........ .1010011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:165 */
            decode_insn32_extract_r_rm(ctx, &u.f_decode_insn3211, insn);
            if (trans_fdiv_s(ctx, &u.f_decode_insn3211)) return true;
            return false;
        case 0xd:
            /* 0001101. ........ ........ .1010011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:193 */
            decode_insn32_extract_r_rm(ctx, &u.f_decode_insn3211, insn);
            if (trans_fdiv_d(ctx, &u.f_decode_insn3211)) return true;
            return false;
        case 0x10:
            /* 0010000. ........ ........ .1010011 */
            decode_insn32_extract_r(ctx, &u.f_r, insn);
            switch ((insn >> 12) & 0x7) {
            case 0x0:
                /* 0010000. ........ .000.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:167 */
                if (trans_fsgnj_s(ctx, &u.f_r)) return true;
                return false;
            case 0x1:
                /* 0010000. ........ .001.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:168 */
                if (trans_fsgnjn_s(ctx, &u.f_r)) return true;
                return false;
            case 0x2:
                /* 0010000. ........ .010.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:169 */
                if (trans_fsgnjx_s(ctx, &u.f_r)) return true;
                return false;
            }
            return false;
        case 0x11:
            /* 0010001. ........ ........ .1010011 */
            decode_insn32_extract_r(ctx, &u.f_r, insn);
            switch ((insn >> 12) & 0x7) {
            case 0x0:
                /* 0010001. ........ .000.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:195 */
                if (trans_fsgnj_d(ctx, &u.f_r)) return true;
                return false;
            case 0x1:
                /* 0010001. ........ .001.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:196 */
                if (trans_fsgnjn_d(ctx, &u.f_r)) return true;
                return false;
            case 0x2:
                /* 0010001. ........ .010.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:197 */
                if (trans_fsgnjx_d(ctx, &u.f_r)) return true;
                return false;
            }
            return false;
        case 0x14:
            /* 0010100. ........ ........ .1010011 */
            decode_insn32_extract_r(ctx, &u.f_r, insn);
            switch ((insn >> 12) & 0x7) {
            case 0x0:
                /* 0010100. ........ .000.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:170 */
                if (trans_fmin_s(ctx, &u.f_r)) return true;
                return false;
            case 0x1:
                /* 0010100. ........ .001.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:171 */
                if (trans_fmax_s(ctx, &u.f_r)) return true;
                return false;
            }
            return false;
        case 0x15:
            /* 0010101. ........ ........ .1010011 */
            decode_insn32_extract_r(ctx, &u.f_r, insn);
            switch ((insn >> 12) & 0x7) {
            case 0x0:
                /* 0010101. ........ .000.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:198 */
                if (trans_fmin_d(ctx, &u.f_r)) return true;
                return false;
            case 0x1:
                /* 0010101. ........ .001.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:199 */
                if (trans_fmax_d(ctx, &u.f_r)) return true;
                return false;
            }
            return false;
        case 0x20:
            /* 0100000. ........ ........ .1010011 */
            decode_insn32_extract_r2_rm(ctx, &u.f_decode_insn3212, insn);
            switch ((insn >> 20) & 0x1f) {
            case 0x1:
                /* 01000000 0001.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:200 */
                if (trans_fcvt_s_d(ctx, &u.f_decode_insn3212)) return true;
                return false;
            }
            return false;
        case 0x21:
            /* 0100001. ........ ........ .1010011 */
            decode_insn32_extract_r2_rm(ctx, &u.f_decode_insn3212, insn);
            switch ((insn >> 20) & 0x1f) {
            case 0x0:
                /* 01000010 0000.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:201 */
                if (trans_fcvt_d_s(ctx, &u.f_decode_insn3212)) return true;
                return false;
            }
            return false;
        case 0x2c:
            /* 0101100. ........ ........ .1010011 */
            decode_insn32_extract_r2_rm(ctx, &u.f_decode_insn3212, insn);
            switch ((insn >> 20) & 0x1f) {
            case 0x0:
                /* 01011000 0000.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:166 */
                if (trans_fsqrt_s(ctx, &u.f_decode_insn3212)) return true;
                return false;
            }
            return false;
        case 0x2d:
            /* 0101101. ........ ........ .1010011 */
            decode_insn32_extract_r2_rm(ctx, &u.f_decode_insn3212, insn);
            switch ((insn >> 20) & 0x1f) {
            case 0x0:
                /* 01011010 0000.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:194 */
                if (trans_fsqrt_d(ctx, &u.f_decode_insn3212)) return true;
                return false;
            }
            return false;
        case 0x50:
            /* 1010000. ........ ........ .1010011 */
            decode_insn32_extract_r(ctx, &u.f_r, insn);
            switch ((insn >> 12) & 0x7) {
            case 0x0:
                /* 1010000. ........ .000.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:177 */
                if (trans_fle_s(ctx, &u.f_r)) return true;
                return false;
            case 0x1:
                /* 1010000. ........ .001.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:176 */
                if (trans_flt_s(ctx, &u.f_r)) return true;
                return false;
            case 0x2:
                /* 1010000. ........ .010.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:175 */
                if (trans_feq_s(ctx, &u.f_r)) return true;
                return false;
            }
            return false;
        case 0x51:
            /* 1010001. ........ ........ .1010011 */
            decode_insn32_extract_r(ctx, &u.f_r, insn);
            switch ((insn >> 12) & 0x7) {
            case 0x0:
                /* 1010001. ........ .000.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:204 */
                if (trans_fle_d(ctx, &u.f_r)) return true;
                return false;
            case 0x1:
                /* 1010001. ........ .001.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:203 */
                if (trans_flt_d(ctx, &u.f_r)) return true;
                return false;
            case 0x2:
                /* 1010001. ........ .010.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:202 */
                if (trans_feq_d(ctx, &u.f_r)) return true;
                return false;
            }
            return false;
        case 0x60:
            /* 1100000. ........ ........ .1010011 */
            decode_insn32_extract_r2_rm(ctx, &u.f_decode_insn3212, insn);
            switch ((insn >> 20) & 0x1f) {
            case 0x0:
                /* 11000000 0000.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:172 */
                if (trans_fcvt_w_s(ctx, &u.f_decode_insn3212)) return true;
                return false;
            case 0x1:
                /* 11000000 0001.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:173 */
                if (trans_fcvt_wu_s(ctx, &u.f_decode_insn3212)) return true;
                return false;
            case 0x2:
                /* 11000000 0010.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:61 */
                if (trans_fcvt_l_s(ctx, &u.f_decode_insn3212)) return true;
                return false;
            case 0x3:
                /* 11000000 0011.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:62 */
                if (trans_fcvt_lu_s(ctx, &u.f_decode_insn3212)) return true;
                return false;
            }
            return false;
        case 0x61:
            /* 1100001. ........ ........ .1010011 */
            decode_insn32_extract_r2_rm(ctx, &u.f_decode_insn3212, insn);
            switch ((insn >> 20) & 0x1f) {
            case 0x0:
                /* 11000010 0000.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:206 */
                if (trans_fcvt_w_d(ctx, &u.f_decode_insn3212)) return true;
                return false;
            case 0x1:
                /* 11000010 0001.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:207 */
                if (trans_fcvt_wu_d(ctx, &u.f_decode_insn3212)) return true;
                return false;
            case 0x2:
                /* 11000010 0010.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:67 */
                if (trans_fcvt_l_d(ctx, &u.f_decode_insn3212)) return true;
                return false;
            case 0x3:
                /* 11000010 0011.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:68 */
                if (trans_fcvt_lu_d(ctx, &u.f_decode_insn3212)) return true;
                return false;
            }
            return false;
        case 0x68:
            /* 1101000. ........ ........ .1010011 */
            decode_insn32_extract_r2_rm(ctx, &u.f_decode_insn3212, insn);
            switch ((insn >> 20) & 0x1f) {
            case 0x0:
                /* 11010000 0000.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:179 */
                if (trans_fcvt_s_w(ctx, &u.f_decode_insn3212)) return true;
                return false;
            case 0x1:
                /* 11010000 0001.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:180 */
                if (trans_fcvt_s_wu(ctx, &u.f_decode_insn3212)) return true;
                return false;
            case 0x2:
                /* 11010000 0010.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:63 */
                if (trans_fcvt_s_l(ctx, &u.f_decode_insn3212)) return true;
                return false;
            case 0x3:
                /* 11010000 0011.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:64 */
                if (trans_fcvt_s_lu(ctx, &u.f_decode_insn3212)) return true;
                return false;
            }
            return false;
        case 0x69:
            /* 1101001. ........ ........ .1010011 */
            decode_insn32_extract_r2_rm(ctx, &u.f_decode_insn3212, insn);
            switch ((insn >> 20) & 0x1f) {
            case 0x0:
                /* 11010010 0000.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:208 */
                if (trans_fcvt_d_w(ctx, &u.f_decode_insn3212)) return true;
                return false;
            case 0x1:
                /* 11010010 0001.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:209 */
                if (trans_fcvt_d_wu(ctx, &u.f_decode_insn3212)) return true;
                return false;
            case 0x2:
                /* 11010010 0010.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:70 */
                if (trans_fcvt_d_l(ctx, &u.f_decode_insn3212)) return true;
                return false;
            case 0x3:
                /* 11010010 0011.... ........ .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:71 */
                if (trans_fcvt_d_lu(ctx, &u.f_decode_insn3212)) return true;
                return false;
            }
            return false;
        case 0x70:
            /* 1110000. ........ ........ .1010011 */
            decode_insn32_extract_r2(ctx, &u.f_decode_insn3213, insn);
            switch (insn & 0x01f07000) {
            case 0x00000000:
                /* 11100000 0000.... .000.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:174 */
                if (trans_fmv_x_w(ctx, &u.f_decode_insn3213)) return true;
                return false;
            case 0x00001000:
                /* 11100000 0000.... .001.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:178 */
                if (trans_fclass_s(ctx, &u.f_decode_insn3213)) return true;
                return false;
            }
            return false;
        case 0x71:
            /* 1110001. ........ ........ .1010011 */
            decode_insn32_extract_r2(ctx, &u.f_decode_insn3213, insn);
            switch (insn & 0x01f07000) {
            case 0x00000000:
                /* 11100010 0000.... .000.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:69 */
                if (trans_fmv_x_d(ctx, &u.f_decode_insn3213)) return true;
                return false;
            case 0x00001000:
                /* 11100010 0000.... .001.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:205 */
                if (trans_fclass_d(ctx, &u.f_decode_insn3213)) return true;
                return false;
            }
            return false;
        case 0x78:
            /* 1111000. ........ ........ .1010011 */
            decode_insn32_extract_r2(ctx, &u.f_decode_insn3213, insn);
            switch (insn & 0x01f07000) {
            case 0x00000000:
                /* 11110000 0000.... .000.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:181 */
                if (trans_fmv_w_x(ctx, &u.f_decode_insn3213)) return true;
                return false;
            }
            return false;
        case 0x79:
            /* 1111001. ........ ........ .1010011 */
            decode_insn32_extract_r2(ctx, &u.f_decode_insn3213, insn);
            switch (insn & 0x01f07000) {
            case 0x00000000:
                /* 11110010 0000.... .000.... .1010011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32-64.decode:72 */
                if (trans_fmv_d_x(ctx, &u.f_decode_insn3213)) return true;
                return false;
            }
            return false;
        }
        return false;
    case 0x00000063:
        /* ........ ........ ........ .1100011 */
        decode_insn32_extract_b(ctx, &u.f_b, insn);
        switch ((insn >> 12) & 0x7) {
        case 0x0:
            /* ........ ........ .000.... .1100011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:90 */
            if (trans_beq(ctx, &u.f_b)) return true;
            return false;
        case 0x1:
            /* ........ ........ .001.... .1100011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:91 */
            if (trans_bne(ctx, &u.f_b)) return true;
            return false;
        case 0x4:
            /* ........ ........ .100.... .1100011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:92 */
            if (trans_blt(ctx, &u.f_b)) return true;
            return false;
        case 0x5:
            /* ........ ........ .101.... .1100011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:93 */
            if (trans_bge(ctx, &u.f_b)) return true;
            return false;
        case 0x6:
            /* ........ ........ .110.... .1100011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:94 */
            if (trans_bltu(ctx, &u.f_b)) return true;
            return false;
        case 0x7:
            /* ........ ........ .111.... .1100011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:95 */
            if (trans_bgeu(ctx, &u.f_b)) return true;
            return false;
        }
        return false;
    case 0x00000067:
        /* ........ ........ ........ .1100111 */
        decode_insn32_extract_i(ctx, &u.f_i, insn);
        switch ((insn >> 12) & 0x7) {
        case 0x0:
            /* ........ ........ .000.... .1100111 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:89 */
            if (trans_jalr(ctx, &u.f_i)) return true;
            return false;
        }
        return false;
    case 0x0000006f:
        /* ........ ........ ........ .1101111 */
        /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:88 */
        decode_insn32_extract_j(ctx, &u.f_j, insn);
        if (trans_jal(ctx, &u.f_j)) return true;
        return false;
    case 0x00000073:
        /* ........ ........ ........ .1110011 */
        switch ((insn >> 12) & 0x7) {
        case 0x0:
            /* ........ ........ .000.... .1110011 */
            switch (insn & 0xfe000f80) {
            case 0x00000000:
                /* 0000000. ........ .0000000 01110011 */
                decode_insn32_extract_decode_insn32_Fmt_18(ctx, &u.f_empty, insn);
                switch ((insn >> 15) & 0x3ff) {
                case 0x0:
                    /* 00000000 00000000 00000000 01110011 */
                    /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:74 */
                    if (trans_ecall(ctx, &u.f_empty)) return true;
                    return false;
                case 0x20:
                    /* 00000000 00010000 00000000 01110011 */
                    /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:75 */
                    if (trans_ebreak(ctx, &u.f_empty)) return true;
                    return false;
                case 0x40:
                    /* 00000000 00100000 00000000 01110011 */
                    /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:76 */
                    if (trans_uret(ctx, &u.f_empty)) return true;
                    return false;
                }
                return false;
            case 0x10000000:
                /* 0001000. ........ .0000000 01110011 */
                switch ((insn >> 20) & 0x1f) {
                case 0x2:
                    /* 00010000 0010.... .0000000 01110011 */
                    decode_insn32_extract_decode_insn32_Fmt_18(ctx, &u.f_empty, insn);
                    switch ((insn >> 15) & 0x1f) {
                    case 0x0:
                        /* 00010000 00100000 00000000 01110011 */
                        /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:77 */
                        if (trans_sret(ctx, &u.f_empty)) return true;
                        return false;
                    }
                    return false;
                case 0x4:
                    /* 00010000 0100.... .0000000 01110011 */
                    /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:83 */
                    decode_insn32_extract_sfence_vm(ctx, &u.f_decode_insn3215, insn);
                    if (trans_sfence_vm(ctx, &u.f_decode_insn3215)) return true;
                    return false;
                case 0x5:
                    /* 00010000 0101.... .0000000 01110011 */
                    decode_insn32_extract_decode_insn32_Fmt_18(ctx, &u.f_empty, insn);
                    switch ((insn >> 15) & 0x1f) {
                    case 0x0:
                        /* 00010000 01010000 00000000 01110011 */
                        /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:79 */
                        if (trans_wfi(ctx, &u.f_empty)) return true;
                        return false;
                    }
                    return false;
                }
                return false;
            case 0x12000000:
                /* 0001001. ........ .0000000 01110011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:82 */
                decode_insn32_extract_sfence_vma(ctx, &u.f_decode_insn3214, insn);
                if (trans_sfence_vma(ctx, &u.f_decode_insn3214)) return true;
                return false;
            case 0x22000000:
                /* 0010001. ........ .0000000 01110011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:81 */
                decode_insn32_extract_hfence_bvma(ctx, &u.f_decode_insn3214, insn);
                if (trans_hfence_bvma(ctx, &u.f_decode_insn3214)) return true;
                return false;
            case 0x30000000:
                /* 0011000. ........ .0000000 01110011 */
                decode_insn32_extract_decode_insn32_Fmt_18(ctx, &u.f_empty, insn);
                switch ((insn >> 15) & 0x3ff) {
                case 0x40:
                    /* 00110000 00100000 00000000 01110011 */
                    /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:78 */
                    if (trans_mret(ctx, &u.f_empty)) return true;
                    return false;
                }
                return false;
            case 0x62000000:
                /* 0110001. ........ .0000000 01110011 */
                /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:80 */
                decode_insn32_extract_hfence_gvma(ctx, &u.f_decode_insn3214, insn);
                if (trans_hfence_gvma(ctx, &u.f_decode_insn3214)) return true;
                return false;
            }
            return false;
        case 0x1:
            /* ........ ........ .001.... .1110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:125 */
            decode_insn32_extract_csr(ctx, &u.f_decode_insn329, insn);
            if (trans_csrrw(ctx, &u.f_decode_insn329)) return true;
            return false;
        case 0x2:
            /* ........ ........ .010.... .1110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:126 */
            decode_insn32_extract_csr(ctx, &u.f_decode_insn329, insn);
            if (trans_csrrs(ctx, &u.f_decode_insn329)) return true;
            return false;
        case 0x3:
            /* ........ ........ .011.... .1110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:127 */
            decode_insn32_extract_csr(ctx, &u.f_decode_insn329, insn);
            if (trans_csrrc(ctx, &u.f_decode_insn329)) return true;
            return false;
        case 0x5:
            /* ........ ........ .101.... .1110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:128 */
            decode_insn32_extract_csr(ctx, &u.f_decode_insn329, insn);
            if (trans_csrrwi(ctx, &u.f_decode_insn329)) return true;
            return false;
        case 0x6:
            /* ........ ........ .110.... .1110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:129 */
            decode_insn32_extract_csr(ctx, &u.f_decode_insn329, insn);
            if (trans_csrrsi(ctx, &u.f_decode_insn329)) return true;
            return false;
        case 0x7:
            /* ........ ........ .111.... .1110011 */
            /* /home/me/projects/unicorn2/qemu-5.0.0-build/target/riscv/insn32.decode:130 */
            decode_insn32_extract_csr(ctx, &u.f_decode_insn329, insn);
            if (trans_csrrci(ctx, &u.f_decode_insn329)) return true;
            return false;
        }
        return false;
    }
    return false;
}
